/** @type {import('tailwindcss').Config} */
const defaultTheme = require('tailwindcss/defaultTheme')
const withMT = require("@material-tailwind/react/utils/withMT");

export default withMT({
  content: [
    "./index.html",
    "./src/**/*.{js,ts,jsx,tsx}",
  ],
  corePlugins: {
    container: false,
  },
  theme: {
    extend: {
      fontFamily: {
        'sans': ['"DM Sans"', ...defaultTheme.fontFamily.sans],
        'serif': ['"Baskerville Win95BT"', ...defaultTheme.fontFamily.serif]
      },
      screens: { '3xl': '1441px' },
      colors: {
        "green": "#A1B0AD",
        "gray": "#DBDAD7",
        "darkGreen": "#394544",
        "skin": "#dcd1c6",
        // "black": "#414041",
        "brown": "#5f482e",
        "lightBrown": "#8c7e73"
      },
    },
	listStyleType: { 
		  none: 'none',
		  disc: 'disc',
		  decimal: 'decimal',
		  square: 'square',
		  roman: 'upper-roman',
	  },
  },
  plugins: [],
})

