import React, { useEffect, useRef, useState } from "react";
import { Link } from "react-router-dom";
import Slider, { slickGoTo } from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import TeamAnchor from "../../assets/img/team/team-anchor.jpg";
import AzoraColor from "../../assets/img/team/azora-logo-color.svg";
import Slide1 from "../../assets/img/team/team-project-shannon18_1.jpg";
import Slide2 from "../../assets/img/team/team-project-brockhouse_2.jpg";
import Slide3 from "../../assets/img/team/team-project-aviida.jpg";
import Slide4 from "../../assets/img/team/team-project-french_3.jpg";
import Slide5 from "../../assets/img/team/team-project-ariia_5.jpg";
import Slide6 from "../../assets/img/team/team-project-columbia_6.jpg";

const Team = () => {
  const [slideIndex, setSlideIndex] = useState(0);
  let sliderRef1 = useRef(null);
  const settings = {
    dots: false,
    infinite: true,
	arrow: false,
	autoplay: true,
    speed: 800,
    slidesToShow: 3,
    slidesToScroll: 1,
	centerPadding: "50px",
    beforeChange: (current, next) => setSlideIndex(next),
	responsive: [
      {
        breakpoint: 800,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 500,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  };
	useEffect(() => {
		document.title = 'Team | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
	}, []);
  return (
    <div className="relative w-full">
		<MainSiteHeader designSrc={TeamAnchor}/>	
		<div className="px-[25px] lg:px-[10vw] w-full relative">
			<div className="flex justify-center py-[50px]" data-aos="fade-up" data-aos-delay="0">
				<Link to="https://www.azoragroup.ca" target="_blank"><img className="w-[50vw] sm:w-[40vw] md:w-[30vw] lg:w-full" src={AzoraColor}></img>
				<p className="text-center pt-[25px]">www.AzoraGroup.ca</p></Link>
			</div>
			<div className="w-full lg:w-[50vw] my-0 mx-auto pb-[50px]" data-aos="fade-up" data-aos-delay="500">
				<p>At Azora Group, an uncompromising commitment to our customers and an unwavering focus on safe and timely delivery define our approach. And above all else, we are dedicated to crafting functional, sustainable and truly beautiful homes where our clients and their families can build lasting memories.</p>
				
				<p>With a range of experience spanning from multi-family townhomes to custom single-family residences, our diverse portfolio is a true reflection of our team’s vast experience, attention to detail and design prowess.</p>
				
				
			</div>
			<div className="w-full pb-[100px]">
				<Slider
					ref={slider => {
					  sliderRef1 = slider;
					}}
					{...settings}
				  >
					<div>
						<div className="mx-[5px]">
							<img src={Slide1}></img>
							<div className="pt-[25px]">Vancouver</div>
							<h3>Shannon 18</h3>
						</div>
					</div>
					<div>
						<div className="mx-[5px]">
							<img src={Slide2}></img>
							<div className="pt-[25px]">Vancouver</div><h3>Brock House</h3>
						</div>	
					</div>
					<div>
						<div className="mx-[5px]">
							<img src={Slide3}></img>
							<div className="pt-[25px]">Vancouver</div><h3>Aviida</h3>
						</div>
					</div>
					<div>
						<div className="mx-[5px]">
							<img src={Slide4}></img>
							<div className="pt-[25px]">Vancouver</div><h3>French</h3>
						</div>
					</div>
					<div>
						<div className="mx-[5px]">
							<img src={Slide5}></img>
							<div className="pt-[25px]">Vancouver</div><h3>Ariia</h3>
						</div>
					</div>
					<div>
						<div className="mx-[5px]">
							<img src={Slide6}></img>
							<div className="pt-[25px]">Vancouver</div><h3>Columbia</h3>
						</div>
					</div>
				</Slider>
			</div>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Team;