import React, { useEffect, useRef, useState } from "react";
import { fields } from "./fields";
import CheckMark from "./CheckMark";
import { Button, Checkbox, Radio, Typography, Select, Option } from "@material-tailwind/react";
import { useNavigate, Link } from "react-router-dom";
import openingVideo from "../../assets/img/video/W58-openning-V2.mp4";
import exterior from "../../assets/img/register/exterior.jpg";
import interior from "../../assets/img/register/interior.jpg";
import wLogo from "../../assets/img/logo/W58-logo-white.svg";
import Logo from "../../assets/img/logo/W58-logo.svg";
import WaterMark from "../../assets/img/logo/58watermark.svg";
import Azora from "../../assets/img/logo/azora-logo.svg";
import AzoraHZ from "../../assets/img/logo/azora_logo_horizontal.svg";

const { text, method, source, homeTypes, realtor, withRealtor } = fields;

const RegisterMain = () => {
  const [submitting, setSubmitting] = useState(false);
  const [videoEnd, setVideoEnd] = useState(0);
  const bgVideoRef = useRef();
  const formRef = useRef();
  const triggerStartRef = useRef();
  const mobileTriggerStartRef = useRef();
  const triggerEndRef = useRef();
  const movingLogo = useRef();
  const mobileMovingLogo = useRef();
  const registerFormRef = useRef();
  const mainDIVRef = useRef();
  const HeaderBarRef = useRef();
  const FooterBarRef = useRef();
  const navigate = useNavigate();
  const scrollCallback = () => {
	   mainDIVRef.current.scrollIntoView({ behavior: 'smooth' });
	}
  const videoEndScroll = () => {
	   	if (window.pageYOffset > window.innerHeight) {
		   scrollCallback;
		}
	}
  const [stickyLogo, setStickyLogo] = React.useState(0);
  const handleScroll = () => {
		const newScrollYPosition = window.pageYOffset;
	    var triggerPos = triggerStartRef.current.offsetTop + HeaderBarRef.current.offsetHeight;
	    var scrollBottomPos = window.pageYOffset + window.innerHeight;	    
	    var availableScroll = triggerStartRef.current.offsetHeight - triggerEndRef.current.offsetHeight - HeaderBarRef.current.offsetHeight;
		var amountScrolled = window.pageYOffset + window.innerHeight - triggerStartRef.current.offsetTop;
	    var headerBarPadding = (HeaderBarRef.current.offsetHeight - movingLogo.current.offsetHeight) / 2;	
	  
	    //bgVideoRef.current.height = window.innerHeight + "px";
	    if (document.body.clientWidth >= 960) {
			if (scrollBottomPos > triggerPos) {
				setStickyLogo(1);
				if ((scrollBottomPos - document.body.offsetHeight + 50) >= 0) {
					setStickyLogo(2);
					movingLogo.current.style.top = (triggerStartRef.current.offsetHeight - triggerEndRef.current.offsetHeight + 25 + ((FooterBarRef.current.offsetHeight - movingLogo.current.offsetHeight)/2)) + "px";
				}
				else {
					movingLogo.current.style.top = ((amountScrolled - HeaderBarRef.current.offsetHeight) * 0.75 + headerBarPadding) + "px";
				}
			}
			else if (scrollBottomPos <= (triggerPos)) {
				setStickyLogo(0);
				movingLogo.current.style.top = 0 + "px";
			}
		}
	};
	useEffect(() => {
		window.addEventListener('scroll', handleScroll);
		window.addEventListener('resize', handleScroll);
		document.title = 'Register | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
		setTimeout(() => { registerFormRef.current.scrollIntoView({ behavior: 'smooth' })}, 500);
		
		return () => {
			window.removeEventListener('scroll', handleScroll);
			window.removeEventListener('resize', handleScroll);
		};
	}, []);
  
  return (
    <div className="relative w-full">
		<div className="relative w-full h-[100vh] hidden lg:block">
			<video id="videoBG" className="max-w-[100vw] w-full h-[100vh] object-cover" autoPlay muted ref={bgVideoRef} 
				onEnded={scrollCallback}>
				<source src={openingVideo} type="video/mp4"></source>
			</video>
			<div className="absolute w-[50px] bottom-[75px] left-[50%] translate-x-[-50%] cursor-pointer" onClick={scrollCallback} data-aos="fade-down" data-aos-delay="1000">
				<svg 
					  xmlns="http://www.w3.org/2000/svg"
					  xmlSpace="preserve"
					  x="0px" 
					  y="0px"
					  /*viewBox="0 0 253.8 30.2" */
					  viewBox="0 0 35 43.3"
					  style={{
					  shapeRendering: "geometricPrecision",
					  textRendering: "geometricPrecision",
					  imageRendering: "optimizeQuality",
					  fillRule: "evenodd",
					  clipRule: "evenodd",
					  width: "50px",
					}} 
				  >
					<defs>
					  <style>
						{".st0{fill:#FFFFFF;}"}
					  </style>
					</defs>
					<polygon className="arrowanimation delay1" points="35,3.6 30.5,0 17.5,10.3 4.5,0 0,3.6 17.5,17.4"/>
					<polygon className="arrowanimation delay2" points="35,16.5 30.5,13 17.5,23.3 4.5,13 0,16.5 17.5,30.4"/>
					<polygon className="arrowanimation delay3" points="35,29.5 30.5,25.9 17.5,36.2 4.5,25.9 0,29.5 17.5,43.3"/>
				  </svg>
			</div>
		</div>
		<div className="relative w-full exterior-img-fill" id="exterior" ref={mainDIVRef}
			style={{ 
			  backgroundImage: `url(${exterior})`,
			  backgroundPosition: 'center',
			  backgroundSize: 'cover',
			  backgroundRepeat: 'no-repeat'
			}}>
				<img src={exterior} className="w-full lg:hidden"></img>
			</div>
		<div className="relative" ref={triggerStartRef}>
			<div className="relative w-full flex flex-row h-[19vw] lg:h-[12vw]" ref={HeaderBarRef}>
				<div className="basis-1/3 lg:basis-1/5 flex flex-row items-center">
					<div className="basis-1/5">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
					<div className="basis-3/5 bg-white flex justify-center">
						<div className="relative lg:hidden" data-aos="fade-down" data-aos-delay="0">
							<Link to="/"><img src={Logo} className="transition-all w-[15vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
						</div>
					</div>
					<div className="basis-1/5">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
				</div>
				<div className="basis-2/3 lg:basis-4/5 flex items-center">
					<div className="w-full">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
				</div>
			</div>
			<div className="relative w-full">
				<div className="w-full  lg:w-[80vw] lg:ml-[20vw] xl:w-[80vw] xl:ml-[20vw] lg:flex items-center items-stretch">
					<div className="relative w-full xl:w-[35vw] lg:flex items-center" data-aos="fade-up" data-aos-delay="0">
						<div className="text-left p-9 lg:p-0 lg:pr-[100px]">
							<p>Charming yet vibrant. Connected yet tranquil. Modern yet timeless. Vancouver’s west side is a fusion of everything needed for exceptional modern living. A neighbourhood of this calibre deserves homes that reflect its unique character.</p>
							<p>Enter West58, a dynamic collection of 23 spacious one to three-bedroom townhomes and garden suites perfectly crafted to embody the essence of living well in a setting that truly stands out. Enveloped by serene parks, green spaces and a network of top-tier schools, West58 is where life’s best elements converge in one place.</p>
						</div>					
					</div>
					<div className="relative w-full xl:w-[45vw] overflow-x-hidden" data-aos="fade-left" data-aos-delay="300" ref={registerFormRef}>
						<img src={interior} className="w-full max-w-[none] xl:w-[112%] xl:max-2xl:w-[520px] 2xl:w-[100%]"></img>
					</div>
				</div>
			</div>
			<div className="relative w-full px-9 lg:px-0 lg:pt-[50px]">
				<div className="w-full lg:w-[80vw] lg:ml-[20vw] lg:pr-[7.6vw] text-left pt-[50px]" data-aos="fade-up" data-aos-delay="0">
					<h2 className="text-left">Join the list today for an exclusive look into life at West58.</h2>
					<br></br>
					<p className="font-bold">*Required</p>
					<br></br>
					<div className="w-full lg:flex lg:flex-row">
						<form
							ref={formRef}
							data-aos="fade-up"
							data-aos-delay="0"
							id="spark-registration-form"
							action="https://spark.re/azora-corp/west58/register/register"
							method="post"
						>
							<input type="hidden" name="authenticity_token" value="1lDVbEsOxbk4xdEQYQKU4HtXMgXIlB73Sr7D0qmqDXPBuWSgaREjODXgAg/8w1ZuKR6mpnUDPFKE8LYwORd6RA=="/>
							<input id="redirect_error" name="redirect_error" type="hidden" value="https://west58.ca/error" />
							<input id="redirect_success" name="redirect_success" type="hidden" value="https://west58.ca/register/thank-you"/>
						  <div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
							  {text.map(({ type, name, id, label, required }, i) => (
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								  key={i}
								>
								  <label className="w-full !px-0">
									<span className="font-bold inline-block mb-[12px]">
									  {label}
									  {required && "*"}
									</span>{" "}
									<br />
									<input
										className="disable-require w-full bg-transparent border-b focus-visible:outline-none"
										type={type}
										required={required}
										id={id}
										name={name}
										maxLength='50'
									/>
								  </label>
								</div>
							  ))}
							</div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
								<div className="md:basis-1/2 px-3 md:px-[40px]">
									<label className="w-full font-bold inline-block">Preferred Method of Contact*</label>
								</div>
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								>
									<select className="text-[#394544] border-[#394544] border-[1px] border-solid w-full p-[5px]" id="answers_22559" name="answers[22559][answers]" required>
										<option value="">- Select -</option>
										<option value="Email">Email</option>
										<option value="Phone">Phone</option>
										<option value="Text Message">Text Message</option>
									</select>						  
								</div>
							</div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
								<div className="md:basis-1/2 px-3 md:px-[40px]">
									<label className="w-full font-bold inline-block">How Did You Hear About Us?*</label>
								</div>
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								>
									<select className="text-[#394544] border-[#394544] border-[1px] border-solid w-full p-[5px]" id="answers_22554" name="answers[22554][answers]" label="- Select -" required>
										<option value="">- Select -</option>
										{source.options.map((option, i) => (
										  <option value={option} key={i}>{option}</option>
										))}
									</select>							  
								</div>
							</div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
								<div className="md:basis-1/2 px-3 md:px-[40px]">
									<label className="w-full font-bold inline-block">What Type of Home Are You Looking for?</label>
								</div>
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								>
									<select className="text-[#394544] border-[#394544] border-[1px] border-solid w-full p-[5px]" id="answers_22560" name="answers[22560][answers]" label="- Select -">
										<option value="">- Select -</option>
										{homeTypes.options.map((option, i) => (
										  <option value={option} key={i}>{option}</option>
										))}
									</select>							  
								</div>
							</div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
								<div className="md:basis-1/2 px-3 md:px-[40px]">
									<label className="w-full font-bold inline-block">Are You a Realtor?*</label>
								</div>
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								>
									<select className="text-[#394544] border-[#394544] border-[1px] border-solid w-full p-[5px]" id="answers_22561" name="answers[22561][answers]" label="- Select -" required>
										<option value="">- Select -</option>
										<option>Yes</option>
										<option>No</option>									
									</select>							  
								</div>
							</div>
							<div className="flex flex-wrap -mx-[12px] md:-mx-[40px]">
								<div className="md:basis-1/2 px-3 md:px-[40px]">
									<label className="w-full font-bold inline-block">Are You Working with a Realtor?*</label>
								</div>
								<div
								  className="basis-full md:basis-1/2 px-3 md:px-[40px] mb-[40px]"
								>
									<select className="text-[#394544] border-[#394544] border-[1px] border-solid w-full p-[5px]" id="answers_22562" name="answers[22562][answers]" label="- Select -" required>
										<option value="">- Select -</option>
										<option>Yes</option>
										<option>No</option>									
									</select>							  
								</div>
							</div>
							<div className="mb-[40px] flex flex-row">
							  <label className="flex items-start cursor-pointer !p-0">
								<div className="m-0 w-[50px]">
								  <Checkbox
									id="answers_22563"
									name="answers[22563][answers]"
									ripple={false}
									icon={<CheckMark />}
									required
									className="!border-black !bg-white transition-none hover:before:opacity-0 rounded-none scale-75 md:scale-100"
									value="Yes"
								  />
								</div>

								<p className="flex-1">
								  I confirm my consent to receive future communications from West58 and its affiliates and partners including info about this and upcoming developments, promotions, VIP early access or special offers. Should you wish to be excluded, please email us at{" "}
								  <a href="mailto:info@west58.ca" className="underline">
									info@west58.ca
								  </a>{" "}
								  or click the appropriate link at the bottom of any email received. *
								</p>
							  </label>
							</div>
						  </div>

						  <div className="flex items-center h-[56px]">
							{submitting ? (
							  <span className="relative flex h-[20px] w-[20px]">
								<span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-submit opacity-75"></span>
								<span className="relative inline-flex rounded-full h-[20px] w-[20px] bg-submit"></span>
							  </span>
							) : (
							  <button className="bg-submit px-20 py-[12px] uppercase font-bold text-[24px] text-white" type="submit" value="Submit">
								Register
							  </button>
							)}
						  </div>
						</form>

					</div>
				</div>
			</div>
			<div className="relative w-full" ref={mobileTriggerStartRef}>
				<div className="relative w-full flex flex-row mt-[50px] h-[19vw] lg:hidden" id="mobile-logo-bar">
					<div className="basis-1/3 lg:basis-1/5 flex flex-row items-center">
						<div className="basis-1/5">
							<div className="relative w-full h-[11vw] bg-bar-footer"></div>
						</div>
						<div className="basis-3/5 bg-white flex justify-center">
							<div className="relative pt-[1.75vw] lg:hidden lg:pt-0" data-aos="fade-up">
								<Link to="/"><img src={Logo} className="w-[15vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
							</div>
						</div>
						<div className="basis-1/5">
							<div className="relative w-full h-[11vw] bg-bar-footer"></div>
						</div>
					</div>
					<div className="basis-2/3 lg:basis-4/5 flex items-center">
						<div className="w-full">
							<div className="relative w-full h-[11vw] bg-bar-footer"></div>
						</div>
					</div>
				</div>
				<div className="relative w-full pl-[9vw] lg:pl-0">
					<div className="w-full lg:w-[80vw] lg:ml-[20vw] lg:pr-[7.6vw] text-left pt-[50px]">
						<div className="w-full lg:flex lg:flex-row items-center">
							<div className="w-full pb-[50px] lg:pb-0 lg:w-[40vw]" data-aos="fade-up" data-aos-delay="0"><h2 className="text-6xl">Designed for<br></br>Better Living</h2></div>
							<div className="w-full hidden pt-[50px] lg:flex lg:w-[40vw] justify-end" data-aos="fade-left" data-aos-delay="500" id="watermark"><img src={WaterMark} className="w-[250px]"></img></div>
						</div>
					</div>
				</div>
				<div className="relative w-full overflow-y-hidden" ref={triggerEndRef}>
					<div className="relative w-full bg-bar-footer flex flex-row">
						<div className="hidden lg:flex lg:basis-1/5 flex-row">
							<div className="basis-1/5"></div>
							<div className="basis-3/5 bg-white flex justify-center">
								<div className="relative pt-[75px]" data-aos="fade-up">
									<Link to="/"><img src={Logo} className="hidden w-[15vw] pt-[1.2vw] lg:pt-[1.1vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
								</div>
							</div>
							<div className="basis-1/5"></div>
						</div>
						<div className="basis-full pt-[25px] pr-[6vw] lg:pr-0 lg:basis-4/5 lg:flex lg:flex-row lg:justify-end">
							<div className="w-full lg:flex lg:flex-row lg:pl-[5vw]" ref={FooterBarRef}>
								<div className="basis-1/3 flex items-center justity-center lg:border-r-[1px] lg:border-r-[white]" data-aos="fade-up" data-aos-delay="500" id="azora-logo">
									<Link to="https://azoragroup.ca/" target="_blank" className="relative my-0 mx-[auto] lg:mx-0">
										<img src={Azora} className="hidden lg:block w-[12vw] lg:w-[7vw] lg:pt-[25px] relative my-0 mx-[auto] lg:mx-0 lg:pb-[25px]"></img>
										<img src={AzoraHZ} className="pt-[25px] lg:hidden w-[50vw] lg:w-[7vw] relative my-0 mx-[auto] lg:mx-0 lg:pb-[25px]"></img>
									</Link>
								</div>
								<div className="basis-full flex lg:basis-2/3 justify-center items-center pt-[50px] lg:pt-0">
									<div className="basis-1/2 flex justify-center items-center lg:py-0 border-r-[1px] border-r-[white] lg:border-r-0">
										<div className="text-white text-left" data-aos="fade-up" data-aos-delay="1000">
											<p>Contact Us</p>
											<Link to="tel:604.374.7858">604.374.7858</Link>
											<br></br>
											<Link to="mailto:info@West58.ca">info@West58.ca</Link>
										</div>
									</div>
									<div className="basis-1/2 flex justify-center lg:py-0 lg:justify-start items-center">
										<div className="text-white text-left" data-aos="fade-up" data-aos-delay="1500">
											<p>Site Address</p>
											7487 Granville Street
											<br></br>
											Vancouver
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div className="relative w-full bg-bar-footer flex flex-row">
						<div className="hidden lg:basis-1/5 lg:flex flex-row">
							<div className="basis-1/5"></div>
							<div className="basis-3/5 bg-white flex justify-center">
								<div className="relative pt-[75px]">
								</div>
							</div>
							<div className="basis-1/5"></div>
						</div>
						<div className="basis-full py-[25px] pr-[6vw] lg:pr-0 lg:basis-4/5 lg:flex lg:flex-row lg:justify-start">
							<div className="w-full pl-[9vw] lg:flex lg:flex-row lg:pl-[5vw] lg:w-[80%]">
								<p className="text-white text-xs">Illustrations and renderings reflect the artist’s interpretation of the project and do not take into account the neighbouring building, physical structures, streets and landscape. When built, actual suites, amenities, building interiors, exteriors and views may be different than what is depicted. This is not an offering for sale. Any such offering can only be made with the applicable disclosure statement and agreement of purchase and sale. E.&O.E. <Link to="/privacy-policy" className="underline">Privacy Policy</Link></p>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<div className="absolute top-0 bottom-0 left-0 hidden transition-all lg:block lg:w-[20%]">
				<div className="relative w-full flex flex-row h-[19vw] lg:h-[12vw] items-center">
					<div className="basis-1/5">
						<div className="relative w-full h-[5vw] bg-bar-footer"></div>
					</div>
					<div className="basis-3/5 bg-white flex justify-center">
						<div className={`hidden lg:block ${stickyLogo === 0 ? "stay" : ""}
										${stickyLogo === 1 ? "sticky-logo" : ""}
										${stickyLogo === 2 ? "sticky-transition" : ""}
						`} ref={movingLogo}>
							<Link to="/"><img src={Logo} className="transition-all w-[15vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
						</div>
					</div>
					<div className="basis-1/5">
						<div className="relative w-full h-[5vw] bg-bar-footer"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
  );
};

export default RegisterMain;
