import React, { useEffect } from "react";
import { Link } from "react-router-dom";
import SiteHeader from "../../components/SiteHeader";
import SiteFooter from "../../components/SiteFooter";

const PrivacyPolicy = () => {
  useEffect(() => {
		document.title = 'Privacy Policy | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
	}, []);
  return (
    <div className="relative w-full min-h-screen flex flex-col">
		<SiteHeader />
		<div className="relative w-full px-[9vw] lg:pl-0 flex-1">
			<div className="w-full lg:w-[80vw] lg:ml-[20vw] lg:pr-[7.6vw] text-left pt-[50px]">
				<div className="w-full pr-[25px] lg:px-[7vw]">
					<h2 className="text-center">Privacy Policy</h2>
					<br></br>
					<br></br>
					<h3 className="mb-[10px]">Effective date: February 24, 2020</h3>
					<p>AZORA GROUP (“us”, “we”, or “our”) operates the https://WEST58.CA website (the “Service”).</p>
					<p>This page informs you of our policies regarding the collection, use, and disclosure of personal data when you use our Service and the choices you have associated with that data.</p>
					<p>We use your data to provide and improve the Service. By using the Service, you agree to the collection and use of information in accordance with this policy. Unless otherwise defined in this Privacy Policy, terms used in this Privacy Policy have the same meanings as in our Terms and Conditions, accessible from <Link to="https://west58.ca">https://WEST58.CA</Link></p>
					<br></br>
					<h3 className="mb-[10px]">Information Collection and Use</h3>
					<p>We collect several different types of information for various purposes to provide and improve our Service to you.</p>
					<p>Types of Data Collected</p>

					<p className="underline">Personal Data</p>
					<p>While using our Service, we may ask you to provide us with certain personally identifiable information that can be used to contact or identify you (“Personal Data”). Personally identifiable information may include, but is not limited to:</p>
					<ul className="list-disc ml-[50px]">
						<li>Email address</li>
						<li>First name and last name</li>
						<li>Phone number</li>
						<li>Address, State, Province, ZIP/Postal code, City</li>
						<li>Cookies and Usage Data</li>
					</ul>
					<br></br>

					<p className="underline">Usage Data</p>
					<p>We may also collect information how the Service is accessed and used (“Usage Data”). This Usage Data may include information such as your computer’s Internet Protocol address (e.g. IP address), browser type, browser version, the pages of our Service that you visit, the time and date of your visit, the time spent on those pages, unique device identifiers and other diagnostic data.</p>

					<p className="underline">Tracking & Cookies Data</p>
					<p>We use cookies and similar tracking technologies to track the activity on our Service and hold certain information.</p>
					<p>Cookies are files with small amount of data which may include an anonymous unique identifier. Cookies are sent to your browser from a website and stored on your device. Tracking technologies also used are beacons, tags, and scripts to collect and track information and to improve and analyze our Service.</p>
					<p>You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our Service.</p>
					<p>Examples of Cookies we use:</p>
					<ul className="list-disc ml-[50px]">
						<li>Session Cookies. We use Session Cookies to operate our Service.</li>
						<li>Preference Cookies. We use Preference Cookies to remember your preferences and various settings.</li>
						<li>Security Cookies. We use Security Cookies for security purposes.</li>
					</ul>
					<br></br>

					<p className="underline">Use of Data</p>
					<p>AZORA GROUP uses the collected data for various purposes:</p>
					<p>To provide and maintain the Service</p>
					<p>To notify you about changes to our Service</p>
					<p>To allow you to participate in interactive features of our Service when you choose to do so</p>
					<p>To provide customer care and support</p>
					<p>To provide analysis or valuable information so that we can improve the Service</p>
					<p>To monitor the usage of the Service</p>
					<p>To detect, prevent and address technical issues</p>
					<br></br>

					<p className="underline">Transfer of Data</p>
					<p>Your information, including Personal Data, may be transferred to – and maintained on – computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ than those from your jurisdiction.</p>
					<p>If you are located outside Canada and choose to provide information to us, please note that we transfer the data, including Personal Data, to Canada and process it there.</p>
					<p>Your consent to this Privacy Policy followed by your submission of such information represents your agreement to that transfer.</p>
					<p>AZORA GROUP will take all steps reasonably necessary to ensure that your data is treated securely and in accordance with this Privacy Policy and no transfer of your Personal Data will take place to an organization or a country unless there are adequate controls in place including the security of your data and other personal information.</p>
					<br></br>

					<p className="underline">Disclosure of Data</p>
					<p>Legal Requirements</p>
					<p>AZORA GROUP may disclose your Personal Data in the good faith belief that such action is necessary to:</p>
					<ul className="list-disc ml-[50px]">
						<li>To comply with a legal obligation</li>
						<li>To protect and defend the rights or property of AZORA GROUP</li>
						<li>To prevent or investigate possible wrongdoing in connection with the Service</li>
						<li>To protect the personal safety of users of the Service or the public</li>
						<li>To protect against legal liability</li>
					</ul>
					<br></br>

					<p className="underline">Security of Data</p>
					<p>The security of your data is important to us, but remember that no method of transmission over the Internet, or method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your Personal Data, we cannot guarantee its absolute security.</p>
					<p>We only provide articles and information. We never ask for credit card numbers.</p>
					<p>We use regular Malware Scanning.</p>
					<p>Your personal information is contained behind secured networks and is only accessible by a limited number of persons who have special access rights to such systems, and are required to keep the information confidential. In addition, all sensitive/credit information you supply is encrypted via Secure Socket Layer (SSL) technology.</p>
					<br></br>

					<p className="font-bold">Service Providers</p>
					<p>We may employ third party companies and individuals to facilitate our Service (“Service Providers”), to provide the Service on our behalf, to perform Service-related services or to assist us in analyzing how our Service is used.</p>
					<p>These third parties have access to your Personal Data only to perform these tasks on our behalf and are obligated not to disclose or use it for any other purpose.</p>
					<br></br>

					<p className="font-bold">Advertising and Analytics</p>
					<p>We may use third-party Service Providers to monitor and analyze the use of our Service.</p>
					<ul className="list-disc ml-[50px]">
						<li>Google Analytics:  Google Analytics is a web analytics service offered by Google that tracks and reports website traffic. Google uses the data collected to track and monitor the use of our Service. This data is shared with other Google services. Google may use the collected data to contextualize and personalize the ads of its own advertising network. You can opt-out of having made your activity on the Service available to Google Analytics by installing the Google Analytics opt-out browser add-on. The add-on prevents the Google Analytics JavaScript (ga.js, analytics.js, and dc.js) from sharing information with Google Analytics about visits activity. For more information on the privacy practices of Google, please visit the Google Privacy & Terms web page: <Link to="https://policies.google.com/privacy?hl=en">https://policies.google.com/privacy?hl=en</Link></li>
					</ul>
					<br></br>
					<p>Behavioral Remarketing</p>
					<p>We may use remarketing services to advertise on third party websites to you after you visited our Service. We and our third-party vendors use cookies to inform, optimize and serve ads based on your past visits to our Service.</p>
					<ul className="list-disc ml-[50px]">
						<li>Facebook: Facebook remarketing service is provided by Facebook Inc. You can learn more about interest-based advertising from Facebook by visiting this page:  <Link to="https://www.facebook.com/help/164968693837950">https://www.facebook.com/help/164968693837950</Link>. To opt-out from Facebook’s interest-based ads follow these instructions from Facebook:  <Link to="https://www.facebook.com/help/568137493302217">https://www.facebook.com/help/568137493302217</Link>. Facebook adheres to the Self-Regulatory Principles for Online Behavioral Advertising established by the Digital Advertising Alliance. You can also opt-out from Facebook and other participating companies through the Digital Advertising Alliance in the USA  <Link to="http://www.aboutads.info/choices/">http://www.aboutads.info/choices/</Link>, the Digital Advertising Alliance of Canada in Canada  <Link to="http://youradchoices.ca">http://youradchoices.ca/</Link> or the European Interactive Digital Advertising Alliance in Europe  <Link to="http://www.youronlinechoices.eu/">http://www.youronlinechoices.eu/</Link>, or opt-out using your mobile device settings. For more information on the privacy practices of Facebook, please visit Facebook’s Data Policy:  <Link to="https://www.facebook.com/privacy/explanation">https://www.facebook.com/privacy/explanation</Link></li>
					</ul>
					<br></br>

					<p className="font-bold">Links to Other Sites</p>
					<p>Our Service may contain links to other sites that are not operated by us. If you click on a third party link, you will be directed to that third party’s site. We strongly advise you to review the Privacy Policy of every site you visit.</p>
					<p>We have no control over and assume no responsibility for the content, privacy policies or practices of any third party sites or services.</p>
					<br></br>

					<p className="font-bold">CANSPAM</p>
					<p>To be in accordance with CANSPAM, we agree to the following:</p>
					<ul className="list-disc ml-[50px]">
						<li>Not use false or misleading subjects or email addresses.</li>
						<li>Include the physical address of our business or site headquarters.</li>
						<li>Honour opt-out/unsubscribe requests quickly.</li>
					</ul>
					<br></br>

					<p className="font-bold">Children’s Privacy</p>
					<p>Our Service does not address anyone under the age of 18 (“Children”).</p>
					<p>We do not knowingly collect personally identifiable information from anyone under the age of 18. If you are a parent or guardian and you are aware that your Children has provided us with Personal Data, please contact us. If we become aware that we have collected Personal Data from children without verification of parental consent, we take steps to remove that information from our servers.</p>
					<br></br>

					<p className="font-bold">Changes to this Privacy Policy</p>
					<p>We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.</p>
					<p>We will let you know via email and/or a prominent notice on our Service, prior to the change becoming effective and update the “effective date” at the top of this Privacy Policy.</p>
					<p>You are advised to review this Privacy Policy periodically for any changes. Changes to this Privacy Policy are effective when they are posted on this page.</p>
					<br></br>

					<p className="font-bold">Contact Us</p>
					<p>If you have any questions about this Privacy Policy, please contact us:</p>
					<p>By email: <Link to="mailto:info@azora.ca">info@azora.ca</Link></p>
					<p>By Phone: <Link to="tel:778-896-0851">778-896-0851</Link></p>
					<p>By mail: 2645 Kingsway, Vancouver, BC V5R 5H4, Canada</p>
					<br></br>
				</div>
			</div>
		</div>
		<SiteFooter />
	</div>
  );
};

export default PrivacyPolicy;