import React, { useEffect, useRef, useState } from "react";
import { Link } from "react-router-dom";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import NeighbourhoodAnchor from "../../assets/img/neighbourhood/neighbourhood-anchor.jpg";
import Building from "../../assets/img/neighbourhood/neighbourhood-building.jpg";
import Bike from "../../assets/img/neighbourhood/neighbourhood-bike.jpg";
import Grocery from "../../assets/img/neighbourhood/neighbourhood-grocery.jpg";
import Park from "../../assets/img/neighbourhood/neighbourhood-park.jpg";
import SquarePattern1 from "../../assets/img/neighbourhood/neighbourhood-square-pattern-1.svg";
import SquarePattern2 from "../../assets/img/neighbourhood/neighbourhood-square-pattern-2.svg";
import SquareFrame from "../../assets/img/squareframe.svg";
import Map from "./Map";

const Neighbourhood = () => {
	useEffect(() => {
		document.title = 'Neighbourhood | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
	}, []);
  return (
    <div className="relative w-full">
		<MainSiteHeader designSrc={NeighbourhoodAnchor}/>	
		<div className="w-full relative flex">
			<div className="px-[25px] lg:px-0 relative w-full lg:pt-[5vw] lg:w-[40vw] flex-none">
				<div className="relative w-[130px] mt-[50px] lg:my-[50px] lg:mt-0 lg:mb-[5vw] lg:ml-[10vw]" data-aos="fade-right" data-aos-delay="0">
					<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed for
						<br></br>
						Community
					</h2>
					<img className="" src={SquareFrame}></img>
				</div>
				<img className="hidden lg:block w-[calc(40vw-50px)]" src={Bike} data-aos="fade-up" data-aos-delay="500"></img>
			</div>
			<div className="hidden lg:block flex-1 justify-center" data-aos="fade-left" data-aos-delay="1000">
				<img className="w-full" src={Building}></img>
				<div className="flex justify-center pt-[50px]">
					<div className="w-[35vw] grid grid-cols-2 gap-2">
						<img className="w-full" src={Grocery}></img>
						<img className="w-full" src={Park}></img>
					</div>
				</div>
			</div>
		</div>
		<div className="px-[25px] lg:px-[10vw] lg:mb-[50px] w-full relative flex items-center justify-center py-[50px] lg:py-[10vw]" data-aos="fade-up" data-aos-delay="0">
			<img className="hidden lg:block absolute left-[6vw] top-0 w-[15vw]" src={SquarePattern1}></img>
			<img className="hidden lg:block absolute right-[6vw] bottom-0 w-[15vw]" src={SquarePattern2}></img>
			<p className="w-full lg:w-[50vw]">At West58, connection is at the heart of everything. Situated in a prime west side location, amenities abound, from the charming shops on Granville Street to the big box stores in Marpole or at nearby Marine Gateway. This area is also teeming with some of the city’s top schools where your kids can learn and thrive, including Magee Secondary and Dr. R. E. McKechnie Elementary, plus a variety of private options and post-secondary education. Or if it's the more leisurely pace that you're after, life at West58 offers no shortage of family-friendly parks and golf courses for serene community living.</p>
		</div>
		<div className="lg:hidden w-full pb-[50px]" data-aos="fade-up" data-aos-delay="500">
			<img className="w-[85vw] ml-[15vw]" src={Building}></img>
			<div className="flex flex-row items-center mt-[-6.5vw]">
				<img className="w-[55vw] border-solid border-white border-y-[1.65vw] border-r-[1.65vw]" src={Bike}></img>
				<img className="w-[35vw]" src={Grocery}></img>
			</div>
		</div>
		<div className="relative w-full">
			<Map></Map>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Neighbourhood;