import React, { useEffect, useRef, useState } from "react";
import {
  Accordion,
  AccordionHeader,
  AccordionBody,
} from "@material-tailwind/react";
import MapSVG from "../../assets/img/neighbourhood/map.svg";
import Dining from "../../assets/img/neighbourhood/dining.svg";
import Recreation from "../../assets/img/neighbourhood/recreation.svg";
import Schools from "../../assets/img/neighbourhood/schools.svg";
import Shopping from "../../assets/img/neighbourhood/shopping.svg";
import WhiteBar from "../../assets/img/neighbourhood/whitebar.svg";
import North from "../../assets/img/neighbourhood/northicon.svg";
import PurpleDot from "../../assets/img/neighbourhood/purple-dot.svg";
import OrangeDot from "../../assets/img/neighbourhood/orange-dot.svg";
import GreenDot from "../../assets/img/neighbourhood/green-dot.svg";
import BlueDot from "../../assets/img/neighbourhood/blue-dot.svg";
import { locations } from "./markers";
import "./map.css";

const Map = () => {  
	const [open, setOpen] = React.useState(1);
	const handleOpen = (value) => { 
		setOpen(open === value ? 0 : value);
		var els = document.getElementsByClassName('map-dots active');
		while (els[0]) {
			els[0].classList.remove('active')
		}
	}
	const [mobileView, setMobileView] = useState(0);
	const [category, setCategory] = useState("shopping");
	const shoppingDot1 = useRef(null);
	function handleMapDotOver(cat, index) {
		var els = document.getElementsByClassName('map-dots active');
		while (els[0]) {
			els[0].classList.remove('active')
		}
		document.getElementById(cat+'-dot-'+index).classList.toggle('over');	
	}
	function handleMapDotClick(cat, index) {
		//document.getElementsByClassName('map-dots').classList.remove('active');
		var els = document.getElementsByClassName('map-dots active');
		while (els[0]) {
			els[0].classList.remove('active')
		}
		document.getElementById(cat+'-dot-'+index).classList.add('active');		
	}
	 const checkScreenWidth = () => {
	 if (window.innerWidth < 960 ) {
		  setMobileView(1);
	 }
	 else {
		  setMobileView(0);
	 }
	};
	useEffect(() => {
		window.addEventListener('load', checkScreenWidth);
		window.addEventListener('resize', checkScreenWidth);
		return () => {
		};
	}, []);	
  return (
	<div className="relative">
		<div className="relative overflow-x-hidden lg:px-[10vw]">
			<div className={`float-right relative w-[123vw] lg:w-full`}>
				<img src={MapSVG} className="relative max-w-[none] w-full"></img>
				<div className="absolute top-0 bottom-0 left-0 right-0">
					<svg 
						  xmlns="http://www.w3.org/2000/svg"
						  xmlSpace="preserve"
						  x="0px" 
						  y="0px"
						  viewBox="0 0 1328.5 894.2"
						  style={{
						  shapeRendering: "geometricPrecision",
						  textRendering: "geometricPrecision",
						  imageRendering: "optimizeQuality",
						  fillRule: "evenodd",
						  clipRule: "evenodd",
						  width: "100%",
						}} 
					  >
						<defs>
						  <style>
							{".st0-shopping{fill-rule:evenodd;clip-rule:evenodd;fill:#A8518A;}.st0-dining{fill-rule:evenodd;clip-rule:evenodd;fill:#F58634;}.st0-recreation{fill-rule:evenodd;clip-rule:evenodd;fill:#00A859;}.st0-school{fill-rule:evenodd;clip-rule:evenodd;fill:#0098DA;}.st1{fill:#FEFEFE;}.st2{fill:none;}"}
						  </style>
						</defs>
						<g id="shopping" className={`${category === "shopping" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="shopping-legend-1" onMouseOver={() => {
								  handleMapDotOver("shopping", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 1);
								}}>

									<circle className="st0-shopping" cx="796" cy="518.2" r="12" />
									<polygon className="st1" points={`797.9,524.8 797.9,511.6 796.5,511.6 793.9,513.8 793.9,515.4 796.5,513.1 796.5,524.8`}/>
									
								</g>
								<g className="cursor-pointer" id="shopping-legend-2" onMouseOver={() => {
								  handleMapDotOver("shopping", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 2);
								}}>
									<circle className="st0-shopping" cx="870.2" cy="663.7" r="12" />
									<path className="st1" d={`M873.8,670.3v-1.3h-5.7l4.6-6c0.8-0.9,1.1-1.6,1.1-2.7c0-2.2-1.4-3.6-3.6-3.6c-2.2,0-3.6,1.6-3.6,3.6h1.4c0-1.7,1.1-2.4,2.4-2.4c1.4,0,2.4,0.9,2.4,2.4c0,0.8-0.3,1.3-0.8,1.9l-5.2,6.6v1.3h7.1V670.3z`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-3" onMouseOver={() => {
								  handleMapDotOver("shopping", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 3);
								}}>
									<circle className="st0-shopping" cx="1086.7" cy="280.2" r="12" />
									<path className="st1" d={`M1090.5,283.2c0-1.7-0.6-2.7-2.1-3.3c1.3-0.5,1.7-1.6,1.7-3c0-2.2-1.4-3.6-3.6-3.6c-2.1,0-3.6,1.3-3.8,3.5h1.3c0.2-1.4,0.9-2.2,2.4-2.2c1.3,0,2.4,0.8,2.4,2.4c0,1.4-0.8,2.4-2.4,2.4h-0.3v1.1h0.3c1.7,0,2.7,0.9,2.7,2.5s-1.1,2.5-2.5,2.5c-1.3,0-2.4-0.6-2.5-2.4h-1.4c0.2,2.4,1.7,3.5,3.9,3.5C1088.8,287,1090.5,285.7,1090.5,283.2z`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-4" onMouseOver={() => {
								  handleMapDotOver("shopping", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 4);
								}}>
									<circle className="st0-shopping" cx="891.2" cy="843.1" r="12" />
									<polygon className="st1" points={`895.3,847.7 895.3,846.4 893.7,846.4 893.7,842.8 892.5,842.8 892.5,846.4 888.5,846.4 893.4,836.5 891.8,836.5 887.1,846.4 887.1,847.7 892.5,847.7 892.5,849.7 893.7,849.7 893.7,847.7`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-5" onMouseOver={() => {
								  handleMapDotOver("shopping", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 5);
								}}>
									<circle className="st0-shopping" cx="1163.8" cy="645.7" r="12" />
									<path className="st1" d={`M1167.4,647.9c0-1.3-0.2-2.5-1.1-3.6c-0.5-0.5-1.3-0.8-2.4-0.8s-1.9,0.3-2.4,0.9v-4.3h5.5v-1.3h-6.8v6.9		h1.3c0.3-0.8,1.1-1.3,2.2-1.3c1.9,0,2.2,1.6,2.2,3.2c0,0.9,0,2.1-0.8,2.7c-0.3,0.3-0.9,0.6-1.6,0.6c-1.4,0-2.1-0.8-2.2-2.1h-1.4		c0,0.9,0.3,1.7,0.9,2.4c0.6,0.6,1.6,0.9,2.7,0.9c1.1,0,2.1-0.3,2.7-0.9C1167.4,650.6,1167.4,649.3,1167.4,647.9z`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-6" onMouseOver={() => {
								  handleMapDotOver("shopping", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 6);
								}}>
									<circle className="st0-shopping" cx="1146.1" cy="648.7" r="12" />
									<path className="st1" d={`M1149.7,651.4c0-2.2-1.4-3.8-3.5-3.8c-0.5,0-0.9,0.2-1.4,0.3l3-6h-1.4l-3.3,6.6c-0.6,1.1-0.8,2.1-0.8,3		c0,2.4,1.4,3.8,3.6,3.8S1149.7,653.8,1149.7,651.4z M1148.5,651.5c0,1.6-0.9,2.7-2.4,2.7s-2.4-1.1-2.4-2.7		c0-1.6,0.9-2.7,2.4-2.7C1147.7,648.9,1148.5,650,1148.5,651.5z`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-7" onMouseOver={() => {
								  handleMapDotOver("shopping", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 7);
								}}>
									<circle className="st0-shopping" cx="704.8" cy="367.4" r="12" />
									<path className="st1" d={`M709.1,361.6c-1.4,2.5-2.5,4.9-3.3,6.9c-0.8,2.1-1.3,3.9-1.4,5.5h-1.6c0.2-1.1,0.5-2.2,0.8-3.5					c0.5-1.3,0.9-2.5,1.6-3.9c0.6-1.4,1.4-3,2.4-4.7h-6.8v-1.3h8.5v0.9H709.1z`}/>
								</g>
								<g className="cursor-pointer" id="shopping-legend-8" onMouseOver={() => {
								  handleMapDotOver("shopping", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 8);
								}}>
									<circle className="st0-shopping" cx="1048.4" cy="859.7" r="12" />
									<path className="st1" d={`M1052.3,862.7c0-1.6-0.8-2.5-2.1-3.2c1.1-0.6,1.7-1.6,1.7-3c0-2.1-1.6-3.6-3.6-3.6c-2.1,0-3.6,1.4-3.6,3.6		c0,1.4,0.6,2.4,1.7,3c-1.1,0.6-2.1,1.7-2.1,3.2c0,2.2,1.7,3.8,3.9,3.8C1050.6,866.5,1052.3,864.9,1052.3,862.7z M1051.1,862.7		c0,1.4-1.1,2.5-2.5,2.5c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5C1050,860,1051.1,861.1,1051.1,862.7z M1050.8,856.5		c0,1.4-0.9,2.4-2.4,2.4s-2.4-0.9-2.4-2.4s0.9-2.4,2.4-2.4S1050.8,855.1,1050.8,856.5z`}/>
								</g>
							</g>
						</g>

						<g id="dining" className={`${category === "dining" || category === "all" ? "visible" : "invisible"}`}>
							<g className="cursor-pointer" id="dining-legend-1" onMouseOver={() => {
								  handleMapDotOver("dining", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 1);
								}}>
								<circle className="st0-dining" cx="897.1" cy="603.9" r="12" />
								<polygon className="st1" points="899.3,610.5 899.3,597.3 897.4,597.3 894.9,599.5 894.9,601.5 897.4,599.3 897.4,610.5"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-2" onMouseOver={() => {
								  handleMapDotOver("dining", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 2);
								}}>
								<circle className="st0-dining" cx="897.1" cy="583.2" r="12" />
								<path className="st1" d="M900.7,590v-1.3H895l4.6-6c0.8-0.9,1.1-1.6,1.1-2.7c0-2.2-1.4-3.6-3.6-3.6c-2.2,0-3.6,1.6-3.6,3.6h1.4
				c0-1.7,1.1-2.4,2.4-2.4c1.4,0,2.4,0.9,2.4,2.4c0,0.8-0.3,1.3-0.8,1.9l-5.2,6.6v1.3h7.1V590z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-3" onMouseOver={() => {
								  handleMapDotOver("dining", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 3);
								}}>
								<circle className="st0-dining" cx="872" cy="597.2" r="12" />
								<path className="st1" d="M875.9,600.4c0-1.7-0.6-2.7-2.1-3.3c1.3-0.5,1.7-1.6,1.7-3c0-2.2-1.4-3.6-3.6-3.6c-2.1,0-3.6,1.3-3.8,3.5
				h1.4c0.2-1.4,0.9-2.2,2.4-2.2c1.3,0,2.4,0.8,2.4,2.4c0,1.4-0.8,2.4-2.4,2.4h-0.3v1.1h0.3c1.7,0,2.7,0.9,2.7,2.5
				c0,1.6-1.1,2.5-2.5,2.5c-1.3,0-2.4-0.6-2.5-2.4h-1.4c0.2,2.4,1.7,3.5,3.9,3.5C874.2,604,875.9,602.7,875.9,600.4z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-4" onMouseOver={() => {
								  handleMapDotOver("dining", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 4);
								}}>
								<circle className="st0-dining" cx="872" cy="615.7" r="12" />
								<polygon className="st1" points="876.1,620.3 876.1,619 874.5,619 874.5,615.2 873.3,615.2 873.3,619 869.3,619 874.2,609.1 
				872.6,609.1 867.9,619 867.9,620.3 873.3,620.3 873.3,622.3 874.5,622.3 874.5,620.3"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-5" onMouseOver={() => {
								  handleMapDotOver("dining", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 5);
								}}>
								<circle className="st0-dining" cx="895.6" cy="689.8" r="12" />
								<path className="st1" d="M899.4,691c0-1.3-0.2-2.5-1.1-3.6c-0.5-0.5-1.3-0.8-2.4-0.8s-1.9,0.3-2.4,0.9v-4.3h5.5V682h-6.8v6.9h1.3
				c0.3-0.8,1.1-1.3,2.2-1.3c1.9,0,2.2,1.6,2.2,3.2c0,0.9,0,2.1-0.8,2.7c-0.3,0.3-0.9,0.6-1.6,0.6c-1.4,0-2.1-0.8-2.2-2.1H892
				c0,0.9,0.3,1.7,0.9,2.4c0.6,0.6,1.6,0.9,2.7,0.9s2.1-0.3,2.7-0.9C899.2,693.5,899.4,692.3,899.4,691z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-6" onMouseOver={() => {
							  handleMapDotOver("dining", 6);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 6);
							}}>
								<circle className="st0-dining" cx="812.9" cy="517.9" r="12" />
								<path className="st1" d="M816.7,520.6c0-2.2-1.4-3.8-3.5-3.8c-0.5,0-0.9,0.2-1.4,0.3l3-6h-1.4l-3.3,6.6c-0.6,1.1-0.8,2.1-0.8,3
					c0,2.4,1.4,3.8,3.6,3.8C815.3,524.5,816.7,522.8,816.7,520.6z M815.3,520.6c0,1.6-0.9,2.7-2.4,2.7s-2.4-1.1-2.4-2.7
					c0-1.6,0.9-2.7,2.4-2.7C814.5,517.9,815.3,519.2,815.3,520.6z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-7" onMouseOver={() => {
							  handleMapDotOver("dining", 7);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 7);
							}}>
								<circle className="st0-dining" cx="917.1" cy="689.8" r="12" />
								<polygon className="st1" points="920.7,684.3 920.7,683.2 913.3,683.2 913.3,686.5 914.7,686.5 914.7,684.3 919.3,684.3 
					914.7,696.4 916.2,696.4"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-8" onMouseOver={() => {
							  handleMapDotOver("dining", 8);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 8);
							}}>
								<circle className="st0-dining" cx="715.5" cy="239.9" r="12" />
								<path className="st1" d="M719.4,242.7c0-1.6-0.8-2.5-2.1-3.2c1.1-0.6,1.7-1.6,1.7-3c0-2.1-1.6-3.6-3.6-3.6s-3.6,1.4-3.6,3.6
					c0,1.4,0.6,2.4,1.7,3c-1.1,0.6-2.1,1.7-2.1,3.2c0,2.2,1.7,3.8,3.9,3.8C717.7,246.5,719.4,245.1,719.4,242.7z M718,242.7
					c0,1.4-1.1,2.5-2.5,2.5c-1.4,0-2.5-1.1-2.5-2.5s1.1-2.5,2.5-2.5C716.9,240.2,718,241.3,718,242.7z M717.7,236.6
					c0,1.4-0.9,2.4-2.4,2.4c-1.4,0-2.4-0.9-2.4-2.4c0-1.4,0.9-2.4,2.4-2.4C716.8,234.2,717.7,235.3,717.7,236.6z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-9" onMouseOver={() => {
							  handleMapDotOver("dining", 9);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 9);
							}}>
								<circle className="st0-dining" cx="661.6" cy="256.1" r="12" />
								<path className="st1" d="M665.2,253.3c0-2.4-1.4-3.8-3.6-3.8c-2.2,0-3.6,1.7-3.6,3.9s1.4,3.8,3.5,3.8c0.5,0,0.9-0.2,1.4-0.3l-3,6
					h1.4l3.3-6.6C664.9,255.2,665.2,254.2,665.2,253.3z M664,253.3c0,1.6-0.9,2.7-2.4,2.7c-1.6,0-2.4-1.3-2.4-2.7
					c0-1.6,0.9-2.7,2.4-2.7S664,251.7,664,253.3z"/>
							</g>
							<g className="cursor-pointer" id="dining-legend-10" onMouseOver={() => {
							  handleMapDotOver("dining", 10);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 10);
							}}>
								<circle className="st0-dining" cx="940.6" cy="743.6" r="12" />
								<polygon className="st1" points="936.5,750.2 936.5,737 935.2,737 932.7,739 932.7,740.6 935.2,738.4 935.2,750.2"/>
								<path id="_x31_" className="st1" d="M948.7,746.6v-6.2c0-2.2-1.6-3.6-3.6-3.6s-3.6,1.4-3.6,3.6v6.2c0,2.2,1.6,3.6,3.6,3.6
					C947.1,750.4,948.7,748.8,948.7,746.6z M947.2,746.6c0,1.4-0.8,2.5-2.4,2.5c-1.4,0-2.4-1.1-2.4-2.5v-6c0-1.4,0.8-2.5,2.4-2.5
					c1.4,0,2.4,1.1,2.4,2.5V746.6z"/>
							</g>
						</g>

						<g id="recreation" className={`${category === "recreation" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="recreation-legend-1" onMouseOver={() => {
								  handleMapDotOver("recreation", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 1);
								}}>
									<circle className="st0-recreation" cx="832.9" cy="492.9" r="12" />
									<polygon className="st1" points="834.8,499.5 834.8,486.3 833.4,486.3 831,488.3 831,489.9 833.4,487.7 833.4,499.5"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-2" onMouseOver={() => {
								  handleMapDotOver("recreation", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 2);
								}}>
									<circle className="st0-recreation" cx="827.2" cy="575.3" r="12" />
									<path className="st1" d="M830.8,582.1v-1.3h-5.7l4.6-6c0.8-0.9,1.1-1.6,1.1-2.7c0-2.2-1.4-3.6-3.6-3.6c-2.2,0-3.6,1.6-3.6,3.6h1.4
					c0-1.7,1.1-2.4,2.4-2.4c1.4,0,2.4,0.9,2.4,2.4c0,0.8-0.3,1.3-0.8,1.9l-5.2,6.6v1.3h7.1V582.1z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-3" onMouseOver={() => {
								  handleMapDotOver("recreation", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 3);
								}}>
									<circle className="st0-recreation" cx="1021.9" cy="531" r="12" />
									<path className="st1" d="M1025.8,534c0-1.7-0.6-2.7-2.1-3.3c1.3-0.5,1.7-1.6,1.7-3c0-2.2-1.4-3.6-3.6-3.6c-2.1,0-3.6,1.3-3.8,3.5
					h1.4c0.2-1.4,0.9-2.2,2.4-2.2c1.3,0,2.4,0.8,2.4,2.4c0,1.4-0.8,2.4-2.4,2.4h-0.3v1.1h0.3c1.7,0,2.7,0.9,2.7,2.5
					c0,1.6-1.1,2.5-2.5,2.5c-1.3,0-2.4-0.6-2.5-2.4h-1.4c0.2,2.4,1.7,3.5,3.9,3.5C1024.1,537.8,1025.8,536.5,1025.8,534z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-4" onMouseOver={() => {
								  handleMapDotOver("recreation", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 4);
								}}>
									<circle className="st0-recreation" cx="1021.2" cy="566" r="12" />
									<polygon className="st1" points="1025.3,570.6 1025.3,569.3 1023.7,569.3 1023.7,565.5 1022.3,565.5 1022.3,569.3 1018.5,569.3 
					1023.3,559.4 1021.8,559.4 1017.1,569.3 1017.1,570.6 1022.3,570.6 1022.3,572.6 1023.7,572.6 1023.7,570.6"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-5" onMouseOver={() => {
								  handleMapDotOver("recreation", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 5);
								}}>
									<circle className="st0-recreation" cx="1182.9" cy="485.5" r="12" />
									<path className="st1" d="M1186.5,487.7c0-1.3-0.2-2.5-1.1-3.6c-0.5-0.5-1.3-0.8-2.4-0.8s-1.9,0.3-2.4,0.9V480h5.5v-1.3h-6.8v6.9h1.3
					c0.3-0.8,1.1-1.3,2.2-1.3c1.9,0,2.2,1.6,2.2,3.2c0,0.9,0,2.1-0.8,2.7c-0.3,0.3-0.9,0.6-1.6,0.6c-1.4,0-2.1-0.8-2.2-2.1h-1.4
					c0,0.9,0.3,1.7,0.9,2.4c0.6,0.6,1.6,0.9,2.7,0.9c1.1,0,2.1-0.3,2.7-0.9C1186.4,490.2,1186.5,489,1186.5,487.7z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-6" onMouseOver={() => {
								  handleMapDotOver("recreation", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 6);
								}}>
									<circle className="st0-recreation" cx="961" cy="182" r="12" />
									<path className="st1" d="M964.8,184.7c0-2.2-1.4-3.8-3.5-3.8c-0.5,0-0.9,0.2-1.4,0.3l3-6h-1.4l-3.3,6.6c-0.6,1.1-0.8,2.1-0.8,3
					c0,2.4,1.4,3.8,3.6,3.8C963.4,188.6,964.8,186.9,964.8,184.7z M963.4,184.7c0,1.6-0.9,2.7-2.4,2.7s-2.4-1.1-2.4-2.7
					c0-1.6,0.9-2.7,2.4-2.7C962.6,182,963.4,183.3,963.4,184.7z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-7" onMouseOver={() => {
								  handleMapDotOver("recreation", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 7);
								}}>
									<circle className="st0-recreation" cx="1189.1" cy="161.5" r="12" />
									<polygon className="st1" points="1192.7,156 1192.7,154.9 1185.3,154.9 1185.3,158 1186.7,158 1186.7,156 1191.3,156 1186.7,168.1 
					1188.2,168.1"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-8" onMouseOver={() => {
								  handleMapDotOver("recreation", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 8);
								}}>
									<circle className="st0-recreation" cx="1106.5" cy="369.8" r="12" />
									<path className="st1" d="M1110.4,372.8c0-1.6-0.8-2.5-2.1-3.2c1.1-0.6,1.7-1.6,1.7-3c0-2.1-1.6-3.6-3.6-3.6s-3.6,1.4-3.6,3.6
					c0,1.4,0.6,2.4,1.7,3c-1.1,0.6-2.1,1.7-2.1,3.2c0,2.2,1.7,3.8,3.9,3.8C1108.7,376.6,1110.4,375,1110.4,372.8z M1109.2,372.6
					c0,1.4-1.1,2.5-2.5,2.5s-2.5-1.1-2.5-2.5s1.1-2.5,2.5-2.5C1108.1,370.1,1109.2,371.2,1109.2,372.6z M1108.9,366.6
					c0,1.4-0.9,2.4-2.4,2.4c-1.4,0-2.4-0.9-2.4-2.4s0.9-2.4,2.4-2.4C1107.9,364.1,1108.9,365.2,1108.9,366.6z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-9" onMouseOver={() => {
								  handleMapDotOver("recreation", 9);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 9);
								}}>
									<circle className="st0-recreation" cx="675.4" cy="547.3" r="12" />
									<path className="st1" d="M679,544.5c0-2.4-1.4-3.8-3.6-3.8s-3.6,1.7-3.6,3.9s1.4,3.8,3.5,3.8c0.5,0,0.9-0.2,1.4-0.3l-3,6h1.4
					l3.3-6.6C678.7,546.2,679,545.4,679,544.5z M677.6,544.5c0,1.6-0.9,2.7-2.4,2.7c-1.6,0-2.4-1.3-2.4-2.7c0-1.6,0.9-2.7,2.4-2.7
					S677.6,542.9,677.6,544.5z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-10" onMouseOver={() => {
								  handleMapDotOver("recreation", 10);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 10);
								}}>
									<circle className="st0-recreation" cx="776" cy="685.6" r="12" />
									<path className="st1" d="M771.9,692.2V679h-1.4l-2.5,2.2v1.6l2.5-2.2v11.8h1.4V692.2z M784.1,688.8v-6.2c0-2.2-1.6-3.6-3.6-3.6
					c-2.1,0-3.6,1.4-3.6,3.6v6.2c0,2.2,1.6,3.6,3.6,3.6C782.5,692.4,784.1,691,784.1,688.8z M782.6,688.6c0,1.4-0.8,2.5-2.4,2.5
					c-1.4,0-2.4-1.1-2.4-2.5v-6c0-1.4,0.8-2.5,2.4-2.5c1.4,0,2.4,1.1,2.4,2.5V688.6z"/>
								</g>
								<g className="cursor-pointer" id="recreation-legend-11" onMouseOver={() => {
								  handleMapDotOver("recreation", 11);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 11);
								}}>
									<circle className="st0-recreation" cx="711.8" cy="297.4" r="12" />
									<path className="st1" d="M708.8,304.2v-13.3h-1.4l-2.5,2.2v1.6l2.5-2.2v11.8h1.4V304.2z M718.6,304.2v-13.3h-1.4l-2.5,2.2v1.6
					l2.5-2.2v11.8h1.4V304.2z"/>
								</g>
							</g>
						</g>

						<g id="schools" className={`transition-all duration-500 ${category === "schools" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="schools-legend-1" onMouseOver={() => {
								  handleMapDotOver("schools", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 1);
								}}>
									<circle className="st0-school" cx="755.8" cy="531.8" r="12" />
									<polygon className="st1" points="757.9,538.4 757.9,525.2 756.4,525.2 753.9,527.2 753.9,528.8 756.4,526.6 756.4,538.4"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-2" onMouseOver={() => {
								  handleMapDotOver("schools", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 2);
								}}>
									<circle className="st0-school" cx="751.7" cy="334.9" r="12" />
									<path className="st1" d="M755.3,341.5v-1.3h-5.7l4.6-6c0.8-0.9,1.1-1.6,1.1-2.7c0-2.2-1.4-3.6-3.6-3.6c-2.2,0-3.6,1.6-3.6,3.6h1.4
					c0-1.7,1.1-2.4,2.4-2.4c1.4,0,2.4,0.9,2.4,2.4c0,0.8-0.3,1.3-0.8,1.9l-5.2,6.6v1.3h7.1V341.5z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-3" onMouseOver={() => {
								  handleMapDotOver("schools", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 3);
								}}>
									<circle className="st0-school" cx="1037.2" cy="469" r="12" />
									<path className="st1" d="M1041,472c0-1.7-0.6-2.7-2.1-3.3c1.3-0.5,1.7-1.6,1.7-3c0-2.2-1.4-3.6-3.6-3.6c-2.1,0-3.6,1.3-3.8,3.5h1.4
					c0.2-1.4,0.9-2.2,2.4-2.2c1.3,0,2.4,0.8,2.4,2.4c0,1.4-0.8,2.4-2.4,2.4h-0.3v1.1h0.3c1.7,0,2.7,0.9,2.7,2.5s-1.1,2.5-2.5,2.5
					c-1.3,0-2.4-0.6-2.5-2.4h-1.4c0.2,2.4,1.7,3.5,3.9,3.5C1039.3,475.8,1041,474.5,1041,472z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-4" onMouseOver={() => {
								  handleMapDotOver("schools", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 4);
								}}>
									<circle className="st0-school" cx="1042.8" cy="516.5" r="12" />
									<polygon className="st1" points="1046.9,521.1 1046.9,519.8 1045.3,519.8 1045.3,516 1044.1,516 1044.1,519.8 1040.1,519.8 
					1045,509.9 1043.6,509.9 1038.7,519.8 1038.7,521.1 1044.1,521.1 1044.1,523.1 1045.3,523.1 1045.3,521.1"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-5" onMouseOver={() => {
								  handleMapDotOver("schools", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 5);
								}}>
									<circle className="st0-school" cx="1230.4" cy="400.1" r="12" />
									<path className="st1" d="M1234,402.3c0-1.3-0.2-2.5-1.1-3.6c-0.5-0.5-1.3-0.8-2.4-0.8s-1.9,0.3-2.4,0.9v-4.3h5.5v-1.3h-6.8v6.9h1.3
					c0.3-0.8,1.1-1.3,2.2-1.3c1.9,0,2.2,1.6,2.2,3.2c0,0.9,0,2.1-0.8,2.7c-0.3,0.3-0.9,0.6-1.6,0.6c-1.4,0-2.1-0.8-2.2-2.1h-1.4
					c0,0.9,0.3,1.7,0.9,2.4c0.6,0.6,1.6,0.9,2.7,0.9c1.1,0,2.1-0.3,2.7-0.9C1233.9,404.8,1234,403.6,1234,402.3z"/>
								</g>						
								<g className="cursor-pointer" id="schools-legend-6" onMouseOver={() => {
								  handleMapDotOver("schools", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 6);
								}}>
									<circle className="st0-school" cx="926.9" cy="735.8" r="12" />
									<path className="st1" d="M930.5,738.6c0-2.2-1.4-3.8-3.5-3.8c-0.5,0-0.9,0.2-1.4,0.3l3-6h-1.4l-3.3,6.6c-0.6,1.1-0.8,2.1-0.8,3
					c0,2.4,1.4,3.8,3.6,3.8C929.1,742.6,930.5,740.9,930.5,738.6z M929.3,738.6c0,1.6-0.9,2.7-2.4,2.7s-2.4-1.1-2.4-2.7
					c0-1.6,0.9-2.7,2.4-2.7C928.5,736,929.3,737.2,929.3,738.6z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-7" onMouseOver={() => {
								  handleMapDotOver("schools", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 7);
								}}>
									<circle className="st0-school" cx="941.2" cy="629.5" r="12" />
									<polygon className="st1" points="944.8,624 944.8,622.9 937.4,622.9 937.4,626.2 938.8,626.2 938.8,624 943.4,624 938.8,636.1 
					940.3,636.1"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-8" onMouseOver={() => {
								  handleMapDotOver("schools", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 8);
								}}>
									<circle className="st0-school" cx="841" cy="689.8" r="12" />
									<path className="st1" d="M844.9,692.8c0-1.6-0.8-2.5-2.1-3.2c1.1-0.6,1.7-1.6,1.7-3c0-2.1-1.6-3.6-3.6-3.6s-3.6,1.4-3.6,3.6
					c0,1.4,0.6,2.4,1.7,3c-1.1,0.6-2.1,1.7-2.1,3.2c0,2.2,1.7,3.8,3.9,3.8C843.2,696.6,844.9,695,844.9,692.8z M843.5,692.8
					c0,1.4-1.1,2.5-2.5,2.5c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5C842.4,690.1,843.5,691.2,843.5,692.8z M843.4,686.6
					c0,1.4-0.9,2.4-2.4,2.4s-2.4-0.9-2.4-2.4s0.9-2.4,2.4-2.4S843.4,685.2,843.4,686.6z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-9" onMouseOver={() => {
								  handleMapDotOver("schools", 9);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 9);
								}}>
									<circle className="st0-school" cx="870.3" cy="49.1" r="12" />
									<path className="st1" d="M873.9,46.3c0-2.4-1.4-3.8-3.6-3.8c-2.2,0-3.6,1.7-3.6,3.9c0,2.2,1.4,3.8,3.5,3.8c0.5,0,0.9-0.2,1.4-0.3
					l-3,6h1.4l3.3-6.6C873.8,48.2,873.9,47.2,873.9,46.3z M872.7,46.3c0,1.6-0.9,2.7-2.4,2.7c-1.6,0-2.4-1.3-2.4-2.7
					c0-1.6,0.9-2.7,2.4-2.7S872.7,44.7,872.7,46.3z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-10" onMouseOver={() => {
								  handleMapDotOver("schools", 10);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 10);
								}}>
									<circle className="st0-school" cx="857.2" cy="62.6" r="12" />
									<path className="st1" d="M853.1,69.2V56h-1.4l-2.5,2.2v1.6l2.5-2.2v11.8h1.4V69.2z M865.3,65.8v-6.2c0-2.2-1.6-3.6-3.6-3.6
					c-2.1,0-3.6,1.4-3.6,3.6v6.2c0,2.2,1.6,3.6,3.6,3.6C863.7,69.4,865.3,68,865.3,65.8z M863.8,65.6c0,1.4-0.8,2.5-2.4,2.5
					c-1.4,0-2.4-1.1-2.4-2.5v-6c0-1.4,0.8-2.5,2.4-2.5c1.4,0,2.4,1.1,2.4,2.5V65.6z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-11" onMouseOver={() => {
								  handleMapDotOver("schools", 11);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 11);
								}}>
									<circle className="st0-school" cx="500.6" cy="88.5" r="12" />
									<path className="st1" d="M497.6,95.1V81.9h-1.4l-2.5,2.2v1.6l2.5-2.2v11.8h1.4V95.1z M507.4,95.1V81.9H506l-2.5,2.2v1.6l2.5-2.2
					v11.8h1.4V95.1z" />
								</g>
								<g className="cursor-pointer" id="schools-legend-12" onMouseOver={() => {
								  handleMapDotOver("schools", 12);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 12);
								}}>
									<circle className="st0-school" cx="604.7" cy="282.7" r="12" />
									<polygon className="st1" points="600.6,289.3 600.6,276.1 599.2,276.1 596.6,278.3 596.6,279.7 599.2,277.6 599.2,289.3"/>
									<path id="_x31__00000081606217914870312680000012269690995614418827_" className="st1" d="M612.8,289.3v-1.3h-5.7l4.6-6
					c0.8-0.9,1.1-1.6,1.1-2.7c0-2.2-1.4-3.6-3.6-3.6c-2.2,0-3.6,1.6-3.6,3.6h1.4c0-1.7,1.1-2.4,2.4-2.4c1.4,0,2.4,0.9,2.4,2.4
					c0,0.8-0.3,1.3-0.8,1.9l-5.2,6.6v1.3h7.1V289.3z"/>
								</g>
							</g>
						</g>
					</svg>
				</div>
				<div className="absolute top-0 left-0 w-[19vw] h-full bg-[rgba(255,255,255,0.8)]">
					<div className="relative p-[2.63vw] text-[#A98B68] text-[0.95vw]">
						<div className="relative">
							<div className="relative pb-[1.31vw]">
								<div className="flex flex-row items-start transition-all duration-300 cursor-pointer" onClick={() => setCategory("all")}>	
									<h3 className="flex-1 text-[1.25vw] leading-[1.68vw] font-normal">All</h3>
								</div>
							</div>
							{locations.map(({ category, catLabel, markers }, i) => (
							  <Accordion open={open === i + 1} className=" pb-[1.31vw]" key={i}>
								<AccordionHeader
								  className="border-0 py-0"
								  onClick={() => {
									handleOpen(i + 1);
									setCategory(category);
								  }}
								>
									<div className="flex flex-row items-center">
										{ category === "shopping" && <img src={PurpleDot} className="flex-none w-[5.856%]"></img> }
										{ category === "dining" && <img src={OrangeDot} className="flex-none w-[5.856%]"></img> }
										{ category === "recreation" && <img src={GreenDot} className="flex-none w-[5.856%]"></img> }
										{ category === "schools" && <img src={BlueDot} className="flex-none w-[5.856%]"></img> }
										<h3 className="flex-1 pl-[0.26vw] text-[1.25vw] text-[#A98B68] font-normal leading-[1.68vw]">{catLabel}</h3>
									</div>
								</AccordionHeader>
								<AccordionBody className="py-0 pt-[0.63vw]">

									{markers.map(({ title }, j) => (
										<div key={j} className="flex flex-row items-start cursor-pointer text-[0.95vw]" onClick={() => handleMapDotClick(category, (j+1))}>
											<div className="flex-none w-[5.856%] text-center">{j + 1}.</div>
											<div className="flex-1 pl-[0.26vw]">{title}</div>
										</div>
									))}
								</AccordionBody>
							  </Accordion>
							))}							
						</div>
					</div>
				</div>
				{locations.map(({ category, catLabel, markers }, i) => (
				  <div key={i}>
						{markers.map(({ title, boxWidth, position, boxPosition, anglePosition }, j) => (
							<div key={j} className={`map-dots absolute ${position}`} id={category+"-dot-"+(j+1)}>
								<div
									className={`absolute ${boxWidth} bg-white p-[0.53vw] transition-all duration-700 ${boxPosition} left-[50%] translate-x-[-50%] opacity-100 translate-y-[-100%] leading-[3vw] lg:leading-[0.92vw] text-center text-[3vw] lg:text-[0.92vw]`}
								  >
									<div className={`absolute bg-white w-[3vw] lg:w-[1.05vw] h-[3vw] lg:h-[1.05vw] rotate-45 left-[50%] translate-x-[-50%] ${anglePosition} z-[-11]`}></div>
									<div className="z-[99]">{title}</div>
								</div>
							</div>
						))}
				  </div>
				))}
			</div>
		</div>
		<div className="relative pb-[50px]">
			<div className="lg:hidden relative p-[25px] text-[#A98B68]">
				<div className="relative pb-[1.31vw]">
					<div className="flex flex-row items-start transition-all duration-300 cursor-pointer" onClick={() => setCategory("all")}>
						<h3 className="flex-1 font-normal">All</h3>
					</div>
				</div>
				{locations.map(({ category, catLabel, markers }, i) => (
				  <Accordion open={open === i + 1} className="relative pb-[1.31vw]" key={i}>
					<AccordionHeader
					  className="relative border-0 py-0"
					  onClick={() => {
						handleOpen(i + 1);
						setCategory(category);
					  }}
					>
						<div className="relative flex flex-row items-center">
							{ category === "shopping" && <img src={PurpleDot} className="flex-none w-[20px]"></img> }
							{ category === "dining" && <img src={OrangeDot} className="flex-none w-[20px]"></img> }
							{ category === "recreation" && <img src={GreenDot} className="flex-none w-[20px]"></img> }
							{ category === "schools" && <img src={BlueDot} className="flex-none w-[20px]"></img> }
							<h3 className="flex-1 pl-[5px] text-[#A98B68] font-normal">{catLabel}</h3>
						</div>
					</AccordionHeader>
					<AccordionBody className="py-0 pt-3 text-lg">

						{markers.map(({ title }, j) => (
							<div key={j} className="flex flex-row items-start cursor-pointer" onClick={() => handleMapDotClick(category, (j+1))}>
								<div className="flex-none w-[20px] text-center">{j + 1}.</div>
								<div className="flex-1 pl-[5px]">{title}</div>
							</div>
						))}
					</AccordionBody>
				  </Accordion>
				))}				
			</div>
		</div>
	</div>
  );
};

export default Map;
