import React, { useEffect, useRef, useState } from "react";
import { useNavigate, Link } from "react-router-dom";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import HomeAnchor from "../../assets/img/home/homepage-anchor.jpg";
import Lifestyle1 from "../../assets/img/home/homepage-lifestyle-1.jpg";
import Lifestyle2 from "../../assets/img/home/homepage-lifestyle-2.jpg";
import Lifestyle3 from "../../assets/img/home/homepage-lifestyle-3.jpg";
import Sophistication from "../../assets/img/home/homepage-sophistication.jpg";
import Inspire from "../../assets/img/home/homepage-inspire.jpg";
import Style from "../../assets/img/home/homepage-style.jpg";
import SquareFrame from "../../assets/img/squareframe.svg";
import ActiveDot from "../../assets/img/home/homepage-slider-menu-navy.svg";
import Dot from "../../assets/img/home/homepage-slider-menu-beidge.svg";

const Home = () => {
	const [dotLoc, setDotLoc] = useState(0);
	const [scrollY, setScrollY] = useState("");
	const [slide1top, setslide1top] = useState("");
	const [slide2top, setslide2top] = useState("");
	const [slide3top, setslide3top] = useState("");
 	const handleSlider = () => {
		if (window.innerWidth < 1024) {
			if ((document.getElementById("slide1-block").offsetHeight + document.getElementById("slide1-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide1").style.height = document.getElementById("slide1-block").offsetHeight + document.getElementById("slide1-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide1").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}	
			
			if ((document.getElementById("slide2-block").offsetHeight + document.getElementById("slide2-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide2").style.height = document.getElementById("slide2-block").offsetHeight + document.getElementById("slide2-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide2").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
			
			if ((document.getElementById("slide3-block").offsetHeight + document.getElementById("slide3-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide3").style.height = document.getElementById("slide3-block").offsetHeight + document.getElementById("slide3-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide3").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
			
		}
		else {
			document.getElementById("slide1").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide2").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide3").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
		}
	};
	const handleDots = () => {
		if (window.innerWidth >= 1024) {
			if ((window.pageYOffset) > (document.getElementById("slider-wrap").offsetTop - (window.innerHeight/2))) {
				setDotLoc(0);
			}
			if ((window.pageYOffset) > (document.getElementById("slider-wrap").offsetTop + document.getElementById("slide1").offsetHeight - (window.innerHeight/2))) {
				setDotLoc(1);
			}
			if ((window.pageYOffset) > (document.getElementById("slider-wrap").offsetTop + document.getElementById("slide1").offsetHeight + document.getElementById("slide2").offsetHeight - (window.innerHeight/2))) {
				setDotLoc(2);
			}
		}
	};

	useEffect(() => {
		window.addEventListener('load', handleSlider);
		window.addEventListener('resize', handleSlider);
		window.addEventListener('scroll', handleDots);
		document.title = 'Home | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
		return () => {
			window.removeEventListener('load', handleSlider);
			window.removeEventListener('resize', handleSlider);
			window.addEventListener('scroll', handleDots);
		};
	}, []);
  return (
    <div className="w-full">
		<MainSiteHeader designSrc={HomeAnchor}/>		
		<div className="w-full relative flex flex-col-reverse lg:flex-row items-center pb-[50px] bg-white z-[1]">
			<div className="hidden lg:block w-[10%]">
			</div>
			<div className="w-full lg:w-[50%] grid grid-cols-3 gap-2">
				<div className="pt-[50px] lg:pt-0">
					<img src={Lifestyle1} data-aos="fade-down" data-aos-delay="0"></img>
				</div>
				<div>
					<img src={Lifestyle2} data-aos="fade-up" data-aos-delay="500"></img>
				</div>
				<div className="pt-[50px] lg:pt-0">
					<img src={Lifestyle3} data-aos="fade-down" data-aos-delay="1000"></img>
				</div>
			</div>
			<div className="w-full lg:w-[30%] p-[25px] lg:p-[50px]" data-aos="fade-left" data-aos-delay="0">
				<h2 className="lg:hidden">Designed for Better Living</h2>
				<br className="lg:hidden"></br>
				<h3 className="lg:hidden">1 to 3 Bed Townhomes & Garden Suites</h3>
				<br className="lg:hidden"></br>
				<br className="lg:hidden"></br>
				<p>Charming yet vibrant. Connected yet tranquil. Modern yet timeless. Enter West58, a dynamic collection of 23 spacious townhomes and garden suites perfectly crafted to embody the essence of living well in a setting that truly stands out. Enveloped by serene parks, green spaces and a network of top-tier schools in Vancouver’s west side, West58 is where life’s best elements converge in one place.</p>
				<br></br>
				<Link to="/neighbourhood"><h3>Explore Our Neighbourhood &#8594;</h3></Link>
				<br className="lg:hidden"></br>
				<br className="lg:hidden"></br>
			</div>
			<div className="hidden lg:block w-[10%]">
			</div>
		</div>
		<div className="w-full relative overflow-clip" id="slider-wrap">
			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip" id="slide1">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide1-block" data-aos="fade-down" data-aos-delay="0">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed for
							<br></br>
							Sophistication
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Life at West58 welcomes you to a home where function and style unite, and where roomy interiors and intuitive layouts create the perfect backdrop for a thriving lifestyle.</p>
					<br></br>
					<Link to="/floorplans"><h3>Explore Our Homes &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-full lg:w-[50vw] h-[300%] top-[25%] lg:top-0" data-aos="fade-left" data-aos-delay="500">
					<div className="sticky h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] bottom-0 lg:top-[7.8vw] flex items-center">
						<img className="" src={Sophistication}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Sophistication} id="slide1-img"></img>
						</div>
					</div>
				</div>
				</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip " id="slide2">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide2-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed for
							<br></br>
							Elegance
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Embrace the refined interiors of West58, curated for both comfort and style. With generous storage, abundant natural light and sophisticated design touches, West58 creates the perfect canvas for modern living.</p>
					<br></br>
					<Link to="/gallery"><h3>Explore the Gallery &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-full lg:w-[50vw] h-[300%] top-[-100%]">
					<div className="sticky h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] bottom-0 lg:top-[7.8vw] flex items-center">
						<img className="" src={Style}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Style} id="slide2-img"></img>
						</div>
					</div>
				</div>
			</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip" id="slide3">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide3-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed to
							<br></br>
							Inspire
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>West58 is brought to you by Azora Group, a proudly family-owned residential development and construction company located in the heart of beautiful Vancouver.</p>
					<br></br>
					<Link to="/team"><h3>Explore Our Team &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-[50vw] h-[300%] top-auto bottom-0">
					<div className="sticky h-[calc(100vh-7.8vw)] top-[7.8vw] flex items-center">
						<img className="sticky top-0" src={Inspire}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Inspire} id="slide3-img"></img>
						</div>
					</div>
				</div>
			</div>
			<div className="relative h-[35px]"></div>
			<div className="hidden lg:block absolute w-[10vw] top-0 bottom-0 flex justify-center items-center">
				<div className="sticky top-0 h-[calc(100vh-7.8vw)] flex justify-center pt-[calc((100vh-7.8vw)/2)]">
					<div className="h-[131px]">
						<img className="" src={dotLoc === 0 ? ActiveDot : Dot}></img>
						<img className="py-[10px]" src={dotLoc === 1 ? ActiveDot : Dot}></img>
						<img className="" src={dotLoc === 2 ? ActiveDot : Dot}></img>
					</div>
				</div>
			</div>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Home;