import React, { useEffect, useRef, useState } from "react";
import { Link } from "react-router-dom";
import Slider, { slickGoTo } from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import GalleryAnchor from "../../assets/img/gallery/gallery-anchor.jpg";
import Panel1 from "../../assets/img/gallery/gallery-1.jpg";
import Panel2 from "../../assets/img/gallery/gallery-2.jpg";
import Panel3 from "../../assets/img/gallery/gallery-3.jpg";
import Panel4 from "../../assets/img/gallery/gallery-4.jpg";
import Panel5 from "../../assets/img/gallery/gallery-5.jpg";
import Panel6 from "../../assets/img/gallery/gallery-6.jpg";
import Panel7 from "../../assets/img/gallery/gallery-7.jpg";
import Panel8 from "../../assets/img/gallery/gallery-8.jpg";
import Panel9 from "../../assets/img/gallery/gallery-9.jpg";
import Panel10 from "../../assets/img/gallery/gallery-10.jpg";
import Panel11 from "../../assets/img/gallery/gallery-11.jpg";
import Panel12 from "../../assets/img/gallery/gallery-12.jpg";
import Panel13 from "../../assets/img/gallery/gallery-13.jpg";
import Panel14 from "../../assets/img/gallery/gallery-14.jpg";
import Panel15 from "../../assets/img/gallery/gallery-15.jpg";
import Panel16 from "../../assets/img/gallery/gallery-16.jpg";
import Panel17 from "../../assets/img/gallery/gallery-17.jpg";
import Panel18 from "../../assets/img/gallery/gallery-18.jpg";
import Panel19 from "../../assets/img/gallery/gallery-19.jpg";
import Rendering1 from "../../assets/img/gallery/gallery-rendering-01.jpg";
import Rendering2 from "../../assets/img/gallery/gallery-rendering-02.jpg";
import Rendering3 from "../../assets/img/gallery/gallery-rendering-03.jpg";
import Rendering4 from "../../assets/img/gallery/gallery-rendering-04.jpg";
import Rendering5 from "../../assets/img/gallery/gallery-rendering-05.jpg";
import Rendering6 from "../../assets/img/gallery/gallery-rendering-06.jpg";
import Rendering7 from "../../assets/img/gallery/gallery-rendering-07.jpg";
import Rendering8 from "../../assets/img/gallery/gallery-rendering-08.jpg";
import Rendering9 from "../../assets/img/gallery/gallery-rendering-09.jpg";
import Rendering10 from "../../assets/img/gallery/gallery-rendering-10.jpg";
import './gallery.css';
import ActiveDot from "../../assets/img/home/homepage-slider-menu-navy.svg";
import Dot from "../../assets/img/home/homepage-slider-menu-beidge.svg";
import Arrow from "../../assets/img/arrow.svg";
import Close from "../../assets/img/close-btn.svg";

const Gallery = () => {
  const [slideIndex, setSlideIndex] = useState(0);
  const [slideIndex2, setSlideIndex2] = useState(2);
  const [showGallery, setShowGallery] = useState(0);
	let sliderRef1 = useRef(null);
	const settings = {
		dots: false,
		infinite: true,
		fade: true,
		arrows: false,
		autoplay: true,
		speed: 800,
		slidesToShow: 1,
		slidesToScroll: 1,
		beforeChange: (current, next) => setSlideIndex(next)
	};
	let sliderRef2 = useRef(null);
	const settings2 = {
		dots: false,
		infinite: true,
		fade: true,
		arrows: false,
		autoplay: false,
		speed: 800,
		slidesToShow: 1,
		slidesToScroll: 1,
		initialSlide: 2,
		beforeChange: (current, next) => setSlideIndex2(next)
	};
	function handleBoxClick(elem, panelgroup, goIndex) {
		const panels = document.querySelectorAll('.'+panelgroup);
		panels.forEach((panel) => {
			panel.classList.remove('active');
		});
		document.getElementById(elem).classList.add('active');
		if (slideIndex2 === goIndex) {
			setShowGallery(1);
			sliderRef1.slickPause(); 
		}
		else {
			sliderRef2.slickGoTo(goIndex);
		}
	}
	function handleArrowClick(dir) {
		if (dir === "Prev") {
			if ((slideIndex2 - 1) > 0) {
				sliderRef2.slickGoTo((slideIndex2 - 1));
				sliderRef1.slickGoTo(Math.floor((slideIndex2 - 1) / 5));
				if ((slideIndex2 % 5) > 0) {
					document.querySelectorAll('.panel'+(Math.floor(slideIndex2 / 5) + 1)).forEach((panel) => {
						panel.classList.remove('active');
					});
				}
				else {
					document.querySelectorAll('.panel'+(Math.floor(slideIndex2 / 5))).forEach((panel) => {
						panel.classList.remove('active');
					});
				}
				document.getElementById('panel' + slideIndex2).classList.add('active');
			}
			else if ((slideIndex2 - 1) === 0) {
				sliderRef2.slickGoTo(0);
				sliderRef1.slickGoTo(0);
				document.querySelectorAll('.panel1').forEach((panel) => {
						panel.classList.remove('active');
				});
				document.getElementById('panel1').classList.add('active');
			}
			else {
				sliderRef2.slickGoTo(28);
				sliderRef1.slickGoTo(5);
				document.querySelectorAll('.panel6').forEach((panel) => {
						panel.classList.remove('active');
				});
				document.getElementById('panel29').classList.add('active');
			}
		}
		else if (dir === "Next") {
			if ((slideIndex2 + 1) < 28) {
				sliderRef2.slickGoTo((slideIndex2 + 1));
				sliderRef1.slickGoTo(Math.floor((slideIndex2 + 1) / 5));
				if (((slideIndex2 + 1) % 5) > 0) {
					document.querySelectorAll('.panel'+(Math.floor((slideIndex2 + 1) / 5) + 1)).forEach((panel) => {
						panel.classList.remove('active');
					});
				}
				else {
					document.querySelectorAll('.panel'+(Math.floor((slideIndex2 + 1) / 5) + 1)).forEach((panel) => {
						panel.classList.remove('active');
					});
				}
				document.getElementById('panel' + (slideIndex2 + 2)).classList.add('active');
			}
			else if ((slideIndex2 + 1) === 28) {
				sliderRef2.slickGoTo(28);
				sliderRef1.slickGoTo(5);
				document.querySelectorAll('.panel6').forEach((panel) => {
						panel.classList.remove('active');
				});
				document.getElementById('panel29').classList.add('active');
			}
			else {
				sliderRef2.slickGoTo(0);
				sliderRef1.slickGoTo(0);
				document.querySelectorAll('.panel1').forEach((panel) => {
						panel.classList.remove('active');
				});
				document.getElementById('panel1').classList.add('active');
			}
		}
	}
	function closeGallery() {
		setShowGallery(0);
		sliderRef1.slickPlay(); 
	}
	useEffect(() => {
		document.title = 'Gallery | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
	}, []);
	
  return (
    <div className="relative w-full">
		<MainSiteHeader designSrc={GalleryAnchor}/>	

		<div className="relative pt-[50px]">
			<Slider
				ref={slider => {
				  sliderRef1 = slider;
				}}
				{...settings}
			  >
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">						
						<div className="relative cursor-pointer transition-all duration-500 panel1" id="panel1" onClick={() => (handleBoxClick("panel1", "panel1", 0))}>
							<img src={Rendering2} />
							<h4>Courtyard</h4>
							<div className="img-overlay"></div> 
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel1" id="panel2" onClick={() => (handleBoxClick("panel2", "panel1", 1))}>
							<img src={Rendering3} />
							<h4>Dining / Kitchen</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel1 active" id="panel3" onClick={() => (handleBoxClick("panel3", "panel1", 2))}>
							<img src={Rendering1} />
							<h4>Exterior</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel1" id="panel4" onClick={() => (handleBoxClick("panel4", "panel1", 3))}>
							<img src={Rendering4} />
							<h4>Kitchen / Living</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel1" id="panel5" onClick={() => (handleBoxClick("panel5", "panel1", 4))}>
							<img src={Rendering5} />
							<h4>Kitchen Details</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">						
						<div className="relative cursor-pointer transition-all duration-500 panel2 active" id="panel6" onClick={() => (handleBoxClick("panel6", "panel2", 5))}>
							<img src={Rendering6} />
							<h4>Bedroom</h4>
							<div className="img-overlay"></div> 
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel7" onClick={() => (handleBoxClick("panel7", "panel2", 6))}>
							<img src={Rendering7} />
							<h4>Bathroom</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel8" onClick={() => (handleBoxClick("panel8", "panel2", 7))}>
							<img src={Rendering8} />
							<h4>Office</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel9" onClick={() => (handleBoxClick("panel9", "panel2", 8))}>
							<img src={Rendering9} />
							<h4>Balcony</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel2" id="panel10" onClick={() => (handleBoxClick("panel10", "panel2", 9))}>
							<img src={Rendering10} />
							<h4>Dollhouse</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel11" onClick={() => (handleBoxClick("panel11", "panel3", 10))}>
							<img src={Panel2} />
							<h4>Safeway</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel12" onClick={() => (handleBoxClick("panel12", "panel3", 11))}>
							<img src={Panel3} />
							<h4>Shopping</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel3 active" id="panel13" onClick={() => (handleBoxClick("panel13", "panel3", 12))}>
							<img src={Panel1} />
							<h4>VanDusen Botanical Garden</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel14" onClick={() => (handleBoxClick("panel14", "panel3", 13))}>
							<img src={Panel4} />
							<h4>Marpole</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel3" id="panel15" onClick={() => (handleBoxClick("panel15", "panel3", 14))}>
							<img src={Panel5} />
							<h4>Red Star Seafood Restaurant</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel4 active" id="panel16" onClick={() => (handleBoxClick("panel16", "panel4", 15))}>
							<img src={Panel6} />
							<h4>Magee Secondary School</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel17" onClick={() => (handleBoxClick("panel17", "panel4", 16))}>
							<img src={Panel7} />
							<h4>Churchill Secondary School</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel18" onClick={() => (handleBoxClick("panel18", "panel4", 17))}>
							<img src={Panel8} />
							<h4>Marine Gateway</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel19" onClick={() => (handleBoxClick("panel19", "panel4", 18))}>
							<img src={Panel9} />
							<h4>Cycling along Bike Trails</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel4" id="panel20" onClick={() => (handleBoxClick("panel20", "panel4", 19))}>
							<img src={Panel10} />
							<h4>Marine Gateway</h4>
							<div className="img-overlay"></div>
						</div>	
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel5 active" id="panel21" onClick={() => (handleBoxClick("panel21", "panel5", 20))}>
							<img src={Panel11} />
							<h4>T&T Supermarket</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel5" id="panel22" onClick={() => (handleBoxClick("panel22", "panel5", 21))}>
							<img src={Panel12} />
							<h4>Langara Golf Course</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel5" id="panel23" onClick={() => (handleBoxClick("panel23", "panel5", 22))}>
							<img src={Panel13} />
							<h4>Golfing at your Doorstep</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel5" id="panel24" onClick={() => (handleBoxClick("panel24", "panel5", 23))}>
							<img src={Panel14} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel5" id="panel25" onClick={() => (handleBoxClick("panel25", "panel5", 24))}>
							<img src={Panel15} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>
					</div>
				</div>
				<div>
					<div className="flex flex-row gap-2 mb-[50px]">
						<div className="relative cursor-pointer transition-all duration-500 panel6 active" id="panel26" onClick={() => (handleBoxClick("panel26", "panel6", 25))}>
							<img src={Panel16} />
							<h4>Queen Elizabeth Park</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel6" id="panel27" onClick={() => (handleBoxClick("panel27", "panel6", 26))}>
							<img src={Panel17} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>
						<div className="relative cursor-pointer transition-all duration-500 panel6" id="panel28" onClick={() => (handleBoxClick("panel28", "panel6", 27))}>
							<img src={Panel18} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>	
						<div className="relative cursor-pointer transition-all duration-500 panel6" id="panel29" onClick={() => (handleBoxClick("panel29", "panel6", 28))}>
							<img src={Panel19} />
							<h4>McArthurGlen Designer Outlet</h4>
							<div className="img-overlay"></div>
						</div>	
					</div>
				</div>
				
			</Slider>
		</div>
		<div className="relative my-0 mx-auto flex flex-row gap-2 justify-center pb-[50px]">
			<img className="w-[30px] cursor-pointer" src={slideIndex === 0 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(0))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 1 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(1))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 2 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(2))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 3 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(3))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 4 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(4))}></img>
			<img className="w-[30px] cursor-pointer" src={slideIndex === 5 ? ActiveDot : Dot} onClick={() => (sliderRef1.slickGoTo(5))}></img>
		</div>
		<div className={`fixed top-0 left-0 h-full w-full bg-[rgba(0,0,0,0.5)] flex items-center justify-center z-10 popup-gallery ${showGallery === 1 ? "active" : ""}`}>
			<div className="absolute top-0 bottom-0 left-0 right-0" onClick={() => (closeGallery())}></div>
			
			<div className="w-full lg:w-[90vw] relative">
				<img src={Arrow} className="cursor-pointer absolute top-[100%] lg:top-[50%] translate-y-[0] lg:translate-y-[-50%] left-[50%] lg:left-0 translate-x-[-200%] lg:translate-x-[-100%] rotate-180 w-[5vw] lg:w-[2vw]" onClick={() => (handleArrowClick("Prev"))}></img>
				<img src={Arrow} className="cursor-pointer absolute top-[100%] lg:top-[50%] translate-y-[0] lg:translate-y-[-50%] right-[50%] lg:right-0 translate-x-[200%] lg:translate-x-[100%] w-[5vw] lg:w-[2vw]" onClick={() => (handleArrowClick("Next"))}></img>
				
				<Slider
					ref={slider2 => {
					  sliderRef2 = slider2;
					}}
					{...settings2}>
					<div onClick={() => (closeGallery())}>
						<img className="w-auto h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering2}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="w-auto h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering3}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="w-auto h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering1}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="w-auto h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering4}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="w-auto h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering5}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering6}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering7}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering8}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering9}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Rendering10}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel2}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel3}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel1}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel4}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel5}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel6}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel7}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel8}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel9}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel10}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel11}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel12}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel13}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel14}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel15}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel16}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel17}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel18}></img>
					</div>
					<div onClick={() => (closeGallery())}>
						<img className="h-[41vw] lg:h-[38VW] relative my-0 mx-auto" src={Panel19}></img>
					</div>
				</Slider>
			</div>
			<img src={Close} className="cursor-pointer absolute top-[25px] right-[25px] w-[5vw] lg:w-[2vw]" onClick={() => (closeGallery())}></img>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Gallery;