import React, { useEffect, useRef, useState } from "react";
import {
  Accordion,
  AccordionHeader,
  AccordionBody,
} from "@material-tailwind/react";
import courtyardMinus from "../../assets/img/floorplans/courtyard-minus-icon.svg";
import courtyardPlus from "../../assets/img/floorplans/courtyard-plus-icon.svg";
import gardenMinus from "../../assets/img/floorplans/garden-minus-icon.svg";
import gardenPlus from "../../assets/img/floorplans/garden-plus-icon.svg";
import terraceMinus from "../../assets/img/floorplans/terrace-minus-icon.svg";
import terracePlus from "../../assets/img/floorplans/terrace-plus-icon.svg";
import basePlan from "../../assets/img/floorplans/baseplan.svg";
import { floorplans } from "./floorplans";
import PDFPlanA from "../../assets/img/floorplans/W58-floorplan-A.pdf";
import PDFPlanB from "../../assets/img/floorplans/W58-floorplan-B.pdf";
import PDFPlanC from "../../assets/img/floorplans/W58-floorplan-C.pdf";
import PDFPlanD from "../../assets/img/floorplans/W58-floorplan-D.pdf";
import PDFPlanE from "../../assets/img/floorplans/W58-floorplan-E.pdf";
import PDFPlanF from "../../assets/img/floorplans/W58-floorplan-F.pdf";
import PDFPlanG from "../../assets/img/floorplans/W58-floorplan-G.pdf";
import PDFPlanFull from "../../assets/img/floorplans/W58-floorplan-full.pdf";

const Plans = () => {  
	const [open, setOpen] = React.useState(1);
	const handleOpen = (value) => { 
		setOpenPlan(1);
		setOpen(open === value ? 0 : value);		
	}
	const [selectedCat, setSelectedCat] = useState("garden");
	const [openPlan, setOpenPlan] = useState(1);

	useEffect(() => {

		return () => {
		};
	}, []);	
  return (
	<div className="relative flex flex-col-reverse lg:flex-row px-[25px] lg:px-[10vw] py-[50px]">
		<div className="w-full lg:w-[35%] pr-[10vw]">
			{floorplans.map(({ category, catLabel, planDetails }, i) => (
			  <Accordion open={open === i + 1} className=" pb-[25px]" key={i}>
				<AccordionHeader
				  className="border-0 py-0"
				  onClick={() => {
					handleOpen(i + 1);
					setSelectedCat(category);
				  }}
				>
					<div className="flex flex-row items-center">
						{ category === "garden" && <img src={selectedCat === "garden" ? gardenMinus : gardenPlus} className="flex-none w-[25px]"></img> }
						{ category === "terrace" && <img src={selectedCat === "terrace" ? terraceMinus : terracePlus} className="flex-none w-[25px]"></img> }
						{ category === "courtyard" && <img src={selectedCat === "courtyard" ? courtyardMinus : courtyardPlus} className="flex-none w-[25px]"></img> }						
						<h3 className="flex-1 pl-[15px] font-normal text-[#394544]">{catLabel}</h3>
					</div>
				</AccordionHeader>
				<AccordionBody className="py-0 pt-[12px]">

					{planDetails.map(({ name, bedroom, interior, exterior, storage, total }, j) => (
						
						
						<div key={j} className="relative cursor-pointer pl-[40px] text-base w-[270px]">
							<Accordion open={openPlan === j + 1} key={j}>
								<AccordionHeader
								  className={`border-b-[1px] border-b-solid py-0 pt-[10px] font-normal after:text-[#394544] after:text-xxl ${openPlan === j + 1 ? "after:content-['-']" : "after:content-['+']"}`}
								  onClick={() => {
									setOpenPlan(openPlan === (j + 1) ? 0 : (j + 1));
								  }}
								>
									{name}
								</AccordionHeader>
								<AccordionBody className="py-0">
									<ul className="py-[15px] text-base">
										<li>{bedroom}</li>
										<li>{interior}</li>
										<li>{exterior}</li>
										{ storage != "" && <li>{storage}</li> }
										<li>{total}</li>
										{name === "Plan A" && 
										<a href={PDFPlanA} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan B" && 
										<a href={PDFPlanB} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan C" && 
										<a href={PDFPlanC} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan D" && 
										<a href={PDFPlanD} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan E" && 
										<a href={PDFPlanE} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan F" && 
										<a href={PDFPlanF} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
										{name === "Plan G" && 
										<a href={PDFPlanG} target="_blank"><li className="pt-[10px] font-bold">Download {name} &#8594;</li></a>
										}
									</ul>
								</AccordionBody>
							</Accordion>
						</div>
					))}
				</AccordionBody>
			  </Accordion>
			))}
			<div className="relative">			
				<a href={PDFPlanFull} target="_blank"><h3 className="font-normal text-[#394544]">Download All Plans &#8594;</h3></a>
			</div>
		</div>
		<div className="relative w-full lg:w-[65%] pb-[50px] lg:pb-0">
			<img src={basePlan} className="w-[99.7%]"></img>
			<div className="absolute top-0 w-full h-full">
				<svg 
						  xmlns="http://www.w3.org/2000/svg"
						  xmlSpace="preserve"
						  x="0px" 
						  y="0px"
						  viewBox="0 0 2500 2053.79"
						  style={{
						  shapeRendering: "geometricPrecision",
						  textRendering: "geometricPrecision",
						  imageRendering: "optimizeQuality",
						  width: "100%",
						}} 
					  >
						<defs>
						  <style>
							{".cls-1, .cls-9 {fill: none;}.cls-2 {fill: #a1b0ae;}.cls-3, .cls-6, .cls-8 {fill: #fff;}.cls-10, .cls-14, .cls-15, .cls-3, .cls-5, .cls-7, .cls-8 {stroke: #373435;}.cls-12, .cls-13, .cls-14, .cls-3, .cls-5 {stroke-miterlimit: 10;}.cls-10, .cls-11, .cls-14, .cls-15, .cls-3, .cls-5, .cls-7, .cls-8 {fill-rule: evenodd;}.cls-4 {fill: #373435;}.cls-5, .cls-7 {fill: #7eaea5;}.cls-7 {stroke-miterlimit: 8.15;}.cls-10, .cls-11, .cls-15, .cls-8, .cls-9 {stroke-miterlimit: 5.601;}.cls-10, .cls-11, .cls-8, .cls-9 {stroke-width: 2.084px;}.cls-9 {stroke: #bdbfc1;}.cls-10, .cls-11 {fill: #394544;}.cls-11 {stroke: #fff;}.cls-12, .cls-13 {fill: #e6e7e8;}.cls-12 {stroke: #96989a;stroke-width: 0.9px;}.cls-13 {stroke: #d2d3d5;stroke-width: 2.083px;}.cls-14, .cls-15 {fill: #a88b67;}"}
						  </style>

						</defs>
					
					<g id="Header">
						<g id="Courtyard-Header" className={`${selectedCat === "courtyard" ? "" : "hidden"}`}>
						  <path className="cls-2" d="M482.885,95.762c-8.15,0-16.3-2.037-22.412-6.112-4.075-2.038-10.188-8.15-12.225-14.263a34.42,34.42,0,0,1-6.113-20.375c0-10.187,2.038-16.3,6.113-22.412,2.037-6.113,8.15-12.225,12.225-14.263,6.112-4.075,14.262-6.112,22.412-6.112s16.3,2.037,22.412,8.15q9.169,6.112,12.225,18.337h-16.3c-2.038-4.075-4.075-6.112-6.113-10.187-4.075-2.038-8.15-2.038-14.262-2.038s-12.225,2.038-16.3,6.113c-4.075,6.112-6.113,12.225-6.113,22.412a34.42,34.42,0,0,0,6.113,20.375c4.075,4.075,10.187,6.113,16.3,6.113s10.187,0,14.262-2.038c2.038-4.075,4.075-6.112,6.113-10.187h16.3Q514.467,81.5,505.3,87.612C499.185,93.725,491.035,95.762,482.885,95.762Z"/>
						  <path id="_1" data-name="1" className="cls-2" d="M568.46,95.762c-8.15,0-16.3-2.037-22.413-6.112a47.6,47.6,0,0,1-14.262-14.263,73.225,73.225,0,0,1-4.075-22.412c0-8.15,2.037-14.263,4.075-20.375,4.075-6.113,8.15-12.225,14.262-14.263,6.113-4.075,14.263-6.112,22.413-6.112a34.422,34.422,0,0,1,20.375,6.112c6.112,2.038,10.187,8.15,14.262,14.263,2.037,6.112,4.075,12.225,4.075,20.375A73.255,73.255,0,0,1,603.1,75.387,47.6,47.6,0,0,1,588.835,89.65,34.422,34.422,0,0,1,568.46,95.762Zm0-14.262q9.168,0,18.337-6.113c4.075-6.112,6.113-12.225,6.113-22.412A34.42,34.42,0,0,0,586.8,32.6q-9.168-6.113-18.337-6.113-12.225,0-18.338,6.113c-6.112,6.112-8.15,12.225-8.15,20.375,0,10.187,2.038,16.3,8.15,22.412Q556.235,81.5,568.46,81.5Z"/>
						  <path id="_2" data-name="2" className="cls-2" d="M652,95.762a38.375,38.375,0,0,1-16.3-4.075c-4.075-2.037-8.15-6.112-12.225-10.187A40.681,40.681,0,0,1,619.4,63.162v-48.9h16.3v48.9c0,6.113,0,10.188,4.075,14.263C641.809,79.462,645.884,81.5,652,81.5s10.187-2.038,12.225-4.075c4.075-4.075,4.075-8.15,4.075-14.263v-48.9h16.3v48.9q0,12.225-6.113,18.338A24.544,24.544,0,0,1,668.3,91.687C662.184,93.725,658.109,95.762,652,95.762Z"/>
						  <path id="_3" data-name="3" className="cls-2" d="M698.859,93.725V14.262h28.525c6.112,0,12.225,0,16.3,2.038a24.544,24.544,0,0,1,10.187,10.187c2.038,4.075,2.038,8.15,2.038,12.225s0,8.15-4.075,12.225a20.873,20.873,0,0,1-12.225,10.188l18.337,32.6H739.609L725.346,63.162H713.121V93.725Zm14.262-42.788h14.263c4.075,0,8.15,0,10.187-2.037,2.038-4.075,4.075-6.113,4.075-10.188s-2.037-6.112-4.075-10.187c-2.037-2.038-6.112-2.038-10.187-2.038H713.121Z"/>
						  <polygon id="_4" data-name="4" className="cls-2" points="788.509 93.725 788.509 26.487 766.096 26.487 766.096 14.262 827.221 14.262 827.221 26.487 802.771 26.487 802.771 93.725 788.509 93.725"/>
						  <polygon id="_5" data-name="5" className="cls-2" points="857.783 93.725 857.783 65.2 831.296 14.262 847.596 14.262 865.933 50.937 884.271 14.262 900.571 14.262 872.046 65.2 872.046 93.725 857.783 93.725"/>
						  <path id="_6" data-name="6" className="cls-2" d="M894.458,93.725,925.02,14.262h16.3l28.525,79.463h-16.3l-6.112-18.338H916.87l-6.112,18.338Zm26.487-30.563h22.413l-12.225-32.6Z"/>
						  <path id="_7" data-name="7" className="cls-2" d="M980.033,93.725V14.262h28.524c8.15,0,12.225,0,16.3,2.038a24.552,24.552,0,0,1,10.188,10.187c2.037,4.075,2.037,8.15,2.037,12.225s0,8.15-4.075,12.225a24.552,24.552,0,0,1-10.187,10.188l16.3,32.6h-18.338L1006.52,63.162H994.3V93.725ZM994.3,50.937h14.262c4.075,0,8.15,0,10.188-2.037,2.037-4.075,4.075-6.113,4.075-10.188s-2.038-6.112-4.075-10.187c-2.038-2.038-6.113-2.038-10.188-2.038H994.3Z"/>
						  <path id="_8" data-name="8" className="cls-2" d="M1051.345,93.725V14.262h26.487a76,76,0,0,1,24.45,4.075c6.113,4.075,10.187,8.15,12.225,14.263a34.42,34.42,0,0,1,6.112,20.375c0,8.15-2.037,16.3-6.112,22.412-2.038,6.113-6.112,10.188-12.225,14.263a76,76,0,0,1-24.45,4.075ZM1065.607,81.5h12.225a38.39,38.39,0,0,0,16.3-4.075,15.908,15.908,0,0,0,8.15-8.15c2.038-4.075,2.038-10.188,2.038-16.3,0-4.075,0-10.188-2.038-14.263a15.908,15.908,0,0,0-8.15-8.15c-4.075-4.075-10.187-4.075-16.3-4.075h-12.225Z"/>
						  <path id="_9" data-name="9" className="cls-2" d="M1196.007,95.762a34.42,34.42,0,0,1-20.375-6.112c-6.113-2.038-10.188-8.15-14.263-14.263-2.037-6.112-4.075-12.225-4.075-20.375,0-10.187,2.038-16.3,4.075-22.412,4.075-6.113,8.15-12.225,14.263-14.263a34.42,34.42,0,0,1,20.375-6.112c10.187,0,18.337,2.037,24.449,8.15,6.113,4.075,10.188,10.187,10.188,18.337h-16.3c0-4.075-2.038-6.112-6.112-10.187-2.038-2.038-6.113-2.038-12.225-2.038-8.15,0-12.225,2.038-16.3,6.113-6.113,6.112-8.15,12.225-8.15,22.412,0,8.15,2.037,14.263,8.15,20.375,4.075,4.075,8.15,6.113,16.3,6.113,6.112,0,10.187,0,12.225-2.038,4.074-4.075,6.112-6.112,6.112-10.187h16.3c0,8.15-4.075,14.262-10.188,18.337C1214.344,93.725,1206.194,95.762,1196.007,95.762Z"/>
						  <path id="_10" data-name="10" className="cls-2" d="M1281.581,95.762a34.422,34.422,0,0,1-20.375-6.112,47.6,47.6,0,0,1-14.262-14.263c-4.075-6.112-6.113-14.262-6.113-22.412a34.42,34.42,0,0,1,6.113-20.375c4.075-6.113,8.15-12.225,14.262-14.263a34.422,34.422,0,0,1,20.375-6.112c8.15,0,16.3,2.037,20.375,6.112A24.61,24.61,0,0,1,1316.218,32.6a34.42,34.42,0,0,1,6.113,20.375c0,8.15-2.038,16.3-6.113,22.412-2.037,6.113-8.149,10.188-14.262,14.263C1297.881,93.725,1289.731,95.762,1281.581,95.762Zm0-14.262q12.225,0,18.338-6.113c4.075-6.112,6.112-12.225,6.112-22.412a34.42,34.42,0,0,0-6.112-20.375q-6.112-6.113-18.338-6.113T1263.244,32.6a34.42,34.42,0,0,0-6.113,20.375c0,10.187,2.038,16.3,6.113,22.412Q1269.356,81.5,1281.581,81.5Z"/>
						  <polygon id="_11" data-name="11" className="cls-2" points="1334.556 93.725 1334.556 14.262 1348.818 14.262 1348.818 81.5 1385.493 81.5 1385.493 93.725 1334.556 93.725"/>
						  <polygon id="_12" data-name="12" className="cls-2" points="1397.718 93.725 1397.718 14.262 1411.98 14.262 1411.98 81.5 1448.655 81.5 1448.655 93.725 1397.718 93.725"/>
						  <polygon id="_13" data-name="13" className="cls-2" points="1460.88 93.725 1460.88 14.262 1513.855 14.262 1513.855 26.487 1475.143 26.487 1475.143 46.862 1509.78 46.862 1509.78 59.087 1475.143 59.087 1475.143 81.5 1513.855 81.5 1513.855 93.725 1460.88 93.725"/>
						  <path id="_14" data-name="14" className="cls-2" d="M1562.755,95.762a34.42,34.42,0,0,1-20.375-6.112c-6.113-2.038-10.188-8.15-12.225-14.263a34.42,34.42,0,0,1-6.113-20.375c0-10.187,2.038-16.3,6.113-22.412,2.037-6.113,6.112-12.225,12.225-14.263a34.42,34.42,0,0,1,20.375-6.112c10.187,0,18.337,2.037,24.45,8.15q9.168,6.112,12.225,18.337h-16.3c-2.038-4.075-4.075-6.112-6.113-10.187-4.075-2.038-8.15-2.038-14.262-2.038s-12.225,2.038-16.3,6.113c-4.075,6.112-6.113,12.225-6.113,22.412a34.42,34.42,0,0,0,6.113,20.375c4.075,4.075,10.187,6.113,16.3,6.113s10.187,0,14.262-2.038c2.038-4.075,4.075-6.112,6.113-10.187h16.3q-3.057,12.225-12.225,18.337C1581.092,93.725,1572.942,95.762,1562.755,95.762Z"/>
						  <polygon id="_15" data-name="15" className="cls-2" points="1629.992 93.725 1629.992 26.487 1605.542 26.487 1605.542 14.262 1666.667 14.262 1666.667 26.487 1644.254 26.487 1644.254 93.725 1629.992 93.725"/>
						  <polygon id="_16" data-name="16" className="cls-2" points="1678.892 93.725 1678.892 14.262 1693.154 14.262 1693.154 93.725 1678.892 93.725"/>
						  <path id="_17" data-name="17" className="cls-2" d="M1746.129,95.762a34.42,34.42,0,0,1-20.375-6.112c-6.113-4.075-12.225-8.15-14.262-14.263-4.075-6.112-6.113-14.262-6.113-22.412a34.42,34.42,0,0,1,6.113-20.375,24.61,24.61,0,0,1,14.262-14.263,37.017,37.017,0,0,1,40.75,0A24.612,24.612,0,0,1,1780.766,32.6a34.42,34.42,0,0,1,6.113,20.375c0,8.15-2.038,16.3-6.113,22.412-2.037,6.113-8.15,10.188-14.262,14.263A34.422,34.422,0,0,1,1746.129,95.762Zm0-14.262q12.225,0,18.337-6.113c4.075-6.112,6.113-12.225,6.113-22.412a34.42,34.42,0,0,0-6.113-20.375q-6.112-6.113-18.337-6.113T1727.791,32.6a34.42,34.42,0,0,0-6.112,20.375c0,10.187,2.037,16.3,6.112,22.412Q1733.9,81.5,1746.129,81.5Z"/>
						  <polygon id="_18" data-name="18" className="cls-2" points="1799.104 93.725 1799.104 14.262 1813.366 14.262 1852.078 69.275 1852.078 14.262 1866.341 14.262 1866.341 93.725 1852.078 93.725 1813.366 36.675 1813.366 93.725 1799.104 93.725"/>
						</g>
						<g id="Garden-Header" className={`${selectedCat === "garden" ? "" : "hidden"}`}>
						  <path className="cls-2" d="M587.87,95.3c-7,0-14-1.4-19.6-5.6-5.6-2.8-9.8-8.4-12.6-14s-4.2-14-4.2-21a58.053,58.053,0,0,1,4.2-22.4c2.8-5.6,8.4-11.2,14-15.4q8.4-4.2,21-4.2c9.8,0,16.8,1.4,23.8,5.6,5.6,5.6,9.8,11.2,11.2,19.6h-15.4a14.339,14.339,0,0,0-7-8.4q-4.2-4.2-12.6-4.2c-8.4,0-14,2.8-18.2,8.4-4.2,4.2-7,11.2-7,21,0,8.4,2.8,15.4,7,19.6a19.959,19.959,0,0,0,16.8,8.4c8.4,0,12.6-2.8,16.8-7,4.2-2.8,5.6-8.4,7-15.4h-21v-11.2h35V93.9h-12.6l-1.4-11.2a32.716,32.716,0,0,1-9.8,9.8A43.228,43.228,0,0,1,587.87,95.3Z"/>
						  <path id="_1-2" data-name="1" className="cls-2" d="M636.876,93.9l29.4-79.809h16.8l29.4,79.809h-16.8l-5.6-18.2h-30.8l-7,18.2Zm25.2-30.8h23.8l-11.2-32.2Z"/>
						  <path id="_2-2" data-name="2" className="cls-2" d="M722.286,93.9V14.089h29.4c7,0,11.2,0,15.4,2.8a60.947,60.947,0,0,1,9.8,8.4c1.4,4.2,2.8,8.4,2.8,12.6a23.654,23.654,0,0,1-4.2,14c-1.4,4.2-5.6,7-11.2,8.4l16.8,33.6h-16.8l-15.4-32.2h-12.6V93.9Zm14-42h14c5.6,0,8.4-1.4,11.2-4.2s2.8-5.6,2.8-9.8c0-2.8,0-7-2.8-8.4-2.8-2.8-5.6-4.2-11.2-4.2h-14Z"/>
						  <path id="_3-2" data-name="3" className="cls-2" d="M793.7,93.9V14.089h26.6c9.8,0,18.2,1.4,23.8,4.2,5.6,4.2,11.2,8.4,14,14s4.2,12.6,4.2,21-1.4,15.4-4.2,21c-2.8,7-8.4,11.2-14,14-5.6,4.2-14,5.6-23.8,5.6Zm14-12.6h12.6c7,0,12.6-1.4,15.4-2.8,4.2-2.8,7-5.6,8.4-9.8a50.337,50.337,0,0,0,2.8-15.4c0-5.6-1.4-9.8-2.8-14s-4.2-7-8.4-9.8c-2.8-2.8-8.4-2.8-15.4-2.8H807.7Z"/>
						  <polygon id="_4-2" data-name="4" className="cls-2" points="874.905 93.898 874.905 14.089 926.711 14.089 926.711 25.29 888.906 25.29 888.906 47.693 923.91 47.693 923.91 58.894 888.906 58.894 888.906 81.297 926.711 81.297 926.711 93.898 874.905 93.898"/>
						  <polygon id="_5-2" data-name="5" className="cls-2" points="940.712 93.898 940.712 14.089 956.114 14.089 993.919 70.095 993.919 14.089 1007.92 14.089 1007.92 93.898 993.919 93.898 956.114 37.892 956.114 93.898 940.712 93.898"/>
						  <path id="_6-2" data-name="6" className="cls-2" d="M1087.73,95.3c-8.4,0-15.4-1.4-21-5.6a33.744,33.744,0,0,1-14-14,58.053,58.053,0,0,1-4.2-22.4c0-7,1.4-15.4,4.2-21,2.8-7,8.4-11.2,14-15.4q8.4-4.2,21-4.2c8.4,0,16.8,1.4,23.8,7,5.6,4.2,9.8,11.2,11.2,19.6h-16.8c-1.4-4.2-2.8-7-5.6-9.8a23.651,23.651,0,0,0-14-4.2,19.958,19.958,0,0,0-16.8,8.4c-4.2,4.2-5.6,11.2-5.6,19.6,0,9.8,1.4,16.8,5.6,21,4.2,5.6,9.8,7,16.8,7,5.6,0,9.8,0,14-2.8,2.8-2.8,4.2-5.6,5.6-9.8h16.8c-1.4,8.4-5.6,15.4-11.2,19.6A47.207,47.207,0,0,1,1087.73,95.3Z"/>
						  <path id="_7-2" data-name="7" className="cls-2" d="M1173.14,95.3c-8.4,0-15.4-1.4-21-5.6a33.744,33.744,0,0,1-14-14c-4.2-7-5.6-14-5.6-22.4s1.4-15.4,5.6-21c2.8-7,8.4-11.2,14-15.4q8.4-4.2,21-4.2a56.191,56.191,0,0,1,21,4.2,49.95,49.95,0,0,1,14,15.4q4.2,8.4,4.2,21a58.053,58.053,0,0,1-4.2,22.4c-4.2,5.6-8.4,11.2-14,14A39.518,39.518,0,0,1,1173.14,95.3Zm0-14c7,0,14-1.4,18.2-7s7-11.2,7-21a34.388,34.388,0,0,0-7-21c-4.2-4.2-11.2-7-18.2-7-8.4,0-14,2.8-18.2,7-5.6,5.6-7,12.6-7,21,0,9.8,1.4,15.4,7,21C1159.139,79.9,1164.739,81.3,1173.14,81.3Z"/>
						  <polygon id="_8-2" data-name="8" className="cls-2" points="1226.347 93.898 1226.347 14.089 1240.348 14.089 1240.348 82.697 1275.353 82.697 1275.353 93.898 1226.347 93.898"/>
						  <polygon id="_9-2" data-name="9" className="cls-2" points="1289.354 93.898 1289.354 14.089 1303.356 14.089 1303.356 82.697 1339.76 82.697 1339.76 93.898 1289.354 93.898"/>
						  <polygon id="_10-2" data-name="10" className="cls-2" points="1352.362 93.898 1352.362 14.089 1404.168 14.089 1404.168 25.29 1366.363 25.29 1366.363 47.693 1401.368 47.693 1401.368 58.894 1366.363 58.894 1366.363 81.297 1404.168 81.297 1404.168 93.898 1352.362 93.898"/>
						  <path id="_11-2" data-name="11" className="cls-2" d="M1454.574,95.3c-8.4,0-15.4-1.4-21-5.6-5.6-2.8-9.8-8.4-12.6-14-4.2-7-5.6-14-5.6-22.4,0-7,1.4-15.4,5.6-21,2.8-7,7-11.2,12.6-15.4q8.4-4.2,21-4.2c9.8,0,16.8,1.4,23.8,7,5.6,4.2,9.8,11.2,11.2,19.6h-15.4c-1.4-4.2-4.2-7-7-9.8s-7-4.2-12.6-4.2c-7,0-14,2.8-18.2,8.4-4.2,4.2-5.6,11.2-5.6,19.6,0,9.8,1.4,16.8,5.6,21,4.2,5.6,11.2,7,18.2,7,5.6,0,9.8,0,12.6-2.8s5.6-5.6,7-9.8h15.4c-1.4,8.4-5.6,15.4-11.2,19.6C1471.376,92.5,1464.375,95.3,1454.574,95.3Z"/>
						  <polygon id="_12-2" data-name="12" className="cls-2" points="1520.382 93.898 1520.382 25.29 1496.579 25.29 1496.579 14.089 1558.187 14.089 1558.187 25.29 1534.384 25.29 1534.384 93.898 1520.382 93.898"/>
						  <polygon id="_13-2" data-name="13" className="cls-2" points="1569.388 93.898 1569.388 14.089 1583.39 14.089 1583.39 93.898 1569.388 93.898"/>
						  <path id="_14-2" data-name="14" className="cls-2" d="M1636.6,95.3a39.518,39.518,0,0,1-21-5.6c-5.6-2.8-9.8-8.4-14-14a58.035,58.035,0,0,1-4.2-22.4q0-12.6,4.2-21a49.936,49.936,0,0,1,14-15.4,56.191,56.191,0,0,1,21-4.2q12.6,0,21,4.2c7,4.2,11.2,8.4,14,15.4,4.2,5.6,5.6,12.6,5.6,21s-1.4,15.4-5.6,22.4c-2.8,5.6-7,11.2-14,14C1652,93.9,1645,95.3,1636.6,95.3Zm0-14c8.4,0,14-1.4,18.2-7,5.6-5.6,7-11.2,7-21,0-8.4-1.4-15.4-7-21-4.2-4.2-9.8-7-18.2-7-7,0-14,2.8-18.2,7a34.388,34.388,0,0,0-7,21c0,9.8,2.8,15.4,7,21S1629.6,81.3,1636.6,81.3Z"/>
						  <polygon id="_15-2" data-name="15" className="cls-2" points="1689.802 93.898 1689.802 14.089 1705.204 14.089 1743.009 70.095 1743.009 14.089 1757.01 14.089 1757.01 93.898 1743.009 93.898 1705.204 37.892 1705.204 93.898 1689.802 93.898"/>
						</g>
						<g id="Terrace-Header" className={`${selectedCat === "terrace" ? "" : "hidden"}`}>
						  <polygon className="cls-2" points="557.245 94.068 557.245 25.685 533.865 25.685 533.865 13.919 595.359 13.919 595.359 25.685 571.877 25.685 571.877 94.068 557.245 94.068"/>
						  <polygon id="_1-3" data-name="1" className="cls-2" points="606.22 94.068 606.22 13.919 658.563 13.919 658.563 25.685 620.902 25.685 620.902 47.708 655.144 47.708 655.144 59.122 620.902 59.122 620.902 82.252 658.563 82.252 658.563 94.068 606.22 94.068"/>
						  <path id="_2-3" data-name="2" className="cls-2" d="M672.39,94.068V13.919h29.465c6.386,0,11.665,1.056,15.839,3.268a21.348,21.348,0,0,1,9.3,8.8,24.919,24.919,0,0,1,3.117,12.319,24.393,24.393,0,0,1-3.821,13.375c-2.564,4.072-6.537,6.989-11.967,8.849l16.593,33.538H714.074L699.19,62.441H687.072V94.068Zm14.682-42.387H700.9c4.927,0,8.5-1.157,10.76-3.52a12.917,12.917,0,0,0,3.469-9.4,12.583,12.583,0,0,0-3.368-9.151c-2.263-2.313-5.934-3.47-10.962-3.47H687.072Z"/>
						  <path id="_3-3" data-name="3" className="cls-2" d="M743.74,94.068V13.919h29.414c6.436,0,11.716,1.056,15.839,3.268a21.752,21.752,0,0,1,9.352,8.8,24.909,24.909,0,0,1,3.118,12.319,24.43,24.43,0,0,1-3.872,13.375c-2.564,4.072-6.536,6.989-11.967,8.849l16.593,33.538H785.423L770.54,62.441H758.372V94.068Zm14.632-42.387h13.877c4.878,0,8.448-1.157,10.761-3.52a13.1,13.1,0,0,0,3.419-9.4c0-3.821-1.107-6.888-3.369-9.151-2.263-2.313-5.883-3.47-10.911-3.47H758.372Z"/>
						  <path id="_4-3" data-name="4" className="cls-2" d="M809.91,94.068l29.314-80.149h16.493l29.314,80.149H869.443l-6.385-18.554H831.783l-6.537,18.554ZM835.805,64.05h23.23L847.37,30.763Z"/>
						  <path id="_5-3" data-name="5" className="cls-2" d="M927.016,95.425c-8.095,0-15.034-1.709-20.817-5.229a34.633,34.633,0,0,1-13.375-14.531A46.846,46.846,0,0,1,888.1,54.094a47.2,47.2,0,0,1,4.726-21.621A35.027,35.027,0,0,1,906.2,17.791c5.783-3.52,12.722-5.23,20.817-5.23,9.654,0,17.5,2.364,23.682,7.14q9.2,7.166,11.465,20.063H946.022a17.1,17.1,0,0,0-6.335-10.207c-3.269-2.514-7.542-3.721-12.872-3.721-7.392,0-13.224,2.514-17.4,7.542-4.223,5.028-6.335,11.967-6.335,20.716q0,13.2,6.335,20.666c4.174,4.978,10.006,7.492,17.4,7.492,5.33,0,9.6-1.157,12.872-3.47a16.2,16.2,0,0,0,6.335-9.7h16.141c-1.509,8.246-5.33,14.732-11.465,19.358C944.514,93.112,936.67,95.425,927.016,95.425Z"/>
						  <polygon id="_6-3" data-name="6" className="cls-2" points="975.135 94.068 975.135 13.919 1027.428 13.919 1027.428 25.685 989.767 25.685 989.767 47.708 1024.009 47.708 1024.009 59.122 989.767 59.122 989.767 82.252 1027.428 82.252 1027.428 94.068 975.135 94.068"/>
						  <path id="_7-3" data-name="7" className="cls-2" d="M1104.811,95.425c-8.045,0-15.034-1.709-20.816-5.229a34.62,34.62,0,0,1-13.375-14.531,46.833,46.833,0,0,1-4.727-21.571,47.191,47.191,0,0,1,4.727-21.621,35.014,35.014,0,0,1,13.375-14.682c5.782-3.52,12.771-5.23,20.816-5.23,9.654,0,17.5,2.364,23.683,7.14q9.2,7.166,11.514,20.063h-16.19a16.871,16.871,0,0,0-6.336-10.207c-3.218-2.514-7.542-3.721-12.872-3.721-7.391,0-13.224,2.514-17.4,7.542-4.224,5.028-6.285,11.967-6.285,20.716,0,8.8,2.061,15.688,6.285,20.666,4.173,4.978,10.006,7.492,17.4,7.492,5.33,0,9.654-1.157,12.872-3.47a15.985,15.985,0,0,0,6.336-9.7h16.19c-1.558,8.246-5.38,14.732-11.514,19.358C1122.309,93.112,1114.465,95.425,1104.811,95.425Z"/>
						  <path id="_8-3" data-name="8" className="cls-2" d="M1190.491,95.425c-8.045,0-15.034-1.759-21.018-5.279A37.058,37.058,0,0,1,1155.4,75.564a44.127,44.127,0,0,1-5.129-21.571,43.852,43.852,0,0,1,5.129-21.57,37.183,37.183,0,0,1,14.078-14.632c5.984-3.52,12.973-5.23,21.018-5.23a40.637,40.637,0,0,1,20.917,5.23,36.515,36.515,0,0,1,14.079,14.632,44.4,44.4,0,0,1,5.078,21.57,44.676,44.676,0,0,1-5.078,21.571,36.393,36.393,0,0,1-14.079,14.582A40.66,40.66,0,0,1,1190.491,95.425Zm0-13.173c7.593,0,13.727-2.514,18.252-7.543s6.788-11.967,6.788-20.716c0-8.8-2.262-15.687-6.788-20.716-4.525-5.078-10.659-7.592-18.252-7.592-7.643,0-13.777,2.514-18.353,7.592-4.575,5.029-6.838,11.917-6.838,20.716,0,8.749,2.263,15.688,6.838,20.716S1182.848,82.252,1190.491,82.252Z"/>
						  <polygon id="_9-3" data-name="9" className="cls-2" points="1243.488 94.068 1243.488 13.919 1258.12 13.919 1258.12 82.604 1293.618 82.604 1293.618 94.068 1243.488 94.068"/>
						  <polygon id="_10-3" data-name="10" className="cls-2" points="1306.541 94.068 1306.541 13.919 1321.223 13.919 1321.223 82.604 1356.722 82.604 1356.722 94.068 1306.541 94.068"/>
						  <polygon id="_11-3" data-name="11" className="cls-2" points="1369.644 94.068 1369.644 13.919 1421.987 13.919 1421.987 25.685 1384.326 25.685 1384.326 47.708 1418.518 47.708 1418.518 59.122 1384.326 59.122 1384.326 82.252 1421.987 82.252 1421.987 94.068 1369.644 94.068"/>
						  <path id="_12-3" data-name="12" className="cls-2" d="M1472.118,95.425c-8.1,0-15.034-1.709-20.817-5.229a34.431,34.431,0,0,1-13.425-14.531,47.477,47.477,0,0,1-4.676-21.571,47.841,47.841,0,0,1,4.676-21.621A34.819,34.819,0,0,1,1451.3,17.791c5.783-3.52,12.722-5.23,20.817-5.23q14.406,0,23.632,7.14c6.134,4.777,10.006,11.465,11.515,20.063h-16.141a17.336,17.336,0,0,0-6.335-10.207c-3.269-2.514-7.542-3.721-12.923-3.721-7.391,0-13.173,2.514-17.4,7.542-4.173,5.028-6.285,11.967-6.285,20.716,0,8.8,2.112,15.688,6.285,20.666,4.224,4.978,10.006,7.492,17.4,7.492,5.381,0,9.654-1.157,12.923-3.47a16.425,16.425,0,0,0,6.335-9.7h16.141c-1.509,8.246-5.381,14.732-11.515,19.358Q1486.549,95.45,1472.118,95.425Z"/>
						  <polygon id="_13-3" data-name="13" className="cls-2" points="1537.836 94.068 1537.836 25.685 1514.455 25.685 1514.455 13.919 1575.949 13.919 1575.949 25.685 1552.468 25.685 1552.468 94.068 1537.836 94.068"/>
						  <polygon id="_14-3" data-name="14" className="cls-2" points="1586.81 94.068 1586.81 13.919 1601.492 13.919 1601.492 94.068 1586.81 94.068"/>
						  <path id="_15-3" data-name="15" className="cls-2" d="M1654.589,95.425a40.59,40.59,0,0,1-20.967-5.279,36.724,36.724,0,0,1-14.079-14.582,44.138,44.138,0,0,1-5.128-21.571,43.863,43.863,0,0,1,5.128-21.57,36.847,36.847,0,0,1,14.079-14.632c5.984-3.52,12.973-5.23,20.967-5.23a40.824,40.824,0,0,1,20.968,5.23,36.847,36.847,0,0,1,14.079,14.632c3.369,6.184,5.028,13.375,5.028,21.57a44.658,44.658,0,0,1-5.028,21.571,36.724,36.724,0,0,1-14.079,14.582A40.846,40.846,0,0,1,1654.589,95.425Zm0-13.173c7.643,0,13.727-2.514,18.3-7.543,4.525-5.028,6.788-11.967,6.788-20.716,0-8.8-2.263-15.687-6.788-20.716-4.576-5.078-10.66-7.592-18.3-7.592-7.592,0-13.726,2.514-18.3,7.592-4.576,5.029-6.889,11.917-6.889,20.716,0,8.749,2.313,15.688,6.889,20.716S1647,82.252,1654.589,82.252Z"/>
						  <polygon id="_16-2" data-name="16" className="cls-2" points="1707.636 94.068 1707.636 13.919 1722.268 13.919 1759.929 70.335 1759.929 13.919 1774.611 13.919 1774.611 94.068 1759.929 94.068 1722.268 37.702 1722.268 94.068 1707.636 94.068"/>
						</g>
					</g>
					<g id="CourtyardPlans" className={`${selectedCat === "courtyard" ? "" : "hidden"}`}>
						<g id="Base-DEFG">
						  <g id="D">
							<polygon className="cls-3" points="2363.817 448.85 2396.701 448.85 2395.844 703.011 2081.886 703.011 2082.744 450.545 2081.465 322.959 2222.505 322.959 2222.505 301.238 2338.093 301.238 2338.093 322.959 2363.917 322.959 2363.817 448.85"/>
						  </g>
						  <g id="E">
							<polygon className="cls-3" points="131.606 280.241 161.121 280.241 161.121 265.76 251.024 265.76 251.024 280.241 365.364 280.241 365.364 593.596 365.364 673.191 365.364 702.154 271.891 702.154 271.891 673.191 131.606 673.191 131.606 280.241"/>
						  </g>
						  <g id="E-2" data-name="E">
							<polygon className="cls-3" points="599.173 280.241 480.057 280.241 480.057 265.76 385.427 265.76 385.427 280.241 365.364 280.241 365.364 673.191 505.65 673.191 505.65 702.154 599.173 702.154 599.173 673.191 599.173 593.596 599.173 280.241"/>
						  </g>
						  <g id="E-3" data-name="E">
							<polygon className="cls-3" points="599.173 280.241 619.186 280.241 619.186 265.76 713.815 265.76 713.815 280.241 832.932 280.241 832.932 593.596 832.932 673.191 832.932 702.154 739.409 702.154 739.409 673.191 599.173 673.191 599.173 280.241"/>
						  </g>
						  <g id="E-4" data-name="E">
							<polygon className="cls-3" points="1380.146 278.624 1400.158 278.624 1400.158 264.143 1494.788 264.143 1494.788 278.624 1613.905 278.624 1613.905 593.596 1613.905 673.191 1613.905 702.154 1520.381 702.154 1520.381 673.191 1380.146 673.191 1380.146 278.624"/>
						  </g>
						  <g id="E-5" data-name="E">
							<polygon className="cls-3" points="1847.664 278.624 1728.547 278.624 1728.547 264.143 1633.917 264.143 1633.917 278.624 1613.905 278.624 1613.905 673.191 1754.14 673.191 1754.14 702.154 1847.664 702.154 1847.664 673.191 1847.664 593.596 1847.664 278.624"/>
						  </g>
						  <g id="F">
							<polygon className="cls-3" points="1037.176 280.241 832.932 280.241 832.932 593.596 832.932 673.191 832.932 702.154 926.456 702.154 926.456 673.191 972.614 673.191 1037.176 673.191 1066.138 673.191 1066.138 413.538 1037.176 413.538 1037.176 280.241"/>
						  </g>
						  <g id="F-2" data-name="F">
							<polygon className="cls-3" points="1175.852 278.624 1380.146 278.624 1380.146 593.596 1380.146 673.191 1380.146 702.154 1286.622 702.154 1286.622 673.191 1244.889 673.191 1175.852 673.191 1151.365 673.191 1151.365 411.959 1175.852 411.959 1175.852 278.624"/>
						  </g>
						  <g id="G">
							<polygon className="cls-3" points="2081.465 278.532 1962.103 278.532 1962.103 264.143 1866.341 264.143 1866.341 278.532 1848.003 278.532 1848.003 672.372 1941.728 672.372 1941.728 702.934 2081.465 702.934 2081.465 672.372 2081.465 592.91 2081.465 278.532"/>
						  </g>
						  <g>
							<polygon className="cls-4" points="236.241 502.134 236.241 462.059 261.684 462.059 261.684 466.987 242.275 466.987 242.275 479.457 259.974 479.457 259.974 484.284 242.275 484.284 242.275 497.206 261.684 497.206 261.684 502.134 236.241 502.134"/>
							<polygon id="_1-4" data-name="1" className="cls-4" points="247.404 561.768 247.404 528.582 240.968 530.04 240.968 525.615 249.817 521.693 253.689 521.693 253.689 561.768 247.404 561.768"/>
							<polygon className="cls-4" points="464.469 502.838 464.469 462.763 489.962 462.763 489.962 467.691 470.553 467.691 470.553 480.161 488.252 480.161 488.252 484.988 470.553 484.988 470.553 497.91 489.962 497.91 489.962 502.838 464.469 502.838"/>
							<path id="_1-5" data-name="1" className="cls-4" d="M463.665,562.471V558.1c2.564-2.062,5.078-4.123,7.441-6.235a81.637,81.637,0,0,0,6.286-6.185,34,34,0,0,0,4.424-6.033,11.977,11.977,0,0,0,1.559-5.682,9.88,9.88,0,0,0-.6-3.47,5.66,5.66,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.531,8.531,0,0,0-1.759,5.481h-5.883a13.959,13.959,0,0,1,1.81-7.09A11.064,11.064,0,0,1,470.3,523.2a14.54,14.54,0,0,1,6.687-1.509,12.731,12.731,0,0,1,9.051,3.168c2.313,2.112,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,30.173,30.173,0,0,1-4.274,6.386A55.042,55.042,0,0,1,478,552.566c-1.961,1.76-3.872,3.419-5.632,4.877h18.3v5.028Z"/>
							<polygon className="cls-4" points="706.776 502.838 706.776 462.763 732.218 462.763 732.218 467.691 712.81 467.691 712.81 480.161 730.509 480.161 730.509 484.988 712.81 484.988 712.81 497.91 732.218 497.91 732.218 502.838 706.776 502.838"/>
							<path id="_1-6" data-name="1" className="cls-4" d="M718.994,563.125a16.99,16.99,0,0,1-7.089-1.408,11.27,11.27,0,0,1-5.079-4.223,13.769,13.769,0,0,1-2.011-7.191h6.034a7.588,7.588,0,0,0,8.145,7.643,7.4,7.4,0,0,0,5.582-2.061,6.944,6.944,0,0,0,1.961-5.029,6.16,6.16,0,0,0-2.615-5.48,11.225,11.225,0,0,0-6.386-1.76H714.57v-5.028h3.016a8.87,8.87,0,0,0,5.481-1.609,5.812,5.812,0,0,0,.453-8.548,6.854,6.854,0,0,0-11.414,4.777h-6.034a12.508,12.508,0,0,1,1.76-6.084,11.221,11.221,0,0,1,4.525-3.973,14.385,14.385,0,0,1,6.537-1.458,14.238,14.238,0,0,1,6.738,1.408,10.037,10.037,0,0,1,4.123,3.771,9.908,9.908,0,0,1,1.407,5.179,9.383,9.383,0,0,1-1.759,5.632,8.267,8.267,0,0,1-4.777,3.167,10.32,10.32,0,0,1,5.682,3.369,9.9,9.9,0,0,1,2.212,6.738,12.55,12.55,0,0,1-1.508,6.084,11.423,11.423,0,0,1-4.576,4.425A15.5,15.5,0,0,1,718.994,563.125Z"/>
							<polygon className="cls-4" points="936.864 502.134 936.864 462.059 962.005 462.059 962.005 466.987 942.948 466.987 942.948 479.658 958.737 479.658 958.737 484.535 942.948 484.535 942.948 502.134 936.864 502.134"/>
							<path id="_1-7" data-name="1" className="cls-4" d="M952.854,561.768v-8H932.741v-4.827L951.9,521.693h6.99v26.8h5.581v5.28h-5.581v8Zm-13.526-13.275h13.878V528.381Z"/>
							<polygon className="cls-4" points="1253.789 502.134 1253.789 462.059 1278.929 462.059 1278.929 466.987 1259.873 466.987 1259.873 479.658 1275.661 479.658 1275.661 484.535 1259.873 484.535 1259.873 502.134 1253.789 502.134"/>
							<path id="_1-8" data-name="1" className="cls-4" d="M1265.655,562.471a16.631,16.631,0,0,1-7.341-1.508,12.476,12.476,0,0,1-4.877-4.224,13.644,13.644,0,0,1-2.213-6.033h5.984a7.553,7.553,0,0,0,2.866,4.726,8.453,8.453,0,0,0,5.631,1.86,7.71,7.71,0,0,0,4.375-1.206,8.774,8.774,0,0,0,2.866-3.319,10.585,10.585,0,0,0,1.006-4.626,9.1,9.1,0,0,0-2.263-6.486,7.749,7.749,0,0,0-5.782-2.464,9.305,9.305,0,0,0-5.129,1.408,8.539,8.539,0,0,0-3.067,3.52h-5.783l3.419-22.426h21.672v5.33h-17.1l-2.062,10.71a10.751,10.751,0,0,1,3.671-2.514,14.07,14.07,0,0,1,12.218.855,12.729,12.729,0,0,1,4.475,5.028,16.426,16.426,0,0,1-.15,14.28,13.414,13.414,0,0,1-4.878,5.179A14.485,14.485,0,0,1,1265.655,562.471Z"/>
							<polygon className="cls-4" points="1473.569 502.838 1473.569 462.763 1499.012 462.763 1499.012 467.691 1479.603 467.691 1479.603 480.161 1497.302 480.161 1497.302 484.988 1479.603 484.988 1479.603 497.91 1499.012 497.91 1499.012 502.838 1473.569 502.838"/>
							<path id="_1-9" data-name="1" className="cls-4" d="M1486.542,563.125a15.225,15.225,0,0,1-7.442-1.659,13.845,13.845,0,0,1-4.927-4.375,20.035,20.035,0,0,1-2.665-6.184,32.834,32.834,0,0,1-.805-7.04,33.9,33.9,0,0,1,1.861-11.615,17.478,17.478,0,0,1,5.38-7.793,13.314,13.314,0,0,1,8.447-2.766,13.684,13.684,0,0,1,6.788,1.559,11.512,11.512,0,0,1,4.374,4.123,13.663,13.663,0,0,1,1.911,5.581h-5.682a7.442,7.442,0,0,0-2.463-4.575,7.684,7.684,0,0,0-4.978-1.609,8.131,8.131,0,0,0-6.889,3.922c-1.81,2.614-2.765,6.637-2.916,12.067a11.987,11.987,0,0,1,4.274-4.274,12.455,12.455,0,0,1,6.687-1.81,13.181,13.181,0,0,1,6.336,1.609,12.871,12.871,0,0,1,4.776,4.525,12.113,12.113,0,0,1,1.861,6.839,13.272,13.272,0,0,1-1.71,6.587,13.468,13.468,0,0,1-12.218,6.888Zm-.352-5.229a8.551,8.551,0,0,0,4.274-1.056,8.124,8.124,0,0,0,1.709-12.772,8.629,8.629,0,0,0-6.033-2.162,8.263,8.263,0,0,0-4.325,1.107,7.538,7.538,0,0,0-3.017,2.866,7.286,7.286,0,0,0-1.106,3.972,8.209,8.209,0,0,0,1.106,4.173,7.9,7.9,0,0,0,3.068,2.816A8.742,8.742,0,0,0,1486.19,557.9Z"/>
							<polygon className="cls-4" points="1712.155 502.134 1712.155 462.059 1737.648 462.059 1737.648 466.987 1718.239 466.987 1718.239 479.457 1735.938 479.457 1735.938 484.284 1718.239 484.284 1718.239 497.206 1737.648 497.206 1737.648 502.134 1712.155 502.134"/>
							<polygon id="_1-10" data-name="1" className="cls-4" points="1716.027 561.768 1731.564 526.922 1710.697 526.922 1710.697 521.693 1737.799 521.693 1737.799 526.118 1722.362 561.768 1716.027 561.768"/>
							<path className="cls-4" d="M2205.97,502.838V462.763h13.023c4.676,0,8.548.805,11.565,2.464a15.863,15.863,0,0,1,6.788,6.939,24.385,24.385,0,0,1,2.162,10.71,24.079,24.079,0,0,1-2.162,10.609,15.5,15.5,0,0,1-6.788,6.889c-3.017,1.659-6.889,2.464-11.565,2.464Zm6.084-5.179h6.687c3.621,0,6.487-.554,8.649-1.76a10.237,10.237,0,0,0,4.575-5.079,20.948,20.948,0,0,0,1.408-7.944,21.491,21.491,0,0,0-1.408-8.045,10.456,10.456,0,0,0-4.575-5.179,17.689,17.689,0,0,0-8.649-1.81h-6.687Z"/>
							<polygon id="_1-11" data-name="1" className="cls-4" points="2202.852 562.471 2202.852 529.235 2196.416 530.744 2196.416 526.269 2205.266 522.397 2209.188 522.397 2209.188 562.471 2202.852 562.471"/>
							<path id="_2-4" data-name="2" className="cls-4" d="M2232.016,563.125a15.225,15.225,0,0,1-7.442-1.659,14.294,14.294,0,0,1-4.928-4.375,20.057,20.057,0,0,1-2.664-6.184,35.583,35.583,0,0,1,1.106-18.655,17.4,17.4,0,0,1,5.33-7.793,13.314,13.314,0,0,1,8.447-2.766,13.554,13.554,0,0,1,6.788,1.559,11.519,11.519,0,0,1,4.374,4.123,13.663,13.663,0,0,1,1.911,5.581h-5.682a7.2,7.2,0,0,0-2.464-4.575,7.491,7.491,0,0,0-4.977-1.609,8.131,8.131,0,0,0-6.889,3.922q-2.715,3.921-2.866,12.067a11.445,11.445,0,0,1,4.224-4.274,12.455,12.455,0,0,1,6.687-1.81,13.181,13.181,0,0,1,6.336,1.609,13.409,13.409,0,0,1,4.827,4.525,12.53,12.53,0,0,1,1.86,6.839,13.324,13.324,0,0,1-1.76,6.587,12.738,12.738,0,0,1-4.827,4.977A13.485,13.485,0,0,1,2232.016,563.125Zm-.352-5.229a8.551,8.551,0,0,0,4.274-1.056,8.127,8.127,0,0,0,3.017-2.816,7.986,7.986,0,0,0,1.055-4.123,7.652,7.652,0,0,0-2.363-5.833,8.63,8.63,0,0,0-6.034-2.162,8.26,8.26,0,0,0-4.324,1.107,7.538,7.538,0,0,0-3.017,2.866,7.831,7.831,0,0,0,3.068,10.961A8.742,8.742,0,0,0,2231.664,557.9Z"/>
							<path id="_1-12" data-name="1" className="cls-4" d="M1958.028,562.347h-8.15l-4.075-4.075c-2.038-2.037-2.038-4.075-2.038-6.112,0-4.075,0-6.113,2.038-8.15,0-2.038,2.037-2.038,4.075-2.038-2.038-2.037-4.075-2.037-4.075-4.075-2.038-2.037-2.038-4.075-2.038-6.112s0-4.075,2.038-4.075a4.381,4.381,0,0,1,4.075-4.075c2.037-2.038,4.075-2.038,8.15-2.038,2.037,0,4.075,0,6.112,2.038a4.381,4.381,0,0,1,4.075,4.075c2.038,0,2.038,2.037,2.038,4.075s0,4.075-2.038,6.112c0,2.038-2.037,2.038-4.075,4.075,2.038,0,4.075,0,6.113,2.038,0,2.037,2.037,4.075,2.037,8.15,0,2.037-2.037,4.075-2.037,6.112-2.038,0-4.075,2.038-6.113,4.075Zm0-22.412c2.037,0,4.075-2.038,4.075-2.038a6.31,6.31,0,0,0,2.037-4.075c0-2.037,0-4.075-2.037-6.112,0,0-2.038-2.038-4.075-2.038-4.075,0-4.075,2.038-6.113,2.038-2.037,2.037-2.037,4.075-2.037,6.112a6.31,6.31,0,0,0,2.037,4.075C1953.953,537.9,1953.953,539.935,1958.028,539.935Zm0,18.337c2.037,0,4.075-2.037,6.112-2.037,0-2.038,2.038-4.075,2.038-6.113s-2.038-4.075-2.038-4.075c-2.037-2.037-4.075-2.037-6.112-2.037-4.075,0-6.113,0-6.113,2.037-2.037,0-2.037,2.038-2.037,4.075s0,4.075,2.037,6.113A8.927,8.927,0,0,0,1958.028,558.272Z"/>
							<path className="cls-4" d="M1955.99,503.26c-2.037,0-6.112,0-8.15-2.037a15.912,15.912,0,0,1-8.15-8.15c0-2.038-2.037-6.113-2.037-10.188s2.037-8.15,2.037-10.187a15.908,15.908,0,0,1,8.15-8.15c2.038-2.038,6.113-2.038,10.188-2.038s8.15,0,10.187,2.038a11.2,11.2,0,0,1,6.113,10.187h-6.113c0-2.037-2.037-4.075-4.075-6.112-2.037,0-4.075-2.038-6.112-2.038a15.568,15.568,0,0,0-10.188,4.075c-2.037,4.075-4.075,8.15-4.075,12.225a15.568,15.568,0,0,0,4.075,10.188c2.038,4.075,6.113,4.075,10.188,4.075s6.112,0,8.15-2.038a15.563,15.563,0,0,0,4.075-10.187h-12.225v-4.075h18.337V503.26h-6.112v-6.112c-2.038,2.037-4.075,4.075-6.113,4.075C1962.1,503.26,1960.065,503.26,1955.99,503.26Z"/>
						  </g>
						</g>
						<g id="D-active" className={`${openPlan === 1 ? "" : "hidden"}`}>
						  <g id="D-2" data-name="D">
							<polygon className="cls-5" points="2363.817 448.85 2396.701 448.85 2395.844 703.011 2081.886 703.011 2082.744 450.545 2081.465 322.959 2222.505 322.959 2222.505 301.238 2338.093 301.238 2338.093 322.959 2363.917 322.959 2363.817 448.85"/>
						  </g>
						  <path className="cls-6" d="M2204.564,503.26V462.51h14.262c4.075,0,8.15,0,10.188,2.038a15.908,15.908,0,0,1,8.15,8.15c2.037,2.037,2.037,6.112,2.037,10.187s0,8.15-2.037,10.188a15.912,15.912,0,0,1-8.15,8.15c-2.038,0-6.113,2.037-10.188,2.037Zm6.113-6.112h8.149c2.038,0,6.113,0,8.15-2.038a4.381,4.381,0,0,0,4.075-4.075c2.038-2.037,2.038-6.112,2.038-8.15,0-4.075,0-6.112-2.038-8.15,0-2.037-2.037-4.075-4.075-6.112h-16.3Z"/>
						  <polygon id="_1-13" data-name="1" className="cls-6" points="2202.527 562.347 2202.527 529.747 2196.414 529.747 2196.414 525.672 2204.564 521.597 2208.639 521.597 2208.639 562.347 2202.527 562.347"/>
						  <path id="_2-5" data-name="2" className="cls-6" d="M2231.051,562.347h-6.112l-6.113-6.112c0-2.038-2.037-4.075-2.037-6.113s-2.037-4.075-2.037-6.112c0-4.075,2.037-8.15,2.037-12.225,2.037-2.038,4.075-6.113,6.112-8.15s6.113-2.038,8.15-2.038,6.113,0,6.113,2.038c2.037,0,4.075,2.037,6.112,4.075,0,2.037,0,4.075,2.038,6.112H2239.2c0-2.037-2.037-4.075-2.037-6.112h-6.113c-2.037,0-4.075,0-6.112,2.037-2.038,4.075-4.075,8.15-4.075,12.225,2.037,0,2.037-2.037,4.075-4.075,2.037,0,4.075-2.037,8.15-2.037,2.037,0,4.075,2.037,6.112,2.037,2.038,2.038,4.075,2.038,4.075,4.075,2.038,2.038,2.038,4.075,2.038,8.15,0,2.038,0,4.075-2.038,6.113a4.382,4.382,0,0,1-4.075,4.075C2237.164,562.347,2235.126,562.347,2231.051,562.347Zm0-4.075c2.038,0,4.075,0,4.075-2.037,2.038,0,2.038-2.038,4.075-2.038v-4.075c0-2.037,0-4.075-2.037-6.112s-4.075-2.038-6.113-2.038h-4.075l-4.075,4.075v8.15c2.038,0,2.038,2.038,4.075,2.038C2229.014,558.272,2229.014,558.272,2231.051,558.272Z"/>
						</g>
						<g id="E-Active" className={`${openPlan === 2 ? "" : "hidden"}`}>
						  <g id="E-6" data-name="E">
							<polygon className="cls-5" points="131.606 280.241 161.121 280.241 161.121 265.76 251.024 265.76 251.024 280.241 365.364 280.241 365.364 593.596 365.364 673.191 365.364 702.154 271.891 702.154 271.891 673.191 131.606 673.191 131.606 280.241"/>
						  </g>
						  <g id="E-7" data-name="E">
							<polygon className="cls-5" points="599.173 280.241 480.057 280.241 480.057 265.76 385.427 265.76 385.427 280.241 365.364 280.241 365.364 673.191 505.65 673.191 505.65 702.154 599.173 702.154 599.173 673.191 599.173 593.596 599.173 280.241"/>
						  </g>
						  <g id="E-8" data-name="E">
							<polygon className="cls-5" points="599.173 280.241 619.186 280.241 619.186 265.76 713.815 265.76 713.815 280.241 832.932 280.241 832.932 593.596 832.932 673.191 832.932 702.154 739.409 702.154 739.409 673.191 599.173 673.191 599.173 280.241"/>
						  </g>
						  <g id="E-9" data-name="E">
							<polygon className="cls-5" points="1380.146 278.624 1400.158 278.624 1400.158 264.143 1494.788 264.143 1494.788 278.624 1613.905 278.624 1613.905 593.596 1613.905 673.191 1613.905 702.154 1520.381 702.154 1520.381 673.191 1380.146 673.191 1380.146 278.624"/>
						  </g>
						  <g id="E-10" data-name="E">
							<polygon className="cls-5" points="1847.664 278.624 1728.547 278.624 1728.547 264.143 1633.917 264.143 1633.917 278.624 1613.905 278.624 1613.905 673.191 1754.14 673.191 1754.14 702.154 1847.664 702.154 1847.664 673.191 1847.664 593.596 1847.664 278.624"/>
						  </g>
						  <polygon className="cls-6" points="236.241 502.134 236.241 462.059 261.684 462.059 261.684 466.987 242.275 466.987 242.275 479.457 259.974 479.457 259.974 484.284 242.275 484.284 242.275 497.206 261.684 497.206 261.684 502.134 236.241 502.134"/>
						  <polygon id="_1-14" data-name="1" className="cls-6" points="247.404 561.768 247.404 528.582 240.968 530.04 240.968 525.615 249.817 521.693 253.689 521.693 253.689 561.768 247.404 561.768"/>
						  <polygon className="cls-6" points="464.469 502.838 464.469 462.763 489.962 462.763 489.962 467.691 470.553 467.691 470.553 480.161 488.252 480.161 488.252 484.988 470.553 484.988 470.553 497.91 489.962 497.91 489.962 502.838 464.469 502.838"/>
						  <path id="_1-15" data-name="1" className="cls-6" d="M463.665,562.471V558.1c2.564-2.062,5.078-4.123,7.441-6.235a81.637,81.637,0,0,0,6.286-6.185,34,34,0,0,0,4.424-6.033,11.977,11.977,0,0,0,1.559-5.682,9.88,9.88,0,0,0-.6-3.47,5.66,5.66,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.531,8.531,0,0,0-1.759,5.481h-5.883a13.959,13.959,0,0,1,1.81-7.09A11.064,11.064,0,0,1,470.3,523.2a14.54,14.54,0,0,1,6.687-1.509,12.731,12.731,0,0,1,9.051,3.168c2.313,2.112,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,30.173,30.173,0,0,1-4.274,6.386A55.042,55.042,0,0,1,478,552.566c-1.961,1.76-3.872,3.419-5.632,4.877h18.3v5.028Z"/>
						  <polygon className="cls-6" points="706.776 502.838 706.776 462.763 732.218 462.763 732.218 467.691 712.81 467.691 712.81 480.161 730.509 480.161 730.509 484.988 712.81 484.988 712.81 497.91 732.218 497.91 732.218 502.838 706.776 502.838"/>
						  <path id="_1-16" data-name="1" className="cls-6" d="M718.994,563.125a16.99,16.99,0,0,1-7.089-1.408,11.27,11.27,0,0,1-5.079-4.223,13.769,13.769,0,0,1-2.011-7.191h6.034a7.588,7.588,0,0,0,8.145,7.643,7.4,7.4,0,0,0,5.582-2.061,6.944,6.944,0,0,0,1.961-5.029,6.16,6.16,0,0,0-2.615-5.48,11.225,11.225,0,0,0-6.386-1.76H714.57v-5.028h3.016a8.87,8.87,0,0,0,5.481-1.609,5.812,5.812,0,0,0,.453-8.548,6.854,6.854,0,0,0-11.414,4.777h-6.034a12.508,12.508,0,0,1,1.76-6.084,11.221,11.221,0,0,1,4.525-3.973,14.385,14.385,0,0,1,6.537-1.458,14.238,14.238,0,0,1,6.738,1.408,10.037,10.037,0,0,1,4.123,3.771,9.908,9.908,0,0,1,1.407,5.179,9.383,9.383,0,0,1-1.759,5.632,8.267,8.267,0,0,1-4.777,3.167,10.32,10.32,0,0,1,5.682,3.369,9.9,9.9,0,0,1,2.212,6.738,12.55,12.55,0,0,1-1.508,6.084,11.423,11.423,0,0,1-4.576,4.425A15.5,15.5,0,0,1,718.994,563.125Z"/>
						  <polygon className="cls-6" points="1473.569 502.838 1473.569 462.763 1499.012 462.763 1499.012 467.691 1479.603 467.691 1479.603 480.161 1497.302 480.161 1497.302 484.988 1479.603 484.988 1479.603 497.91 1499.012 497.91 1499.012 502.838 1473.569 502.838"/>
						  <path id="_1-17" data-name="1" className="cls-6" d="M1486.542,563.125a15.225,15.225,0,0,1-7.442-1.659,13.845,13.845,0,0,1-4.927-4.375,20.035,20.035,0,0,1-2.665-6.184,32.834,32.834,0,0,1-.805-7.04,33.9,33.9,0,0,1,1.861-11.615,17.478,17.478,0,0,1,5.38-7.793,13.314,13.314,0,0,1,8.447-2.766,13.684,13.684,0,0,1,6.788,1.559,11.512,11.512,0,0,1,4.374,4.123,13.663,13.663,0,0,1,1.911,5.581h-5.682a7.442,7.442,0,0,0-2.463-4.575,7.684,7.684,0,0,0-4.978-1.609,8.131,8.131,0,0,0-6.889,3.922c-1.81,2.614-2.765,6.637-2.916,12.067a11.987,11.987,0,0,1,4.274-4.274,12.455,12.455,0,0,1,6.687-1.81,13.181,13.181,0,0,1,6.336,1.609,12.871,12.871,0,0,1,4.776,4.525,12.113,12.113,0,0,1,1.861,6.839,13.272,13.272,0,0,1-1.71,6.587,13.468,13.468,0,0,1-12.218,6.888Zm-.352-5.229a8.551,8.551,0,0,0,4.274-1.056,8.124,8.124,0,0,0,1.709-12.772,8.629,8.629,0,0,0-6.033-2.162,8.263,8.263,0,0,0-4.325,1.107,7.538,7.538,0,0,0-3.017,2.866,7.286,7.286,0,0,0-1.106,3.972,8.209,8.209,0,0,0,1.106,4.173,7.9,7.9,0,0,0,3.068,2.816A8.742,8.742,0,0,0,1486.19,557.9Z"/>
						  <polygon className="cls-6" points="1712.155 502.134 1712.155 462.059 1737.648 462.059 1737.648 466.987 1718.239 466.987 1718.239 479.457 1735.938 479.457 1735.938 484.284 1718.239 484.284 1718.239 497.206 1737.648 497.206 1737.648 502.134 1712.155 502.134"/>
						  <polygon id="_1-18" data-name="1" className="cls-6" points="1716.027 561.768 1731.564 526.922 1710.697 526.922 1710.697 521.693 1737.799 521.693 1737.799 526.118 1722.362 561.768 1716.027 561.768"/>
						</g>
						<g id="F-active" className={`${openPlan === 3 ? "" : "hidden"}`}>
						  <g id="F-3" data-name="F">
							<polygon className="cls-5" points="1037.176 280.241 832.932 280.241 832.932 593.596 832.932 673.191 832.932 702.154 926.456 702.154 926.456 673.191 972.614 673.191 1037.176 673.191 1066.138 673.191 1066.138 413.538 1037.176 413.538 1037.176 280.241"/>
						  </g>
						  <g id="F-4" data-name="F">
							<polygon className="cls-5" points="1175.852 278.624 1380.146 278.624 1380.146 593.596 1380.146 673.191 1380.146 702.154 1286.622 702.154 1286.622 673.191 1244.889 673.191 1175.852 673.191 1151.365 673.191 1151.365 411.959 1175.852 411.959 1175.852 278.624"/>
						  </g>
						  <polygon className="cls-6" points="937.245 501.223 937.245 462.51 961.695 462.51 961.695 466.585 943.358 466.585 943.358 478.81 957.62 478.81 957.62 484.923 943.358 484.923 943.358 501.223 937.245 501.223"/>
						  <path id="_1-19" data-name="1" className="cls-6" d="M951.508,562.347V554.2H933.17v-6.112L951.508,521.6h6.112v26.488h6.113V554.2H957.62v8.15Zm-12.225-14.262h14.262V527.71Z"/>
						  <polygon className="cls-6" points="1253.056 501.223 1253.056 462.51 1277.506 462.51 1277.506 466.585 1259.169 466.585 1259.169 478.81 1275.469 478.81 1275.469 484.923 1259.169 484.923 1259.169 501.223 1253.056 501.223"/>
						  <path id="_1-20" data-name="1" className="cls-6" d="M1265.281,562.347c-2.037,0-6.112,0-8.15-2.037-2.037,0-2.037-2.038-4.075-4.075s-2.037-4.075-2.037-6.113h6.112c0,2.038,0,4.075,2.038,6.113h10.187l4.075-4.075v-4.075c0-2.038,0-4.075-2.037-6.113s-4.075-2.037-6.113-2.037h-4.075c-2.037,2.037-4.075,2.037-4.075,4.075h-6.112l4.075-22.413h22.412v6.113h-18.337l-2.038,10.187c2.038-2.037,2.038-2.037,4.075-2.037a6.311,6.311,0,0,1,4.075-2.038c4.075,0,6.113,0,8.15,2.038s4.075,2.037,4.075,6.112c2.038,2.038,2.038,4.075,2.038,6.113a15.4,15.4,0,0,1-2.038,8.15l-4.075,4.075C1271.394,562.347,1267.319,562.347,1265.281,562.347Z"/>
						</g>
						<g id="G-active" className={`${openPlan === 4 ? "" : "hidden"}`}>
						  <g id="G-2" data-name="G">
							<polygon className="cls-7" points="2081.465 278.532 1962.103 278.532 1962.103 264.143 1866.341 264.143 1866.341 278.532 1848.003 278.532 1848.003 672.372 1941.728 672.372 1941.728 702.934 2081.465 702.934 2081.465 672.372 2081.465 592.91 2081.465 278.532"/>
						  </g>
						  <path className="cls-6" d="M1957.328,503.542a18.786,18.786,0,0,1-9.906-2.615,17.543,17.543,0,0,1-6.587-7.19,23.786,23.786,0,0,1-2.363-10.811,23.147,23.147,0,0,1,2.414-10.81,18.315,18.315,0,0,1,6.838-7.392,20.27,20.27,0,0,1,10.509-2.665,19.084,19.084,0,0,1,11.464,3.319,15.1,15.1,0,0,1,5.933,9.151h-6.838a8.928,8.928,0,0,0-3.62-5.028,12.266,12.266,0,0,0-6.939-1.81c-4.174,0-7.492,1.357-9.906,4.073s-3.57,6.436-3.57,11.212,1.157,8.5,3.52,11.163a12.052,12.052,0,0,0,9.453,4.022c3.972,0,6.939-1.156,8.95-3.419a15.047,15.047,0,0,0,3.52-8.95h-10.861v-4.726h17v21.772H1970.8l-.553-5.883a13.99,13.99,0,0,1-5.028,4.827A15.694,15.694,0,0,1,1957.328,503.542Z"/>
						  <path id="_1-21" data-name="1" className="cls-6" d="M1957.78,563.125a16.632,16.632,0,0,1-7.24-1.458,12.674,12.674,0,0,1-5.179-4.073,10.38,10.38,0,0,1-1.911-6.184,10.91,10.91,0,0,1,2.011-6.487,10.114,10.114,0,0,1,5.431-3.871,10.156,10.156,0,0,1-4.676-3.52,8.666,8.666,0,0,1-1.66-5.129,9.814,9.814,0,0,1,1.509-5.33,10.837,10.837,0,0,1,4.525-3.922,18.334,18.334,0,0,1,14.33,0,10.537,10.537,0,0,1,4.526,3.922A9.865,9.865,0,0,1,1971,532.4a8.959,8.959,0,0,1-1.709,5.129,9.976,9.976,0,0,1-4.727,3.52,10.2,10.2,0,0,1,5.431,3.921,10.654,10.654,0,0,1,2.011,6.437,10.044,10.044,0,0,1-1.911,6.184,12.36,12.36,0,0,1-5.078,4.073A16.943,16.943,0,0,1,1957.78,563.125Zm0-24.034a7.54,7.54,0,0,0,5.23-1.71,6.314,6.314,0,0,0,0-9.051,9.384,9.384,0,0,0-10.509,0,6.312,6.312,0,0,0,0,9.051A7.5,7.5,0,0,0,1957.78,539.091Zm0,18.9q4.072,0,6.185-1.961a6.855,6.855,0,0,0,2.061-5.078,6.477,6.477,0,0,0-2.212-5.28,10.8,10.8,0,0,0-12.118,0,6.363,6.363,0,0,0-2.262,5.28,6.711,6.711,0,0,0,2.111,5.078C1952.953,557.343,1955.015,558,1957.78,558Z"/>
						</g>
					</g>	
					<g id="GardenPlans" className={`${selectedCat === "garden" ? "" : "hidden"}`}>
						<g id="Base-AB">
						  <g id="_1132983448" data-name=" 1132983448">
							<polygon className="cls-8" points="131.462 1036.147 365.29 1036.147 365.29 1085.153 410.096 1085.153 410.096 1502.403 131.462 1502.403 131.462 1036.147"/>
							<polygon className="cls-8" points="454.901 1036.147 698.53 1036.147 698.53 1502.403 410.096 1502.403 410.096 1085.153 454.901 1085.153 454.901 1036.147"/>
							<polygon className="cls-8" points="1244.596 1036.147 1488.225 1036.147 1488.225 1085.153 1533.03 1085.153 1533.03 1506.603 1244.596 1506.603 1244.596 1036.147"/>
							<polygon className="cls-8" points="1818.665 1036.147 1577.836 1036.147 1577.836 1085.153 1533.03 1085.153 1533.03 1506.603 1818.665 1506.603 1818.665 1036.147"/>
							<polygon className="cls-8" points="1818.665 1036.147 2052.493 1036.147 2052.493 1085.153 2097.298 1085.153 2097.298 1506.603 1818.665 1506.603 1818.665 1036.147"/>
							<polygon className="cls-8" points="2388.533 1036.147 2142.103 1036.147 2142.103 1085.153 2097.298 1085.153 2097.298 1506.603 2388.533 1506.603 2388.533 1036.147"/>
							<path className="cls-4" d="M253.277,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
							<polygon id="_1-22" data-name="1" className="cls-4" points="253.277 1296.578 253.277 1262.974 246.276 1264.374 246.276 1260.174 256.077 1255.973 258.877 1255.973 258.877 1296.578 253.277 1296.578"/>
							<path id="_2-6" data-name="2" className="cls-4" d="M281.28,1296.578c-2.8,0-5.6,0-7-1.4s-4.2-2.8-5.6-4.2c0-1.4-1.4-4.2-1.4-5.6h5.6c0,1.4,1.4,2.8,2.8,4.2s4.2,1.4,5.6,1.4,4.2,0,4.2-1.4a3.011,3.011,0,0,0,2.8-2.8,5.143,5.143,0,0,0,1.4-4.2c0-2.8,0-5.6-1.4-7-2.8-1.4-4.2-2.8-7-2.8-1.4,0-2.8,1.4-4.2,1.4-1.4,1.4-2.8,2.8-2.8,4.2h-7l4.2-22.4h21v5.6h-16.8l-1.4,9.8a4.888,4.888,0,0,1,2.8-1.4c1.4-1.4,4.2-1.4,5.6-1.4,2.8,0,5.6,0,7,1.4a19.337,19.337,0,0,1,4.2,5.6c1.4,1.4,1.4,4.2,1.4,7s0,4.2-1.4,7c-1.4,1.4-2.8,4.2-4.2,5.6C286.881,1296.578,284.08,1296.578,281.28,1296.578Z"/>
							<path className="cls-4" d="M551.513,1236.371l15.4-40.605h5.6l15.4,40.605h-7l-2.8-9.8h-16.8l-2.8,9.8Zm11.2-14h14l-7-19.6Z"/>
							<polygon id="_1-23" data-name="1" className="cls-4" points="550.112 1296.578 550.112 1262.974 544.512 1264.374 544.512 1260.174 552.913 1255.973 557.113 1255.973 557.113 1296.578 550.112 1296.578"/>
							<path id="_2-7" data-name="2" className="cls-4" d="M583.716,1296.578v-8.4h-21v-5.6l19.6-26.6h7v26.6h5.6v5.6h-5.6v8.4Zm-14-14h14v-19.6Z"/>
							<path className="cls-4" d="M1370.611,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
							<polygon id="_1-24" data-name="1" className="cls-4" points="1372.011 1296.578 1372.011 1262.974 1365.01 1264.374 1365.01 1260.174 1373.411 1255.973 1377.612 1255.973 1377.612 1296.578 1372.011 1296.578"/>
							<path id="_2-8" data-name="2" className="cls-4" d="M1384.613,1296.578v-5.6c2.8-1.4,5.6-4.2,8.4-5.6,1.4-2.8,4.2-4.2,5.6-5.6,2.8-2.8,4.2-4.2,4.2-7,1.4-1.4,2.8-4.2,2.8-5.6a21922.859,21922.859,0,0,0-2.8-5.6,5.145,5.145,0,0,0-4.2-1.4c-2.8,0-4.2,1.4-5.6,2.8s-1.4,2.8-1.4,5.6h-5.6c0-2.8,0-5.6,1.4-7a19.347,19.347,0,0,1,4.2-5.6c2.8,0,4.2-1.4,7-1.4q6.3,0,8.4,4.2,4.2,2.1,4.2,8.4c0,2.8,0,4.2-1.4,7-1.4,1.4-2.8,4.2-4.2,5.6-1.4,2.8-4.2,4.2-5.6,5.6l-5.6,5.6h18.2v5.6Z"/>
							<path className="cls-4" d="M1671.647,1236.371l15.4-40.605h7l14,40.605h-7l-2.8-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
							<polygon id="_1-25" data-name="1" className="cls-4" points="1680.048 1296.578 1680.048 1262.974 1673.047 1264.374 1673.047 1260.174 1681.448 1255.973 1685.649 1255.973 1685.649 1296.578 1680.048 1296.578"/>
							<polygon id="_2-9" data-name="2" className="cls-4" points="1698.25 1296.578 1698.25 1262.974 1691.249 1264.374 1691.249 1260.174 1701.051 1255.973 1703.851 1255.973 1703.851 1296.578 1698.25 1296.578"/>
							<path className="cls-4" d="M1955.881,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-15.4l-4.2,9.8Zm12.6-14h12.6l-7-19.6Z"/>
							<polygon id="_1-26" data-name="1" className="cls-4" points="1953.081 1296.578 1953.081 1262.974 1947.48 1264.374 1947.48 1260.174 1955.881 1255.973 1960.082 1255.973 1960.082 1296.578 1953.081 1296.578"/>
							<path id="_2-10" data-name="2" className="cls-4" d="M1983.884,1296.578c-4.2,0-7-1.4-9.8-2.8s-4.2-4.2-5.6-7-1.4-7-1.4-11.2,0-7,1.4-11.2c1.4-2.8,2.8-4.2,5.6-7,2.8-1.4,5.6-2.8,9.8-2.8s7,1.4,9.8,2.8c2.8,2.8,4.2,4.2,5.6,7,1.4,4.2,1.4,7,1.4,11.2s0,8.4-1.4,11.2-2.8,5.6-5.6,7S1988.085,1296.578,1983.884,1296.578Zm0-5.6c2.8,0,4.2,0,5.6-1.4a19.327,19.327,0,0,0,4.2-5.6c1.4-2.8,1.4-5.6,1.4-8.4s0-5.6-1.4-8.4c-1.4-1.4-2.8-4.2-4.2-4.2-1.4-1.4-2.8-2.8-5.6-2.8s-4.2,1.4-5.6,2.8c-1.4,0-2.8,2.8-4.2,4.2-1.4,2.8-1.4,5.6-1.4,8.4s0,5.6,1.4,8.4a19.327,19.327,0,0,0,4.2,5.6C1979.684,1290.978,1981.084,1290.978,1983.884,1290.978Z"/>
							<path className="cls-4" d="M2233.114,1236.371l14-40.605h7l15.4,40.605h-7l-2.8-9.8h-16.8l-4.2,9.8Zm11.2-14h12.6l-5.6-19.6Z"/>
							<path id="_1-27" data-name="1" className="cls-4" d="M2249.916,1296.578c-2.8,0-4.2,0-5.6-1.4a19.319,19.319,0,0,1-5.6-4.2c0-1.4-1.4-4.2-1.4-5.6h5.6c0,1.4,1.4,2.8,2.8,4.2a5.141,5.141,0,0,0,4.2,1.4,10.7,10.7,0,0,0,7-2.8c2.8-2.8,2.8-7,2.8-12.6q0,2.1-4.2,4.2c-1.4,1.4-4.2,1.4-5.6,1.4-2.8,0-5.6,0-7-1.4s-4.2-2.8-4.2-4.2a10.7,10.7,0,0,1-2.8-7c0-2.8,1.4-4.2,2.8-7,0-1.4,2.8-2.8,4.2-4.2a10.689,10.689,0,0,1,7-2.8c2.8,0,5.6,1.4,8.4,2.8q2.1,0,4.2,4.2c1.4,1.4,2.8,4.2,2.8,5.6,0,2.8,1.4,4.2,1.4,7a26.379,26.379,0,0,1-2.8,11.2c-1.4,4.2-2.8,7-5.6,8.4C2256.917,1295.178,2254.117,1296.578,2249.916,1296.578Zm1.4-19.6c1.4,0,2.8-1.4,4.2-1.4l2.8-2.8c0-1.4,1.4-2.8,1.4-4.2s-1.4-2.8-1.4-4.2c-1.4-1.4-1.4-2.8-2.8-2.8a5.143,5.143,0,0,0-4.2-1.4c-2.8,0-4.2,0-5.6,1.4l-2.8,2.8v4.2c0,2.8,0,4.2,1.4,5.6A10.694,10.694,0,0,0,2251.317,1276.976Z"/>
							<g id="B-inactive">
							  <polygon className="cls-8" points="1090.577 1036.147 757.337 1036.147 757.337 1085.153 698.53 1085.153 698.53 1502.403 1090.577 1502.403 1090.577 1036.147"/>
							  <rect className="cls-9" x="971.563" y="1036.147" width="118.762" height="158.138"/>
							  <path className="cls-4" d="M897.354,1236.371v-40.605h15.4c4.2,0,7,1.4,8.4,2.8q4.2,4.2,4.2,8.4c0,1.4-1.4,4.2-2.8,5.6s-2.8,2.8-4.2,2.8c1.4,0,2.8,1.4,4.2,1.4,0,1.4,1.4,2.8,2.8,4.2v4.2c0,2.8,0,4.2-1.4,5.6q0,2.1-4.2,4.2c-1.4,1.4-4.2,1.4-7,1.4Zm5.6-22.4h8.4c2.8,0,4.2-1.4,5.6-2.8,1.4,0,1.4-1.4,1.4-4.2a5.142,5.142,0,0,0-1.4-4.2c-1.4-1.4-2.8-1.4-5.6-1.4h-8.4Zm0,16.8h8.4c2.8,0,5.6,0,7-1.4,0-1.4,1.4-2.8,1.4-4.2,0-2.8-1.4-4.2-2.8-5.6s-2.8-1.4-5.6-1.4h-8.4Z"/>
							  <polygon id="_1-28" data-name="1" className="cls-4" points="893.154 1296.578 893.154 1262.974 886.153 1264.374 886.153 1260.174 894.554 1255.973 898.754 1255.973 898.754 1296.578 893.154 1296.578"/>
							  <path id="_2-11" data-name="2" className="cls-4" d="M919.757,1296.578c-2.8,0-4.2,0-7-1.4-1.4-1.4-4.2-2.8-4.2-4.2a10.7,10.7,0,0,1-2.8-7h5.6c0,1.4,1.4,4.2,2.8,5.6s2.8,1.4,5.6,1.4,4.2,0,5.6-1.4,2.8-2.8,2.8-5.6-1.4-4.2-2.8-5.6-4.2-1.4-7-1.4h-2.8v-5.6h2.8c2.8,0,4.2,0,5.6-1.4,1.4,0,2.8-2.8,2.8-4.2s-1.4-2.8-2.8-4.2c0-1.4-1.4-1.4-4.2-1.4-1.4,0-2.8,1.4-4.2,1.4-1.4,1.4-2.8,2.8-2.8,5.6h-5.6c0-2.8,0-4.2,1.4-7l4.2-4.2c2.8,0,4.2-1.4,7-1.4s5.6,1.4,7,1.4l4.2,4.2c1.4,1.4,1.4,2.8,1.4,5.6,0,1.4-1.4,4.2-1.4,5.6-1.4,1.4-2.8,2.8-5.6,2.8,2.8,0,4.2,1.4,5.6,2.8,1.4,2.8,2.8,4.2,2.8,7s0,4.2-1.4,7l-4.2,4.2C925.357,1296.578,922.557,1296.578,919.757,1296.578Z"/>
							</g>
						  </g>
						</g>
						<g id="B-active" className={`${openPlan === 2 ? "" : "hidden"}`}>
						  <polygon className="cls-10" points="1090.577 1036.147 757.337 1036.147 757.337 1085.153 698.53 1085.153 698.53 1502.403 1090.577 1502.403 1090.577 1036.147"/>
						  <rect className="cls-9" x="971.563" y="1036.147" width="118.762" height="158.138"/>
						  <path className="cls-6" d="M897.354,1236.371v-40.605h15.4c4.2,0,7,1.4,8.4,2.8q4.2,4.2,4.2,8.4c0,1.4-1.4,4.2-2.8,5.6s-2.8,2.8-4.2,2.8c1.4,0,2.8,1.4,4.2,1.4,0,1.4,1.4,2.8,2.8,4.2v4.2c0,2.8,0,4.2-1.4,5.6q0,2.1-4.2,4.2c-1.4,1.4-4.2,1.4-7,1.4Zm5.6-22.4h8.4c2.8,0,4.2-1.4,5.6-2.8,1.4,0,1.4-1.4,1.4-4.2a5.142,5.142,0,0,0-1.4-4.2c-1.4-1.4-2.8-1.4-5.6-1.4h-8.4Zm0,16.8h8.4c2.8,0,5.6,0,7-1.4,0-1.4,1.4-2.8,1.4-4.2,0-2.8-1.4-4.2-2.8-5.6s-2.8-1.4-5.6-1.4h-8.4Z"/>
						  <polygon id="_1-29" data-name="1" className="cls-6" points="893.154 1296.578 893.154 1262.974 886.153 1264.374 886.153 1260.174 894.554 1255.973 898.754 1255.973 898.754 1296.578 893.154 1296.578"/>
						  <path id="_2-12" data-name="2" className="cls-6" d="M919.757,1296.578c-2.8,0-4.2,0-7-1.4-1.4-1.4-4.2-2.8-4.2-4.2a10.7,10.7,0,0,1-2.8-7h5.6c0,1.4,1.4,4.2,2.8,5.6s2.8,1.4,5.6,1.4,4.2,0,5.6-1.4,2.8-2.8,2.8-5.6-1.4-4.2-2.8-5.6-4.2-1.4-7-1.4h-2.8v-5.6h2.8c2.8,0,4.2,0,5.6-1.4,1.4,0,2.8-2.8,2.8-4.2s-1.4-2.8-2.8-4.2c0-1.4-1.4-1.4-4.2-1.4-1.4,0-2.8,1.4-4.2,1.4-1.4,1.4-2.8,2.8-2.8,5.6h-5.6c0-2.8,0-4.2,1.4-7l4.2-4.2c2.8,0,4.2-1.4,7-1.4s5.6,1.4,7,1.4l4.2,4.2c1.4,1.4,1.4,2.8,1.4,5.6,0,1.4-1.4,4.2-1.4,5.6-1.4,1.4-2.8,2.8-5.6,2.8,2.8,0,4.2,1.4,5.6,2.8,1.4,2.8,2.8,4.2,2.8,7s0,4.2-1.4,7l-4.2,4.2C925.357,1296.578,922.557,1296.578,919.757,1296.578Z"/>
						</g>
						<g id="A-active" className={`${openPlan === 1 ? "" : "hidden"}`}>
						  <polygon className="cls-11" points="131.462 1036.147 365.29 1036.147 365.29 1085.153 410.096 1085.153 410.096 1502.403 131.462 1502.403 131.462 1036.147"/>
						  <polygon className="cls-11" points="1244.596 1036.147 1488.225 1036.147 1488.225 1085.153 1533.03 1085.153 1533.03 1506.603 1244.596 1506.603 1244.596 1036.147"/>
						  <polygon className="cls-11" points="1818.665 1036.147 1577.836 1036.147 1577.836 1085.153 1533.03 1085.153 1533.03 1506.603 1818.665 1506.603 1818.665 1036.147"/>
						  <polygon className="cls-11" points="1818.665 1036.147 2052.493 1036.147 2052.493 1085.153 2097.298 1085.153 2097.298 1506.603 1818.665 1506.603 1818.665 1036.147"/>
						  <polygon className="cls-11" points="2388.533 1036.147 2142.103 1036.147 2142.103 1085.153 2097.298 1085.153 2097.298 1506.603 2388.533 1506.603 2388.533 1036.147"/>
						  <polygon className="cls-11" points="454.901 1036.147 698.53 1036.147 698.53 1502.403 410.096 1502.403 410.096 1085.153 454.901 1085.153 454.901 1036.147"/>
						  <path className="cls-6" d="M253.277,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
						  <polygon id="_1-30" data-name="1" className="cls-6" points="253.277 1296.578 253.277 1262.974 246.276 1264.374 246.276 1260.174 256.077 1255.973 258.877 1255.973 258.877 1296.578 253.277 1296.578"/>
						  <path id="_2-13" data-name="2" className="cls-6" d="M281.28,1296.578c-2.8,0-5.6,0-7-1.4s-4.2-2.8-5.6-4.2c0-1.4-1.4-4.2-1.4-5.6h5.6c0,1.4,1.4,2.8,2.8,4.2s4.2,1.4,5.6,1.4,4.2,0,4.2-1.4a3.011,3.011,0,0,0,2.8-2.8,5.143,5.143,0,0,0,1.4-4.2c0-2.8,0-5.6-1.4-7-2.8-1.4-4.2-2.8-7-2.8-1.4,0-2.8,1.4-4.2,1.4-1.4,1.4-2.8,2.8-2.8,4.2h-7l4.2-22.4h21v5.6h-16.8l-1.4,9.8a4.888,4.888,0,0,1,2.8-1.4c1.4-1.4,4.2-1.4,5.6-1.4,2.8,0,5.6,0,7,1.4a19.337,19.337,0,0,1,4.2,5.6c1.4,1.4,1.4,4.2,1.4,7s0,4.2-1.4,7c-1.4,1.4-2.8,4.2-4.2,5.6C286.881,1296.578,284.08,1296.578,281.28,1296.578Z"/>
						  <path className="cls-6" d="M551.513,1236.371l15.4-40.605h5.6l15.4,40.605h-7l-2.8-9.8h-16.8l-2.8,9.8Zm11.2-14h14l-7-19.6Z"/>
						  <polygon id="_1-31" data-name="1" className="cls-6" points="550.112 1296.578 550.112 1262.974 544.512 1264.374 544.512 1260.174 552.913 1255.973 557.113 1255.973 557.113 1296.578 550.112 1296.578"/>
						  <path id="_2-14" data-name="2" className="cls-6" d="M583.716,1296.578v-8.4h-21v-5.6l19.6-26.6h7v26.6h5.6v5.6h-5.6v8.4Zm-14-14h14v-19.6Z"/>
						  <path className="cls-6" d="M1370.611,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
						  <polygon id="_1-32" data-name="1" className="cls-6" points="1372.011 1296.578 1372.011 1262.974 1365.01 1264.374 1365.01 1260.174 1373.411 1255.973 1377.612 1255.973 1377.612 1296.578 1372.011 1296.578"/>
						  <path id="_2-15" data-name="2" className="cls-6" d="M1384.613,1296.578v-5.6c2.8-1.4,5.6-4.2,8.4-5.6,1.4-2.8,4.2-4.2,5.6-5.6,2.8-2.8,4.2-4.2,4.2-7,1.4-1.4,2.8-4.2,2.8-5.6a21922.859,21922.859,0,0,0-2.8-5.6,5.145,5.145,0,0,0-4.2-1.4c-2.8,0-4.2,1.4-5.6,2.8s-1.4,2.8-1.4,5.6h-5.6c0-2.8,0-5.6,1.4-7a19.347,19.347,0,0,1,4.2-5.6c2.8,0,4.2-1.4,7-1.4q6.3,0,8.4,4.2,4.2,2.1,4.2,8.4c0,2.8,0,4.2-1.4,7-1.4,1.4-2.8,4.2-4.2,5.6-1.4,2.8-4.2,4.2-5.6,5.6l-5.6,5.6h18.2v5.6Z"/>
						  <path className="cls-6" d="M1671.647,1236.371l15.4-40.605h7l14,40.605h-7l-2.8-9.8h-16.8l-2.8,9.8Zm12.6-14h12.6l-7-19.6Z"/>
						  <polygon id="_1-33" data-name="1" className="cls-6" points="1680.048 1296.578 1680.048 1262.974 1673.047 1264.374 1673.047 1260.174 1681.448 1255.973 1685.649 1255.973 1685.649 1296.578 1680.048 1296.578"/>
						  <polygon id="_2-16" data-name="2" className="cls-6" points="1698.25 1296.578 1698.25 1262.974 1691.249 1264.374 1691.249 1260.174 1701.051 1255.973 1703.851 1255.973 1703.851 1296.578 1698.25 1296.578"/>
						  <path className="cls-6" d="M1955.881,1236.371l15.4-40.605h7l14,40.605h-5.6l-4.2-9.8h-15.4l-4.2,9.8Zm12.6-14h12.6l-7-19.6Z"/>
						  <polygon id="_1-34" data-name="1" className="cls-6" points="1953.081 1296.578 1953.081 1262.974 1947.48 1264.374 1947.48 1260.174 1955.881 1255.973 1960.082 1255.973 1960.082 1296.578 1953.081 1296.578"/>
						  <path id="_2-17" data-name="2" className="cls-6" d="M1983.884,1296.578c-4.2,0-7-1.4-9.8-2.8s-4.2-4.2-5.6-7-1.4-7-1.4-11.2,0-7,1.4-11.2c1.4-2.8,2.8-4.2,5.6-7,2.8-1.4,5.6-2.8,9.8-2.8s7,1.4,9.8,2.8c2.8,2.8,4.2,4.2,5.6,7,1.4,4.2,1.4,7,1.4,11.2s0,8.4-1.4,11.2-2.8,5.6-5.6,7S1988.085,1296.578,1983.884,1296.578Zm0-5.6c2.8,0,4.2,0,5.6-1.4a19.327,19.327,0,0,0,4.2-5.6c1.4-2.8,1.4-5.6,1.4-8.4s0-5.6-1.4-8.4c-1.4-1.4-2.8-4.2-4.2-4.2-1.4-1.4-2.8-2.8-5.6-2.8s-4.2,1.4-5.6,2.8c-1.4,0-2.8,2.8-4.2,4.2-1.4,2.8-1.4,5.6-1.4,8.4s0,5.6,1.4,8.4a19.327,19.327,0,0,0,4.2,5.6C1979.684,1290.978,1981.084,1290.978,1983.884,1290.978Z"/>
						  <path className="cls-6" d="M2233.114,1236.371l14-40.605h7l15.4,40.605h-7l-2.8-9.8h-16.8l-4.2,9.8Zm11.2-14h12.6l-5.6-19.6Z"/>
						  <path id="_1-35" data-name="1" className="cls-6" d="M2249.916,1296.578c-2.8,0-4.2,0-5.6-1.4a19.319,19.319,0,0,1-5.6-4.2c0-1.4-1.4-4.2-1.4-5.6h5.6c0,1.4,1.4,2.8,2.8,4.2a5.141,5.141,0,0,0,4.2,1.4,10.7,10.7,0,0,0,7-2.8c2.8-2.8,2.8-7,2.8-12.6q0,2.1-4.2,4.2c-1.4,1.4-4.2,1.4-5.6,1.4-2.8,0-5.6,0-7-1.4s-4.2-2.8-4.2-4.2a10.7,10.7,0,0,1-2.8-7c0-2.8,1.4-4.2,2.8-7,0-1.4,2.8-2.8,4.2-4.2a10.689,10.689,0,0,1,7-2.8c2.8,0,5.6,1.4,8.4,2.8q2.1,0,4.2,4.2c1.4,1.4,2.8,4.2,2.8,5.6,0,2.8,1.4,4.2,1.4,7a26.379,26.379,0,0,1-2.8,11.2c-1.4,4.2-2.8,7-5.6,8.4C2256.917,1295.178,2254.117,1296.578,2249.916,1296.578Zm1.4-19.6c1.4,0,2.8-1.4,4.2-1.4l2.8-2.8c0-1.4,1.4-2.8,1.4-4.2s-1.4-2.8-1.4-4.2c-1.4-1.4-1.4-2.8-2.8-2.8a5.143,5.143,0,0,0-4.2-1.4c-2.8,0-4.2,0-5.6,1.4l-2.8,2.8v4.2c0,2.8,0,4.2,1.4,5.6A10.694,10.694,0,0,0,2251.317,1276.976Z"/>
						</g>
					</g>
					<g id="TerracePlans" className={`${selectedCat === "terrace" ? "" : "hidden"}`}>
						<g id="Base-C">
						  <rect className="cls-12" x="2145.431" y="978.551" width="228.53" height="58.679"/>
						  <rect className="cls-12" x="1591.077" y="978.551" width="228.53" height="57.271"/>
						  <rect className="cls-12" x="1243.129" y="978.551" width="227.926" height="57.271"/>
						  <rect className="cls-12" x="761.482" y="978.551" width="232.753" height="57.271"/>
						  <rect className="cls-12" x="464.922" y="978.551" width="222.898" height="57.271"/>
						  <rect className="cls-12" x="130.851" y="978.551" width="228.58" height="57.271"/>
						  <rect className="cls-12" x="1819.556" y="978.551" width="228.53" height="57.271"/>
						  <rect className="cls-13" x="1005.649" y="1035.771" width="83.266" height="468.674"/>
						  <polygon className="cls-3" points="2387.536 1505.552 2098.116 1505.552 2098.116 1085.651 2141.911 1085.651 2141.962 1037.682 2387.536 1037.481 2387.536 1505.552"/>
						  <polygon className="cls-3" points="1819.556 1505.552 2098.116 1505.552 2098.116 1085.651 2055.326 1085.651 2055.326 1035.771 1819.556 1035.771 1819.556 1505.552"/>
						  <polygon className="cls-3" points="1819.556 1505.552 1531.242 1505.552 1531.242 1085.5 1575.54 1085.5 1575.54 1035.771 1819.556 1035.771 1819.556 1505.552"/>
						  <polygon className="cls-3" points="456.123 1035.771 698.329 1035.771 698.329 1505.552 409.461 1505.552 409.461 1085.198 456.123 1085.198 456.123 1035.771"/>
						  <polygon className="cls-3" points="366.772 1035.771 130.851 1035.771 130.851 1505.552 409.461 1505.552 409.461 1085.198 366.772 1085.198 366.772 1035.771"/>
						  <polygon className="cls-3" points="1005.649 1035.771 757.409 1035.771 757.409 1085.198 698.329 1085.198 698.329 1505.552 1005.649 1505.552 1005.649 1035.771"/>
						  <polygon className="cls-3" points="1243.129 1505.552 1531.242 1505.552 1531.242 1085.5 1486.994 1085.5 1486.994 1035.771 1243.129 1035.771 1243.129 1505.552"/>
						  <path className="cls-4" d="M271.338,1269.128a19.853,19.853,0,0,1-10.308-2.564,17.587,17.587,0,0,1-6.637-7.291,25.91,25.91,0,0,1,0-21.621,17.581,17.581,0,0,1,6.637-7.291,19.411,19.411,0,0,1,10.308-2.665q7.014,0,11.464,3.469a15.08,15.08,0,0,1,5.682,9.6h-6.738a9.857,9.857,0,0,0-3.469-5.581,11.066,11.066,0,0,0-7.04-2.062,12,12,0,0,0-9.5,4.124c-2.313,2.715-3.469,6.486-3.469,11.212q0,7.166,3.469,11.163a11.964,11.964,0,0,0,9.5,4.073,11.7,11.7,0,0,0,7.04-1.911,9.078,9.078,0,0,0,3.469-5.33h6.738a14.637,14.637,0,0,1-5.682,9.3C279.836,1268.022,276.014,1269.128,271.338,1269.128Z"/>
						  <path id="_1-36" data-name="1" className="cls-4" d="M240.214,1328.108v-4.374c2.564-2.062,5.078-4.123,7.441-6.235a83.2,83.2,0,0,0,6.336-6.235,34.015,34.015,0,0,0,4.374-5.984,12.068,12.068,0,0,0,1.609-5.681,9.689,9.689,0,0,0-.653-3.47,5.673,5.673,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.529,8.529,0,0,0-1.76,5.48h-5.882a13.955,13.955,0,0,1,1.81-7.089,11.072,11.072,0,0,1,4.676-4.325,14.549,14.549,0,0,1,6.687-1.508,12.733,12.733,0,0,1,9.051,3.168c2.313,2.111,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,31.892,31.892,0,0,1-4.224,6.385,67.268,67.268,0,0,1-5.581,5.783c-2.011,1.76-3.922,3.419-5.682,4.827h18.3v5.078Z"/>
						  <path id="_2-18" data-name="2" className="cls-4" d="M286.573,1328.762a17.006,17.006,0,0,1-7.089-1.408,11.138,11.138,0,0,1-5.029-4.224,13.307,13.307,0,0,1-2.011-7.19h5.984a8.037,8.037,0,0,0,2.212,5.431,7.851,7.851,0,0,0,5.933,2.212,7.443,7.443,0,0,0,5.632-2.062,7.113,7.113,0,0,0,1.91-5.028,6.157,6.157,0,0,0-2.614-5.48,11.112,11.112,0,0,0-6.386-1.76h-2.967v-5.028h3.068a8.722,8.722,0,0,0,5.43-1.609,5.812,5.812,0,0,0,.453-8.548,6.438,6.438,0,0,0-4.576-1.509,6.565,6.565,0,0,0-4.877,1.81,6.94,6.94,0,0,0-1.961,4.475H273.7a11.521,11.521,0,0,1,1.76-6.084,10.427,10.427,0,0,1,4.475-3.972,16.2,16.2,0,0,1,13.325-.05,9.668,9.668,0,0,1,5.48,8.95,9.058,9.058,0,0,1-1.759,5.631,8.155,8.155,0,0,1-4.727,3.168,9.862,9.862,0,0,1,7.894,10.107,12.061,12.061,0,0,1-1.558,6.084,11.12,11.12,0,0,1-4.576,4.425A15.36,15.36,0,0,1,286.573,1328.762Z"/>
						  <path className="cls-4" d="M569.256,1269.128a19.982,19.982,0,0,1-10.308-2.564,17.587,17.587,0,0,1-6.637-7.291,25.91,25.91,0,0,1,0-21.621,17.581,17.581,0,0,1,6.637-7.291,19.538,19.538,0,0,1,10.308-2.665c4.676,0,8.5,1.157,11.514,3.469a15.236,15.236,0,0,1,5.632,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.861,11.861,0,0,0-9.5,4.124c-2.363,2.715-3.519,6.486-3.519,11.212,0,4.777,1.156,8.5,3.519,11.163a13.434,13.434,0,0,0,16.543,2.162,9.009,9.009,0,0,0,3.419-5.33H586.4a14.784,14.784,0,0,1-5.632,9.3C577.754,1268.022,573.932,1269.128,569.256,1269.128Z"/>
						  <path id="_1-37" data-name="1" className="cls-4" d="M538.685,1328.108v-4.374c2.614-2.062,5.078-4.123,7.441-6.235a83.018,83.018,0,0,0,6.336-6.235,29.556,29.556,0,0,0,4.374-5.984,11.506,11.506,0,0,0,1.609-5.681,9.679,9.679,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.8,6.8,0,0,0-3.872-.955,6.5,6.5,0,0,0-5.38,2.263,8.248,8.248,0,0,0-1.76,5.48h-5.883a13.473,13.473,0,0,1,1.81-7.089,11.078,11.078,0,0,1,4.676-4.325,14.407,14.407,0,0,1,6.688-1.508,12.728,12.728,0,0,1,9.05,3.168c2.263,2.111,3.42,5.078,3.42,8.849a14.777,14.777,0,0,1-1.66,6.688,28.134,28.134,0,0,1-4.223,6.385,54.965,54.965,0,0,1-5.582,5.783c-1.961,1.76-3.871,3.419-5.681,4.827h18.352v5.078Z"/>
						  <path id="_2-19" data-name="2" className="cls-4" d="M571.468,1328.108v-4.374c2.565-2.062,5.079-4.123,7.442-6.235a73.925,73.925,0,0,0,6.285-6.235,29.563,29.563,0,0,0,4.375-5.984,11.516,11.516,0,0,0,1.609-5.681,9.657,9.657,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.739,6.739,0,0,0-3.822-.955,6.535,6.535,0,0,0-5.43,2.263,8.523,8.523,0,0,0-1.76,5.48h-5.883a13.965,13.965,0,0,1,1.81-7.089,11.08,11.08,0,0,1,4.677-4.325,14.549,14.549,0,0,1,6.687-1.508,12.733,12.733,0,0,1,9.051,3.168c2.262,2.111,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,30.142,30.142,0,0,1-4.274,6.385,55.055,55.055,0,0,1-5.581,5.783c-1.961,1.76-3.872,3.419-5.632,4.827h18.3v5.078Z"/>
						  <path className="cls-4" d="M1388.392,1269.128a19.976,19.976,0,0,1-10.307-2.564,17.589,17.589,0,0,1-6.638-7.291,25.91,25.91,0,0,1,0-21.621,17.583,17.583,0,0,1,6.638-7.291,19.532,19.532,0,0,1,10.307-2.665c4.676,0,8.5,1.157,11.515,3.469a15.235,15.235,0,0,1,5.631,9.6H1398.8a9.793,9.793,0,0,0-3.42-5.581,11.26,11.26,0,0,0-7.039-2.062,11.86,11.86,0,0,0-9.5,4.124c-2.363,2.715-3.52,6.486-3.52,11.212,0,4.777,1.157,8.5,3.52,11.163a13.432,13.432,0,0,0,16.542,2.162,9.015,9.015,0,0,0,3.42-5.33h6.737a14.783,14.783,0,0,1-5.631,9.3C1396.89,1268.022,1393.068,1269.128,1388.392,1269.128Z"/>
						  <path id="_1-38" data-name="1" className="cls-4" d="M1354.352,1328.108v-4.374c2.614-2.062,5.078-4.123,7.441-6.235a83.2,83.2,0,0,0,6.336-6.235,29.594,29.594,0,0,0,4.374-5.984,12.068,12.068,0,0,0,1.609-5.681,8.718,8.718,0,0,0-.653-3.47,5.673,5.673,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.214,8.214,0,0,0-1.709,5.48H1354.5a13.955,13.955,0,0,1,1.81-7.089,10.913,10.913,0,0,1,4.726-4.325,14.343,14.343,0,0,1,6.637-1.508,12.944,12.944,0,0,1,9.1,3.168c2.263,2.111,3.369,5.078,3.369,8.849a14.707,14.707,0,0,1-1.609,6.688,31.892,31.892,0,0,1-4.224,6.385,67.268,67.268,0,0,1-5.581,5.783c-2.011,1.76-3.871,3.419-5.682,4.827h18.3v5.078Z"/>
						  <path id="_2-20" data-name="2" className="cls-4" d="M1403.477,1328.762a16.339,16.339,0,0,1-9.353-2.615,16.523,16.523,0,0,1-6.033-7.24,28.982,28.982,0,0,1,0-21.722,16.808,16.808,0,0,1,6.033-7.24,16.339,16.339,0,0,1,9.353-2.615,16.064,16.064,0,0,1,9.3,2.615,16.371,16.371,0,0,1,5.983,7.24,28.982,28.982,0,0,1,0,21.722,15.962,15.962,0,0,1-15.285,9.855Zm0-5.431a9.746,9.746,0,0,0,5.782-1.81,11.959,11.959,0,0,0,3.972-5.279,23.75,23.75,0,0,0,0-16.392,11.8,11.8,0,0,0-3.972-5.229,9.992,9.992,0,0,0-11.615,0,11.81,11.81,0,0,0-3.972,5.229,24.559,24.559,0,0,0,0,16.392,11.967,11.967,0,0,0,3.972,5.279A9.684,9.684,0,0,0,1403.477,1323.331Z"/>
						  <path className="cls-4" d="M1690.534,1269.128a19.664,19.664,0,0,1-10.257-2.564,17.371,17.371,0,0,1-6.688-7.291,25.91,25.91,0,0,1,0-21.621,17.365,17.365,0,0,1,6.688-7.291,19.228,19.228,0,0,1,10.257-2.665c4.676,0,8.548,1.157,11.514,3.469a15.018,15.018,0,0,1,5.632,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.861,11.861,0,0,0-9.5,4.124c-2.312,2.715-3.519,6.486-3.519,11.212,0,4.777,1.207,8.5,3.519,11.163a13.434,13.434,0,0,0,16.543,2.162,9.009,9.009,0,0,0,3.419-5.33h6.738a14.572,14.572,0,0,1-5.632,9.3C1699.082,1268.022,1695.21,1269.128,1690.534,1269.128Z"/>
						  <polygon id="_1-39" data-name="1" className="cls-4" points="1670.271 1328.108 1670.271 1294.872 1663.834 1296.381 1663.834 1291.906 1672.684 1288.034 1676.606 1288.034 1676.606 1328.108 1670.271 1328.108"/>
						  <path id="_2-21" data-name="2" className="cls-4" d="M1698.177,1328.762a14.032,14.032,0,0,1-6.738-1.509,11.674,11.674,0,0,1-4.425-4.123,14.974,14.974,0,0,1-1.91-5.631h5.681a7.307,7.307,0,0,0,2.464,4.575,7.684,7.684,0,0,0,4.978,1.609,8.134,8.134,0,0,0,6.889-3.921c1.81-2.615,2.765-6.638,2.916-12.068a12.1,12.1,0,0,1-4.274,4.324,12.753,12.753,0,0,1-6.687,1.76,13.181,13.181,0,0,1-6.336-1.609,12.886,12.886,0,0,1-4.827-4.475,12.739,12.739,0,0,1-1.81-6.838,13.132,13.132,0,0,1,1.71-6.587,13.984,13.984,0,0,1,4.827-5.028,14.241,14.241,0,0,1,7.441-1.911,15.5,15.5,0,0,1,7.442,1.659,13.21,13.21,0,0,1,4.827,4.425,18.031,18.031,0,0,1,2.665,6.185,29.653,29.653,0,0,1,.855,7.039,32.732,32.732,0,0,1-1.861,11.615,17.316,17.316,0,0,1-5.38,7.743A13.031,13.031,0,0,1,1698.177,1328.762Zm.3-20.213a8.685,8.685,0,0,0,4.274-1.056,8.819,8.819,0,0,0,3.017-2.917,7.277,7.277,0,0,0,1.106-3.972,7.555,7.555,0,0,0-1.106-4.123,8.022,8.022,0,0,0-3.067-2.866,9.688,9.688,0,0,0-8.6,0,8.25,8.25,0,0,0-3.017,2.866,7.97,7.97,0,0,0-1.106,4.073,7.441,7.441,0,0,0,2.413,5.833A8.673,8.673,0,0,0,1698.478,1308.549Z"/>
						  <path className="cls-4" d="M1974.423,1269.128a19.976,19.976,0,0,1-10.307-2.564,17.58,17.58,0,0,1-6.637-7.291,25.9,25.9,0,0,1,0-21.621,17.574,17.574,0,0,1,6.637-7.291,19.532,19.532,0,0,1,10.307-2.665c4.677,0,8.5,1.157,11.515,3.469a15.23,15.23,0,0,1,5.631,9.6h-6.737a9.791,9.791,0,0,0-3.419-5.581,11.263,11.263,0,0,0-7.04-2.062,11.86,11.86,0,0,0-9.5,4.124c-2.363,2.715-3.52,6.486-3.52,11.212,0,4.777,1.157,8.5,3.52,11.163a13.434,13.434,0,0,0,16.543,2.162,9.013,9.013,0,0,0,3.419-5.33h6.737a14.779,14.779,0,0,1-5.631,9.3C1982.921,1268.022,1979.1,1269.128,1974.423,1269.128Z"/>
						  <polygon id="_1-40" data-name="1" className="cls-4" points="1954.512 1328.108 1954.512 1294.872 1948.026 1296.381 1948.026 1291.906 1956.926 1288.034 1960.797 1288.034 1960.797 1328.108 1954.512 1328.108"/>
						  <path id="_2-22" data-name="2" className="cls-4" d="M1982.619,1328.762a16.953,16.953,0,0,1-7.24-1.458,12.208,12.208,0,0,1-5.129-4.073,10.052,10.052,0,0,1-1.911-6.185,10.9,10.9,0,0,1,2.012-6.486,10.109,10.109,0,0,1,5.43-3.872,10.053,10.053,0,0,1-4.726-3.519,8.668,8.668,0,0,1-1.66-5.129,9.45,9.45,0,0,1,1.559-5.33,10.392,10.392,0,0,1,4.475-3.922,18.46,18.46,0,0,1,14.381,0,10.392,10.392,0,0,1,4.475,3.922,9.449,9.449,0,0,1,1.558,5.33,8.9,8.9,0,0,1-1.659,5.129,10.226,10.226,0,0,1-4.726,3.519,10.277,10.277,0,0,1,5.38,3.922,10.694,10.694,0,0,1,2.061,6.436,10.38,10.38,0,0,1-1.91,6.185,12.208,12.208,0,0,1-5.129,4.073A16.957,16.957,0,0,1,1982.619,1328.762Zm0-24.035a7.454,7.454,0,0,0,5.23-1.709,5.581,5.581,0,0,0,1.91-4.425,5.709,5.709,0,0,0-1.86-4.626,9.466,9.466,0,0,0-10.559,0,6.431,6.431,0,0,0,0,9.051A7.5,7.5,0,0,0,1982.619,1304.727Zm0,18.906q4.149,0,6.185-1.961a6.857,6.857,0,0,0,2.062-5.078,6.65,6.65,0,0,0-2.213-5.33,9.2,9.2,0,0,0-6.034-1.86,9.446,9.446,0,0,0-6.084,1.86,7.344,7.344,0,0,0-.1,10.408Q1978.471,1323.634,1982.619,1323.633Z"/>
						  <path className="cls-4" d="M2250.469,1269.128a19.664,19.664,0,0,1-10.257-2.564,17.371,17.371,0,0,1-6.688-7.291,25.91,25.91,0,0,1,0-21.621,17.365,17.365,0,0,1,6.688-7.291,19.228,19.228,0,0,1,10.257-2.665c4.676,0,8.548,1.157,11.515,3.469a15.022,15.022,0,0,1,5.631,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.859,11.859,0,0,0-9.5,4.124c-2.364,2.715-3.52,6.486-3.52,11.212,0,4.777,1.156,8.5,3.52,11.163a13.432,13.432,0,0,0,16.542,2.162,9.009,9.009,0,0,0,3.419-5.33h6.738a14.575,14.575,0,0,1-5.631,9.3C2259.017,1268.022,2255.145,1269.128,2250.469,1269.128Z"/>
						  <polygon id="_1-41" data-name="1" className="cls-4" points="2233.021 1328.108 2233.021 1294.872 2226.585 1296.381 2226.585 1291.906 2235.435 1288.034 2239.307 1288.034 2239.307 1328.108 2233.021 1328.108"/>
						  <polygon id="_2-23" data-name="2" className="cls-4" points="2250.268 1328.108 2265.755 1293.213 2244.938 1293.213 2244.938 1288.034 2272.04 1288.034 2272.04 1292.408 2256.603 1328.108 2250.268 1328.108"/>
						  <path className="cls-4" d="M867.777,1269.128a19.849,19.849,0,0,1-10.307-2.564,17.58,17.58,0,0,1-6.637-7.291,25.9,25.9,0,0,1,0-21.621,17.574,17.574,0,0,1,6.637-7.291,19.407,19.407,0,0,1,10.307-2.665q7.015,0,11.465,3.469a15.079,15.079,0,0,1,5.681,9.6h-6.737a9.859,9.859,0,0,0-3.47-5.581,11.063,11.063,0,0,0-7.039-2.062,12,12,0,0,0-9.5,4.124c-2.313,2.715-3.47,6.486-3.47,11.212q0,7.166,3.47,11.163a11.964,11.964,0,0,0,9.5,4.073,11.7,11.7,0,0,0,7.039-1.911,9.08,9.08,0,0,0,3.47-5.33h6.737a14.636,14.636,0,0,1-5.681,9.3C876.275,1268.022,872.454,1269.128,867.777,1269.128Z"/>
						  <path id="_1-42" data-name="1" className="cls-4" d="M844.3,1328.108v-4.374c2.615-2.062,5.078-4.123,7.442-6.235a83.181,83.181,0,0,0,6.335-6.235,29.6,29.6,0,0,0,4.375-5.984,12.08,12.08,0,0,0,1.609-5.681,9.679,9.679,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.8,6.8,0,0,0-3.872-.955,6.5,6.5,0,0,0-5.38,2.263,8.248,8.248,0,0,0-1.76,5.48H844.5a13.024,13.024,0,0,1,1.81-7.089,11.078,11.078,0,0,1,4.676-4.325,14.407,14.407,0,0,1,6.688-1.508,12.728,12.728,0,0,1,9.05,3.168c2.263,2.111,3.42,5.078,3.42,8.849a14.765,14.765,0,0,1-1.66,6.688,28.1,28.1,0,0,1-4.223,6.385,54.965,54.965,0,0,1-5.582,5.783c-1.961,1.76-3.871,3.419-5.681,4.827h18.352v5.078Z"/>
						  <polygon id="_2-24" data-name="2" className="cls-4" points="881.957 1328.108 881.957 1294.872 875.521 1296.381 875.521 1291.906 884.37 1288.034 888.292 1288.034 888.292 1328.108 881.957 1328.108"/>
						</g>
						<g id="C-active" className={`${openPlan === 1 ? "" : "hidden"}`}>
						  <rect className="cls-12" x="2145.431" y="978.551" width="228.53" height="58.679"/>
						  <rect className="cls-12" x="1591.077" y="978.551" width="228.53" height="57.271"/>
						  <rect className="cls-12" x="1243.129" y="978.551" width="227.926" height="57.271"/>
						  <rect className="cls-12" x="761.482" y="978.551" width="232.753" height="57.271"/>
						  <rect className="cls-12" x="464.922" y="978.551" width="222.898" height="57.271"/>
						  <rect className="cls-12" x="130.851" y="978.551" width="228.58" height="57.271"/>
						  <rect className="cls-12" x="1819.556" y="978.551" width="228.53" height="57.271"/>
						  <rect className="cls-13" x="1005.649" y="1035.771" width="83.266" height="468.674"/>
						  <polygon className="cls-14" points="2387.536 1505.552 2098.116 1505.552 2098.116 1085.651 2141.911 1085.651 2141.962 1037.682 2387.536 1037.481 2387.536 1505.552"/>
						  <polygon className="cls-14" points="1819.556 1505.552 2098.116 1505.552 2098.116 1085.651 2055.326 1085.651 2055.326 1035.771 1819.556 1035.771 1819.556 1505.552"/>
						  <polygon className="cls-14" points="1819.556 1505.552 1531.242 1505.552 1531.242 1085.5 1575.54 1085.5 1575.54 1035.771 1819.556 1035.771 1819.556 1505.552"/>
						  <polygon className="cls-14" points="1243.129 1505.552 1531.242 1505.552 1531.242 1085.5 1486.994 1085.5 1486.994 1035.771 1243.129 1035.771 1243.129 1505.552"/>
						  <polygon className="cls-15" points="456.123 1035.771 698.329 1035.771 698.329 1505.552 409.461 1505.552 409.461 1085.198 456.123 1085.198 456.123 1035.771"/>
						  <polygon className="cls-15" points="366.772 1035.771 130.851 1035.771 130.851 1505.552 409.461 1505.552 409.461 1085.198 366.772 1085.198 366.772 1035.771"/>
						  <polygon className="cls-15" points="1005.649 1035.771 757.409 1035.771 757.409 1085.198 698.329 1085.198 698.329 1505.552 1005.649 1505.552 1005.649 1035.771"/>
						  <path className="cls-6" d="M271.338,1269.128a19.853,19.853,0,0,1-10.308-2.564,17.587,17.587,0,0,1-6.637-7.291,25.91,25.91,0,0,1,0-21.621,17.581,17.581,0,0,1,6.637-7.291,19.411,19.411,0,0,1,10.308-2.665q7.014,0,11.464,3.469a15.08,15.08,0,0,1,5.682,9.6h-6.738a9.857,9.857,0,0,0-3.469-5.581,11.066,11.066,0,0,0-7.04-2.062,12,12,0,0,0-9.5,4.124c-2.313,2.715-3.469,6.486-3.469,11.212q0,7.166,3.469,11.163a11.964,11.964,0,0,0,9.5,4.073,11.7,11.7,0,0,0,7.04-1.911,9.078,9.078,0,0,0,3.469-5.33h6.738a14.637,14.637,0,0,1-5.682,9.3C279.836,1268.022,276.014,1269.128,271.338,1269.128Z"/>
						  <path id="_1-43" data-name="1" className="cls-6" d="M240.214,1328.108v-4.374c2.564-2.062,5.078-4.123,7.441-6.235a83.2,83.2,0,0,0,6.336-6.235,34.015,34.015,0,0,0,4.374-5.984,12.068,12.068,0,0,0,1.609-5.681,9.689,9.689,0,0,0-.653-3.47,5.673,5.673,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.529,8.529,0,0,0-1.76,5.48h-5.882a13.955,13.955,0,0,1,1.81-7.089,11.072,11.072,0,0,1,4.676-4.325,14.549,14.549,0,0,1,6.687-1.508,12.733,12.733,0,0,1,9.051,3.168c2.313,2.111,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,31.892,31.892,0,0,1-4.224,6.385,67.268,67.268,0,0,1-5.581,5.783c-2.011,1.76-3.922,3.419-5.682,4.827h18.3v5.078Z"/>
						  <path id="_2-25" data-name="2" className="cls-6" d="M286.573,1328.762a17.006,17.006,0,0,1-7.089-1.408,11.138,11.138,0,0,1-5.029-4.224,13.307,13.307,0,0,1-2.011-7.19h5.984a8.037,8.037,0,0,0,2.212,5.431,7.851,7.851,0,0,0,5.933,2.212,7.443,7.443,0,0,0,5.632-2.062,7.113,7.113,0,0,0,1.91-5.028,6.157,6.157,0,0,0-2.614-5.48,11.112,11.112,0,0,0-6.386-1.76h-2.967v-5.028h3.068a8.722,8.722,0,0,0,5.43-1.609,5.812,5.812,0,0,0,.453-8.548,6.438,6.438,0,0,0-4.576-1.509,6.565,6.565,0,0,0-4.877,1.81,6.94,6.94,0,0,0-1.961,4.475H273.7a11.521,11.521,0,0,1,1.76-6.084,10.427,10.427,0,0,1,4.475-3.972,16.2,16.2,0,0,1,13.325-.05,9.668,9.668,0,0,1,5.48,8.95,9.058,9.058,0,0,1-1.759,5.631,8.155,8.155,0,0,1-4.727,3.168,9.862,9.862,0,0,1,7.894,10.107,12.061,12.061,0,0,1-1.558,6.084,11.12,11.12,0,0,1-4.576,4.425A15.36,15.36,0,0,1,286.573,1328.762Z"/>
						  <path className="cls-6" d="M569.256,1269.128a19.982,19.982,0,0,1-10.308-2.564,17.587,17.587,0,0,1-6.637-7.291,25.91,25.91,0,0,1,0-21.621,17.581,17.581,0,0,1,6.637-7.291,19.538,19.538,0,0,1,10.308-2.665c4.676,0,8.5,1.157,11.514,3.469a15.236,15.236,0,0,1,5.632,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.861,11.861,0,0,0-9.5,4.124c-2.363,2.715-3.519,6.486-3.519,11.212,0,4.777,1.156,8.5,3.519,11.163a13.434,13.434,0,0,0,16.543,2.162,9.009,9.009,0,0,0,3.419-5.33H586.4a14.784,14.784,0,0,1-5.632,9.3C577.754,1268.022,573.932,1269.128,569.256,1269.128Z"/>
						  <path id="_1-44" data-name="1" className="cls-6" d="M538.685,1328.108v-4.374c2.614-2.062,5.078-4.123,7.441-6.235a83.018,83.018,0,0,0,6.336-6.235,29.556,29.556,0,0,0,4.374-5.984,11.506,11.506,0,0,0,1.609-5.681,9.679,9.679,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.8,6.8,0,0,0-3.872-.955,6.5,6.5,0,0,0-5.38,2.263,8.248,8.248,0,0,0-1.76,5.48h-5.883a13.473,13.473,0,0,1,1.81-7.089,11.078,11.078,0,0,1,4.676-4.325,14.407,14.407,0,0,1,6.688-1.508,12.728,12.728,0,0,1,9.05,3.168c2.263,2.111,3.42,5.078,3.42,8.849a14.777,14.777,0,0,1-1.66,6.688,28.134,28.134,0,0,1-4.223,6.385,54.965,54.965,0,0,1-5.582,5.783c-1.961,1.76-3.871,3.419-5.681,4.827h18.352v5.078Z"/>
						  <path id="_2-26" data-name="2" className="cls-6" d="M571.468,1328.108v-4.374c2.565-2.062,5.079-4.123,7.442-6.235a73.925,73.925,0,0,0,6.285-6.235,29.563,29.563,0,0,0,4.375-5.984,11.516,11.516,0,0,0,1.609-5.681,9.657,9.657,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.739,6.739,0,0,0-3.822-.955,6.535,6.535,0,0,0-5.43,2.263,8.523,8.523,0,0,0-1.76,5.48h-5.883a13.965,13.965,0,0,1,1.81-7.089,11.08,11.08,0,0,1,4.677-4.325,14.549,14.549,0,0,1,6.687-1.508,12.733,12.733,0,0,1,9.051,3.168c2.262,2.111,3.419,5.078,3.419,8.849a15.377,15.377,0,0,1-1.609,6.688,30.142,30.142,0,0,1-4.274,6.385,55.055,55.055,0,0,1-5.581,5.783c-1.961,1.76-3.872,3.419-5.632,4.827h18.3v5.078Z"/>
						  <path className="cls-6" d="M1388.392,1269.128a19.976,19.976,0,0,1-10.307-2.564,17.589,17.589,0,0,1-6.638-7.291,25.91,25.91,0,0,1,0-21.621,17.583,17.583,0,0,1,6.638-7.291,19.532,19.532,0,0,1,10.307-2.665c4.676,0,8.5,1.157,11.515,3.469a15.235,15.235,0,0,1,5.631,9.6H1398.8a9.793,9.793,0,0,0-3.42-5.581,11.26,11.26,0,0,0-7.039-2.062,11.86,11.86,0,0,0-9.5,4.124c-2.363,2.715-3.52,6.486-3.52,11.212,0,4.777,1.157,8.5,3.52,11.163a13.432,13.432,0,0,0,16.542,2.162,9.015,9.015,0,0,0,3.42-5.33h6.737a14.783,14.783,0,0,1-5.631,9.3C1396.89,1268.022,1393.068,1269.128,1388.392,1269.128Z"/>
						  <path id="_1-45" data-name="1" className="cls-6" d="M1354.352,1328.108v-4.374c2.614-2.062,5.078-4.123,7.441-6.235a83.2,83.2,0,0,0,6.336-6.235,29.594,29.594,0,0,0,4.374-5.984,12.068,12.068,0,0,0,1.609-5.681,8.718,8.718,0,0,0-.653-3.47,5.673,5.673,0,0,0-2.062-2.665,6.625,6.625,0,0,0-3.821-.955,6.536,6.536,0,0,0-5.431,2.263,8.214,8.214,0,0,0-1.709,5.48H1354.5a13.955,13.955,0,0,1,1.81-7.089,10.913,10.913,0,0,1,4.726-4.325,14.343,14.343,0,0,1,6.637-1.508,12.944,12.944,0,0,1,9.1,3.168c2.263,2.111,3.369,5.078,3.369,8.849a14.707,14.707,0,0,1-1.609,6.688,31.892,31.892,0,0,1-4.224,6.385,67.268,67.268,0,0,1-5.581,5.783c-2.011,1.76-3.871,3.419-5.682,4.827h18.3v5.078Z"/>
						  <path id="_2-27" data-name="2" className="cls-6" d="M1403.477,1328.762a16.339,16.339,0,0,1-9.353-2.615,16.523,16.523,0,0,1-6.033-7.24,28.982,28.982,0,0,1,0-21.722,16.808,16.808,0,0,1,6.033-7.24,16.339,16.339,0,0,1,9.353-2.615,16.064,16.064,0,0,1,9.3,2.615,16.371,16.371,0,0,1,5.983,7.24,28.982,28.982,0,0,1,0,21.722,15.962,15.962,0,0,1-15.285,9.855Zm0-5.431a9.746,9.746,0,0,0,5.782-1.81,11.959,11.959,0,0,0,3.972-5.279,23.75,23.75,0,0,0,0-16.392,11.8,11.8,0,0,0-3.972-5.229,9.992,9.992,0,0,0-11.615,0,11.81,11.81,0,0,0-3.972,5.229,24.559,24.559,0,0,0,0,16.392,11.967,11.967,0,0,0,3.972,5.279A9.684,9.684,0,0,0,1403.477,1323.331Z"/>
						  <path className="cls-6" d="M1690.534,1269.128a19.664,19.664,0,0,1-10.257-2.564,17.371,17.371,0,0,1-6.688-7.291,25.91,25.91,0,0,1,0-21.621,17.365,17.365,0,0,1,6.688-7.291,19.228,19.228,0,0,1,10.257-2.665c4.676,0,8.548,1.157,11.514,3.469a15.018,15.018,0,0,1,5.632,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.861,11.861,0,0,0-9.5,4.124c-2.312,2.715-3.519,6.486-3.519,11.212,0,4.777,1.207,8.5,3.519,11.163a13.434,13.434,0,0,0,16.543,2.162,9.009,9.009,0,0,0,3.419-5.33h6.738a14.572,14.572,0,0,1-5.632,9.3C1699.082,1268.022,1695.21,1269.128,1690.534,1269.128Z"/>
						  <polygon id="_1-46" data-name="1" className="cls-6" points="1670.271 1328.108 1670.271 1294.872 1663.834 1296.381 1663.834 1291.906 1672.684 1288.034 1676.606 1288.034 1676.606 1328.108 1670.271 1328.108"/>
						  <path id="_2-28" data-name="2" className="cls-6" d="M1698.177,1328.762a14.032,14.032,0,0,1-6.738-1.509,11.674,11.674,0,0,1-4.425-4.123,14.974,14.974,0,0,1-1.91-5.631h5.681a7.307,7.307,0,0,0,2.464,4.575,7.684,7.684,0,0,0,4.978,1.609,8.134,8.134,0,0,0,6.889-3.921c1.81-2.615,2.765-6.638,2.916-12.068a12.1,12.1,0,0,1-4.274,4.324,12.753,12.753,0,0,1-6.687,1.76,13.181,13.181,0,0,1-6.336-1.609,12.886,12.886,0,0,1-4.827-4.475,12.739,12.739,0,0,1-1.81-6.838,13.132,13.132,0,0,1,1.71-6.587,13.984,13.984,0,0,1,4.827-5.028,14.241,14.241,0,0,1,7.441-1.911,15.5,15.5,0,0,1,7.442,1.659,13.21,13.21,0,0,1,4.827,4.425,18.031,18.031,0,0,1,2.665,6.185,29.653,29.653,0,0,1,.855,7.039,32.732,32.732,0,0,1-1.861,11.615,17.316,17.316,0,0,1-5.38,7.743A13.031,13.031,0,0,1,1698.177,1328.762Zm.3-20.213a8.685,8.685,0,0,0,4.274-1.056,8.819,8.819,0,0,0,3.017-2.917,7.277,7.277,0,0,0,1.106-3.972,7.555,7.555,0,0,0-1.106-4.123,8.022,8.022,0,0,0-3.067-2.866,9.688,9.688,0,0,0-8.6,0,8.25,8.25,0,0,0-3.017,2.866,7.97,7.97,0,0,0-1.106,4.073,7.441,7.441,0,0,0,2.413,5.833A8.673,8.673,0,0,0,1698.478,1308.549Z"/>
						  <path className="cls-6" d="M1974.423,1269.128a19.976,19.976,0,0,1-10.307-2.564,17.58,17.58,0,0,1-6.637-7.291,25.9,25.9,0,0,1,0-21.621,17.574,17.574,0,0,1,6.637-7.291,19.532,19.532,0,0,1,10.307-2.665c4.677,0,8.5,1.157,11.515,3.469a15.23,15.23,0,0,1,5.631,9.6h-6.737a9.791,9.791,0,0,0-3.419-5.581,11.263,11.263,0,0,0-7.04-2.062,11.86,11.86,0,0,0-9.5,4.124c-2.363,2.715-3.52,6.486-3.52,11.212,0,4.777,1.157,8.5,3.52,11.163a13.434,13.434,0,0,0,16.543,2.162,9.013,9.013,0,0,0,3.419-5.33h6.737a14.779,14.779,0,0,1-5.631,9.3C1982.921,1268.022,1979.1,1269.128,1974.423,1269.128Z"/>
						  <polygon id="_1-47" data-name="1" className="cls-6" points="1954.512 1328.108 1954.512 1294.872 1948.026 1296.381 1948.026 1291.906 1956.926 1288.034 1960.797 1288.034 1960.797 1328.108 1954.512 1328.108"/>
						  <path id="_2-29" data-name="2" className="cls-6" d="M1982.619,1328.762a16.953,16.953,0,0,1-7.24-1.458,12.208,12.208,0,0,1-5.129-4.073,10.052,10.052,0,0,1-1.911-6.185,10.9,10.9,0,0,1,2.012-6.486,10.109,10.109,0,0,1,5.43-3.872,10.053,10.053,0,0,1-4.726-3.519,8.668,8.668,0,0,1-1.66-5.129,9.45,9.45,0,0,1,1.559-5.33,10.392,10.392,0,0,1,4.475-3.922,18.46,18.46,0,0,1,14.381,0,10.392,10.392,0,0,1,4.475,3.922,9.449,9.449,0,0,1,1.558,5.33,8.9,8.9,0,0,1-1.659,5.129,10.226,10.226,0,0,1-4.726,3.519,10.277,10.277,0,0,1,5.38,3.922,10.694,10.694,0,0,1,2.061,6.436,10.38,10.38,0,0,1-1.91,6.185,12.208,12.208,0,0,1-5.129,4.073A16.957,16.957,0,0,1,1982.619,1328.762Zm0-24.035a7.454,7.454,0,0,0,5.23-1.709,5.581,5.581,0,0,0,1.91-4.425,5.709,5.709,0,0,0-1.86-4.626,9.466,9.466,0,0,0-10.559,0,6.431,6.431,0,0,0,0,9.051A7.5,7.5,0,0,0,1982.619,1304.727Zm0,18.906q4.149,0,6.185-1.961a6.857,6.857,0,0,0,2.062-5.078,6.65,6.65,0,0,0-2.213-5.33,9.2,9.2,0,0,0-6.034-1.86,9.446,9.446,0,0,0-6.084,1.86,7.344,7.344,0,0,0-.1,10.408Q1978.471,1323.634,1982.619,1323.633Z"/>
						  <path className="cls-6" d="M2250.469,1269.128a19.664,19.664,0,0,1-10.257-2.564,17.371,17.371,0,0,1-6.688-7.291,25.91,25.91,0,0,1,0-21.621,17.365,17.365,0,0,1,6.688-7.291,19.228,19.228,0,0,1,10.257-2.665c4.676,0,8.548,1.157,11.515,3.469a15.022,15.022,0,0,1,5.631,9.6h-6.738a9.786,9.786,0,0,0-3.419-5.581,11.262,11.262,0,0,0-7.039-2.062,11.859,11.859,0,0,0-9.5,4.124c-2.364,2.715-3.52,6.486-3.52,11.212,0,4.777,1.156,8.5,3.52,11.163a13.432,13.432,0,0,0,16.542,2.162,9.009,9.009,0,0,0,3.419-5.33h6.738a14.575,14.575,0,0,1-5.631,9.3C2259.017,1268.022,2255.145,1269.128,2250.469,1269.128Z"/>
						  <polygon id="_1-48" data-name="1" className="cls-6" points="2233.021 1328.108 2233.021 1294.872 2226.585 1296.381 2226.585 1291.906 2235.435 1288.034 2239.307 1288.034 2239.307 1328.108 2233.021 1328.108"/>
						  <polygon id="_2-30" data-name="2" className="cls-6" points="2250.268 1328.108 2265.755 1293.213 2244.938 1293.213 2244.938 1288.034 2272.04 1288.034 2272.04 1292.408 2256.603 1328.108 2250.268 1328.108"/>
						  <path className="cls-6" d="M867.777,1269.128a19.849,19.849,0,0,1-10.307-2.564,17.58,17.58,0,0,1-6.637-7.291,25.9,25.9,0,0,1,0-21.621,17.574,17.574,0,0,1,6.637-7.291,19.407,19.407,0,0,1,10.307-2.665q7.015,0,11.465,3.469a15.079,15.079,0,0,1,5.681,9.6h-6.737a9.859,9.859,0,0,0-3.47-5.581,11.063,11.063,0,0,0-7.039-2.062,12,12,0,0,0-9.5,4.124c-2.313,2.715-3.47,6.486-3.47,11.212q0,7.166,3.47,11.163a11.964,11.964,0,0,0,9.5,4.073,11.7,11.7,0,0,0,7.039-1.911,9.08,9.08,0,0,0,3.47-5.33h6.737a14.636,14.636,0,0,1-5.681,9.3C876.275,1268.022,872.454,1269.128,867.777,1269.128Z"/>
						  <path id="_1-49" data-name="1" className="cls-6" d="M844.3,1328.108v-4.374c2.615-2.062,5.078-4.123,7.442-6.235a83.181,83.181,0,0,0,6.335-6.235,29.6,29.6,0,0,0,4.375-5.984,12.08,12.08,0,0,0,1.609-5.681,9.679,9.679,0,0,0-.6-3.47,6,6,0,0,0-2.061-2.665,6.8,6.8,0,0,0-3.872-.955,6.5,6.5,0,0,0-5.38,2.263,8.248,8.248,0,0,0-1.76,5.48H844.5a13.024,13.024,0,0,1,1.81-7.089,11.078,11.078,0,0,1,4.676-4.325,14.407,14.407,0,0,1,6.688-1.508,12.728,12.728,0,0,1,9.05,3.168c2.263,2.111,3.42,5.078,3.42,8.849a14.765,14.765,0,0,1-1.66,6.688,28.1,28.1,0,0,1-4.223,6.385,54.965,54.965,0,0,1-5.582,5.783c-1.961,1.76-3.871,3.419-5.681,4.827h18.352v5.078Z"/>
						  <polygon id="_2-31" data-name="2" className="cls-6" points="881.957 1328.108 881.957 1294.872 875.521 1296.381 875.521 1291.906 884.37 1288.034 888.292 1288.034 888.292 1328.108 881.957 1328.108"/>
						</g>
					</g>					
				</svg>
			</div>			
		</div>
	</div>
  );
};

export default Plans;