import React, { useEffect, useRef, useState } from "react";
import { Link } from "react-router-dom";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import HomesAnchor from "../../assets/img/features/feature-anchor.jpg";
import Insert from "../../assets/img/features/Web-Features.pdf";
import SquareFrame from "../../assets/img/squareframe.svg";
import Bathroom from "../../assets/img/features/feature-bathroom.jpg";
import Bedroom from "../../assets/img/features/feature-bedroom.jpg";
import FlexSpace from "../../assets/img/features/feature-flex-space.jpg";
import Kitchen from "../../assets/img/features/feature-kitchen.jpg";
import RoofDeck from "../../assets/img/features/feature-roof-deck.jpg"
import GoldSquare from "../../assets/img/features/gold-square.svg";
import Highlights from "./Highlights";

const Features = () => {
	const [slide1top, setslide1top] = useState("");
	const [slide2top, setslide2top] = useState("");
	const [slide3top, setslide3top] = useState("");
	const [slide4top, setslide4top] = useState("");
	const [slide5top, setslide5top] = useState("");
 	const handleSlider = () => {
		if (window.innerWidth < 1024) {
			if ((document.getElementById("slide1-block").offsetHeight + document.getElementById("slide1-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide1").style.height = document.getElementById("slide1-block").offsetHeight + document.getElementById("slide1-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide1").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}	
			
			if ((document.getElementById("slide2-block").offsetHeight + document.getElementById("slide2-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide2").style.height = document.getElementById("slide2-block").offsetHeight + document.getElementById("slide2-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide2").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
			
			if ((document.getElementById("slide3-block").offsetHeight + document.getElementById("slide3-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide3").style.height = document.getElementById("slide3-block").offsetHeight + document.getElementById("slide3-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide3").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
			
			if ((document.getElementById("slide4-block").offsetHeight + document.getElementById("slide4-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide4").style.height = document.getElementById("slide4-block").offsetHeight + document.getElementById("slide4-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide4").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
			
			if ((document.getElementById("slide5-block").offsetHeight + document.getElementById("slide5-img").offsetHeight) > (window.innerHeight - (window.innerWidth * 0.18))) {
				document.getElementById("slide5").style.height = document.getElementById("slide5-block").offsetHeight + document.getElementById("slide5-img").offsetHeight + "px";
		  	}
			else {
				document.getElementById("slide5").style.height = window.innerHeight - (window.innerWidth * 0.18) + "px";
			}
		}
		else {
			document.getElementById("slide1").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide2").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide3").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide4").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
			document.getElementById("slide5").style.height = window.innerHeight - (window.innerWidth * 0.078) + "px";
		}
	};
	useEffect(() => {
		window.addEventListener('load', handleSlider);
		window.addEventListener('resize', handleSlider);
		document.title = 'Features | West58 | Vancouver West Side 1-3 Bed Townhomes & Garden Suites';
		return () => {
			window.removeEventListener('load', handleSlider);
			window.removeEventListener('resize', handleSlider);
		};
	}, []);
  return (
    <div className="relative w-full">
		<MainSiteHeader designSrc={HomesAnchor}/>	
		<div className="px-0 lg:px-[10vw] w-full relative lg:pt-[50px]">
			<div className="flex flex-col-reverse lg:flex-row">
				<div className="flex-none w-full lg:w-[50vw]">
					<Highlights />
				</div>
				<div className="flex flex-1 justify-end items-center" data-aos="fade-left" data-aos-delay="500">
					<div className="px-[25px] lg:px-0 py-[50px] lg:py-0 w-full lg:w-[calc(100%-50px)]">
						<div className="relative w-[130px] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed for
								<br></br>
								Well-Being
							</h2>
							<img className="" src={SquareFrame}></img>
						</div>
						<p>Behind a modern exterior façade with Hardie board accents, through oversized windows and under soaring 9 ft ceilings, West58 delivers all the sophisticated features you want in a home. Generous 1-3 bedroom homes with open layouts and flowing with functionality and warmth? Check. Open kitchens with state-of-the art appliances? You bet. Luxurious main floor powder rooms and spa-like ensuites? It’s all right here.</p>
						<br></br>
						<a href={Insert} target="_blank"><h3>Explore Our Features &#8594;</h3></a>
					</div>
				</div>
			</div>
		</div>
		<div className="lg:hidden w-full relative overflow-clip" id="slider-wrap">
			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip" id="slide1">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide1-block" data-aos="fade-down" data-aos-delay="0">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Kitchen
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>The open-concept kitchens at West58 are designed to be the centre of family life, where every meal becomes an occasion and every gathering feels special. Anchored by a large centre island, provides ample space for everyone to gather around, whether you’re preparing a feast or enjoying a casual breakfast.</p>
					<br></br>
					<p>Highlights:</p>
					<ul style={{ 
					  listStyleImage: `url(${GoldSquare})`,
					}}>
						<li>Polished quartz countertops</li>
						<li>Sleek white cabinetry with soft-closing feature and under-cabinet lighting</li>
						<li>Premium stainless steel appliance package featuring Bosch and Fisher & Paykel</li>
					</ul>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Kitchen} id="slide1-img"></img>
						</div>
					</div>
				</div>
			</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip " id="slide2">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide2-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Bathroom
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>When it’s time to unwind, indulgent bathrooms offer a retreat for ending each day right. Bathrooms at West58 invite relaxation with modern soaker bathtubs or frameless glass showers. Double vanities available in select homes.</p>
					<br></br>
					<p>Highlights:</p>
					<ul style={{ 
					  listStyleImage: `url(${GoldSquare})`,
					}}>
						<li>Riobel bath & shower fixtures</li>
						<li>Polished quartz vanities with undermount sinks</li>
						<li>Large porcelain floor & wall tiles in ensuites</li>
					</ul>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Bathroom} id="slide2-img"></img>
						</div>
					</div>
				</div>
			</div>
			
			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip " id="slide3">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide3-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Bedroom
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Soft waffle pattern carpeting in the sizable bedrooms add warmth, while transitional sheer and privacy window coverings let you set hte perfect mood.</p>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Bedroom} id="slide3-img"></img>
						</div>
					</div>
				</div>
			</div>
			
			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip " id="slide4">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide4-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Roof Deck
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Effortlessly extending your living space outdoors, many homes feature private third-floor blaconies with sweeping views of Vancouver.</p>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={RoofDeck} id="slide4-img"></img>
						</div>
					</div>
				</div>
			</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip" id="slide5">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0" id="slide5-block">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Flex Space
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Ample flex space in the West58 homes that can easily be converted into a home office or extra storage.</p>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={FlexSpace} id="slide5-img"></img>
						</div>
					</div>
				</div>
			</div>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Features;