import React, { useRef, useState } from "react";
import "./Highlights.css";
import ZoomIcon from "../../assets/img/features/zoomicon.svg";
import Building from "../../assets/img/features/feature-building.jpg";
import Bathroom from "../../assets/img/features/feature-bathroom.jpg";
import Bedroom from "../../assets/img/features/feature-bedroom.jpg";
import FlexSpace from "../../assets/img/features/feature-flex-space.jpg";
import Kitchen from "../../assets/img/features/feature-kitchen.jpg";
import RoofDeck from "../../assets/img/features/feature-roof-deck.jpg";
import SquareFrame from "../../assets/img/squareframe.svg";
import GoldSquare from "../../assets/img/features/gold-square.svg";
import CloseIcon from "../../assets/img/close-btn.svg";
import Slider, { slickGoTo } from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";

const dots = [
  {
    position: "top-[68.5%] left-[82.07%]",
    boxPosition: "-top-[75px] -left-[0]",
	boxWidth: "w-auto",
    description:
      "Kitchen",
  },
  {
    position: "top-[41%] left-[53.35%]",
    boxPosition: "-top-[75px] -left-[0]",
	boxWidth: "w-auto",
    description:
      "Bathroom",
  },
  {
    position: "top-[41%] left-[82.07%]",
    boxPosition: "-top-[75px] -left-[0]",
	boxWidth: "w-auto",
    description:
      "Bedroom",
  },
  {
    position: "top-[21.98%] left-[83.07%]",
    boxPosition: "-top-[75px] -left-[0]",
	boxWidth: "w-[105px]",
    description:
      "Roof Deck",
  },
  {
    position: "top-[88.43%] left-[82.07%]",
    boxPosition: "-top-[75px] -left-[0]",
	boxWidth: "w-[110px]",
    description:
      "Flex Space",
  },
];

const Highlights = () => {
  const [slideIndex, setSlideIndex] = useState(0);
  let sliderRef1 = useRef(null);
  const settings = {
    dots: false,
    infinite: false,
	arrow: false,
	autoplay: false,
    speed: 0,
    slidesToShow: 1,
    slidesToScroll: 1,
    beforeChange: (current, next) => setSlideIndex(next)
  };
  const [activeDot, setActiveDot] = useState(-1);
  const [showHomesCard, setShowHomesCard] = useState("");
  function handleDotClick(index) {
	  
	  if ((window.innerWidth < 960)&&(index > -1)) {	  
		  window.scrollTo({behavior: "smooth", top: document.getElementById('slide'+(1+index)).getBoundingClientRect().top - document.body.getBoundingClientRect().top - (window.innerWidth * 0.18) });
	  }
	  else {
		  if (index === 0) {
			  document.getElementById('KitchenCard').classList.add('activeCard');
		  }
		  else if (index === 1) {
			  document.getElementById('BathroomCard').classList.add('activeCard');
		  }
		  else if (index === 2) {
			  document.getElementById('BedroomCard').classList.add('activeCard');
		  }
		  else if (index === 3) {
			  document.getElementById('RoofDeckCard').classList.add('activeCard');
		  }
		  else if (index === 4) {
			  document.getElementById('FlexSpaceCard').classList.add('activeCard');
		  }
		  else {
			  if (activeDot === 0) {
				  document.getElementById('KitchenCard').classList.remove('activeCard');
			  }
			  else if (activeDot === 1) {
				  document.getElementById('BathroomCard').classList.remove('activeCard');
			  }
			  else if (activeDot === 2) {
				  document.getElementById('BedroomCard').classList.remove('activeCard');
			  }
			  else if (activeDot === 3) {
				  document.getElementById('RoofDeckCard').classList.remove('activeCard');
			  }
			  else if (activeDot === 4) {
				  document.getElementById('FlexSpaceCard').classList.remove('activeCard');
			  }
		  }
	  }
	  setActiveDot(index);
  }
  return (
	<div className="w-full mx-auto relative mb-[50px] lg:mb-[50px]">
	  <div className="w-full" data-aos="fade-down" data-aos-delay="0">
		<img className="w-full" src={Building} alt="banner" />
	  </div>

	  <div>
		{dots.map(
		  ({ position, boxPosition, boxWidth, description }, i) => (
			<div className={`absolute ${position} group`} key={i} data-aos="fade-up" data-aos-delay="0">
				  <img src={ZoomIcon} className={`transition-all w-[30px] translate-x-[-50%] translate-y-[-50%] hover:w-[40px] group-hover:w-[40px] ${
				  activeDot === i ? "w-[40px]" : "w-[30px]"
				} cursor-pointer`}
				onClick={() => handleDotClick(i)}></img>

			  <div
				className={`absolute ${boxWidth} translate-x-[-50%] bg-[rgba(255,255,255,0.6)] p-3 transition-all duration-700 opacity-0 group-hover:opacity-100 ${boxPosition} ${
				  activeDot === i ? "opacity-100" : "opacity-0"
				}`}
			  >
				<div className="relative font-bold text-center">{description}</div>
			  </div>
			</div>
		  )
		)}
	  </div>

		<div className={`card lg:flex fixed items-center justify-center w-full h-[100vh] top-0 left-0 bg-[rgba(0,0,0,0.5)] opacity-0 border-none ${activeDot === 0 ? "" : ""}`} onClick={() => handleDotClick(-1)} id="KitchenCard">
			<div className="relative w-[80vw] bg-white flex items-center border-none">
				<div className="flex flex-initial items-stretch w-full lg:w-[50vw] border-none">
					<img className="w-full object-cover border-none" src={Kitchen} alt="Kitchen" />
				</div>
				<div className="flex flex-1 justify-end items-center">
					<div className="px-[50px] w-full] text-[0.85vw]">
						<div className="relative w-[6.8vw] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%] text-[1.875vw]">Kitchen
							</h2>
							<img src={SquareFrame}></img>
						</div>
						<p>The open-concept kitchens at West58 are designed to be the centre of family life, where every meal becomes an occasion and every gathering feels special. Anchored by a large centre island, provides ample space for everyone to gather around, whether you’re preparing a feast or enjoying a casual breakfast.</p>
						<br></br>
						<p>Highlights:</p>
						<ul style={{ 
						  listStyleImage: `url(${GoldSquare})`,
						}}>
							<li>Polished quartz countertops</li>
							<li>Sleek white cabinetry with soft-closing feature and under-cabinet lighting</li>
							<li>Premium stainless steel appliance package featuring Bosch and Fisher & Paykel</li>
						</ul>
					</div>
				</div>
				<div className="absolute top-[1.5vw] right-[2vw] w-[2vw]"><img className="cursor-pointer" src={CloseIcon}></img></div>
			</div>
		</div>
		  
		<div className={`card lg:flex fixed items-center justify-center w-full h-[100vh] top-0 left-0 bg-[rgba(0,0,0,0.5)] opacity-0 border-none ${activeDot === 0 ? "" : ""}`} onClick={() => handleDotClick(-1)} id="BathroomCard">
			<div className="relative w-[80vw] bg-white flex items-center">
				<div className="flex flex-initial items-stretch w-full lg:w-[50vw]">
					<img className="w-full object-cover" src={Bathroom} alt="Bathroom" />
				</div>
				<div className="flex flex-1 justify-end items-center">
					<div className="px-[50px] w-full] text-[0.85vw]">
						<div className="relative w-[6.8vw] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%] text-[1.875vw]">Bathroom
							</h2>
							<img  src={SquareFrame}></img>
						</div>
						<p>When it’s time to unwind, indulgent bathrooms offer a retreat for ending each day right. Bathrooms at West58 invite relaxation with modern soaker bathtubs or frameless glass showers. Double vanities available in select homes.</p>
						<br></br>
						<p>Highlights:</p>
						<ul style={{ 
						  listStyleImage: `url(${GoldSquare})`,
						}}>
							<li>Riobel bath & shower fixtures</li>
							<li>Polished quartz vanities with undermount sinks</li>
							<li>Large porcelain floor & wall tiles in ensuites</li>
						</ul>
					</div>
				</div>
				<div className="absolute top-[1.5vw] right-[2vw] w-[2vw]"><img className="cursor-pointer" src={CloseIcon}></img></div>
			</div>
		</div>
		  
		<div className={`card lg:flex fixed items-center justify-center w-full h-[100vh] top-0 left-0 bg-[rgba(0,0,0,0.5)] opacity-0 border-none ${activeDot === 0 ? "" : ""}`} onClick={() => handleDotClick(-1)} id="BedroomCard">
			<div className="relative w-[80vw] bg-white flex items-center">
				<div className="flex flex-initial items-stretch w-full lg:w-[50vw]">
					<img className="w-full object-cover" src={Bedroom} alt="Bedroom" />
				</div>
				<div className="flex flex-1 justify-end items-center">
					<div className="px-[50px] w-full] text-[0.85vw]">
						<div className="relative w-[6.8vw] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%] text-[1.875vw]">Bedroom
							</h2>
							<img  src={SquareFrame}></img>
						</div>
						<p>Soft waffle pattern carpeting in the sizable bedrooms add warmth, while transitional sheer and privacy window coverings let you set the perfect mood.</p>
					</div>
				</div>
				<div className="absolute top-[1.5vw] right-[2vw] w-[2vw]"><img className="cursor-pointer" src={CloseIcon}></img></div>
			</div>
		</div>
		  
		<div className={`card lg:flex fixed items-center justify-center w-full h-[100vh] top-0 left-0 bg-[rgba(0,0,0,0.5)] opacity-0 border-none ${activeDot === 0 ? "" : ""}`} onClick={() => handleDotClick(-1)} id="RoofDeckCard">
			<div className="relative w-[80vw] bg-white flex items-center">
				<div className="flex flex-initial items-stretch w-full lg:w-[50vw]">
					<img className="w-full object-cover" src={RoofDeck} alt="Roof Deck" />
				</div>
				<div className="flex flex-1 justify-end items-center">
					<div className="px-[50px] w-full] text-[0.85vw]">
						<div className="relative w-[6.8vw] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%] text-[1.875vw]">Roof Deck
							</h2>
							<img  src={SquareFrame}></img>
						</div>
						<p>Effortlessly extending your living space outdoors, many homes feature private third-floor blaconies with sweeping views of Vancouver.</p>
					</div>
				</div>
				<div className="absolute top-[1.5vw] right-[2vw] w-[2vw]"><img className="cursor-pointer" src={CloseIcon}></img></div>
			</div>
		</div>
		  
		<div className={`card lg:flex fixed items-center justify-center w-full h-[100vh] top-0 left-0 bg-[rgba(0,0,0,0.5)] opacity-0 border-none ${activeDot === 0 ? "" : ""}`} onClick={() => handleDotClick(-1)} id="FlexSpaceCard">
			<div className="relative w-[80vw] bg-white flex items-center">
				<div className="flex flex-initial items-stretch w-full lg:w-[50vw]">
					<img className="w-full object-cover" src={FlexSpace} alt="Flex Space" />
				</div>
				<div className="flex flex-1 justify-end items-center">
					<div className="px-[50px] w-full] text-[0.85vw]">
						<div className="relative w-[6.8vw] mb-[50px]">
							<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%] text-[1.875vw]">Flex Space
							</h2>
							<img  src={SquareFrame}></img>
						</div>
						<p>Ample flex space in the West58 homes that can easily be converted into a home office or extra storage.</p>
					</div>
				</div>
				<div className="absolute top-[1.5vw] right-[2vw] w-[2vw]"><img className="cursor-pointer" src={CloseIcon}></img></div>
			</div>
		</div>
	</div>
  );
};

export default Highlights;
