import React from "react";
import Home from "../pages/Home";
import Register from "../pages/Register";
import RegisterMain from "../pages/Register/RegisterMain";
import Thankyou from "../pages/Thankyou";
import PrivacyPolicy from "../pages/PrivacyPolicy";
import Neighbourhood from "../pages/Neighbourhood";
import Floorplans from "../pages/Floorplans";
import Features from "../pages/Features";
import Gallery from "../pages/Gallery";
import Team from "../pages/Team";

const useRoutes = () => {
  return [
    { index: true, element: <Home /> },
    {
      path: "register",
      element: <Register />,
      children: [
        {
          index: true,
          element: <RegisterMain />,
        },
        {
          path: "thank-you",
          element: <Thankyou />,
        },
      ],
    },
    {
      path: "privacy-policy",
      label: "Privacy Policy",
      element: <PrivacyPolicy />,
    },
	{
      path: "neighbourhood",
      label: "Neighbourhood",
      element: <Neighbourhood />,
    },
	{
      path: "floorplans",
      label: "Floorplans",
      element: <Floorplans />,
    },
	{
      path: "features",
      label: "Features",
      element: <Features />,
    },
	{
      path: "gallery",
      label: "Gallery",
      element: <Gallery />,
    },
	{
      path: "team",
      label: "Team",
      element: <Team />,
    },
  ];
};

export default useRoutes;
