import React from 'react';
import { Link } from "react-router-dom";
import Logo from "../assets/img/logo/W58-logo.svg";
import WaterMark from "../assets/img/logo/58watermark.svg";
import Azora from "../assets/img/logo/azora-logo.svg";
import AzoraHZ from "../assets/img/logo/azora_logo_horizontal.svg";

const SiteHeader = () => {
  return (
    <div className="relative w-full">
			<div className="relative w-full flex flex-row h-[19vw] lg:h-[12vw]">
				<div className="basis-1/3 lg:basis-1/5 flex flex-row items-center">
					<div className="basis-1/5">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
					<div className="basis-3/5 bg-white flex justify-center">
						<div className="relative" data-aos="fade-down" data-aos-delay="0">
							<Link to="/"><img src={Logo} className="transition-all w-[15vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
						</div>
					</div>
					<div className="basis-1/5">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
				</div>
				<div className="basis-2/3 lg:basis-4/5 flex items-center">
					<div className="w-full">
						<div className="relative w-full h-[11vw] lg:h-[5vw] bg-bar-footer transition-all"></div>
					</div>
				</div>
			</div>
		</div>
  )
}

export default SiteHeader