import React from 'react';
import { Link } from "react-router-dom";
import Logo from "../assets/img/logo/W58-logo.svg";
import WaterMark from "../assets/img/logo/58watermark.svg";
import Azora from "../assets/img/logo/azora-logo.svg";
import AzoraHZ from "../assets/img/logo/azora_logo_horizontal.svg";

const SiteFooter = () => {
  return (
    <div className="relative w-full">
			<div className="relative w-full pl-[9vw] lg:pl-0">
				<div className="w-full lg:w-[80vw] lg:ml-[20vw] lg:pr-[7.6vw] text-left pt-[50px]">
					<div className="w-full lg:flex lg:flex-row items-center">
						<div className="w-full pb-[50px] lg:pb-0 lg:w-[40vw]" data-aos="fade-up" data-aos-delay="0"><h2 className="text-6xl">Designed for<br></br>Better Living</h2></div>
						<div className="w-full hidden pt-[50px] lg:flex lg:w-[40vw] justify-end" data-aos="fade-left" data-aos-delay="500" id="watermark"><img src={WaterMark} className="w-[250px]"></img></div>
					</div>
				</div>
			</div>
			<div className="relative w-full">
				<div className="relative w-full bg-bar-footer flex flex-row">
					<div className="hidden lg:flex lg:basis-1/5 flex-row">
						<div className="basis-1/5"></div>
						<div className="basis-3/5 bg-white flex justify-center lg:items-center pt-[25px]">
							<div className="relative pt-[1.75vw] lg:pt-0" data-aos="fade-up">
								<Link to="/"><img src={Logo} className="w-[15vw] lg:w-[8vw] relative mx-[auto] my-0"></img></Link>
							</div>
						</div>
						<div className="basis-1/5"></div>
					</div>
					<div className="basis-full pt-[25px] pr-[6vw] lg:pr-0 lg:basis-4/5 lg:flex lg:flex-row lg:justify-end">
						<div className="w-full lg:flex lg:flex-row lg:pl-[5vw]">
							<div className="basis-1/3 flex items-center justity-center lg:border-r-[1px] lg:border-r-[white]" data-aos="fade-up" data-aos-delay="500" id="azora-logo">
								<Link to="https://azoragroup.ca/" target="_blank" className="relative my-0 mx-[auto] lg:mx-0">
									<img src={Azora} className="hidden lg:block w-[12vw] lg:w-[7vw] lg:pt-[25px] relative my-0 mx-[auto] lg:mx-0 lg:pb-[25px]"></img>
									<img src={AzoraHZ} className="pt-[25px] lg:hidden w-[50vw] lg:w-[7vw] relative my-0 mx-[auto] lg:mx-0 lg:pb-[25px]"></img>
								</Link>
							</div>
							<div className="basis-full flex lg:basis-2/3 justify-center items-center pt-[50px] lg:pt-0">
								<div className="basis-1/2 flex justify-center items-center lg:py-0 border-r-[1px] border-r-[white] lg:border-r-0">
									<div className="text-white text-left" data-aos="fade-up" data-aos-delay="1000">
										<p>Contact Us</p>
										<Link to="tel:604.374.7858">604.374.7858</Link>
										<br></br>
										<Link to="mailto:info@West58.ca">info@West58.ca</Link>
									</div>
								</div>
								<div className="basis-1/2 flex justify-center lg:py-0 lg:justify-start items-center">
									<div className="text-white text-left" data-aos="fade-up" data-aos-delay="1500">
										<p>Site Address</p>
										7487 Granville Street
										<br></br>
										Vancouver
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div className="relative w-full bg-bar-footer flex flex-row">
					<div className="hidden lg:basis-1/5 lg:flex flex-row">
						<div className="basis-1/5"></div>
						<div className="basis-3/5 bg-white flex justify-center">
							<div className="relative pt-[75px]">

							</div>
						</div>
						<div className="basis-1/5"></div>
					</div>
					<div className="basis-full py-[25px] pr-[6vw] lg:pr-0 lg:basis-4/5 lg:flex lg:flex-row lg:justify-start">
						<div className="w-full pl-[9vw] lg:flex lg:flex-row lg:pl-[5vw] lg:w-[80%]">
							<p className="text-white text-xs">Illustrations and renderings reflect the artist’s interpretation of the project and do not take into account the neighbouring building, physical structures, streets and landscape. When built, actual suites, amenities, building interiors, exteriors and views may be different than what is depicted. This is not an offering for sale. Any such offering can only be made with the applicable disclosure statement and agreement of purchase and sale. E.&O.E. <Link to="/privacy-policy" className="underline">Privacy Policy</Link></p>
						</div>
					</div>
				</div>
			</div>
		</div>			
  );
};

export default SiteFooter;
