import React, { useEffect, useRef, useState } from "react";
import { useLocation } from "react-router-dom";
import { Link } from "react-router-dom";
import Logo from "../assets/img/logo/w58-logo-navy.svg";
import wLogo from "../assets/img/logo/w58-logo-white.svg";
import Hamburger from "../assets/img/hamburger.svg";
import Close from "../assets/img/close-btn.svg";

const MainSiteHeader = ({ designSrc }) => {
  const { pathname } = useLocation();
  const [mobMenu, setMobMenu] = useState(0);
  const navRef = useRef();
  const mobileNavClick = () => {
	  const $body = document.querySelector('body');
	  let scrollPosition = 0;
	  
	  if (mobMenu === 0) {
		  setMobMenu(1);
		  	scrollPosition = window.pageYOffset;
			$body.style.overflow = 'hidden';
			/*$body.style.position = 'fixed';
			$body.style.top = `-${scrollPosition}px`;
			$body.style.width = '100%';*/
	  }
	  else {
		  setMobMenu(0);
		  $body.style.removeProperty('overflow');
			/*$body.style.removeProperty('position');
			$body.style.removeProperty('top');
			$body.style.removeProperty('width');
			window.scrollTo(0, scrollPosition);*/
	  }	  
	};
  const contactClick = () => {
	  window.scroll({
		  top: document.body.scrollHeight,
		  behavior: 'smooth'
		});
	};
  const handleScroll = () => {
	  if (window.pageYOffset > document.getElementById("headerImg").offsetHeight) {
		  navRef.current.classList.add("sticky-header");
	  }
	  else {
		  navRef.current.classList.remove("sticky-header");
	  }
	};
	useEffect(() => {
		window.addEventListener('scroll', handleScroll);
		window.addEventListener('resize', handleScroll);
		return () => {
			window.removeEventListener('scroll', handleScroll);
			window.removeEventListener('resize', handleScroll);
		};
	}, []);
  return (
    <div className="relative w-full h-auto lg:h-[100vh] bottom-0 pb-[15vw] lg:pb-[7.8vw] z-[2]">
		<div className={`w-full h-auto lg:h-[calc(100vh-7.8vw)] relative`} id="headerImg" style={{ 
			  backgroundImage: `url(${designSrc})`,
			  backgroundPosition: 'center',
			  backgroundSize: 'cover',
			  backgroundRepeat: 'no-repeat'
			}}>
			<img src={designSrc} className="lg:hidden w-full relative"></img>
			
			{pathname === "/"  && 
			<div className="absolute right-[10vw] bottom-[5vw] hidden lg:block" data-aos="fade-up" data-aos-delay="0">
				<h2 className="text-white text-[4vw]">Designed for Better Living</h2>				
				<h3 className="text-white pt-[2.88vw] text-[2.88vw]">1 to 3 Bed Townhomes & Garden Suites</h3>
			</div>}
		</div>
		<nav className="absolute bottom-0 w-full transition-all h-[18vw] lg:h-[7.8vw]" id="navbar" ref={navRef}>
			<div className="bg-white w-full flex flex-row h-[18vw] lg:h-[7.8vw]">
				<div className="basis-1/3 lg:basis-1/5 flex flex-row items-center">
					<div className="w-[calc((100%-15vw)/2)] lg:w-[calc((100%-7.8vw)/2)]">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-bar-footer transition-all"></div>
					</div>
					<div className="w-[15vw] lg:w-[7.8vw] bg-white flex justify-center">
						<div className="relative">
							<Link to="/"><img src={Logo} className="transition-all w-[12.8vw] lg:w-[5vw] relative mx-[auto] my-0"></img></Link>
						</div>
					</div>
					<div className="w-[calc((100%-15vw)/2)] lg:w-[calc((100%-7.8vw)/2)]">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-bar-footer transition-all"></div>
					</div>
				</div>
				<div className="basis-2/3 lg:basis-4/5 flex items-center">
					<div className="w-full">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-bar-footer transition-all flex items-center">
							<ul className="text-lg lg:text-xl text-white absolute right-[10vw] hidden lg:block">
								<Link to="/neighbourhood"><li className={`pr-5 inline-block ${pathname === "/neighbourhood"  && "text-darkGreen font-bold"}`}>Neighbourhood</li></Link>
								<Link to="/floorplans"><li className={`px-5 inline-block ${pathname === "/floorplans"  && "text-darkGreen font-bold"}`}>Floorplans</li></Link>
								<Link to="/features"><li className={`px-5 inline-block ${pathname === "/features"  && "text-darkGreen font-bold"}`}>Features</li></Link>
								<Link to="/gallery"><li className={`px-5 inline-block ${pathname === "/gallery"  && "text-darkGreen font-bold"}`}>Gallery</li></Link>
								<Link to="/team"><li className={`px-5 inline-block ${pathname === "/team"  && "text-darkGreen font-bold"}`}>Team</li></Link>
								<li className={`px-5 inline-block cursor-pointer`} onClick={() => (contactClick())}>Contact</li>
								<Link to="/register" target="_blank"><li className="pl-5 inline-block">Register</li></Link>
							</ul>
							<img src={Hamburger} className="lg:hidden h-[4vw] absolute right-[25px] top-[50%] translate-y-[-50%] cursor-pointer" onClick={() => (mobileNavClick())}></img>
						</div>
					</div>
				</div>
			</div>
		</nav>
		<div className={`transition-all duration-300 top-0 opacity-0 z-[100] fixed w-full h-full flex flex-col bg-bar-footer ${mobMenu === 1 ? "left-0 opacity-100" : "left-[100%] opacity-0"} lg:hidden`}>
			<div className="w-full flex flex-row h-[18vw]">
				<div className="basis-1/3 lg:basis-1/5 flex flex-row items-center">
					<div className="w-[calc((100%-15vw)/2)] lg:w-[calc((100%-7.8vw)/2)]">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-white transition-all"></div>
					</div>
					<div className="w-[15vw] lg:w-[7.8vw] flex justify-center">
						<div className="relative">
							{pathname === "/"  && 
								<img src={wLogo} className="transition-all w-[12.8vw] lg:w-[5vw] relative mx-[auto] my-0 cursor-pointer" onClick={() => (mobileNavClick())}></img>
							}
							{pathname !== "/"  && 
								<Link to="/" onClick={() => (mobileNavClick())}><img src={wLogo} className="transition-all w-[12.8vw] lg:w-[5vw] relative mx-[auto] my-0"></img></Link>
							}
							
						</div>
					</div>
					<div className="w-[calc((100%-15vw)/2)] lg:w-[calc((100%-7.8vw)/2)]">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-white transition-all"></div>
					</div>
				</div>
				<div className="basis-2/3 lg:basis-4/5 flex items-center">
					<div className="w-full">
						<div className="relative w-full h-[9vw] lg:h-[3.33vw] bg-white transition-all flex items-center">
							<img src={Close} className="h-[4vw] absolute right-[25px] top-[50%] translate-y-[-50%] cursor-pointer" onClick={() => (mobileNavClick())}></img>
						</div>
					</div>
				</div>
			</div>
			<div className="flex-1 flex text-white text-center items-center justify-center pb-[50px]">
				<div className="text-xl">
					<Link to="/neighbourhood" onClick={() => (mobileNavClick())}><div className="py-[10px]">Neighbourhood</div></Link>
					<Link to="/floorplans" onClick={() => (mobileNavClick())}><div className="py-[10px]">Floorplans</div></Link>
					<Link to="/features" onClick={() => (mobileNavClick())}><div className="py-[10px]">Features</div></Link>
					<Link to="/gallery" onClick={() => (mobileNavClick())}><div className="py-[10px]">Gallery</div></Link>
					<Link to="/team" onClick={() => (mobileNavClick())}><div className="py-[10px]">Team</div></Link>
					<Link to="/register" target="_blank" onClick={() => (mobileNavClick())}><div className="w-[150px] py-[7px] mt-[15px] bg-bar-footer2 my-0 mx-auto">Register</div></Link>
				</div>
			</div>
			<div className="flex-none bg-bar-footer2 py-[25px]">
				<div className="text-white text-center text-base">
					<p>Presentation Centre</p>
					2152 West 41st Ave, Vancouver
					<br></br>
					<p>Open by Appointment</p>
					<Link to="tel:604.374.7858">604.374.7858</Link>
					<br></br><Link to="mailto:info@west58.ca">info@west58.ca</Link>
				</div>
			</div>
		</div>
	</div>
  )
}

export default MainSiteHeader