import React from 'react';
import { Link } from "react-router-dom";
import Logo from "../assets/img/logo/W58-logo-white.svg";
import WaterMark from "../assets/img/logo/58watermark.svg";
import Azora from "../assets/img/logo/footer-azora-logo.svg";
import AzoraHZ from "../assets/img/logo/azora_logo_horizontal.svg";
import TagLine from "../assets/img/logo/footer-w58-logotagline.svg";

const MainSiteFooter = () => {
  return (
    <div className="relative w-full flex flex-col lg:flex-row">
		<div className="py-[50px] lg:py-0 lg:pb-[25px] bg-bar-footer basis-1/4 flex items-center lg:items-start lg:pt-[25px] justify-center">
			<div className="w-[70%] lg:w-[45%]">
				<img className="max-w-none w-full" src={TagLine}></img>
			</div>
		</div>
		<div className="bg-bar-footer2 basis-3/4 flex flex-col items-bottom py-[25px] px-[6vw] lg:px-[10vw]">
			<div className="w-full flex flex-col lg:flex-row items-center lg:items-start lg:items-stretch">
				<div className="basis-full lg:basis-1/3 flex justity-center lg:border-r-[1px] lg:border-r-[white]" data-aos="fade-up" data-aos-delay="500" id="azora-logo">
					<Link to="https://azoragroup.ca/" target="_blank" className="relative my-0 mx-[auto] lg:mx-0">
						<img src={Azora} className="hidden lg:block w-[12vw] h-auto lg:w-auto lg:h-full lg:pt-[0] relative my-0 mx-[auto] lg:mx-0 lg:pb-[0]"></img>
						<img src={AzoraHZ} className="pt-[25px] lg:hidden w-[50vw] lg:w-[7vw] relative my-0 mx-[auto] lg:mx-0 lg:pb-[25px]"></img>
					</Link>
				</div>
				<div className="w-full basis-full lg:basis-2/3 flex flex-col lg:flex-row justify-center items-center lg:items-start py-[50px] lg:py-0 lg:pt-[0]">
					<div className="basis-full lg:basis-1/2 flex justify-center lg:justify-end items-center lg:py-0">
						<span className="text-white text-center lg:text-left md:text-[16px] w-auto" data-aos="fade-up" data-aos-delay="1000">
							<p>Presentation Centre</p>
							2152 West 41st Ave, Vancouver
							<br></br>
							<p>Open by Appointment</p>
							<Link to="tel:604.374.7858">604.374.7858</Link>
							<br></br><Link to="mailto:info@west58.ca">info@west58.ca</Link>
						</span>
					</div>
					<div className="basis-full lg:basis-1/2 flex justify-center pt-[50px] lg:py-0 lg:justify-end items-center">
						<div className="text-white text-center lg:text-left md:text-[16px]" data-aos="fade-up" data-aos-delay="1500">							
							<p>Site Address</p>
							7487 Granville St,
							<br></br>Vancouver							
						</div>
					</div>
				</div>
			 </div>
			<div className="basis-full lg:pr-0 lg:basis-4/5 lg:flex lg:flex-row lg:justify-start lg:pt-[25px]">
				<div className="w-full">
					<p className="text-white text-xs">Illustrations and renderings reflect the artist’s interpretation of the project and do not take into account the neighbouring building, physical structures, streets and landscape. When built, actual suites, amenities, building interiors, exteriors and views may be different than what is depicted. This is not an offering for sale. Any such offering can only be made with the applicable disclosure statement and agreement of purchase and sale. E.&O.E. <Link to="/privacy-policy" className="underline">Privacy Policy</Link></p>
				</div>
			</div>
		 </div>
	</div>			
  );
};

export default MainSiteFooter;