import { useEffect, useRef, useState, useMemo } from "react";
import { Outlet, useLocation, useNavigate } from "react-router-dom";
import AOS from "aos";
import "./App.css";
import "/node_modules/aos/dist/aos.css";
//import Facebook from "./meta/facebookPixel";
//import MetaPixel from "./meta/metaPixel";
// import MainMenu from "./components/MainMenu";

function App() {
  const initRef = useRef(false);
  // const navigate = useNavigate();
  const { pathname } = useLocation();
  const navigate = useNavigate();

  useEffect(() => {
    if (!initRef.current) return;
    window.scrollTo(0, 0);
  }, [pathname]);

  useEffect(() => {
    if (initRef.current) return;
    initRef.current = true;

    setTimeout(() => {
      AOS.init({
        // offset: 200,
        duration: 1200,
        easing: "ease-out-sine",
        once: true,
      });
    }, 300);
  }, []);

  return (
    <>
      <main>
        <Outlet />
      </main>

    </>
  );
}

export default App;
