import { ValidScrollAxis } from 'parallax-controller';

export interface ParallaxProviderProps {
  /**
   * Optionally pass the scroll axis for setting horizontal/vertical scrolling. One of vertical or
   * horizontal
   */
  scrollAxis?: ValidScrollAxis;
  /**
   * Optionally set the container that has overflow and will contain parallax elements. Defaults
   * to the HTML body
   */
  scrollContainer?: HTMLElement;
  /**
   * Disables the ParallaxController and all animations.
   */
  isDisabled?: boolean;
  children?: React.ReactNode;
}
