import { EasingFunction } from 'bezier-easing';
import { Element } from './classes/Element';
export declare type ParallaxStartEndEffects = {
    translateX?: ParsedValueEffect;
    translateY?: ParsedValueEffect;
    rotate?: ParsedValueEffect;
    rotateX?: ParsedValueEffect;
    rotateY?: ParsedValueEffect;
    rotateZ?: ParsedValueEffect;
    scale?: ParsedValueEffect;
    scaleX?: ParsedValueEffect;
    scaleY?: ParsedValueEffect;
    scaleZ?: ParsedValueEffect;
    opacity?: ParsedValueEffect;
};
export declare enum ValidCSSEffects {
    'speed' = "speed",
    'translateX' = "translateX",
    'translateY' = "translateY",
    'rotate' = "rotate",
    'rotateX' = "rotateX",
    'rotateY' = "rotateY",
    'rotateZ' = "rotateZ",
    'scale' = "scale",
    'scaleX' = "scaleX",
    'scaleY' = "scaleY",
    'scaleZ' = "scaleZ",
    'opacity' = "opacity"
}
export declare enum Units {
    'px' = "px",
    '%' = "%",
    'vh' = "vh",
    'vw' = "vw"
}
export declare type ValidUnits = keyof typeof Units;
export declare enum RotationUnits {
    'deg' = "deg",
    'turn' = "turn",
    'rad' = "rad"
}
export declare enum ScaleUnits {
    '' = ""
}
export declare type ValidScaleUnits = keyof typeof ScaleUnits;
export declare type ValidRotationUnits = keyof typeof RotationUnits;
export declare type AllValidUnits = ValidUnits | ValidRotationUnits | ValidScaleUnits;
export declare enum ScrollAxis {
    'vertical' = "vertical",
    'horizontal' = "horizontal"
}
export declare type ValidScrollAxis = keyof typeof ScrollAxis;
export declare type ParsedValueShape = {
    value: number;
    unit: AllValidUnits;
};
export declare type ParsedValueEffect = {
    start: number;
    end: number;
    unit: AllValidUnits;
    easing?: EasingFunction;
};
export declare type ViewElement = HTMLElement | Window;
export declare type ParallaxControllerOptions = {
    scrollAxis?: ValidScrollAxis;
    scrollContainer?: HTMLElement;
    disabled?: boolean;
};
export declare type EffectNumber = [number, number, EasingParam?];
export declare type EffectString = [string, string, EasingParam?];
export declare type EasingParam = ValidEasingPresets | EasingParams;
export declare type CSSEffect = EffectNumber | EffectString;
export declare type ScaleOpacityEffect = EffectNumber;
export declare type ParallaxElementConfig = {
    speed?: number;
    disabled?: boolean;
    translateX?: CSSEffect;
    translateY?: CSSEffect;
    rotate?: CSSEffect;
    rotateX?: CSSEffect;
    rotateY?: CSSEffect;
    rotateZ?: CSSEffect;
    scale?: ScaleOpacityEffect;
    scaleX?: ScaleOpacityEffect;
    scaleY?: ScaleOpacityEffect;
    scaleZ?: ScaleOpacityEffect;
    opacity?: ScaleOpacityEffect;
    easing?: EasingParams | ValidEasingPresets;
    rootMargin?: RootMarginShape;
    shouldAlwaysCompleteAnimation?: boolean;
    shouldDisableScalingTranslations?: boolean;
    startScroll?: number;
    endScroll?: number;
    targetElement?: HTMLElement;
    onEnter?: (element: Element) => any;
    onExit?: (element: Element) => any;
    onChange?: (element: Element) => any;
    onProgressChange?: (progress: number) => any;
};
export declare type CreateElementOptions = {
    el: HTMLElement;
    props: ParallaxElementConfig;
};
export declare type EasingParams = [number, number, number, number];
export declare enum EasingPreset {
    ease = "ease",
    easeIn = "easeIn",
    easeOut = "easeOut",
    easeInOut = "easeInOut",
    easeInQuad = "easeInQuad",
    easeInCubic = "easeInCubic",
    easeInQuart = "easeInQuart",
    easeInQuint = "easeInQuint",
    easeInSine = "easeInSine",
    easeInExpo = "easeInExpo",
    easeInCirc = "easeInCirc",
    easeOutQuad = "easeOutQuad",
    easeOutCubic = "easeOutCubic",
    easeOutQuart = "easeOutQuart",
    easeOutQuint = "easeOutQuint",
    easeOutSine = "easeOutSine",
    easeOutExpo = "easeOutExpo",
    easeOutCirc = "easeOutCirc",
    easeInOutQuad = "easeInOutQuad",
    easeInOutCubic = "easeInOutCubic",
    easeInOutQuart = "easeInOutQuart",
    easeInOutQuint = "easeInOutQuint",
    easeInOutSine = "easeInOutSine",
    easeInOutExpo = "easeInOutExpo",
    easeInOutCirc = "easeInOutCirc",
    easeInBack = "easeInBack",
    easeOutBack = "easeOutBack",
    easeInOutBack = "easeInOutBack"
}
export declare type ValidEasingPresets = keyof typeof EasingPreset;
export declare type RootMarginShape = {
    top: number;
    bottom: number;
    left: number;
    right: number;
};
