import { View } from './View';
import { Scroll } from './Scroll';
import { Element } from './Element';
import { CreateElementOptions, ParallaxControllerOptions, ParallaxElementConfig, ValidScrollAxis, ViewElement } from '../types';
/**
 * -------------------------------------------------------
 * Parallax Controller
 * -------------------------------------------------------
 *
 * The global controller for setting up and managing a scroll view of elements.
 *
 */
export declare class ParallaxController {
    disabled: boolean;
    elements: Element[];
    scrollAxis: ValidScrollAxis;
    viewEl: ViewElement;
    scroll: Scroll;
    view: View;
    _hasScrollContainer: boolean;
    _ticking: boolean;
    _supportsPassive: boolean;
    _resizeObserver?: ResizeObserver;
    /**
     * Static method to instantiate the ParallaxController.
     * @returns {Class} ParallaxController
     */
    static init(options: ParallaxControllerOptions): ParallaxController;
    constructor({ scrollAxis, scrollContainer, disabled, }: ParallaxControllerOptions);
    _bindAllMethods(): void;
    _addListeners(el: ViewElement): void;
    _removeListeners(el: ViewElement): void;
    _addResizeObserver(): void;
    _getScrollPosition(): any[];
    /**
     * Window scroll handler sets scroll position
     * and then calls '_updateAllElements()'.
     */
    _handleScroll(): void;
    /**
     * Window resize handler. Sets the new window inner height
     * then updates parallax element attributes and positions.
     */
    _handleUpdateCache(): void;
    /**
     * Update element positions.
     * Determines if the element is in view based on the cached
     * attributes, if so set the elements parallax styles.
     */
    _updateAllElements({ updateCache }?: {
        updateCache?: boolean;
    }): void;
    /**
     * Update element positions.
     * Determines if the element is in view based on the cached
     * attributes, if so set the elements parallax styles.
     */
    _updateElementPosition(element: Element): void;
    /**
     * Gets the params to set in the View from the scroll container or the window
     */
    _getViewParams(): {
        width: number;
        height: number;
        scrollHeight: number;
        scrollWidth: number;
    };
    /**
     * Cache the view attributes
     */
    _setViewSize(): View;
    /**
     * Checks if any of the cached attributes of the view have changed.
     * @returns boolean
     */
    _checkIfViewHasChanged(): boolean;
    /**
     * -------------------------------------------------------
     * Public methods
     * -------------------------------------------------------
     */
    /**
     * Returns all the parallax elements in the controller
     */
    getElements(): Element[];
    /**
     * Creates and returns new parallax element with provided options to be managed by the controller.
     */
    createElement(options: CreateElementOptions): Element;
    /**
     * Remove an element by id
     */
    removeElementById(id: number): void;
    /**
     * Updates an existing parallax element object with new options.
     */
    updateElementPropsById(id: number, props: ParallaxElementConfig): void;
    /**
     * Remove a target elements parallax styles
     */
    resetElementStyles(element: Element): void;
    /**
     * Updates all cached attributes on parallax elements.
     */
    update(): void;
    /**
     * Updates the scroll container of the parallax controller
     */
    updateScrollContainer(el: HTMLElement): void;
    disableParallaxController(): void;
    enableParallaxController(): void;
    /**
     * Disable all parallax elements
     */
    disableAllElements(): void;
    /**
     * Enable all parallax elements
     */
    enableAllElements(): void;
    /**
     * Removes all listeners and resets all styles on managed elements.
     */
    destroy(): void;
}
