import bezier from 'bezier-easing';
import { CreateElementOptions, ParallaxElementConfig, ParallaxStartEndEffects, ValidScrollAxis, EasingParam } from '../types';
import { Rect } from './Rect';
import { View } from './View';
import { Scroll } from './Scroll';
import { Limits } from './Limits';
declare type ParallaxControllerConstructorOptions = {
    scrollAxis: ValidScrollAxis;
    disabledParallaxController?: boolean;
};
declare type ElementConstructorOptions = CreateElementOptions & ParallaxControllerConstructorOptions;
export declare class Element {
    el: HTMLElement;
    props: ParallaxElementConfig;
    scrollAxis: ValidScrollAxis;
    disabledParallaxController: boolean;
    id: number;
    effects: ParallaxStartEndEffects;
    isInView: boolean | null;
    progress: number;
    scaledEffects?: ParallaxStartEndEffects;
    rect?: Rect;
    limits?: Limits;
    easing?: bezier.EasingFunction;
    constructor(options: ElementConstructorOptions);
    updateProps(nextProps: ParallaxElementConfig): this;
    setCachedAttributes(view: View, scroll: Scroll): Element;
    _updateElementIsInView(nextIsInView: boolean): void;
    _setFinalProgress(): void;
    _setElementStyles(): void;
    _updateElementProgress(nextProgress: number): void;
    _setElementEasing(easing?: EasingParam): void;
    updateElementOptions(options: ParallaxControllerConstructorOptions): void;
    updatePosition(scroll: Scroll): Element;
}
export {};
