# 🕹 Parallax Controller

[![NPM Version Latest](https://img.shields.io/npm/v/parallax-controller/latest)](https://www.npmjs.com/package/parallax-controller)
[![NPM Downloads](https://img.shields.io/npm/dm/parallax-controller)](https://www.npmjs.com/package/parallax-controller)
[![Codecov](https://codecov.io/gh/jscottsmith/parallax-controller/branch/master/graph/badge.svg)](https://codecov.io/gh/jscottsmith/parallax-controller)

[![Test and Lint](https://github.com/jscottsmith/parallax-controller/actions/workflows/main.yml/badge.svg)](https://github.com/jscottsmith/parallax-controller/actions/workflows/main.yml)
[![Size](https://github.com/jscottsmith/parallax-controller/actions/workflows/size.yml/badge.svg)](https://github.com/jscottsmith/parallax-controller/actions/workflows/size.yml)
[![Coverage](https://github.com/jscottsmith/parallax-controller/actions/workflows/coverage.yml/badge.svg)](https://github.com/jscottsmith/parallax-controller/actions/workflows/coverage.yml)

Core classes and controller for creating parallax scrolling effects. Designed to provide scroll based animations for elements relative to the view. Built for performance by caching important attributes that cause reflow and layout when accessing.

## NPM Package

Via Yarn

```bash
yarn add parallax-controller
```

or NPM

```bash
npm install parallax-controller
```

## Documentation

[API and Usage docs](https://parallax-controller.vercel.app/docs/intro)

## React Integration

If you're building with React use `react-scroll-parallax`, a set of hooks and components to easily create effects and interact with the `parallax-controller`.

```bash
yarn add react-scroll-parallax
```

See the [React Scroll Parallax documentation](https://react-scroll-parallax.damnthat.tv/) for usage and demos.

## Demos

This package was created for [react-scroll-parallax](https://github.com/jscottsmith/react-scroll-parallax), but can be used as a standalone lib. Most demos were built with `react-scroll-parallax`.

- [React Scroll Parallax V3 Doc Site](https://react-scroll-parallax-docs.netlify.app/)
- [React Scroll Parallax V3 Storybook](https://react-scroll-parallax-v3.surge.sh/)
