/// <reference types="google.maps" />
import React, { CSSProperties, PropsWithChildren } from 'react';
import { MapEventProps } from './use-map-events';
import { DeckGlCompatProps } from './use-deckgl-camera-update';
export interface GoogleMapsContextValue {
    map: google.maps.Map | null;
}
export declare const GoogleMapsContext: React.Context<GoogleMapsContextValue | null>;
export type { MapCameraChangedEvent, MapEvent, MapEventProps, MapMouseEvent } from './use-map-events';
export type MapCameraProps = {
    center: google.maps.LatLngLiteral;
    zoom: number;
    heading?: number;
    tilt?: number;
};
/**
 * Props for the Map Component
 */
export type MapProps = google.maps.MapOptions & MapEventProps & DeckGlCompatProps & {
    /**
     * An id for the map, this is required when multiple maps are present
     * in the same APIProvider context.
     */
    id?: string;
    /**
     * Additional style rules to apply to the map dom-element.
     */
    style?: CSSProperties;
    /**
     * Additional css class-name to apply to the element containing the map.
     */
    className?: string;
    /**
     * Indicates that the map will be controlled externally. Disables all controls provided by the map itself.
     */
    controlled?: boolean;
    /**
     * Enable caching of map-instances created by this component.
     */
    reuseMaps?: boolean;
    defaultCenter?: google.maps.LatLngLiteral;
    defaultZoom?: number;
    defaultHeading?: number;
    defaultTilt?: number;
    /**
     * Alternative way to specify the default camera props as a geographic region that should be fully visible
     */
    defaultBounds?: google.maps.LatLngBoundsLiteral & {
        padding?: number | google.maps.Padding;
    };
};
export declare const Map: {
    (props: PropsWithChildren<MapProps>): React.JSX.Element;
    deckGLViewProps: boolean;
};
