/// <reference types="react" />
import PropTypes from "prop-types";
import type { AnimatePresenceProps } from "framer-motion";
import type { UseDismissProps } from "@floating-ui/react";
export type colors = "blue-gray" | "gray" | "brown" | "deep-orange" | "orange" | "amber" | "yellow" | "lime" | "light-green" | "green" | "teal" | "cyan" | "light-blue" | "blue" | "indigo" | "deep-purple" | "purple" | "pink" | "red";
export type animation = {
    initial?: object;
    mount?: object;
    unmount?: object;
};
export interface dismissType extends UseDismissProps {
}
export type offsetType = number | {
    mainAxis?: number;
    crossAxis?: number;
    alignmentAxis?: number | null;
};
export interface NewAnimatePresenceProps extends Omit<AnimatePresenceProps, "children"> {
    children: React.ReactNode;
}
export declare const propTypesColors: string[];
export declare const propTypesAnimation: PropTypes.Requireable<PropTypes.InferProps<{
    mount: PropTypes.Requireable<Object>;
    unmount: PropTypes.Requireable<Object>;
}>>;
export declare const propTypesDismissType: PropTypes.Requireable<PropTypes.InferProps<{
    enabled: PropTypes.Requireable<boolean>;
    escapeKey: PropTypes.Requireable<boolean>;
    referencePress: PropTypes.Requireable<boolean>;
    referencePressEvent: PropTypes.Requireable<string>;
    outsidePress: PropTypes.Requireable<NonNullable<boolean | ((...args: any[]) => any)>>;
    outsidePressEvent: PropTypes.Requireable<string>;
    ancestorScroll: PropTypes.Requireable<boolean>;
    bubbles: PropTypes.Requireable<NonNullable<boolean | PropTypes.InferProps<{
        escapeKey: PropTypes.Requireable<boolean>;
        outsidePress: PropTypes.Requireable<boolean>;
    }>>>;
}>>;
export declare const propTypesOffsetType: PropTypes.Requireable<NonNullable<number | PropTypes.InferProps<{
    mainAxis: PropTypes.Requireable<number>;
    crossAxis: PropTypes.Requireable<number>;
    alignmentAxis: PropTypes.Requireable<number>;
}>>>;
export declare const propTypesPlacements: string[];
//# sourceMappingURL=generic.d.ts.map