"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _export(target,all){for(var name in all)Object.defineProperty(target,name,{enumerable:true,get:all[name]})}_export(exports,{Textarea:function(){return Textarea},default:function(){return _default}});var _react=_interopRequireDefault(require("react"));var _propTypes=_interopRequireDefault(require("prop-types"));var _classnames=_interopRequireDefault(require("classnames"));var _findMatch=_interopRequireDefault(require("../../utils/findMatch"));var _objectsToString=_interopRequireDefault(require("../../utils/objectsToString"));var _theme=require("../../context/theme");var _input=require("../../types/components/input");var _tailwindMerge=require("tailwind-merge");function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectWithoutProperties(source,excluded){if(source==null)return{};var target=_objectWithoutPropertiesLoose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}var Textarea=_react.default.forwardRef(function(_param,ref){var variant=_param.variant,color=_param.color,size=_param.size,label=_param.label,error=_param.error,success=_param.success,resize=_param.resize,labelProps=_param.labelProps,containerProps=_param.containerProps,shrink=_param.shrink,className=_param.className,rest=_objectWithoutProperties(_param,["variant","color","size","label","error","success","resize","labelProps","containerProps","shrink","className"]);var textarea=(0,_theme.useTheme)().textarea;var defaultProps=textarea.defaultProps,valid=textarea.valid,styles=textarea.styles;var base=styles.base,variants=styles.variants;variant=variant!==null&&variant!==void 0?variant:defaultProps.variant;size=size!==null&&size!==void 0?size:defaultProps.size;color=color!==null&&color!==void 0?color:defaultProps.color;label=label!==null&&label!==void 0?label:defaultProps.label;labelProps=labelProps!==null&&labelProps!==void 0?labelProps:defaultProps.labelProps;containerProps=containerProps!==null&&containerProps!==void 0?containerProps:defaultProps.containerProps;shrink=shrink!==null&&shrink!==void 0?shrink:defaultProps.shrink;className=(0,_tailwindMerge.twMerge)(defaultProps.className||"",className);var textareaVariant=variants[(0,_findMatch.default)(valid.variants,variant,"outlined")];var textareaError=(0,_objectsToString.default)(textareaVariant.error.textarea);var textareaSuccess=(0,_objectsToString.default)(textareaVariant.success.textarea);var textareaShrink=(0,_objectsToString.default)(textareaVariant.shrink.textarea);var textareaColor=(0,_objectsToString.default)(textareaVariant.colors.textarea[(0,_findMatch.default)(valid.colors,color,"gray")]);var labelError=(0,_objectsToString.default)(textareaVariant.error.label);var labelSuccess=(0,_objectsToString.default)(textareaVariant.success.label);var labelShrink=(0,_objectsToString.default)(textareaVariant.shrink.label);var labelColor=(0,_objectsToString.default)(textareaVariant.colors.label[(0,_findMatch.default)(valid.colors,color,"gray")]);var containerClasses=(0,_classnames.default)((0,_objectsToString.default)(base.container),containerProps===null||containerProps===void 0?void 0:containerProps.className);var textareaClasses=(0,_classnames.default)((0,_objectsToString.default)(base.textarea),(0,_objectsToString.default)(textareaVariant.base.textarea),(0,_objectsToString.default)(textareaVariant.sizes[(0,_findMatch.default)(valid.sizes,size,"md")].textarea),_defineProperty({},textareaColor,!error&&!success),_defineProperty({},textareaError,error),_defineProperty({},textareaSuccess,success),_defineProperty({},textareaShrink,shrink),!resize?"!resize-none":"",className);var labelClasses=(0,_classnames.default)((0,_objectsToString.default)(base.label),(0,_objectsToString.default)(textareaVariant.base.label),(0,_objectsToString.default)(textareaVariant.sizes[(0,_findMatch.default)(valid.sizes,size,"md")].label),_defineProperty({},labelColor,!error&&!success),_defineProperty({},labelError,error),_defineProperty({},labelSuccess,success),_defineProperty({},labelShrink,shrink),labelProps===null||labelProps===void 0?void 0:labelProps.className);var asteriskClasses=(0,_classnames.default)((0,_objectsToString.default)(base.asterisk));return _react.default.createElement("div",{ref:ref,className:containerClasses},_react.default.createElement("textarea",_extends({},rest,{className:textareaClasses,placeholder:(rest===null||rest===void 0?void 0:rest.placeholder)||" "})),_react.default.createElement("label",{className:labelClasses},label," ",rest.required?_react.default.createElement("span",{className:asteriskClasses},"*"):""))});Textarea.propTypes={variant:_propTypes.default.oneOf(_input.propTypesVariant),size:_propTypes.default.oneOf(_input.propTypesSize),color:_propTypes.default.oneOf(_input.propTypesColor),label:_input.propTypesLabel,error:_input.propTypesError,success:_input.propTypesSuccess,resize:_input.propTypesResize,labelProps:_input.propTypesLabelProps,containerProps:_input.propTypesContainerProps,shrink:_input.propTypesShrink,className:_input.propTypesClassName};Textarea.displayName="MaterialTailwind.Textarea";var _default=Textarea;