"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _export(target,all){for(var name in all)Object.defineProperty(target,name,{enumerable:true,get:all[name]})}_export(exports,{Dialog:function(){return Dialog},DialogHeader:function(){return _dialogHeader.DialogHeader},DialogBody:function(){return _dialogBody.DialogBody},DialogFooter:function(){return _dialogFooter.DialogFooter},default:function(){return _default}});var _react=_interopRequireDefault(require("react"));var _propTypes=_interopRequireDefault(require("prop-types"));var _react1=require("@floating-ui/react");var _framerMotion=require("framer-motion");var _classnames=_interopRequireDefault(require("classnames"));var _deepmerge=_interopRequireDefault(require("deepmerge"));var _tailwindMerge=require("tailwind-merge");var _findMatch=_interopRequireDefault(require("../../utils/findMatch"));var _objectsToString=_interopRequireDefault(require("../../utils/objectsToString"));var _theme=require("../../context/theme");var _dialog=require("../../types/components/dialog");var _dialogHeader=require("./DialogHeader");var _dialogBody=require("./DialogBody");var _dialogFooter=require("./DialogFooter");function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){_defineProperty(target,key,source[key])})}return target}function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly){symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable})}keys.push.apply(keys,symbols)}return keys}function _objectSpreadProps(target,source){source=source!=null?source:{};if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source))}else{ownKeys(Object(source)).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})}return target}function _objectWithoutProperties(source,excluded){if(source==null)return{};var target=_objectWithoutPropertiesLoose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}var Dialog=_react.default.forwardRef(function(_param,ref){var open=_param.open,handler=_param.handler,size=_param.size,dismiss=_param.dismiss,animate=_param.animate,className=_param.className,children=_param.children,rest=_objectWithoutProperties(_param,["open","handler","size","dismiss","animate","className","children"]);var dialog=(0,_theme.useTheme)().dialog;var defaultProps=dialog.defaultProps,valid=dialog.valid,_dialog_styles=dialog.styles,base=_dialog_styles.base,sizes=_dialog_styles.sizes;handler=handler!==null&&handler!==void 0?handler:undefined;size=size!==null&&size!==void 0?size:defaultProps.size;dismiss=dismiss!==null&&dismiss!==void 0?dismiss:defaultProps.dismiss;animate=animate!==null&&animate!==void 0?animate:defaultProps.animate;className=(0,_tailwindMerge.twMerge)(defaultProps.className||"",className);var backdropClasses=(0,_classnames.default)((0,_objectsToString.default)(base.backdrop));var dialogClasses=(0,_tailwindMerge.twMerge)((0,_classnames.default)((0,_objectsToString.default)(base.container),(0,_objectsToString.default)(sizes[(0,_findMatch.default)(valid.sizes,size,"md")])),className);var animation={unmount:{opacity:0,y:-50,transition:{duration:.3}},mount:{opacity:1,y:0,transition:{duration:.3}}};var backdropAnimation={unmount:{opacity:0,transition:{delay:.2}},mount:{opacity:1}};var appliedAnimation=(0,_deepmerge.default)(animation,animate);var _useFloating=(0,_react1.useFloating)({open:open,onOpenChange:handler}),floating=_useFloating.floating,context=_useFloating.context;var id=(0,_react1.useId)();var labelId="".concat(id,"-label");var descriptionId="".concat(id,"-description");var getFloatingProps=(0,_react1.useInteractions)([(0,_react1.useClick)(context),(0,_react1.useRole)(context),(0,_react1.useDismiss)(context,dismiss)]).getFloatingProps;var mergedRef=(0,_react1.useMergeRefs)([ref,floating]);var NewAnimatePresence=_framerMotion.AnimatePresence;return _react.default.createElement(_framerMotion.LazyMotion,{features:_framerMotion.domAnimation},_react.default.createElement(_react1.FloatingPortal,null,_react.default.createElement(NewAnimatePresence,null,open&&_react.default.createElement(_react1.FloatingOverlay,{style:{zIndex:9999},lockScroll:true},_react.default.createElement(_react1.FloatingFocusManager,{context:context},_react.default.createElement(_framerMotion.m.div,{className:size==="xxl"?"":backdropClasses,initial:"unmount",exit:"unmount",animate:open?"mount":"unmount",variants:backdropAnimation,transition:{duration:.2}},_react.default.createElement(_framerMotion.m.div,_extends({},getFloatingProps(_objectSpreadProps(_objectSpread({},rest),{ref:mergedRef,className:dialogClasses,"aria-labelledby":labelId,"aria-describedby":descriptionId})),{initial:"unmount",exit:"unmount",animate:open?"mount":"unmount",variants:appliedAnimation}),children)))))))});Dialog.propTypes={open:_dialog.propTypesOpen,handler:_dialog.propTypesHandler,size:_propTypes.default.oneOf(_dialog.propTypesSize),dismiss:_dialog.propTypesDismiss,animate:_dialog.propTypesAnimate,className:_dialog.propTypesClassName,children:_dialog.propTypesChildren};Dialog.displayName="MaterialTailwind.Dialog";var _default=Object.assign(Dialog,{Header:_dialogHeader.DialogHeader,Body:_dialogBody.DialogBody,Footer:_dialogFooter.DialogFooter});