import {
  require_react_dom
} from "./chunk-GSZ7ISAW.js";
import {
  require_classnames
} from "./chunk-LSVB3Q7Z.js";
import {
  require_react
} from "./chunk-ZGRSIX2Q.js";
import {
  __commonJS,
  __esm,
  __export,
  __toCommonJS,
  __toESM
} from "./chunk-ROME4SDB.js";

// node_modules/tailwind-merge/dist/tailwind-merge.cjs.development.js
var require_tailwind_merge_cjs_development = __commonJS({
  "node_modules/tailwind-merge/dist/tailwind-merge.cjs.development.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function twJoin() {
      var index4 = 0;
      var argument;
      var resolvedValue;
      var string = "";
      while (index4 < arguments.length) {
        if (argument = arguments[index4++]) {
          if (resolvedValue = toValue(argument)) {
            string && (string += " ");
            string += resolvedValue;
          }
        }
      }
      return string;
    }
    function toValue(mix2) {
      if (typeof mix2 === "string") {
        return mix2;
      }
      var resolvedValue;
      var string = "";
      for (var k = 0; k < mix2.length; k++) {
        if (mix2[k]) {
          if (resolvedValue = toValue(mix2[k])) {
            string && (string += " ");
            string += resolvedValue;
          }
        }
      }
      return string;
    }
    function _extends2() {
      _extends2 = Object.assign ? Object.assign.bind() : function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    var CLASS_PART_SEPARATOR = "-";
    function createClassUtils(config) {
      var classMap = createClassMap(config);
      function getClassGroupId(className) {
        var classParts = className.split(CLASS_PART_SEPARATOR);
        if (classParts[0] === "" && classParts.length !== 1) {
          classParts.shift();
        }
        return getGroupRecursive(classParts, classMap) || getGroupIdForArbitraryProperty(className);
      }
      function getConflictingClassGroupIds(classGroupId) {
        return config.conflictingClassGroups[classGroupId] || [];
      }
      return {
        getClassGroupId,
        getConflictingClassGroupIds
      };
    }
    function getGroupRecursive(classParts, classPartObject) {
      var _classPartObject$vali;
      if (classParts.length === 0) {
        return classPartObject.classGroupId;
      }
      var currentClassPart = classParts[0];
      var nextClassPartObject = classPartObject.nextPart.get(currentClassPart);
      var classGroupFromNextClassPart = nextClassPartObject ? getGroupRecursive(classParts.slice(1), nextClassPartObject) : void 0;
      if (classGroupFromNextClassPart) {
        return classGroupFromNextClassPart;
      }
      if (classPartObject.validators.length === 0) {
        return void 0;
      }
      var classRest = classParts.join(CLASS_PART_SEPARATOR);
      return (_classPartObject$vali = classPartObject.validators.find(function(_ref) {
        var validator = _ref.validator;
        return validator(classRest);
      })) == null ? void 0 : _classPartObject$vali.classGroupId;
    }
    var arbitraryPropertyRegex = /^\[(.+)\]$/;
    function getGroupIdForArbitraryProperty(className) {
      if (arbitraryPropertyRegex.test(className)) {
        var arbitraryPropertyClassName = arbitraryPropertyRegex.exec(className)[1];
        var property = arbitraryPropertyClassName == null ? void 0 : arbitraryPropertyClassName.substring(0, arbitraryPropertyClassName.indexOf(":"));
        if (property) {
          return "arbitrary.." + property;
        }
      }
    }
    function createClassMap(config) {
      var theme = config.theme, prefix = config.prefix;
      var classMap = {
        nextPart: /* @__PURE__ */ new Map(),
        validators: []
      };
      var prefixedClassGroupEntries = getPrefixedClassGroupEntries(Object.entries(config.classGroups), prefix);
      prefixedClassGroupEntries.forEach(function(_ref2) {
        var classGroupId = _ref2[0], classGroup = _ref2[1];
        processClassesRecursively(classGroup, classMap, classGroupId, theme);
      });
      return classMap;
    }
    function processClassesRecursively(classGroup, classPartObject, classGroupId, theme) {
      classGroup.forEach(function(classDefinition) {
        if (typeof classDefinition === "string") {
          var classPartObjectToEdit = classDefinition === "" ? classPartObject : getPart(classPartObject, classDefinition);
          classPartObjectToEdit.classGroupId = classGroupId;
          return;
        }
        if (typeof classDefinition === "function") {
          if (isThemeGetter(classDefinition)) {
            processClassesRecursively(classDefinition(theme), classPartObject, classGroupId, theme);
            return;
          }
          classPartObject.validators.push({
            validator: classDefinition,
            classGroupId
          });
          return;
        }
        Object.entries(classDefinition).forEach(function(_ref3) {
          var key = _ref3[0], classGroup2 = _ref3[1];
          processClassesRecursively(classGroup2, getPart(classPartObject, key), classGroupId, theme);
        });
      });
    }
    function getPart(classPartObject, path) {
      var currentClassPartObject = classPartObject;
      path.split(CLASS_PART_SEPARATOR).forEach(function(pathPart) {
        if (!currentClassPartObject.nextPart.has(pathPart)) {
          currentClassPartObject.nextPart.set(pathPart, {
            nextPart: /* @__PURE__ */ new Map(),
            validators: []
          });
        }
        currentClassPartObject = currentClassPartObject.nextPart.get(pathPart);
      });
      return currentClassPartObject;
    }
    function isThemeGetter(func) {
      return func.isThemeGetter;
    }
    function getPrefixedClassGroupEntries(classGroupEntries, prefix) {
      if (!prefix) {
        return classGroupEntries;
      }
      return classGroupEntries.map(function(_ref4) {
        var classGroupId = _ref4[0], classGroup = _ref4[1];
        var prefixedClassGroup = classGroup.map(function(classDefinition) {
          if (typeof classDefinition === "string") {
            return prefix + classDefinition;
          }
          if (typeof classDefinition === "object") {
            return Object.fromEntries(Object.entries(classDefinition).map(function(_ref5) {
              var key = _ref5[0], value = _ref5[1];
              return [prefix + key, value];
            }));
          }
          return classDefinition;
        });
        return [classGroupId, prefixedClassGroup];
      });
    }
    function createLruCache(maxCacheSize) {
      if (maxCacheSize < 1) {
        return {
          get: function get() {
            return void 0;
          },
          set: function set() {
          }
        };
      }
      var cacheSize = 0;
      var cache = /* @__PURE__ */ new Map();
      var previousCache = /* @__PURE__ */ new Map();
      function update(key, value) {
        cache.set(key, value);
        cacheSize++;
        if (cacheSize > maxCacheSize) {
          cacheSize = 0;
          previousCache = cache;
          cache = /* @__PURE__ */ new Map();
        }
      }
      return {
        get: function get(key) {
          var value = cache.get(key);
          if (value !== void 0) {
            return value;
          }
          if ((value = previousCache.get(key)) !== void 0) {
            update(key, value);
            return value;
          }
        },
        set: function set(key, value) {
          if (cache.has(key)) {
            cache.set(key, value);
          } else {
            update(key, value);
          }
        }
      };
    }
    var IMPORTANT_MODIFIER = "!";
    function createSplitModifiers(config) {
      var separator = config.separator || ":";
      return function splitModifiers(className) {
        var bracketDepth = 0;
        var modifiers = [];
        var modifierStart = 0;
        for (var index4 = 0; index4 < className.length; index4++) {
          var _char = className[index4];
          if (bracketDepth === 0 && _char === separator[0]) {
            if (separator.length === 1 || className.slice(index4, index4 + separator.length) === separator) {
              modifiers.push(className.slice(modifierStart, index4));
              modifierStart = index4 + separator.length;
            }
          }
          if (_char === "[") {
            bracketDepth++;
          } else if (_char === "]") {
            bracketDepth--;
          }
        }
        var baseClassNameWithImportantModifier = modifiers.length === 0 ? className : className.substring(modifierStart);
        var hasImportantModifier = baseClassNameWithImportantModifier.startsWith(IMPORTANT_MODIFIER);
        var baseClassName = hasImportantModifier ? baseClassNameWithImportantModifier.substring(1) : baseClassNameWithImportantModifier;
        return {
          modifiers,
          hasImportantModifier,
          baseClassName
        };
      };
    }
    function sortModifiers(modifiers) {
      if (modifiers.length <= 1) {
        return modifiers;
      }
      var sortedModifiers = [];
      var unsortedModifiers = [];
      modifiers.forEach(function(modifier) {
        var isArbitraryVariant = modifier[0] === "[";
        if (isArbitraryVariant) {
          sortedModifiers.push.apply(sortedModifiers, unsortedModifiers.sort().concat([modifier]));
          unsortedModifiers = [];
        } else {
          unsortedModifiers.push(modifier);
        }
      });
      sortedModifiers.push.apply(sortedModifiers, unsortedModifiers.sort());
      return sortedModifiers;
    }
    function createConfigUtils(config) {
      return _extends2({
        cache: createLruCache(config.cacheSize),
        splitModifiers: createSplitModifiers(config)
      }, createClassUtils(config));
    }
    var SPLIT_CLASSES_REGEX = /\s+/;
    function mergeClassList(classList, configUtils) {
      var splitModifiers = configUtils.splitModifiers, getClassGroupId = configUtils.getClassGroupId, getConflictingClassGroupIds = configUtils.getConflictingClassGroupIds;
      var classGroupsInConflict = /* @__PURE__ */ new Set();
      return classList.trim().split(SPLIT_CLASSES_REGEX).map(function(originalClassName) {
        var _splitModifiers = splitModifiers(originalClassName), modifiers = _splitModifiers.modifiers, hasImportantModifier = _splitModifiers.hasImportantModifier, baseClassName = _splitModifiers.baseClassName;
        var classGroupId = getClassGroupId(baseClassName);
        if (!classGroupId) {
          return {
            isTailwindClass: false,
            originalClassName
          };
        }
        var variantModifier = sortModifiers(modifiers).join(":");
        var modifierId = hasImportantModifier ? variantModifier + IMPORTANT_MODIFIER : variantModifier;
        return {
          isTailwindClass: true,
          modifierId,
          classGroupId,
          originalClassName
        };
      }).reverse().filter(function(parsed) {
        if (!parsed.isTailwindClass) {
          return true;
        }
        var modifierId = parsed.modifierId, classGroupId = parsed.classGroupId;
        var classId = modifierId + classGroupId;
        if (classGroupsInConflict.has(classId)) {
          return false;
        }
        classGroupsInConflict.add(classId);
        getConflictingClassGroupIds(classGroupId).forEach(function(group) {
          return classGroupsInConflict.add(modifierId + group);
        });
        return true;
      }).reverse().map(function(parsed) {
        return parsed.originalClassName;
      }).join(" ");
    }
    function createTailwindMerge() {
      for (var _len = arguments.length, createConfig = new Array(_len), _key = 0; _key < _len; _key++) {
        createConfig[_key] = arguments[_key];
      }
      var configUtils;
      var cacheGet;
      var cacheSet;
      var functionToCall = initTailwindMerge;
      function initTailwindMerge(classList) {
        var firstCreateConfig = createConfig[0], restCreateConfig = createConfig.slice(1);
        var config = restCreateConfig.reduce(function(previousConfig, createConfigCurrent) {
          return createConfigCurrent(previousConfig);
        }, firstCreateConfig());
        configUtils = createConfigUtils(config);
        cacheGet = configUtils.cache.get;
        cacheSet = configUtils.cache.set;
        functionToCall = tailwindMerge;
        return tailwindMerge(classList);
      }
      function tailwindMerge(classList) {
        var cachedResult = cacheGet(classList);
        if (cachedResult) {
          return cachedResult;
        }
        var result = mergeClassList(classList, configUtils);
        cacheSet(classList, result);
        return result;
      }
      return function callTailwindMerge() {
        return functionToCall(twJoin.apply(null, arguments));
      };
    }
    function fromTheme(key) {
      var themeGetter = function themeGetter2(theme) {
        return theme[key] || [];
      };
      themeGetter.isThemeGetter = true;
      return themeGetter;
    }
    var arbitraryValueRegex = /^\[(.+)\]$/;
    var fractionRegex = /^\d+\/\d+$/;
    var stringLengths = /* @__PURE__ */ new Set(["px", "full", "screen"]);
    var tshirtUnitRegex = /^(\d+)?(xs|sm|md|lg|xl)$/;
    var lengthUnitRegex = /\d+(%|px|r?em|[sdl]?v([hwib]|min|max)|pt|pc|in|cm|mm|cap|ch|ex|r?lh)/;
    var shadowRegex = /^-?((\d+)?\.?(\d+)[a-z]+|0)_-?((\d+)?\.?(\d+)[a-z]+|0)/;
    function isLength(classPart) {
      return !Number.isNaN(Number(classPart)) || stringLengths.has(classPart) || fractionRegex.test(classPart) || isArbitraryLength(classPart);
    }
    function isArbitraryLength(classPart) {
      var _arbitraryValueRegex$;
      var arbitraryValue = (_arbitraryValueRegex$ = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$[1];
      if (arbitraryValue) {
        return arbitraryValue.startsWith("length:") || lengthUnitRegex.test(arbitraryValue);
      }
      return false;
    }
    function isArbitrarySize(classPart) {
      var _arbitraryValueRegex$2;
      var arbitraryValue = (_arbitraryValueRegex$2 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$2[1];
      return arbitraryValue ? arbitraryValue.startsWith("size:") : false;
    }
    function isArbitraryPosition(classPart) {
      var _arbitraryValueRegex$3;
      var arbitraryValue = (_arbitraryValueRegex$3 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$3[1];
      return arbitraryValue ? arbitraryValue.startsWith("position:") : false;
    }
    function isArbitraryUrl(classPart) {
      var _arbitraryValueRegex$4;
      var arbitraryValue = (_arbitraryValueRegex$4 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$4[1];
      return arbitraryValue ? arbitraryValue.startsWith("url(") || arbitraryValue.startsWith("url:") : false;
    }
    function isArbitraryNumber(classPart) {
      var _arbitraryValueRegex$5;
      var arbitraryValue = (_arbitraryValueRegex$5 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$5[1];
      return arbitraryValue ? !Number.isNaN(Number(arbitraryValue)) || arbitraryValue.startsWith("number:") : false;
    }
    var isArbitraryWeight = isArbitraryNumber;
    function isInteger(classPart) {
      var _arbitraryValueRegex$6;
      var arbitraryValue = (_arbitraryValueRegex$6 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$6[1];
      if (arbitraryValue) {
        return Number.isInteger(Number(arbitraryValue));
      }
      return Number.isInteger(Number(classPart));
    }
    function isArbitraryValue(classPart) {
      return arbitraryValueRegex.test(classPart);
    }
    function isAny() {
      return true;
    }
    function isTshirtSize(classPart) {
      return tshirtUnitRegex.test(classPart);
    }
    function isArbitraryShadow(classPart) {
      var _arbitraryValueRegex$7;
      var arbitraryValue = (_arbitraryValueRegex$7 = arbitraryValueRegex.exec(classPart)) == null ? void 0 : _arbitraryValueRegex$7[1];
      if (arbitraryValue) {
        return shadowRegex.test(arbitraryValue);
      }
      return false;
    }
    var validators = {
      __proto__: null,
      isLength,
      isArbitraryLength,
      isArbitrarySize,
      isArbitraryPosition,
      isArbitraryUrl,
      isArbitraryNumber,
      isArbitraryWeight,
      isInteger,
      isArbitraryValue,
      isAny,
      isTshirtSize,
      isArbitraryShadow
    };
    function getDefaultConfig() {
      var colors = fromTheme("colors");
      var spacing = fromTheme("spacing");
      var blur = fromTheme("blur");
      var brightness = fromTheme("brightness");
      var borderColor = fromTheme("borderColor");
      var borderRadius = fromTheme("borderRadius");
      var borderSpacing = fromTheme("borderSpacing");
      var borderWidth = fromTheme("borderWidth");
      var contrast = fromTheme("contrast");
      var grayscale = fromTheme("grayscale");
      var hueRotate = fromTheme("hueRotate");
      var invert = fromTheme("invert");
      var gap = fromTheme("gap");
      var gradientColorStops = fromTheme("gradientColorStops");
      var inset = fromTheme("inset");
      var margin = fromTheme("margin");
      var opacity = fromTheme("opacity");
      var padding = fromTheme("padding");
      var saturate = fromTheme("saturate");
      var scale = fromTheme("scale");
      var sepia = fromTheme("sepia");
      var skew = fromTheme("skew");
      var space = fromTheme("space");
      var translate = fromTheme("translate");
      var getOverscroll = function getOverscroll2() {
        return ["auto", "contain", "none"];
      };
      var getOverflow = function getOverflow2() {
        return ["auto", "hidden", "clip", "visible", "scroll"];
      };
      var getSpacingWithAuto = function getSpacingWithAuto2() {
        return ["auto", spacing];
      };
      var getLengthWithEmpty = function getLengthWithEmpty2() {
        return ["", isLength];
      };
      var getIntegerWithAuto = function getIntegerWithAuto2() {
        return ["auto", isInteger];
      };
      var getPositions = function getPositions2() {
        return ["bottom", "center", "left", "left-bottom", "left-top", "right", "right-bottom", "right-top", "top"];
      };
      var getLineStyles = function getLineStyles2() {
        return ["solid", "dashed", "dotted", "double", "none"];
      };
      var getBlendModes = function getBlendModes2() {
        return ["normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity", "plus-lighter"];
      };
      var getAlign = function getAlign2() {
        return ["start", "end", "center", "between", "around", "evenly"];
      };
      var getZeroAndEmpty = function getZeroAndEmpty2() {
        return ["", "0", isArbitraryValue];
      };
      var getBreaks = function getBreaks2() {
        return ["auto", "avoid", "all", "avoid-page", "page", "left", "right", "column"];
      };
      return {
        cacheSize: 500,
        theme: {
          colors: [isAny],
          spacing: [isLength],
          blur: ["none", "", isTshirtSize, isArbitraryLength],
          brightness: [isInteger],
          borderColor: [colors],
          borderRadius: ["none", "", "full", isTshirtSize, isArbitraryLength],
          borderSpacing: [spacing],
          borderWidth: getLengthWithEmpty(),
          contrast: [isInteger],
          grayscale: getZeroAndEmpty(),
          hueRotate: [isInteger],
          invert: getZeroAndEmpty(),
          gap: [spacing],
          gradientColorStops: [colors],
          inset: getSpacingWithAuto(),
          margin: getSpacingWithAuto(),
          opacity: [isInteger],
          padding: [spacing],
          saturate: [isInteger],
          scale: [isInteger],
          sepia: getZeroAndEmpty(),
          skew: [isInteger, isArbitraryValue],
          space: [spacing],
          translate: [spacing]
        },
        classGroups: {
          // Layout
          /**
           * Aspect Ratio
           * @see https://tailwindcss.com/docs/aspect-ratio
           */
          aspect: [{
            aspect: ["auto", "square", "video", isArbitraryValue]
          }],
          /**
           * Container
           * @see https://tailwindcss.com/docs/container
           */
          container: ["container"],
          /**
           * Columns
           * @see https://tailwindcss.com/docs/columns
           */
          columns: [{
            columns: [isTshirtSize]
          }],
          /**
           * Break After
           * @see https://tailwindcss.com/docs/break-after
           */
          "break-after": [{
            "break-after": getBreaks()
          }],
          /**
           * Break Before
           * @see https://tailwindcss.com/docs/break-before
           */
          "break-before": [{
            "break-before": getBreaks()
          }],
          /**
           * Break Inside
           * @see https://tailwindcss.com/docs/break-inside
           */
          "break-inside": [{
            "break-inside": ["auto", "avoid", "avoid-page", "avoid-column"]
          }],
          /**
           * Box Decoration Break
           * @see https://tailwindcss.com/docs/box-decoration-break
           */
          "box-decoration": [{
            "box-decoration": ["slice", "clone"]
          }],
          /**
           * Box Sizing
           * @see https://tailwindcss.com/docs/box-sizing
           */
          box: [{
            box: ["border", "content"]
          }],
          /**
           * Display
           * @see https://tailwindcss.com/docs/display
           */
          display: ["block", "inline-block", "inline", "flex", "inline-flex", "table", "inline-table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row-group", "table-row", "flow-root", "grid", "inline-grid", "contents", "list-item", "hidden"],
          /**
           * Floats
           * @see https://tailwindcss.com/docs/float
           */
          "float": [{
            "float": ["right", "left", "none"]
          }],
          /**
           * Clear
           * @see https://tailwindcss.com/docs/clear
           */
          clear: [{
            clear: ["left", "right", "both", "none"]
          }],
          /**
           * Isolation
           * @see https://tailwindcss.com/docs/isolation
           */
          isolation: ["isolate", "isolation-auto"],
          /**
           * Object Fit
           * @see https://tailwindcss.com/docs/object-fit
           */
          "object-fit": [{
            object: ["contain", "cover", "fill", "none", "scale-down"]
          }],
          /**
           * Object Position
           * @see https://tailwindcss.com/docs/object-position
           */
          "object-position": [{
            object: [].concat(getPositions(), [isArbitraryValue])
          }],
          /**
           * Overflow
           * @see https://tailwindcss.com/docs/overflow
           */
          overflow: [{
            overflow: getOverflow()
          }],
          /**
           * Overflow X
           * @see https://tailwindcss.com/docs/overflow
           */
          "overflow-x": [{
            "overflow-x": getOverflow()
          }],
          /**
           * Overflow Y
           * @see https://tailwindcss.com/docs/overflow
           */
          "overflow-y": [{
            "overflow-y": getOverflow()
          }],
          /**
           * Overscroll Behavior
           * @see https://tailwindcss.com/docs/overscroll-behavior
           */
          overscroll: [{
            overscroll: getOverscroll()
          }],
          /**
           * Overscroll Behavior X
           * @see https://tailwindcss.com/docs/overscroll-behavior
           */
          "overscroll-x": [{
            "overscroll-x": getOverscroll()
          }],
          /**
           * Overscroll Behavior Y
           * @see https://tailwindcss.com/docs/overscroll-behavior
           */
          "overscroll-y": [{
            "overscroll-y": getOverscroll()
          }],
          /**
           * Position
           * @see https://tailwindcss.com/docs/position
           */
          position: ["static", "fixed", "absolute", "relative", "sticky"],
          /**
           * Top / Right / Bottom / Left
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          inset: [{
            inset: [inset]
          }],
          /**
           * Right / Left
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          "inset-x": [{
            "inset-x": [inset]
          }],
          /**
           * Top / Bottom
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          "inset-y": [{
            "inset-y": [inset]
          }],
          /**
           * Top
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          top: [{
            top: [inset]
          }],
          /**
           * Right
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          right: [{
            right: [inset]
          }],
          /**
           * Bottom
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          bottom: [{
            bottom: [inset]
          }],
          /**
           * Left
           * @see https://tailwindcss.com/docs/top-right-bottom-left
           */
          left: [{
            left: [inset]
          }],
          /**
           * Visibility
           * @see https://tailwindcss.com/docs/visibility
           */
          visibility: ["visible", "invisible", "collapse"],
          /**
           * Z-Index
           * @see https://tailwindcss.com/docs/z-index
           */
          z: [{
            z: [isInteger]
          }],
          // Flexbox and Grid
          /**
           * Flex Basis
           * @see https://tailwindcss.com/docs/flex-basis
           */
          basis: [{
            basis: [spacing]
          }],
          /**
           * Flex Direction
           * @see https://tailwindcss.com/docs/flex-direction
           */
          "flex-direction": [{
            flex: ["row", "row-reverse", "col", "col-reverse"]
          }],
          /**
           * Flex Wrap
           * @see https://tailwindcss.com/docs/flex-wrap
           */
          "flex-wrap": [{
            flex: ["wrap", "wrap-reverse", "nowrap"]
          }],
          /**
           * Flex
           * @see https://tailwindcss.com/docs/flex
           */
          flex: [{
            flex: ["1", "auto", "initial", "none", isArbitraryValue]
          }],
          /**
           * Flex Grow
           * @see https://tailwindcss.com/docs/flex-grow
           */
          grow: [{
            grow: getZeroAndEmpty()
          }],
          /**
           * Flex Shrink
           * @see https://tailwindcss.com/docs/flex-shrink
           */
          shrink: [{
            shrink: getZeroAndEmpty()
          }],
          /**
           * Order
           * @see https://tailwindcss.com/docs/order
           */
          order: [{
            order: ["first", "last", "none", isInteger]
          }],
          /**
           * Grid Template Columns
           * @see https://tailwindcss.com/docs/grid-template-columns
           */
          "grid-cols": [{
            "grid-cols": [isAny]
          }],
          /**
           * Grid Column Start / End
           * @see https://tailwindcss.com/docs/grid-column
           */
          "col-start-end": [{
            col: ["auto", {
              span: [isInteger]
            }]
          }],
          /**
           * Grid Column Start
           * @see https://tailwindcss.com/docs/grid-column
           */
          "col-start": [{
            "col-start": getIntegerWithAuto()
          }],
          /**
           * Grid Column End
           * @see https://tailwindcss.com/docs/grid-column
           */
          "col-end": [{
            "col-end": getIntegerWithAuto()
          }],
          /**
           * Grid Template Rows
           * @see https://tailwindcss.com/docs/grid-template-rows
           */
          "grid-rows": [{
            "grid-rows": [isAny]
          }],
          /**
           * Grid Row Start / End
           * @see https://tailwindcss.com/docs/grid-row
           */
          "row-start-end": [{
            row: ["auto", {
              span: [isInteger]
            }]
          }],
          /**
           * Grid Row Start
           * @see https://tailwindcss.com/docs/grid-row
           */
          "row-start": [{
            "row-start": getIntegerWithAuto()
          }],
          /**
           * Grid Row End
           * @see https://tailwindcss.com/docs/grid-row
           */
          "row-end": [{
            "row-end": getIntegerWithAuto()
          }],
          /**
           * Grid Auto Flow
           * @see https://tailwindcss.com/docs/grid-auto-flow
           */
          "grid-flow": [{
            "grid-flow": ["row", "col", "dense", "row-dense", "col-dense"]
          }],
          /**
           * Grid Auto Columns
           * @see https://tailwindcss.com/docs/grid-auto-columns
           */
          "auto-cols": [{
            "auto-cols": ["auto", "min", "max", "fr", isArbitraryValue]
          }],
          /**
           * Grid Auto Rows
           * @see https://tailwindcss.com/docs/grid-auto-rows
           */
          "auto-rows": [{
            "auto-rows": ["auto", "min", "max", "fr", isArbitraryValue]
          }],
          /**
           * Gap
           * @see https://tailwindcss.com/docs/gap
           */
          gap: [{
            gap: [gap]
          }],
          /**
           * Gap X
           * @see https://tailwindcss.com/docs/gap
           */
          "gap-x": [{
            "gap-x": [gap]
          }],
          /**
           * Gap Y
           * @see https://tailwindcss.com/docs/gap
           */
          "gap-y": [{
            "gap-y": [gap]
          }],
          /**
           * Justify Content
           * @see https://tailwindcss.com/docs/justify-content
           */
          "justify-content": [{
            justify: getAlign()
          }],
          /**
           * Justify Items
           * @see https://tailwindcss.com/docs/justify-items
           */
          "justify-items": [{
            "justify-items": ["start", "end", "center", "stretch"]
          }],
          /**
           * Justify Self
           * @see https://tailwindcss.com/docs/justify-self
           */
          "justify-self": [{
            "justify-self": ["auto", "start", "end", "center", "stretch"]
          }],
          /**
           * Align Content
           * @see https://tailwindcss.com/docs/align-content
           */
          "align-content": [{
            content: [].concat(getAlign(), ["baseline"])
          }],
          /**
           * Align Items
           * @see https://tailwindcss.com/docs/align-items
           */
          "align-items": [{
            items: ["start", "end", "center", "baseline", "stretch"]
          }],
          /**
           * Align Self
           * @see https://tailwindcss.com/docs/align-self
           */
          "align-self": [{
            self: ["auto", "start", "end", "center", "stretch", "baseline"]
          }],
          /**
           * Place Content
           * @see https://tailwindcss.com/docs/place-content
           */
          "place-content": [{
            "place-content": [].concat(getAlign(), ["baseline", "stretch"])
          }],
          /**
           * Place Items
           * @see https://tailwindcss.com/docs/place-items
           */
          "place-items": [{
            "place-items": ["start", "end", "center", "baseline", "stretch"]
          }],
          /**
           * Place Self
           * @see https://tailwindcss.com/docs/place-self
           */
          "place-self": [{
            "place-self": ["auto", "start", "end", "center", "stretch"]
          }],
          // Spacing
          /**
           * Padding
           * @see https://tailwindcss.com/docs/padding
           */
          p: [{
            p: [padding]
          }],
          /**
           * Padding X
           * @see https://tailwindcss.com/docs/padding
           */
          px: [{
            px: [padding]
          }],
          /**
           * Padding Y
           * @see https://tailwindcss.com/docs/padding
           */
          py: [{
            py: [padding]
          }],
          /**
           * Padding Top
           * @see https://tailwindcss.com/docs/padding
           */
          pt: [{
            pt: [padding]
          }],
          /**
           * Padding Right
           * @see https://tailwindcss.com/docs/padding
           */
          pr: [{
            pr: [padding]
          }],
          /**
           * Padding Bottom
           * @see https://tailwindcss.com/docs/padding
           */
          pb: [{
            pb: [padding]
          }],
          /**
           * Padding Left
           * @see https://tailwindcss.com/docs/padding
           */
          pl: [{
            pl: [padding]
          }],
          /**
           * Margin
           * @see https://tailwindcss.com/docs/margin
           */
          m: [{
            m: [margin]
          }],
          /**
           * Margin X
           * @see https://tailwindcss.com/docs/margin
           */
          mx: [{
            mx: [margin]
          }],
          /**
           * Margin Y
           * @see https://tailwindcss.com/docs/margin
           */
          my: [{
            my: [margin]
          }],
          /**
           * Margin Top
           * @see https://tailwindcss.com/docs/margin
           */
          mt: [{
            mt: [margin]
          }],
          /**
           * Margin Right
           * @see https://tailwindcss.com/docs/margin
           */
          mr: [{
            mr: [margin]
          }],
          /**
           * Margin Bottom
           * @see https://tailwindcss.com/docs/margin
           */
          mb: [{
            mb: [margin]
          }],
          /**
           * Margin Left
           * @see https://tailwindcss.com/docs/margin
           */
          ml: [{
            ml: [margin]
          }],
          /**
           * Space Between X
           * @see https://tailwindcss.com/docs/space
           */
          "space-x": [{
            "space-x": [space]
          }],
          /**
           * Space Between X Reverse
           * @see https://tailwindcss.com/docs/space
           */
          "space-x-reverse": ["space-x-reverse"],
          /**
           * Space Between Y
           * @see https://tailwindcss.com/docs/space
           */
          "space-y": [{
            "space-y": [space]
          }],
          /**
           * Space Between Y Reverse
           * @see https://tailwindcss.com/docs/space
           */
          "space-y-reverse": ["space-y-reverse"],
          // Sizing
          /**
           * Width
           * @see https://tailwindcss.com/docs/width
           */
          w: [{
            w: ["auto", "min", "max", "fit", spacing]
          }],
          /**
           * Min-Width
           * @see https://tailwindcss.com/docs/min-width
           */
          "min-w": [{
            "min-w": ["min", "max", "fit", isLength]
          }],
          /**
           * Max-Width
           * @see https://tailwindcss.com/docs/max-width
           */
          "max-w": [{
            "max-w": ["0", "none", "full", "min", "max", "fit", "prose", {
              screen: [isTshirtSize]
            }, isTshirtSize, isArbitraryLength]
          }],
          /**
           * Height
           * @see https://tailwindcss.com/docs/height
           */
          h: [{
            h: [spacing, "auto", "min", "max", "fit"]
          }],
          /**
           * Min-Height
           * @see https://tailwindcss.com/docs/min-height
           */
          "min-h": [{
            "min-h": ["min", "max", "fit", isLength]
          }],
          /**
           * Max-Height
           * @see https://tailwindcss.com/docs/max-height
           */
          "max-h": [{
            "max-h": [spacing, "min", "max", "fit"]
          }],
          // Typography
          /**
           * Font Size
           * @see https://tailwindcss.com/docs/font-size
           */
          "font-size": [{
            text: ["base", isTshirtSize, isArbitraryLength]
          }],
          /**
           * Font Smoothing
           * @see https://tailwindcss.com/docs/font-smoothing
           */
          "font-smoothing": ["antialiased", "subpixel-antialiased"],
          /**
           * Font Style
           * @see https://tailwindcss.com/docs/font-style
           */
          "font-style": ["italic", "not-italic"],
          /**
           * Font Weight
           * @see https://tailwindcss.com/docs/font-weight
           */
          "font-weight": [{
            font: ["thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", isArbitraryNumber]
          }],
          /**
           * Font Family
           * @see https://tailwindcss.com/docs/font-family
           */
          "font-family": [{
            font: [isAny]
          }],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-normal": ["normal-nums"],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-ordinal": ["ordinal"],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-slashed-zero": ["slashed-zero"],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-figure": ["lining-nums", "oldstyle-nums"],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-spacing": ["proportional-nums", "tabular-nums"],
          /**
           * Font Variant Numeric
           * @see https://tailwindcss.com/docs/font-variant-numeric
           */
          "fvn-fraction": ["diagonal-fractions", "stacked-fractons"],
          /**
           * Letter Spacing
           * @see https://tailwindcss.com/docs/letter-spacing
           */
          tracking: [{
            tracking: ["tighter", "tight", "normal", "wide", "wider", "widest", isArbitraryLength]
          }],
          /**
           * Line Height
           * @see https://tailwindcss.com/docs/line-height
           */
          leading: [{
            leading: ["none", "tight", "snug", "normal", "relaxed", "loose", isLength]
          }],
          /**
           * List Style Type
           * @see https://tailwindcss.com/docs/list-style-type
           */
          "list-style-type": [{
            list: ["none", "disc", "decimal", isArbitraryValue]
          }],
          /**
           * List Style Position
           * @see https://tailwindcss.com/docs/list-style-position
           */
          "list-style-position": [{
            list: ["inside", "outside"]
          }],
          /**
           * Placeholder Color
           * @deprecated since Tailwind CSS v3.0.0
           * @see https://tailwindcss.com/docs/placeholder-color
           */
          "placeholder-color": [{
            placeholder: [colors]
          }],
          /**
           * Placeholder Opacity
           * @see https://tailwindcss.com/docs/placeholder-opacity
           */
          "placeholder-opacity": [{
            "placeholder-opacity": [opacity]
          }],
          /**
           * Text Alignment
           * @see https://tailwindcss.com/docs/text-align
           */
          "text-alignment": [{
            text: ["left", "center", "right", "justify", "start", "end"]
          }],
          /**
           * Text Color
           * @see https://tailwindcss.com/docs/text-color
           */
          "text-color": [{
            text: [colors]
          }],
          /**
           * Text Opacity
           * @see https://tailwindcss.com/docs/text-opacity
           */
          "text-opacity": [{
            "text-opacity": [opacity]
          }],
          /**
           * Text Decoration
           * @see https://tailwindcss.com/docs/text-decoration
           */
          "text-decoration": ["underline", "overline", "line-through", "no-underline"],
          /**
           * Text Decoration Style
           * @see https://tailwindcss.com/docs/text-decoration-style
           */
          "text-decoration-style": [{
            decoration: [].concat(getLineStyles(), ["wavy"])
          }],
          /**
           * Text Decoration Thickness
           * @see https://tailwindcss.com/docs/text-decoration-thickness
           */
          "text-decoration-thickness": [{
            decoration: ["auto", "from-font", isLength]
          }],
          /**
           * Text Underline Offset
           * @see https://tailwindcss.com/docs/text-underline-offset
           */
          "underline-offset": [{
            "underline-offset": ["auto", isLength]
          }],
          /**
           * Text Decoration Color
           * @see https://tailwindcss.com/docs/text-decoration-color
           */
          "text-decoration-color": [{
            decoration: [colors]
          }],
          /**
           * Text Transform
           * @see https://tailwindcss.com/docs/text-transform
           */
          "text-transform": ["uppercase", "lowercase", "capitalize", "normal-case"],
          /**
           * Text Overflow
           * @see https://tailwindcss.com/docs/text-overflow
           */
          "text-overflow": ["truncate", "text-ellipsis", "text-clip"],
          /**
           * Text Indent
           * @see https://tailwindcss.com/docs/text-indent
           */
          indent: [{
            indent: [spacing]
          }],
          /**
           * Vertical Alignment
           * @see https://tailwindcss.com/docs/vertical-align
           */
          "vertical-align": [{
            align: ["baseline", "top", "middle", "bottom", "text-top", "text-bottom", "sub", "super", isArbitraryLength]
          }],
          /**
           * Whitespace
           * @see https://tailwindcss.com/docs/whitespace
           */
          whitespace: [{
            whitespace: ["normal", "nowrap", "pre", "pre-line", "pre-wrap"]
          }],
          /**
           * Word Break
           * @see https://tailwindcss.com/docs/word-break
           */
          "break": [{
            "break": ["normal", "words", "all", "keep"]
          }],
          /**
           * Content
           * @see https://tailwindcss.com/docs/content
           */
          content: [{
            content: ["none", isArbitraryValue]
          }],
          // Backgrounds
          /**
           * Background Attachment
           * @see https://tailwindcss.com/docs/background-attachment
           */
          "bg-attachment": [{
            bg: ["fixed", "local", "scroll"]
          }],
          /**
           * Background Clip
           * @see https://tailwindcss.com/docs/background-clip
           */
          "bg-clip": [{
            "bg-clip": ["border", "padding", "content", "text"]
          }],
          /**
           * Background Opacity
           * @deprecated since Tailwind CSS v3.0.0
           * @see https://tailwindcss.com/docs/background-opacity
           */
          "bg-opacity": [{
            "bg-opacity": [opacity]
          }],
          /**
           * Background Origin
           * @see https://tailwindcss.com/docs/background-origin
           */
          "bg-origin": [{
            "bg-origin": ["border", "padding", "content"]
          }],
          /**
           * Background Position
           * @see https://tailwindcss.com/docs/background-position
           */
          "bg-position": [{
            bg: [].concat(getPositions(), [isArbitraryPosition])
          }],
          /**
           * Background Repeat
           * @see https://tailwindcss.com/docs/background-repeat
           */
          "bg-repeat": [{
            bg: ["no-repeat", {
              repeat: ["", "x", "y", "round", "space"]
            }]
          }],
          /**
           * Background Size
           * @see https://tailwindcss.com/docs/background-size
           */
          "bg-size": [{
            bg: ["auto", "cover", "contain", isArbitrarySize]
          }],
          /**
           * Background Image
           * @see https://tailwindcss.com/docs/background-image
           */
          "bg-image": [{
            bg: ["none", {
              "gradient-to": ["t", "tr", "r", "br", "b", "bl", "l", "tl"]
            }, isArbitraryUrl]
          }],
          /**
           * Background Color
           * @see https://tailwindcss.com/docs/background-color
           */
          "bg-color": [{
            bg: [colors]
          }],
          /**
           * Gradient Color Stops From
           * @see https://tailwindcss.com/docs/gradient-color-stops
           */
          "gradient-from": [{
            from: [gradientColorStops]
          }],
          /**
           * Gradient Color Stops Via
           * @see https://tailwindcss.com/docs/gradient-color-stops
           */
          "gradient-via": [{
            via: [gradientColorStops]
          }],
          /**
           * Gradient Color Stops To
           * @see https://tailwindcss.com/docs/gradient-color-stops
           */
          "gradient-to": [{
            to: [gradientColorStops]
          }],
          // Borders
          /**
           * Border Radius
           * @see https://tailwindcss.com/docs/border-radius
           */
          rounded: [{
            rounded: [borderRadius]
          }],
          /**
           * Border Radius Top
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-t": [{
            "rounded-t": [borderRadius]
          }],
          /**
           * Border Radius Right
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-r": [{
            "rounded-r": [borderRadius]
          }],
          /**
           * Border Radius Bottom
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-b": [{
            "rounded-b": [borderRadius]
          }],
          /**
           * Border Radius Left
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-l": [{
            "rounded-l": [borderRadius]
          }],
          /**
           * Border Radius Top Left
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-tl": [{
            "rounded-tl": [borderRadius]
          }],
          /**
           * Border Radius Top Right
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-tr": [{
            "rounded-tr": [borderRadius]
          }],
          /**
           * Border Radius Bottom Right
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-br": [{
            "rounded-br": [borderRadius]
          }],
          /**
           * Border Radius Bottom Left
           * @see https://tailwindcss.com/docs/border-radius
           */
          "rounded-bl": [{
            "rounded-bl": [borderRadius]
          }],
          /**
           * Border Width
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w": [{
            border: [borderWidth]
          }],
          /**
           * Border Width X
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-x": [{
            "border-x": [borderWidth]
          }],
          /**
           * Border Width Y
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-y": [{
            "border-y": [borderWidth]
          }],
          /**
           * Border Width Top
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-t": [{
            "border-t": [borderWidth]
          }],
          /**
           * Border Width Right
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-r": [{
            "border-r": [borderWidth]
          }],
          /**
           * Border Width Bottom
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-b": [{
            "border-b": [borderWidth]
          }],
          /**
           * Border Width Left
           * @see https://tailwindcss.com/docs/border-width
           */
          "border-w-l": [{
            "border-l": [borderWidth]
          }],
          /**
           * Border Opacity
           * @see https://tailwindcss.com/docs/border-opacity
           */
          "border-opacity": [{
            "border-opacity": [opacity]
          }],
          /**
           * Border Style
           * @see https://tailwindcss.com/docs/border-style
           */
          "border-style": [{
            border: [].concat(getLineStyles(), ["hidden"])
          }],
          /**
           * Divide Width X
           * @see https://tailwindcss.com/docs/divide-width
           */
          "divide-x": [{
            "divide-x": [borderWidth]
          }],
          /**
           * Divide Width X Reverse
           * @see https://tailwindcss.com/docs/divide-width
           */
          "divide-x-reverse": ["divide-x-reverse"],
          /**
           * Divide Width Y
           * @see https://tailwindcss.com/docs/divide-width
           */
          "divide-y": [{
            "divide-y": [borderWidth]
          }],
          /**
           * Divide Width Y Reverse
           * @see https://tailwindcss.com/docs/divide-width
           */
          "divide-y-reverse": ["divide-y-reverse"],
          /**
           * Divide Opacity
           * @see https://tailwindcss.com/docs/divide-opacity
           */
          "divide-opacity": [{
            "divide-opacity": [opacity]
          }],
          /**
           * Divide Style
           * @see https://tailwindcss.com/docs/divide-style
           */
          "divide-style": [{
            divide: getLineStyles()
          }],
          /**
           * Border Color
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color": [{
            border: [borderColor]
          }],
          /**
           * Border Color X
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-x": [{
            "border-x": [borderColor]
          }],
          /**
           * Border Color Y
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-y": [{
            "border-y": [borderColor]
          }],
          /**
           * Border Color Top
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-t": [{
            "border-t": [borderColor]
          }],
          /**
           * Border Color Right
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-r": [{
            "border-r": [borderColor]
          }],
          /**
           * Border Color Bottom
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-b": [{
            "border-b": [borderColor]
          }],
          /**
           * Border Color Left
           * @see https://tailwindcss.com/docs/border-color
           */
          "border-color-l": [{
            "border-l": [borderColor]
          }],
          /**
           * Divide Color
           * @see https://tailwindcss.com/docs/divide-color
           */
          "divide-color": [{
            divide: [borderColor]
          }],
          /**
           * Outline Style
           * @see https://tailwindcss.com/docs/outline-style
           */
          "outline-style": [{
            outline: [""].concat(getLineStyles())
          }],
          /**
           * Outline Offset
           * @see https://tailwindcss.com/docs/outline-offset
           */
          "outline-offset": [{
            "outline-offset": [isLength]
          }],
          /**
           * Outline Width
           * @see https://tailwindcss.com/docs/outline-width
           */
          "outline-w": [{
            outline: [isLength]
          }],
          /**
           * Outline Color
           * @see https://tailwindcss.com/docs/outline-color
           */
          "outline-color": [{
            outline: [colors]
          }],
          /**
           * Ring Width
           * @see https://tailwindcss.com/docs/ring-width
           */
          "ring-w": [{
            ring: getLengthWithEmpty()
          }],
          /**
           * Ring Width Inset
           * @see https://tailwindcss.com/docs/ring-width
           */
          "ring-w-inset": ["ring-inset"],
          /**
           * Ring Color
           * @see https://tailwindcss.com/docs/ring-color
           */
          "ring-color": [{
            ring: [colors]
          }],
          /**
           * Ring Opacity
           * @see https://tailwindcss.com/docs/ring-opacity
           */
          "ring-opacity": [{
            "ring-opacity": [opacity]
          }],
          /**
           * Ring Offset Width
           * @see https://tailwindcss.com/docs/ring-offset-width
           */
          "ring-offset-w": [{
            "ring-offset": [isLength]
          }],
          /**
           * Ring Offset Color
           * @see https://tailwindcss.com/docs/ring-offset-color
           */
          "ring-offset-color": [{
            "ring-offset": [colors]
          }],
          // Effects
          /**
           * Box Shadow
           * @see https://tailwindcss.com/docs/box-shadow
           */
          shadow: [{
            shadow: ["", "inner", "none", isTshirtSize, isArbitraryShadow]
          }],
          /**
           * Box Shadow Color
           * @see https://tailwindcss.com/docs/box-shadow-color
           */
          "shadow-color": [{
            shadow: [isAny]
          }],
          /**
           * Opacity
           * @see https://tailwindcss.com/docs/opacity
           */
          opacity: [{
            opacity: [opacity]
          }],
          /**
           * Mix Beldn Mode
           * @see https://tailwindcss.com/docs/mix-blend-mode
           */
          "mix-blend": [{
            "mix-blend": getBlendModes()
          }],
          /**
           * Background Blend Mode
           * @see https://tailwindcss.com/docs/background-blend-mode
           */
          "bg-blend": [{
            "bg-blend": getBlendModes()
          }],
          // Filters
          /**
           * Filter
           * @deprecated since Tailwind CSS v3.0.0
           * @see https://tailwindcss.com/docs/filter
           */
          filter: [{
            filter: ["", "none"]
          }],
          /**
           * Blur
           * @see https://tailwindcss.com/docs/blur
           */
          blur: [{
            blur: [blur]
          }],
          /**
           * Brightness
           * @see https://tailwindcss.com/docs/brightness
           */
          brightness: [{
            brightness: [brightness]
          }],
          /**
           * Contrast
           * @see https://tailwindcss.com/docs/contrast
           */
          contrast: [{
            contrast: [contrast]
          }],
          /**
           * Drop Shadow
           * @see https://tailwindcss.com/docs/drop-shadow
           */
          "drop-shadow": [{
            "drop-shadow": ["", "none", isTshirtSize, isArbitraryValue]
          }],
          /**
           * Grayscale
           * @see https://tailwindcss.com/docs/grayscale
           */
          grayscale: [{
            grayscale: [grayscale]
          }],
          /**
           * Hue Rotate
           * @see https://tailwindcss.com/docs/hue-rotate
           */
          "hue-rotate": [{
            "hue-rotate": [hueRotate]
          }],
          /**
           * Invert
           * @see https://tailwindcss.com/docs/invert
           */
          invert: [{
            invert: [invert]
          }],
          /**
           * Saturate
           * @see https://tailwindcss.com/docs/saturate
           */
          saturate: [{
            saturate: [saturate]
          }],
          /**
           * Sepia
           * @see https://tailwindcss.com/docs/sepia
           */
          sepia: [{
            sepia: [sepia]
          }],
          /**
           * Backdrop Filter
           * @deprecated since Tailwind CSS v3.0.0
           * @see https://tailwindcss.com/docs/backdrop-filter
           */
          "backdrop-filter": [{
            "backdrop-filter": ["", "none"]
          }],
          /**
           * Backdrop Blur
           * @see https://tailwindcss.com/docs/backdrop-blur
           */
          "backdrop-blur": [{
            "backdrop-blur": [blur]
          }],
          /**
           * Backdrop Brightness
           * @see https://tailwindcss.com/docs/backdrop-brightness
           */
          "backdrop-brightness": [{
            "backdrop-brightness": [brightness]
          }],
          /**
           * Backdrop Contrast
           * @see https://tailwindcss.com/docs/backdrop-contrast
           */
          "backdrop-contrast": [{
            "backdrop-contrast": [contrast]
          }],
          /**
           * Backdrop Grayscale
           * @see https://tailwindcss.com/docs/backdrop-grayscale
           */
          "backdrop-grayscale": [{
            "backdrop-grayscale": [grayscale]
          }],
          /**
           * Backdrop Hue Rotate
           * @see https://tailwindcss.com/docs/backdrop-hue-rotate
           */
          "backdrop-hue-rotate": [{
            "backdrop-hue-rotate": [hueRotate]
          }],
          /**
           * Backdrop Invert
           * @see https://tailwindcss.com/docs/backdrop-invert
           */
          "backdrop-invert": [{
            "backdrop-invert": [invert]
          }],
          /**
           * Backdrop Opacity
           * @see https://tailwindcss.com/docs/backdrop-opacity
           */
          "backdrop-opacity": [{
            "backdrop-opacity": [opacity]
          }],
          /**
           * Backdrop Saturate
           * @see https://tailwindcss.com/docs/backdrop-saturate
           */
          "backdrop-saturate": [{
            "backdrop-saturate": [saturate]
          }],
          /**
           * Backdrop Sepia
           * @see https://tailwindcss.com/docs/backdrop-sepia
           */
          "backdrop-sepia": [{
            "backdrop-sepia": [sepia]
          }],
          // Tables
          /**
           * Border Collapse
           * @see https://tailwindcss.com/docs/border-collapse
           */
          "border-collapse": [{
            border: ["collapse", "separate"]
          }],
          /**
           * Border Spacing
           * @see https://tailwindcss.com/docs/border-spacing
           */
          "border-spacing": [{
            "border-spacing": [borderSpacing]
          }],
          /**
           * Border Spacing X
           * @see https://tailwindcss.com/docs/border-spacing
           */
          "border-spacing-x": [{
            "border-spacing-x": [borderSpacing]
          }],
          /**
           * Border Spacing Y
           * @see https://tailwindcss.com/docs/border-spacing
           */
          "border-spacing-y": [{
            "border-spacing-y": [borderSpacing]
          }],
          /**
           * Table Layout
           * @see https://tailwindcss.com/docs/table-layout
           */
          "table-layout": [{
            table: ["auto", "fixed"]
          }],
          // Transitions and Animation
          /**
           * Tranisition Property
           * @see https://tailwindcss.com/docs/transition-property
           */
          transition: [{
            transition: ["none", "all", "", "colors", "opacity", "shadow", "transform", isArbitraryValue]
          }],
          /**
           * Transition Duration
           * @see https://tailwindcss.com/docs/transition-duration
           */
          duration: [{
            duration: [isInteger]
          }],
          /**
           * Transition Timing Function
           * @see https://tailwindcss.com/docs/transition-timing-function
           */
          ease: [{
            ease: ["linear", "in", "out", "in-out", isArbitraryValue]
          }],
          /**
           * Transition Delay
           * @see https://tailwindcss.com/docs/transition-delay
           */
          delay: [{
            delay: [isInteger]
          }],
          /**
           * Animation
           * @see https://tailwindcss.com/docs/animation
           */
          animate: [{
            animate: ["none", "spin", "ping", "pulse", "bounce", isArbitraryValue]
          }],
          // Transforms
          /**
           * Transform
           * @see https://tailwindcss.com/docs/transform
           */
          transform: [{
            transform: ["", "gpu", "none"]
          }],
          /**
           * Scale
           * @see https://tailwindcss.com/docs/scale
           */
          scale: [{
            scale: [scale]
          }],
          /**
           * Scale X
           * @see https://tailwindcss.com/docs/scale
           */
          "scale-x": [{
            "scale-x": [scale]
          }],
          /**
           * Scale Y
           * @see https://tailwindcss.com/docs/scale
           */
          "scale-y": [{
            "scale-y": [scale]
          }],
          /**
           * Rotate
           * @see https://tailwindcss.com/docs/rotate
           */
          rotate: [{
            rotate: [isInteger, isArbitraryValue]
          }],
          /**
           * Translate X
           * @see https://tailwindcss.com/docs/translate
           */
          "translate-x": [{
            "translate-x": [translate]
          }],
          /**
           * Translate Y
           * @see https://tailwindcss.com/docs/translate
           */
          "translate-y": [{
            "translate-y": [translate]
          }],
          /**
           * Skew X
           * @see https://tailwindcss.com/docs/skew
           */
          "skew-x": [{
            "skew-x": [skew]
          }],
          /**
           * Skew Y
           * @see https://tailwindcss.com/docs/skew
           */
          "skew-y": [{
            "skew-y": [skew]
          }],
          /**
           * Transform Origin
           * @see https://tailwindcss.com/docs/transform-origin
           */
          "transform-origin": [{
            origin: ["center", "top", "top-right", "right", "bottom-right", "bottom", "bottom-left", "left", "top-left", isArbitraryValue]
          }],
          // Interactivity
          /**
           * Accent Color
           * @see https://tailwindcss.com/docs/accent-color
           */
          accent: [{
            accent: ["auto", colors]
          }],
          /**
           * Appearance
           * @see https://tailwindcss.com/docs/appearance
           */
          appearance: ["appearance-none"],
          /**
           * Cursor
           * @see https://tailwindcss.com/docs/cursor
           */
          cursor: [{
            cursor: ["auto", "default", "pointer", "wait", "text", "move", "help", "not-allowed", "none", "context-menu", "progress", "cell", "crosshair", "vertical-text", "alias", "copy", "no-drop", "grab", "grabbing", "all-scroll", "col-resize", "row-resize", "n-resize", "e-resize", "s-resize", "w-resize", "ne-resize", "nw-resize", "se-resize", "sw-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "zoom-in", "zoom-out", isArbitraryValue]
          }],
          /**
           * Caret Color
           * @see https://tailwindcss.com/docs/just-in-time-mode#caret-color-utilities
           */
          "caret-color": [{
            caret: [colors]
          }],
          /**
           * Pointer Events
           * @see https://tailwindcss.com/docs/pointer-events
           */
          "pointer-events": [{
            "pointer-events": ["none", "auto"]
          }],
          /**
           * Resize
           * @see https://tailwindcss.com/docs/resize
           */
          resize: [{
            resize: ["none", "y", "x", ""]
          }],
          /**
           * Scroll Behavior
           * @see https://tailwindcss.com/docs/scroll-behavior
           */
          "scroll-behavior": [{
            scroll: ["auto", "smooth"]
          }],
          /**
           * Scroll Margin
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-m": [{
            "scroll-m": [spacing]
          }],
          /**
           * Scroll Margin X
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-mx": [{
            "scroll-mx": [spacing]
          }],
          /**
           * Scroll Margin Y
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-my": [{
            "scroll-my": [spacing]
          }],
          /**
           * Scroll Margin Top
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-mt": [{
            "scroll-mt": [spacing]
          }],
          /**
           * Scroll Margin Right
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-mr": [{
            "scroll-mr": [spacing]
          }],
          /**
           * Scroll Margin Bottom
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-mb": [{
            "scroll-mb": [spacing]
          }],
          /**
           * Scroll Margin Left
           * @see https://tailwindcss.com/docs/scroll-margin
           */
          "scroll-ml": [{
            "scroll-ml": [spacing]
          }],
          /**
           * Scroll Padding
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-p": [{
            "scroll-p": [spacing]
          }],
          /**
           * Scroll Padding X
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-px": [{
            "scroll-px": [spacing]
          }],
          /**
           * Scroll Padding Y
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-py": [{
            "scroll-py": [spacing]
          }],
          /**
           * Scroll Padding Top
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-pt": [{
            "scroll-pt": [spacing]
          }],
          /**
           * Scroll Padding Right
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-pr": [{
            "scroll-pr": [spacing]
          }],
          /**
           * Scroll Padding Bottom
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-pb": [{
            "scroll-pb": [spacing]
          }],
          /**
           * Scroll Padding Left
           * @see https://tailwindcss.com/docs/scroll-padding
           */
          "scroll-pl": [{
            "scroll-pl": [spacing]
          }],
          /**
           * Scroll Snap Align
           * @see https://tailwindcss.com/docs/scroll-snap-align
           */
          "snap-align": [{
            snap: ["start", "end", "center", "align-none"]
          }],
          /**
           * Scroll Snap Stop
           * @see https://tailwindcss.com/docs/scroll-snap-stop
           */
          "snap-stop": [{
            snap: ["normal", "always"]
          }],
          /**
           * Scroll Snap Type
           * @see https://tailwindcss.com/docs/scroll-snap-type
           */
          "snap-type": [{
            snap: ["none", "x", "y", "both"]
          }],
          /**
           * Scroll Snap Type Strictness
           * @see https://tailwindcss.com/docs/scroll-snap-type
           */
          "snap-strictness": [{
            snap: ["mandatory", "proximity"]
          }],
          /**
           * Touch Action
           * @see https://tailwindcss.com/docs/touch-action
           */
          touch: [{
            touch: ["auto", "none", "pinch-zoom", "manipulation", {
              pan: ["x", "left", "right", "y", "up", "down"]
            }]
          }],
          /**
           * User Select
           * @see https://tailwindcss.com/docs/user-select
           */
          select: [{
            select: ["none", "text", "all", "auto"]
          }],
          /**
           * Will Change
           * @see https://tailwindcss.com/docs/will-change
           */
          "will-change": [{
            "will-change": ["auto", "scroll", "contents", "transform", isArbitraryValue]
          }],
          // SVG
          /**
           * Fill
           * @see https://tailwindcss.com/docs/fill
           */
          fill: [{
            fill: [colors, "none"]
          }],
          /**
           * Stroke Width
           * @see https://tailwindcss.com/docs/stroke-width
           */
          "stroke-w": [{
            stroke: [isLength, isArbitraryNumber]
          }],
          /**
           * Stroke
           * @see https://tailwindcss.com/docs/stroke
           */
          stroke: [{
            stroke: [colors, "none"]
          }],
          // Accessibility
          /**
           * Screen Readers
           * @see https://tailwindcss.com/docs/screen-readers
           */
          sr: ["sr-only", "not-sr-only"]
        },
        conflictingClassGroups: {
          overflow: ["overflow-x", "overflow-y"],
          overscroll: ["overscroll-x", "overscroll-y"],
          inset: ["inset-x", "inset-y", "top", "right", "bottom", "left"],
          "inset-x": ["right", "left"],
          "inset-y": ["top", "bottom"],
          flex: ["basis", "grow", "shrink"],
          gap: ["gap-x", "gap-y"],
          p: ["px", "py", "pt", "pr", "pb", "pl"],
          px: ["pr", "pl"],
          py: ["pt", "pb"],
          m: ["mx", "my", "mt", "mr", "mb", "ml"],
          mx: ["mr", "ml"],
          my: ["mt", "mb"],
          "font-size": ["leading"],
          "fvn-normal": ["fvn-ordinal", "fvn-slashed-zero", "fvn-figure", "fvn-spacing", "fvn-fraction"],
          "fvn-ordinal": ["fvn-normal"],
          "fvn-slashed-zero": ["fvn-normal"],
          "fvn-figure": ["fvn-normal"],
          "fvn-spacing": ["fvn-normal"],
          "fvn-fraction": ["fvn-normal"],
          rounded: ["rounded-t", "rounded-r", "rounded-b", "rounded-l", "rounded-tl", "rounded-tr", "rounded-br", "rounded-bl"],
          "rounded-t": ["rounded-tl", "rounded-tr"],
          "rounded-r": ["rounded-tr", "rounded-br"],
          "rounded-b": ["rounded-br", "rounded-bl"],
          "rounded-l": ["rounded-tl", "rounded-bl"],
          "border-spacing": ["border-spacing-x", "border-spacing-y"],
          "border-w": ["border-w-t", "border-w-r", "border-w-b", "border-w-l"],
          "border-w-x": ["border-w-r", "border-w-l"],
          "border-w-y": ["border-w-t", "border-w-b"],
          "border-color": ["border-color-t", "border-color-r", "border-color-b", "border-color-l"],
          "border-color-x": ["border-color-r", "border-color-l"],
          "border-color-y": ["border-color-t", "border-color-b"],
          "scroll-m": ["scroll-mx", "scroll-my", "scroll-mt", "scroll-mr", "scroll-mb", "scroll-ml"],
          "scroll-mx": ["scroll-mr", "scroll-ml"],
          "scroll-my": ["scroll-mt", "scroll-mb"],
          "scroll-p": ["scroll-px", "scroll-py", "scroll-pt", "scroll-pr", "scroll-pb", "scroll-pl"],
          "scroll-px": ["scroll-pr", "scroll-pl"],
          "scroll-py": ["scroll-pt", "scroll-pb"]
        }
      };
    }
    var twMerge = createTailwindMerge(getDefaultConfig);
    function mergeConfigs(baseConfig, configExtension) {
      for (var key in configExtension) {
        mergePropertyRecursively(baseConfig, key, configExtension[key]);
      }
      return baseConfig;
    }
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var overrideTypes = /* @__PURE__ */ new Set(["string", "number", "boolean"]);
    function mergePropertyRecursively(baseObject, mergeKey, mergeValue) {
      if (!hasOwnProperty.call(baseObject, mergeKey) || overrideTypes.has(typeof mergeValue) || mergeValue === null) {
        baseObject[mergeKey] = mergeValue;
        return;
      }
      if (Array.isArray(mergeValue) && Array.isArray(baseObject[mergeKey])) {
        baseObject[mergeKey] = baseObject[mergeKey].concat(mergeValue);
        return;
      }
      if (typeof mergeValue === "object" && typeof baseObject[mergeKey] === "object") {
        if (baseObject[mergeKey] === null) {
          baseObject[mergeKey] = mergeValue;
          return;
        }
        for (var nextKey in mergeValue) {
          mergePropertyRecursively(baseObject[mergeKey], nextKey, mergeValue[nextKey]);
        }
      }
    }
    function extendTailwindMerge(configExtension) {
      for (var _len = arguments.length, createConfig = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        createConfig[_key - 1] = arguments[_key];
      }
      return typeof configExtension === "function" ? createTailwindMerge.apply(void 0, [getDefaultConfig, configExtension].concat(createConfig)) : createTailwindMerge.apply(void 0, [function() {
        return mergeConfigs(getDefaultConfig(), configExtension);
      }].concat(createConfig));
    }
    var join = twJoin;
    exports.createTailwindMerge = createTailwindMerge;
    exports.extendTailwindMerge = extendTailwindMerge;
    exports.fromTheme = fromTheme;
    exports.getDefaultConfig = getDefaultConfig;
    exports.join = join;
    exports.mergeConfigs = mergeConfigs;
    exports.twJoin = twJoin;
    exports.twMerge = twMerge;
    exports.validators = validators;
  }
});

// node_modules/tailwind-merge/dist/index.js
var require_dist = __commonJS({
  "node_modules/tailwind-merge/dist/index.js"(exports, module) {
    "use strict";
    if (false) {
      module.exports = null;
    } else {
      module.exports = require_tailwind_merge_cjs_development();
    }
  }
});

// node_modules/@material-tailwind/react/utils/objectsToArray.js
var require_objectsToArray = __commonJS({
  "node_modules/@material-tailwind/react/utils/objectsToArray.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return objectsToArray;
    } });
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    function objectsToArray(object) {
      var result = [];
      Object.values(object).forEach(function(value) {
        if (typeof value === "string") {
          result = _toConsumableArray(result).concat([value]);
        } else if (typeof value === "object" && !Array.isArray(value) && value !== null) {
          result = _toConsumableArray(result).concat(_toConsumableArray(objectsToArray(value)));
        }
        return void 0;
      });
      return result;
    }
  }
});

// node_modules/@material-tailwind/react/utils/objectsToString.js
var require_objectsToString = __commonJS({
  "node_modules/@material-tailwind/react/utils/objectsToString.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return objectsToString;
    } });
    var _objectsToArray = _interopRequireDefault(require_objectsToArray());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function objectsToString(object) {
      return (0, _objectsToArray.default)(object).join(" ");
    }
  }
});

// node_modules/react-is/cjs/react-is.development.js
var require_react_is_development = __commonJS({
  "node_modules/react-is/cjs/react-is.development.js"(exports) {
    "use strict";
    if (true) {
      (function() {
        "use strict";
        var hasSymbol = typeof Symbol === "function" && Symbol.for;
        var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for("react.element") : 60103;
        var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for("react.portal") : 60106;
        var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for("react.fragment") : 60107;
        var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for("react.strict_mode") : 60108;
        var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for("react.profiler") : 60114;
        var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for("react.provider") : 60109;
        var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for("react.context") : 60110;
        var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for("react.async_mode") : 60111;
        var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for("react.concurrent_mode") : 60111;
        var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for("react.forward_ref") : 60112;
        var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for("react.suspense") : 60113;
        var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for("react.suspense_list") : 60120;
        var REACT_MEMO_TYPE = hasSymbol ? Symbol.for("react.memo") : 60115;
        var REACT_LAZY_TYPE = hasSymbol ? Symbol.for("react.lazy") : 60116;
        var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for("react.block") : 60121;
        var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for("react.fundamental") : 60117;
        var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for("react.responder") : 60118;
        var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for("react.scope") : 60119;
        function isValidElementType(type) {
          return typeof type === "string" || typeof type === "function" || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
          type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === "object" && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
        }
        function typeOf(object) {
          if (typeof object === "object" && object !== null) {
            var $$typeof = object.$$typeof;
            switch ($$typeof) {
              case REACT_ELEMENT_TYPE:
                var type = object.type;
                switch (type) {
                  case REACT_ASYNC_MODE_TYPE:
                  case REACT_CONCURRENT_MODE_TYPE:
                  case REACT_FRAGMENT_TYPE:
                  case REACT_PROFILER_TYPE:
                  case REACT_STRICT_MODE_TYPE:
                  case REACT_SUSPENSE_TYPE:
                    return type;
                  default:
                    var $$typeofType = type && type.$$typeof;
                    switch ($$typeofType) {
                      case REACT_CONTEXT_TYPE:
                      case REACT_FORWARD_REF_TYPE:
                      case REACT_LAZY_TYPE:
                      case REACT_MEMO_TYPE:
                      case REACT_PROVIDER_TYPE:
                        return $$typeofType;
                      default:
                        return $$typeof;
                    }
                }
              case REACT_PORTAL_TYPE:
                return $$typeof;
            }
          }
          return void 0;
        }
        var AsyncMode = REACT_ASYNC_MODE_TYPE;
        var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
        var ContextConsumer = REACT_CONTEXT_TYPE;
        var ContextProvider = REACT_PROVIDER_TYPE;
        var Element2 = REACT_ELEMENT_TYPE;
        var ForwardRef = REACT_FORWARD_REF_TYPE;
        var Fragment2 = REACT_FRAGMENT_TYPE;
        var Lazy = REACT_LAZY_TYPE;
        var Memo = REACT_MEMO_TYPE;
        var Portal = REACT_PORTAL_TYPE;
        var Profiler = REACT_PROFILER_TYPE;
        var StrictMode = REACT_STRICT_MODE_TYPE;
        var Suspense = REACT_SUSPENSE_TYPE;
        var hasWarnedAboutDeprecatedIsAsyncMode = false;
        function isAsyncMode(object) {
          {
            if (!hasWarnedAboutDeprecatedIsAsyncMode) {
              hasWarnedAboutDeprecatedIsAsyncMode = true;
              console["warn"]("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 17+. Update your code to use ReactIs.isConcurrentMode() instead. It has the exact same API.");
            }
          }
          return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
        }
        function isConcurrentMode(object) {
          return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
        }
        function isContextConsumer(object) {
          return typeOf(object) === REACT_CONTEXT_TYPE;
        }
        function isContextProvider(object) {
          return typeOf(object) === REACT_PROVIDER_TYPE;
        }
        function isElement3(object) {
          return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
        }
        function isForwardRef(object) {
          return typeOf(object) === REACT_FORWARD_REF_TYPE;
        }
        function isFragment(object) {
          return typeOf(object) === REACT_FRAGMENT_TYPE;
        }
        function isLazy(object) {
          return typeOf(object) === REACT_LAZY_TYPE;
        }
        function isMemo(object) {
          return typeOf(object) === REACT_MEMO_TYPE;
        }
        function isPortal(object) {
          return typeOf(object) === REACT_PORTAL_TYPE;
        }
        function isProfiler(object) {
          return typeOf(object) === REACT_PROFILER_TYPE;
        }
        function isStrictMode(object) {
          return typeOf(object) === REACT_STRICT_MODE_TYPE;
        }
        function isSuspense(object) {
          return typeOf(object) === REACT_SUSPENSE_TYPE;
        }
        exports.AsyncMode = AsyncMode;
        exports.ConcurrentMode = ConcurrentMode;
        exports.ContextConsumer = ContextConsumer;
        exports.ContextProvider = ContextProvider;
        exports.Element = Element2;
        exports.ForwardRef = ForwardRef;
        exports.Fragment = Fragment2;
        exports.Lazy = Lazy;
        exports.Memo = Memo;
        exports.Portal = Portal;
        exports.Profiler = Profiler;
        exports.StrictMode = StrictMode;
        exports.Suspense = Suspense;
        exports.isAsyncMode = isAsyncMode;
        exports.isConcurrentMode = isConcurrentMode;
        exports.isContextConsumer = isContextConsumer;
        exports.isContextProvider = isContextProvider;
        exports.isElement = isElement3;
        exports.isForwardRef = isForwardRef;
        exports.isFragment = isFragment;
        exports.isLazy = isLazy;
        exports.isMemo = isMemo;
        exports.isPortal = isPortal;
        exports.isProfiler = isProfiler;
        exports.isStrictMode = isStrictMode;
        exports.isSuspense = isSuspense;
        exports.isValidElementType = isValidElementType;
        exports.typeOf = typeOf;
      })();
    }
  }
});

// node_modules/react-is/index.js
var require_react_is = __commonJS({
  "node_modules/react-is/index.js"(exports, module) {
    "use strict";
    if (false) {
      module.exports = null;
    } else {
      module.exports = require_react_is_development();
    }
  }
});

// node_modules/object-assign/index.js
var require_object_assign = __commonJS({
  "node_modules/object-assign/index.js"(exports, module) {
    "use strict";
    var getOwnPropertySymbols = Object.getOwnPropertySymbols;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var propIsEnumerable = Object.prototype.propertyIsEnumerable;
    function toObject(val) {
      if (val === null || val === void 0) {
        throw new TypeError("Object.assign cannot be called with null or undefined");
      }
      return Object(val);
    }
    function shouldUseNative() {
      try {
        if (!Object.assign) {
          return false;
        }
        var test1 = new String("abc");
        test1[5] = "de";
        if (Object.getOwnPropertyNames(test1)[0] === "5") {
          return false;
        }
        var test2 = {};
        for (var i = 0; i < 10; i++) {
          test2["_" + String.fromCharCode(i)] = i;
        }
        var order2 = Object.getOwnPropertyNames(test2).map(function(n) {
          return test2[n];
        });
        if (order2.join("") !== "0123456789") {
          return false;
        }
        var test3 = {};
        "abcdefghijklmnopqrst".split("").forEach(function(letter) {
          test3[letter] = letter;
        });
        if (Object.keys(Object.assign({}, test3)).join("") !== "abcdefghijklmnopqrst") {
          return false;
        }
        return true;
      } catch (err) {
        return false;
      }
    }
    module.exports = shouldUseNative() ? Object.assign : function(target, source) {
      var from;
      var to = toObject(target);
      var symbols;
      for (var s = 1; s < arguments.length; s++) {
        from = Object(arguments[s]);
        for (var key in from) {
          if (hasOwnProperty.call(from, key)) {
            to[key] = from[key];
          }
        }
        if (getOwnPropertySymbols) {
          symbols = getOwnPropertySymbols(from);
          for (var i = 0; i < symbols.length; i++) {
            if (propIsEnumerable.call(from, symbols[i])) {
              to[symbols[i]] = from[symbols[i]];
            }
          }
        }
      }
      return to;
    };
  }
});

// node_modules/prop-types/lib/ReactPropTypesSecret.js
var require_ReactPropTypesSecret = __commonJS({
  "node_modules/prop-types/lib/ReactPropTypesSecret.js"(exports, module) {
    "use strict";
    var ReactPropTypesSecret = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
    module.exports = ReactPropTypesSecret;
  }
});

// node_modules/prop-types/lib/has.js
var require_has = __commonJS({
  "node_modules/prop-types/lib/has.js"(exports, module) {
    module.exports = Function.call.bind(Object.prototype.hasOwnProperty);
  }
});

// node_modules/prop-types/checkPropTypes.js
var require_checkPropTypes = __commonJS({
  "node_modules/prop-types/checkPropTypes.js"(exports, module) {
    "use strict";
    var printWarning = function() {
    };
    if (true) {
      ReactPropTypesSecret = require_ReactPropTypesSecret();
      loggedTypeFailures = {};
      has = require_has();
      printWarning = function(text) {
        var message = "Warning: " + text;
        if (typeof console !== "undefined") {
          console.error(message);
        }
        try {
          throw new Error(message);
        } catch (x) {
        }
      };
    }
    var ReactPropTypesSecret;
    var loggedTypeFailures;
    var has;
    function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
      if (true) {
        for (var typeSpecName in typeSpecs) {
          if (has(typeSpecs, typeSpecName)) {
            var error;
            try {
              if (typeof typeSpecs[typeSpecName] !== "function") {
                var err = Error(
                  (componentName || "React class") + ": " + location + " type `" + typeSpecName + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + typeof typeSpecs[typeSpecName] + "`.This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`."
                );
                err.name = "Invariant Violation";
                throw err;
              }
              error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
            } catch (ex) {
              error = ex;
            }
            if (error && !(error instanceof Error)) {
              printWarning(
                (componentName || "React class") + ": type specification of " + location + " `" + typeSpecName + "` is invalid; the type checker function must return `null` or an `Error` but returned a " + typeof error + ". You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument)."
              );
            }
            if (error instanceof Error && !(error.message in loggedTypeFailures)) {
              loggedTypeFailures[error.message] = true;
              var stack = getStack ? getStack() : "";
              printWarning(
                "Failed " + location + " type: " + error.message + (stack != null ? stack : "")
              );
            }
          }
        }
      }
    }
    checkPropTypes.resetWarningCache = function() {
      if (true) {
        loggedTypeFailures = {};
      }
    };
    module.exports = checkPropTypes;
  }
});

// node_modules/prop-types/factoryWithTypeCheckers.js
var require_factoryWithTypeCheckers = __commonJS({
  "node_modules/prop-types/factoryWithTypeCheckers.js"(exports, module) {
    "use strict";
    var ReactIs = require_react_is();
    var assign = require_object_assign();
    var ReactPropTypesSecret = require_ReactPropTypesSecret();
    var has = require_has();
    var checkPropTypes = require_checkPropTypes();
    var printWarning = function() {
    };
    if (true) {
      printWarning = function(text) {
        var message = "Warning: " + text;
        if (typeof console !== "undefined") {
          console.error(message);
        }
        try {
          throw new Error(message);
        } catch (x) {
        }
      };
    }
    function emptyFunctionThatReturnsNull() {
      return null;
    }
    module.exports = function(isValidElement, throwOnDirectAccess) {
      var ITERATOR_SYMBOL = typeof Symbol === "function" && Symbol.iterator;
      var FAUX_ITERATOR_SYMBOL = "@@iterator";
      function getIteratorFn(maybeIterable) {
        var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
        if (typeof iteratorFn === "function") {
          return iteratorFn;
        }
      }
      var ANONYMOUS = "<<anonymous>>";
      var ReactPropTypes = {
        array: createPrimitiveTypeChecker("array"),
        bigint: createPrimitiveTypeChecker("bigint"),
        bool: createPrimitiveTypeChecker("boolean"),
        func: createPrimitiveTypeChecker("function"),
        number: createPrimitiveTypeChecker("number"),
        object: createPrimitiveTypeChecker("object"),
        string: createPrimitiveTypeChecker("string"),
        symbol: createPrimitiveTypeChecker("symbol"),
        any: createAnyTypeChecker(),
        arrayOf: createArrayOfTypeChecker,
        element: createElementTypeChecker(),
        elementType: createElementTypeTypeChecker(),
        instanceOf: createInstanceTypeChecker,
        node: createNodeChecker(),
        objectOf: createObjectOfTypeChecker,
        oneOf: createEnumTypeChecker,
        oneOfType: createUnionTypeChecker,
        shape: createShapeTypeChecker,
        exact: createStrictShapeTypeChecker
      };
      function is(x, y) {
        if (x === y) {
          return x !== 0 || 1 / x === 1 / y;
        } else {
          return x !== x && y !== y;
        }
      }
      function PropTypeError(message, data2) {
        this.message = message;
        this.data = data2 && typeof data2 === "object" ? data2 : {};
        this.stack = "";
      }
      PropTypeError.prototype = Error.prototype;
      function createChainableTypeChecker(validate) {
        if (true) {
          var manualPropTypeCallCache = {};
          var manualPropTypeWarningCount = 0;
        }
        function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
          componentName = componentName || ANONYMOUS;
          propFullName = propFullName || propName;
          if (secret !== ReactPropTypesSecret) {
            if (throwOnDirectAccess) {
              var err = new Error(
                "Calling PropTypes validators directly is not supported by the `prop-types` package. Use `PropTypes.checkPropTypes()` to call them. Read more at http://fb.me/use-check-prop-types"
              );
              err.name = "Invariant Violation";
              throw err;
            } else if (typeof console !== "undefined") {
              var cacheKey = componentName + ":" + propName;
              if (!manualPropTypeCallCache[cacheKey] && // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3) {
                printWarning(
                  "You are manually calling a React.PropTypes validation function for the `" + propFullName + "` prop on `" + componentName + "`. This is deprecated and will throw in the standalone `prop-types` package. You may be seeing this warning due to a third-party PropTypes library. See https://fb.me/react-warning-dont-call-proptypes for details."
                );
                manualPropTypeCallCache[cacheKey] = true;
                manualPropTypeWarningCount++;
              }
            }
          }
          if (props[propName] == null) {
            if (isRequired) {
              if (props[propName] === null) {
                return new PropTypeError("The " + location + " `" + propFullName + "` is marked as required " + ("in `" + componentName + "`, but its value is `null`."));
              }
              return new PropTypeError("The " + location + " `" + propFullName + "` is marked as required in " + ("`" + componentName + "`, but its value is `undefined`."));
            }
            return null;
          } else {
            return validate(props, propName, componentName, location, propFullName);
          }
        }
        var chainedCheckType = checkType.bind(null, false);
        chainedCheckType.isRequired = checkType.bind(null, true);
        return chainedCheckType;
      }
      function createPrimitiveTypeChecker(expectedType) {
        function validate(props, propName, componentName, location, propFullName, secret) {
          var propValue = props[propName];
          var propType = getPropType(propValue);
          if (propType !== expectedType) {
            var preciseType = getPreciseType(propValue);
            return new PropTypeError(
              "Invalid " + location + " `" + propFullName + "` of type " + ("`" + preciseType + "` supplied to `" + componentName + "`, expected ") + ("`" + expectedType + "`."),
              { expectedType }
            );
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createAnyTypeChecker() {
        return createChainableTypeChecker(emptyFunctionThatReturnsNull);
      }
      function createArrayOfTypeChecker(typeChecker) {
        function validate(props, propName, componentName, location, propFullName) {
          if (typeof typeChecker !== "function") {
            return new PropTypeError("Property `" + propFullName + "` of component `" + componentName + "` has invalid PropType notation inside arrayOf.");
          }
          var propValue = props[propName];
          if (!Array.isArray(propValue)) {
            var propType = getPropType(propValue);
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type " + ("`" + propType + "` supplied to `" + componentName + "`, expected an array."));
          }
          for (var i = 0; i < propValue.length; i++) {
            var error = typeChecker(propValue, i, componentName, location, propFullName + "[" + i + "]", ReactPropTypesSecret);
            if (error instanceof Error) {
              return error;
            }
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createElementTypeChecker() {
        function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          if (!isValidElement(propValue)) {
            var propType = getPropType(propValue);
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type " + ("`" + propType + "` supplied to `" + componentName + "`, expected a single ReactElement."));
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createElementTypeTypeChecker() {
        function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          if (!ReactIs.isValidElementType(propValue)) {
            var propType = getPropType(propValue);
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type " + ("`" + propType + "` supplied to `" + componentName + "`, expected a single ReactElement type."));
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createInstanceTypeChecker(expectedClass) {
        function validate(props, propName, componentName, location, propFullName) {
          if (!(props[propName] instanceof expectedClass)) {
            var expectedClassName = expectedClass.name || ANONYMOUS;
            var actualClassName = getClassName(props[propName]);
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type " + ("`" + actualClassName + "` supplied to `" + componentName + "`, expected ") + ("instance of `" + expectedClassName + "`."));
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createEnumTypeChecker(expectedValues) {
        if (!Array.isArray(expectedValues)) {
          if (true) {
            if (arguments.length > 1) {
              printWarning(
                "Invalid arguments supplied to oneOf, expected an array, got " + arguments.length + " arguments. A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z])."
              );
            } else {
              printWarning("Invalid argument supplied to oneOf, expected an array.");
            }
          }
          return emptyFunctionThatReturnsNull;
        }
        function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          for (var i = 0; i < expectedValues.length; i++) {
            if (is(propValue, expectedValues[i])) {
              return null;
            }
          }
          var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
            var type = getPreciseType(value);
            if (type === "symbol") {
              return String(value);
            }
            return value;
          });
          return new PropTypeError("Invalid " + location + " `" + propFullName + "` of value `" + String(propValue) + "` " + ("supplied to `" + componentName + "`, expected one of " + valuesString + "."));
        }
        return createChainableTypeChecker(validate);
      }
      function createObjectOfTypeChecker(typeChecker) {
        function validate(props, propName, componentName, location, propFullName) {
          if (typeof typeChecker !== "function") {
            return new PropTypeError("Property `" + propFullName + "` of component `" + componentName + "` has invalid PropType notation inside objectOf.");
          }
          var propValue = props[propName];
          var propType = getPropType(propValue);
          if (propType !== "object") {
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type " + ("`" + propType + "` supplied to `" + componentName + "`, expected an object."));
          }
          for (var key in propValue) {
            if (has(propValue, key)) {
              var error = typeChecker(propValue, key, componentName, location, propFullName + "." + key, ReactPropTypesSecret);
              if (error instanceof Error) {
                return error;
              }
            }
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createUnionTypeChecker(arrayOfTypeCheckers) {
        if (!Array.isArray(arrayOfTypeCheckers)) {
          true ? printWarning("Invalid argument supplied to oneOfType, expected an instance of array.") : void 0;
          return emptyFunctionThatReturnsNull;
        }
        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          if (typeof checker !== "function") {
            printWarning(
              "Invalid argument supplied to oneOfType. Expected an array of check functions, but received " + getPostfixForTypeWarning(checker) + " at index " + i + "."
            );
            return emptyFunctionThatReturnsNull;
          }
        }
        function validate(props, propName, componentName, location, propFullName) {
          var expectedTypes = [];
          for (var i2 = 0; i2 < arrayOfTypeCheckers.length; i2++) {
            var checker2 = arrayOfTypeCheckers[i2];
            var checkerResult = checker2(props, propName, componentName, location, propFullName, ReactPropTypesSecret);
            if (checkerResult == null) {
              return null;
            }
            if (checkerResult.data && has(checkerResult.data, "expectedType")) {
              expectedTypes.push(checkerResult.data.expectedType);
            }
          }
          var expectedTypesMessage = expectedTypes.length > 0 ? ", expected one of type [" + expectedTypes.join(", ") + "]" : "";
          return new PropTypeError("Invalid " + location + " `" + propFullName + "` supplied to " + ("`" + componentName + "`" + expectedTypesMessage + "."));
        }
        return createChainableTypeChecker(validate);
      }
      function createNodeChecker() {
        function validate(props, propName, componentName, location, propFullName) {
          if (!isNode2(props[propName])) {
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` supplied to " + ("`" + componentName + "`, expected a ReactNode."));
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function invalidValidatorError(componentName, location, propFullName, key, type) {
        return new PropTypeError(
          (componentName || "React class") + ": " + location + " type `" + propFullName + "." + key + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + type + "`."
        );
      }
      function createShapeTypeChecker(shapeTypes) {
        function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          var propType = getPropType(propValue);
          if (propType !== "object") {
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type `" + propType + "` " + ("supplied to `" + componentName + "`, expected `object`."));
          }
          for (var key in shapeTypes) {
            var checker = shapeTypes[key];
            if (typeof checker !== "function") {
              return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
            }
            var error = checker(propValue, key, componentName, location, propFullName + "." + key, ReactPropTypesSecret);
            if (error) {
              return error;
            }
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function createStrictShapeTypeChecker(shapeTypes) {
        function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          var propType = getPropType(propValue);
          if (propType !== "object") {
            return new PropTypeError("Invalid " + location + " `" + propFullName + "` of type `" + propType + "` " + ("supplied to `" + componentName + "`, expected `object`."));
          }
          var allKeys = assign({}, props[propName], shapeTypes);
          for (var key in allKeys) {
            var checker = shapeTypes[key];
            if (has(shapeTypes, key) && typeof checker !== "function") {
              return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
            }
            if (!checker) {
              return new PropTypeError(
                "Invalid " + location + " `" + propFullName + "` key `" + key + "` supplied to `" + componentName + "`.\nBad object: " + JSON.stringify(props[propName], null, "  ") + "\nValid keys: " + JSON.stringify(Object.keys(shapeTypes), null, "  ")
              );
            }
            var error = checker(propValue, key, componentName, location, propFullName + "." + key, ReactPropTypesSecret);
            if (error) {
              return error;
            }
          }
          return null;
        }
        return createChainableTypeChecker(validate);
      }
      function isNode2(propValue) {
        switch (typeof propValue) {
          case "number":
          case "string":
          case "undefined":
            return true;
          case "boolean":
            return !propValue;
          case "object":
            if (Array.isArray(propValue)) {
              return propValue.every(isNode2);
            }
            if (propValue === null || isValidElement(propValue)) {
              return true;
            }
            var iteratorFn = getIteratorFn(propValue);
            if (iteratorFn) {
              var iterator = iteratorFn.call(propValue);
              var step;
              if (iteratorFn !== propValue.entries) {
                while (!(step = iterator.next()).done) {
                  if (!isNode2(step.value)) {
                    return false;
                  }
                }
              } else {
                while (!(step = iterator.next()).done) {
                  var entry = step.value;
                  if (entry) {
                    if (!isNode2(entry[1])) {
                      return false;
                    }
                  }
                }
              }
            } else {
              return false;
            }
            return true;
          default:
            return false;
        }
      }
      function isSymbol(propType, propValue) {
        if (propType === "symbol") {
          return true;
        }
        if (!propValue) {
          return false;
        }
        if (propValue["@@toStringTag"] === "Symbol") {
          return true;
        }
        if (typeof Symbol === "function" && propValue instanceof Symbol) {
          return true;
        }
        return false;
      }
      function getPropType(propValue) {
        var propType = typeof propValue;
        if (Array.isArray(propValue)) {
          return "array";
        }
        if (propValue instanceof RegExp) {
          return "object";
        }
        if (isSymbol(propType, propValue)) {
          return "symbol";
        }
        return propType;
      }
      function getPreciseType(propValue) {
        if (typeof propValue === "undefined" || propValue === null) {
          return "" + propValue;
        }
        var propType = getPropType(propValue);
        if (propType === "object") {
          if (propValue instanceof Date) {
            return "date";
          } else if (propValue instanceof RegExp) {
            return "regexp";
          }
        }
        return propType;
      }
      function getPostfixForTypeWarning(value) {
        var type = getPreciseType(value);
        switch (type) {
          case "array":
          case "object":
            return "an " + type;
          case "boolean":
          case "date":
          case "regexp":
            return "a " + type;
          default:
            return type;
        }
      }
      function getClassName(propValue) {
        if (!propValue.constructor || !propValue.constructor.name) {
          return ANONYMOUS;
        }
        return propValue.constructor.name;
      }
      ReactPropTypes.checkPropTypes = checkPropTypes;
      ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
      ReactPropTypes.PropTypes = ReactPropTypes;
      return ReactPropTypes;
    };
  }
});

// node_modules/prop-types/index.js
var require_prop_types = __commonJS({
  "node_modules/prop-types/index.js"(exports, module) {
    if (true) {
      ReactIs = require_react_is();
      throwOnDirectAccess = true;
      module.exports = require_factoryWithTypeCheckers()(ReactIs.isElement, throwOnDirectAccess);
    } else {
      module.exports = null();
    }
    var ReactIs;
    var throwOnDirectAccess;
  }
});

// node_modules/deepmerge/dist/cjs.js
var require_cjs = __commonJS({
  "node_modules/deepmerge/dist/cjs.js"(exports, module) {
    "use strict";
    var isMergeableObject = function isMergeableObject2(value) {
      return isNonNullObject(value) && !isSpecial(value);
    };
    function isNonNullObject(value) {
      return !!value && typeof value === "object";
    }
    function isSpecial(value) {
      var stringValue = Object.prototype.toString.call(value);
      return stringValue === "[object RegExp]" || stringValue === "[object Date]" || isReactElement(value);
    }
    var canUseSymbol = typeof Symbol === "function" && Symbol.for;
    var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
    function isReactElement(value) {
      return value.$$typeof === REACT_ELEMENT_TYPE;
    }
    function emptyTarget(val) {
      return Array.isArray(val) ? [] : {};
    }
    function cloneUnlessOtherwiseSpecified(value, options) {
      return options.clone !== false && options.isMergeableObject(value) ? deepmerge(emptyTarget(value), value, options) : value;
    }
    function defaultArrayMerge(target, source, options) {
      return target.concat(source).map(function(element) {
        return cloneUnlessOtherwiseSpecified(element, options);
      });
    }
    function getMergeFunction(key, options) {
      if (!options.customMerge) {
        return deepmerge;
      }
      var customMerge = options.customMerge(key);
      return typeof customMerge === "function" ? customMerge : deepmerge;
    }
    function getEnumerableOwnPropertySymbols(target) {
      return Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols(target).filter(function(symbol) {
        return target.propertyIsEnumerable(symbol);
      }) : [];
    }
    function getKeys(target) {
      return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target));
    }
    function propertyIsOnObject(object, property) {
      try {
        return property in object;
      } catch (_) {
        return false;
      }
    }
    function propertyIsUnsafe(target, key) {
      return propertyIsOnObject(target, key) && !(Object.hasOwnProperty.call(target, key) && Object.propertyIsEnumerable.call(target, key));
    }
    function mergeObject(target, source, options) {
      var destination = {};
      if (options.isMergeableObject(target)) {
        getKeys(target).forEach(function(key) {
          destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
        });
      }
      getKeys(source).forEach(function(key) {
        if (propertyIsUnsafe(target, key)) {
          return;
        }
        if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
          destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
        } else {
          destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
        }
      });
      return destination;
    }
    function deepmerge(target, source, options) {
      options = options || {};
      options.arrayMerge = options.arrayMerge || defaultArrayMerge;
      options.isMergeableObject = options.isMergeableObject || isMergeableObject;
      options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;
      var sourceIsArray = Array.isArray(source);
      var targetIsArray = Array.isArray(target);
      var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;
      if (!sourceAndTargetTypesMatch) {
        return cloneUnlessOtherwiseSpecified(source, options);
      } else if (sourceIsArray) {
        return options.arrayMerge(target, source, options);
      } else {
        return mergeObject(target, source, options);
      }
    }
    deepmerge.all = function deepmergeAll(array, options) {
      if (!Array.isArray(array)) {
        throw new Error("first argument should be an array");
      }
      return array.reduce(function(prev, next) {
        return deepmerge(prev, next, options);
      }, {});
    };
    var deepmerge_1 = deepmerge;
    module.exports = deepmerge_1;
  }
});

// node_modules/@material-tailwind/react/theme/components/accordion/index.js
var require_accordion = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/accordion/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { accordion: function() {
      return accordion;
    }, default: function() {
      return _default;
    } });
    var accordion = { defaultProps: { icon: void 0, className: "", animate: { unmount: {}, mount: {} }, disabled: false }, styles: { base: { container: { display: "block", position: "relative", width: "w-full" }, header: { initial: { display: "flex", justifyContent: "justify-between", alignItems: "items-center", width: "w-full", py: "py-4", borderWidth: "border-b border-b-blue-gray-100", color: "text-blue-gray-700", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-xl", textAlign: "text-left", fontWeight: "font-semibold", lineHeight: "leading-snug", userSelect: "select-none", hover: "hover:text-blue-gray-900", transition: "transition-colors" }, active: { color: "text-blue-gray-900" }, icon: { ml: "ml-4" } }, body: { display: "block", width: "w-full", py: "py-4", color: "text-gray-700", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-light", lineHeight: "leading-normal" }, disabled: { pointerEvents: "pointer-events-none", opacity: "opacity-50" } } } };
    var _default = accordion;
  }
});

// node_modules/@material-tailwind/react/theme/components/alert/alertFilled.js
var require_alertFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/alert/alertFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var alertFilled = { "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white" }, gray: { backgroud: "bg-gray-900", color: "text-white" }, brown: { backgroud: "bg-brown-500", color: "text-white" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white" }, orange: { backgroud: "bg-orange-500", color: "text-white" }, amber: { backgroud: "bg-amber-500", color: "text-black" }, yellow: { backgroud: "bg-yellow-500", color: "text-black" }, lime: { backgroud: "bg-lime-500", color: "text-black" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white" }, green: { backgroud: "bg-green-500", color: "text-white" }, teal: { backgroud: "bg-teal-500", color: "text-white" }, cyan: { backgroud: "bg-cyan-500", color: "text-white" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white" }, blue: { backgroud: "bg-blue-500", color: "text-white" }, indigo: { backgroud: "bg-indigo-500", color: "text-white" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white" }, purple: { backgroud: "bg-purple-500", color: "text-white" }, pink: { backgroud: "bg-pink-500", color: "text-white" }, red: { backgroud: "bg-red-500", color: "text-white" } };
    var _default = alertFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/alert/alertGradient.js
var require_alertGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/alert/alertGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var alertGradient = { "blue-gray": { backgroud: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white" }, gray: { backgroud: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white" }, brown: { backgroud: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white" }, "deep-orange": { backgroud: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white" }, orange: { backgroud: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white" }, amber: { backgroud: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black" }, yellow: { backgroud: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black" }, lime: { backgroud: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black" }, "light-green": { backgroud: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white" }, green: { backgroud: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white" }, teal: { backgroud: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white" }, cyan: { backgroud: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white" }, "light-blue": { backgroud: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white" }, blue: { backgroud: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white" }, indigo: { backgroud: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white" }, "deep-purple": { backgroud: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white" }, purple: { backgroud: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white" }, pink: { backgroud: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white" }, red: { backgroud: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white" } };
    var _default = alertGradient;
  }
});

// node_modules/@material-tailwind/react/theme/components/alert/alertOutlined.js
var require_alertOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/alert/alertOutlined.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var alertOutlined = { "blue-gray": { border: "border border-blue-gray-500", color: "text-blue-gray-700" }, gray: { border: "border border-gray-900", color: "text-gray-900" }, brown: { border: "border border-brown-500", color: "text-brown-700" }, "deep-orange": { border: "border border-deep-orange-500", color: "text-deep-orange-700" }, orange: { border: "border border-orange-500", color: "text-orange-700" }, amber: { border: "border border-amber-500", color: "text-amber-700" }, yellow: { border: "border border-yellow-500", color: "text-yellow-700" }, lime: { border: "border border-lime-500", color: "text-lime-700" }, "light-green": { border: "border border-light-green-500", color: "text-light-green-700" }, green: { border: "border border-green-500", color: "text-green-700" }, teal: { border: "border border-teal-500", color: "text-teal-700" }, cyan: { border: "border border-cyan-500", color: "text-cyan-700" }, "light-blue": { border: "border border-light-blue-500", color: "text-light-blue-700" }, blue: { border: "border border-blue-500", color: "text-blue-700" }, indigo: { border: "border border-indigo-500", color: "text-indigo-700" }, "deep-purple": { border: "border border-deep-purple-500", color: "text-deep-purple-700" }, purple: { border: "border border-purple-500", color: "text-purple-700" }, pink: { border: "border border-pink-500", color: "text-pink-700" }, red: { border: "border border-red-500", color: "text-red-700" } };
    var _default = alertOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/alert/alertGhost.js
var require_alertGhost = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/alert/alertGhost.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var alertGhost = { "blue-gray": { backgroud: "bg-blue-gray-500/20", color: "text-blue-gray-900" }, gray: { backgroud: "bg-gray-900/10", color: "text-gray-900" }, brown: { backgroud: "bg-brown-500/20", color: "text-brown-900" }, "deep-orange": { backgroud: "bg-deep-orange-500/20", color: "text-deep-orange-900" }, orange: { backgroud: "bg-orange-500/20", color: "text-orange-900" }, amber: { backgroud: "bg-amber-500/20", color: "text-amber-900" }, yellow: { backgroud: "bg-yellow-500/20", color: "text-yellow-900" }, lime: { backgroud: "bg-lime-500/20", color: "text-lime-900" }, "light-green": { backgroud: "bg-light-green-500/20", color: "text-light-green-900" }, green: { backgroud: "bg-green-500/20", color: "text-green-900" }, teal: { backgroud: "bg-teal-500/20", color: "text-teal-900" }, cyan: { backgroud: "bg-cyan-500/20", color: "text-cyan-900" }, "light-blue": { backgroud: "bg-light-blue-500/20", color: "text-light-blue-900" }, blue: { backgroud: "bg-blue-500/20", color: "text-blue-900" }, indigo: { backgroud: "bg-indigo-500/20", color: "text-indigo-900" }, "deep-purple": { backgroud: "bg-deep-purple-500/20", color: "text-deep-purple-900" }, purple: { backgroud: "bg-purple-500/20", color: "text-purple-900" }, pink: { backgroud: "bg-pink-500/20", color: "text-pink-900" }, red: { backgroud: "bg-red-500/20", color: "text-red-900" } };
    var _default = alertGhost;
  }
});

// node_modules/@material-tailwind/react/types/generic.js
var require_generic = __commonJS({
  "node_modules/@material-tailwind/react/types/generic.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesColors: function() {
      return propTypesColors;
    }, propTypesAnimation: function() {
      return propTypesAnimation;
    }, propTypesDismissType: function() {
      return propTypesDismissType;
    }, propTypesOffsetType: function() {
      return propTypesOffsetType;
    }, propTypesPlacements: function() {
      return propTypesPlacements;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesColors = ["blue-gray", "gray", "brown", "deep-orange", "orange", "amber", "yellow", "lime", "light-green", "green", "teal", "cyan", "light-blue", "blue", "indigo", "deep-purple", "purple", "pink", "red"];
    var propTypesAnimation = _propTypes.default.shape({ mount: _propTypes.default.instanceOf(Object), unmount: _propTypes.default.instanceOf(Object) });
    var propTypesDismissType = _propTypes.default.shape({ enabled: _propTypes.default.bool, escapeKey: _propTypes.default.bool, referencePress: _propTypes.default.bool, referencePressEvent: _propTypes.default.oneOf(["pointerdown", "mousedown", "click"]), outsidePress: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.func]), outsidePressEvent: _propTypes.default.oneOf(["pointerdown", "mousedown", "click"]), ancestorScroll: _propTypes.default.bool, bubbles: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.shape({ escapeKey: _propTypes.default.bool, outsidePress: _propTypes.default.bool })]) });
    var propTypesOffsetType = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.shape({ mainAxis: _propTypes.default.number, crossAxis: _propTypes.default.number, alignmentAxis: _propTypes.default.number })]);
    var propTypesPlacements = ["top-start", "top", "top-end", "right-start", "right", "right-end", "bottom-start", "bottom", "bottom-end", "left-start", "left", "left-end"];
  }
});

// node_modules/@material-tailwind/react/types/components/alert.js
var require_alert = __commonJS({
  "node_modules/@material-tailwind/react/types/components/alert.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesIcon: function() {
      return propTypesIcon;
    }, propTypesOpen: function() {
      return propTypesOpen;
    }, propTypesOnClose: function() {
      return propTypesOnClose;
    }, propTypesAction: function() {
      return propTypesAction;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesVariant = ["filled", "gradient", "outlined", "ghost"];
    var propTypesColor = _generic.propTypesColors;
    var propTypesIcon = _propTypes.default.node;
    var propTypesOpen = _propTypes.default.bool;
    var propTypesOnClose = _propTypes.default.func;
    var propTypesAction = _propTypes.default.node;
    var propTypesAnimate = _generic.propTypesAnimation;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/alert/index.js
var require_alert2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/alert/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { alert: function() {
      return alert;
    }, default: function() {
      return _default;
    } });
    var _alertFilled = _interopRequireDefault(require_alertFilled());
    var _alertGradient = _interopRequireDefault(require_alertGradient());
    var _alertOutlined = _interopRequireDefault(require_alertOutlined());
    var _alertGhost = _interopRequireDefault(require_alertGhost());
    var _alert = require_alert();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var alert = { defaultProps: { variant: "filled", color: "gray", icon: void 0, open: true, action: void 0, onClose: void 0, animate: { unmount: {}, mount: {} }, className: "" }, valid: { variants: _alert.propTypesVariant, colors: _alert.propTypesColor }, styles: { base: { alert: { position: "relative", display: "block", width: "w-full", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-regular", px: "px-4", py: "py-4", borderRadius: "rounded-lg" }, action: { position: "!absolute", top: "top-3", right: "right-3" } }, variants: { filled: _alertFilled.default, gradient: _alertGradient.default, outlined: _alertOutlined.default, ghost: _alertGhost.default } } };
    var _default = alert;
  }
});

// node_modules/@material-tailwind/react/types/components/avatar.js
var require_avatar = __commonJS({
  "node_modules/@material-tailwind/react/types/components/avatar.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesWithBorder: function() {
      return propTypesWithBorder;
    }, propTypesColor: function() {
      return propTypesColor;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["circular", "rounded", "square"];
    var propTypesSize = ["xs", "sm", "md", "lg", "xl", "xxl"];
    var propTypesClassName = _propTypes.default.string;
    var propTypesWithBorder = _propTypes.default.bool;
    var propTypesColor = ["white"].concat(_toConsumableArray(_generic.propTypesColors));
  }
});

// node_modules/@material-tailwind/react/theme/components/avatar/avatarBorderColor.js
var require_avatarBorderColor = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/avatar/avatarBorderColor.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var avatarBorderColor = { white: { borderColor: "border-white" }, "blue-gray": { borderColor: "border-blue-gray-500" }, gray: { borderColor: "border-gray-900" }, brown: { borderColor: "border-brown-500" }, "deep-orange": { borderColor: "border-deep-orange-500" }, orange: { borderColor: "border-orange-500" }, amber: { borderColor: "border-amber-500" }, yellow: { borderColor: "border-yellow-500" }, lime: { borderColor: "border-lime-500" }, "light-green": { borderColor: "border-light-green-500" }, green: { borderColor: "border-green-500" }, teal: { borderColor: "border-teal-500" }, cyan: { borderColor: "border-cyan-500" }, "light-blue": { borderColor: "border-light-blue-500" }, blue: { borderColor: "border-blue-500" }, indigo: { borderColor: "border-indigo-500" }, "deep-purple": { borderColor: "border-deep-purple-500" }, purple: { borderColor: "border-purple-500" }, pink: { borderColor: "border-pink-500" }, red: { borderColor: "border-red-500" } };
    var _default = avatarBorderColor;
  }
});

// node_modules/@material-tailwind/react/theme/components/avatar/index.js
var require_avatar2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/avatar/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { avatar: function() {
      return avatar;
    }, default: function() {
      return _default;
    } });
    var _avatar = require_avatar();
    var _avatarBorderColor = _interopRequireDefault(require_avatarBorderColor());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var avatar = { defaultProps: { variant: "circular", size: "md", className: "", withBorder: false, color: "gray" }, valid: { variants: _avatar.propTypesVariant, sizes: _avatar.propTypesSize, colors: _avatar.propTypesColor }, styles: { base: { initial: { display: "inline-block", position: "relative", objectFit: "object-cover", objectPosition: "object-center" }, withBorder: { border: "border-2" } }, sizes: { xs: { width: "w-6", height: "h-6", borderRadius: "rounded-md" }, sm: { width: "w-9", height: "h-9", borderRadius: "rounded-md" }, md: { width: "w-12", height: "h-12", borderRadius: "rounded-lg" }, lg: { width: "w-[58px]", height: "h-[58px]", borderRadius: "rounded-lg" }, xl: { width: "w-[74px]", height: "h-[74px]", borderRadius: "rounded-xl" }, xxl: { width: "w-[110px]", height: "h-[110px]", borderRadius: "rounded-2xl" } }, variants: { rounded: {}, square: { borderRadius: "!rounded-none" }, circular: { borderRadius: "!rounded-full" } }, borderColor: _avatarBorderColor.default } };
    var _default = avatar;
  }
});

// node_modules/@material-tailwind/react/theme/components/breadcrumbs/index.js
var require_breadcrumbs = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/breadcrumbs/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { breadcrumbs: function() {
      return breadcrumbs;
    }, default: function() {
      return _default;
    } });
    var breadcrumbs = { defaultProps: { className: "", fullWidth: false, separator: "/" }, styles: { base: { root: { initial: { width: "w-max" }, fullWidth: { display: "block", width: "w-full" } }, list: { display: "flex", flexWrap: "flex-wrap", alignItems: "items-center", width: "w-full", bg: "bg-blue-gray-50", bgOpacity: "bg-opacity-60", py: "py-2", px: "px-4", borderRadius: "rounded-md" }, item: { initial: { display: "flex", alignItems: "items-center", color: "text-blue-gray-900", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-normal", lineHeight: "leading-normal", cursor: "cursor-pointer", transition: "transition-colors duration-300", hover: "hover:text-light-blue-500" }, disabled: { pointerEvents: "pointer-events-none" } }, separator: { color: "text-blue-gray-500", fontSize: "text-sm", fontSmoothing: "antialiased", fontFamily: "font-sans", fontWeight: "font-normal", lineHeight: "leading-normal", px: "mx-2", pointerEvents: "pointer-events-none", userSelcet: "select-none" } } } };
    var _default = breadcrumbs;
  }
});

// node_modules/@material-tailwind/react/theme/components/button/buttonFilled.js
var require_buttonFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/button/buttonFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var buttonFilled = { white: { background: "bg-white", color: "text-blue-gray-900", shadow: "shadow-md shadow-blue-gray-500/10", hover: "hover:shadow-lg hover:shadow-blue-gray-500/20", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, black: { background: "bg-gray-900", color: "text-white", shadow: "shadow-md shadow-gray-900/10", hover: "hover:shadow-lg hover:shadow-gray-900/20", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, "blue-gray": { background: "bg-blue-gray-500", color: "text-white", shadow: "shadow-md shadow-blue-gray-500/20", hover: "hover:shadow-lg hover:shadow-blue-gray-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, gray: { background: "bg-gray-900", color: "text-white", shadow: "shadow-md shadow-gray-900/10", hover: "hover:shadow-lg hover:shadow-gray-900/20", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, brown: { background: "bg-brown-500", color: "text-white", shadow: "shadow-md shadow-brown-500/20", hover: "hover:shadow-lg hover:shadow-brown-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, "deep-orange": { background: "bg-deep-orange-500", color: "text-white", shadow: "shadow-md shadow-deep-orange-500/20", hover: "hover:shadow-lg hover:shadow-deep-orange-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, orange: { background: "bg-orange-500", color: "text-white", shadow: "shadow-md shadow-orange-500/20", hover: "hover:shadow-lg hover:shadow-orange-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, amber: { background: "bg-amber-500", color: "text-black", shadow: "shadow-md shadow-amber-500/20", hover: "hover:shadow-lg hover:shadow-amber-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, yellow: { background: "bg-yellow-500", color: "text-black", shadow: "shadow-md shadow-yellow-500/20", hover: "hover:shadow-lg hover:shadow-yellow-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, lime: { background: "bg-lime-500", color: "text-black", shadow: "shadow-md shadow-lime-500/20", hover: "hover:shadow-lg hover:shadow-lime-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, "light-green": { background: "bg-light-green-500", color: "text-white", shadow: "shadow-md shadow-light-green-500/20", hover: "hover:shadow-lg hover:shadow-light-green-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, green: { background: "bg-green-500", color: "text-white", shadow: "shadow-md shadow-green-500/20", hover: "hover:shadow-lg hover:shadow-green-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, teal: { background: "bg-teal-500", color: "text-white", shadow: "shadow-md shadow-teal-500/20", hover: "hover:shadow-lg hover:shadow-teal-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, cyan: { background: "bg-cyan-500", color: "text-white", shadow: "shadow-md shadow-cyan-500/20", hover: "hover:shadow-lg hover:shadow-cyan-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, "light-blue": { background: "bg-light-blue-500", color: "text-white", shadow: "shadow-md shadow-light-blue-500/20", hover: "hover:shadow-lg hover:shadow-light-blue-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, blue: { background: "bg-blue-500", color: "text-white", shadow: "shadow-md shadow-blue-500/20", hover: "hover:shadow-lg hover:shadow-blue-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, indigo: { background: "bg-indigo-500", color: "text-white", shadow: "shadow-md shadow-indigo-500/20", hover: "hover:shadow-lg hover:shadow-indigo-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, "deep-purple": { background: "bg-deep-purple-500", color: "text-white", shadow: "shadow-md shadow-deep-purple-500/20", hover: "hover:shadow-lg hover:shadow-deep-purple-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, purple: { background: "bg-purple-500", color: "text-white", shadow: "shadow-md shadow-purple-500/20", hover: "hover:shadow-lg hover:shadow-purple-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, pink: { background: "bg-pink-500", color: "text-white", shadow: "shadow-md shadow-pink-500/20", hover: "hover:shadow-lg hover:shadow-pink-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, red: { background: "bg-red-500", color: "text-white", shadow: "shadow-md shadow-red-500/20", hover: "hover:shadow-lg hover:shadow-red-500/40", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" } };
    var _default = buttonFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/button/buttonGradient.js
var require_buttonGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/button/buttonGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var buttonGradient = { white: { background: "bg-white", color: "text-blue-gray-900", shadow: "shadow-md shadow-blue-gray-500/10", hover: "hover:shadow-lg hover:shadow-blue-gray-500/20", focus: "focus:opacity-[0.85] focus:shadow-none", active: "active:opacity-[0.85] active:shadow-none" }, black: { background: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white", shadow: "shadow-md shadow-gray-900/10", hover: "hover:shadow-lg hover:shadow-gray-900/20", active: "active:opacity-[0.85]" }, "blue-gray": { background: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white", shadow: "shadow-md shadow-blue-gray-500/20", hover: "hover:shadow-lg hover:shadow-blue-gray-500/40", active: "active:opacity-[0.85]" }, gray: { background: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white", shadow: "shadow-md shadow-gray-900/10", hover: "hover:shadow-lg hover:shadow-gray-900/20", active: "active:opacity-[0.85]" }, brown: { background: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white", shadow: "shadow-md shadow-brown-500/20", hover: "hover:shadow-lg hover:shadow-brown-500/40", active: "active:opacity-[0.85]" }, "deep-orange": { background: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white", shadow: "shadow-md shadow-deep-orange-500/20", hover: "hover:shadow-lg hover:shadow-deep-orange-500/40", active: "active:opacity-[0.85]" }, orange: { background: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white", shadow: "shadow-md shadow-orange-500/20", hover: "hover:shadow-lg hover:shadow-orange-500/40", active: "active:opacity-[0.85]" }, amber: { background: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black", shadow: "shadow-md shadow-amber-500/20", hover: "hover:shadow-lg hover:shadow-amber-500/40", active: "active:opacity-[0.85]" }, yellow: { background: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black", shadow: "shadow-md shadow-yellow-500/20", hover: "hover:shadow-lg hover:shadow-yellow-500/40", active: "active:opacity-[0.85]" }, lime: { background: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black", shadow: "shadow-md shadow-lime-500/20", hover: "hover:shadow-lg hover:shadow-lime-500/40", active: "active:opacity-[0.85]" }, "light-green": { background: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white", shadow: "shadow-md shadow-light-green-500/20", hover: "hover:shadow-lg hover:shadow-light-green-500/40", active: "active:opacity-[0.85]" }, green: { background: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white", shadow: "shadow-md shadow-green-500/20", hover: "hover:shadow-lg hover:shadow-green-500/40", active: "active:opacity-[0.85]" }, teal: { background: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white", shadow: "shadow-md shadow-teal-500/20", hover: "hover:shadow-lg hover:shadow-teal-500/40", active: "active:opacity-[0.85]" }, cyan: { background: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white", shadow: "shadow-md shadow-cyan-500/20", hover: "hover:shadow-lg hover:shadow-cyan-500/40", active: "active:opacity-[0.85]" }, "light-blue": { background: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white", shadow: "shadow-md shadow-light-blue-500/20", hover: "hover:shadow-lg hover:shadow-light-blue-500/40", active: "active:opacity-[0.85]" }, blue: { background: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white", shadow: "shadow-md shadow-blue-500/20", hover: "hover:shadow-lg hover:shadow-blue-500/40", active: "active:opacity-[0.85]" }, indigo: { background: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white", shadow: "shadow-md shadow-indigo-500/20", hover: "hover:shadow-lg hover:shadow-indigo-500/40", active: "active:opacity-[0.85]" }, "deep-purple": { background: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white", shadow: "shadow-md shadow-deep-purple-500/20", hover: "hover:shadow-lg hover:shadow-deep-purple-500/40", active: "active:opacity-[0.85]" }, purple: { background: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white", shadow: "shadow-md shadow-purple-500/20", hover: "hover:shadow-lg hover:shadow-purple-500/40", active: "active:opacity-[0.85]" }, pink: { background: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white", shadow: "shadow-md shadow-pink-500/20", hover: "hover:shadow-lg hover:shadow-pink-500/40", active: "active:opacity-[0.85]" }, red: { background: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white", shadow: "shadow-md shadow-red-500/20", hover: "hover:shadow-lg hover:shadow-red-500/40", active: "active:opacity-[0.85]" } };
    var _default = buttonGradient;
  }
});

// node_modules/@material-tailwind/react/theme/components/button/buttonOutlined.js
var require_buttonOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/button/buttonOutlined.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var buttonOutlined = { white: { border: "border border-white", color: "text-white", hover: "hover:opacity-75", focus: "focus:ring focus:ring-white/50", active: "active:opacity-[0.85]" }, black: { border: "border border-gray-900", color: "text-gray-900", hover: "hover:opacity-75", focus: "focus:ring focus:ring-gray-300", active: "active:opacity-[0.85]" }, "blue-gray": { border: "border border-blue-gray-500", color: "text-blue-gray-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-blue-gray-200", active: "active:opacity-[0.85]" }, gray: { border: "border border-gray-900", color: "text-gray-900", hover: "hover:opacity-75", focus: "focus:ring focus:ring-gray-300", active: "active:opacity-[0.85]" }, brown: { border: "border border-brown-500", color: "text-brown-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-brown-200", active: "active:opacity-[0.85]" }, "deep-orange": { border: "border border-deep-orange-500", color: "text-deep-orange-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-deep-orange-200", active: "active:opacity-[0.85]" }, orange: { border: "border border-orange-500", color: "text-orange-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-orange-200", active: "active:opacity-[0.85]" }, amber: { border: "border border-amber-500", color: "text-amber-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-amber-200", active: "active:opacity-[0.85]" }, yellow: { border: "border border-yellow-500", color: "text-yellow-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-yellow-200", active: "active:opacity-[0.85]" }, lime: { border: "border border-lime-500", color: "text-lime-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-lime-200", active: "active:opacity-[0.85]" }, "light-green": { border: "border border-light-green-500", color: "text-light-green-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-light-green-200", active: "active:opacity-[0.85]" }, green: { border: "border border-green-500", color: "text-green-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-green-200", active: "active:opacity-[0.85]" }, teal: { border: "border border-teal-500", color: "text-teal-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-teal-200", active: "active:opacity-[0.85]" }, cyan: { border: "border border-cyan-500", color: "text-cyan-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-cyan-200", active: "active:opacity-[0.85]" }, "light-blue": { border: "border border-light-blue-500", color: "text-light-blue-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-light-blue-200", active: "active:opacity-[0.85]" }, blue: { border: "border border-blue-500", color: "text-blue-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-blue-200", active: "active:opacity-[0.85]" }, indigo: { border: "border border-indigo-500", color: "text-indigo-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-indigo-200", active: "active:opacity-[0.85]" }, "deep-purple": { border: "border border-deep-purple-500", color: "text-deep-purple-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-deep-purple-200", active: "active:opacity-[0.85]" }, purple: { border: "border border-purple-500", color: "text-purple-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-purple-200", active: "active:opacity-[0.85]" }, pink: { border: "border border-pink-500", color: "text-pink-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-pink-200", active: "active:opacity-[0.85]" }, red: { border: "border border-red-500", color: "text-red-500", hover: "hover:opacity-75", focus: "focus:ring focus:ring-red-200", active: "active:opacity-[0.85]" } };
    var _default = buttonOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/button/buttonText.js
var require_buttonText = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/button/buttonText.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var buttonText = { white: { color: "text-white", hover: "hover:bg-white/10", active: "active:bg-white/30" }, black: { color: "text-gray-900", hover: "hover:bg-gray-900/10", active: "active:bg-gray-900/20" }, "blue-gray": { color: "text-blue-gray-500", hover: "hover:bg-blue-gray-500/10", active: "active:bg-blue-gray-500/30" }, gray: { color: "text-gray-900", hover: "hover:bg-gray-900/10", active: "active:bg-gray-900/20" }, brown: { color: "text-brown-500", hover: "hover:bg-brown-500/10", active: "active:bg-brown-500/30" }, "deep-orange": { color: "text-deep-orange-500", hover: "hover:bg-deep-orange-500/10", active: "active:bg-deep-orange-500/30" }, orange: { color: "text-orange-500", hover: "hover:bg-orange-500/10", active: "active:bg-orange-500/30" }, amber: { color: "text-amber-500", hover: "hover:bg-amber-500/10", active: "active:bg-amber-500/30" }, yellow: { color: "text-yellow-500", hover: "hover:bg-yellow-500/10", active: "active:bg-yellow-500/30" }, lime: { color: "text-lime-500", hover: "hover:bg-lime-500/10", active: "active:bg-lime-500/30" }, "light-green": { color: "text-light-green-500", hover: "hover:bg-light-green-500/10", active: "active:bg-light-green-500/30" }, green: { color: "text-green-500", hover: "hover:bg-green-500/10", active: "active:bg-green-500/30" }, teal: { color: "text-teal-500", hover: "hover:bg-teal-500/10", active: "active:bg-teal-500/30" }, cyan: { color: "text-cyan-500", hover: "hover:bg-cyan-500/10", active: "active:bg-cyan-500/30" }, "light-blue": { color: "text-light-blue-500", hover: "hover:bg-light-blue-500/10", active: "active:bg-light-blue-500/30" }, blue: { color: "text-blue-500", hover: "hover:bg-blue-500/10", active: "active:bg-blue-500/30" }, indigo: { color: "text-indigo-500", hover: "hover:bg-indigo-500/10", active: "active:bg-indigo-500/30" }, "deep-purple": { color: "text-deep-purple-500", hover: "hover:bg-deep-purple-500/10", active: "active:bg-deep-purple-500/30" }, purple: { color: "text-purple-500", hover: "hover:bg-purple-500/10", active: "active:bg-purple-500/30" }, pink: { color: "text-pink-500", hover: "hover:bg-pink-500/10", active: "active:bg-pink-500/30" }, red: { color: "text-red-500", hover: "hover:bg-red-500/10", active: "active:bg-red-500/30" } };
    var _default = buttonText;
  }
});

// node_modules/@material-tailwind/react/types/components/button.js
var require_button = __commonJS({
  "node_modules/@material-tailwind/react/types/components/button.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesFullWidth: function() {
      return propTypesFullWidth;
    }, propTypesRipple: function() {
      return propTypesRipple;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    }, propTypesLoading: function() {
      return propTypesLoading;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["filled", "outlined", "gradient", "text"];
    var propTypesSize = ["sm", "md", "lg"];
    var propTypesColor = ["white", "black"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesFullWidth = _propTypes.default.bool;
    var propTypesRipple = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
    var propTypesLoading = _propTypes.default.bool;
  }
});

// node_modules/@material-tailwind/react/theme/components/button/index.js
var require_button2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/button/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { button: function() {
      return button;
    }, default: function() {
      return _default;
    } });
    var _buttonFilled = _interopRequireDefault(require_buttonFilled());
    var _buttonGradient = _interopRequireDefault(require_buttonGradient());
    var _buttonOutlined = _interopRequireDefault(require_buttonOutlined());
    var _buttonText = _interopRequireDefault(require_buttonText());
    var _button = require_button();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var button = { defaultProps: { variant: "filled", size: "md", color: "gray", fullWidth: false, ripple: true, className: "" }, valid: { variants: _button.propTypesVariant, sizes: _button.propTypesSize, colors: _button.propTypesColor }, styles: { base: { initial: { verticalAlign: "align-middle", userSelect: "select-none", fontFamily: "font-sans", fontWeight: "font-bold", textAlign: "text-center", textTransform: "uppercase", transition: "transition-all", disabled: "disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none" }, fullWidth: { display: "block", width: "w-full" } }, sizes: { sm: { fontSize: "text-xs", py: "py-2", px: "px-4", borderRadius: "rounded-lg" }, md: { fontSize: "text-xs", py: "py-3", px: "px-6", borderRadius: "rounded-lg" }, lg: { fontSize: "text-sm", py: "py-3.5", px: "px-7", borderRadius: "rounded-lg" } }, variants: { filled: _buttonFilled.default, gradient: _buttonGradient.default, outlined: _buttonOutlined.default, text: _buttonText.default } } };
    var _default = button;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/cardFilled.js
var require_cardFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/cardFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var cardFilled = { transparent: { backgroud: "bg-transparent", color: "text-gray-700", shadow: "shadow-none" }, white: { backgroud: "bg-white", color: "text-gray-700" }, "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white", shadow: "shadow-blue-gray-500/40" }, gray: { backgroud: "bg-gray-900", color: "text-white", shadow: "shadow-gray-900/20" }, brown: { backgroud: "bg-brown-500", color: "text-white", shadow: "shadow-brown-500/40" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white", shadow: "shadow-deep-orange-500/40" }, orange: { backgroud: "bg-orange-500", color: "text-white", shadow: "shadow-orange-500/40" }, amber: { backgroud: "bg-amber-500", color: "text-gray-700", shadow: "shadow-amber-500/40" }, yellow: { backgroud: "bg-yellow-500", color: "text-gray-700", shadow: "shadow-yellow-500/40" }, lime: { backgroud: "bg-lime-500", color: "text-gray-700", shadow: "shadow-lime-500/40" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white", shadow: "shadow-light-green-500/40" }, green: { backgroud: "bg-green-500", color: "text-white", shadow: "shadow-green-500/40" }, teal: { backgroud: "bg-teal-500", color: "text-white", shadow: "shadow-teal-500/40" }, cyan: { backgroud: "bg-cyan-500", color: "text-white", shadow: "shadow-cyan-500/40" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white", shadow: "shadow-light-blue-500/40" }, blue: { backgroud: "bg-blue-500", color: "text-white", shadow: "shadow-blue-500/40" }, indigo: { backgroud: "bg-indigo-500", color: "text-white", shadow: "shadow-indigo-500/40" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white", shadow: "shadow-deep-purple-500/40" }, purple: { backgroud: "bg-purple-500", color: "text-white", shadow: "shadow-purple-500/40" }, pink: { backgroud: "bg-pink-500", color: "text-white", shadow: "shadow-pink-500/40" }, red: { backgroud: "bg-red-500", color: "text-white", shadow: "shadow-red-500/40" } };
    var _default = cardFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/cardGradient.js
var require_cardGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/cardGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var cardGradient = { transparent: { backgroud: "bg-transparent", color: "text-gray-700", shadow: "shadow-none" }, white: { backgroud: "bg-white", color: "text-gray-700" }, "blue-gray": { backgroud: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white", shadow: "shadow-blue-gray-500/40" }, gray: { backgroud: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white", shadow: "shadow-gray-900/20" }, brown: { backgroud: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white", shadow: "shadow-brown-500/40" }, "deep-orange": { backgroud: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white", shadow: "shadow-deep-orange-500/40" }, orange: { backgroud: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white", shadow: "shadow-orange-500/40" }, amber: { backgroud: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-gray-700", shadow: "shadow-amber-500/40" }, yellow: { backgroud: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-gray-700", shadow: "shadow-yellow-500/40" }, lime: { backgroud: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-gray-700", shadow: "shadow-lime-500/40" }, "light-green": { backgroud: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white", shadow: "shadow-light-green-500/40" }, green: { backgroud: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white", shadow: "shadow-green-500/40" }, teal: { backgroud: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white", shadow: "shadow-teal-500/40" }, cyan: { backgroud: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white", shadow: "shadow-cyan-500/40" }, "light-blue": { backgroud: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white", shadow: "shadow-light-blue-500/40" }, blue: { backgroud: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white", shadow: "shadow-blue-500/40" }, indigo: { backgroud: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white", shadow: "shadow-indigo-500/40" }, "deep-purple": { backgroud: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white", shadow: "shadow-deep-purple-500/40" }, purple: { backgroud: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white", shadow: "shadow-purple-500/40" }, pink: { backgroud: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white", shadow: "shadow-pink-500/40" }, red: { backgroud: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white", shadow: "shadow-red-500/40" } };
    var _default = cardGradient;
  }
});

// node_modules/@material-tailwind/react/types/components/card.js
var require_card = __commonJS({
  "node_modules/@material-tailwind/react/types/components/card.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesShadow: function() {
      return propTypesShadow;
    }, propTypesFloated: function() {
      return propTypesFloated;
    }, propTypesDivider: function() {
      return propTypesDivider;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["filled", "gradient"];
    var propTypesColor = ["transparent", "white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesShadow = _propTypes.default.bool;
    var propTypesFloated = _propTypes.default.bool;
    var propTypesDivider = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/index.js
var require_card2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _cardFilled = _interopRequireDefault(require_cardFilled());
    var _cardGradient = _interopRequireDefault(require_cardGradient());
    var _card = require_card();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var card = { defaultProps: { variant: "filled", color: "white", shadow: true, className: "" }, valid: { variants: _card.propTypesVariant, colors: _card.propTypesColor }, styles: { base: { initial: { position: "relative", display: "flex", flexDirection: "flex-col", backgroundClip: "bg-clip-border", borderRadius: "rounded-xl" }, shadow: { boxShadow: "shadow-md" } }, variants: { filled: _cardFilled.default, gradient: _cardGradient.default } } };
    var _default = card;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/cardBody.js
var require_cardBody = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/cardBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { cardBody: function() {
      return cardBody;
    }, default: function() {
      return _default;
    } });
    var cardBody = { defaultProps: { className: "" }, styles: { base: { p: "p-6" } } };
    var _default = cardBody;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/cardFooter.js
var require_cardFooter = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/cardFooter.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { cardFooter: function() {
      return cardFooter;
    }, default: function() {
      return _default;
    } });
    var cardFooter = { defaultProps: { className: "" }, styles: { base: { initial: { p: "p-6" }, divider: { borderWidth: "border-t", borderColor: "border-blue-gray-50" } } } };
    var _default = cardFooter;
  }
});

// node_modules/@material-tailwind/react/theme/components/card/cardHeader.js
var require_cardHeader = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/card/cardHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _cardFilled = _interopRequireDefault(require_cardFilled());
    var _cardGradient = _interopRequireDefault(require_cardGradient());
    var _card = require_card();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var cardHeader = { defaultProps: { variant: "filled", color: "white", shadow: true, floated: true, className: "" }, valid: { variants: _card.propTypesVariant, colors: _card.propTypesColor }, styles: { base: { initial: { position: "relative", backgroundClip: "bg-clip-border", mt: "mt-4", mx: "mx-4", borderRadius: "rounded-xl", overflow: "overflow-hidden" }, shadow: { boxShadow: "shadow-lg" }, floated: { mt: "-mt-6" } }, variants: { filled: _cardFilled.default, gradient: _cardGradient.default } } };
    var _default = cardHeader;
  }
});

// node_modules/@material-tailwind/react/theme/components/checkbox/checkboxColors.js
var require_checkboxColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/checkbox/checkboxColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var checkboxColors = { "blue-gray": { background: "checked:bg-blue-gray-500", border: "checked:border-blue-gray-500", before: "checked:before:bg-blue-gray-500" }, gray: { background: "checked:bg-gray-900", border: "checked:border-gray-900", before: "checked:before:bg-gray-900" }, brown: { background: "checked:bg-brown-500", border: "checked:border-brown-500", before: "checked:before:bg-brown-500" }, "deep-orange": { background: "checked:bg-deep-orange-500", border: "checked:border-deep-orange-500", before: "checked:before:bg-deep-orange-500" }, orange: { background: "checked:bg-orange-500", border: "checked:border-orange-500", before: "checked:before:bg-orange-500" }, amber: { background: "checked:bg-amber-500", border: "checked:border-amber-500", before: "checked:before:bg-amber-500" }, yellow: { background: "checked:bg-yellow-500", border: "checked:border-yellow-500", before: "checked:before:bg-yellow-500" }, lime: { background: "checked:bg-lime-500", border: "checked:border-lime-500", before: "checked:before:bg-lime-500" }, "light-green": { background: "checked:bg-light-green-500", border: "checked:border-light-green-500", before: "checked:before:bg-light-green-500" }, green: { background: "checked:bg-green-500", border: "checked:border-green-500", before: "checked:before:bg-green-500" }, teal: { background: "checked:bg-teal-500", border: "checked:border-teal-500", before: "checked:before:bg-teal-500" }, cyan: { background: "checked:bg-cyan-500", border: "checked:border-cyan-500", before: "checked:before:bg-cyan-500" }, "light-blue": { background: "checked:bg-light-blue-500", border: "checked:border-light-blue-500", before: "checked:before:bg-light-blue-500" }, blue: { background: "checked:bg-blue-500", border: "checked:border-blue-500", before: "checked:before:bg-blue-500" }, indigo: { background: "checked:bg-indigo-500", border: "checked:border-indigo-500", before: "checked:before:bg-indigo-500" }, "deep-purple": { background: "checked:bg-deep-purple-500", border: "checked:border-deep-purple-500", before: "checked:before:bg-deep-purple-500" }, purple: { background: "checked:bg-purple-500", border: "checked:border-purple-500", before: "checked:before:bg-purple-500" }, pink: { background: "checked:bg-pink-500", border: "checked:border-pink-500", before: "checked:before:bg-pink-500" }, red: { background: "checked:bg-red-500", border: "checked:border-red-500", before: "checked:before:bg-red-500" } };
    var _default = checkboxColors;
  }
});

// node_modules/@material-tailwind/react/types/components/checkbox.js
var require_checkbox = __commonJS({
  "node_modules/@material-tailwind/react/types/components/checkbox.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesColor: function() {
      return propTypesColor;
    }, propTypesLabel: function() {
      return propTypesLabel;
    }, propTypesIcon: function() {
      return propTypesIcon;
    }, propTypesRipple: function() {
      return propTypesRipple;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesDisabled: function() {
      return propTypesDisabled;
    }, propTypesObject: function() {
      return propTypesObject;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesColor = _generic.propTypesColors;
    var propTypesLabel = _propTypes.default.node;
    var propTypesIcon = _propTypes.default.node;
    var propTypesRipple = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesDisabled = _propTypes.default.bool;
    var propTypesObject = _propTypes.default.instanceOf(Object);
  }
});

// node_modules/@material-tailwind/react/theme/components/checkbox/index.js
var require_checkbox2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/checkbox/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { checkbox: function() {
      return checkbox;
    }, default: function() {
      return _default;
    } });
    var _checkboxColors = _interopRequireDefault(require_checkboxColors());
    var _checkbox = require_checkbox();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var checkbox = { defaultProps: { color: "gray", label: void 0, icon: void 0, ripple: true, className: "", disabled: false, containerProps: void 0, labelProps: void 0, iconProps: void 0 }, valid: { colors: _checkbox.propTypesColor }, styles: { base: { root: { display: "inline-flex", alignItems: "items-center" }, container: { position: "relative", display: "flex", alignItems: "items-center", cursor: "cursor-pointer", p: "p-3", borderRadius: "rounded-full" }, input: { peer: "peer", position: "relative", appearance: "appearance-none", width: "w-5", height: "h-5", borderWidth: "border", borderRadius: "rounded-md", borderColor: "border-blue-gray-200", cursor: "cursor-pointer", transition: "transition-all", before: { content: "before:content['']", display: "before:block", bg: "before:bg-blue-gray-500", width: "before:w-12", height: "before:h-12", borderRadius: "before:rounded-full", position: "before:absolute", top: "before:top-2/4", left: "before:left-2/4", transform: "before:-translate-y-2/4 before:-translate-x-2/4", opacity: "before:opacity-0 hover:before:opacity-10", transition: "before:transition-opacity" } }, label: { color: "text-gray-700", fontWeight: "font-light", userSelect: "select-none", cursor: "cursor-pointer", mt: "mt-px" }, icon: { color: "text-white", position: "absolute", top: "top-2/4", left: "left-2/4", translate: "-translate-y-2/4 -translate-x-2/4", pointerEvents: "pointer-events-none", opacity: "opacity-0 peer-checked:opacity-100", transition: "transition-opacity" }, disabled: { opacity: "opacity-50", pointerEvents: "pointer-events-none" } }, colors: _checkboxColors.default } };
    var _default = checkbox;
  }
});

// node_modules/@material-tailwind/react/theme/components/chip/chipFilled.js
var require_chipFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/chip/chipFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var chipFilled = { "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white" }, gray: { backgroud: "bg-gray-900", color: "text-white" }, brown: { backgroud: "bg-brown-500", color: "text-white" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white" }, orange: { backgroud: "bg-orange-500", color: "text-white" }, amber: { backgroud: "bg-amber-500", color: "text-black" }, yellow: { backgroud: "bg-yellow-500", color: "text-black" }, lime: { backgroud: "bg-lime-500", color: "text-black" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white" }, green: { backgroud: "bg-green-500", color: "text-white" }, teal: { backgroud: "bg-teal-500", color: "text-white" }, cyan: { backgroud: "bg-cyan-500", color: "text-white" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white" }, blue: { backgroud: "bg-blue-500", color: "text-white" }, indigo: { backgroud: "bg-indigo-500", color: "text-white" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white" }, purple: { backgroud: "bg-purple-500", color: "text-white" }, pink: { backgroud: "bg-pink-500", color: "text-white" }, red: { backgroud: "bg-red-500", color: "text-white" } };
    var _default = chipFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/chip/chipGradient.js
var require_chipGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/chip/chipGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var chipGradient = { "blue-gray": { backgroud: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white" }, gray: { backgroud: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white" }, brown: { backgroud: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white" }, "deep-orange": { backgroud: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white" }, orange: { backgroud: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white" }, amber: { backgroud: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black" }, yellow: { backgroud: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black" }, lime: { backgroud: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black" }, "light-green": { backgroud: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white" }, green: { backgroud: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white" }, teal: { backgroud: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white" }, cyan: { backgroud: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white" }, "light-blue": { backgroud: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white" }, blue: { backgroud: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white" }, indigo: { backgroud: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white" }, "deep-purple": { backgroud: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white" }, purple: { backgroud: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white" }, pink: { backgroud: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white" }, red: { backgroud: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white" } };
    var _default = chipGradient;
  }
});

// node_modules/@material-tailwind/react/theme/components/chip/chipOutlined.js
var require_chipOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/chip/chipOutlined.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var chipOutlined = { "blue-gray": { border: "border border-blue-gray-500", color: "text-blue-gray-700" }, gray: { border: "border border-gray-900", color: "text-gray-700" }, brown: { border: "border border-brown-500", color: "text-brown-700" }, "deep-orange": { border: "border border-deep-orange-500", color: "text-deep-orange-700" }, orange: { border: "border border-orange-500", color: "text-orange-700" }, amber: { border: "border border-amber-500", color: "text-amber-700" }, yellow: { border: "border border-yellow-500", color: "text-yellow-700" }, lime: { border: "border border-lime-500", color: "text-lime-700" }, "light-green": { border: "border border-light-green-500", color: "text-light-green-700" }, green: { border: "border border-green-500", color: "text-green-700" }, teal: { border: "border border-teal-500", color: "text-teal-700" }, cyan: { border: "border border-cyan-500", color: "text-cyan-700" }, "light-blue": { border: "border border-light-blue-500", color: "text-light-blue-700" }, blue: { border: "border border-blue-500", color: "text-blue-700" }, indigo: { border: "border border-indigo-500", color: "text-indigo-700" }, "deep-purple": { border: "border border-deep-purple-500", color: "text-deep-purple-700" }, purple: { border: "border border-purple-500", color: "text-purple-700" }, pink: { border: "border border-pink-500", color: "text-pink-700" }, red: { border: "border border-red-500", color: "text-red-700" } };
    var _default = chipOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/chip/chipGhost.js
var require_chipGhost = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/chip/chipGhost.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var chipGhost = { "blue-gray": { backgroud: "bg-blue-gray-500/20", color: "text-blue-gray-900" }, gray: { backgroud: "bg-gray-900/10", color: "text-gray-900" }, brown: { backgroud: "bg-brown-500/20", color: "text-brown-900" }, "deep-orange": { backgroud: "bg-deep-orange-500/20", color: "text-deep-orange-900" }, orange: { backgroud: "bg-orange-500/20", color: "text-orange-900" }, amber: { backgroud: "bg-amber-500/20", color: "text-amber-900" }, yellow: { backgroud: "bg-yellow-500/20", color: "text-yellow-900" }, lime: { backgroud: "bg-lime-500/20", color: "text-lime-900" }, "light-green": { backgroud: "bg-light-green-500/20", color: "text-light-green-900" }, green: { backgroud: "bg-green-500/20", color: "text-green-900" }, teal: { backgroud: "bg-teal-500/20", color: "text-teal-900" }, cyan: { backgroud: "bg-cyan-500/20", color: "text-cyan-900" }, "light-blue": { backgroud: "bg-light-blue-500/20", color: "text-light-blue-900" }, blue: { backgroud: "bg-blue-500/20", color: "text-blue-900" }, indigo: { backgroud: "bg-indigo-500/20", color: "text-indigo-900" }, "deep-purple": { backgroud: "bg-deep-purple-500/20", color: "text-deep-purple-900" }, purple: { backgroud: "bg-purple-500/20", color: "text-purple-900" }, pink: { backgroud: "bg-pink-500/20", color: "text-pink-900" }, red: { backgroud: "bg-red-500/20", color: "text-red-900" } };
    var _default = chipGhost;
  }
});

// node_modules/@material-tailwind/react/types/components/chip.js
var require_chip = __commonJS({
  "node_modules/@material-tailwind/react/types/components/chip.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesIcon: function() {
      return propTypesIcon;
    }, propTypesOpen: function() {
      return propTypesOpen;
    }, propTypesOnClose: function() {
      return propTypesOnClose;
    }, propTypesAction: function() {
      return propTypesAction;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesValue: function() {
      return propTypesValue;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesVariant = ["filled", "gradient", "outlined", "ghost"];
    var propTypesSize = ["sm", "md", "lg"];
    var propTypesColor = _generic.propTypesColors;
    var propTypesIcon = _propTypes.default.node;
    var propTypesOpen = _propTypes.default.bool;
    var propTypesOnClose = _propTypes.default.func;
    var propTypesAction = _propTypes.default.node;
    var propTypesAnimate = _generic.propTypesAnimation;
    var propTypesClassName = _propTypes.default.string;
    var propTypesValue = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/chip/index.js
var require_chip2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/chip/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { chip: function() {
      return chip;
    }, default: function() {
      return _default;
    } });
    var _chipFilled = _interopRequireDefault(require_chipFilled());
    var _chipGradient = _interopRequireDefault(require_chipGradient());
    var _chipOutlined = _interopRequireDefault(require_chipOutlined());
    var _chipGhost = _interopRequireDefault(require_chipGhost());
    var _chip = require_chip();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var chip = { defaultProps: { variant: "filled", size: "md", color: "gray", icon: void 0, open: true, onClose: void 0, action: void 0, animate: { unmount: {}, mount: {} }, className: "" }, valid: { variants: _chip.propTypesVariant, sizes: _chip.propTypesSize, colors: _chip.propTypesColor }, styles: { base: { chip: { position: "relative", display: "grid", placeItems: "items-center", fontFamily: "font-sans", fontWeight: "font-bold", textTransform: "uppercase", lineHeight: "leading-none", whiteSpace: "whitespace-nowrap", userSelect: "select-none" }, action: { position: "!absolute", top: "top-2/4", right: "right-1", translate: "-translate-y-2/4", mx: "mx-px", rounded: "rounded-md" }, icon: { position: "absolute", top: "top-2/4", translate: "-translate-y-2/4" } }, sizes: { sm: { chip: { py: "py-1", px: "px-2", fontSize: "text-xs", borderRadius: "rounded-md" }, action: { width: "w-4", height: "h-4" }, icon: { width: "w-4", height: "h-4", left: "left-1" } }, md: { chip: { py: "py-1.5", px: "px-3", fontSize: "text-xs", borderRadius: "rounded-lg" }, action: { width: "w-5", height: "h-5" }, icon: { width: "w-5", height: "h-5", left: "left-1.5" } }, lg: { chip: { py: "py-2", px: "px-4", fontSize: "text-xs", borderRadius: "rounded-lg" }, action: { width: "w-6", height: "h-6" }, icon: { width: "w-6", height: "h-6", left: "left-1.5" } } }, variants: { filled: _chipFilled.default, gradient: _chipGradient.default, outlined: _chipOutlined.default, ghost: _chipGhost.default } } };
    var _default = chip;
  }
});

// node_modules/@material-tailwind/react/types/components/dialog.js
var require_dialog = __commonJS({
  "node_modules/@material-tailwind/react/types/components/dialog.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesOpen: function() {
      return propTypesOpen;
    }, propTypesHandler: function() {
      return propTypesHandler;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesDismiss: function() {
      return propTypesDismiss;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    }, propTypesDivider: function() {
      return propTypesDivider;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesOpen = _propTypes.default.bool.isRequired;
    var propTypesHandler = _propTypes.default.func;
    var propTypesSize = ["xs", "sm", "md", "lg", "xl", "xxl"];
    var propTypesDismiss = _generic.propTypesDismissType;
    var propTypesAnimate = _generic.propTypesAnimation;
    var propTypesDivider = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/dialog/index.js
var require_dialog2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/dialog/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { dialog: function() {
      return dialog;
    }, default: function() {
      return _default;
    } });
    var _dialog = require_dialog();
    var dialog = { defaultProps: { size: "md", dismiss: {}, animate: { unmount: {}, mount: {} }, className: "" }, valid: { sizes: _dialog.propTypesSize }, styles: { base: { backdrop: { display: "grid", placeItems: "place-items-center", position: "fixed", top: 0, left: 0, width: "w-screen", height: "h-screen", backgroundColor: "bg-black", backgroundOpacity: "bg-opacity-60", backdropFilter: "backdrop-blur-sm" }, container: { position: "relative", bg: "bg-white", m: "m-4", borderRadius: "rounded-lg", boxShadow: "shadow-2xl", color: "text-blue-gray-500", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-light", lineHeight: "leading-relaxed" } }, sizes: { xs: { width: "w-full md:w-3/5 lg:w-2/5 2xl:w-1/4", minWidth: "min-w-[80%] md:min-w-[60%] lg:min-w-[40%] 2xl:min-w-[25%]", maxWidth: "max-w-[80%] md:max-w-[60%] lg:max-w-[40%] 2xl:max-w-[25%]" }, sm: { width: "w-full md:w-2/3 lg:w-2/4 2xl:w-1/3", minWidth: "min-w-[80%] md:min-w-[66.666667%] lg:min-w-[50%] 2xl:min-w-[33.333333%]", maxWidth: "max-w-[80%] md:max-w-[66.666667%] lg:max-w-[50%] 2xl:max-w-[33.333333%]" }, md: { width: "w-full md:w-3/4 lg:w-3/5 2xl:w-2/5", minWidth: "min-w-[90%] md:min-w-[75%] lg:min-w-[60%] 2xl:min-w-[40%]", maxWidth: "max-w-[90%] md:max-w-[75%] lg:max-w-[60%] 2xl:max-w-[40%]" }, lg: { width: "w-full md:w-5/6 lg:w-3/4 2xl:w-3/5", minWidth: "min-w-[90%] md:min-w-[83.333333%] lg:min-w-[75%] 2xl:min-w-[60%]", maxWidth: "max-w-[90%] md:max-w-[83.333333%] lg:max-w-[75%] 2xl:max-w-[60%]" }, xl: { width: "w-full md:w-5/6 2xl:w-3/4", minWidth: "min-w-[95%] md:min-w-[83.333333%] 2xl:min-w-[75%]", maxWidth: "max-w-[95%] md:max-w-[83.333333%] 2xl:max-w-[75%]" }, xxl: { display: "flex", flexDirection: "flex-col", width: "w-screen", minWidth: "min-w-[100vw]", maxWidth: "max-w-[100vw]", height: "h-screen", minHeight: "min-h-[100vh]", maxHeight: "max-h-[100vh]", m: "m-0", borderRadius: "rounded-none" } } } };
    var _default = dialog;
  }
});

// node_modules/@material-tailwind/react/theme/components/dialog/dialogBody.js
var require_dialogBody = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/dialog/dialogBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { dialogBody: function() {
      return dialogBody;
    }, default: function() {
      return _default;
    } });
    var dialogBody = { defaultProps: { className: "", divider: false }, styles: { base: { initial: { position: "relative", p: "p-4", color: "text-blue-gray-500", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-light", lineHeight: "leading-relaxed" }, divider: { borderTop: "border-t", borderTopColor: "border-t-blue-gray-100", borderBottom: "border-b", borderBottomColor: "border-b-blue-gray-100" } } } };
    var _default = dialogBody;
  }
});

// node_modules/@material-tailwind/react/theme/components/dialog/dialogFooter.js
var require_dialogFooter = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/dialog/dialogFooter.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { dialogFooter: function() {
      return dialogFooter;
    }, default: function() {
      return _default;
    } });
    var dialogFooter = { defaultProps: { className: "" }, styles: { base: { display: "flex", alignItems: "items-center", justifyContent: "justify-end", flexShrink: "shrink-0", flexWrap: "flex-wrap", p: "p-4", color: "text-blue-gray-500" } } };
    var _default = dialogFooter;
  }
});

// node_modules/@material-tailwind/react/theme/components/dialog/dialogHeader.js
var require_dialogHeader = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/dialog/dialogHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { dialogHeader: function() {
      return dialogHeader;
    }, default: function() {
      return _default;
    } });
    var dialogHeader = { defaultProps: { className: "" }, styles: { base: { display: "flex", alignItems: "items-center", flexShrink: "shrink-0", p: "p-4", color: "text-blue-gray-900", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-2xl", fontWeight: "font-semibold", lineHeight: "leading-snug" } } };
    var _default = dialogHeader;
  }
});

// node_modules/@material-tailwind/react/theme/components/iconButton/index.js
var require_iconButton = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/iconButton/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { iconButton: function() {
      return iconButton;
    }, default: function() {
      return _default;
    } });
    var _buttonFilled = _interopRequireDefault(require_buttonFilled());
    var _buttonGradient = _interopRequireDefault(require_buttonGradient());
    var _buttonOutlined = _interopRequireDefault(require_buttonOutlined());
    var _buttonText = _interopRequireDefault(require_buttonText());
    var _button = require_button();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var iconButton = { defaultProps: { variant: "filled", size: "md", color: "gray", fullWidth: false, ripple: true, className: "" }, valid: { variants: _button.propTypesVariant, sizes: _button.propTypesSize, colors: _button.propTypesColor }, styles: { base: { position: "relative", verticalAlign: "align-middle", userSelect: "select-none", fontFamily: "font-sans", fontWeight: "font-medium", textAlign: "text-center", textTransform: "uppercase", transition: "transition-all", disabled: "disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none" }, sizes: { sm: { width: "w-8", maxWidth: "max-w-[32px]", height: "h-8", maxHeight: "max-h-[32px]", borderRadius: "rounded-lg", fontSize: "text-xs" }, md: { width: "w-10", maxWidth: "max-w-[40px]", height: "h-10", maxHeight: "max-h-[40px]", borderRadius: "rounded-lg", fontSize: "text-xs" }, lg: { width: "w-12", maxWidth: "max-w-[48px]", height: "h-12", maxHeight: "max-h-[48px]", borderRadius: "rounded-lg", fontSize: "text-sm" } }, variants: { filled: _buttonFilled.default, gradient: _buttonGradient.default, outlined: _buttonOutlined.default, text: _buttonText.default } } };
    var _default = iconButton;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedLabel.js
var require_inputOutlinedLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputOutlinedLabel = { position: "-top-1.5", fontSize: "peer-placeholder-shown:text-sm", floated: { fontSize: "text-[11px] peer-focus:text-[11px]" }, before: { content: "before:content[' ']", display: "before:block", boxSizing: "before:box-border", width: "before:w-2.5", height: "before:h-1.5", mt: "before:mt-[6.5px]", mr: "before:mr-1", borderColor: "peer-placeholder-shown:before:border-transparent", borderRadius: "before:rounded-tl-md", floated: { bt: "before:border-t peer-focus:before:border-t-2", bl: "before:border-l peer-focus:before:border-l-2" }, pointerEvents: "before:pointer-events-none", transition: "before:transition-all", disabled: "peer-disabled:before:border-transparent" }, after: { content: "after:content[' ']", display: "after:block", flexGrow: "after:flex-grow", boxSizing: "after:box-border", width: "after:w-2.5", height: "after:h-1.5", mt: "after:mt-[6.5px]", ml: "after:ml-1", borderColor: "peer-placeholder-shown:after:border-transparent", borderRadius: "after:rounded-tr-md", floated: { bt: "after:border-t peer-focus:after:border-t-2", br: "after:border-r peer-focus:after:border-r-2" }, pointerEvents: "after:pointer-events-none", transition: "after:transition-all", disabled: "peer-disabled:after:border-transparent" } };
    var _default = inputOutlinedLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedColors.js
var require_inputOutlinedColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputOutlinedColors = { black: { color: "text-black", borderColor: "border-black", borderColorFocused: "focus:border-black" }, white: { color: "!text-white", borderColor: "border-white", borderColorFocused: "focus:border-white" }, "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-500" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-900" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = inputOutlinedColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedLabelColors.js
var require_inputOutlinedLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputOutlined/inputOutlinedLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputOutlinedLabelColors = { black: { color: "!text-black peer-focus:text-black", before: "before:border-black peer-focus:before:!border-black", after: "after:border-black peer-focus:after:!border-black" }, white: { color: "!text-white peer-focus:text-white", before: "before:border-white peer-focus:before:!border-white", after: "after:border-white peer-focus:after:!border-white" }, "blue-gray": { color: "text-blue-gray-400 peer-focus:text-blue-gray-500", before: "before:border-blue-gray-200 peer-focus:before:!border-blue-gray-500", after: "after:border-blue-gray-200 peer-focus:after:!border-blue-gray-500" }, gray: { color: "text-gray-500 peer-focus:text-gray-900", before: "before:border-blue-gray-200 peer-focus:before:!border-gray-900", after: "after:border-blue-gray-200 peer-focus:after:!border-gray-900" }, brown: { color: "text-blue-gray-400 peer-focus:text-brown-500", before: "before:border-blue-gray-200 peer-focus:before:!border-brown-500", after: "after:border-blue-gray-200 peer-focus:after:!border-brown-500" }, "deep-orange": { color: "text-blue-gray-400 peer-focus:text-deep-orange-500", before: "before:border-blue-gray-200 peer-focus:before:!border-deep-orange-500", after: "after:border-blue-gray-200 peer-focus:after:!border-deep-orange-500" }, orange: { color: "text-blue-gray-400 peer-focus:text-orange-500", before: "before:border-blue-gray-200 peer-focus:before:!border-orange-500", after: "after:border-blue-gray-200 peer-focus:after:!border-orange-500" }, amber: { color: "text-blue-gray-400 peer-focus:text-amber-500", before: "before:border-blue-gray-200 peer-focus:before:!border-amber-500", after: "after:border-blue-gray-200 peer-focus:after:!border-amber-500" }, yellow: { color: "text-blue-gray-400 peer-focus:text-yellow-500", before: "before:border-blue-gray-200 peer-focus:before:!border-yellow-500", after: "after:border-blue-gray-200 peer-focus:after:!border-yellow-500" }, lime: { color: "text-blue-gray-400 peer-focus:text-lime-500", before: "before:border-blue-gray-200 peer-focus:before:!border-lime-500", after: "after:border-blue-gray-200 peer-focus:after:!border-lime-500" }, "light-green": { color: "text-blue-gray-400 peer-focus:text-light-green-500", before: "before:border-blue-gray-200 peer-focus:before:!border-light-green-500", after: "after:border-blue-gray-200 peer-focus:after:!border-light-green-500" }, green: { color: "text-blue-gray-400 peer-focus:text-green-500", before: "before:border-blue-gray-200 peer-focus:before:!border-green-500", after: "after:border-blue-gray-200 peer-focus:after:!border-green-500" }, teal: { color: "text-blue-gray-400 peer-focus:text-teal-500", before: "before:border-blue-gray-200 peer-focus:before:!border-teal-500", after: "after:border-blue-gray-200 peer-focus:after:!border-teal-500" }, cyan: { color: "text-blue-gray-400 peer-focus:text-cyan-500", before: "before:border-blue-gray-200 peer-focus:before:!border-cyan-500", after: "after:border-blue-gray-200 peer-focus:after:!border-cyan-500" }, "light-blue": { color: "text-blue-gray-400 peer-focus:text-light-blue-500", before: "before:border-blue-gray-200 peer-focus:before:!border-light-blue-500", after: "after:border-blue-gray-200 peer-focus:after:!border-light-blue-500" }, blue: { color: "text-blue-gray-400 peer-focus:text-blue-500", before: "before:border-blue-gray-200 peer-focus:before:!border-blue-500", after: "after:border-blue-gray-200 peer-focus:after:!border-blue-500" }, indigo: { color: "text-blue-gray-400 peer-focus:text-indigo-500", before: "before:border-blue-gray-200 peer-focus:before:!border-indigo-500", after: "after:border-blue-gray-200 peer-focus:after:!border-indigo-500" }, "deep-purple": { color: "text-blue-gray-400 peer-focus:text-deep-purple-500", before: "before:border-blue-gray-200 peer-focus:before:!border-deep-purple-500", after: "after:border-blue-gray-200 peer-focus:after:!border-deep-purple-500" }, purple: { color: "text-blue-gray-400 peer-focus:text-purple-500", before: "before:border-blue-gray-200 peer-focus:before:!border-purple-500", after: "after:border-blue-gray-200 peer-focus:after:!border-purple-500" }, pink: { color: "text-blue-gray-400 peer-focus:text-pink-500", before: "before:border-blue-gray-200 peer-focus:before:!border-pink-500", after: "after:border-blue-gray-200 peer-focus:after:!border-pink-500" }, red: { color: "text-blue-gray-400 peer-focus:text-red-500", before: "before:border-blue-gray-200 peer-focus:before:!border-red-500", after: "after:border-blue-gray-200 peer-focus:after:!border-red-500" } };
    var _default = inputOutlinedLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputOutlined/index.js
var require_inputOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputOutlined/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _inputOutlinedLabel = _interopRequireDefault(require_inputOutlinedLabel());
    var _inputOutlinedColors = _interopRequireDefault(require_inputOutlinedColors());
    var _inputOutlinedLabelColors = _interopRequireDefault(require_inputOutlinedLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var inputOutlined = { base: { input: { borderWidth: "placeholder-shown:border", borderColor: "placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200", floated: { borderWidth: "border focus:border-2", borderColor: "border-t-transparent focus:border-t-transparent" }, placeholder: "placeholder:opacity-0 focus:placeholder:opacity-100" }, inputWithIcon: { pr: "!pr-9" }, icon: { top: "top-2/4", right: "right-3", transform: "-translate-y-2/4" }, label: _inputOutlinedLabel.default }, sizes: { md: { container: { height: "h-10" }, input: { fontSize: "text-sm", px: "px-3", py: "py-2.5", borderRadius: "rounded-[7px]" }, label: { lineHeight: "peer-placeholder-shown:leading-[3.75]" }, icon: { width: "w-5", height: "h-5" } }, lg: { container: { height: "h-11" }, input: { fontSize: "text-sm", px: "px-3", py: "py-3", borderRadius: "rounded-md" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.1]" }, icon: { width: "w-6", height: "h-6" } } }, colors: { input: _inputOutlinedColors.default, label: _inputOutlinedLabelColors.default }, error: { input: { borderColor: "border-red-500 placeholder-shown:border-t-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", before: "before:border-red-500 peer-focus:before:border-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { input: { borderColor: "border-green-500 placeholder-shown:border-t-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", before: "before:border-green-500 peer-focus:before:border-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { input: { borderTop: "!border-t-transparent" }, label: { fontSize: "!text-[11px]", lineHeight: "!leading-tight", borderColor: "before:!border-blue-gray-200 after:!border-blue-gray-200" } } };
    var _default = inputOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardLabel.js
var require_inputStandardLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStandardLabel = { position: "-top-1.5", fontSize: "peer-placeholder-shown:text-sm", floated: { fontSize: "text-[11px] peer-focus:text-[11px]" }, after: { content: "after:content['']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-1.5", left: "left-0", borderWidth: "after:border-b-2", scale: "after:scale-x-0", floated: { scale: "peer-focus:after:scale-x-100" }, transition: "after:transition-transform after:duration-300" } };
    var _default = inputStandardLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardColors.js
var require_inputStandardColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStandardColors = { black: { color: "text-black", borderColor: "border-black", borderColorFocused: "focus:border-black" }, white: { color: "!text-white", borderColor: "border-white", borderColorFocused: "focus:border-white" }, "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-900" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-500" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = inputStandardColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardLabelColors.js
var require_inputStandardLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStandard/inputStandardLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStandardLabelColors = { black: { color: "!text-black peer-focus:text-black", after: "after:border-black peer-focus:after:border-black" }, white: { color: "!text-white peer-focus:text-white", after: "after:border-white peer-focus:after:border-white" }, "blue-gray": { color: "text-blue-gray-500 peer-focus:text-blue-gray-500", after: "after:border-blue-gray-500 peer-focus:after:border-blue-gray-500" }, gray: { color: "text-gray-500 peer-focus:text-gray-900", after: "after:border-gray-500 peer-focus:after:border-gray-900" }, brown: { color: "text-blue-gray-500 peer-focus:text-brown-500", after: "after:border-brown-500 peer-focus:after:border-brown-500" }, "deep-orange": { color: "text-blue-gray-500 peer-focus:text-deep-orange-500", after: "after:border-deep-orange-500 peer-focus:after:border-deep-orange-500" }, orange: { color: "text-blue-gray-500 peer-focus:text-orange-500", after: "after:border-orange-500 peer-focus:after:border-orange-500" }, amber: { color: "text-blue-gray-500 peer-focus:text-amber-500", after: "after:border-amber-500 peer-focus:after:border-amber-500" }, yellow: { color: "text-blue-gray-500 peer-focus:text-yellow-500", after: "after:border-yellow-500 peer-focus:after:border-yellow-500" }, lime: { color: "text-blue-gray-500 peer-focus:text-lime-500", after: "after:border-lime-500 peer-focus:after:border-lime-500" }, "light-green": { color: "text-blue-gray-500 peer-focus:text-light-green-500", after: "after:border-light-green-500 peer-focus:after:border-light-green-500" }, green: { color: "text-blue-gray-500 peer-focus:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" }, teal: { color: "text-blue-gray-500 peer-focus:text-teal-500", after: "after:border-teal-500 peer-focus:after:border-teal-500" }, cyan: { color: "text-blue-gray-500 peer-focus:text-cyan-500", after: "after:border-cyan-500 peer-focus:after:border-cyan-500" }, "light-blue": { color: "text-blue-gray-500 peer-focus:text-light-blue-500", after: "after:border-light-blue-500 peer-focus:after:border-light-blue-500" }, blue: { color: "text-blue-gray-500 peer-focus:text-blue-500", after: "after:border-blue-500 peer-focus:after:border-blue-500" }, indigo: { color: "text-blue-gray-500 peer-focus:text-indigo-500", after: "after:border-indigo-500 peer-focus:after:border-indigo-500" }, "deep-purple": { color: "text-blue-gray-500 peer-focus:text-deep-purple-500", after: "after:border-deep-purple-500 peer-focus:after:border-deep-purple-500" }, purple: { color: "text-blue-gray-500 peer-focus:text-purple-500", after: "after:border-purple-500 peer-focus:after:border-purple-500" }, pink: { color: "text-blue-gray-500 peer-focus:text-pink-500", after: "after:border-pink-500 peer-focus:after:border-pink-500" }, red: { color: "text-blue-gray-500 peer-focus:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } };
    var _default = inputStandardLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStandard/index.js
var require_inputStandard = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStandard/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _inputStandardLabel = _interopRequireDefault(require_inputStandardLabel());
    var _inputStandardColors = _interopRequireDefault(require_inputStandardColors());
    var _inputStandardLabelColors = _interopRequireDefault(require_inputStandardLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var inputStandard = { base: { input: { borderWidth: "border-b", borderColor: "placeholder-shown:border-blue-gray-200", placeholder: "placeholder:opacity-0 focus:placeholder:opacity-100" }, inputWithIcon: { pr: "!pr-7" }, icon: { top: "top-2/4", right: "right-0", transform: "-translate-y-1/4" }, label: _inputStandardLabel.default }, sizes: { md: { container: { height: "h-11" }, input: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.25]" }, icon: { width: "w-5", height: "h-5" } }, lg: { container: { height: "h-12" }, input: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.875]" }, icon: { width: "w-6", height: "h-6" } } }, colors: { input: _inputStandardColors.default, label: _inputStandardLabelColors.default }, error: { input: { borderColor: "border-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { input: { borderColor: "border-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { input: {}, label: { fontSize: "!text-[11px]", lineHeight: "!leading-tight" } } };
    var _default = inputStandard;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticLabel.js
var require_inputStaticLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStaticLabel = { position: "-top-2.5", fontSize: "text-sm peer-focus:text-sm", after: { content: "after:content[' ']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-2.5", left: "left-0", borderWidth: "after:border-b-2", scale: "after:scale-x-0", floated: { scale: "peer-focus:after:scale-x-100" }, transition: "after:transition-transform after:duration-300" } };
    var _default = inputStaticLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticColors.js
var require_inputStaticColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStaticColors = { black: { color: "text-black", borderColor: "border-black", borderColorFocused: "focus:border-black" }, white: { color: "!text-white", borderColor: "border-white", borderColorFocused: "focus:border-white" }, "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-500" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-900" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = inputStaticColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticLabelColors.js
var require_inputStaticLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStatic/inputStaticLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var inputStaticLabelColors = { black: { color: "!text-black peer-focus:black", after: "after:border-black peer-focus:after:border-black" }, white: { color: "!text-white peer-focus:white", after: "after:border-white peer-focus:after:border-white" }, "blue-gray": { color: "text-blue-gray-500 peer-focus:text-blue-gray-500", after: "after:border-blue-gray-500 peer-focus:after:border-blue-gray-500" }, gray: { color: "text-gray-500 peer-focus:text-gray-900", after: "after:border-gray-500 peer-focus:after:border-gray-900" }, brown: { color: "text-blue-gray-500 peer-focus:text-brown-500", after: "after:border-brown-500 peer-focus:after:border-brown-500" }, "deep-orange": { color: "text-blue-gray-500 peer-focus:text-deep-orange-500", after: "after:border-deep-orange-500 peer-focus:after:border-deep-orange-500" }, orange: { color: "text-blue-gray-500 peer-focus:text-orange-500", after: "after:border-orange-500 peer-focus:after:border-orange-500" }, amber: { color: "text-blue-gray-500 peer-focus:text-amber-500", after: "after:border-amber-500 peer-focus:after:border-amber-500" }, yellow: { color: "text-blue-gray-500 peer-focus:text-yellow-500", after: "after:border-yellow-500 peer-focus:after:border-yellow-500" }, lime: { color: "text-blue-gray-500 peer-focus:text-lime-500", after: "after:border-lime-500 peer-focus:after:border-lime-500" }, "light-green": { color: "text-blue-gray-500 peer-focus:text-light-green-500", after: "after:border-light-green-500 peer-focus:after:border-light-green-500" }, green: { color: "text-blue-gray-500 peer-focus:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" }, teal: { color: "text-blue-gray-500 peer-focus:text-teal-500", after: "after:border-teal-500 peer-focus:after:border-teal-500" }, cyan: { color: "text-blue-gray-500 peer-focus:text-cyan-500", after: "after:border-cyan-500 peer-focus:after:border-cyan-500" }, "light-blue": { color: "text-blue-gray-500 peer-focus:text-light-blue-500", after: "after:border-light-blue-500 peer-focus:after:border-light-blue-500" }, blue: { color: "text-blue-gray-500 peer-focus:text-blue-500", after: "after:border-blue-500 peer-focus:after:border-blue-500" }, indigo: { color: "text-blue-gray-500 peer-focus:text-indigo-500", after: "after:border-indigo-500 peer-focus:after:border-indigo-500" }, "deep-purple": { color: "text-blue-gray-500 peer-focus:text-deep-purple-500", after: "after:border-deep-purple-500 peer-focus:after:border-deep-purple-500" }, purple: { color: "text-blue-gray-500 peer-focus:text-purple-500", after: "after:border-purple-500 peer-focus:after:border-purple-500" }, pink: { color: "text-blue-gray-500 peer-focus:text-pink-500", after: "after:border-pink-500 peer-focus:after:border-pink-500" }, red: { color: "text-blue-gray-500 peer-focus:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } };
    var _default = inputStaticLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/inputStatic/index.js
var require_inputStatic = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/inputStatic/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _inputStaticLabel = _interopRequireDefault(require_inputStaticLabel());
    var _inputStaticColors = _interopRequireDefault(require_inputStaticColors());
    var _inputStaticLabelColors = _interopRequireDefault(require_inputStaticLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var inputStatic = { base: { input: { borderWidth: "border-b", borderColor: "placeholder-shown:border-blue-gray-200" }, inputWithIcon: { pr: "!pr-7" }, icon: { top: "top-2/4", right: "right-0", transform: "-translate-y-1/4" }, label: _inputStaticLabel.default }, sizes: { md: { container: { height: "h-11" }, input: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5" }, label: { lineHeight: "peer-placeholder-shown:leading-tight" }, icon: { width: "w-5", height: "h-5" } }, lg: { container: { height: "h-12" }, input: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { lineHeight: "peer-placeholder-shown:leading-tight" }, icon: { width: "w-6", height: "h-6" } } }, colors: { input: _inputStaticColors.default, label: _inputStaticLabelColors.default }, error: { input: { borderColor: "border-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { input: { borderColor: "border-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { input: {}, label: {} } };
    var _default = inputStatic;
  }
});

// node_modules/@material-tailwind/react/types/components/input.js
var require_input = __commonJS({
  "node_modules/@material-tailwind/react/types/components/input.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesLabel: function() {
      return propTypesLabel;
    }, propTypesError: function() {
      return propTypesError;
    }, propTypesSuccess: function() {
      return propTypesSuccess;
    }, propTypesIcon: function() {
      return propTypesIcon;
    }, propTypesResize: function() {
      return propTypesResize;
    }, propTypesLabelProps: function() {
      return propTypesLabelProps;
    }, propTypesContainerProps: function() {
      return propTypesContainerProps;
    }, propTypesShrink: function() {
      return propTypesShrink;
    }, propTypesClassName: function() {
      return propTypesClassName;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["standard", "outlined", "static"];
    var propTypesSize = ["md", "lg"];
    var propTypesColor = ["black", "white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesLabel = _propTypes.default.string;
    var propTypesError = _propTypes.default.bool;
    var propTypesSuccess = _propTypes.default.bool;
    var propTypesIcon = _propTypes.default.node;
    var propTypesResize = _propTypes.default.bool;
    var propTypesLabelProps = _propTypes.default.instanceOf(Object);
    var propTypesContainerProps = _propTypes.default.instanceOf(Object);
    var propTypesShrink = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
  }
});

// node_modules/@material-tailwind/react/theme/components/input/index.js
var require_input2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/input/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { input: function() {
      return input;
    }, default: function() {
      return _default;
    } });
    var _inputOutlined = _interopRequireDefault(require_inputOutlined());
    var _inputStandard = _interopRequireDefault(require_inputStandard());
    var _inputStatic = _interopRequireDefault(require_inputStatic());
    var _input = require_input();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var input = { defaultProps: { variant: "outlined", size: "md", color: "gray", label: "", error: false, success: false, icon: void 0, labelProps: void 0, containerProps: void 0, shrink: false, className: "" }, valid: { variants: _input.propTypesVariant, sizes: _input.propTypesSize, colors: _input.propTypesColor }, styles: { base: { container: { position: "relative", width: "w-full", minWidth: "min-w-[200px]" }, input: { peer: "peer", width: "w-full", height: "h-full", bg: "bg-transparent", color: "text-blue-gray-700", fontFamily: "font-sans", fontWeight: "font-normal", outline: "outline outline-0 focus:outline-0", disabled: "disabled:bg-blue-gray-50 disabled:border-0 disabled:cursor-not-allowed", transition: "transition-all" }, label: { display: "flex", width: "w-full", height: "h-full", userSelect: "select-none", pointerEvents: "pointer-events-none", position: "absolute", left: "left-0", fontWeight: "font-normal", overflow: "!overflow-visible", textOverflow: "truncate", color: "peer-placeholder-shown:text-blue-gray-500", lineHeight: "leading-tight peer-focus:leading-tight", disabled: "peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500", transition: "transition-all" }, icon: { display: "grid", placeItems: "place-items-center", position: "absolute", color: "text-blue-gray-500" }, asterisk: { display: "inline-block", color: "text-red-500", ml: "ml-0.5" } }, variants: { outlined: _inputOutlined.default, standard: _inputStandard.default, static: _inputStatic.default } } };
    var _default = input;
  }
});

// node_modules/@material-tailwind/react/theme/components/menu/index.js
var require_menu = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/menu/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { menu: function() {
      return menu;
    }, default: function() {
      return _default;
    } });
    var menu = { defaultProps: { placement: "bottom", offset: 5, dismiss: { itemPress: true }, animate: { unmount: {}, mount: {} }, lockScroll: false }, styles: { base: { menu: { bg: "bg-white", minWidth: "min-w-[180px]", p: "p-3", border: "border border-blue-gray-50", borderRadius: "rounded-md", boxShadow: "shadow-lg shadow-blue-gray-500/10", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-normal", color: "text-blue-gray-500", overflow: "overflow-auto", outline: "focus:outline-none", zIndex: "z-[999]" }, item: { initial: { display: "block", width: "w-full", pt: "pt-[9px]", pb: "pb-2", px: "px-3", borderRadius: "rounded-md", textAlign: "text-start", lightHeight: "leading-tight", cursor: "cursor-pointer", userSelect: "select-none", transition: "transition-all", bg: "hover:bg-blue-gray-50 hover:bg-opacity-80 focus:bg-blue-gray-50 focus:bg-opacity-80 active:bg-blue-gray-50 active:bg-opacity-80", color: "hover:text-blue-gray-900 focus:text-blue-gray-900 active:text-blue-gray-900", outline: "outline-none" }, disabled: { opacity: "opacity-50", cursor: "cursor-not-allowed", pointerEvents: "pointer-events-none", userSelect: "select-none", bg: "hover:bg-transparent focus:bg-transparent active:bg-transparent", color: "hover:text-blue-gray-500 focus:text-blue-gray-500 active:text-blue-gray-500" } } } } };
    var _default = menu;
  }
});

// node_modules/@material-tailwind/react/theme/components/navbar/navbarFilled.js
var require_navbarFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/navbar/navbarFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var navbarFilled = { transparent: { background: "bg-transparent", color: "text-white", boxShadow: "shadow-none" }, white: { background: "bg-white", color: "text-white" }, "blue-gray": { background: "bg-blue-gray-500", color: "text-white" }, gray: { background: "bg-gray-500", color: "text-white" }, brown: { background: "bg-brown-500", color: "text-white" }, "deep-orange": { background: "bg-deep-orange-500", color: "text-white" }, orange: { background: "bg-orange-500", color: "text-white" }, amber: { background: "bg-amber-500", color: "text-black" }, yellow: { background: "bg-yellow-500", color: "text-black" }, lime: { background: "bg-lime-500", color: "text-black" }, "light-green": { background: "bg-light-green-500", color: "text-white" }, green: { background: "bg-green-500", color: "text-white" }, teal: { background: "bg-teal-500", color: "text-white" }, cyan: { background: "bg-cyan-500", color: "text-white" }, "light-blue": { background: "bg-light-blue-500", color: "text-white" }, blue: { background: "bg-blue-500", color: "text-white" }, indigo: { background: "bg-indigo-500", color: "text-white" }, "deep-purple": { background: "bg-deep-purple-500", color: "text-white" }, purple: { background: "bg-purple-500", color: "text-white" }, pink: { background: "bg-pink-500", color: "text-white" }, red: { background: "bg-red-500", color: "text-white" } };
    var _default = navbarFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/navbar/navbarGradient.js
var require_navbarGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/navbar/navbarGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var navbarGradient = { transparent: { background: "bg-transparent", color: "text-blue-gray-900", boxShadow: "shadow-none" }, white: { background: "bg-white", color: "text-blue-gray-900" }, "blue-gray": { background: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white" }, gray: { background: "bg-gradient-to-tr from-gray-600 to-gray-400", color: "text-white" }, brown: { background: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white" }, "deep-orange": { background: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white" }, orange: { background: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white" }, amber: { background: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black" }, yellow: { background: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black" }, lime: { background: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black" }, "light-green": { background: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white" }, green: { background: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white" }, teal: { background: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white" }, cyan: { background: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white" }, "light-blue": { background: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white" }, blue: { background: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white" }, indigo: { background: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white" }, "deep-purple": { background: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white" }, purple: { background: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white" }, pink: { background: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white" }, red: { background: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white" } };
    var _default = navbarGradient;
  }
});

// node_modules/@material-tailwind/react/types/components/navbar.js
var require_navbar = __commonJS({
  "node_modules/@material-tailwind/react/types/components/navbar.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesShadow: function() {
      return propTypesShadow;
    }, propTypesBlurred: function() {
      return propTypesBlurred;
    }, propTypesFullWidth: function() {
      return propTypesFullWidth;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    }, propTypesOpen: function() {
      return propTypesOpen;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["filled", "gradient"];
    var propTypesColor = ["transparent", "white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesShadow = _propTypes.default.bool;
    var propTypesBlurred = _propTypes.default.bool;
    var propTypesFullWidth = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
    var propTypesOpen = _propTypes.default.bool.isRequired;
    var propTypesAnimate = _generic.propTypesAnimation;
  }
});

// node_modules/@material-tailwind/react/theme/components/navbar/index.js
var require_navbar2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/navbar/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { navbar: function() {
      return navbar;
    }, default: function() {
      return _default;
    } });
    var _navbarFilled = _interopRequireDefault(require_navbarFilled());
    var _navbarGradient = _interopRequireDefault(require_navbarGradient());
    var _navbar = require_navbar();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var navbar = { defaultProps: { variant: "filled", color: "white", shadow: true, blurred: true, fullWidth: false, className: "" }, valid: { variants: _navbar.propTypesVariant, colors: _navbar.propTypesColor }, styles: { base: { navbar: { initial: { display: "block", width: "w-full", maxWidth: "max-w-screen-2xl", borderRadius: "rounded-xl", py: "py-4", px: "px-8" }, shadow: { boxShadow: "shadow-md" }, blurred: { backdropFilter: "backdrop-saturate-200 backdrop-blur-2xl", bgOpacity: "bg-opacity-80", borderWidth: "border", borderColor: "border-white/80" }, fullWidth: { width: "w-full", maxWidth: "max-w-full", rounded: "rounded-none", px: "px-4" } }, mobileNav: { display: "block", width: "w-full", basis: "basis-full", overflow: "overflow-hidden" } }, variants: { filled: _navbarFilled.default, gradient: _navbarGradient.default } } };
    var _default = navbar;
  }
});

// node_modules/@material-tailwind/react/theme/components/popover/index.js
var require_popover = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/popover/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { popover: function() {
      return popover;
    }, default: function() {
      return _default;
    } });
    var popover = { defaultProps: { placement: "top", offset: 5, dismiss: {}, animate: { unmount: {}, mount: {} }, className: "" }, styles: { base: { bg: "bg-white", p: "p-4", border: "border border-blue-gray-50", borderRadius: "rounded-lg", boxShadow: "shadow-lg shadow-blue-gray-500/10", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-normal", color: "text-blue-gray-500", outline: "focus:outline-none", overflowWrap: "break-words", whiteSpace: "whitespace-normal" } } };
    var _default = popover;
  }
});

// node_modules/@material-tailwind/react/theme/components/progress/progressFilled.js
var require_progressFilled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/progress/progressFilled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var progressFilled = { "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white" }, gray: { backgroud: "bg-gray-900", color: "text-white" }, brown: { backgroud: "bg-brown-500", color: "text-white" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white" }, orange: { backgroud: "bg-orange-500", color: "text-white" }, amber: { backgroud: "bg-amber-500", color: "text-black" }, yellow: { backgroud: "bg-yellow-500", color: "text-black" }, lime: { backgroud: "bg-lime-500", color: "text-black" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white" }, green: { backgroud: "bg-green-500", color: "text-white" }, teal: { backgroud: "bg-teal-500", color: "text-white" }, cyan: { backgroud: "bg-cyan-500", color: "text-white" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white" }, blue: { backgroud: "bg-blue-500", color: "text-white" }, indigo: { backgroud: "bg-indigo-500", color: "text-white" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white" }, purple: { backgroud: "bg-purple-500", color: "text-white" }, pink: { backgroud: "bg-pink-500", color: "text-white" }, red: { backgroud: "bg-red-500", color: "text-white" } };
    var _default = progressFilled;
  }
});

// node_modules/@material-tailwind/react/theme/components/progress/progressGradient.js
var require_progressGradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/progress/progressGradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var progressGradient = { "blue-gray": { backgroud: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white" }, gray: { backgroud: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white" }, brown: { backgroud: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white" }, "deep-orange": { backgroud: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white" }, orange: { backgroud: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white" }, amber: { backgroud: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black" }, yellow: { backgroud: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black" }, lime: { backgroud: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black" }, "light-green": { backgroud: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white" }, green: { backgroud: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white" }, teal: { backgroud: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white" }, cyan: { backgroud: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white" }, "light-blue": { backgroud: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white" }, blue: { backgroud: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white" }, indigo: { backgroud: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white" }, "deep-purple": { backgroud: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white" }, purple: { backgroud: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white" }, pink: { backgroud: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white" }, red: { backgroud: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white" } };
    var _default = progressGradient;
  }
});

// node_modules/@material-tailwind/react/types/components/progress.js
var require_progress = __commonJS({
  "node_modules/@material-tailwind/react/types/components/progress.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesValue: function() {
      return propTypesValue;
    }, propTypesLabel: function() {
      return propTypesLabel;
    }, propTypesBarProps: function() {
      return propTypesBarProps;
    }, propTypesClassName: function() {
      return propTypesClassName;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesVariant = ["filled", "gradient"];
    var propTypesColor = _generic.propTypesColors;
    var propTypesSize = ["sm", "md", "lg"];
    var propTypesValue = _propTypes.default.number;
    var propTypesLabel = _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]);
    var propTypesBarProps = _propTypes.default.instanceOf(Object);
    var propTypesClassName = _propTypes.default.string;
  }
});

// node_modules/@material-tailwind/react/theme/components/progress/index.js
var require_progress2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/progress/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { progress: function() {
      return progress2;
    }, default: function() {
      return _default;
    } });
    var _progressFilled = _interopRequireDefault(require_progressFilled());
    var _progressGradient = _interopRequireDefault(require_progressGradient());
    var _progress = require_progress();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var progress2 = { defaultProps: { variant: "filled", color: "gray", size: "md", value: 0, label: false, className: "", barProps: {} }, valid: { variants: _progress.propTypesVariant, colors: _progress.propTypesColor, sizes: _progress.propTypesSize }, styles: { base: { container: { initial: { display: "flex", justifyContent: "flex-start", bg: "bg-blue-gray-50", overflow: "overflow-hidden", width: "w-full", fontFamily: "font-sans", borderRadius: "rounded-full", fontSize: "text-xs", fontWeight: "font-medium" }, withLabel: {} }, bar: { display: "flex", justifyContent: "justify-center", alignItems: "items-center", height: "h-full", overflow: "overflow-hidden", wordBreak: "break-all", borderRadius: "rounded-full" } }, sizes: { sm: { container: { initial: { height: "h-1.5" }, withLabel: { height: "h-3.5" } }, bar: {} }, md: { container: { initial: { height: "h-2.5" }, withLabel: { height: "h-4" } }, bar: {} }, lg: { container: { initial: { height: "h-3.5" }, withLabel: { height: "h-5" } }, bar: {} } }, variants: { filled: _progressFilled.default, gradient: _progressGradient.default } } };
    var _default = progress2;
  }
});

// node_modules/@material-tailwind/react/theme/components/radio/radioColors.js
var require_radioColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/radio/radioColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var radioColors = { "blue-gray": { color: "text-blue-gray-500", border: "checked:border-blue-gray-500", before: "checked:before:bg-blue-gray-500" }, gray: { color: "text-gray-900", border: "checked:border-gray-900", before: "checked:before:bg-gray-900" }, brown: { color: "text-brown-500", border: "checked:border-brown-500", before: "checked:before:bg-brown-500" }, "deep-orange": { color: "text-deep-orange-500", border: "checked:border-deep-orange-500", before: "checked:before:bg-deep-orange-500" }, orange: { color: "text-orange-500", border: "checked:border-orange-500", before: "checked:before:bg-orange-500" }, amber: { color: "text-amber-500", border: "checked:border-amber-500", before: "checked:before:bg-amber-500" }, yellow: { color: "text-yellow-500", border: "checked:border-yellow-500", before: "checked:before:bg-yellow-500" }, lime: { color: "text-lime-500", border: "checked:border-lime-500", before: "checked:before:bg-lime-500" }, "light-green": { color: "text-light-green-500", border: "checked:border-light-green-500", before: "checked:before:bg-light-green-500" }, green: { color: "text-green-500", border: "checked:border-green-500", before: "checked:before:bg-green-500" }, teal: { color: "text-teal-500", border: "checked:border-teal-500", before: "checked:before:bg-teal-500" }, cyan: { color: "text-cyan-500", border: "checked:border-cyan-500", before: "checked:before:bg-cyan-500" }, "light-blue": { color: "text-light-blue-500", border: "checked:border-light-blue-500", before: "checked:before:bg-light-blue-500" }, blue: { color: "text-blue-500", border: "checked:border-blue-500", before: "checked:before:bg-blue-500" }, indigo: { color: "text-indigo-500", border: "checked:border-indigo-500", before: "checked:before:bg-indigo-500" }, "deep-purple": { color: "text-deep-purple-500", border: "checked:border-deep-purple-500", before: "checked:before:bg-deep-purple-500" }, purple: { color: "text-purple-500", border: "checked:border-purple-500", before: "checked:before:bg-purple-500" }, pink: { color: "text-pink-500", border: "checked:border-pink-500", before: "checked:before:bg-pink-500" }, red: { color: "text-red-500", border: "checked:border-red-500", before: "checked:before:bg-red-500" } };
    var _default = radioColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/radio/index.js
var require_radio = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/radio/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { radio: function() {
      return radio;
    }, default: function() {
      return _default;
    } });
    var _radioColors = _interopRequireDefault(require_radioColors());
    var _checkbox = require_checkbox();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var radio = { defaultProps: { color: "gray", label: void 0, icon: void 0, ripple: true, className: "", disabled: false, containerProps: void 0, labelProps: void 0, iconProps: void 0 }, valid: { colors: _checkbox.propTypesColor }, styles: { base: { root: { display: "inline-flex", alignItems: "items-center" }, container: { position: "relative", display: "flex", alignItems: "items-center", cursor: "cursor-pointer", p: "p-3", borderRadius: "rounded-full" }, input: { peer: "peer", position: "relative", appearance: "appearance-none", width: "w-5", height: "h-5", borderWidth: "border", borderRadius: "rounded-full", borderColor: "border-blue-gray-200", cursor: "cursor-pointer", transition: "transition-all", before: { content: "before:content['']", display: "before:block", bg: "before:bg-blue-gray-500", width: "before:w-12", height: "before:h-12", borderRadius: "before:rounded-full", position: "before:absolute", top: "before:top-2/4", left: "before:left-2/4", transform: "before:-translate-y-2/4 before:-translate-x-2/4", opacity: "before:opacity-0 hover:before:opacity-10", transition: "before:transition-opacity" } }, label: { color: "text-gray-700", fontWeight: "font-light", userSelect: "select-none", cursor: "cursor-pointer", mt: "mt-px" }, icon: { position: "absolute", top: "top-2/4", left: "left-2/4", translate: "-translate-y-2/4 -translate-x-2/4", pointerEvents: "pointer-events-none", opacity: "opacity-0 peer-checked:opacity-100", transition: "transition-opacity" }, disabled: { opacity: "opacity-50", pointerEvents: "pointer-events-none" } }, colors: _radioColors.default } };
    var _default = radio;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedLabel.js
var require_selectOutlinedLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectOutlinedLabel = { position: "-top-1.5", before: { content: "before:content[' ']", display: "before:block", boxSizing: "before:box-border", width: "before:w-2.5", height: "before:h-1.5", mt: "before:mt-[6.5px]", mr: "before:mr-1", borderRadius: "before:rounded-tl-md", pointerEvents: "before:pointer-events-none", transition: "before:transition-all", disabled: "peer-disabled:before:border-transparent" }, after: { content: "after:content[' ']", display: "after:block", flexGrow: "after:flex-grow", boxSizing: "after:box-border", width: "after:w-2.5", height: "after:h-1.5", mt: "after:mt-[6.5px]", ml: "after:ml-1", borderRadius: "after:rounded-tr-md", pointerEvents: "after:pointer-events-none", transition: "after:transition-all", disabled: "peer-disabled:after:border-transparent" } };
    var _default = selectOutlinedLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedColors.js
var require_selectOutlinedColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectOutlinedColors = { "blue-gray": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-gray-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, gray: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-gray-900", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, brown: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-brown-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, "deep-orange": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-orange-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, orange: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-orange-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, amber: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-amber-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, yellow: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-yellow-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, lime: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-lime-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, "light-green": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-green-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, green: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-green-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, teal: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-teal-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, cyan: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-cyan-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, "light-blue": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-blue-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, blue: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, indigo: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-indigo-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, "deep-purple": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-purple-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, purple: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-purple-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, pink: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-pink-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } }, red: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-red-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-blue-gray-200", borderTopColor: "border-t-transparent" } } };
    var _default = selectOutlinedColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedLabelColors.js
var require_selectOutlinedLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectOutlined/selectOutlinedLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectOutlinedLabelColors = { "blue-gray": { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-blue-gray-500", before: "before:border-blue-gray-500", after: "after:border-blue-gray-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, gray: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-gray-900", before: "before:border-gray-900", after: "after:border-gray-900" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, brown: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-brown-500", before: "before:border-brown-500", after: "after:border-brown-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, "deep-orange": { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-deep-orange-500", before: "before:border-deep-orange-500", after: "after:border-deep-orange-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, orange: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-orange-500", before: "before:border-orange-500", after: "after:border-orange-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, amber: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-amber-500", before: "before:border-amber-500", after: "after:border-amber-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, yellow: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-yellow-500", before: "before:border-yellow-500", after: "after:border-yellow-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, lime: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-lime-500", before: "before:border-lime-500", after: "after:border-lime-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, "light-green": { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-light-green-500", before: "before:border-light-green-500", after: "after:border-light-green-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, green: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-green-500", before: "before:border-green-500", after: "after:border-green-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, teal: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-teal-500", before: "before:border-teal-500", after: "after:border-teal-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, cyan: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-cyan-500", before: "before:border-cyan-500", after: "after:border-cyan-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, "light-blue": { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-light-blue-500", before: "before:border-light-blue-500", after: "after:border-light-blue-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, blue: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-blue-500", before: "before:border-blue-500", after: "after:border-blue-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, indigo: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-indigo-500", before: "before:border-indigo-500", after: "after:border-indigo-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, "deep-purple": { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-deep-purple-500", before: "before:border-deep-purple-500", after: "after:border-deep-purple-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, purple: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-purple-500", before: "before:border-purple-500", after: "after:border-purple-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, pink: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-pink-500", before: "before:border-pink-500", after: "after:border-pink-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } }, red: { close: { color: "text-blue-gray-400", before: "before:border-transparent", after: "after:border-transparent" }, open: { color: "text-red-500", before: "before:border-red-500", after: "after:border-red-500" }, withValue: { color: "text-blue-gray-400", before: "before:border-blue-gray-200", after: "after:border-blue-gray-200" } } };
    var _default = selectOutlinedLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectOutlined/index.js
var require_selectOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectOutlined/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _selectOutlinedLabel = _interopRequireDefault(require_selectOutlinedLabel());
    var _selectOutlinedColors = _interopRequireDefault(require_selectOutlinedColors());
    var _selectOutlinedLabelColors = _interopRequireDefault(require_selectOutlinedLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var selectOutlined = { base: { select: {}, label: _selectOutlinedLabel.default }, sizes: { md: { container: { height: "h-10" }, select: { fontSize: "text-sm", px: "px-3", py: "py-2.5", borderRadius: "rounded-[7px]" }, label: { initial: {}, states: { close: { lineHeight: "leading-[3.75]" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } }, lg: { container: { height: "h-11" }, select: { fontSize: "text-sm", px: "px-3", py: "py-3", borderRadius: "rounded-[7px]" }, label: { initial: {}, states: { close: { lineHeight: "leading-[4.1]" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } } }, colors: { select: _selectOutlinedColors.default, label: _selectOutlinedLabelColors.default }, states: { close: { select: { borderWidth: "border" }, label: { fontSize: "text-sm", disabled: "peer-disabled:text-blue-gray-400", before: { bt: "before:border-t-transparent", bl: "before:border-l-transparent" }, after: { bt: "after:border-t-transparent", br: "after:border-r-transparent" } } }, open: { select: { borderWidth: "border-2", borderColor: "border-t-transparent" }, label: { fontSize: "text-[11px]", disabled: "peer-disabled:text-transparent", before: { bt: "before:border-t-2", bl: "before:border-l-2" }, after: { bt: "after:border-t-2", br: "after:border-r-2" } } }, withValue: { select: { borderWidth: "border", borderColor: "border-t-transparent" }, label: { fontSize: "text-[11px]", disabled: "peer-disabled:text-transparent", before: { bt: "before:border-t", bl: "before:border-l" }, after: { bt: "after:border-t", br: "after:border-r" } } } }, error: { select: { initial: {}, states: { close: { borderColor: "border-red-500" }, open: { borderColor: "border-red-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-red-500", borderTopColor: "border-t-transparent" } } }, label: { initial: {}, states: { close: { color: "text-red-500", before: "before:border-red-500", after: "after:border-red-500" }, open: { color: "text-red-500", before: "before:border-red-500", after: "after:border-red-500" }, withValue: { color: "text-red-500", before: "before:border-red-500", after: "after:border-red-500" } } } }, success: { select: { initial: {}, states: { close: { borderColor: "border-green-500" }, open: { borderColor: "border-green-500", borderTopColor: "border-t-transparent" }, withValue: { borderColor: "border-green-500", borderTopColor: "border-t-transparent" } } }, label: { initial: {}, states: { close: { color: "text-green-500", before: "before:border-green-500", after: "after:border-green-500" }, open: { color: "text-green-500", before: "before:border-green-500", after: "after:border-green-500" }, withValue: { color: "text-green-500", before: "before:border-green-500", after: "after:border-green-500" } } } } };
    var _default = selectOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardLabel.js
var require_selectStandardLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStandardLabel = { position: "-top-1.5", after: { content: "after:content[' ']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-1.5", left: "left-0", borderWidth: "after:border-b-2", transition: "after:transition-transform after:duration-300" } };
    var _default = selectStandardLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardColors.js
var require_selectStandardColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStandardColors = { "blue-gray": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-gray-500" }, withValue: { borderColor: "border-blue-gray-200" } }, gray: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-gray-900" }, withValue: { borderColor: "border-blue-gray-200" } }, brown: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-brown-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "deep-orange": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-orange-500" }, withValue: { borderColor: "border-blue-gray-200" } }, orange: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-orange-500" }, withValue: { borderColor: "border-blue-gray-200" } }, amber: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-amber-500" }, withValue: { borderColor: "border-blue-gray-200" } }, yellow: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-yellow-500" }, withValue: { borderColor: "border-blue-gray-200" } }, lime: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-lime-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "light-green": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-green-500" }, withValue: { borderColor: "border-blue-gray-200" } }, green: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-green-500" }, withValue: { borderColor: "border-blue-gray-200" } }, teal: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-teal-500" }, withValue: { borderColor: "border-blue-gray-200" } }, cyan: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-cyan-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "light-blue": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-blue-500" }, withValue: { borderColor: "border-blue-gray-200" } }, blue: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-500" }, withValue: { borderColor: "border-blue-gray-200" } }, indigo: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-indigo-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "deep-purple": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-purple-500" }, withValue: { borderColor: "border-blue-gray-200" } }, purple: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-purple-500" }, withValue: { borderColor: "border-blue-gray-200" } }, pink: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-pink-500" }, withValue: { borderColor: "border-blue-gray-200" } }, red: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-red-500" }, withValue: { borderColor: "border-blue-gray-200" } } };
    var _default = selectStandardColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardLabelColors.js
var require_selectStandardLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStandard/selectStandardLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStandardLabelColors = { "blue-gray": { close: { color: "text-blue-gray-500", after: "after:border-blue-gray-500" }, open: { color: "text-blue-gray-500", after: "after:border-blue-gray-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-blue-gray-50" } }, gray: { close: { color: "text-blue-gray-500", after: "after:border-gray-500" }, open: { color: "text-gray-900", after: "after:border-gray-900" }, withValue: { color: "text-blue-gray-500", after: "after:border-gray-500" } }, brown: { close: { color: "text-blue-gray-500", after: "after:border-brown-500" }, open: { color: "text-brown-500", after: "after:border-brown-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-brown-500" } }, "deep-orange": { close: { color: "text-blue-gray-500", after: "after:border-deep-orange-500" }, open: { color: "text-deep-orange-500", after: "after:border-deep-orange-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-deep-orange-500" } }, orange: { close: { color: "text-blue-gray-500", after: "after:border-orange-500" }, open: { color: "text-orange-500", after: "after:border-orange-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-orange-500" } }, amber: { close: { color: "text-blue-gray-500", after: "after:border-amber-500" }, open: { color: "text-amber-500", after: "after:border-amber-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-amber-500" } }, yellow: { close: { color: "text-blue-gray-500", after: "after:border-yellow-500" }, open: { color: "text-yellow-500", after: "after:border-yellow-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-yellow-500" } }, lime: { close: { color: "text-blue-gray-500", after: "after:border-lime-500" }, open: { color: "text-lime-500", after: "after:border-lime-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-lime-500" } }, "light-green": { close: { color: "text-blue-gray-500", after: "after:border-light-green-500" }, open: { color: "text-light-green-500", after: "after:border-light-green-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-light-green-500" } }, green: { close: { color: "text-blue-gray-500", after: "after:border-green-500" }, open: { color: "text-green-500", after: "after:border-green-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-green-500" } }, teal: { close: { color: "text-blue-gray-500", after: "after:border-teal-500" }, open: { color: "text-teal-500", after: "after:border-teal-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-teal-500" } }, cyan: { close: { color: "text-blue-gray-500", after: "after:border-cyan-500" }, open: { color: "text-cyan-500", after: "after:border-cyan-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-cyan-500" } }, "light-blue": { close: { color: "text-blue-gray-500", after: "after:border-light-blue-500" }, open: { color: "text-light-blue-500", after: "after:border-light-blue-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-light-blue-500" } }, blue: { close: { color: "text-blue-gray-500", after: "after:border-blue-500" }, open: { color: "text-blue-500", after: "after:border-blue-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-blue-500" } }, indigo: { close: { color: "text-blue-gray-500", after: "after:border-indigo-500" }, open: { color: "text-indigo-500", after: "after:border-indigo-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-indigo-500" } }, "deep-purple": { close: { color: "text-blue-gray-500", after: "after:border-deep-purple-500" }, open: { color: "text-deep-purple-500", after: "after:border-deep-purple-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-deep-purple-500" } }, purple: { close: { color: "text-blue-gray-500", after: "after:border-purple-500" }, open: { color: "text-purple-500", after: "after:border-purple-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-purple-500" } }, pink: { close: { color: "text-blue-gray-500", after: "after:border-pink-500" }, open: { color: "text-pink-500", after: "after:border-pink-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-pink-500" } }, red: { close: { color: "text-blue-gray-500", after: "after:border-red-500" }, open: { color: "text-red-500", after: "after:border-red-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-red-500" } } };
    var _default = selectStandardLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStandard/index.js
var require_selectStandard = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStandard/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _selectStandardLabel = _interopRequireDefault(require_selectStandardLabel());
    var _selectStandardColors = _interopRequireDefault(require_selectStandardColors());
    var _selectStandardLabelColors = _interopRequireDefault(require_selectStandardLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var selectStandard = { base: { select: {}, label: _selectStandardLabel.default }, sizes: { md: { container: { height: "h-11" }, select: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5" }, label: { initial: {}, states: { close: { lineHeight: "leading-[4.25]" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } }, lg: { container: { height: "h-12" }, select: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { initial: {}, states: { close: { lineHeight: "leading-[4.875]" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } } }, colors: { select: _selectStandardColors.default, label: _selectStandardLabelColors.default }, states: { close: { select: { borderWidth: "border-b" }, label: { fontSize: "text-sm", disabled: "peer-disabled:text-blue-gray-400", after: { transform: "after:scale-x-0" } } }, open: { select: { borderWidth: "border-b" }, label: { fontSize: "text-[11px]", disabled: "peer-disabled:text-transparent", after: { transform: "after:scale-x-100" } } }, withValue: { select: { borderWidth: "border-b" }, label: { fontSize: "text-[11px]", disabled: "peer-disabled:text-transparent", after: { transform: "after:scale-x-0" } } } }, error: { select: { initial: {}, states: { close: { borderColor: "border-red-500" }, open: { borderColor: "border-red-500" }, withValue: { borderColor: "border-red-500" } } }, label: { initial: {}, states: { close: { color: "text-red-500", after: "after:border-red-500" }, open: { color: "text-red-500", after: "after:border-red-500" }, withValue: { color: "text-red-500", after: "after:border-red-500" } } } }, success: { select: { initial: {}, states: { close: { borderColor: "border-green-500" }, open: { borderColor: "border-green-500" }, withValue: { borderColor: "border-green-500" } } }, label: { initial: {}, states: { close: { color: "text-green-500", after: "after:border-green-500" }, open: { color: "text-green-500", after: "after:border-green-500" }, withValue: { color: "text-green-500", after: "after:border-green-500" } } } } };
    var _default = selectStandard;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticLabel.js
var require_selectStaticLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStaticLabel = { position: "-top-2.5", after: { content: "after:content[' ']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-2.5", left: "left-0", borderWidth: "after:border-b-2", transition: "after:transition-transform after:duration-300" } };
    var _default = selectStaticLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticColors.js
var require_selectStaticColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStaticColors = { "blue-gray": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-gray-500" }, withValue: { borderColor: "border-blue-gray-200" } }, gray: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-gray-900" }, withValue: { borderColor: "border-blue-gray-200" } }, brown: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-brown-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "deep-orange": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-orange-500" }, withValue: { borderColor: "border-blue-gray-200" } }, orange: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-orange-500" }, withValue: { borderColor: "border-blue-gray-200" } }, amber: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-amber-500" }, withValue: { borderColor: "border-blue-gray-200" } }, yellow: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-yellow-500" }, withValue: { borderColor: "border-blue-gray-200" } }, lime: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-lime-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "light-green": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-green-500" }, withValue: { borderColor: "border-blue-gray-200" } }, green: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-green-500" }, withValue: { borderColor: "border-blue-gray-200" } }, teal: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-teal-500" }, withValue: { borderColor: "border-blue-gray-200" } }, cyan: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-cyan-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "light-blue": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-light-blue-500" }, withValue: { borderColor: "border-blue-gray-200" } }, blue: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-blue-500" }, withValue: { borderColor: "border-blue-gray-200" } }, indigo: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-indigo-500" }, withValue: { borderColor: "border-blue-gray-200" } }, "deep-purple": { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-deep-purple-500" }, withValue: { borderColor: "border-blue-gray-200" } }, purple: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-purple-500" }, withValue: { borderColor: "border-blue-gray-200" } }, pink: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-pink-500" }, withValue: { borderColor: "border-blue-gray-200" } }, red: { close: { borderColor: "border-blue-gray-200" }, open: { borderColor: "border-red-500" }, withValue: { borderColor: "border-blue-gray-200" } } };
    var _default = selectStaticColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticLabelColors.js
var require_selectStaticLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStatic/selectStaticLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var selectStaticLabelColors = { "blue-gray": { close: { color: "text-blue-gray-500", after: "after:border-blue-gray-500" }, open: { color: "text-blue-gray-500", after: "after:border-blue-gray-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-blue-gray-50" } }, gray: { close: { color: "text-blue-gray-500", after: "after:border-gray-500" }, open: { color: "text-gray-900", after: "after:border-gray-900" }, withValue: { color: "text-blue-gray-500", after: "after:border-gray-500" } }, brown: { close: { color: "text-blue-gray-500", after: "after:border-brown-500" }, open: { color: "text-brown-500", after: "after:border-brown-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-brown-500" } }, "deep-orange": { close: { color: "text-blue-gray-500", after: "after:border-deep-orange-500" }, open: { color: "text-deep-orange-500", after: "after:border-deep-orange-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-deep-orange-500" } }, orange: { close: { color: "text-blue-gray-500", after: "after:border-orange-500" }, open: { color: "text-orange-500", after: "after:border-orange-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-orange-500" } }, amber: { close: { color: "text-blue-gray-500", after: "after:border-amber-500" }, open: { color: "text-amber-500", after: "after:border-amber-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-amber-500" } }, yellow: { close: { color: "text-blue-gray-500", after: "after:border-yellow-500" }, open: { color: "text-yellow-500", after: "after:border-yellow-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-yellow-500" } }, lime: { close: { color: "text-blue-gray-500", after: "after:border-lime-500" }, open: { color: "text-lime-500", after: "after:border-lime-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-lime-500" } }, "light-green": { close: { color: "text-blue-gray-500", after: "after:border-light-green-500" }, open: { color: "text-light-green-500", after: "after:border-light-green-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-light-green-500" } }, green: { close: { color: "text-blue-gray-500", after: "after:border-green-500" }, open: { color: "text-green-500", after: "after:border-green-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-green-500" } }, teal: { close: { color: "text-blue-gray-500", after: "after:border-teal-500" }, open: { color: "text-teal-500", after: "after:border-teal-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-teal-500" } }, cyan: { close: { color: "text-blue-gray-500", after: "after:border-cyan-500" }, open: { color: "text-cyan-500", after: "after:border-cyan-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-cyan-500" } }, "light-blue": { close: { color: "text-blue-gray-500", after: "after:border-light-blue-500" }, open: { color: "text-light-blue-500", after: "after:border-light-blue-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-light-blue-500" } }, blue: { close: { color: "text-blue-gray-500", after: "after:border-blue-500" }, open: { color: "text-blue-500", after: "after:border-blue-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-blue-500" } }, indigo: { close: { color: "text-blue-gray-500", after: "after:border-indigo-500" }, open: { color: "text-indigo-500", after: "after:border-indigo-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-indigo-500" } }, "deep-purple": { close: { color: "text-blue-gray-500", after: "after:border-deep-purple-500" }, open: { color: "text-deep-purple-500", after: "after:border-deep-purple-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-deep-purple-500" } }, purple: { close: { color: "text-blue-gray-500", after: "after:border-purple-500" }, open: { color: "text-purple-500", after: "after:border-purple-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-purple-500" } }, pink: { close: { color: "text-blue-gray-500", after: "after:border-pink-500" }, open: { color: "text-pink-500", after: "after:border-pink-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-pink-500" } }, red: { close: { color: "text-blue-gray-500", after: "after:border-red-500" }, open: { color: "text-red-500", after: "after:border-red-500" }, withValue: { color: "text-blue-gray-500", after: "after:border-red-500" } } };
    var _default = selectStaticLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/selectStatic/index.js
var require_selectStatic = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/selectStatic/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _selectStaticLabel = _interopRequireDefault(require_selectStaticLabel());
    var _selectStaticColors = _interopRequireDefault(require_selectStaticColors());
    var _selectStaticLabelColors = _interopRequireDefault(require_selectStaticLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var selectStatic = { base: { select: {}, label: _selectStaticLabel.default }, sizes: { md: { container: { height: "h-11" }, select: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5" }, label: { initial: {}, states: { close: { lineHeight: "leading-tight" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } }, lg: { container: { height: "h-12" }, select: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { initial: {}, states: { close: { lineHeight: "leading-tight" }, open: { lineHeight: "leading-tight" }, withValue: { lineHeight: "leading-tight" } } } } }, colors: { select: _selectStaticColors.default, label: _selectStaticLabelColors.default }, states: { close: { select: { borderWidth: "border-b" }, label: { fontSize: "text-sm", disabled: "peer-disabled:text-blue-gray-400", after: { transform: "after:scale-x-0" } } }, open: { select: { borderWidth: "border-b" }, label: { fontSize: "text-sm", disabled: "peer-disabled:text-transparent", after: { transform: "after:scale-x-100" } } }, withValue: { select: { borderWidth: "border-b" }, label: { fontSize: "text-sm", disabled: "peer-disabled:text-transparent", after: { transform: "after:scale-x-0" } } } }, error: { select: { initial: {}, states: { close: { borderColor: "border-red-500" }, open: { borderColor: "border-red-500" }, withValue: { borderColor: "border-red-500" } } }, label: { initial: {}, states: { close: { color: "text-red-500", after: "after:border-red-500" }, open: { color: "text-red-500", after: "after:border-red-500" }, withValue: { color: "text-red-500", after: "after:border-red-500" } } } }, success: { select: { initial: {}, states: { close: { borderColor: "border-green-500" }, open: { borderColor: "border-green-500" }, withValue: { borderColor: "border-green-500" } } }, label: { initial: {}, states: { close: { color: "text-green-500", after: "after:border-green-500" }, open: { color: "text-green-500", after: "after:border-green-500" }, withValue: { color: "text-green-500", after: "after:border-green-500" } } } } };
    var _default = selectStatic;
  }
});

// node_modules/@material-tailwind/react/types/components/select.js
var require_select = __commonJS({
  "node_modules/@material-tailwind/react/types/components/select.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesLabel: function() {
      return propTypesLabel;
    }, propTypesError: function() {
      return propTypesError;
    }, propTypesSuccess: function() {
      return propTypesSuccess;
    }, propTypesArrow: function() {
      return propTypesArrow;
    }, propTypesValue: function() {
      return propTypesValue;
    }, propTypesOnChange: function() {
      return propTypesOnChange;
    }, propTypesSelected: function() {
      return propTypesSelected;
    }, propTypesOffset: function() {
      return propTypesOffset;
    }, propTypesDismiss: function() {
      return propTypesDismiss;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    }, propTypesAutoHeight: function() {
      return propTypesAutoHeight;
    }, propTypesLockScroll: function() {
      return propTypesLockScroll;
    }, propTypesLabelProps: function() {
      return propTypesLabelProps;
    }, propTypesMenuProps: function() {
      return propTypesMenuProps;
    }, propTypesIndex: function() {
      return propTypesIndex;
    }, propTypesDisabled: function() {
      return propTypesDisabled;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesName: function() {
      return propTypesName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    }, propTypesContainerProps: function() {
      return propTypesContainerProps;
    }, propTypesContextValue: function() {
      return propTypesContextValue;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesVariant = ["standard", "outlined", "static"];
    var propTypesSize = ["md", "lg"];
    var propTypesColor = _generic.propTypesColors;
    var propTypesLabel = _propTypes.default.string;
    var propTypesError = _propTypes.default.bool;
    var propTypesSuccess = _propTypes.default.bool;
    var propTypesArrow = _propTypes.default.node;
    var propTypesValue = _propTypes.default.string;
    var propTypesOnChange = _propTypes.default.func;
    var propTypesSelected = _propTypes.default.func;
    var propTypesOffset = _generic.propTypesOffsetType;
    var propTypesDismiss = _generic.propTypesDismissType;
    var propTypesAnimate = _generic.propTypesAnimation;
    var propTypesAutoHeight = _propTypes.default.bool;
    var propTypesLockScroll = _propTypes.default.bool;
    var propTypesLabelProps = _propTypes.default.instanceOf(Object);
    var propTypesMenuProps = _propTypes.default.instanceOf(Object);
    var propTypesIndex = _propTypes.default.number;
    var propTypesDisabled = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
    var propTypesContainerProps = _propTypes.default.instanceOf(Object);
    var propTypesContextValue = _propTypes.default.shape({ selectedIndex: _propTypes.default.number.isRequired, setSelectedIndex: _propTypes.default.func.isRequired, activeIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.instanceOf(null)]), setActiveIndex: _propTypes.default.func.isRequired, listRef: _propTypes.default.instanceOf(Object).isRequired, setOpen: _propTypes.default.func.isRequired, onChange: _propTypes.default.func.isRequired, getItemProps: _propTypes.default.func.isRequired, dataRef: _propTypes.default.instanceOf(Object).isRequired }).isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/select/index.js
var require_select2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/select/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { select: function() {
      return select;
    }, default: function() {
      return _default;
    } });
    var _selectOutlined = _interopRequireDefault(require_selectOutlined());
    var _selectStandard = _interopRequireDefault(require_selectStandard());
    var _selectStatic = _interopRequireDefault(require_selectStatic());
    var _select = require_select();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var select = { defaultProps: { variant: "outlined", color: "gray", size: "md", label: "", error: false, success: false, arrow: void 0, value: void 0, onChange: void 0, selected: void 0, offset: 5, dismiss: {}, animate: { unmount: {}, mount: {} }, autoHeight: false, lockScroll: false, labelProps: {}, menuProps: {}, className: "", disabled: false, containerProps: void 0 }, valid: { variants: _select.propTypesVariant, sizes: _select.propTypesSize, colors: _select.propTypesColor }, styles: { base: { container: { position: "relative", width: "w-full", minWidth: "min-w-[200px]" }, select: { peer: "peer", width: "w-full", height: "h-full", bg: "bg-transparent", color: "text-blue-gray-700", fontFamily: "font-sans", fontWeight: "font-normal", textAlign: "text-left", outline: "outline outline-0 focus:outline-0", disabled: "disabled:bg-blue-gray-50 disabled:border-0 disabled:cursor-not-allowed", transition: "transition-all" }, arrow: { initial: { display: "grid", placeItems: "place-items-center", position: "absolute", top: "top-2/4", right: "right-2", pt: "pt-px", width: "w-5", height: "h-5", color: "text-blue-gray-400", transform: "rotate-0 -translate-y-2/4", transition: "transition-all" }, active: { transform: "rotate-180", mt: "mt-px" } }, label: { display: "flex", width: "w-full", height: "h-full", userSelect: "select-none", pointerEvents: "pointer-events-none", position: "absolute", left: "left-0", fontWeight: "font-normal", transition: "transition-all" }, menu: { width: "w-full", maxHeight: "max-h-96", bg: "bg-white", p: "p-3", border: "border border-blue-gray-50", borderRadius: "rounded-md", boxShadow: "shadow-lg shadow-blue-gray-500/10", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-normal", color: "text-blue-gray-500", overflow: "overflow-auto", outline: "focus:outline-none" }, option: { initial: { pt: "pt-[9px]", pb: "pb-2", px: "px-3", borderRadius: "rounded-md", lightHeight: "leading-tight", cursor: "cursor-pointer", userSelect: "select-none", background: "hover:bg-blue-gray-50 focus:bg-blue-gray-50", opacity: "hover:bg-opacity-80 focus:bg-opacity-80", color: "hover:text-blue-gray-900 focus:text-blue-gray-900", outline: "outline outline-0", transition: "transition-all" }, active: { bg: "bg-blue-gray-50 bg-opacity-80", color: "text-blue-gray-900" }, disabled: { opacity: "opacity-50", cursor: "cursor-not-allowed", userSelect: "select-none", pointerEvents: "pointer-events-none" } } }, variants: { outlined: _selectOutlined.default, standard: _selectStandard.default, static: _selectStatic.default } } };
    var _default = select;
  }
});

// node_modules/@material-tailwind/react/theme/components/switch/switchColors.js
var require_switchColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/switch/switchColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var switchColors = { "blue-gray": { input: "checked:bg-blue-gray-500", circle: "peer-checked:border-blue-gray-500", before: "peer-checked:before:bg-blue-gray-500" }, gray: { input: "checked:bg-gray-900", circle: "peer-checked:border-gray-900", before: "peer-checked:before:bg-gray-900" }, brown: { input: "checked:bg-brown-500", circle: "peer-checked:border-brown-500", before: "peer-checked:before:bg-brown-500" }, "deep-orange": { input: "checked:bg-deep-orange-500", circle: "peer-checked:border-deep-orange-500", before: "peer-checked:before:bg-deep-orange-500" }, orange: { input: "checked:bg-orange-500", circle: "peer-checked:border-orange-500", before: "peer-checked:before:bg-orange-500" }, amber: { input: "checked:bg-amber-500", circle: "peer-checked:border-amber-500", before: "peer-checked:before:bg-amber-500" }, yellow: { input: "checked:bg-yellow-500", circle: "peer-checked:border-yellow-500", before: "peer-checked:before:bg-yellow-500" }, lime: { input: "checked:bg-lime-500", circle: "peer-checked:border-lime-500", before: "peer-checked:before:bg-lime-500" }, "light-green": { input: "checked:bg-light-green-500", circle: "peer-checked:border-light-green-500", before: "peer-checked:before:bg-light-green-500" }, green: { input: "checked:bg-green-500", circle: "peer-checked:border-green-500", before: "peer-checked:before:bg-green-500" }, teal: { input: "checked:bg-teal-500", circle: "peer-checked:border-teal-500", before: "peer-checked:before:bg-teal-500" }, cyan: { input: "checked:bg-cyan-500", circle: "peer-checked:border-cyan-500", before: "peer-checked:before:bg-cyan-500" }, "light-blue": { input: "checked:bg-light-blue-500", circle: "peer-checked:border-light-blue-500", before: "peer-checked:before:bg-light-blue-500" }, blue: { input: "checked:bg-blue-500", circle: "peer-checked:border-blue-500", before: "peer-checked:before:bg-blue-500" }, indigo: { input: "checked:bg-indigo-500", circle: "peer-checked:border-indigo-500", before: "peer-checked:before:bg-indigo-500" }, "deep-purple": { input: "checked:bg-deep-purple-500", circle: "peer-checked:border-deep-purple-500", before: "peer-checked:before:bg-deep-purple-500" }, purple: { input: "checked:bg-purple-500", circle: "peer-checked:border-purple-500", before: "peer-checked:before:bg-purple-500" }, pink: { input: "checked:bg-pink-500", circle: "peer-checked:border-pink-500", before: "peer-checked:before:bg-pink-500" }, red: { input: "checked:bg-red-500", circle: "peer-checked:border-red-500", before: "peer-checked:before:bg-red-500" } };
    var _default = switchColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/switch/index.js
var require_switch = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/switch/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { switchButton: function() {
      return switchButton;
    }, default: function() {
      return _default;
    } });
    var _switchColors = _interopRequireDefault(require_switchColors());
    var _checkbox = require_checkbox();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var switchButton = { defaultProps: { color: "gray", label: "", ripple: true, className: "", disabled: false, containerProps: void 0, labelProps: void 0, circleProps: void 0 }, valid: { colors: _checkbox.propTypesColor }, styles: { base: { root: { display: "inline-flex", alignItems: "items-center" }, container: { position: "relative", display: "inline-block", width: "w-8", height: "h-4", cursor: "cursor-pointer", borderRadius: "rounded-full" }, input: { peer: "peer", appearance: "appearance-none", width: "w-8", height: "h-4", position: "absolute", background: "bg-blue-gray-100", borderRadius: "rounded-full", cursor: "cursor-pointer", transition: "transition-colors duration-300" }, circle: { bg: "bg-white", width: "w-5", height: "h-5", borderWidth: "border", borderColor: "border-blue-gray-100", borderRadius: "rounded-full", boxShadow: "shadow-md", position: "absolute", top: "top-2/4", left: "-left-1", transform: "-translate-y-2/4 peer-checked:translate-x-full", transition: "transition-all duration-300", cursor: "cursor-pointer", before: { content: "before:content['']", display: "before:block", bg: "before:bg-blue-gray-500", width: "before:w-10", height: "before:h-10", borderRadius: "before:rounded-full", position: "before:absolute", top: "before:top-2/4", left: "before:left-2/4", transform: "before:-translate-y-2/4 before:-translate-x-2/4", transition: "before:transition-opacity", opacity: "before:opacity-0 hover:before:opacity-10" } }, ripple: { display: "inline-block", top: "top-2/4", left: "left-2/4", transform: "-translate-x-2/4 -translate-y-2/4", p: "p-5", borderRadius: "rounded-full" }, label: { color: "text-gray-700", fontWeight: "font-light", userSelect: "select-none", cursor: "cursor-pointer", mt: "mt-px", ml: "ml-3", mb: "mb-0" }, disabled: { opacity: "opacity-50", pointerEvents: "pointer-events-none" } }, colors: _switchColors.default } };
    var _default = switchButton;
  }
});

// node_modules/@material-tailwind/react/theme/components/tabs/tab.js
var require_tab = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tabs/tab.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tab: function() {
      return tab;
    }, default: function() {
      return _default;
    } });
    var tab = { defaultProps: { className: "", activeClassName: "", disabled: false }, styles: { base: { tab: { initial: { display: "flex", alignItems: "items-center", justifyContent: "justify-center", textAlign: "text-center", width: "w-full", height: "h-full", position: "relative", bg: "bg-transparent", py: "py-1", px: "px-2", color: "text-blue-gray-900", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-normal", lineHeight: "leading-relaxed", userSelect: "select-none", cursor: "cursor-pointer" }, disabled: { opacity: "opacity-50", cursor: "cursor-not-allowed", pointerEvents: "pointer-events-none", userSelect: "select-none" } }, indicator: { position: "absolute", inset: "inset-0", zIndex: "z-10", height: "h-full", bg: "bg-white", borderRadius: "rounded-md", boxShadow: "shadow" } } } };
    var _default = tab;
  }
});

// node_modules/@material-tailwind/react/theme/components/tabs/index.js
var require_tabs = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tabs/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tabs: function() {
      return tabs;
    }, default: function() {
      return _default;
    } });
    var tabs = { defaultProps: { className: "", orientation: "horizontal" }, styles: { base: { overflow: "overflow-hidden" }, horizontal: { display: "block" }, vertical: { display: "flex" } } };
    var _default = tabs;
  }
});

// node_modules/@material-tailwind/react/theme/components/tabs/tabsBody.js
var require_tabsBody = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tabs/tabsBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tabsBody: function() {
      return tabsBody;
    }, default: function() {
      return _default;
    } });
    var tabsBody = { defaultProps: { animate: { unmount: {}, mount: {} }, className: "" }, styles: { base: { display: "block", width: "w-full", position: "relative", bg: "bg-transparent", overflow: "overflow-hidden" } } };
    var _default = tabsBody;
  }
});

// node_modules/@material-tailwind/react/theme/components/tabs/tabsHeader.js
var require_tabsHeader = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tabs/tabsHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tabsHeader: function() {
      return tabsHeader;
    }, default: function() {
      return _default;
    } });
    var tabsHeader = { defaultProps: { className: "" }, styles: { base: { display: "flex", position: "relative", bg: "bg-blue-gray-50", bgOpacity: "bg-opacity-60", borderRadius: "rounded-lg", p: "p-1" }, horizontal: { flexDirection: "flex-row" }, vertical: { flexDirection: "flex-col" } } };
    var _default = tabsHeader;
  }
});

// node_modules/@material-tailwind/react/theme/components/tabs/tabPanel.js
var require_tabPanel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tabs/tabPanel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tabPanel: function() {
      return tabPanel;
    }, default: function() {
      return _default;
    } });
    var tabPanel = { defaultProps: { className: "" }, styles: { base: { width: "w-full", height: "h-max", color: "text-gray-700", p: "p-4", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-light", lineHeight: "leading-relaxed" } } };
    var _default = tabPanel;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedLabel.js
var require_textareaOutlinedLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaOutlinedLabel = { position: "-top-1.5", fontSize: "peer-placeholder-shown:text-sm", floated: { fontSize: "text-[11px] peer-focus:text-[11px]" }, before: { content: "before:content[' ']", display: "before:block", boxSizing: "before:box-border", width: "before:w-2.5", height: "before:h-1.5", mt: "before:mt-[6.5px]", mr: "before:mr-1", borderColor: "peer-placeholder-shown:before:border-transparent", borderRadius: "before:rounded-tl-md", floated: { bt: "before:border-t peer-focus:before:border-t-2", bl: "before:border-l peer-focus:before:border-l-2" }, pointerEvents: "before:pointer-events-none", transition: "before:transition-all", disabled: "peer-disabled:before:border-transparent" }, after: { content: "after:content[' ']", display: "after:block", flexGrow: "after:flex-grow", boxSizing: "after:box-border", width: "after:w-2.5", height: "after:h-1.5", mt: "after:mt-[6.5px]", ml: "after:ml-1", borderColor: "peer-placeholder-shown:after:border-transparent", borderRadius: "after:rounded-tr-md", floated: { bt: "after:border-t peer-focus:after:border-t-2", br: "after:border-r peer-focus:after:border-r-2" }, pointerEvents: "after:pointer-events-none", transition: "after:transition-all", disabled: "peer-disabled:after:border-transparent" } };
    var _default = textareaOutlinedLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedColors.js
var require_textareaOutlinedColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaOutlinedColors = { "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-500" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-900" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = textareaOutlinedColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedLabelColors.js
var require_textareaOutlinedLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/textareaOutlinedLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaOutlinedLabelColors = { "blue-gray": { color: "text-blue-gray-400 peer-focus:text-blue-gray-500", before: "before:border-blue-gray-200 peer-focus:before:!border-blue-gray-500", after: "after:border-blue-gray-200 peer-focus:after:!border-blue-gray-500" }, gray: { color: "text-blue-gray-400 peer-focus:text-gray-900", before: "before:border-blue-gray-200 peer-focus:before:!border-gray-900", after: "after:border-blue-gray-200 peer-focus:after:!border-gray-900" }, brown: { color: "text-blue-gray-400 peer-focus:text-brown-500", before: "before:border-blue-gray-200 peer-focus:before:!border-brown-500", after: "after:border-blue-gray-200 peer-focus:after:!border-brown-500" }, "deep-orange": { color: "text-blue-gray-400 peer-focus:text-deep-orange-500", before: "before:border-blue-gray-200 peer-focus:before:!border-deep-orange-500", after: "after:border-blue-gray-200 peer-focus:after:!border-deep-orange-500" }, orange: { color: "text-blue-gray-400 peer-focus:text-orange-500", before: "before:border-blue-gray-200 peer-focus:before:!border-orange-500", after: "after:border-blue-gray-200 peer-focus:after:!border-orange-500" }, amber: { color: "text-blue-gray-400 peer-focus:text-amber-500", before: "before:border-blue-gray-200 peer-focus:before:!border-amber-500", after: "after:border-blue-gray-200 peer-focus:after:!border-amber-500" }, yellow: { color: "text-blue-gray-400 peer-focus:text-yellow-500", before: "before:border-blue-gray-200 peer-focus:before:!border-yellow-500", after: "after:border-blue-gray-200 peer-focus:after:!border-yellow-500" }, lime: { color: "text-blue-gray-400 peer-focus:text-lime-500", before: "before:border-blue-gray-200 peer-focus:before:!border-lime-500", after: "after:border-blue-gray-200 peer-focus:after:!border-lime-500" }, "light-green": { color: "text-blue-gray-400 peer-focus:text-light-green-500", before: "before:border-blue-gray-200 peer-focus:before:!border-light-green-500", after: "after:border-blue-gray-200 peer-focus:after:!border-light-green-500" }, green: { color: "text-blue-gray-400 peer-focus:text-green-500", before: "before:border-blue-gray-200 peer-focus:before:!border-green-500", after: "after:border-blue-gray-200 peer-focus:after:!border-green-500" }, teal: { color: "text-blue-gray-400 peer-focus:text-teal-500", before: "before:border-blue-gray-200 peer-focus:before:!border-teal-500", after: "after:border-blue-gray-200 peer-focus:after:!border-teal-500" }, cyan: { color: "text-blue-gray-400 peer-focus:text-cyan-500", before: "before:border-blue-gray-200 peer-focus:before:!border-cyan-500", after: "after:border-blue-gray-200 peer-focus:after:!border-cyan-500" }, "light-blue": { color: "text-blue-gray-400 peer-focus:text-light-blue-500", before: "before:border-blue-gray-200 peer-focus:before:!border-light-blue-500", after: "after:border-blue-gray-200 peer-focus:after:!border-light-blue-500" }, blue: { color: "text-blue-gray-400 peer-focus:text-blue-500", before: "before:border-blue-gray-200 peer-focus:before:!border-blue-500", after: "after:border-blue-gray-200 peer-focus:after:!border-blue-500" }, indigo: { color: "text-blue-gray-400 peer-focus:text-indigo-500", before: "before:border-blue-gray-200 peer-focus:before:!border-indigo-500", after: "after:border-blue-gray-200 peer-focus:after:!border-indigo-500" }, "deep-purple": { color: "text-blue-gray-400 peer-focus:text-deep-purple-500", before: "before:border-blue-gray-200 peer-focus:before:!border-deep-purple-500", after: "after:border-blue-gray-200 peer-focus:after:!border-deep-purple-500" }, purple: { color: "text-blue-gray-400 peer-focus:text-purple-500", before: "before:border-blue-gray-200 peer-focus:before:!border-purple-500", after: "after:border-blue-gray-200 peer-focus:after:!border-purple-500" }, pink: { color: "text-blue-gray-400 peer-focus:text-pink-500", before: "before:border-blue-gray-200 peer-focus:before:!border-pink-500", after: "after:border-blue-gray-200 peer-focus:after:!border-pink-500" }, red: { color: "text-blue-gray-400 peer-focus:text-red-500", before: "before:border-blue-gray-200 peer-focus:before:!border-red-500", after: "after:border-blue-gray-200 peer-focus:after:!border-red-500" } };
    var _default = textareaOutlinedLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/index.js
var require_textareaOutlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaOutlined/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _textareaOutlinedLabel = _interopRequireDefault(require_textareaOutlinedLabel());
    var _textareaOutlinedColors = _interopRequireDefault(require_textareaOutlinedColors());
    var _textareaOutlinedLabelColors = _interopRequireDefault(require_textareaOutlinedLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var textareaOutlined = { base: { textarea: { borderWidth: "placeholder-shown:border", borderColor: "placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200", floated: { borderWidth: "border focus:border-2", borderColor: "border-t-transparent focus:border-t-transparent" } }, label: _textareaOutlinedLabel.default }, sizes: { md: { container: { height: "h-10" }, textarea: { fontSize: "text-sm", px: "px-3", py: "py-2.5", borderRadius: "rounded-[7px]" }, label: { lineHeight: "peer-placeholder-shown:leading-[3.75]" } }, lg: { container: { height: "h-11" }, textarea: { fontSize: "text-sm", px: "px-3", py: "py-3", borderRadius: "rounded-md" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.1]" } } }, colors: { textarea: _textareaOutlinedColors.default, label: _textareaOutlinedLabelColors.default }, error: { textarea: { borderColor: "border-red-500 placeholder-shown:border-t-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", before: "before:border-red-500 peer-focus:before:border-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { textarea: { borderColor: "border-green-500 placeholder-shown:border-t-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", before: "before:border-green-500 peer-focus:before:border-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { textarea: { borderTop: "!border-t-transparent" }, label: { fontSize: "!text-[11px]", lineHeight: "!leading-tight", borderColor: "before:!border-blue-gray-200 after:!border-blue-gray-200" } } };
    var _default = textareaOutlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardLabel.js
var require_textareaStandardLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStandardLabel = { position: "-top-1.5", fontSize: "peer-placeholder-shown:text-sm", floated: { fontSize: "text-[11px] peer-focus:text-[11px]" }, after: { content: "after:content[' ']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-0", left: "left-0", borderWidth: "after:border-b-2", scale: "after:scale-x-0", floated: { scale: "peer-focus:after:scale-x-100" }, transition: "after:transition-transform after:duration-300" } };
    var _default = textareaStandardLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardColors.js
var require_textareaStandardColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStandardColors = { "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-500" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-900" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = textareaStandardColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardLabelColors.js
var require_textareaStandardLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/textareaStandardLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStandardLabelColors = { "blue-gray": { color: "text-blue-gray-500 peer-focus:text-blue-gray-500", after: "after:border-blue-gray-500 peer-focus:after:!border-blue-gray-500" }, gray: { color: "text-gray-500 peer-focus:text-gray-900", after: "after:border-gray-500 peer-focus:after:!border-gray-900" }, brown: { color: "text-blue-gray-500 peer-focus:text-brown-500", after: "after:border-brown-500 peer-focus:after:!border-brown-500" }, "deep-orange": { color: "text-blue-gray-500 peer-focus:text-deep-orange-500", after: "after:border-deep-orange-500 peer-focus:after:!border-deep-orange-500" }, orange: { color: "text-blue-gray-500 peer-focus:text-orange-500", after: "after:border-orange-500 peer-focus:after:!border-orange-500" }, amber: { color: "text-blue-gray-500 peer-focus:text-amber-500", after: "after:border-amber-500 peer-focus:after:!border-amber-500" }, yellow: { color: "text-blue-gray-500 peer-focus:text-yellow-500", after: "after:border-yellow-500 peer-focus:after:!border-yellow-500" }, lime: { color: "text-blue-gray-500 peer-focus:text-lime-500", after: "after:border-lime-500 peer-focus:after:!border-lime-500" }, "light-green": { color: "text-blue-gray-500 peer-focus:text-light-green-500", after: "after:border-light-green-500 peer-focus:after:!border-light-green-500" }, green: { color: "text-blue-gray-500 peer-focus:text-green-500", after: "after:border-green-500 peer-focus:after:!border-green-500" }, teal: { color: "text-blue-gray-500 peer-focus:text-teal-500", after: "after:border-teal-500 peer-focus:after:!border-teal-500" }, cyan: { color: "text-blue-gray-500 peer-focus:text-cyan-500", after: "after:border-cyan-500 peer-focus:after:!border-cyan-500" }, "light-blue": { color: "text-blue-gray-500 peer-focus:text-light-blue-500", after: "after:border-light-blue-500 peer-focus:after:!border-light-blue-500" }, blue: { color: "text-blue-gray-500 peer-focus:text-blue-500", after: "after:border-blue-500 peer-focus:after:!border-blue-500" }, indigo: { color: "text-blue-gray-500 peer-focus:text-indigo-500", after: "after:border-indigo-500 peer-focus:after:!border-indigo-500" }, "deep-purple": { color: "text-blue-gray-500 peer-focus:text-deep-purple-500", after: "after:border-deep-purple-500 peer-focus:after:!border-deep-purple-500" }, purple: { color: "text-blue-gray-500 peer-focus:text-purple-500", after: "after:border-purple-500 peer-focus:after:!border-purple-500" }, pink: { color: "text-blue-gray-500 peer-focus:text-pink-500", after: "after:border-pink-500 peer-focus:after:!border-pink-500" }, red: { color: "text-blue-gray-500 peer-focus:text-red-500", after: "after:border-red-500 peer-focus:after:!border-red-500" } };
    var _default = textareaStandardLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/index.js
var require_textareaStandard = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStandard/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _textareaStandardLabel = _interopRequireDefault(require_textareaStandardLabel());
    var _textareaStandardColors = _interopRequireDefault(require_textareaStandardColors());
    var _textareaStandardLabelColors = _interopRequireDefault(require_textareaStandardLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var textareaStandard = { base: { textarea: { borderWidth: "border-b", borderColor: "placeholder-shown:border-blue-gray-200" }, label: _textareaStandardLabel.default }, sizes: { md: { container: { height: "h-11" }, textarea: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5", mt: "mt-1.5" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.25]" } }, lg: { container: { height: "h-12" }, textarea: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { lineHeight: "peer-placeholder-shown:leading-[4.875]" } } }, colors: { textarea: _textareaStandardColors.default, label: _textareaStandardLabelColors.default }, error: { textarea: { borderColor: "border-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { textarea: { borderColor: "border-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { textarea: {}, label: { fontSize: "!text-[11px]", lineHeight: "!leading-tight" } } };
    var _default = textareaStandard;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticLabel.js
var require_textareaStaticLabel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticLabel.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStaticLabel = { position: "-top-2.5", fontSize: "text-sm peer-focus:text-sm", after: { content: "after:content[' ']", display: "after:block", width: "after:w-full", position: "after:absolute", bottom: "after:-bottom-1", left: "left-0", borderWidth: "after:border-b-2", scale: "after:scale-x-0", floated: { scale: "peer-focus:after:scale-x-100" }, transition: "after:transition-transform after:duration-300" } };
    var _default = textareaStaticLabel;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticColors.js
var require_textareaStaticColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStaticColors = { "blue-gray": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-gray-500" }, gray: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-gray-900" }, brown: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-brown-500" }, "deep-orange": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-orange-500" }, orange: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-orange-500" }, amber: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-amber-500" }, yellow: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-yellow-500" }, lime: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-lime-500" }, "light-green": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-green-500" }, green: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-green-500" }, teal: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-teal-500" }, cyan: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-cyan-500" }, "light-blue": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-light-blue-500" }, blue: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-blue-500" }, indigo: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-indigo-500" }, "deep-purple": { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-deep-purple-500" }, purple: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-purple-500" }, pink: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-pink-500" }, red: { borderColor: "border-blue-gray-200", borderColorFocused: "focus:border-red-500" } };
    var _default = textareaStaticColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticLabelColors.js
var require_textareaStaticLabelColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/textareaStaticLabelColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var textareaStaticLabelColors = { "blue-gray": { color: "text-blue-gray-500 peer-focus:text-blue-gray-500", after: "after:border-blue-gray-500 peer-focus:after:border-blue-gray-500" }, gray: { color: "text-gray-500 peer-focus:text-gray-900", after: "after:border-gray-500 peer-focus:after:border-gray-900" }, brown: { color: "text-blue-gray-500 peer-focus:text-brown-500", after: "after:border-brown-500 peer-focus:after:border-brown-500" }, "deep-orange": { color: "text-blue-gray-500 peer-focus:text-deep-orange-500", after: "after:border-deep-orange-500 peer-focus:after:border-deep-orange-500" }, orange: { color: "text-blue-gray-500 peer-focus:text-orange-500", after: "after:border-orange-500 peer-focus:after:border-orange-500" }, amber: { color: "text-blue-gray-500 peer-focus:text-amber-500", after: "after:border-amber-500 peer-focus:after:border-amber-500" }, yellow: { color: "text-blue-gray-500 peer-focus:text-yellow-500", after: "after:border-yellow-500 peer-focus:after:border-yellow-500" }, lime: { color: "text-blue-gray-500 peer-focus:text-lime-500", after: "after:border-lime-500 peer-focus:after:border-lime-500" }, "light-green": { color: "text-blue-gray-500 peer-focus:text-light-green-500", after: "after:border-light-green-500 peer-focus:after:border-light-green-500" }, green: { color: "text-blue-gray-500 peer-focus:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" }, teal: { color: "text-blue-gray-500 peer-focus:text-teal-500", after: "after:border-teal-500 peer-focus:after:border-teal-500" }, cyan: { color: "text-blue-gray-500 peer-focus:text-cyan-500", after: "after:border-cyan-500 peer-focus:after:border-cyan-500" }, "light-blue": { color: "text-blue-gray-500 peer-focus:text-light-blue-500", after: "after:border-light-blue-500 peer-focus:after:border-light-blue-500" }, blue: { color: "text-blue-gray-500 peer-focus:text-blue-500", after: "after:border-blue-500 peer-focus:after:border-blue-500" }, indigo: { color: "text-blue-gray-500 peer-focus:text-indigo-500", after: "after:border-indigo-500 peer-focus:after:border-indigo-500" }, "deep-purple": { color: "text-blue-gray-500 peer-focus:text-deep-purple-500", after: "after:border-deep-purple-500 peer-focus:after:border-deep-purple-500" }, purple: { color: "text-blue-gray-500 peer-focus:text-purple-500", after: "after:border-purple-500 peer-focus:after:border-purple-500" }, pink: { color: "text-blue-gray-500 peer-focus:text-pink-500", after: "after:border-pink-500 peer-focus:after:border-pink-500" }, red: { color: "text-blue-gray-500 peer-focus:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } };
    var _default = textareaStaticLabelColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/index.js
var require_textareaStatic = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/textareaStatic/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _textareaStaticLabel = _interopRequireDefault(require_textareaStaticLabel());
    var _textareaStaticColors = _interopRequireDefault(require_textareaStaticColors());
    var _textareaStaticLabelColors = _interopRequireDefault(require_textareaStaticLabelColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var textareaStatic = { base: { textarea: { borderWidth: "border-b", borderColor: "placeholder-shown:border-blue-gray-200" }, label: _textareaStaticLabel.default }, sizes: { md: { container: { height: "h-11" }, textarea: { fontSize: "text-sm", pt: "pt-4", pb: "pb-1.5", mt: "mt-1.5" }, label: { lineHeight: "peer-placeholder-shown:leading-tight" } }, lg: { container: { height: "h-12" }, textarea: { fontSize: "text-sm", px: "px-px", pt: "pt-5", pb: "pb-2" }, label: { lineHeight: "peer-placeholder-shown:leading-tight" } } }, colors: { textarea: _textareaStaticColors.default, label: _textareaStaticLabelColors.default }, error: { textarea: { borderColor: "border-red-500 placeholder-shown:border-red-500", borderColorFocused: "focus:border-red-500" }, label: { color: "text-red-500 peer-focus:text-red-500 peer-placeholder-shown:text-red-500", after: "after:border-red-500 peer-focus:after:border-red-500" } }, success: { textarea: { borderColor: "border-green-500 placeholder-shown:border-green-500", borderColorFocused: "focus:border-green-500" }, label: { color: "text-green-500 peer-focus:text-green-500 peer-placeholder-shown:text-green-500", after: "after:border-green-500 peer-focus:after:border-green-500" } }, shrink: { textarea: {}, label: {} } };
    var _default = textareaStatic;
  }
});

// node_modules/@material-tailwind/react/theme/components/textarea/index.js
var require_textarea = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/textarea/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { textarea: function() {
      return textarea;
    }, default: function() {
      return _default;
    } });
    var _textareaOutlined = _interopRequireDefault(require_textareaOutlined());
    var _textareaStandard = _interopRequireDefault(require_textareaStandard());
    var _textareaStatic = _interopRequireDefault(require_textareaStatic());
    var _input = require_input();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var textarea = { defaultProps: { variant: "outlined", size: "md", color: "gray", label: "", error: false, success: false, resize: true, labelProps: void 0, containerProps: void 0, shrink: false, className: "" }, valid: { variants: _input.propTypesVariant, sizes: _input.propTypesSize, colors: _input.propTypesColor }, styles: { base: { container: { position: "relative", width: "w-full", minWidth: "min-w-[200px]" }, textarea: { peer: "peer", width: "w-full", height: "h-full", minHeight: "min-h-[100px]", bg: "bg-transparent", color: "text-blue-gray-700", fontFamily: "font-sans", fontWeight: "font-normal", outline: "outline outline-0 focus:outline-0", resize: "resize-y", disabled: "disabled:bg-blue-gray-50 disabled:border-0 disabled:resize-none disabled:cursor-not-allowed", transition: "transition-all" }, label: { display: "flex", width: "w-full", height: "h-full", userSelect: "select-none", pointerEvents: "pointer-events-none", position: "absolute", left: "left-0", fontWeight: "font-normal", color: "peer-placeholder-shown:text-blue-gray-500", lineHeight: "leading-tight peer-focus:leading-tight", disabled: "peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500", transition: "transition-all" }, asterisk: { display: "inline-block", color: "text-red-500", ml: "ml-0.5" } }, variants: { outlined: _textareaOutlined.default, standard: _textareaStandard.default, static: _textareaStatic.default } } };
    var _default = textarea;
  }
});

// node_modules/@material-tailwind/react/theme/components/tooltip/index.js
var require_tooltip = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/tooltip/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { tooltip: function() {
      return tooltip;
    }, default: function() {
      return _default;
    } });
    var tooltip = { defaultProps: { interactive: false, placement: "top", offset: 5, dismiss: {}, animate: { unmount: {}, mount: {} }, className: "" }, styles: { base: { bg: "bg-black", py: "py-1.5", px: "px-3", borderRadius: "rounded-lg", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-normal", color: "text-white", outline: "focus:outline-none", overflowWrap: "break-words", zIndex: "z-[999]", whiteSpace: "whitespace-normal" } } };
    var _default = tooltip;
  }
});

// node_modules/@material-tailwind/react/theme/components/typography/typographyColors.js
var require_typographyColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/typography/typographyColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var typographyColors = { inherit: { color: "text-inherit" }, current: { color: "text-current" }, black: { color: "text-black" }, white: { color: "text-white" }, "blue-gray": { color: "text-blue-gray-900", gradient: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400" }, gray: { color: "text-gray-700", gradient: "bg-gradient-to-tr from-gray-600 to-gray-400" }, brown: { color: "text-brown-500", gradient: "bg-gradient-to-tr from-brown-600 to-brown-400" }, "deep-orange": { color: "text-deep-orange-500", gradient: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400" }, orange: { color: "text-orange-500", gradient: "bg-gradient-to-tr from-orange-600 to-orange-400" }, amber: { color: "text-amber-500", gradient: "bg-gradient-to-tr from-amber-600 to-amber-400" }, yellow: { color: "text-yellow-500", gradient: "bg-gradient-to-tr from-yellow-600 to-yellow-400" }, lime: { color: "text-lime-500", gradient: "bg-gradient-to-tr from-lime-600 to-lime-400" }, "light-green": { color: "text-light-green-500", gradient: "bg-gradient-to-tr from-light-green-600 to-light-green-400" }, green: { color: "text-green-500", gradient: "bg-gradient-to-tr from-green-600 to-green-400" }, teal: { color: "text-teal-500", gradient: "bg-gradient-to-tr from-teal-600 to-teal-400" }, cyan: { color: "text-cyan-500", gradient: "bg-gradient-to-tr from-cyan-600 to-cyan-400" }, "light-blue": { color: "text-light-blue-500", gradient: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400" }, blue: { color: "text-blue-500", gradient: "bg-gradient-to-tr from-blue-600 to-blue-400" }, indigo: { color: "text-indigo-500", gradient: "bg-gradient-to-tr from-indigo-600 to-indigo-400" }, "deep-purple": { color: "text-deep-purple-500", gradient: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400" }, purple: { color: "text-purple-500", gradient: "bg-gradient-to-tr from-purple-600 to-purple-400" }, pink: { color: "text-pink-500", gradient: "bg-gradient-to-tr from-pink-600 to-pink-400" }, red: { color: "text-red-500", gradient: "bg-gradient-to-tr from-red-600 to-red-400" } };
    var _default = typographyColors;
  }
});

// node_modules/@material-tailwind/react/types/components/typography.js
var require_typography = __commonJS({
  "node_modules/@material-tailwind/react/types/components/typography.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesVariant: function() {
      return propTypesVariant;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesAs: function() {
      return propTypesAs;
    }, propTypesTextGradient: function() {
      return propTypesTextGradient;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesVariant = ["h1", "h2", "h3", "h4", "h5", "h6", "lead", "paragraph", "small"];
    var propTypesColor = ["inherit", "current", "black", "white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesAs = _propTypes.default.elementType;
    var propTypesTextGradient = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/theme/components/typography/index.js
var require_typography2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/typography/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { typography: function() {
      return typography;
    }, default: function() {
      return _default;
    } });
    var _typographyColors = _interopRequireDefault(require_typographyColors());
    var _typography = require_typography();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var typography = { defaultProps: { variant: "paragraph", color: "inherit", textGradient: false, className: "" }, valid: { variants: _typography.propTypesVariant, colors: _typography.propTypesColor }, styles: { variants: { h1: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-5xl", fontWeight: "font-semibold", lineHeight: "leading-tight" }, h2: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-4xl", fontWeight: "font-semibold", lineHeight: "leading-[1.3]" }, h3: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-3xl", fontWeight: "font-semibold", lineHeight: "leading-snug" }, h4: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-2xl", fontWeight: "font-semibold", lineHeight: "leading-snug" }, h5: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-xl", fontWeight: "font-semibold", lineHeight: "leading-snug" }, h6: { display: "block", fontSmoothing: "antialiased", letterSpacing: "tracking-normal", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-semibold", lineHeight: "leading-relaxed" }, lead: { display: "block", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-xl", fontWeight: "font-normal", lineHeight: "leading-relaxed" }, paragraph: { display: "block", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-light", lineHeight: "leading-relaxed" }, small: { display: "block", fontSmoothing: "antialiased", fontFamily: "font-sans", fontSize: "text-sm", fontWeight: "font-light", lineHeight: "leading-normal" } }, textGradient: { bgClip: "bg-clip-text", color: "text-transparent" }, colors: _typographyColors.default } };
    var _default = typography;
  }
});

// node_modules/@material-tailwind/react/theme/components/collapse/index.js
var require_collapse = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/collapse/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { collapse: function() {
      return collapse;
    }, default: function() {
      return _default;
    } });
    var collapse = { defaultProps: { animate: { unmount: {}, mount: {} }, className: "" }, styles: { base: { display: "block", width: "w-full", basis: "basis-full", overflow: "overflow-hidden" } } };
    var _default = collapse;
  }
});

// node_modules/@material-tailwind/react/theme/components/list/index.js
var require_list = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/list/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { list: function() {
      return list;
    }, default: function() {
      return _default;
    } });
    var list = { defaultProps: { ripple: true, className: "" }, styles: { base: { list: { display: "flex", flexDirection: "flex-col", gap: "gap-1", minWidth: "min-w-[240px]", p: "p-2", fontFamily: "font-sans", fontSize: "text-base", fontWeight: "font-normal", color: "text-blue-gray-700" }, item: { initial: { display: "flex", alignItems: "items-center", width: "w-full", padding: "p-3", borderRadius: "rounded-lg", textAlign: "text-start", lightHeight: "leading-tight", transition: "transition-all", bg: "hover:bg-blue-gray-50 hover:bg-opacity-80 focus:bg-blue-gray-50 focus:bg-opacity-80 active:bg-blue-gray-50 active:bg-opacity-80", color: "hover:text-blue-gray-900 focus:text-blue-gray-900 active:text-blue-gray-900", outline: "outline-none" }, selected: { bg: "bg-blue-gray-50/50", color: "text-blue-gray-700" }, disabled: { opacity: "opacity-50", cursor: "cursor-not-allowed", pointerEvents: "pointer-events-none", userSelect: "select-none", bg: "hover:bg-transparent focus:bg-transparent active:bg-transparent", color: "hover:text-blue-gray-500 focus:text-blue-gray-500 active:text-blue-gray-500" } }, itemPrefix: { display: "grid", placeItems: "place-items-center", marginRight: "mr-4" }, itemSuffix: { display: "grid", placeItems: "place-items-center", marginRight: "ml-auto justify-self-end" } } } };
    var _default = list;
  }
});

// node_modules/@material-tailwind/react/theme/components/buttonGroup/buttonGroupDividerColor.js
var require_buttonGroupDividerColor = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/buttonGroup/buttonGroupDividerColor.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var buttonGroupDividerColor = { white: { divideColor: "divide-blue-gray-50" }, black: { divideColor: "divide-gray-800" }, "blue-gray": { divideColor: "divide-blue-gray-600" }, gray: { divideColor: "divide-gray-800" }, brown: { divideColor: "divide-brown-600" }, "deep-orange": { divideColor: "divide-deep-orange-600" }, orange: { divideColor: "divide-orange-600" }, amber: { divideColor: "divide-amber-600" }, yellow: { divideColor: "divide-yellow-600" }, lime: { divideColor: "divide-lime-600" }, "light-green": { divideColor: "divide-light-green-600" }, green: { divideColor: "divide-green-600" }, teal: { divideColor: "divide-teal-600" }, cyan: { divideColor: "divide-cyan-600" }, "light-blue": { divideColor: "divide-light-blue-600" }, blue: { divideColor: "divide-blue-600" }, indigo: { divideColor: "divide-indigo-600" }, "deep-purple": { divideColor: "divide-deep-purple-600" }, purple: { divideColor: "divide-purple-600" }, pink: { divideColor: "divide-pink-600" }, red: { divideColor: "divide-red-600" } };
    var _default = buttonGroupDividerColor;
  }
});

// node_modules/@material-tailwind/react/theme/components/buttonGroup/index.js
var require_buttonGroup = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/buttonGroup/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { buttonGroup: function() {
      return buttonGroup;
    }, default: function() {
      return _default;
    } });
    var _buttonGroupDividerColor = _interopRequireDefault(require_buttonGroupDividerColor());
    var _button = require_button();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var buttonGroup = { defaultProps: { variant: "filled", size: "md", color: "gray", fullWidth: false, ripple: true, className: "" }, valid: { variants: _button.propTypesVariant, sizes: _button.propTypesSize, colors: _button.propTypesColor }, styles: { base: { initial: { display: "flex", flexDirection: "row" }, fullWidth: { width: "w-full" } }, dividerColor: _buttonGroupDividerColor.default } };
    var _default = buttonGroup;
  }
});

// node_modules/@material-tailwind/react/theme/components/carousel/index.js
var require_carousel = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/carousel/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { carousel: function() {
      return carousel;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var carousel = { defaultProps: { prevArrow: function(param) {
      var loop = param.loop, handlePrev = param.handlePrev, firstIndex = param.firstIndex;
      return _react.default.createElement("button", { onClick: handlePrev, disabled: !loop && firstIndex, className: "!absolute top-2/4 left-4 -translate-y-2/4 rounded-full select-none transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none w-12 max-w-[48px] h-12 max-h-[48px] text-white hover:bg-white/10 active:bg-white/30 grid place-items-center" }, _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", stroke: "currentColor", strokeWidth: 3, className: "-ml-1 h-7 w-7" }, _react.default.createElement("path", { strokeLinecap: "round", strokeLinejoin: "round", d: "M15.75 19.5L8.25 12l7.5-7.5" })));
    }, nextArrow: function(param) {
      var loop = param.loop, handleNext = param.handleNext, lastIndex = param.lastIndex;
      return _react.default.createElement("button", { onClick: handleNext, disabled: !loop && lastIndex, className: "!absolute top-2/4 right-4 -translate-y-2/4 rounded-full select-none transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none w-12 max-w-[48px] h-12 max-h-[48px] text-white hover:bg-white/10 active:bg-white/30 grid place-items-center" }, _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", stroke: "currentColor", strokeWidth: 3, className: "ml-1 h-7 w-7" }, _react.default.createElement("path", { strokeLinecap: "round", strokeLinejoin: "round", d: "M8.25 4.5l7.5 7.5-7.5 7.5" })));
    }, navigation: function(param) {
      var setActiveIndex = param.setActiveIndex, activeIndex = param.activeIndex, length2 = param.length;
      return _react.default.createElement("div", { className: "absolute bottom-4 left-2/4 z-50 flex -translate-x-2/4 gap-2" }, new Array(length2).fill("").map(function(_, i) {
        return _react.default.createElement("span", { key: i, className: "block h-3 w-3 cursor-pointer rounded-full transition-colors content-[''] ".concat(activeIndex === i ? "bg-white" : "bg-white/50"), onClick: function() {
          return setActiveIndex(i);
        } });
      }));
    }, autoplay: false, autoplayDelay: 5e3, transition: { type: "tween", duration: 0.5 }, loop: false, className: "" }, styles: { base: { carousel: { position: "relative", width: "w-full", height: "h-full", overflowX: "overflow-x-hidden", display: "flex" }, slide: { width: "w-full", height: "h-full", display: "inline-block", flex: "flex-none" } } } };
    var _default = carousel;
  }
});

// node_modules/@material-tailwind/react/theme/components/drawer/index.js
var require_drawer = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/drawer/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { drawer: function() {
      return drawer;
    }, default: function() {
      return _default;
    } });
    var drawer = { defaultProps: { size: 300, overlay: true, placement: "left", overlayProps: void 0, className: "", dismiss: void 0, onClose: void 0, transition: { type: "tween", duration: 0.3 } }, styles: { base: { drawer: { position: "fixed", zIndex: "z-[9999]", pointerEvents: "pointer-events-auto", backgroundColor: "bg-white", boxSizing: "box-border", width: "w-full", boxShadow: "shadow-2xl shadow-blue-gray-900/10" }, overlay: { position: "absolute", inset: "inset-0", width: "w-full", height: "h-full", pointerEvents: "pointer-events-auto", zIndex: "z-[9995]", backgroundColor: "bg-black", backgroundOpacity: "bg-opacity-60", backdropBlur: "backdrop-blur-sm" } } } };
    var _default = drawer;
  }
});

// node_modules/@material-tailwind/react/types/components/badge.js
var require_badge = __commonJS({
  "node_modules/@material-tailwind/react/types/components/badge.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesColor: function() {
      return propTypesColor;
    }, propTypesInvisible: function() {
      return propTypesInvisible;
    }, propTypesWithBorder: function() {
      return propTypesWithBorder;
    }, propTypesOverlap: function() {
      return propTypesOverlap;
    }, propTypesPlacement: function() {
      return propTypesPlacement;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesContent: function() {
      return propTypesContent;
    }, propTypesChildren: function() {
      return propTypesChildren;
    }, propTypesContainerProps: function() {
      return propTypesContainerProps;
    }, propTypesContainerRef: function() {
      return propTypesContainerRef;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesColor = ["white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesInvisible = _propTypes.default.bool;
    var propTypesWithBorder = _propTypes.default.bool;
    var propTypesOverlap = ["circular", "square"];
    var propTypesPlacement = ["top-start", "top-end", "bottom-start", "bottom-end"];
    var propTypesClassName = _propTypes.default.string;
    var propTypesContent = _propTypes.default.node;
    var propTypesChildren = _propTypes.default.node.isRequired;
    var propTypesContainerProps = _propTypes.default.instanceOf(Object);
    var propTypesContainerRef = _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({ current: _propTypes.default.any })]);
  }
});

// node_modules/@material-tailwind/react/theme/components/badge/badgeColors.js
var require_badgeColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/badge/badgeColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var badgeColors = { white: { backgroud: "bg-white", color: "text-blue-gray-900" }, "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white" }, gray: { backgroud: "bg-gray-500", color: "text-white" }, brown: { backgroud: "bg-brown-500", color: "text-white" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white" }, orange: { backgroud: "bg-orange-500", color: "text-white" }, amber: { backgroud: "bg-amber-500", color: "text-black" }, yellow: { backgroud: "bg-yellow-500", color: "text-black" }, lime: { backgroud: "bg-lime-500", color: "text-black" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white" }, green: { backgroud: "bg-green-500", color: "text-white" }, teal: { backgroud: "bg-teal-500", color: "text-white" }, cyan: { backgroud: "bg-cyan-500", color: "text-white" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white" }, blue: { backgroud: "bg-blue-500", color: "text-white" }, indigo: { backgroud: "bg-indigo-500", color: "text-white" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white" }, purple: { backgroud: "bg-purple-500", color: "text-white" }, pink: { backgroud: "bg-pink-500", color: "text-white" }, red: { backgroud: "bg-red-500", color: "text-white" } };
    var _default = badgeColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/badge/index.js
var require_badge2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/badge/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { badge: function() {
      return badge;
    }, default: function() {
      return _default;
    } });
    var _badge = require_badge();
    var _badgeColors = _interopRequireDefault(require_badgeColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var badge = { defaultProps: { color: "red", invisible: false, withBorder: false, overlap: "square", content: void 0, placement: "top-end", className: void 0, containerProps: void 0 }, valid: { colors: _badge.propTypesColor, overlaps: _badge.propTypesOverlap, placements: _badge.propTypesPlacement }, styles: { base: { container: { position: "relative", display: "inline-flex" }, badge: { initial: { position: "absolute", minWidth: "min-w-[12px]", minHeight: "min-h-[12px]", borderRadius: "rounded-full", paddingY: "py-1", paddingX: "px-1", fontSize: "text-xs", fontWeight: "font-medium", content: "content-['']", lineHeight: "leading-none", display: "grid", placeItems: "place-items-center" }, withBorder: { borderWidth: "border-2", borderColor: "border-white" }, withContent: { minWidth: "min-w-[24px]", minHeight: "min-h-[24px]" } } }, placements: { "top-start": { square: { top: "top-[4%]", left: "left-[2%]", translateX: "-translate-x-2/4", translateY: "-translate-y-2/4" }, circular: { top: "top-[14%]", left: "left-[14%]", translateX: "-translate-x-2/4", translateY: "-translate-y-2/4" } }, "top-end": { square: { top: "top-[4%]", right: "right-[2%]", translateX: "translate-x-2/4", translateY: "-translate-y-2/4" }, circular: { top: "top-[14%]", right: "right-[14%]", translateX: "translate-x-2/4", translateY: "-translate-y-2/4" } }, "bottom-start": { square: { bottom: "bottom-[4%]", left: "left-[2%]", translateX: "-translate-x-2/4", translateY: "translate-y-2/4" }, circular: { bottom: "bottom-[14%]", left: "left-[14%]", translateX: "-translate-x-2/4", translateY: "translate-y-2/4" } }, "bottom-end": { square: { bottom: "bottom-[4%]", right: "right-[2%]", translateX: "translate-x-2/4", translateY: "translate-y-2/4" }, circular: { bottom: "bottom-[14%]", right: "right-[14%]", translateX: "translate-x-2/4", translateY: "translate-y-2/4" } } }, colors: _badgeColors.default } };
    var _default = badge;
  }
});

// node_modules/@material-tailwind/react/types/components/rating.js
var require_rating = __commonJS({
  "node_modules/@material-tailwind/react/types/components/rating.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesCount: function() {
      return propTypesCount;
    }, propTypesValue: function() {
      return propTypesValue;
    }, propTypesRatedIcon: function() {
      return propTypesRatedIcon;
    }, propTypesUnratedIcon: function() {
      return propTypesUnratedIcon;
    }, propTypesColor: function() {
      return propTypesColor;
    }, propTypesOnChange: function() {
      return propTypesOnChange;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesReadonly: function() {
      return propTypesReadonly;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesCount = _propTypes.default.number;
    var propTypesValue = _propTypes.default.number;
    var propTypesRatedIcon = _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.instanceOf(Object)]);
    var propTypesUnratedIcon = _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.instanceOf(Object)]);
    var propTypesColor = ["white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesOnChange = _propTypes.default.func;
    var propTypesClassName = _propTypes.default.string;
    var propTypesReadonly = _propTypes.default.bool;
  }
});

// node_modules/@material-tailwind/react/theme/components/rating/ratingColors.js
var require_ratingColors = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/rating/ratingColors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var ratingColors = { white: { color: "text-white" }, "blue-gray": { color: "text-blue-gray-500" }, gray: { color: "text-gray-500" }, brown: { color: "text-brown-500" }, "deep-orange": { color: "text-deep-orange-500" }, orange: { color: "text-orange-500" }, amber: { color: "text-amber-500" }, yellow: { color: "text-yellow-700" }, lime: { color: "text-lime-500" }, "light-green": { color: "text-light-green-500" }, green: { color: "text-green-500" }, teal: { color: "text-teal-500" }, cyan: { color: "text-cyan-500" }, "light-blue": { color: "text-light-blue-500" }, blue: { color: "text-blue-500" }, indigo: { color: "text-indigo-500" }, "deep-purple": { color: "text-deep-purple-500" }, purple: { color: "text-purple-500" }, pink: { color: "text-pink-500" }, red: { color: "text-red-500" } };
    var _default = ratingColors;
  }
});

// node_modules/@material-tailwind/react/theme/components/rating/index.js
var require_rating2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/rating/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { rating: function() {
      return rating;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _rating = require_rating();
    var _ratingColors = _interopRequireDefault(require_ratingColors());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var rating = { defaultProps: { count: 5, value: 0, ratedIcon: _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", fill: "currentColor", className: "w-6 h-6" }, _react.default.createElement("path", { fillRule: "evenodd", d: "M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.007 5.404.433c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.433 2.082-5.006z", clipRule: "evenodd" })), unratedIcon: _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", strokeWidth: 1.5, stroke: "currentColor", className: "w-6 h-6" }, _react.default.createElement("path", { strokeLinecap: "round", strokeLinejoin: "round", d: "M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" })), ratedColor: "yellow", unratedColor: "blue-gray", className: void 0, onChange: void 0, readonly: false }, valid: { colors: _rating.propTypesColor }, styles: { base: { rating: { display: "inline-flex", alignItems: "items-center" }, icon: { width: "w-5", height: "h-5", color: "text-inherit", cursor: "cursor-pointer" } }, colors: _ratingColors.default } };
    var _default = rating;
  }
});

// node_modules/@material-tailwind/react/types/components/slider.js
var require_slider = __commonJS({
  "node_modules/@material-tailwind/react/types/components/slider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesColor: function() {
      return propTypesColor;
    }, propTypesSize: function() {
      return propTypesSize;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesTrackClassName: function() {
      return propTypesTrackClassName;
    }, propTypesThumbClassName: function() {
      return propTypesThumbClassName;
    }, propTypesBarClassName: function() {
      return propTypesBarClassName;
    }, propTypesDefaultValue: function() {
      return propTypesDefaultValue;
    }, propTypesValue: function() {
      return propTypesValue;
    }, propTypesOnChange: function() {
      return propTypesOnChange;
    }, propTypesMin: function() {
      return propTypesMin;
    }, propTypesMax: function() {
      return propTypesMax;
    }, propTypesStep: function() {
      return propTypesStep;
    }, propTypesInputRef: function() {
      return propTypesInputRef;
    }, propTypesInputProps: function() {
      return propTypesInputProps;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesColor = _generic.propTypesColors;
    var propTypesSize = ["sm", "md", "lg"];
    var propTypesClassName = _propTypes.default.string;
    var propTypesTrackClassName = _propTypes.default.string;
    var propTypesThumbClassName = _propTypes.default.string;
    var propTypesBarClassName = _propTypes.default.string;
    var propTypesDefaultValue = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]);
    var propTypesValue = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]);
    var propTypesOnChange = _propTypes.default.func;
    var propTypesMin = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]);
    var propTypesMax = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]);
    var propTypesStep = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]);
    var propTypesInputRef = _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({ current: _propTypes.default.any })]);
    var propTypesInputProps = _propTypes.default.instanceOf(Object);
  }
});

// node_modules/@material-tailwind/react/theme/components/slider/sliderColor.js
var require_sliderColor = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/slider/sliderColor.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var sliderColor = { "blue-gray": { color: "text-blue-gray-500" }, gray: { color: "text-gray-900" }, brown: { color: "text-brown-500" }, "deep-orange": { color: "text-deep-orange-500" }, orange: { color: "text-orange-500" }, amber: { color: "text-amber-500" }, yellow: { color: "text-yellow-500" }, lime: { color: "text-lime-500" }, "light-green": { color: "text-light-green-500" }, green: { color: "text-green-500" }, teal: { color: "text-teal-500" }, cyan: { color: "text-cyan-500" }, "light-blue": { color: "text-light-blue-500" }, blue: { color: "text-blue-500" }, indigo: { color: "text-indigo-500" }, "deep-purple": { color: "text-deep-purple-500" }, purple: { color: "text-purple-500" }, pink: { color: "text-pink-500" }, red: { color: "text-red-500" } };
    var _default = sliderColor;
  }
});

// node_modules/@material-tailwind/react/theme/components/slider/index.js
var require_slider2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/slider/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { slider: function() {
      return slider;
    }, default: function() {
      return _default;
    } });
    var _slider = require_slider();
    var _sliderColor = _interopRequireDefault(require_sliderColor());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var slider = { defaultProps: { color: "gray", size: "md", min: void 0, max: void 0, step: "any", className: "", trackClassName: "", thumbClassName: "", barClassName: "", inputProps: void 0 }, valid: { sizes: _slider.propTypesSize, colors: _slider.propTypesColor }, styles: { base: { container: { position: "relative", width: "w-full", minWidth: "min-w-[200px]" }, slider: { width: "w-full", position: "absolute", inset: "inset-0", backgroundColor: "bg-transparent", cursor: "cursor-pointer", outline: "focus:outline-none focus:outline-0", appearance: "appearance-none [-webkit-appearance:none]" }, track: { height: "[&::-webkit-slider-runnable-track]:h-full [&::-moz-range-track]:h-full", borderRadius: "[&::-webkit-slider-runnable-track]:rounded-full [&::-moz-range-track]:rounded-full", backgroundColor: "[&::-webkit-slider-runnable-track]:bg-blue-gray-100 [&::-moz-range-track]:bg-blue-gray-100" }, thumb: { appearance: "[&::-moz-range-thumb]:appearance-none [&::-moz-range-thumb]:[-webkit-appearance:none] [&::-webkit-slider-thumb]:appearance-none [&::-webkit-slider-thumb]:[-webkit-appearance:none]", borderRadius: "[&::-moz-range-thumb]:rounded-full [&::-webkit-slider-thumb]:rounded-full", border: "[&::-moz-range-thumb]:border-0 [&::-webkit-slider-thumb]:border-0", ringWidth: "[&::-moz-range-thumb]:ring-2 [&::-webkit-slider-thumb]:ring-2", ringColor: "[&::-moz-range-thumb]:ring-current [&::-webkit-slider-thumb]:ring-current", backgroundColor: "[&::-moz-range-thumb]:bg-white [&::-webkit-slider-thumb]:bg-white", position: "[&::-moz-range-thumb]:relative [&::-webkit-slider-thumb]:relative", zIndex: "[&::-moz-range-thumb]:z-20 [&::-webkit-slider-thumb]:z-20" }, bar: { position: "absolute", inset: "inset-0", zIndex: "z-10", borderRadius: "rounded-l-full", height: "h-full", pointerEvents: "pointer-events-none", backgroundColor: "bg-current" } }, sizes: { sm: { container: { height: "h-1" }, thumb: { width: "[&::-moz-range-thumb]:w-2.5 [&::-webkit-slider-thumb]:w-2.5", height: "[&::-moz-range-thumb]:h-2.5 [&::-webkit-slider-thumb]:h-2.5", marginTop: "[&::-moz-range-thumb]:-mt-[3px] [&::-webkit-slider-thumb]:-mt-[3px]" }, slider: {}, track: {}, bar: {} }, md: { container: { height: "h-2" }, thumb: { width: "[&::-moz-range-thumb]:w-3.5 [&::-webkit-slider-thumb]:w-3.5", height: "[&::-moz-range-thumb]:h-3.5 [&::-webkit-slider-thumb]:h-3.5", marginTop: "[&::-moz-range-thumb]:-mt-[3px] [&::-webkit-slider-thumb]:-mt-[3px]" }, slider: {}, track: {}, bar: {} }, lg: { container: { height: "h-3" }, thumb: { width: "[&::-moz-range-thumb]:w-5 [&::-webkit-slider-thumb]:w-5", height: "[&::-moz-range-thumb]:h-5 [&::-webkit-slider-thumb]:h-5", marginTop: "[&::-moz-range-thumb]:-mt-1 [&::-webkit-slider-thumb]:-mt-1" }, slider: {}, track: {}, bar: {} } }, colors: _sliderColor.default } };
    var _default = slider;
  }
});

// node_modules/@material-tailwind/react/types/components/spinner.js
var require_spinner = __commonJS({
  "node_modules/@material-tailwind/react/types/components/spinner.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesColor: function() {
      return propTypesColor;
    }, propTypesClassName: function() {
      return propTypesClassName;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypesColor = ["white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypesClassName = _propTypes.default.string;
  }
});

// node_modules/@material-tailwind/react/theme/components/spinner/spinnerColor.js
var require_spinnerColor = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/spinner/spinnerColor.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var spinnerColor = { white: { color: "text-white" }, "blue-gray": { color: "text-blue-gray-500" }, gray: { color: "text-gray-900" }, brown: { color: "text-brown-500" }, "deep-orange": { color: "text-deep-orange-500" }, orange: { color: "text-orange-500" }, amber: { color: "text-amber-500" }, yellow: { color: "text-yellow-500" }, lime: { color: "text-lime-500" }, "light-green": { color: "text-light-green-500" }, green: { color: "text-green-500" }, teal: { color: "text-teal-500" }, cyan: { color: "text-cyan-500" }, "light-blue": { color: "text-light-blue-500" }, blue: { color: "text-blue-500" }, indigo: { color: "text-indigo-500" }, "deep-purple": { color: "text-deep-purple-500" }, purple: { color: "text-purple-500" }, pink: { color: "text-pink-500" }, red: { color: "text-red-500" } };
    var _default = spinnerColor;
  }
});

// node_modules/@material-tailwind/react/theme/components/spinner/index.js
var require_spinner2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/spinner/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { spinner: function() {
      return spinner;
    }, default: function() {
      return _default;
    } });
    var _spinner = require_spinner();
    var _spinnerColor = _interopRequireDefault(require_spinnerColor());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var spinner = { defaultProps: { color: "gray", className: "" }, valid: { colors: _spinner.propTypesColor }, styles: { base: { color: "text-gray-300", animation: "animate-spin" }, colors: _spinnerColor.default } };
    var _default = spinner;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timeline.js
var require_timeline = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timeline.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timeline: function() {
      return timeline2;
    }, default: function() {
      return _default;
    } });
    var timeline2 = { styles: { base: { display: "w-full", position: "flex", flexDirection: "flex-col" } } };
    var _default = timeline2;
  }
});

// node_modules/@material-tailwind/react/types/components/timeline.js
var require_timeline2 = __commonJS({
  "node_modules/@material-tailwind/react/types/components/timeline.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypeClassName: function() {
      return propTypeClassName;
    }, propTypeChildren: function() {
      return propTypeChildren;
    }, propTypeColor: function() {
      return propTypeColor;
    }, propTypeVariant: function() {
      return propTypeVariant;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(n);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    var propTypeClassName = _propTypes.default.string;
    var propTypeChildren = _propTypes.default.node;
    var propTypeColor = ["white"].concat(_toConsumableArray(_generic.propTypesColors));
    var propTypeVariant = ["filled", "outlined", "ghost", "gradient"];
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineItem.js
var require_timelineItem = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineItem.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timelineItem: function() {
      return timelineItem;
    }, default: function() {
      return _default;
    } });
    var _timeline = require_timeline2();
    var timelineItem = { defaultProps: { color: "gray", variant: "filled" }, valid: { colors: _timeline.propTypeColor, variants: _timeline.propTypeVariant }, styles: { base: { display: "flex", position: "relative", flexDirection: "flex-col", gap: "gap-2" } } };
    var _default = timelineItem;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/ghost.js
var require_ghost = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/ghost.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var ghost = { transparent: { backgroud: "bg-transparent", color: "text-blue-gray-900" }, white: { color: "text-white", background: "bg-white/10" }, "blue-gray": { color: "text-blue-gray-500", background: "bg-blue-gray-500/10" }, gray: { color: "text-gray-900", background: "bg-gray-900/10" }, brown: { color: "text-brown-500", background: "bg-brown-500/10" }, "deep-orange": { color: "text-deep-orange-500", background: "bg-deep-orange-500/10" }, orange: { color: "text-orange-500", background: "bg-orange-500/10" }, amber: { color: "text-amber-500", background: "bg-amber-500/10" }, yellow: { color: "text-yellow-500", background: "bg-yellow-500/10" }, lime: { color: "text-lime-500", background: "bg-lime-500/10" }, "light-green": { color: "text-light-green-500", background: "bg-light-green-500/10" }, green: { color: "text-green-500", background: "bg-green-500/10" }, teal: { color: "text-teal-500", background: "bg-teal-500/10" }, cyan: { color: "text-cyan-500", background: "bg-cyan-500/10" }, "light-blue": { color: "text-light-blue-500", background: "bg-light-blue-500/10" }, blue: { color: "text-blue-500", background: "bg-blue-500/10" }, indigo: { color: "text-indigo-500", background: "bg-indigo-500/10" }, "deep-purple": { color: "text-deep-purple-500", background: "bg-deep-purple-500/10" }, purple: { color: "text-purple-500", background: "bg-purple-500/10" }, pink: { color: "text-pink-500", background: "bg-pink-500/10" }, red: { color: "text-red-500", background: "bg-red-500/10" } };
    var _default = ghost;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/filled.js
var require_filled = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/filled.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var filled = { transparent: { backgroud: "bg-transparent", color: "text-blue-gray-900" }, white: { backgroud: "bg-white", color: "text-blue-gray-900" }, "blue-gray": { backgroud: "bg-blue-gray-500", color: "text-white" }, gray: { backgroud: "bg-gray-900", color: "text-white" }, brown: { backgroud: "bg-brown-500", color: "text-white" }, "deep-orange": { backgroud: "bg-deep-orange-500", color: "text-white" }, orange: { backgroud: "bg-orange-500", color: "text-white" }, amber: { backgroud: "bg-amber-500", color: "text-black" }, yellow: { backgroud: "bg-yellow-500", color: "text-black" }, lime: { backgroud: "bg-lime-500", color: "text-black" }, "light-green": { backgroud: "bg-light-green-500", color: "text-white" }, green: { backgroud: "bg-green-500", color: "text-white" }, teal: { backgroud: "bg-teal-500", color: "text-white" }, cyan: { backgroud: "bg-cyan-500", color: "text-white" }, "light-blue": { backgroud: "bg-light-blue-500", color: "text-white" }, blue: { backgroud: "bg-blue-500", color: "text-white" }, indigo: { backgroud: "bg-indigo-500", color: "text-white" }, "deep-purple": { backgroud: "bg-deep-purple-500", color: "text-white" }, purple: { backgroud: "bg-purple-500", color: "text-white" }, pink: { backgroud: "bg-pink-500", color: "text-white" }, red: { backgroud: "bg-red-500", color: "text-white" } };
    var _default = filled;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/outlined.js
var require_outlined = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/outlined.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var outlined = { transparent: { backgroud: "bg-transparent", color: "text-blue-gray-900" }, white: { border: "border border-white", color: "text-white" }, "blue-gray": { border: "border border-blue-gray-500", color: "text-blue-gray-500" }, gray: { border: "border border-gray-900", color: "text-gray-900" }, brown: { border: "border border-brown-500", color: "text-brown-500" }, "deep-orange": { border: "border border-deep-orange-500", color: "text-deep-orange-500" }, orange: { border: "border border-orange-500", color: "text-orange-500" }, amber: { border: "border border-amber-500", color: "text-amber-500" }, yellow: { border: "border border-yellow-500", color: "text-yellow-500" }, lime: { border: "border border-lime-500", color: "text-lime-500" }, "light-green": { border: "border border-light-green-500", color: "text-light-green-500" }, green: { border: "border border-green-500", color: "text-green-500" }, teal: { border: "border border-teal-500", color: "text-teal-500" }, cyan: { border: "border border-cyan-500", color: "text-cyan-500" }, "light-blue": { border: "border border-light-blue-500", color: "text-light-blue-500" }, blue: { border: "border border-blue-500", color: "text-blue-500" }, indigo: { border: "border border-indigo-500", color: "text-indigo-500" }, "deep-purple": { border: "border border-deep-purple-500", color: "text-deep-purple-500" }, purple: { border: "border border-purple-500", color: "text-purple-500" }, pink: { border: "border border-pink-500", color: "text-pink-500" }, red: { border: "border border-red-500", color: "text-red-500" } };
    var _default = outlined;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/gradient.js
var require_gradient = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineIconColors/gradient.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var gradient = { transparent: { backgroud: "bg-transparent", color: "text-blue-gray-900" }, white: { backgroud: "bg-white", color: "text-blue-gray-900" }, "blue-gray": { backgroud: "bg-gradient-to-tr from-blue-gray-600 to-blue-gray-400", color: "text-white" }, gray: { backgroud: "bg-gradient-to-tr from-gray-900 to-gray-800", color: "text-white" }, brown: { backgroud: "bg-gradient-to-tr from-brown-600 to-brown-400", color: "text-white" }, "deep-orange": { backgroud: "bg-gradient-to-tr from-deep-orange-600 to-deep-orange-400", color: "text-white" }, orange: { backgroud: "bg-gradient-to-tr from-orange-600 to-orange-400", color: "text-white" }, amber: { backgroud: "bg-gradient-to-tr from-amber-600 to-amber-400", color: "text-black" }, yellow: { backgroud: "bg-gradient-to-tr from-yellow-600 to-yellow-400", color: "text-black" }, lime: { backgroud: "bg-gradient-to-tr from-lime-600 to-lime-400", color: "text-black" }, "light-green": { backgroud: "bg-gradient-to-tr from-light-green-600 to-light-green-400", color: "text-white" }, green: { backgroud: "bg-gradient-to-tr from-green-600 to-green-400", color: "text-white" }, teal: { backgroud: "bg-gradient-to-tr from-teal-600 to-teal-400", color: "text-white" }, cyan: { backgroud: "bg-gradient-to-tr from-cyan-600 to-cyan-400", color: "text-white" }, "light-blue": { backgroud: "bg-gradient-to-tr from-light-blue-600 to-light-blue-400", color: "text-white" }, blue: { backgroud: "bg-gradient-to-tr from-blue-600 to-blue-400", color: "text-white" }, indigo: { backgroud: "bg-gradient-to-tr from-indigo-600 to-indigo-400", color: "text-white" }, "deep-purple": { backgroud: "bg-gradient-to-tr from-deep-purple-600 to-deep-purple-400", color: "text-white" }, purple: { backgroud: "bg-gradient-to-tr from-purple-600 to-purple-400", color: "text-white" }, pink: { backgroud: "bg-gradient-to-tr from-pink-600 to-pink-400", color: "text-white" }, red: { backgroud: "bg-gradient-to-tr from-red-600 to-red-400", color: "text-white" } };
    var _default = gradient;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineIcon.js
var require_timelineIcon = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineIcon.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timelineIcon: function() {
      return timelineIcon;
    }, default: function() {
      return _default;
    } });
    var _ghost = _interopRequireDefault(require_ghost());
    var _filled = _interopRequireDefault(require_filled());
    var _outlined = _interopRequireDefault(require_outlined());
    var _gradient = _interopRequireDefault(require_gradient());
    var _timeline = require_timeline2();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var timelineIcon = { defaultProps: { color: "gray", variant: "filled" }, valid: { colors: _timeline.propTypeColor, variants: _timeline.propTypeVariant }, styles: { base: { width: "w-max", height: "w-max", padding: "p-1.5", position: "relative", zIndex: "z-[2]", flexShrink: "flex-shrink-0", borderRadius: "rounded-full", overflow: "overflow-hidden" }, variants: { ghost: _ghost.default, filled: _filled.default, outlined: _outlined.default, gradient: _gradient.default } } };
    var _default = timelineIcon;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineHeader.js
var require_timelineHeader = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timelineHeader: function() {
      return timelineHeader;
    }, default: function() {
      return _default;
    } });
    var timelineHeader = { styles: { base: { display: "flex", alignItems: "items-center", gap: "gap-4" } } };
    var _default = timelineHeader;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineBody.js
var require_timelineBody = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timelineBody: function() {
      return timelineBody;
    }, default: function() {
      return _default;
    } });
    var timelineBody = { styles: { base: { display: "flex", gap: "gap-4" } } };
    var _default = timelineBody;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/timelineConnector.js
var require_timelineConnector = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/timelineConnector.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { timelineConnector: function() {
      return timelineConnector;
    }, default: function() {
      return _default;
    } });
    var timelineConnector = { styles: { base: { container: { position: "absolute", left: "left-0", display: "grid", justifyContent: "justify-center", backgroundColor: "bg-transparent", transition: "transition-opacity duration-200" }, line: { width: "w-0.5", height: "h-full", backgroundColor: "bg-blue-gray-100" } } } };
    var _default = timelineConnector;
  }
});

// node_modules/@material-tailwind/react/theme/components/timeline/index.js
var require_timeline3 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/timeline/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    _exportStar(require_timeline(), exports);
    _exportStar(require_timelineItem(), exports);
    _exportStar(require_timelineIcon(), exports);
    _exportStar(require_timelineHeader(), exports);
    _exportStar(require_timelineBody(), exports);
    _exportStar(require_timelineConnector(), exports);
    function _exportStar(from, to) {
      Object.keys(from).forEach(function(k) {
        if (k !== "default" && !Object.prototype.hasOwnProperty.call(to, k))
          Object.defineProperty(to, k, { enumerable: true, get: function() {
            return from[k];
          } });
      });
      return from;
    }
  }
});

// node_modules/@material-tailwind/react/theme/components/stepper/step.js
var require_step = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/stepper/step.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { step: function() {
      return step;
    }, default: function() {
      return _default;
    } });
    var step = { styles: { base: { initial: { position: "relative", zIndex: "z-10", display: "grid", placeItems: "place-items-center", width: "w-10", height: "h-10", borderRadius: "rounded-full", backgroundColor: "bg-gray-300", color: "text-gray-900", fontWeight: "font-bold", transition: "transition-all duration-300" }, active: { backgroundColor: "bg-gray-900", color: "text-white" }, completed: { backgroundColor: "bg-gray-900", color: "text-white" } } } };
    var _default = step;
  }
});

// node_modules/@material-tailwind/react/theme/components/stepper/stepper.js
var require_stepper = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/stepper/stepper.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { stepper: function() {
      return stepper;
    }, default: function() {
      return _default;
    } });
    var stepper = { styles: { base: { stepper: { width: "w-full", position: "relative", display: "flex", alignItems: "items-center", justifyContent: "justify-between" }, line: { initial: { position: "absolute", left: "left-0", top: "top-2/4", height: "h-0.5", width: "w-full", transform: "-translate-y-2/4", backgroundColor: "bg-gray-300" }, active: { backgroundColor: "bg-gray-900", transition: "transition-all", duration: "duration-500" } } } } };
    var _default = stepper;
  }
});

// node_modules/@material-tailwind/react/theme/components/stepper/index.js
var require_stepper2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/stepper/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    _exportStar(require_step(), exports);
    _exportStar(require_stepper(), exports);
    function _exportStar(from, to) {
      Object.keys(from).forEach(function(k) {
        if (k !== "default" && !Object.prototype.hasOwnProperty.call(to, k))
          Object.defineProperty(to, k, { enumerable: true, get: function() {
            return from[k];
          } });
      });
      return from;
    }
  }
});

// node_modules/@material-tailwind/react/theme/components/speedDial/speedDial.js
var require_speedDial = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/speedDial/speedDial.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { speedDial: function() {
      return speedDial;
    }, default: function() {
      return _default;
    } });
    var speedDial = { defaultProps: { offset: 5, placement: "top", dismiss: void 0, animate: { unmount: {}, mount: {} } } };
    var _default = speedDial;
  }
});

// node_modules/@material-tailwind/react/theme/components/speedDial/speedDialContent.js
var require_speedDialContent = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/speedDial/speedDialContent.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { speedDialContent: function() {
      return speedDialContent;
    }, default: function() {
      return _default;
    } });
    var speedDialContent = { styles: { padding: "p-0.5", width: "w-max", display: "flex", flexDirection: "flex-col", alignItems: "items-center", gap: "gap-1" } };
    var _default = speedDialContent;
  }
});

// node_modules/@material-tailwind/react/theme/components/speedDial/speedDialAction.js
var require_speedDialAction = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/speedDial/speedDialAction.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { speedDialAction: function() {
      return speedDialAction;
    }, default: function() {
      return _default;
    } });
    var speedDialAction = { styles: { display: "flex", flexDirection: "flex-col", alignItems: "items-center", justifyContent: "justify-center", gap: "gap-1", padding: "p-1", margin: "m-0.5", borderWidth: "border", minWidth: "min-w-[48px]", fontFamily: "font-normal", minHeight: "min-h-[48px]", backgroundColor: "bg-white", borderRadius: "rounded-full", borderColor: "border-blue-gray-50", scale: "hover:scale-110 focus:scale-110 active:scale-100", transition: "transition-transform duration-300 ease-in-out" } };
    var _default = speedDialAction;
  }
});

// node_modules/@material-tailwind/react/theme/components/speedDial/index.js
var require_speedDial2 = __commonJS({
  "node_modules/@material-tailwind/react/theme/components/speedDial/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    _exportStar(require_speedDial(), exports);
    _exportStar(require_speedDialContent(), exports);
    _exportStar(require_speedDialAction(), exports);
    function _exportStar(from, to) {
      Object.keys(from).forEach(function(k) {
        if (k !== "default" && !Object.prototype.hasOwnProperty.call(to, k))
          Object.defineProperty(to, k, { enumerable: true, get: function() {
            return from[k];
          } });
      });
      return from;
    }
  }
});

// node_modules/@material-tailwind/react/theme/index.js
var require_theme = __commonJS({
  "node_modules/@material-tailwind/react/theme/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    var _accordion = _interopRequireDefault(_exportStar(require_accordion(), exports));
    var _alert = _interopRequireDefault(_exportStar(require_alert2(), exports));
    var _avatar = _interopRequireDefault(_exportStar(require_avatar2(), exports));
    var _breadcrumbs = _interopRequireDefault(_exportStar(require_breadcrumbs(), exports));
    var _button = _interopRequireDefault(_exportStar(require_button2(), exports));
    var _card = _interopRequireDefault(_exportStar(require_card2(), exports));
    var _cardBody = _interopRequireDefault(_exportStar(require_cardBody(), exports));
    var _cardFooter = _interopRequireDefault(_exportStar(require_cardFooter(), exports));
    var _cardHeader = _interopRequireDefault(_exportStar(require_cardHeader(), exports));
    var _checkbox = _interopRequireDefault(_exportStar(require_checkbox2(), exports));
    var _chip = _interopRequireDefault(_exportStar(require_chip2(), exports));
    var _dialog = _interopRequireDefault(_exportStar(require_dialog2(), exports));
    var _dialogBody = _interopRequireDefault(_exportStar(require_dialogBody(), exports));
    var _dialogFooter = _interopRequireDefault(_exportStar(require_dialogFooter(), exports));
    var _dialogHeader = _interopRequireDefault(_exportStar(require_dialogHeader(), exports));
    var _iconButton = _interopRequireDefault(_exportStar(require_iconButton(), exports));
    var _input = _interopRequireDefault(_exportStar(require_input2(), exports));
    var _menu = _interopRequireDefault(_exportStar(require_menu(), exports));
    var _navbar = _interopRequireDefault(_exportStar(require_navbar2(), exports));
    var _popover = _interopRequireDefault(_exportStar(require_popover(), exports));
    var _progress = _interopRequireDefault(_exportStar(require_progress2(), exports));
    var _radio = _interopRequireDefault(_exportStar(require_radio(), exports));
    var _select = _interopRequireDefault(_exportStar(require_select2(), exports));
    var _switch = _interopRequireDefault(_exportStar(require_switch(), exports));
    var _tab = _interopRequireDefault(_exportStar(require_tab(), exports));
    var _tabs = _interopRequireDefault(_exportStar(require_tabs(), exports));
    var _tabsBody = _interopRequireDefault(_exportStar(require_tabsBody(), exports));
    var _tabsHeader = _interopRequireDefault(_exportStar(require_tabsHeader(), exports));
    var _tabPanel = _interopRequireDefault(_exportStar(require_tabPanel(), exports));
    var _textarea = _interopRequireDefault(_exportStar(require_textarea(), exports));
    var _tooltip = _interopRequireDefault(_exportStar(require_tooltip(), exports));
    var _typography = _interopRequireDefault(_exportStar(require_typography2(), exports));
    var _collapse = _interopRequireDefault(_exportStar(require_collapse(), exports));
    var _list = _interopRequireDefault(_exportStar(require_list(), exports));
    var _buttonGroup = _interopRequireDefault(_exportStar(require_buttonGroup(), exports));
    var _carousel = _interopRequireDefault(_exportStar(require_carousel(), exports));
    var _drawer = _interopRequireDefault(_exportStar(require_drawer(), exports));
    var _badge = _interopRequireDefault(_exportStar(require_badge2(), exports));
    var _rating = _interopRequireDefault(_exportStar(require_rating2(), exports));
    var _slider = _interopRequireDefault(_exportStar(require_slider2(), exports));
    var _spinner = _interopRequireDefault(_exportStar(require_spinner2(), exports));
    var _timeline = _exportStar(require_timeline3(), exports);
    var _stepper = _exportStar(require_stepper2(), exports);
    var _speedDial = _exportStar(require_speedDial2(), exports);
    function _exportStar(from, to) {
      Object.keys(from).forEach(function(k) {
        if (k !== "default" && !Object.prototype.hasOwnProperty.call(to, k))
          Object.defineProperty(to, k, { enumerable: true, get: function() {
            return from[k];
          } });
      });
      return from;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var theme = { accordion: _accordion.default, alert: _alert.default, avatar: _avatar.default, breadcrumbs: _breadcrumbs.default, button: _button.default, card: _card.default, cardBody: _cardBody.default, cardFooter: _cardFooter.default, cardHeader: _cardHeader.default, checkbox: _checkbox.default, chip: _chip.default, dialog: _dialog.default, dialogBody: _dialogBody.default, dialogFooter: _dialogFooter.default, dialogHeader: _dialogHeader.default, iconButton: _iconButton.default, input: _input.default, menu: _menu.default, navbar: _navbar.default, popover: _popover.default, progress: _progress.default, radio: _radio.default, select: _select.default, switch: _switch.default, tab: _tab.default, tabs: _tabs.default, tabsBody: _tabsBody.default, tabsHeader: _tabsHeader.default, tabPanel: _tabPanel.default, textarea: _textarea.default, tooltip: _tooltip.default, typography: _typography.default, collapse: _collapse.default, list: _list.default, buttonGroup: _buttonGroup.default, carousel: _carousel.default, drawer: _drawer.default, badge: _badge.default, rating: _rating.default, slider: _slider.default, spinner: _spinner.default, timeline: _timeline.timeline, timelineItem: _timeline.timelineItem, timelineIcon: _timeline.timelineIcon, timelineHeader: _timeline.timelineHeader, timelineBody: _timeline.timelineBody, timelineConnector: _timeline.timelineConnector, step: _stepper.step, stepper: _stepper.stepper, speedDial: _speedDial.speedDial, speedDialContent: _speedDial.speedDialContent, speedDialAction: _speedDial.speedDialAction };
    var _default = theme;
  }
});

// node_modules/@material-tailwind/react/utils/combineMerge.js
var require_combineMerge = __commonJS({
  "node_modules/@material-tailwind/react/utils/combineMerge.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return combineMerge;
    } });
    var _deepmerge = _interopRequireDefault(require_cjs());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function combineMerge(target, source, options) {
      var destination = target.slice();
      source.forEach(function(item, index4) {
        if (typeof destination[index4] === "undefined") {
          destination[index4] = options.cloneUnlessOtherwiseSpecified(item, options);
        } else if (options.isMergeableObject(item)) {
          destination[index4] = (0, _deepmerge.default)(target[index4], item, options);
        } else if (target.indexOf(item) === -1) {
          destination.push(item);
        }
      });
      return destination;
    }
  }
});

// node_modules/@material-tailwind/react/context/theme.js
var require_theme2 = __commonJS({
  "node_modules/@material-tailwind/react/context/theme.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { MaterialTailwindTheme: function() {
      return MaterialTailwindTheme;
    }, ThemeProvider: function() {
      return ThemeProvider;
    }, useTheme: function() {
      return useTheme;
    } });
    var _react = _interopRequireWildcard(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _deepmerge = _interopRequireDefault(require_cjs());
    var _index = _interopRequireDefault(require_theme());
    var _combineMerge = _interopRequireDefault(require_combineMerge());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    var MaterialTailwindTheme = (0, _react.createContext)(_index.default);
    MaterialTailwindTheme.displayName = "MaterialTailwindThemeProvider";
    function ThemeProvider(param) {
      var _param_value = param.value, value = _param_value === void 0 ? _index.default : _param_value, children = param.children;
      var mergedValue = (0, _deepmerge.default)(_index.default, value, { arrayMerge: _combineMerge.default });
      return _react.default.createElement(MaterialTailwindTheme.Provider, { value: mergedValue }, children);
    }
    var useTheme = function() {
      return (0, _react.useContext)(MaterialTailwindTheme);
    };
    ThemeProvider.propTypes = { value: _propTypes.default.instanceOf(Object), children: _propTypes.default.node.isRequired };
  }
});

// node_modules/@material-tailwind/react/types/components/accordion.js
var require_accordion2 = __commonJS({
  "node_modules/@material-tailwind/react/types/components/accordion.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesOpen: function() {
      return propTypesOpen;
    }, propTypesIcon: function() {
      return propTypesIcon;
    }, propTypesAnimate: function() {
      return propTypesAnimate;
    }, propTypesDisabled: function() {
      return propTypesDisabled;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesValue: function() {
      return propTypesValue;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _generic = require_generic();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesOpen = _propTypes.default.bool.isRequired;
    var propTypesIcon = _propTypes.default.node;
    var propTypesAnimate = _generic.propTypesAnimation;
    var propTypesDisabled = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesValue = _propTypes.default.instanceOf(Object).isRequired;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/components/Accordion/AccordionContext.js
var require_AccordionContext = __commonJS({
  "node_modules/@material-tailwind/react/components/Accordion/AccordionContext.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { AccordionContext: function() {
      return AccordionContext;
    }, useAccordion: function() {
      return useAccordion;
    }, AccordionContextProvider: function() {
      return AccordionContextProvider;
    } });
    var _react = _interopRequireDefault(require_react());
    var _accordion = require_accordion2();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var AccordionContext = _react.default.createContext(null);
    AccordionContext.displayName = "MaterialTailwind.AccordionContext";
    function useAccordion() {
      var context = _react.default.useContext(AccordionContext);
      if (!context) {
        throw new Error("useAccordion() must be used within an Accordion. It happens when you use AccordionHeader or AccordionBody components outside the Accordion component.");
      }
      return context;
    }
    var AccordionContextProvider = function(param) {
      var value = param.value, children = param.children;
      return _react.default.createElement(AccordionContext.Provider, { value }, children);
    };
    AccordionContextProvider.propTypes = { value: _accordion.propTypesValue, children: _accordion.propTypesChildren };
    AccordionContextProvider.displayName = "MaterialTailwind.AccordionContextProvider";
  }
});

// node_modules/@material-tailwind/react/components/Accordion/AccordionHeader.js
var require_AccordionHeader = __commonJS({
  "node_modules/@material-tailwind/react/components/Accordion/AccordionHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { AccordionHeader: function() {
      return AccordionHeader;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _accordionContext = require_AccordionContext();
    var _theme = require_theme2();
    var _accordion = require_accordion2();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var AccordionHeader = _react.default.forwardRef(function(_param, ref) {
      var className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["className", "children"]);
      var _useAccordion = (0, _accordionContext.useAccordion)(), open = _useAccordion.open, icon = _useAccordion.icon, disabled = _useAccordion.disabled;
      var accordion = (0, _theme.useTheme)().accordion;
      var base = accordion.styles.base;
      className = className !== null && className !== void 0 ? className : "";
      var buttonStyles = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.header.initial), _defineProperty({}, (0, _objectsToString.default)(base.header.active), open)), className);
      var iconClasses = (0, _classnames.default)((0, _objectsToString.default)(base.header.icon));
      return _react.default.createElement("button", _extends2({}, rest, { ref, type: "button", disabled, className: buttonStyles }), children, _react.default.createElement("span", { className: iconClasses }, icon !== null && icon !== void 0 ? icon : open ? _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 20 20", fill: "currentColor" }, _react.default.createElement("path", { fillRule: "evenodd", d: "M5 10a1 1 0 011-1h8a1 1 0 110 2H6a1 1 0 01-1-1z", clipRule: "evenodd" })) : _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 20 20", fill: "currentColor" }, _react.default.createElement("path", { fillRule: "evenodd", d: "M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z", clipRule: "evenodd" }))));
    });
    AccordionHeader.propTypes = { className: _accordion.propTypesClassName, children: _accordion.propTypesChildren };
    AccordionHeader.displayName = "MaterialTailwind.AccordionHeader";
    var _default = AccordionHeader;
  }
});

// node_modules/tslib/tslib.es6.mjs
var tslib_es6_exports = {};
__export(tslib_es6_exports, {
  __addDisposableResource: () => __addDisposableResource,
  __assign: () => __assign,
  __asyncDelegator: () => __asyncDelegator,
  __asyncGenerator: () => __asyncGenerator,
  __asyncValues: () => __asyncValues,
  __await: () => __await,
  __awaiter: () => __awaiter,
  __classPrivateFieldGet: () => __classPrivateFieldGet,
  __classPrivateFieldIn: () => __classPrivateFieldIn,
  __classPrivateFieldSet: () => __classPrivateFieldSet,
  __createBinding: () => __createBinding,
  __decorate: () => __decorate,
  __disposeResources: () => __disposeResources,
  __esDecorate: () => __esDecorate,
  __exportStar: () => __exportStar,
  __extends: () => __extends,
  __generator: () => __generator,
  __importDefault: () => __importDefault,
  __importStar: () => __importStar,
  __makeTemplateObject: () => __makeTemplateObject,
  __metadata: () => __metadata,
  __param: () => __param,
  __propKey: () => __propKey,
  __read: () => __read,
  __rest: () => __rest,
  __runInitializers: () => __runInitializers,
  __setFunctionName: () => __setFunctionName,
  __spread: () => __spread,
  __spreadArray: () => __spreadArray,
  __spreadArrays: () => __spreadArrays,
  __values: () => __values,
  default: () => tslib_es6_default
});
function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
    throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
function __rest(s, e) {
  var t = {};
  for (var p in s)
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
    r = Reflect.decorate(decorators, target, key, desc);
  else
    for (var i = decorators.length - 1; i >= 0; i--)
      if (d = decorators[i])
        r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}
function __param(paramIndex, decorator) {
  return function(target, key) {
    decorator(target, key, paramIndex);
  };
}
function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function")
      throw new TypeError("Function expected");
    return f;
  }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn)
      context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access)
      context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done)
        throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0)
        continue;
      if (result === null || typeof result !== "object")
        throw new TypeError("Object expected");
      if (_ = accept(result.get))
        descriptor.get = _;
      if (_ = accept(result.set))
        descriptor.set = _;
      if (_ = accept(result.init))
        initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field")
        initializers.unshift(_);
      else
        descriptor[key] = _;
    }
  }
  if (target)
    Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
}
function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
}
function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
}
function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol")
    name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
}
function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
    return Reflect.metadata(metadataKey, metadataValue);
}
function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() {
    if (t[0] & 1)
      throw t[1];
    return t[1];
  }, trys: [], ops: [] }, f, y, t, g;
  return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
    return this;
  }), g;
  function verb(n) {
    return function(v) {
      return step([n, v]);
    };
  }
  function step(op) {
    if (f)
      throw new TypeError("Generator is already executing.");
    while (g && (g = 0, op[0] && (_ = 0)), _)
      try {
        if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
          return t;
        if (y = 0, t)
          op = [op[0] & 2, t.value];
        switch (op[0]) {
          case 0:
          case 1:
            t = op;
            break;
          case 4:
            _.label++;
            return { value: op[1], done: false };
          case 5:
            _.label++;
            y = op[1];
            op = [0];
            continue;
          case 7:
            op = _.ops.pop();
            _.trys.pop();
            continue;
          default:
            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _ = 0;
              continue;
            }
            if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
              _.label = op[1];
              break;
            }
            if (op[0] === 6 && _.label < t[1]) {
              _.label = t[1];
              t = op;
              break;
            }
            if (t && _.label < t[2]) {
              _.label = t[2];
              _.ops.push(op);
              break;
            }
            if (t[2])
              _.ops.pop();
            _.trys.pop();
            continue;
        }
        op = body.call(thisArg, _);
      } catch (e) {
        op = [6, e];
        y = 0;
      } finally {
        f = t = 0;
      }
    if (op[0] & 5)
      throw op[1];
    return { value: op[0] ? op[1] : void 0, done: true };
  }
}
function __exportStar(m, o) {
  for (var p in m)
    if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
      __createBinding(o, m, p);
}
function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m)
    return m.call(o);
  if (o && typeof o.length === "number")
    return {
      next: function() {
        if (o && i >= o.length)
          o = void 0;
        return { value: o && o[i++], done: !o };
      }
    };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m)
    return o;
  var i = m.call(o), r, ar = [], e;
  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
      ar.push(r.value);
  } catch (error) {
    e = { error };
  } finally {
    try {
      if (r && !r.done && (m = i["return"]))
        m.call(i);
    } finally {
      if (e)
        throw e.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
    ar = ar.concat(__read(arguments[i]));
  return ar;
}
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++)
    s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
    for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
      r[k] = a[j];
  return r;
}
function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2)
    for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
        if (!ar)
          ar = Array.prototype.slice.call(from, 0, i);
        ar[i] = from[i];
      }
    }
  return to.concat(ar || Array.prototype.slice.call(from));
}
function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}
function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator)
    throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function() {
    return this;
  }, i;
  function awaitReturn(f) {
    return function(v) {
      return Promise.resolve(v).then(f, reject);
    };
  }
  function verb(n, f) {
    if (g[n]) {
      i[n] = function(v) {
        return new Promise(function(a, b) {
          q.push([n, v, a, b]) > 1 || resume(n, v);
        });
      };
      if (f)
        i[n] = f(i[n]);
    }
  }
  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }
  function step(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }
  function fulfill(value) {
    resume("next", value);
  }
  function reject(value) {
    resume("throw", value);
  }
  function settle(f, v) {
    if (f(v), q.shift(), q.length)
      resume(q[0][0], q[0][1]);
  }
}
function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function(e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function() {
    return this;
  }, i;
  function verb(n, f) {
    i[n] = o[n] ? function(v) {
      return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v;
    } : f;
  }
}
function __asyncValues(o) {
  if (!Symbol.asyncIterator)
    throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
    return this;
  }, i);
  function verb(n) {
    i[n] = o[n] && function(v) {
      return new Promise(function(resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }
  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function(v2) {
      resolve({ value: v2, done: d });
    }, reject);
  }
}
function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", { value: raw });
  } else {
    cooked.raw = raw;
  }
  return cooked;
}
function __importStar(mod) {
  if (mod && mod.__esModule)
    return mod;
  var result = {};
  if (mod != null) {
    for (var k in mod)
      if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
        __createBinding(result, mod, k);
  }
  __setModuleDefault(result, mod);
  return result;
}
function __importDefault(mod) {
  return mod && mod.__esModule ? mod : { default: mod };
}
function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f)
    throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
    throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}
function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m")
    throw new TypeError("Private method is not writable");
  if (kind === "a" && !f)
    throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
    throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
}
function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function")
    throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}
function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function")
      throw new TypeError("Object expected.");
    var dispose, inner2;
    if (async) {
      if (!Symbol.asyncDispose)
        throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose)
        throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async)
        inner2 = dispose;
    }
    if (typeof dispose !== "function")
      throw new TypeError("Object not disposable.");
    if (inner2)
      dispose = function() {
        try {
          inner2.call(this);
        } catch (e) {
          return Promise.reject(e);
        }
      };
    env.stack.push({ value, dispose, async });
  } else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}
function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  function next() {
    while (env.stack.length) {
      var rec = env.stack.pop();
      try {
        var result = rec.dispose && rec.dispose.call(rec.value);
        if (rec.async)
          return Promise.resolve(result).then(next, function(e) {
            fail(e);
            return next();
          });
      } catch (e) {
        fail(e);
      }
    }
    if (env.hasError)
      throw env.error;
  }
  return next();
}
var extendStatics, __assign, __createBinding, __setModuleDefault, _SuppressedError, tslib_es6_default;
var init_tslib_es6 = __esm({
  "node_modules/tslib/tslib.es6.mjs"() {
    extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
        d2.__proto__ = b2;
      } || function(d2, b2) {
        for (var p in b2)
          if (Object.prototype.hasOwnProperty.call(b2, p))
            d2[p] = b2[p];
      };
      return extendStatics(d, b);
    };
    __assign = function() {
      __assign = Object.assign || function __assign2(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p))
              t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    __createBinding = Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    };
    __setModuleDefault = Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    };
    _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    tslib_es6_default = {
      __extends,
      __assign,
      __rest,
      __decorate,
      __param,
      __metadata,
      __awaiter,
      __generator,
      __createBinding,
      __exportStar,
      __values,
      __read,
      __spread,
      __spreadArrays,
      __spreadArray,
      __await,
      __asyncGenerator,
      __asyncDelegator,
      __asyncValues,
      __makeTemplateObject,
      __importStar,
      __importDefault,
      __classPrivateFieldGet,
      __classPrivateFieldSet,
      __classPrivateFieldIn,
      __addDisposableResource,
      __disposeResources
    };
  }
});

// node_modules/hey-listen/dist/hey-listen.es.js
var hey_listen_es_exports = {};
__export(hey_listen_es_exports, {
  invariant: () => invariant,
  warning: () => warning
});
var warning, invariant;
var init_hey_listen_es = __esm({
  "node_modules/hey-listen/dist/hey-listen.es.js"() {
    warning = function() {
    };
    invariant = function() {
    };
    if (true) {
      warning = function(check, message) {
        if (!check && typeof console !== "undefined") {
          console.warn(message);
        }
      };
      invariant = function(check, message) {
        if (!check) {
          throw new Error(message);
        }
      };
    }
  }
});

// node_modules/style-value-types/dist/valueTypes.cjs.js
var require_valueTypes_cjs = __commonJS({
  "node_modules/style-value-types/dist/valueTypes.cjs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var clamp3 = (min2, max2) => (v) => Math.max(Math.min(v, max2), min2);
    var sanitize = (v) => v % 1 ? Number(v.toFixed(5)) : v;
    var floatRegex = /(-)?([\d]*\.?[\d])+/g;
    var colorRegex = /(#[0-9a-f]{6}|#[0-9a-f]{3}|#(?:[0-9a-f]{2}){2,4}|(rgb|hsl)a?\((-?[\d\.]+%?[,\s]+){2,3}\s*\/*\s*[\d\.]+%?\))/gi;
    var singleColorRegex = /^(#[0-9a-f]{3}|#(?:[0-9a-f]{2}){2,4}|(rgb|hsl)a?\((-?[\d\.]+%?[,\s]+){2,3}\s*\/*\s*[\d\.]+%?\))$/i;
    function isString2(v) {
      return typeof v === "string";
    }
    var number = {
      test: (v) => typeof v === "number",
      parse: parseFloat,
      transform: (v) => v
    };
    var alpha = Object.assign(Object.assign({}, number), { transform: clamp3(0, 1) });
    var scale = Object.assign(Object.assign({}, number), { default: 1 });
    var createUnitType = (unit) => ({
      test: (v) => isString2(v) && v.endsWith(unit) && v.split(" ").length === 1,
      parse: parseFloat,
      transform: (v) => `${v}${unit}`
    });
    var degrees = createUnitType("deg");
    var percent = createUnitType("%");
    var px = createUnitType("px");
    var vh = createUnitType("vh");
    var vw = createUnitType("vw");
    var progressPercentage = Object.assign(Object.assign({}, percent), { parse: (v) => percent.parse(v) / 100, transform: (v) => percent.transform(v * 100) });
    var isColorString = (type, testProp) => (v) => {
      return Boolean(isString2(v) && singleColorRegex.test(v) && v.startsWith(type) || testProp && Object.prototype.hasOwnProperty.call(v, testProp));
    };
    var splitColor = (aName, bName, cName) => (v) => {
      if (!isString2(v))
        return v;
      const [a, b, c, alpha2] = v.match(floatRegex);
      return {
        [aName]: parseFloat(a),
        [bName]: parseFloat(b),
        [cName]: parseFloat(c),
        alpha: alpha2 !== void 0 ? parseFloat(alpha2) : 1
      };
    };
    var hsla = {
      test: isColorString("hsl", "hue"),
      parse: splitColor("hue", "saturation", "lightness"),
      transform: ({ hue, saturation, lightness, alpha: alpha$1 = 1 }) => {
        return "hsla(" + Math.round(hue) + ", " + percent.transform(sanitize(saturation)) + ", " + percent.transform(sanitize(lightness)) + ", " + sanitize(alpha.transform(alpha$1)) + ")";
      }
    };
    var clampRgbUnit = clamp3(0, 255);
    var rgbUnit = Object.assign(Object.assign({}, number), { transform: (v) => Math.round(clampRgbUnit(v)) });
    var rgba = {
      test: isColorString("rgb", "red"),
      parse: splitColor("red", "green", "blue"),
      transform: ({ red, green, blue, alpha: alpha$1 = 1 }) => "rgba(" + rgbUnit.transform(red) + ", " + rgbUnit.transform(green) + ", " + rgbUnit.transform(blue) + ", " + sanitize(alpha.transform(alpha$1)) + ")"
    };
    function parseHex(v) {
      let r = "";
      let g = "";
      let b = "";
      let a = "";
      if (v.length > 5) {
        r = v.substr(1, 2);
        g = v.substr(3, 2);
        b = v.substr(5, 2);
        a = v.substr(7, 2);
      } else {
        r = v.substr(1, 1);
        g = v.substr(2, 1);
        b = v.substr(3, 1);
        a = v.substr(4, 1);
        r += r;
        g += g;
        b += b;
        a += a;
      }
      return {
        red: parseInt(r, 16),
        green: parseInt(g, 16),
        blue: parseInt(b, 16),
        alpha: a ? parseInt(a, 16) / 255 : 1
      };
    }
    var hex = {
      test: isColorString("#"),
      parse: parseHex,
      transform: rgba.transform
    };
    var color = {
      test: (v) => rgba.test(v) || hex.test(v) || hsla.test(v),
      parse: (v) => {
        if (rgba.test(v)) {
          return rgba.parse(v);
        } else if (hsla.test(v)) {
          return hsla.parse(v);
        } else {
          return hex.parse(v);
        }
      },
      transform: (v) => {
        return isString2(v) ? v : v.hasOwnProperty("red") ? rgba.transform(v) : hsla.transform(v);
      }
    };
    var colorToken = "${c}";
    var numberToken = "${n}";
    function test(v) {
      var _a, _b, _c, _d;
      return isNaN(v) && isString2(v) && ((_b = (_a = v.match(floatRegex)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) + ((_d = (_c = v.match(colorRegex)) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0) > 0;
    }
    function analyse(v) {
      if (typeof v === "number")
        v = `${v}`;
      const values = [];
      let numColors = 0;
      const colors = v.match(colorRegex);
      if (colors) {
        numColors = colors.length;
        v = v.replace(colorRegex, colorToken);
        values.push(...colors.map(color.parse));
      }
      const numbers = v.match(floatRegex);
      if (numbers) {
        v = v.replace(floatRegex, numberToken);
        values.push(...numbers.map(number.parse));
      }
      return { values, numColors, tokenised: v };
    }
    function parse(v) {
      return analyse(v).values;
    }
    function createTransformer(v) {
      const { values, numColors, tokenised } = analyse(v);
      const numValues = values.length;
      return (v2) => {
        let output = tokenised;
        for (let i = 0; i < numValues; i++) {
          output = output.replace(i < numColors ? colorToken : numberToken, i < numColors ? color.transform(v2[i]) : sanitize(v2[i]));
        }
        return output;
      };
    }
    var convertNumbersToZero = (v) => typeof v === "number" ? 0 : v;
    function getAnimatableNone(v) {
      const parsed = parse(v);
      const transformer = createTransformer(v);
      return transformer(parsed.map(convertNumbersToZero));
    }
    var complex = { test, parse, createTransformer, getAnimatableNone };
    var maxDefaults = /* @__PURE__ */ new Set(["brightness", "contrast", "saturate", "opacity"]);
    function applyDefaultFilter(v) {
      let [name, value] = v.slice(0, -1).split("(");
      if (name === "drop-shadow")
        return v;
      const [number2] = value.match(floatRegex) || [];
      if (!number2)
        return v;
      const unit = value.replace(number2, "");
      let defaultValue = maxDefaults.has(name) ? 1 : 0;
      if (number2 !== value)
        defaultValue *= 100;
      return name + "(" + defaultValue + unit + ")";
    }
    var functionRegex = /([a-z-]*)\(.*?\)/g;
    var filter = Object.assign(Object.assign({}, complex), { getAnimatableNone: (v) => {
      const functions = v.match(functionRegex);
      return functions ? functions.map(applyDefaultFilter).join(" ") : v;
    } });
    exports.alpha = alpha;
    exports.color = color;
    exports.complex = complex;
    exports.degrees = degrees;
    exports.filter = filter;
    exports.hex = hex;
    exports.hsla = hsla;
    exports.number = number;
    exports.percent = percent;
    exports.progressPercentage = progressPercentage;
    exports.px = px;
    exports.rgbUnit = rgbUnit;
    exports.rgba = rgba;
    exports.scale = scale;
    exports.vh = vh;
    exports.vw = vw;
  }
});

// node_modules/framesync/dist/framesync.cjs.js
var require_framesync_cjs = __commonJS({
  "node_modules/framesync/dist/framesync.cjs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var defaultTimestep = 1 / 60 * 1e3;
    var getCurrentTime = typeof performance !== "undefined" ? () => performance.now() : () => Date.now();
    var onNextFrame = typeof window !== "undefined" ? (callback) => window.requestAnimationFrame(callback) : (callback) => setTimeout(() => callback(getCurrentTime()), defaultTimestep);
    function createRenderStep(runNextFrame2) {
      let toRun = [];
      let toRunNextFrame = [];
      let numToRun = 0;
      let isProcessing2 = false;
      let flushNextFrame = false;
      const toKeepAlive = /* @__PURE__ */ new WeakSet();
      const step = {
        schedule: (callback, keepAlive = false, immediate = false) => {
          const addToCurrentFrame = immediate && isProcessing2;
          const buffer = addToCurrentFrame ? toRun : toRunNextFrame;
          if (keepAlive)
            toKeepAlive.add(callback);
          if (buffer.indexOf(callback) === -1) {
            buffer.push(callback);
            if (addToCurrentFrame && isProcessing2)
              numToRun = toRun.length;
          }
          return callback;
        },
        cancel: (callback) => {
          const index4 = toRunNextFrame.indexOf(callback);
          if (index4 !== -1)
            toRunNextFrame.splice(index4, 1);
          toKeepAlive.delete(callback);
        },
        process: (frameData) => {
          if (isProcessing2) {
            flushNextFrame = true;
            return;
          }
          isProcessing2 = true;
          [toRun, toRunNextFrame] = [toRunNextFrame, toRun];
          toRunNextFrame.length = 0;
          numToRun = toRun.length;
          if (numToRun) {
            for (let i = 0; i < numToRun; i++) {
              const callback = toRun[i];
              callback(frameData);
              if (toKeepAlive.has(callback)) {
                step.schedule(callback);
                runNextFrame2();
              }
            }
          }
          isProcessing2 = false;
          if (flushNextFrame) {
            flushNextFrame = false;
            step.process(frameData);
          }
        }
      };
      return step;
    }
    var maxElapsed2 = 40;
    var useDefaultElapsed = true;
    var runNextFrame = false;
    var isProcessing = false;
    var frame = {
      delta: 0,
      timestamp: 0
    };
    var stepsOrder = [
      "read",
      "update",
      "preRender",
      "render",
      "postRender"
    ];
    var steps2 = stepsOrder.reduce((acc, key) => {
      acc[key] = createRenderStep(() => runNextFrame = true);
      return acc;
    }, {});
    var sync = stepsOrder.reduce((acc, key) => {
      const step = steps2[key];
      acc[key] = (process2, keepAlive = false, immediate = false) => {
        if (!runNextFrame)
          startLoop();
        return step.schedule(process2, keepAlive, immediate);
      };
      return acc;
    }, {});
    var cancelSync = stepsOrder.reduce((acc, key) => {
      acc[key] = steps2[key].cancel;
      return acc;
    }, {});
    var flushSync3 = stepsOrder.reduce((acc, key) => {
      acc[key] = () => steps2[key].process(frame);
      return acc;
    }, {});
    var processStep = (stepId) => steps2[stepId].process(frame);
    var processFrame = (timestamp) => {
      runNextFrame = false;
      frame.delta = useDefaultElapsed ? defaultTimestep : Math.max(Math.min(timestamp - frame.timestamp, maxElapsed2), 1);
      frame.timestamp = timestamp;
      isProcessing = true;
      stepsOrder.forEach(processStep);
      isProcessing = false;
      if (runNextFrame) {
        useDefaultElapsed = false;
        onNextFrame(processFrame);
      }
    };
    var startLoop = () => {
      runNextFrame = true;
      useDefaultElapsed = true;
      if (!isProcessing)
        onNextFrame(processFrame);
    };
    var getFrameData = () => frame;
    exports.cancelSync = cancelSync;
    exports.default = sync;
    exports.flushSync = flushSync3;
    exports.getFrameData = getFrameData;
  }
});

// node_modules/popmotion/dist/popmotion.cjs.js
var require_popmotion_cjs = __commonJS({
  "node_modules/popmotion/dist/popmotion.cjs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var tslib = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var heyListen = (init_hey_listen_es(), __toCommonJS(hey_listen_es_exports));
    var styleValueTypes = require_valueTypes_cjs();
    var sync = require_framesync_cjs();
    function _interopDefaultLegacy(e) {
      return e && typeof e === "object" && "default" in e ? e : { "default": e };
    }
    var sync__default = _interopDefaultLegacy(sync);
    var clamp3 = (min2, max2, v) => Math.min(Math.max(v, min2), max2);
    var safeMin = 1e-3;
    var minDuration = 0.01;
    var maxDuration2 = 10;
    var minDamping = 0.05;
    var maxDamping = 1;
    function findSpring({ duration = 800, bounce = 0.25, velocity = 0, mass = 1 }) {
      let envelope;
      let derivative;
      heyListen.warning(duration <= maxDuration2 * 1e3, "Spring duration must be 10 seconds or less");
      let dampingRatio = 1 - bounce;
      dampingRatio = clamp3(minDamping, maxDamping, dampingRatio);
      duration = clamp3(minDuration, maxDuration2, duration / 1e3);
      if (dampingRatio < 1) {
        envelope = (undampedFreq2) => {
          const exponentialDecay = undampedFreq2 * dampingRatio;
          const delta = exponentialDecay * duration;
          const a2 = exponentialDecay - velocity;
          const b2 = calcAngularFreq(undampedFreq2, dampingRatio);
          const c2 = Math.exp(-delta);
          return safeMin - a2 / b2 * c2;
        };
        derivative = (undampedFreq2) => {
          const exponentialDecay = undampedFreq2 * dampingRatio;
          const delta = exponentialDecay * duration;
          const d = delta * velocity + velocity;
          const e = Math.pow(dampingRatio, 2) * Math.pow(undampedFreq2, 2) * duration;
          const f = Math.exp(-delta);
          const g = calcAngularFreq(Math.pow(undampedFreq2, 2), dampingRatio);
          const factor = -envelope(undampedFreq2) + safeMin > 0 ? -1 : 1;
          return factor * ((d - e) * f) / g;
        };
      } else {
        envelope = (undampedFreq2) => {
          const a2 = Math.exp(-undampedFreq2 * duration);
          const b2 = (undampedFreq2 - velocity) * duration + 1;
          return -safeMin + a2 * b2;
        };
        derivative = (undampedFreq2) => {
          const a2 = Math.exp(-undampedFreq2 * duration);
          const b2 = (velocity - undampedFreq2) * (duration * duration);
          return a2 * b2;
        };
      }
      const initialGuess = 5 / duration;
      const undampedFreq = approximateRoot(envelope, derivative, initialGuess);
      duration = duration * 1e3;
      if (isNaN(undampedFreq)) {
        return {
          stiffness: 100,
          damping: 10,
          duration
        };
      } else {
        const stiffness = Math.pow(undampedFreq, 2) * mass;
        return {
          stiffness,
          damping: dampingRatio * 2 * Math.sqrt(mass * stiffness),
          duration
        };
      }
    }
    var rootIterations = 12;
    function approximateRoot(envelope, derivative, initialGuess) {
      let result = initialGuess;
      for (let i = 1; i < rootIterations; i++) {
        result = result - envelope(result) / derivative(result);
      }
      return result;
    }
    function calcAngularFreq(undampedFreq, dampingRatio) {
      return undampedFreq * Math.sqrt(1 - dampingRatio * dampingRatio);
    }
    var durationKeys = ["duration", "bounce"];
    var physicsKeys = ["stiffness", "damping", "mass"];
    function isSpringType(options, keys2) {
      return keys2.some((key) => options[key] !== void 0);
    }
    function getSpringOptions(options) {
      let springOptions = Object.assign({ velocity: 0, stiffness: 100, damping: 10, mass: 1, isResolvedFromDuration: false }, options);
      if (!isSpringType(options, physicsKeys) && isSpringType(options, durationKeys)) {
        const derived = findSpring(options);
        springOptions = Object.assign(Object.assign(Object.assign({}, springOptions), derived), { velocity: 0, mass: 1 });
        springOptions.isResolvedFromDuration = true;
      }
      return springOptions;
    }
    function spring3(_a) {
      var { from = 0, to = 1, restSpeed = 2, restDelta } = _a, options = tslib.__rest(_a, ["from", "to", "restSpeed", "restDelta"]);
      const state = { done: false, value: from };
      let { stiffness, damping, mass, velocity, duration, isResolvedFromDuration } = getSpringOptions(options);
      let resolveSpring = zero;
      let resolveVelocity = zero;
      function createSpring() {
        const initialVelocity = velocity ? -(velocity / 1e3) : 0;
        const initialDelta = to - from;
        const dampingRatio = damping / (2 * Math.sqrt(stiffness * mass));
        const undampedAngularFreq = Math.sqrt(stiffness / mass) / 1e3;
        if (restDelta === void 0) {
          restDelta = Math.min(Math.abs(to - from) / 100, 0.4);
        }
        if (dampingRatio < 1) {
          const angularFreq = calcAngularFreq(undampedAngularFreq, dampingRatio);
          resolveSpring = (t) => {
            const envelope = Math.exp(-dampingRatio * undampedAngularFreq * t);
            return to - envelope * ((initialVelocity + dampingRatio * undampedAngularFreq * initialDelta) / angularFreq * Math.sin(angularFreq * t) + initialDelta * Math.cos(angularFreq * t));
          };
          resolveVelocity = (t) => {
            const envelope = Math.exp(-dampingRatio * undampedAngularFreq * t);
            return dampingRatio * undampedAngularFreq * envelope * (Math.sin(angularFreq * t) * (initialVelocity + dampingRatio * undampedAngularFreq * initialDelta) / angularFreq + initialDelta * Math.cos(angularFreq * t)) - envelope * (Math.cos(angularFreq * t) * (initialVelocity + dampingRatio * undampedAngularFreq * initialDelta) - angularFreq * initialDelta * Math.sin(angularFreq * t));
          };
        } else if (dampingRatio === 1) {
          resolveSpring = (t) => to - Math.exp(-undampedAngularFreq * t) * (initialDelta + (initialVelocity + undampedAngularFreq * initialDelta) * t);
        } else {
          const dampedAngularFreq = undampedAngularFreq * Math.sqrt(dampingRatio * dampingRatio - 1);
          resolveSpring = (t) => {
            const envelope = Math.exp(-dampingRatio * undampedAngularFreq * t);
            const freqForT = Math.min(dampedAngularFreq * t, 300);
            return to - envelope * ((initialVelocity + dampingRatio * undampedAngularFreq * initialDelta) * Math.sinh(freqForT) + dampedAngularFreq * initialDelta * Math.cosh(freqForT)) / dampedAngularFreq;
          };
        }
      }
      createSpring();
      return {
        next: (t) => {
          const current = resolveSpring(t);
          if (!isResolvedFromDuration) {
            const currentVelocity = resolveVelocity(t) * 1e3;
            const isBelowVelocityThreshold = Math.abs(currentVelocity) <= restSpeed;
            const isBelowDisplacementThreshold = Math.abs(to - current) <= restDelta;
            state.done = isBelowVelocityThreshold && isBelowDisplacementThreshold;
          } else {
            state.done = t >= duration;
          }
          state.value = state.done ? to : current;
          return state;
        },
        flipTarget: () => {
          velocity = -velocity;
          [from, to] = [to, from];
          createSpring();
        }
      };
    }
    spring3.needsInterpolation = (a2, b2) => typeof a2 === "string" || typeof b2 === "string";
    var zero = (_t) => 0;
    var progress2 = (from, to, value) => {
      const toFromDifference = to - from;
      return toFromDifference === 0 ? 1 : (value - from) / toFromDifference;
    };
    var mix2 = (from, to, progress3) => -progress3 * from + progress3 * to + from;
    function hueToRgb(p, q, t) {
      if (t < 0)
        t += 1;
      if (t > 1)
        t -= 1;
      if (t < 1 / 6)
        return p + (q - p) * 6 * t;
      if (t < 1 / 2)
        return q;
      if (t < 2 / 3)
        return p + (q - p) * (2 / 3 - t) * 6;
      return p;
    }
    function hslaToRgba({ hue, saturation, lightness, alpha }) {
      hue /= 360;
      saturation /= 100;
      lightness /= 100;
      let red = 0;
      let green = 0;
      let blue = 0;
      if (!saturation) {
        red = green = blue = lightness;
      } else {
        const q = lightness < 0.5 ? lightness * (1 + saturation) : lightness + saturation - lightness * saturation;
        const p = 2 * lightness - q;
        red = hueToRgb(p, q, hue + 1 / 3);
        green = hueToRgb(p, q, hue);
        blue = hueToRgb(p, q, hue - 1 / 3);
      }
      return {
        red: Math.round(red * 255),
        green: Math.round(green * 255),
        blue: Math.round(blue * 255),
        alpha
      };
    }
    var mixLinearColor = (from, to, v) => {
      const fromExpo = from * from;
      const toExpo = to * to;
      return Math.sqrt(Math.max(0, v * (toExpo - fromExpo) + fromExpo));
    };
    var colorTypes = [styleValueTypes.hex, styleValueTypes.rgba, styleValueTypes.hsla];
    var getColorType = (v) => colorTypes.find((type) => type.test(v));
    var notAnimatable = (color) => `'${color}' is not an animatable color. Use the equivalent color code instead.`;
    var mixColor = (from, to) => {
      let fromColorType = getColorType(from);
      let toColorType = getColorType(to);
      heyListen.invariant(!!fromColorType, notAnimatable(from));
      heyListen.invariant(!!toColorType, notAnimatable(to));
      let fromColor = fromColorType.parse(from);
      let toColor = toColorType.parse(to);
      if (fromColorType === styleValueTypes.hsla) {
        fromColor = hslaToRgba(fromColor);
        fromColorType = styleValueTypes.rgba;
      }
      if (toColorType === styleValueTypes.hsla) {
        toColor = hslaToRgba(toColor);
        toColorType = styleValueTypes.rgba;
      }
      const blended = Object.assign({}, fromColor);
      return (v) => {
        for (const key in blended) {
          if (key !== "alpha") {
            blended[key] = mixLinearColor(fromColor[key], toColor[key], v);
          }
        }
        blended.alpha = mix2(fromColor.alpha, toColor.alpha, v);
        return fromColorType.transform(blended);
      };
    };
    var zeroPoint = {
      x: 0,
      y: 0,
      z: 0
    };
    var isNum = (v) => typeof v === "number";
    var combineFunctions = (a2, b2) => (v) => b2(a2(v));
    var pipe = (...transformers) => transformers.reduce(combineFunctions);
    function getMixer(origin, target) {
      if (isNum(origin)) {
        return (v) => mix2(origin, target, v);
      } else if (styleValueTypes.color.test(origin)) {
        return mixColor(origin, target);
      } else {
        return mixComplex(origin, target);
      }
    }
    var mixArray = (from, to) => {
      const output = [...from];
      const numValues = output.length;
      const blendValue = from.map((fromThis, i) => getMixer(fromThis, to[i]));
      return (v) => {
        for (let i = 0; i < numValues; i++) {
          output[i] = blendValue[i](v);
        }
        return output;
      };
    };
    var mixObject = (origin, target) => {
      const output = Object.assign(Object.assign({}, origin), target);
      const blendValue = {};
      for (const key in output) {
        if (origin[key] !== void 0 && target[key] !== void 0) {
          blendValue[key] = getMixer(origin[key], target[key]);
        }
      }
      return (v) => {
        for (const key in blendValue) {
          output[key] = blendValue[key](v);
        }
        return output;
      };
    };
    function analyse(value) {
      const parsed = styleValueTypes.complex.parse(value);
      const numValues = parsed.length;
      let numNumbers = 0;
      let numRGB = 0;
      let numHSL = 0;
      for (let i = 0; i < numValues; i++) {
        if (numNumbers || typeof parsed[i] === "number") {
          numNumbers++;
        } else {
          if (parsed[i].hue !== void 0) {
            numHSL++;
          } else {
            numRGB++;
          }
        }
      }
      return { parsed, numNumbers, numRGB, numHSL };
    }
    var mixComplex = (origin, target) => {
      const template = styleValueTypes.complex.createTransformer(target);
      const originStats = analyse(origin);
      const targetStats = analyse(target);
      const canInterpolate = originStats.numHSL === targetStats.numHSL && originStats.numRGB === targetStats.numRGB && originStats.numNumbers >= targetStats.numNumbers;
      if (canInterpolate) {
        return pipe(mixArray(originStats.parsed, targetStats.parsed), template);
      } else {
        heyListen.warning(true, `Complex values '${origin}' and '${target}' too different to mix. Ensure all colors are of the same type, and that each contains the same quantity of number and color values. Falling back to instant transition.`);
        return (p) => `${p > 0 ? target : origin}`;
      }
    };
    var mixNumber = (from, to) => (p) => mix2(from, to, p);
    function detectMixerFactory(v) {
      if (typeof v === "number") {
        return mixNumber;
      } else if (typeof v === "string") {
        if (styleValueTypes.color.test(v)) {
          return mixColor;
        } else {
          return mixComplex;
        }
      } else if (Array.isArray(v)) {
        return mixArray;
      } else if (typeof v === "object") {
        return mixObject;
      }
    }
    function createMixers(output, ease, customMixer) {
      const mixers = [];
      const mixerFactory = customMixer || detectMixerFactory(output[0]);
      const numMixers = output.length - 1;
      for (let i = 0; i < numMixers; i++) {
        let mixer = mixerFactory(output[i], output[i + 1]);
        if (ease) {
          const easingFunction = Array.isArray(ease) ? ease[i] : ease;
          mixer = pipe(easingFunction, mixer);
        }
        mixers.push(mixer);
      }
      return mixers;
    }
    function fastInterpolate([from, to], [mixer]) {
      return (v) => mixer(progress2(from, to, v));
    }
    function slowInterpolate(input, mixers) {
      const inputLength = input.length;
      const lastInputIndex = inputLength - 1;
      return (v) => {
        let mixerIndex = 0;
        let foundMixerIndex = false;
        if (v <= input[0]) {
          foundMixerIndex = true;
        } else if (v >= input[lastInputIndex]) {
          mixerIndex = lastInputIndex - 1;
          foundMixerIndex = true;
        }
        if (!foundMixerIndex) {
          let i = 1;
          for (; i < inputLength; i++) {
            if (input[i] > v || i === lastInputIndex) {
              break;
            }
          }
          mixerIndex = i - 1;
        }
        const progressInRange = progress2(input[mixerIndex], input[mixerIndex + 1], v);
        return mixers[mixerIndex](progressInRange);
      };
    }
    function interpolate2(input, output, { clamp: isClamp = true, ease, mixer } = {}) {
      const inputLength = input.length;
      heyListen.invariant(inputLength === output.length, "Both input and output ranges must be the same length");
      heyListen.invariant(!ease || !Array.isArray(ease) || ease.length === inputLength - 1, "Array of easing functions must be of length `input.length - 1`, as it applies to the transitions **between** the defined values.");
      if (input[0] > input[inputLength - 1]) {
        input = [].concat(input);
        output = [].concat(output);
        input.reverse();
        output.reverse();
      }
      const mixers = createMixers(output, ease, mixer);
      const interpolator = inputLength === 2 ? fastInterpolate(input, mixers) : slowInterpolate(input, mixers);
      return isClamp ? (v) => interpolator(clamp3(input[0], input[inputLength - 1], v)) : interpolator;
    }
    var reverseEasing = (easing) => (p) => 1 - easing(1 - p);
    var mirrorEasing = (easing) => (p) => p <= 0.5 ? easing(2 * p) / 2 : (2 - easing(2 * (1 - p))) / 2;
    var createExpoIn = (power) => (p) => Math.pow(p, power);
    var createBackIn = (power) => (p) => p * p * ((power + 1) * p - power);
    var createAnticipate = (power) => {
      const backEasing = createBackIn(power);
      return (p) => (p *= 2) < 1 ? 0.5 * backEasing(p) : 0.5 * (2 - Math.pow(2, -10 * (p - 1)));
    };
    var DEFAULT_OVERSHOOT_STRENGTH = 1.525;
    var BOUNCE_FIRST_THRESHOLD = 4 / 11;
    var BOUNCE_SECOND_THRESHOLD = 8 / 11;
    var BOUNCE_THIRD_THRESHOLD = 9 / 10;
    var linear = (p) => p;
    var easeIn = createExpoIn(2);
    var easeOut = reverseEasing(easeIn);
    var easeInOut = mirrorEasing(easeIn);
    var circIn = (p) => 1 - Math.sin(Math.acos(p));
    var circOut = reverseEasing(circIn);
    var circInOut = mirrorEasing(circOut);
    var backIn = createBackIn(DEFAULT_OVERSHOOT_STRENGTH);
    var backOut = reverseEasing(backIn);
    var backInOut = mirrorEasing(backIn);
    var anticipate = createAnticipate(DEFAULT_OVERSHOOT_STRENGTH);
    var ca = 4356 / 361;
    var cb = 35442 / 1805;
    var cc = 16061 / 1805;
    var bounceOut = (p) => {
      if (p === 1 || p === 0)
        return p;
      const p2 = p * p;
      return p < BOUNCE_FIRST_THRESHOLD ? 7.5625 * p2 : p < BOUNCE_SECOND_THRESHOLD ? 9.075 * p2 - 9.9 * p + 3.4 : p < BOUNCE_THIRD_THRESHOLD ? ca * p2 - cb * p + cc : 10.8 * p * p - 20.52 * p + 10.72;
    };
    var bounceIn = reverseEasing(bounceOut);
    var bounceInOut = (p) => p < 0.5 ? 0.5 * (1 - bounceOut(1 - p * 2)) : 0.5 * bounceOut(p * 2 - 1) + 0.5;
    function defaultEasing(values, easing) {
      return values.map(() => easing || easeInOut).splice(0, values.length - 1);
    }
    function defaultOffset3(values) {
      const numValues = values.length;
      return values.map((_value, i) => i !== 0 ? i / (numValues - 1) : 0);
    }
    function convertOffsetToTimes(offset3, duration) {
      return offset3.map((o) => o * duration);
    }
    function keyframes({ from = 0, to = 1, ease, offset: offset3, duration = 300 }) {
      const state = { done: false, value: from };
      const values = Array.isArray(to) ? to : [from, to];
      const times = convertOffsetToTimes(offset3 && offset3.length === values.length ? offset3 : defaultOffset3(values), duration);
      function createInterpolator() {
        return interpolate2(times, values, {
          ease: Array.isArray(ease) ? ease : defaultEasing(values, ease)
        });
      }
      let interpolator = createInterpolator();
      return {
        next: (t) => {
          state.value = interpolator(t);
          state.done = t >= duration;
          return state;
        },
        flipTarget: () => {
          values.reverse();
          interpolator = createInterpolator();
        }
      };
    }
    function decay({ velocity = 0, from = 0, power = 0.8, timeConstant = 350, restDelta = 0.5, modifyTarget }) {
      const state = { done: false, value: from };
      let amplitude = power * velocity;
      const ideal = from + amplitude;
      const target = modifyTarget === void 0 ? ideal : modifyTarget(ideal);
      if (target !== ideal)
        amplitude = target - from;
      return {
        next: (t) => {
          const delta = -amplitude * Math.exp(-t / timeConstant);
          state.done = !(delta > restDelta || delta < -restDelta);
          state.value = state.done ? target : target + delta;
          return state;
        },
        flipTarget: () => {
        }
      };
    }
    var types = { keyframes, spring: spring3, decay };
    function detectAnimationFromOptions(config) {
      if (Array.isArray(config.to)) {
        return keyframes;
      } else if (types[config.type]) {
        return types[config.type];
      }
      const keys2 = new Set(Object.keys(config));
      if (keys2.has("ease") || keys2.has("duration") && !keys2.has("dampingRatio")) {
        return keyframes;
      } else if (keys2.has("dampingRatio") || keys2.has("stiffness") || keys2.has("mass") || keys2.has("damping") || keys2.has("restSpeed") || keys2.has("restDelta")) {
        return spring3;
      }
      return keyframes;
    }
    function loopElapsed(elapsed, duration, delay = 0) {
      return elapsed - duration - delay;
    }
    function reverseElapsed(elapsed, duration, delay = 0, isForwardPlayback = true) {
      return isForwardPlayback ? loopElapsed(duration + -elapsed, duration, delay) : duration - (elapsed - duration) + delay;
    }
    function hasRepeatDelayElapsed(elapsed, duration, delay, isForwardPlayback) {
      return isForwardPlayback ? elapsed >= duration + delay : elapsed <= -delay;
    }
    var framesync = (update) => {
      const passTimestamp = ({ delta }) => update(delta);
      return {
        start: () => sync__default["default"].update(passTimestamp, true),
        stop: () => sync.cancelSync.update(passTimestamp)
      };
    };
    function animate2(_a) {
      var _b, _c;
      var { from, autoplay = true, driver = framesync, elapsed = 0, repeat: repeatMax = 0, repeatType = "loop", repeatDelay = 0, onPlay, onStop, onComplete, onRepeat, onUpdate } = _a, options = tslib.__rest(_a, ["from", "autoplay", "driver", "elapsed", "repeat", "repeatType", "repeatDelay", "onPlay", "onStop", "onComplete", "onRepeat", "onUpdate"]);
      let { to } = options;
      let driverControls;
      let repeatCount = 0;
      let computedDuration = options.duration;
      let latest;
      let isComplete = false;
      let isForwardPlayback = true;
      let interpolateFromNumber;
      const animator = detectAnimationFromOptions(options);
      if ((_c = (_b = animator).needsInterpolation) === null || _c === void 0 ? void 0 : _c.call(_b, from, to)) {
        interpolateFromNumber = interpolate2([0, 100], [from, to], {
          clamp: false
        });
        from = 0;
        to = 100;
      }
      const animation = animator(Object.assign(Object.assign({}, options), { from, to }));
      function repeat() {
        repeatCount++;
        if (repeatType === "reverse") {
          isForwardPlayback = repeatCount % 2 === 0;
          elapsed = reverseElapsed(elapsed, computedDuration, repeatDelay, isForwardPlayback);
        } else {
          elapsed = loopElapsed(elapsed, computedDuration, repeatDelay);
          if (repeatType === "mirror")
            animation.flipTarget();
        }
        isComplete = false;
        onRepeat && onRepeat();
      }
      function complete() {
        driverControls.stop();
        onComplete && onComplete();
      }
      function update(delta) {
        if (!isForwardPlayback)
          delta = -delta;
        elapsed += delta;
        if (!isComplete) {
          const state = animation.next(Math.max(0, elapsed));
          latest = state.value;
          if (interpolateFromNumber)
            latest = interpolateFromNumber(latest);
          isComplete = isForwardPlayback ? state.done : elapsed <= 0;
        }
        onUpdate === null || onUpdate === void 0 ? void 0 : onUpdate(latest);
        if (isComplete) {
          if (repeatCount === 0)
            computedDuration !== null && computedDuration !== void 0 ? computedDuration : computedDuration = elapsed;
          if (repeatCount < repeatMax) {
            hasRepeatDelayElapsed(elapsed, computedDuration, repeatDelay, isForwardPlayback) && repeat();
          } else {
            complete();
          }
        }
      }
      function play() {
        onPlay === null || onPlay === void 0 ? void 0 : onPlay();
        driverControls = driver(update);
        driverControls.start();
      }
      autoplay && play();
      return {
        stop: () => {
          onStop === null || onStop === void 0 ? void 0 : onStop();
          driverControls.stop();
        }
      };
    }
    function velocityPerSecond2(velocity, frameDuration) {
      return frameDuration ? velocity * (1e3 / frameDuration) : 0;
    }
    function inertia({ from = 0, velocity = 0, min: min2, max: max2, power = 0.8, timeConstant = 750, bounceStiffness = 500, bounceDamping = 10, restDelta = 1, modifyTarget, driver, onUpdate, onComplete, onStop }) {
      let currentAnimation;
      function isOutOfBounds(v) {
        return min2 !== void 0 && v < min2 || max2 !== void 0 && v > max2;
      }
      function boundaryNearest(v) {
        if (min2 === void 0)
          return max2;
        if (max2 === void 0)
          return min2;
        return Math.abs(min2 - v) < Math.abs(max2 - v) ? min2 : max2;
      }
      function startAnimation(options) {
        currentAnimation === null || currentAnimation === void 0 ? void 0 : currentAnimation.stop();
        currentAnimation = animate2(Object.assign(Object.assign({}, options), {
          driver,
          onUpdate: (v) => {
            var _a;
            onUpdate === null || onUpdate === void 0 ? void 0 : onUpdate(v);
            (_a = options.onUpdate) === null || _a === void 0 ? void 0 : _a.call(options, v);
          },
          onComplete,
          onStop
        }));
      }
      function startSpring(options) {
        startAnimation(Object.assign({ type: "spring", stiffness: bounceStiffness, damping: bounceDamping, restDelta }, options));
      }
      if (isOutOfBounds(from)) {
        startSpring({ from, velocity, to: boundaryNearest(from) });
      } else {
        let target = power * velocity + from;
        if (typeof modifyTarget !== "undefined")
          target = modifyTarget(target);
        const boundary = boundaryNearest(target);
        const heading = boundary === min2 ? -1 : 1;
        let prev;
        let current;
        const checkBoundary = (v) => {
          prev = current;
          current = v;
          velocity = velocityPerSecond2(v - prev, sync.getFrameData().delta);
          if (heading === 1 && v > boundary || heading === -1 && v < boundary) {
            startSpring({ from: v, to: boundary, velocity });
          }
        };
        startAnimation({
          type: "decay",
          from,
          velocity,
          timeConstant,
          power,
          restDelta,
          modifyTarget,
          onUpdate: isOutOfBounds(target) ? checkBoundary : void 0
        });
      }
      return {
        stop: () => currentAnimation === null || currentAnimation === void 0 ? void 0 : currentAnimation.stop()
      };
    }
    var radiansToDegrees = (radians) => radians * 180 / Math.PI;
    var angle = (a2, b2 = zeroPoint) => radiansToDegrees(Math.atan2(b2.y - a2.y, b2.x - a2.x));
    var applyOffset = (from, to) => {
      let hasReceivedFrom = true;
      if (to === void 0) {
        to = from;
        hasReceivedFrom = false;
      }
      return (v) => {
        if (hasReceivedFrom) {
          return v - from + to;
        } else {
          from = v;
          hasReceivedFrom = true;
          return to;
        }
      };
    };
    var identity = (v) => v;
    var createAttractor = (alterDisplacement = identity) => (constant, origin, v) => {
      const displacement = origin - v;
      const springModifiedDisplacement = -(0 - constant + 1) * (0 - alterDisplacement(Math.abs(displacement)));
      return displacement <= 0 ? origin + springModifiedDisplacement : origin - springModifiedDisplacement;
    };
    var attract = createAttractor();
    var attractExpo = createAttractor(Math.sqrt);
    var degreesToRadians = (degrees) => degrees * Math.PI / 180;
    var isPoint = (point2) => point2.hasOwnProperty("x") && point2.hasOwnProperty("y");
    var isPoint3D = (point2) => isPoint(point2) && point2.hasOwnProperty("z");
    var distance1D = (a2, b2) => Math.abs(a2 - b2);
    function distance(a2, b2) {
      if (isNum(a2) && isNum(b2)) {
        return distance1D(a2, b2);
      } else if (isPoint(a2) && isPoint(b2)) {
        const xDelta = distance1D(a2.x, b2.x);
        const yDelta = distance1D(a2.y, b2.y);
        const zDelta = isPoint3D(a2) && isPoint3D(b2) ? distance1D(a2.z, b2.z) : 0;
        return Math.sqrt(Math.pow(xDelta, 2) + Math.pow(yDelta, 2) + Math.pow(zDelta, 2));
      }
    }
    var pointFromVector = (origin, angle2, distance2) => {
      angle2 = degreesToRadians(angle2);
      return {
        x: distance2 * Math.cos(angle2) + origin.x,
        y: distance2 * Math.sin(angle2) + origin.y
      };
    };
    var toDecimal = (num, precision = 2) => {
      precision = Math.pow(10, precision);
      return Math.round(num * precision) / precision;
    };
    var smoothFrame = (prevValue, nextValue, duration, smoothing = 0) => toDecimal(prevValue + duration * (nextValue - prevValue) / Math.max(smoothing, duration));
    var smooth = (strength = 50) => {
      let previousValue = 0;
      let lastUpdated = 0;
      return (v) => {
        const currentFramestamp = sync.getFrameData().timestamp;
        const timeDelta = currentFramestamp !== lastUpdated ? currentFramestamp - lastUpdated : 0;
        const newValue = timeDelta ? smoothFrame(previousValue, v, timeDelta, strength) : previousValue;
        lastUpdated = currentFramestamp;
        previousValue = newValue;
        return newValue;
      };
    };
    var snap = (points) => {
      if (typeof points === "number") {
        return (v) => Math.round(v / points) * points;
      } else {
        let i = 0;
        const numPoints = points.length;
        return (v) => {
          let lastDistance = Math.abs(points[0] - v);
          for (i = 1; i < numPoints; i++) {
            const point2 = points[i];
            const distance2 = Math.abs(point2 - v);
            if (distance2 === 0)
              return point2;
            if (distance2 > lastDistance)
              return points[i - 1];
            if (i === numPoints - 1)
              return point2;
            lastDistance = distance2;
          }
        };
      }
    };
    function velocityPerFrame(xps, frameDuration) {
      return xps / (1e3 / frameDuration);
    }
    var wrap2 = (min2, max2, v) => {
      const rangeSize = max2 - min2;
      return ((v - min2) % rangeSize + rangeSize) % rangeSize + min2;
    };
    var a = (a1, a2) => 1 - 3 * a2 + 3 * a1;
    var b = (a1, a2) => 3 * a2 - 6 * a1;
    var c = (a1) => 3 * a1;
    var calcBezier2 = (t, a1, a2) => ((a(a1, a2) * t + b(a1, a2)) * t + c(a1)) * t;
    var getSlope = (t, a1, a2) => 3 * a(a1, a2) * t * t + 2 * b(a1, a2) * t + c(a1);
    var subdivisionPrecision2 = 1e-7;
    var subdivisionMaxIterations2 = 10;
    function binarySubdivide2(aX, aA, aB, mX1, mX2) {
      let currentX;
      let currentT;
      let i = 0;
      do {
        currentT = aA + (aB - aA) / 2;
        currentX = calcBezier2(currentT, mX1, mX2) - aX;
        if (currentX > 0) {
          aB = currentT;
        } else {
          aA = currentT;
        }
      } while (Math.abs(currentX) > subdivisionPrecision2 && ++i < subdivisionMaxIterations2);
      return currentT;
    }
    var newtonIterations = 8;
    var newtonMinSlope = 1e-3;
    function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
      for (let i = 0; i < newtonIterations; ++i) {
        const currentSlope = getSlope(aGuessT, mX1, mX2);
        if (currentSlope === 0) {
          return aGuessT;
        }
        const currentX = calcBezier2(aGuessT, mX1, mX2) - aX;
        aGuessT -= currentX / currentSlope;
      }
      return aGuessT;
    }
    var kSplineTableSize = 11;
    var kSampleStepSize = 1 / (kSplineTableSize - 1);
    function cubicBezier2(mX1, mY1, mX2, mY2) {
      if (mX1 === mY1 && mX2 === mY2)
        return linear;
      const sampleValues = new Float32Array(kSplineTableSize);
      for (let i = 0; i < kSplineTableSize; ++i) {
        sampleValues[i] = calcBezier2(i * kSampleStepSize, mX1, mX2);
      }
      function getTForX(aX) {
        let intervalStart = 0;
        let currentSample = 1;
        const lastSample = kSplineTableSize - 1;
        for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
          intervalStart += kSampleStepSize;
        }
        --currentSample;
        const dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
        const guessForT = intervalStart + dist * kSampleStepSize;
        const initialSlope = getSlope(guessForT, mX1, mX2);
        if (initialSlope >= newtonMinSlope) {
          return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
        } else if (initialSlope === 0) {
          return guessForT;
        } else {
          return binarySubdivide2(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
        }
      }
      return (t) => t === 0 || t === 1 ? t : calcBezier2(getTForX(t), mY1, mY2);
    }
    var steps2 = (steps3, direction = "end") => (progress3) => {
      progress3 = direction === "end" ? Math.min(progress3, 0.999) : Math.max(progress3, 1e-3);
      const expanded = progress3 * steps3;
      const rounded = direction === "end" ? Math.floor(expanded) : Math.ceil(expanded);
      return clamp3(0, 1, rounded / steps3);
    };
    exports.angle = angle;
    exports.animate = animate2;
    exports.anticipate = anticipate;
    exports.applyOffset = applyOffset;
    exports.attract = attract;
    exports.attractExpo = attractExpo;
    exports.backIn = backIn;
    exports.backInOut = backInOut;
    exports.backOut = backOut;
    exports.bounceIn = bounceIn;
    exports.bounceInOut = bounceInOut;
    exports.bounceOut = bounceOut;
    exports.circIn = circIn;
    exports.circInOut = circInOut;
    exports.circOut = circOut;
    exports.clamp = clamp3;
    exports.createAnticipate = createAnticipate;
    exports.createAttractor = createAttractor;
    exports.createBackIn = createBackIn;
    exports.createExpoIn = createExpoIn;
    exports.cubicBezier = cubicBezier2;
    exports.decay = decay;
    exports.degreesToRadians = degreesToRadians;
    exports.distance = distance;
    exports.easeIn = easeIn;
    exports.easeInOut = easeInOut;
    exports.easeOut = easeOut;
    exports.inertia = inertia;
    exports.interpolate = interpolate2;
    exports.isPoint = isPoint;
    exports.isPoint3D = isPoint3D;
    exports.keyframes = keyframes;
    exports.linear = linear;
    exports.mirrorEasing = mirrorEasing;
    exports.mix = mix2;
    exports.mixColor = mixColor;
    exports.mixComplex = mixComplex;
    exports.pipe = pipe;
    exports.pointFromVector = pointFromVector;
    exports.progress = progress2;
    exports.radiansToDegrees = radiansToDegrees;
    exports.reverseEasing = reverseEasing;
    exports.smooth = smooth;
    exports.smoothFrame = smoothFrame;
    exports.snap = snap;
    exports.spring = spring3;
    exports.steps = steps2;
    exports.toDecimal = toDecimal;
    exports.velocityPerFrame = velocityPerFrame;
    exports.velocityPerSecond = velocityPerSecond2;
    exports.wrap = wrap2;
  }
});

// node_modules/@motionone/types/dist/MotionValue.es.js
var MotionValue;
var init_MotionValue_es = __esm({
  "node_modules/@motionone/types/dist/MotionValue.es.js"() {
    MotionValue = class {
      setAnimation(animation) {
        this.animation = animation;
        animation === null || animation === void 0 ? void 0 : animation.finished.then(() => this.clearAnimation()).catch(() => {
        });
      }
      clearAnimation() {
        this.animation = this.generator = void 0;
      }
    };
  }
});

// node_modules/@motionone/types/dist/index.es.js
var init_index_es = __esm({
  "node_modules/@motionone/types/dist/index.es.js"() {
    init_MotionValue_es();
  }
});

// node_modules/@motionone/dom/dist/animate/data.es.js
function getAnimationData(element) {
  if (!data.has(element)) {
    data.set(element, {
      transforms: [],
      values: /* @__PURE__ */ new Map()
    });
  }
  return data.get(element);
}
function getMotionValue(motionValues, name) {
  if (!motionValues.has(name)) {
    motionValues.set(name, new MotionValue());
  }
  return motionValues.get(name);
}
var data;
var init_data_es = __esm({
  "node_modules/@motionone/dom/dist/animate/data.es.js"() {
    init_index_es();
    data = /* @__PURE__ */ new WeakMap();
  }
});

// node_modules/@motionone/utils/dist/array.es.js
function addUniqueItem(array, item) {
  array.indexOf(item) === -1 && array.push(item);
}
function removeItem(arr, item) {
  const index4 = arr.indexOf(item);
  index4 > -1 && arr.splice(index4, 1);
}
var init_array_es = __esm({
  "node_modules/@motionone/utils/dist/array.es.js"() {
  }
});

// node_modules/@motionone/utils/dist/clamp.es.js
var clamp;
var init_clamp_es = __esm({
  "node_modules/@motionone/utils/dist/clamp.es.js"() {
    clamp = (min2, max2, v) => Math.min(Math.max(v, min2), max2);
  }
});

// node_modules/@motionone/utils/dist/defaults.es.js
var defaults;
var init_defaults_es = __esm({
  "node_modules/@motionone/utils/dist/defaults.es.js"() {
    defaults = {
      duration: 0.3,
      delay: 0,
      endDelay: 0,
      repeat: 0,
      easing: "ease"
    };
  }
});

// node_modules/@motionone/utils/dist/is-number.es.js
var isNumber;
var init_is_number_es = __esm({
  "node_modules/@motionone/utils/dist/is-number.es.js"() {
    isNumber = (value) => typeof value === "number";
  }
});

// node_modules/@motionone/utils/dist/is-easing-list.es.js
var isEasingList;
var init_is_easing_list_es = __esm({
  "node_modules/@motionone/utils/dist/is-easing-list.es.js"() {
    init_is_number_es();
    isEasingList = (easing) => Array.isArray(easing) && !isNumber(easing[0]);
  }
});

// node_modules/@motionone/utils/dist/wrap.es.js
var wrap;
var init_wrap_es = __esm({
  "node_modules/@motionone/utils/dist/wrap.es.js"() {
    wrap = (min2, max2, v) => {
      const rangeSize = max2 - min2;
      return ((v - min2) % rangeSize + rangeSize) % rangeSize + min2;
    };
  }
});

// node_modules/@motionone/utils/dist/easing.es.js
function getEasingForSegment(easing, i) {
  return isEasingList(easing) ? easing[wrap(0, easing.length, i)] : easing;
}
var init_easing_es = __esm({
  "node_modules/@motionone/utils/dist/easing.es.js"() {
    init_is_easing_list_es();
    init_wrap_es();
  }
});

// node_modules/@motionone/utils/dist/mix.es.js
var mix;
var init_mix_es = __esm({
  "node_modules/@motionone/utils/dist/mix.es.js"() {
    mix = (min2, max2, progress2) => -progress2 * min2 + progress2 * max2 + min2;
  }
});

// node_modules/@motionone/utils/dist/noop.es.js
var noop, noopReturn;
var init_noop_es = __esm({
  "node_modules/@motionone/utils/dist/noop.es.js"() {
    noop = () => {
    };
    noopReturn = (v) => v;
  }
});

// node_modules/@motionone/utils/dist/progress.es.js
var progress;
var init_progress_es = __esm({
  "node_modules/@motionone/utils/dist/progress.es.js"() {
    progress = (min2, max2, value) => max2 - min2 === 0 ? 1 : (value - min2) / (max2 - min2);
  }
});

// node_modules/@motionone/utils/dist/offset.es.js
function fillOffset(offset3, remaining) {
  const min2 = offset3[offset3.length - 1];
  for (let i = 1; i <= remaining; i++) {
    const offsetProgress = progress(0, remaining, i);
    offset3.push(mix(min2, 1, offsetProgress));
  }
}
function defaultOffset(length2) {
  const offset3 = [0];
  fillOffset(offset3, length2 - 1);
  return offset3;
}
var init_offset_es = __esm({
  "node_modules/@motionone/utils/dist/offset.es.js"() {
    init_mix_es();
    init_progress_es();
  }
});

// node_modules/@motionone/utils/dist/interpolate.es.js
function interpolate(output, input = defaultOffset(output.length), easing = noopReturn) {
  const length2 = output.length;
  const remainder = length2 - input.length;
  remainder > 0 && fillOffset(input, remainder);
  return (t) => {
    let i = 0;
    for (; i < length2 - 2; i++) {
      if (t < input[i + 1])
        break;
    }
    let progressInRange = clamp(0, 1, progress(input[i], input[i + 1], t));
    const segmentEasing = getEasingForSegment(easing, i);
    progressInRange = segmentEasing(progressInRange);
    return mix(output[i], output[i + 1], progressInRange);
  };
}
var init_interpolate_es = __esm({
  "node_modules/@motionone/utils/dist/interpolate.es.js"() {
    init_mix_es();
    init_noop_es();
    init_offset_es();
    init_progress_es();
    init_easing_es();
    init_clamp_es();
  }
});

// node_modules/@motionone/utils/dist/is-cubic-bezier.es.js
var isCubicBezier;
var init_is_cubic_bezier_es = __esm({
  "node_modules/@motionone/utils/dist/is-cubic-bezier.es.js"() {
    init_is_number_es();
    isCubicBezier = (easing) => Array.isArray(easing) && isNumber(easing[0]);
  }
});

// node_modules/@motionone/utils/dist/is-easing-generator.es.js
var isEasingGenerator;
var init_is_easing_generator_es = __esm({
  "node_modules/@motionone/utils/dist/is-easing-generator.es.js"() {
    isEasingGenerator = (easing) => typeof easing === "object" && Boolean(easing.createAnimation);
  }
});

// node_modules/@motionone/utils/dist/is-function.es.js
var isFunction;
var init_is_function_es = __esm({
  "node_modules/@motionone/utils/dist/is-function.es.js"() {
    isFunction = (value) => typeof value === "function";
  }
});

// node_modules/@motionone/utils/dist/is-string.es.js
var isString;
var init_is_string_es = __esm({
  "node_modules/@motionone/utils/dist/is-string.es.js"() {
    isString = (value) => typeof value === "string";
  }
});

// node_modules/@motionone/utils/dist/time.es.js
var time;
var init_time_es = __esm({
  "node_modules/@motionone/utils/dist/time.es.js"() {
    time = {
      ms: (seconds) => seconds * 1e3,
      s: (milliseconds) => milliseconds / 1e3
    };
  }
});

// node_modules/@motionone/utils/dist/velocity.es.js
function velocityPerSecond(velocity, frameDuration) {
  return frameDuration ? velocity * (1e3 / frameDuration) : 0;
}
var init_velocity_es = __esm({
  "node_modules/@motionone/utils/dist/velocity.es.js"() {
  }
});

// node_modules/@motionone/utils/dist/index.es.js
var init_index_es2 = __esm({
  "node_modules/@motionone/utils/dist/index.es.js"() {
    init_array_es();
    init_clamp_es();
    init_defaults_es();
    init_easing_es();
    init_interpolate_es();
    init_is_cubic_bezier_es();
    init_is_easing_generator_es();
    init_is_easing_list_es();
    init_is_function_es();
    init_is_number_es();
    init_is_string_es();
    init_mix_es();
    init_noop_es();
    init_offset_es();
    init_progress_es();
    init_time_es();
    init_velocity_es();
    init_wrap_es();
  }
});

// node_modules/@motionone/dom/dist/animate/utils/transforms.es.js
var axes, order, transformAlias, rotation, baseTransformProperties, transformDefinitions, asTransformCssVar, transforms, compareTransformOrder, transformLookup, isTransform, addTransformToElement, buildTransformTemplate, transformListToString;
var init_transforms_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/transforms.es.js"() {
    init_index_es2();
    init_data_es();
    axes = ["", "X", "Y", "Z"];
    order = ["translate", "scale", "rotate", "skew"];
    transformAlias = {
      x: "translateX",
      y: "translateY",
      z: "translateZ"
    };
    rotation = {
      syntax: "<angle>",
      initialValue: "0deg",
      toDefaultUnit: (v) => v + "deg"
    };
    baseTransformProperties = {
      translate: {
        syntax: "<length-percentage>",
        initialValue: "0px",
        toDefaultUnit: (v) => v + "px"
      },
      rotate: rotation,
      scale: {
        syntax: "<number>",
        initialValue: 1,
        toDefaultUnit: noopReturn
      },
      skew: rotation
    };
    transformDefinitions = /* @__PURE__ */ new Map();
    asTransformCssVar = (name) => `--motion-${name}`;
    transforms = ["x", "y", "z"];
    order.forEach((name) => {
      axes.forEach((axis) => {
        transforms.push(name + axis);
        transformDefinitions.set(asTransformCssVar(name + axis), baseTransformProperties[name]);
      });
    });
    compareTransformOrder = (a, b) => transforms.indexOf(a) - transforms.indexOf(b);
    transformLookup = new Set(transforms);
    isTransform = (name) => transformLookup.has(name);
    addTransformToElement = (element, name) => {
      if (transformAlias[name])
        name = transformAlias[name];
      const { transforms: transforms2 } = getAnimationData(element);
      addUniqueItem(transforms2, name);
      element.style.transform = buildTransformTemplate(transforms2);
    };
    buildTransformTemplate = (transforms2) => transforms2.sort(compareTransformOrder).reduce(transformListToString, "").trim();
    transformListToString = (template, name) => `${template} ${name}(var(${asTransformCssVar(name)}))`;
  }
});

// node_modules/@motionone/dom/dist/animate/utils/css-var.es.js
function registerCssVariable(name) {
  if (registeredProperties.has(name))
    return;
  registeredProperties.add(name);
  try {
    const { syntax, initialValue } = transformDefinitions.has(name) ? transformDefinitions.get(name) : {};
    CSS.registerProperty({
      name,
      inherits: false,
      syntax,
      initialValue
    });
  } catch (e) {
  }
}
var isCssVar, registeredProperties;
var init_css_var_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/css-var.es.js"() {
    init_transforms_es();
    isCssVar = (name) => name.startsWith("--");
    registeredProperties = /* @__PURE__ */ new Set();
  }
});

// node_modules/@motionone/easing/dist/cubic-bezier.es.js
function binarySubdivide(x, lowerBound, upperBound, mX1, mX2) {
  let currentX;
  let currentT;
  let i = 0;
  do {
    currentT = lowerBound + (upperBound - lowerBound) / 2;
    currentX = calcBezier(currentT, mX1, mX2) - x;
    if (currentX > 0) {
      upperBound = currentT;
    } else {
      lowerBound = currentT;
    }
  } while (Math.abs(currentX) > subdivisionPrecision && ++i < subdivisionMaxIterations);
  return currentT;
}
function cubicBezier(mX1, mY1, mX2, mY2) {
  if (mX1 === mY1 && mX2 === mY2)
    return noopReturn;
  const getTForX = (aX) => binarySubdivide(aX, 0, 1, mX1, mX2);
  return (t) => t === 0 || t === 1 ? t : calcBezier(getTForX(t), mY1, mY2);
}
var calcBezier, subdivisionPrecision, subdivisionMaxIterations;
var init_cubic_bezier_es = __esm({
  "node_modules/@motionone/easing/dist/cubic-bezier.es.js"() {
    init_index_es2();
    calcBezier = (t, a1, a2) => (((1 - 3 * a2 + 3 * a1) * t + (3 * a2 - 6 * a1)) * t + 3 * a1) * t;
    subdivisionPrecision = 1e-7;
    subdivisionMaxIterations = 12;
  }
});

// node_modules/@motionone/easing/dist/steps.es.js
var steps;
var init_steps_es = __esm({
  "node_modules/@motionone/easing/dist/steps.es.js"() {
    init_index_es2();
    steps = (steps2, direction = "end") => (progress2) => {
      progress2 = direction === "end" ? Math.min(progress2, 0.999) : Math.max(progress2, 1e-3);
      const expanded = progress2 * steps2;
      const rounded = direction === "end" ? Math.floor(expanded) : Math.ceil(expanded);
      return clamp(0, 1, rounded / steps2);
    };
  }
});

// node_modules/@motionone/easing/dist/index.es.js
var init_index_es3 = __esm({
  "node_modules/@motionone/easing/dist/index.es.js"() {
    init_cubic_bezier_es();
    init_steps_es();
  }
});

// node_modules/@motionone/animation/dist/utils/easing.es.js
function getEasingFunction(definition) {
  if (isFunction(definition))
    return definition;
  if (isCubicBezier(definition))
    return cubicBezier(...definition);
  const namedEasing = namedEasings[definition];
  if (namedEasing)
    return namedEasing;
  if (definition.startsWith("steps")) {
    const args = functionArgsRegex.exec(definition);
    if (args) {
      const argsArray = args[1].split(",");
      return steps(parseFloat(argsArray[0]), argsArray[1].trim());
    }
  }
  return noopReturn;
}
var namedEasings, functionArgsRegex;
var init_easing_es2 = __esm({
  "node_modules/@motionone/animation/dist/utils/easing.es.js"() {
    init_index_es3();
    init_index_es2();
    namedEasings = {
      ease: cubicBezier(0.25, 0.1, 0.25, 1),
      "ease-in": cubicBezier(0.42, 0, 1, 1),
      "ease-in-out": cubicBezier(0.42, 0, 0.58, 1),
      "ease-out": cubicBezier(0, 0, 0.58, 1)
    };
    functionArgsRegex = /\((.*?)\)/;
  }
});

// node_modules/@motionone/animation/dist/Animation.es.js
var Animation;
var init_Animation_es = __esm({
  "node_modules/@motionone/animation/dist/Animation.es.js"() {
    init_index_es2();
    init_easing_es2();
    Animation = class {
      constructor(output, keyframes = [0, 1], { easing, duration: initialDuration = defaults.duration, delay = defaults.delay, endDelay = defaults.endDelay, repeat = defaults.repeat, offset: offset3, direction = "normal", autoplay = true } = {}) {
        this.startTime = null;
        this.rate = 1;
        this.t = 0;
        this.cancelTimestamp = null;
        this.easing = noopReturn;
        this.duration = 0;
        this.totalDuration = 0;
        this.repeat = 0;
        this.playState = "idle";
        this.finished = new Promise((resolve, reject) => {
          this.resolve = resolve;
          this.reject = reject;
        });
        easing = easing || defaults.easing;
        if (isEasingGenerator(easing)) {
          const custom = easing.createAnimation(keyframes);
          easing = custom.easing;
          keyframes = custom.keyframes || keyframes;
          initialDuration = custom.duration || initialDuration;
        }
        this.repeat = repeat;
        this.easing = isEasingList(easing) ? noopReturn : getEasingFunction(easing);
        this.updateDuration(initialDuration);
        const interpolate$1 = interpolate(keyframes, offset3, isEasingList(easing) ? easing.map(getEasingFunction) : noopReturn);
        this.tick = (timestamp) => {
          var _a;
          delay = delay;
          let t = 0;
          if (this.pauseTime !== void 0) {
            t = this.pauseTime;
          } else {
            t = (timestamp - this.startTime) * this.rate;
          }
          this.t = t;
          t /= 1e3;
          t = Math.max(t - delay, 0);
          if (this.playState === "finished" && this.pauseTime === void 0) {
            t = this.totalDuration;
          }
          const progress2 = t / this.duration;
          let currentIteration = Math.floor(progress2);
          let iterationProgress = progress2 % 1;
          if (!iterationProgress && progress2 >= 1) {
            iterationProgress = 1;
          }
          iterationProgress === 1 && currentIteration--;
          const iterationIsOdd = currentIteration % 2;
          if (direction === "reverse" || direction === "alternate" && iterationIsOdd || direction === "alternate-reverse" && !iterationIsOdd) {
            iterationProgress = 1 - iterationProgress;
          }
          const p = t >= this.totalDuration ? 1 : Math.min(iterationProgress, 1);
          const latest = interpolate$1(this.easing(p));
          output(latest);
          const isAnimationFinished = this.pauseTime === void 0 && (this.playState === "finished" || t >= this.totalDuration + endDelay);
          if (isAnimationFinished) {
            this.playState = "finished";
            (_a = this.resolve) === null || _a === void 0 ? void 0 : _a.call(this, latest);
          } else if (this.playState !== "idle") {
            this.frameRequestId = requestAnimationFrame(this.tick);
          }
        };
        if (autoplay)
          this.play();
      }
      play() {
        const now = performance.now();
        this.playState = "running";
        if (this.pauseTime !== void 0) {
          this.startTime = now - this.pauseTime;
        } else if (!this.startTime) {
          this.startTime = now;
        }
        this.cancelTimestamp = this.startTime;
        this.pauseTime = void 0;
        this.frameRequestId = requestAnimationFrame(this.tick);
      }
      pause() {
        this.playState = "paused";
        this.pauseTime = this.t;
      }
      finish() {
        this.playState = "finished";
        this.tick(0);
      }
      stop() {
        var _a;
        this.playState = "idle";
        if (this.frameRequestId !== void 0) {
          cancelAnimationFrame(this.frameRequestId);
        }
        (_a = this.reject) === null || _a === void 0 ? void 0 : _a.call(this, false);
      }
      cancel() {
        this.stop();
        this.tick(this.cancelTimestamp);
      }
      reverse() {
        this.rate *= -1;
      }
      commitStyles() {
      }
      updateDuration(duration) {
        this.duration = duration;
        this.totalDuration = duration * (this.repeat + 1);
      }
      get currentTime() {
        return this.t;
      }
      set currentTime(t) {
        if (this.pauseTime !== void 0 || this.rate === 0) {
          this.pauseTime = t;
        } else {
          this.startTime = performance.now() - t / this.rate;
        }
      }
      get playbackRate() {
        return this.rate;
      }
      set playbackRate(rate) {
        this.rate = rate;
      }
    };
  }
});

// node_modules/@motionone/animation/dist/index.es.js
var init_index_es4 = __esm({
  "node_modules/@motionone/animation/dist/index.es.js"() {
    init_Animation_es();
    init_easing_es2();
  }
});

// node_modules/@motionone/dom/dist/animate/utils/easing.es.js
var convertEasing, cubicBezierAsString;
var init_easing_es3 = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/easing.es.js"() {
    init_index_es2();
    convertEasing = (easing) => isCubicBezier(easing) ? cubicBezierAsString(easing) : easing;
    cubicBezierAsString = ([a, b, c, d]) => `cubic-bezier(${a}, ${b}, ${c}, ${d})`;
  }
});

// node_modules/@motionone/dom/dist/animate/utils/feature-detection.es.js
var testAnimation, featureTests, results, supports;
var init_feature_detection_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/feature-detection.es.js"() {
    testAnimation = (keyframes) => document.createElement("div").animate(keyframes, { duration: 1e-3 });
    featureTests = {
      cssRegisterProperty: () => typeof CSS !== "undefined" && Object.hasOwnProperty.call(CSS, "registerProperty"),
      waapi: () => Object.hasOwnProperty.call(Element.prototype, "animate"),
      partialKeyframes: () => {
        try {
          testAnimation({ opacity: [1] });
        } catch (e) {
          return false;
        }
        return true;
      },
      finished: () => Boolean(testAnimation({ opacity: [0, 1] }).finished)
    };
    results = {};
    supports = {};
    for (const key in featureTests) {
      supports[key] = () => {
        if (results[key] === void 0)
          results[key] = featureTests[key]();
        return results[key];
      };
    }
  }
});

// node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js
function hydrateKeyframes(keyframes, readInitialValue) {
  for (let i = 0; i < keyframes.length; i++) {
    if (keyframes[i] === null) {
      keyframes[i] = i ? keyframes[i - 1] : readInitialValue();
    }
  }
  return keyframes;
}
var keyframesList;
var init_keyframes_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js"() {
    keyframesList = (keyframes) => Array.isArray(keyframes) ? keyframes : [keyframes];
  }
});

// node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js
function getStyleName(key) {
  if (transformAlias[key])
    key = transformAlias[key];
  return isTransform(key) ? asTransformCssVar(key) : key;
}
var init_get_style_name_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js"() {
    init_transforms_es();
  }
});

// node_modules/@motionone/dom/dist/animate/style.es.js
var style;
var init_style_es = __esm({
  "node_modules/@motionone/dom/dist/animate/style.es.js"() {
    init_css_var_es();
    init_get_style_name_es();
    init_transforms_es();
    style = {
      get: (element, name) => {
        name = getStyleName(name);
        let value = isCssVar(name) ? element.style.getPropertyValue(name) : getComputedStyle(element)[name];
        if (!value && value !== 0) {
          const definition = transformDefinitions.get(name);
          if (definition)
            value = definition.initialValue;
        }
        return value;
      },
      set: (element, name, value) => {
        name = getStyleName(name);
        if (isCssVar(name)) {
          element.style.setProperty(name, value);
        } else {
          element.style[name] = value;
        }
      }
    };
  }
});

// node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js
function stopAnimation(animation, needsCommit = true) {
  if (!animation || animation.playState === "finished")
    return;
  try {
    if (animation.stop) {
      animation.stop();
    } else {
      needsCommit && animation.commitStyles();
      animation.cancel();
    }
  } catch (e) {
  }
}
var init_stop_animation_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/animate/animate-style.es.js
function getDevToolsRecord() {
  return window.__MOTION_DEV_TOOLS_RECORD;
}
function animateStyle(element, key, keyframesDefinition, options = {}) {
  const record = getDevToolsRecord();
  const isRecording = options.record !== false && record;
  let animation;
  let { duration = defaults.duration, delay = defaults.delay, endDelay = defaults.endDelay, repeat = defaults.repeat, easing = defaults.easing, direction, offset: offset3, allowWebkitAcceleration = false } = options;
  const data2 = getAnimationData(element);
  let canAnimateNatively = supports.waapi();
  const valueIsTransform = isTransform(key);
  valueIsTransform && addTransformToElement(element, key);
  const name = getStyleName(key);
  const motionValue = getMotionValue(data2.values, name);
  const definition = transformDefinitions.get(name);
  stopAnimation(motionValue.animation, !(isEasingGenerator(easing) && motionValue.generator) && options.record !== false);
  return () => {
    const readInitialValue = () => {
      var _a, _b;
      return (_b = (_a = style.get(element, name)) !== null && _a !== void 0 ? _a : definition === null || definition === void 0 ? void 0 : definition.initialValue) !== null && _b !== void 0 ? _b : 0;
    };
    let keyframes = hydrateKeyframes(keyframesList(keyframesDefinition), readInitialValue);
    if (isEasingGenerator(easing)) {
      const custom = easing.createAnimation(keyframes, readInitialValue, valueIsTransform, name, motionValue);
      easing = custom.easing;
      if (custom.keyframes !== void 0)
        keyframes = custom.keyframes;
      if (custom.duration !== void 0)
        duration = custom.duration;
    }
    if (isCssVar(name)) {
      if (supports.cssRegisterProperty()) {
        registerCssVariable(name);
      } else {
        canAnimateNatively = false;
      }
    }
    if (canAnimateNatively) {
      if (definition) {
        keyframes = keyframes.map((value) => isNumber(value) ? definition.toDefaultUnit(value) : value);
      }
      if (keyframes.length === 1 && (!supports.partialKeyframes() || isRecording)) {
        keyframes.unshift(readInitialValue());
      }
      const animationOptions = {
        delay: time.ms(delay),
        duration: time.ms(duration),
        endDelay: time.ms(endDelay),
        easing: !isEasingList(easing) ? convertEasing(easing) : void 0,
        direction,
        iterations: repeat + 1,
        fill: "both"
      };
      animation = element.animate({
        [name]: keyframes,
        offset: offset3,
        easing: isEasingList(easing) ? easing.map(convertEasing) : void 0
      }, animationOptions);
      if (!animation.finished) {
        animation.finished = new Promise((resolve, reject) => {
          animation.onfinish = resolve;
          animation.oncancel = reject;
        });
      }
      const target = keyframes[keyframes.length - 1];
      animation.finished.then(() => {
        style.set(element, name, target);
        animation.cancel();
      }).catch(noop);
      if (!allowWebkitAcceleration)
        animation.playbackRate = 1.000001;
    } else if (valueIsTransform) {
      keyframes = keyframes.map((value) => typeof value === "string" ? parseFloat(value) : value);
      if (keyframes.length === 1) {
        keyframes.unshift(parseFloat(readInitialValue()));
      }
      const render = (latest) => {
        if (definition)
          latest = definition.toDefaultUnit(latest);
        style.set(element, name, latest);
      };
      animation = new Animation(render, keyframes, Object.assign(Object.assign({}, options), {
        duration,
        easing
      }));
    } else {
      const target = keyframes[keyframes.length - 1];
      style.set(element, name, definition && isNumber(target) ? definition.toDefaultUnit(target) : target);
    }
    if (isRecording) {
      record(element, key, keyframes, {
        duration,
        delay,
        easing,
        repeat,
        offset: offset3
      }, "motion-one");
    }
    motionValue.setAnimation(animation);
    return animation;
  };
}
var init_animate_style_es = __esm({
  "node_modules/@motionone/dom/dist/animate/animate-style.es.js"() {
    init_data_es();
    init_css_var_es();
    init_index_es4();
    init_index_es2();
    init_transforms_es();
    init_easing_es3();
    init_feature_detection_es();
    init_keyframes_es();
    init_style_es();
    init_get_style_name_es();
    init_stop_animation_es();
  }
});

// node_modules/@motionone/dom/dist/animate/utils/options.es.js
var getOptions;
var init_options_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/options.es.js"() {
    getOptions = (options, key) => (
      /**
       * TODO: Make test for this
       * Always return a new object otherwise delay is overwritten by results of stagger
       * and this results in no stagger
       */
      options[key] ? Object.assign(Object.assign({}, options), options[key]) : Object.assign({}, options)
    );
  }
});

// node_modules/@motionone/dom/dist/utils/resolve-elements.es.js
function resolveElements(elements, selectorCache) {
  var _a;
  if (typeof elements === "string") {
    if (selectorCache) {
      (_a = selectorCache[elements]) !== null && _a !== void 0 ? _a : selectorCache[elements] = document.querySelectorAll(elements);
      elements = selectorCache[elements];
    } else {
      elements = document.querySelectorAll(elements);
    }
  } else if (elements instanceof Element) {
    elements = [elements];
  }
  return Array.from(elements || []);
}
var init_resolve_elements_es = __esm({
  "node_modules/@motionone/dom/dist/utils/resolve-elements.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/animate/utils/controls.es.js
var createAnimation, withControls, getActiveAnimation, controls, selectFinished;
var init_controls_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/controls.es.js"() {
    init_index_es2();
    init_stop_animation_es();
    createAnimation = (factory) => factory();
    withControls = (animationFactory, options, duration = defaults.duration) => {
      return new Proxy({
        animations: animationFactory.map(createAnimation).filter(Boolean),
        duration,
        options
      }, controls);
    };
    getActiveAnimation = (state) => state.animations[0];
    controls = {
      get: (target, key) => {
        const activeAnimation = getActiveAnimation(target);
        switch (key) {
          case "duration":
            return target.duration;
          case "currentTime":
            return time.s((activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key]) || 0);
          case "playbackRate":
          case "playState":
            return activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key];
          case "finished":
            if (!target.finished) {
              target.finished = Promise.all(target.animations.map(selectFinished)).catch(noop);
            }
            return target.finished;
          case "stop":
            return () => {
              target.animations.forEach((animation) => stopAnimation(animation));
            };
          case "forEachNative":
            return (callback) => {
              target.animations.forEach((animation) => callback(animation, target));
            };
          default:
            return typeof (activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key]) === "undefined" ? void 0 : () => target.animations.forEach((animation) => animation[key]());
        }
      },
      set: (target, key, value) => {
        switch (key) {
          case "currentTime":
            value = time.ms(value);
          case "currentTime":
          case "playbackRate":
            for (let i = 0; i < target.animations.length; i++) {
              target.animations[i][key] = value;
            }
            return true;
        }
        return false;
      }
    };
    selectFinished = (animation) => animation.finished;
  }
});

// node_modules/@motionone/dom/dist/utils/stagger.es.js
function stagger(duration = 0.1, { start = 0, from = 0, easing } = {}) {
  return (i, total) => {
    const fromIndex = isNumber(from) ? from : getFromIndex(from, total);
    const distance = Math.abs(fromIndex - i);
    let delay = duration * distance;
    if (easing) {
      const maxDelay = total * duration;
      const easingFunction = getEasingFunction(easing);
      delay = easingFunction(delay / maxDelay) * maxDelay;
    }
    return start + delay;
  };
}
function getFromIndex(from, total) {
  if (from === "first") {
    return 0;
  } else {
    const lastIndex = total - 1;
    return from === "last" ? lastIndex : lastIndex / 2;
  }
}
function resolveOption(option, i, total) {
  return typeof option === "function" ? option(i, total) : option;
}
var init_stagger_es = __esm({
  "node_modules/@motionone/dom/dist/utils/stagger.es.js"() {
    init_index_es2();
    init_index_es4();
  }
});

// node_modules/@motionone/dom/dist/animate/index.es.js
function animate(elements, keyframes, options = {}) {
  elements = resolveElements(elements);
  const numElements = elements.length;
  const animationFactories = [];
  for (let i = 0; i < numElements; i++) {
    const element = elements[i];
    for (const key in keyframes) {
      const valueOptions = getOptions(options, key);
      valueOptions.delay = resolveOption(valueOptions.delay, i, numElements);
      const animation = animateStyle(element, key, keyframes[key], valueOptions);
      animationFactories.push(animation);
    }
  }
  return withControls(
    animationFactories,
    options,
    /**
     * TODO:
     * If easing is set to spring or glide, duration will be dynamically
     * generated. Ideally we would dynamically generate this from
     * animation.effect.getComputedTiming().duration but this isn't
     * supported in iOS13 or our number polyfill. Perhaps it's possible
     * to Proxy animations returned from animateStyle that has duration
     * as a getter.
     */
    options.duration
  );
}
var init_index_es5 = __esm({
  "node_modules/@motionone/dom/dist/animate/index.es.js"() {
    init_animate_style_es();
    init_options_es();
    init_resolve_elements_es();
    init_controls_es();
    init_stagger_es();
  }
});

// node_modules/@motionone/dom/dist/timeline/utils/calc-time.es.js
function calcNextTime(current, next, prev, labels) {
  var _a;
  if (isNumber(next)) {
    return next;
  } else if (next.startsWith("-") || next.startsWith("+")) {
    return Math.max(0, current + parseFloat(next));
  } else if (next === "<") {
    return prev;
  } else {
    return (_a = labels.get(next)) !== null && _a !== void 0 ? _a : current;
  }
}
var init_calc_time_es = __esm({
  "node_modules/@motionone/dom/dist/timeline/utils/calc-time.es.js"() {
    init_index_es2();
  }
});

// node_modules/@motionone/dom/dist/timeline/utils/edit.es.js
function eraseKeyframes(sequence, startTime, endTime) {
  for (let i = 0; i < sequence.length; i++) {
    const keyframe = sequence[i];
    if (keyframe.at > startTime && keyframe.at < endTime) {
      removeItem(sequence, keyframe);
      i--;
    }
  }
}
function addKeyframes(sequence, keyframes, easing, offset3, startTime, endTime) {
  eraseKeyframes(sequence, startTime, endTime);
  for (let i = 0; i < keyframes.length; i++) {
    sequence.push({
      value: keyframes[i],
      at: mix(startTime, endTime, offset3[i]),
      easing: getEasingForSegment(easing, i)
    });
  }
}
var init_edit_es = __esm({
  "node_modules/@motionone/dom/dist/timeline/utils/edit.es.js"() {
    init_index_es2();
  }
});

// node_modules/@motionone/dom/dist/timeline/utils/sort.es.js
function compareByTime(a, b) {
  if (a.at === b.at) {
    return a.value === null ? 1 : -1;
  } else {
    return a.at - b.at;
  }
}
var init_sort_es = __esm({
  "node_modules/@motionone/dom/dist/timeline/utils/sort.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/timeline/index.es.js
function timeline(definition, options = {}) {
  var _a;
  const animationDefinitions = createAnimationsFromTimeline(definition, options);
  const animationFactories = animationDefinitions.map((definition2) => animateStyle(...definition2)).filter(Boolean);
  return withControls(
    animationFactories,
    options,
    // Get the duration from the first animation definition
    (_a = animationDefinitions[0]) === null || _a === void 0 ? void 0 : _a[3].duration
  );
}
function createAnimationsFromTimeline(definition, _a = {}) {
  var { defaultOptions = {} } = _a, timelineOptions = __rest(_a, ["defaultOptions"]);
  const animationDefinitions = [];
  const elementSequences = /* @__PURE__ */ new Map();
  const elementCache = {};
  const timeLabels = /* @__PURE__ */ new Map();
  let prevTime = 0;
  let currentTime = 0;
  let totalDuration = 0;
  for (let i = 0; i < definition.length; i++) {
    const segment = definition[i];
    if (isString(segment)) {
      timeLabels.set(segment, currentTime);
      continue;
    } else if (!Array.isArray(segment)) {
      timeLabels.set(segment.name, calcNextTime(currentTime, segment.at, prevTime, timeLabels));
      continue;
    }
    const [elementDefinition, keyframes, options = {}] = segment;
    if (options.at !== void 0) {
      currentTime = calcNextTime(currentTime, options.at, prevTime, timeLabels);
    }
    let maxDuration2 = 0;
    const elements = resolveElements(elementDefinition, elementCache);
    const numElements = elements.length;
    for (let elementIndex = 0; elementIndex < numElements; elementIndex++) {
      const element = elements[elementIndex];
      const elementSequence = getElementSequence(element, elementSequences);
      for (const key in keyframes) {
        const valueSequence = getValueSequence(key, elementSequence);
        let valueKeyframes = keyframesList(keyframes[key]);
        const valueOptions = getOptions(options, key);
        let { duration = defaultOptions.duration || defaults.duration, easing = defaultOptions.easing || defaults.easing } = valueOptions;
        if (isEasingGenerator(easing)) {
          const valueIsTransform = isTransform(key);
          invariant(valueKeyframes.length === 2 || !valueIsTransform, "spring must be provided 2 keyframes within timeline");
          const custom = easing.createAnimation(
            valueKeyframes,
            // TODO We currently only support explicit keyframes
            // so this doesn't currently read from the DOM
            () => "0",
            valueIsTransform
          );
          easing = custom.easing;
          if (custom.keyframes !== void 0)
            valueKeyframes = custom.keyframes;
          if (custom.duration !== void 0)
            duration = custom.duration;
        }
        const delay = resolveOption(options.delay, elementIndex, numElements) || 0;
        const startTime = currentTime + delay;
        const targetTime = startTime + duration;
        let { offset: offset3 = defaultOffset(valueKeyframes.length) } = valueOptions;
        if (offset3.length === 1 && offset3[0] === 0) {
          offset3[1] = 1;
        }
        const remainder = length - valueKeyframes.length;
        remainder > 0 && fillOffset(offset3, remainder);
        valueKeyframes.length === 1 && valueKeyframes.unshift(null);
        addKeyframes(valueSequence, valueKeyframes, easing, offset3, startTime, targetTime);
        maxDuration2 = Math.max(delay + duration, maxDuration2);
        totalDuration = Math.max(targetTime, totalDuration);
      }
    }
    prevTime = currentTime;
    currentTime += maxDuration2;
  }
  elementSequences.forEach((valueSequences, element) => {
    for (const key in valueSequences) {
      const valueSequence = valueSequences[key];
      valueSequence.sort(compareByTime);
      const keyframes = [];
      const valueOffset = [];
      const valueEasing = [];
      for (let i = 0; i < valueSequence.length; i++) {
        const { at, value, easing } = valueSequence[i];
        keyframes.push(value);
        valueOffset.push(progress(0, totalDuration, at));
        valueEasing.push(easing || defaults.easing);
      }
      if (valueOffset[0] !== 0) {
        valueOffset.unshift(0);
        keyframes.unshift(keyframes[0]);
        valueEasing.unshift("linear");
      }
      if (valueOffset[valueOffset.length - 1] !== 1) {
        valueOffset.push(1);
        keyframes.push(null);
      }
      animationDefinitions.push([
        element,
        key,
        keyframes,
        Object.assign(Object.assign(Object.assign({}, defaultOptions), { duration: totalDuration, easing: valueEasing, offset: valueOffset }), timelineOptions)
      ]);
    }
  });
  return animationDefinitions;
}
function getElementSequence(element, sequences) {
  !sequences.has(element) && sequences.set(element, {});
  return sequences.get(element);
}
function getValueSequence(name, sequences) {
  if (!sequences[name])
    sequences[name] = [];
  return sequences[name];
}
var init_index_es6 = __esm({
  "node_modules/@motionone/dom/dist/timeline/index.es.js"() {
    init_tslib_es6();
    init_hey_listen_es();
    init_index_es2();
    init_stagger_es();
    init_animate_style_es();
    init_controls_es();
    init_keyframes_es();
    init_options_es();
    init_resolve_elements_es();
    init_transforms_es();
    init_calc_time_es();
    init_edit_es();
    init_sort_es();
  }
});

// node_modules/@motionone/generators/dist/utils/velocity.es.js
function calcGeneratorVelocity(resolveValue, t, current) {
  const prevT = Math.max(t - sampleT, 0);
  return velocityPerSecond(current - resolveValue(prevT), t - prevT);
}
var sampleT;
var init_velocity_es2 = __esm({
  "node_modules/@motionone/generators/dist/utils/velocity.es.js"() {
    init_index_es2();
    sampleT = 5;
  }
});

// node_modules/@motionone/generators/dist/spring/defaults.es.js
var defaults2;
var init_defaults_es2 = __esm({
  "node_modules/@motionone/generators/dist/spring/defaults.es.js"() {
    defaults2 = {
      stiffness: 100,
      damping: 10,
      mass: 1
    };
  }
});

// node_modules/@motionone/generators/dist/spring/utils.es.js
var calcDampingRatio;
var init_utils_es = __esm({
  "node_modules/@motionone/generators/dist/spring/utils.es.js"() {
    init_defaults_es2();
    calcDampingRatio = (stiffness = defaults2.stiffness, damping = defaults2.damping, mass = defaults2.mass) => damping / (2 * Math.sqrt(stiffness * mass));
  }
});

// node_modules/@motionone/generators/dist/utils/has-reached-target.es.js
function hasReachedTarget(origin, target, current) {
  return origin < target && current >= target || origin > target && current <= target;
}
var init_has_reached_target_es = __esm({
  "node_modules/@motionone/generators/dist/utils/has-reached-target.es.js"() {
  }
});

// node_modules/@motionone/generators/dist/spring/index.es.js
var spring;
var init_index_es7 = __esm({
  "node_modules/@motionone/generators/dist/spring/index.es.js"() {
    init_index_es2();
    init_defaults_es2();
    init_utils_es();
    init_has_reached_target_es();
    init_velocity_es2();
    spring = ({ stiffness = defaults2.stiffness, damping = defaults2.damping, mass = defaults2.mass, from = 0, to = 1, velocity = 0, restSpeed, restDistance } = {}) => {
      velocity = velocity ? time.s(velocity) : 0;
      const state = {
        done: false,
        hasReachedTarget: false,
        current: from,
        target: to
      };
      const initialDelta = to - from;
      const undampedAngularFreq = Math.sqrt(stiffness / mass) / 1e3;
      const dampingRatio = calcDampingRatio(stiffness, damping, mass);
      const isGranularScale = Math.abs(initialDelta) < 5;
      restSpeed || (restSpeed = isGranularScale ? 0.01 : 2);
      restDistance || (restDistance = isGranularScale ? 5e-3 : 0.5);
      let resolveSpring;
      if (dampingRatio < 1) {
        const angularFreq = undampedAngularFreq * Math.sqrt(1 - dampingRatio * dampingRatio);
        resolveSpring = (t) => to - Math.exp(-dampingRatio * undampedAngularFreq * t) * ((-velocity + dampingRatio * undampedAngularFreq * initialDelta) / angularFreq * Math.sin(angularFreq * t) + initialDelta * Math.cos(angularFreq * t));
      } else {
        resolveSpring = (t) => {
          return to - Math.exp(-undampedAngularFreq * t) * (initialDelta + (-velocity + undampedAngularFreq * initialDelta) * t);
        };
      }
      return (t) => {
        state.current = resolveSpring(t);
        const currentVelocity = t === 0 ? velocity : calcGeneratorVelocity(resolveSpring, t, state.current);
        const isBelowVelocityThreshold = Math.abs(currentVelocity) <= restSpeed;
        const isBelowDisplacementThreshold = Math.abs(to - state.current) <= restDistance;
        state.done = isBelowVelocityThreshold && isBelowDisplacementThreshold;
        state.hasReachedTarget = hasReachedTarget(from, to, state.current);
        return state;
      };
    };
  }
});

// node_modules/@motionone/generators/dist/glide/index.es.js
var glide;
var init_index_es8 = __esm({
  "node_modules/@motionone/generators/dist/glide/index.es.js"() {
    init_index_es2();
    init_velocity_es2();
    init_index_es7();
    glide = ({ from = 0, velocity = 0, power = 0.8, decay = 0.325, bounceDamping, bounceStiffness, changeTarget, min: min2, max: max2, restDistance = 0.5, restSpeed }) => {
      decay = time.ms(decay);
      const state = {
        hasReachedTarget: false,
        done: false,
        current: from,
        target: from
      };
      const isOutOfBounds = (v) => min2 !== void 0 && v < min2 || max2 !== void 0 && v > max2;
      const nearestBoundary = (v) => {
        if (min2 === void 0)
          return max2;
        if (max2 === void 0)
          return min2;
        return Math.abs(min2 - v) < Math.abs(max2 - v) ? min2 : max2;
      };
      let amplitude = power * velocity;
      const ideal = from + amplitude;
      const target = changeTarget === void 0 ? ideal : changeTarget(ideal);
      state.target = target;
      if (target !== ideal)
        amplitude = target - from;
      const calcDelta = (t) => -amplitude * Math.exp(-t / decay);
      const calcLatest = (t) => target + calcDelta(t);
      const applyFriction = (t) => {
        const delta = calcDelta(t);
        const latest = calcLatest(t);
        state.done = Math.abs(delta) <= restDistance;
        state.current = state.done ? target : latest;
      };
      let timeReachedBoundary;
      let spring$1;
      const checkCatchBoundary = (t) => {
        if (!isOutOfBounds(state.current))
          return;
        timeReachedBoundary = t;
        spring$1 = spring({
          from: state.current,
          to: nearestBoundary(state.current),
          velocity: calcGeneratorVelocity(calcLatest, t, state.current),
          // TODO: This should be passing * 1000
          damping: bounceDamping,
          stiffness: bounceStiffness,
          restDistance,
          restSpeed
        });
      };
      checkCatchBoundary(0);
      return (t) => {
        let hasUpdatedFrame = false;
        if (!spring$1 && timeReachedBoundary === void 0) {
          hasUpdatedFrame = true;
          applyFriction(t);
          checkCatchBoundary(t);
        }
        if (timeReachedBoundary !== void 0 && t > timeReachedBoundary) {
          state.hasReachedTarget = true;
          return spring$1(t - timeReachedBoundary);
        } else {
          state.hasReachedTarget = false;
          !hasUpdatedFrame && applyFriction(t);
          return state;
        }
      };
    };
  }
});

// node_modules/@motionone/generators/dist/utils/pregenerate-keyframes.es.js
function pregenerateKeyframes(generator, toUnit = noopReturn) {
  let overshootDuration = void 0;
  let timestamp = timeStep;
  let state = generator(0);
  const keyframes = [toUnit(state.current)];
  while (!state.done && timestamp < maxDuration) {
    state = generator(timestamp);
    keyframes.push(toUnit(state.done ? state.target : state.current));
    if (overshootDuration === void 0 && state.hasReachedTarget) {
      overshootDuration = timestamp;
    }
    timestamp += timeStep;
  }
  const duration = timestamp - timeStep;
  if (keyframes.length === 1)
    keyframes.push(state.current);
  return {
    keyframes,
    duration: duration / 1e3,
    overshootDuration: (overshootDuration !== null && overshootDuration !== void 0 ? overshootDuration : duration) / 1e3
  };
}
var timeStep, maxDuration;
var init_pregenerate_keyframes_es = __esm({
  "node_modules/@motionone/generators/dist/utils/pregenerate-keyframes.es.js"() {
    init_index_es2();
    timeStep = 10;
    maxDuration = 1e4;
  }
});

// node_modules/@motionone/generators/dist/index.es.js
var init_index_es9 = __esm({
  "node_modules/@motionone/generators/dist/index.es.js"() {
    init_index_es8();
    init_index_es7();
    init_pregenerate_keyframes_es();
    init_velocity_es2();
  }
});

// node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js
function createGeneratorEasing(createGenerator) {
  const keyframesCache = /* @__PURE__ */ new WeakMap();
  return (options = {}) => {
    const generatorCache = /* @__PURE__ */ new Map();
    const getGenerator = (from = 0, to = 100, velocity = 0, isScale = false) => {
      const key = `${from}-${to}-${velocity}-${isScale}`;
      if (!generatorCache.has(key)) {
        generatorCache.set(key, createGenerator(Object.assign({
          from,
          to,
          velocity,
          restSpeed: isScale ? 0.05 : 2,
          restDistance: isScale ? 0.01 : 0.5
        }, options)));
      }
      return generatorCache.get(key);
    };
    const getKeyframes = (generator) => {
      if (!keyframesCache.has(generator)) {
        keyframesCache.set(generator, pregenerateKeyframes(generator));
      }
      return keyframesCache.get(generator);
    };
    return {
      createAnimation: (keyframes, getOrigin, canUseGenerator, name, motionValue) => {
        var _a, _b;
        let settings;
        const numKeyframes = keyframes.length;
        let shouldUseGenerator = canUseGenerator && numKeyframes <= 2 && keyframes.every(isNumberOrNull);
        if (shouldUseGenerator) {
          const target = keyframes[numKeyframes - 1];
          const unresolvedOrigin = numKeyframes === 1 ? null : keyframes[0];
          let velocity = 0;
          let origin = 0;
          const prevGenerator = motionValue === null || motionValue === void 0 ? void 0 : motionValue.generator;
          if (prevGenerator) {
            const { animation, generatorStartTime } = motionValue;
            const startTime = (animation === null || animation === void 0 ? void 0 : animation.startTime) || generatorStartTime || 0;
            const currentTime = (animation === null || animation === void 0 ? void 0 : animation.currentTime) || performance.now() - startTime;
            const prevGeneratorCurrent = prevGenerator(currentTime).current;
            origin = (_a = unresolvedOrigin) !== null && _a !== void 0 ? _a : prevGeneratorCurrent;
            if (numKeyframes === 1 || numKeyframes === 2 && keyframes[0] === null) {
              velocity = calcGeneratorVelocity((t) => prevGenerator(t).current, currentTime, prevGeneratorCurrent);
            }
          } else {
            origin = (_b = unresolvedOrigin) !== null && _b !== void 0 ? _b : parseFloat(getOrigin());
          }
          const generator = getGenerator(origin, target, velocity, name === null || name === void 0 ? void 0 : name.includes("scale"));
          const keyframesMetadata = getKeyframes(generator);
          settings = Object.assign(Object.assign({}, keyframesMetadata), { easing: "linear" });
          if (motionValue) {
            motionValue.generator = generator;
            motionValue.generatorStartTime = performance.now();
          }
        } else {
          const keyframesMetadata = getKeyframes(getGenerator(0, 100));
          settings = {
            easing: "ease",
            duration: keyframesMetadata.overshootDuration
          };
        }
        return settings;
      }
    };
  };
}
var isNumberOrNull;
var init_create_generator_easing_es = __esm({
  "node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js"() {
    init_index_es9();
    isNumberOrNull = (value) => typeof value !== "string";
  }
});

// node_modules/@motionone/dom/dist/easing/spring/index.es.js
var spring2;
var init_index_es10 = __esm({
  "node_modules/@motionone/dom/dist/easing/spring/index.es.js"() {
    init_index_es9();
    init_create_generator_easing_es();
    spring2 = createGeneratorEasing(spring);
  }
});

// node_modules/@motionone/dom/dist/easing/glide/index.es.js
var glide2;
var init_index_es11 = __esm({
  "node_modules/@motionone/dom/dist/easing/glide/index.es.js"() {
    init_index_es9();
    init_create_generator_easing_es();
    glide2 = createGeneratorEasing(glide);
  }
});

// node_modules/@motionone/dom/dist/gestures/in-view.es.js
function inView(elementOrSelector, onStart, { root, margin: rootMargin, amount = "any" } = {}) {
  if (typeof IntersectionObserver === "undefined") {
    return () => {
    };
  }
  const elements = resolveElements(elementOrSelector);
  const activeIntersections = /* @__PURE__ */ new WeakMap();
  const onIntersectionChange = (entries) => {
    entries.forEach((entry) => {
      const onEnd = activeIntersections.get(entry.target);
      if (entry.isIntersecting === Boolean(onEnd))
        return;
      if (entry.isIntersecting) {
        const newOnEnd = onStart(entry);
        if (typeof newOnEnd === "function") {
          activeIntersections.set(entry.target, newOnEnd);
        } else {
          observer2.unobserve(entry.target);
        }
      } else if (onEnd) {
        onEnd(entry);
        activeIntersections.delete(entry.target);
      }
    });
  };
  const observer2 = new IntersectionObserver(onIntersectionChange, {
    root,
    rootMargin,
    threshold: typeof amount === "number" ? amount : thresholds[amount]
  });
  elements.forEach((element) => observer2.observe(element));
  return () => observer2.disconnect();
}
var thresholds;
var init_in_view_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/in-view.es.js"() {
    init_resolve_elements_es();
    thresholds = {
      any: 0,
      all: 1
    };
  }
});

// node_modules/@motionone/dom/dist/gestures/resize/handle-element.es.js
function getElementSize(target, borderBoxSize) {
  if (borderBoxSize) {
    const { inlineSize, blockSize } = borderBoxSize[0];
    return { width: inlineSize, height: blockSize };
  } else if (target instanceof SVGElement && "getBBox" in target) {
    return target.getBBox();
  } else {
    return {
      width: target.offsetWidth,
      height: target.offsetHeight
    };
  }
}
function notifyTarget({ target, contentRect, borderBoxSize }) {
  var _a;
  (_a = resizeHandlers.get(target)) === null || _a === void 0 ? void 0 : _a.forEach((handler) => {
    handler({
      target,
      contentSize: contentRect,
      get size() {
        return getElementSize(target, borderBoxSize);
      }
    });
  });
}
function notifyAll(entries) {
  entries.forEach(notifyTarget);
}
function createResizeObserver() {
  if (typeof ResizeObserver === "undefined")
    return;
  observer = new ResizeObserver(notifyAll);
}
function resizeElement(target, handler) {
  if (!observer)
    createResizeObserver();
  const elements = resolveElements(target);
  elements.forEach((element) => {
    let elementHandlers = resizeHandlers.get(element);
    if (!elementHandlers) {
      elementHandlers = /* @__PURE__ */ new Set();
      resizeHandlers.set(element, elementHandlers);
    }
    elementHandlers.add(handler);
    observer === null || observer === void 0 ? void 0 : observer.observe(element);
  });
  return () => {
    elements.forEach((element) => {
      const elementHandlers = resizeHandlers.get(element);
      elementHandlers === null || elementHandlers === void 0 ? void 0 : elementHandlers.delete(handler);
      if (!(elementHandlers === null || elementHandlers === void 0 ? void 0 : elementHandlers.size)) {
        observer === null || observer === void 0 ? void 0 : observer.unobserve(element);
      }
    });
  };
}
var resizeHandlers, observer;
var init_handle_element_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/resize/handle-element.es.js"() {
    init_resolve_elements_es();
    resizeHandlers = /* @__PURE__ */ new WeakMap();
  }
});

// node_modules/@motionone/dom/dist/gestures/resize/handle-window.es.js
function createWindowResizeHandler() {
  windowResizeHandler = () => {
    const size3 = {
      width: window.innerWidth,
      height: window.innerHeight
    };
    const info = {
      target: window,
      size: size3,
      contentSize: size3
    };
    windowCallbacks.forEach((callback) => callback(info));
  };
  window.addEventListener("resize", windowResizeHandler);
}
function resizeWindow(callback) {
  windowCallbacks.add(callback);
  if (!windowResizeHandler)
    createWindowResizeHandler();
  return () => {
    windowCallbacks.delete(callback);
    if (!windowCallbacks.size && windowResizeHandler) {
      windowResizeHandler = void 0;
    }
  };
}
var windowCallbacks, windowResizeHandler;
var init_handle_window_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/resize/handle-window.es.js"() {
    windowCallbacks = /* @__PURE__ */ new Set();
  }
});

// node_modules/@motionone/dom/dist/gestures/resize/index.es.js
function resize(a, b) {
  return typeof a === "function" ? resizeWindow(a) : resizeElement(a, b);
}
var init_index_es12 = __esm({
  "node_modules/@motionone/dom/dist/gestures/resize/index.es.js"() {
    init_handle_element_es();
    init_handle_window_es();
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/info.es.js
function updateAxisInfo(element, axisName, info, time2) {
  const axis = info[axisName];
  const { length: length2, position } = keys[axisName];
  const prev = axis.current;
  const prevTime = info.time;
  axis.current = element["scroll" + position];
  axis.scrollLength = element["scroll" + length2] - element["client" + length2];
  axis.offset.length = 0;
  axis.offset[0] = 0;
  axis.offset[1] = axis.scrollLength;
  axis.progress = progress(0, axis.scrollLength, axis.current);
  const elapsed = time2 - prevTime;
  axis.velocity = elapsed > maxElapsed ? 0 : velocityPerSecond(axis.current - prev, elapsed);
}
function updateScrollInfo(element, info, time2) {
  updateAxisInfo(element, "x", info, time2);
  updateAxisInfo(element, "y", info, time2);
  info.time = time2;
}
var maxElapsed, createAxisInfo, createScrollInfo, keys;
var init_info_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/info.es.js"() {
    init_index_es2();
    maxElapsed = 50;
    createAxisInfo = () => ({
      current: 0,
      offset: [],
      progress: 0,
      scrollLength: 0,
      targetOffset: 0,
      targetLength: 0,
      containerLength: 0,
      velocity: 0
    });
    createScrollInfo = () => ({
      time: 0,
      x: createAxisInfo(),
      y: createAxisInfo()
    });
    keys = {
      x: {
        length: "Width",
        position: "Left"
      },
      y: {
        length: "Height",
        position: "Top"
      }
    };
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/offsets/inset.es.js
function calcInset(element, container) {
  let inset = { x: 0, y: 0 };
  let current = element;
  while (current && current !== container) {
    if (current instanceof HTMLElement) {
      inset.x += current.offsetLeft;
      inset.y += current.offsetTop;
      current = current.offsetParent;
    } else if (current instanceof SVGGraphicsElement && "getBBox" in current) {
      const { top, left } = current.getBBox();
      inset.x += left;
      inset.y += top;
      while (current && current.tagName !== "svg") {
        current = current.parentNode;
      }
    }
  }
  return inset;
}
var init_inset_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/offsets/inset.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js
var ScrollOffset;
var init_presets_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js"() {
    ScrollOffset = {
      Enter: [
        [0, 1],
        [1, 1]
      ],
      Exit: [
        [0, 0],
        [1, 0]
      ],
      Any: [
        [1, 0],
        [0, 1]
      ],
      All: [
        [0, 0],
        [1, 1]
      ]
    };
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/offsets/edge.es.js
function resolveEdge(edge, length2, inset = 0) {
  let delta = 0;
  if (namedEdges[edge] !== void 0) {
    edge = namedEdges[edge];
  }
  if (isString(edge)) {
    const asNumber = parseFloat(edge);
    if (edge.endsWith("px")) {
      delta = asNumber;
    } else if (edge.endsWith("%")) {
      edge = asNumber / 100;
    } else if (edge.endsWith("vw")) {
      delta = asNumber / 100 * document.documentElement.clientWidth;
    } else if (edge.endsWith("vh")) {
      delta = asNumber / 100 * document.documentElement.clientHeight;
    } else {
      edge = asNumber;
    }
  }
  if (isNumber(edge)) {
    delta = length2 * edge;
  }
  return inset + delta;
}
var namedEdges;
var init_edge_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/offsets/edge.es.js"() {
    init_index_es2();
    namedEdges = {
      start: 0,
      center: 0.5,
      end: 1
    };
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/offsets/offset.es.js
function resolveOffset(offset3, containerLength, targetLength, targetInset) {
  let offsetDefinition = Array.isArray(offset3) ? offset3 : defaultOffset2;
  let targetPoint = 0;
  let containerPoint = 0;
  if (isNumber(offset3)) {
    offsetDefinition = [offset3, offset3];
  } else if (isString(offset3)) {
    offset3 = offset3.trim();
    if (offset3.includes(" ")) {
      offsetDefinition = offset3.split(" ");
    } else {
      offsetDefinition = [offset3, namedEdges[offset3] ? offset3 : `0`];
    }
  }
  targetPoint = resolveEdge(offsetDefinition[0], targetLength, targetInset);
  containerPoint = resolveEdge(offsetDefinition[1], containerLength);
  return targetPoint - containerPoint;
}
var defaultOffset2;
var init_offset_es2 = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/offsets/offset.es.js"() {
    init_index_es2();
    init_edge_es();
    defaultOffset2 = [0, 0];
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/offsets/index.es.js
function resolveOffsets(container, info, options) {
  let { offset: offsetDefinition = ScrollOffset.All } = options;
  const { target = container, axis = "y" } = options;
  const lengthLabel = axis === "y" ? "height" : "width";
  const inset = target !== container ? calcInset(target, container) : point;
  const targetSize = target === container ? { width: container.scrollWidth, height: container.scrollHeight } : { width: target.clientWidth, height: target.clientHeight };
  const containerSize = {
    width: container.clientWidth,
    height: container.clientHeight
  };
  info[axis].offset.length = 0;
  let hasChanged2 = !info[axis].interpolate;
  const numOffsets = offsetDefinition.length;
  for (let i = 0; i < numOffsets; i++) {
    const offset3 = resolveOffset(offsetDefinition[i], containerSize[lengthLabel], targetSize[lengthLabel], inset[axis]);
    if (!hasChanged2 && offset3 !== info[axis].interpolatorOffsets[i]) {
      hasChanged2 = true;
    }
    info[axis].offset[i] = offset3;
  }
  if (hasChanged2) {
    info[axis].interpolate = interpolate(defaultOffset(numOffsets), info[axis].offset);
    info[axis].interpolatorOffsets = [...info[axis].offset];
  }
  info[axis].progress = info[axis].interpolate(info[axis].current);
}
var point;
var init_index_es13 = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/offsets/index.es.js"() {
    init_index_es2();
    init_inset_es();
    init_presets_es();
    init_offset_es2();
    point = { x: 0, y: 0 };
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/on-scroll-handler.es.js
function measure(container, target = container, info) {
  info.x.targetOffset = 0;
  info.y.targetOffset = 0;
  if (target !== container) {
    let node = target;
    while (node && node != container) {
      info.x.targetOffset += node.offsetLeft;
      info.y.targetOffset += node.offsetTop;
      node = node.offsetParent;
    }
  }
  info.x.targetLength = target === container ? target.scrollWidth : target.clientWidth;
  info.y.targetLength = target === container ? target.scrollHeight : target.clientHeight;
  info.x.containerLength = container.clientWidth;
  info.y.containerLength = container.clientHeight;
}
function createOnScrollHandler(element, onScroll, info, options = {}) {
  const axis = options.axis || "y";
  return {
    measure: () => measure(element, options.target, info),
    update: (time2) => {
      updateScrollInfo(element, info, time2);
      if (options.offset || options.target) {
        resolveOffsets(element, info, options);
      }
    },
    notify: typeof onScroll === "function" ? () => onScroll(info) : scrubAnimation(onScroll, info[axis])
  };
}
function scrubAnimation(controls2, axisInfo) {
  controls2.pause();
  controls2.forEachNative((animation, { easing }) => {
    var _a, _b;
    if (animation.updateDuration) {
      if (!easing)
        animation.easing = noopReturn;
      animation.updateDuration(1);
    } else {
      const timingOptions = { duration: 1e3 };
      if (!easing)
        timingOptions.easing = "linear";
      (_b = (_a = animation.effect) === null || _a === void 0 ? void 0 : _a.updateTiming) === null || _b === void 0 ? void 0 : _b.call(_a, timingOptions);
    }
  });
  return () => {
    controls2.currentTime = axisInfo.progress;
  };
}
var init_on_scroll_handler_es = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/on-scroll-handler.es.js"() {
    init_index_es2();
    init_info_es();
    init_index_es13();
  }
});

// node_modules/@motionone/dom/dist/gestures/scroll/index.es.js
function scroll(onScroll, _a = {}) {
  var { container = document.documentElement } = _a, options = __rest(_a, ["container"]);
  let containerHandlers = onScrollHandlers.get(container);
  if (!containerHandlers) {
    containerHandlers = /* @__PURE__ */ new Set();
    onScrollHandlers.set(container, containerHandlers);
  }
  const info = createScrollInfo();
  const containerHandler = createOnScrollHandler(container, onScroll, info, options);
  containerHandlers.add(containerHandler);
  if (!scrollListeners.has(container)) {
    const listener2 = () => {
      const time2 = performance.now();
      for (const handler of containerHandlers)
        handler.measure();
      for (const handler of containerHandlers)
        handler.update(time2);
      for (const handler of containerHandlers)
        handler.notify();
    };
    scrollListeners.set(container, listener2);
    const target = getEventTarget(container);
    window.addEventListener("resize", listener2, { passive: true });
    if (container !== document.documentElement) {
      resizeListeners.set(container, resize(container, listener2));
    }
    target.addEventListener("scroll", listener2, { passive: true });
  }
  const listener = scrollListeners.get(container);
  const onLoadProcesss = requestAnimationFrame(listener);
  return () => {
    var _a2;
    if (typeof onScroll !== "function")
      onScroll.stop();
    cancelAnimationFrame(onLoadProcesss);
    const containerHandlers2 = onScrollHandlers.get(container);
    if (!containerHandlers2)
      return;
    containerHandlers2.delete(containerHandler);
    if (containerHandlers2.size)
      return;
    const listener2 = scrollListeners.get(container);
    scrollListeners.delete(container);
    if (listener2) {
      getEventTarget(container).removeEventListener("scroll", listener2);
      (_a2 = resizeListeners.get(container)) === null || _a2 === void 0 ? void 0 : _a2();
      window.removeEventListener("resize", listener2);
    }
  };
}
var scrollListeners, resizeListeners, onScrollHandlers, getEventTarget;
var init_index_es14 = __esm({
  "node_modules/@motionone/dom/dist/gestures/scroll/index.es.js"() {
    init_tslib_es6();
    init_index_es12();
    init_info_es();
    init_on_scroll_handler_es();
    scrollListeners = /* @__PURE__ */ new WeakMap();
    resizeListeners = /* @__PURE__ */ new WeakMap();
    onScrollHandlers = /* @__PURE__ */ new WeakMap();
    getEventTarget = (element) => element === document.documentElement ? window : element;
  }
});

// node_modules/@motionone/dom/dist/state/utils/has-changed.es.js
function hasChanged(a, b) {
  if (typeof a !== typeof b)
    return true;
  if (Array.isArray(a) && Array.isArray(b))
    return !shallowCompare(a, b);
  return a !== b;
}
function shallowCompare(next, prev) {
  const prevLength = prev.length;
  if (prevLength !== next.length)
    return false;
  for (let i = 0; i < prevLength; i++) {
    if (prev[i] !== next[i])
      return false;
  }
  return true;
}
var init_has_changed_es = __esm({
  "node_modules/@motionone/dom/dist/state/utils/has-changed.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/state/utils/is-variant.es.js
function isVariant(definition) {
  return typeof definition === "object";
}
var init_is_variant_es = __esm({
  "node_modules/@motionone/dom/dist/state/utils/is-variant.es.js"() {
  }
});

// node_modules/@motionone/dom/dist/state/utils/resolve-variant.es.js
function resolveVariant(definition, variants) {
  if (isVariant(definition)) {
    return definition;
  } else if (definition && variants) {
    return variants[definition];
  }
}
var init_resolve_variant_es = __esm({
  "node_modules/@motionone/dom/dist/state/utils/resolve-variant.es.js"() {
    init_is_variant_es();
  }
});

// node_modules/@motionone/dom/dist/state/utils/schedule.es.js
function processScheduledAnimations() {
  if (!scheduled)
    return;
  const generators = scheduled.sort(compareByDepth).map(fireAnimateUpdates);
  generators.forEach(fireNext);
  generators.forEach(fireNext);
  scheduled = void 0;
}
function scheduleAnimation(state) {
  if (!scheduled) {
    scheduled = [state];
    requestAnimationFrame(processScheduledAnimations);
  } else {
    addUniqueItem(scheduled, state);
  }
}
function unscheduleAnimation(state) {
  scheduled && removeItem(scheduled, state);
}
var scheduled, compareByDepth, fireAnimateUpdates, fireNext;
var init_schedule_es = __esm({
  "node_modules/@motionone/dom/dist/state/utils/schedule.es.js"() {
    init_index_es2();
    scheduled = void 0;
    compareByDepth = (a, b) => a.getDepth() - b.getDepth();
    fireAnimateUpdates = (state) => state.animateUpdates();
    fireNext = (iterator) => iterator.next();
  }
});

// node_modules/@motionone/dom/dist/state/utils/events.es.js
function dispatchPointerEvent(element, name, event) {
  element.dispatchEvent(new CustomEvent(name, { detail: { originalEvent: event } }));
}
function dispatchViewEvent(element, name, entry) {
  element.dispatchEvent(new CustomEvent(name, { detail: { originalEntry: entry } }));
}
var motionEvent;
var init_events_es = __esm({
  "node_modules/@motionone/dom/dist/state/utils/events.es.js"() {
    motionEvent = (name, target) => new CustomEvent(name, { detail: { target } });
  }
});

// node_modules/@motionone/dom/dist/state/gestures/in-view.es.js
var inView2;
var init_in_view_es2 = __esm({
  "node_modules/@motionone/dom/dist/state/gestures/in-view.es.js"() {
    init_tslib_es6();
    init_events_es();
    init_in_view_es();
    inView2 = {
      isActive: (options) => Boolean(options.inView),
      subscribe: (element, { enable, disable }, { inViewOptions = {} }) => {
        const { once } = inViewOptions, viewOptions = __rest(inViewOptions, ["once"]);
        return inView(element, (enterEntry) => {
          enable();
          dispatchViewEvent(element, "viewenter", enterEntry);
          if (!once) {
            return (leaveEntry) => {
              disable();
              dispatchViewEvent(element, "viewleave", leaveEntry);
            };
          }
        }, viewOptions);
      }
    };
  }
});

// node_modules/@motionone/dom/dist/state/gestures/hover.es.js
var mouseEvent, hover;
var init_hover_es = __esm({
  "node_modules/@motionone/dom/dist/state/gestures/hover.es.js"() {
    init_events_es();
    mouseEvent = (element, name, action) => (event) => {
      if (event.pointerType && event.pointerType !== "mouse")
        return;
      action();
      dispatchPointerEvent(element, name, event);
    };
    hover = {
      isActive: (options) => Boolean(options.hover),
      subscribe: (element, { enable, disable }) => {
        const onEnter = mouseEvent(element, "hoverstart", enable);
        const onLeave = mouseEvent(element, "hoverend", disable);
        element.addEventListener("pointerenter", onEnter);
        element.addEventListener("pointerleave", onLeave);
        return () => {
          element.removeEventListener("pointerenter", onEnter);
          element.removeEventListener("pointerleave", onLeave);
        };
      }
    };
  }
});

// node_modules/@motionone/dom/dist/state/gestures/press.es.js
var press;
var init_press_es = __esm({
  "node_modules/@motionone/dom/dist/state/gestures/press.es.js"() {
    init_events_es();
    press = {
      isActive: (options) => Boolean(options.press),
      subscribe: (element, { enable, disable }) => {
        const onPointerUp = (event) => {
          disable();
          dispatchPointerEvent(element, "pressend", event);
          window.removeEventListener("pointerup", onPointerUp);
        };
        const onPointerDown = (event) => {
          enable();
          dispatchPointerEvent(element, "pressstart", event);
          window.addEventListener("pointerup", onPointerUp);
        };
        element.addEventListener("pointerdown", onPointerDown);
        return () => {
          element.removeEventListener("pointerdown", onPointerDown);
          window.removeEventListener("pointerup", onPointerUp);
        };
      }
    };
  }
});

// node_modules/@motionone/dom/dist/state/index.es.js
function createMotionState(options = {}, parent) {
  let element;
  let depth = parent ? parent.getDepth() + 1 : 0;
  const activeStates = { initial: true, animate: true };
  const gestureSubscriptions = {};
  const context = {};
  for (const name of stateTypes) {
    context[name] = typeof options[name] === "string" ? options[name] : parent === null || parent === void 0 ? void 0 : parent.getContext()[name];
  }
  const initialVariantSource = options.initial === false ? "animate" : "initial";
  let _a = resolveVariant(options[initialVariantSource] || context[initialVariantSource], options.variants) || {}, target = __rest(_a, ["transition"]);
  const baseTarget = Object.assign({}, target);
  function* animateUpdates() {
    var _a2, _b;
    const prevTarget = target;
    target = {};
    const animationOptions = {};
    for (const name of stateTypes) {
      if (!activeStates[name])
        continue;
      const variant = resolveVariant(options[name]);
      if (!variant)
        continue;
      for (const key in variant) {
        if (key === "transition")
          continue;
        target[key] = variant[key];
        animationOptions[key] = getOptions((_b = (_a2 = variant.transition) !== null && _a2 !== void 0 ? _a2 : options.transition) !== null && _b !== void 0 ? _b : {}, key);
      }
    }
    const allTargetKeys = /* @__PURE__ */ new Set([
      ...Object.keys(target),
      ...Object.keys(prevTarget)
    ]);
    const animationFactories = [];
    allTargetKeys.forEach((key) => {
      var _a3;
      if (target[key] === void 0) {
        target[key] = baseTarget[key];
      }
      if (hasChanged(prevTarget[key], target[key])) {
        (_a3 = baseTarget[key]) !== null && _a3 !== void 0 ? _a3 : baseTarget[key] = style.get(element, key);
        animationFactories.push(animateStyle(element, key, target[key], animationOptions[key]));
      }
    });
    yield;
    const animations = animationFactories.map((factory) => factory()).filter(Boolean);
    if (!animations.length)
      return;
    const animationTarget = target;
    element.dispatchEvent(motionEvent("motionstart", animationTarget));
    Promise.all(animations.map((animation) => animation.finished)).then(() => {
      element.dispatchEvent(motionEvent("motioncomplete", animationTarget));
    }).catch(noop);
  }
  const setGesture = (name, isActive) => () => {
    activeStates[name] = isActive;
    scheduleAnimation(state);
  };
  const updateGestureSubscriptions = () => {
    for (const name in gestures) {
      const isGestureActive = gestures[name].isActive(options);
      const remove = gestureSubscriptions[name];
      if (isGestureActive && !remove) {
        gestureSubscriptions[name] = gestures[name].subscribe(element, {
          enable: setGesture(name, true),
          disable: setGesture(name, false)
        }, options);
      } else if (!isGestureActive && remove) {
        remove();
        delete gestureSubscriptions[name];
      }
    }
  };
  const state = {
    update: (newOptions) => {
      if (!element)
        return;
      options = newOptions;
      updateGestureSubscriptions();
      scheduleAnimation(state);
    },
    setActive: (name, isActive) => {
      if (!element)
        return;
      activeStates[name] = isActive;
      scheduleAnimation(state);
    },
    animateUpdates,
    getDepth: () => depth,
    getTarget: () => target,
    getOptions: () => options,
    getContext: () => context,
    mount: (newElement) => {
      invariant(Boolean(newElement), "Animation state must be mounted with valid Element");
      element = newElement;
      mountedStates.set(element, state);
      updateGestureSubscriptions();
      return () => {
        mountedStates.delete(element);
        unscheduleAnimation(state);
        for (const key in gestureSubscriptions) {
          gestureSubscriptions[key]();
        }
      };
    },
    isMounted: () => Boolean(element)
  };
  return state;
}
var gestures, stateTypes, mountedStates;
var init_index_es15 = __esm({
  "node_modules/@motionone/dom/dist/state/index.es.js"() {
    init_tslib_es6();
    init_hey_listen_es();
    init_index_es2();
    init_animate_style_es();
    init_style_es();
    init_options_es();
    init_has_changed_es();
    init_resolve_variant_es();
    init_schedule_es();
    init_in_view_es2();
    init_hover_es();
    init_press_es();
    init_events_es();
    gestures = { inView: inView2, hover, press };
    stateTypes = ["initial", "animate", ...Object.keys(gestures), "exit"];
    mountedStates = /* @__PURE__ */ new WeakMap();
  }
});

// node_modules/@motionone/dom/dist/animate/utils/style-object.es.js
function createStyles(keyframes) {
  const initialKeyframes = {};
  const transformKeys = [];
  for (let key in keyframes) {
    const value = keyframes[key];
    if (isTransform(key)) {
      if (transformAlias[key])
        key = transformAlias[key];
      transformKeys.push(key);
      key = asTransformCssVar(key);
    }
    let initialKeyframe = Array.isArray(value) ? value[0] : value;
    const definition = transformDefinitions.get(key);
    if (definition) {
      initialKeyframe = isNumber(value) ? definition.toDefaultUnit(value) : value;
    }
    initialKeyframes[key] = initialKeyframe;
  }
  if (transformKeys.length) {
    initialKeyframes.transform = buildTransformTemplate(transformKeys);
  }
  return initialKeyframes;
}
var init_style_object_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/style-object.es.js"() {
    init_index_es2();
    init_transforms_es();
  }
});

// node_modules/@motionone/dom/dist/animate/utils/style-string.es.js
function createStyleString(target = {}) {
  const styles = createStyles(target);
  let style2 = "";
  for (const key in styles) {
    style2 += key.startsWith("--") ? key : camelToPipeCase(key);
    style2 += `: ${styles[key]}; `;
  }
  return style2;
}
var camelLetterToPipeLetter, camelToPipeCase;
var init_style_string_es = __esm({
  "node_modules/@motionone/dom/dist/animate/utils/style-string.es.js"() {
    init_style_object_es();
    camelLetterToPipeLetter = (letter) => `-${letter.toLowerCase()}`;
    camelToPipeCase = (str) => str.replace(/[A-Z]/g, camelLetterToPipeLetter);
  }
});

// node_modules/@motionone/dom/dist/index.es.js
var index_es_exports = {};
__export(index_es_exports, {
  ScrollOffset: () => ScrollOffset,
  animate: () => animate,
  animateStyle: () => animateStyle,
  createMotionState: () => createMotionState,
  createStyleString: () => createStyleString,
  createStyles: () => createStyles,
  getAnimationData: () => getAnimationData,
  getStyleName: () => getStyleName,
  glide: () => glide2,
  inView: () => inView,
  mountedStates: () => mountedStates,
  resize: () => resize,
  scroll: () => scroll,
  spring: () => spring2,
  stagger: () => stagger,
  style: () => style,
  timeline: () => timeline,
  withControls: () => withControls
});
var init_index_es16 = __esm({
  "node_modules/@motionone/dom/dist/index.es.js"() {
    init_index_es5();
    init_animate_style_es();
    init_index_es6();
    init_stagger_es();
    init_index_es10();
    init_index_es11();
    init_style_es();
    init_in_view_es();
    init_index_es12();
    init_index_es14();
    init_presets_es();
    init_controls_es();
    init_data_es();
    init_get_style_name_es();
    init_index_es15();
    init_style_object_es();
    init_style_string_es();
  }
});

// node_modules/@emotion/memoize/dist/memoize.browser.esm.js
function memoize(fn) {
  var cache = {};
  return function(arg) {
    if (cache[arg] === void 0)
      cache[arg] = fn(arg);
    return cache[arg];
  };
}
var memoize_browser_esm_default;
var init_memoize_browser_esm = __esm({
  "node_modules/@emotion/memoize/dist/memoize.browser.esm.js"() {
    memoize_browser_esm_default = memoize;
  }
});

// node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js
var is_prop_valid_browser_esm_exports = {};
__export(is_prop_valid_browser_esm_exports, {
  default: () => is_prop_valid_browser_esm_default
});
var reactPropsRegex, index, is_prop_valid_browser_esm_default;
var init_is_prop_valid_browser_esm = __esm({
  "node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js"() {
    init_memoize_browser_esm();
    reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|inert|itemProp|itemScope|itemType|itemID|itemRef|on|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/;
    index = memoize_browser_esm_default(
      function(prop) {
        return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111 && prop.charCodeAt(1) === 110 && prop.charCodeAt(2) < 91;
      }
      /* Z+1 */
    );
    is_prop_valid_browser_esm_default = index;
  }
});

// node_modules/framer-motion/dist/cjs/index.js
var require_cjs2 = __commonJS({
  "node_modules/framer-motion/dist/cjs/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var tslib = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var React3 = require_react();
    var heyListen = (init_hey_listen_es(), __toCommonJS(hey_listen_es_exports));
    var styleValueTypes = require_valueTypes_cjs();
    var popmotion = require_popmotion_cjs();
    var sync = require_framesync_cjs();
    var dom = (init_index_es16(), __toCommonJS(index_es_exports));
    function _interopDefaultLegacy(e) {
      return e && typeof e === "object" && "default" in e ? e : { "default": e };
    }
    function _interopNamespace(e) {
      if (e && e.__esModule)
        return e;
      var n = /* @__PURE__ */ Object.create(null);
      if (e) {
        Object.keys(e).forEach(function(k) {
          if (k !== "default") {
            var d = Object.getOwnPropertyDescriptor(e, k);
            Object.defineProperty(n, k, d.get ? d : {
              enumerable: true,
              get: function() {
                return e[k];
              }
            });
          }
        });
      }
      n["default"] = e;
      return Object.freeze(n);
    }
    var React__namespace = _interopNamespace(React3);
    var React__default = _interopDefaultLegacy(React3);
    var sync__default = _interopDefaultLegacy(sync);
    var defaultEnvironment = "production";
    var env = typeof process === "undefined" || process.env === void 0 ? defaultEnvironment : "development";
    var createDefinition = function(propNames) {
      return {
        isEnabled: function(props) {
          return propNames.some(function(name) {
            return !!props[name];
          });
        }
      };
    };
    var featureDefinitions = {
      measureLayout: createDefinition(["layout", "layoutId", "drag"]),
      animation: createDefinition([
        "animate",
        "exit",
        "variants",
        "whileHover",
        "whileTap",
        "whileFocus",
        "whileDrag",
        "whileInView"
      ]),
      exit: createDefinition(["exit"]),
      drag: createDefinition(["drag", "dragControls"]),
      focus: createDefinition(["whileFocus"]),
      hover: createDefinition(["whileHover", "onHoverStart", "onHoverEnd"]),
      tap: createDefinition(["whileTap", "onTap", "onTapStart", "onTapCancel"]),
      pan: createDefinition([
        "onPan",
        "onPanStart",
        "onPanSessionStart",
        "onPanEnd"
      ]),
      inView: createDefinition([
        "whileInView",
        "onViewportEnter",
        "onViewportLeave"
      ])
    };
    function loadFeatures(features) {
      for (var key in features) {
        if (features[key] === null)
          continue;
        if (key === "projectionNodeConstructor") {
          featureDefinitions.projectionNodeConstructor = features[key];
        } else {
          featureDefinitions[key].Component = features[key];
        }
      }
    }
    var LazyContext = React3.createContext({ strict: false });
    var featureNames = Object.keys(featureDefinitions);
    var numFeatures = featureNames.length;
    function useFeatures(props, visualElement2, preloadedFeatures) {
      var features = [];
      var lazyContext = React3.useContext(LazyContext);
      if (!visualElement2)
        return null;
      if (env !== "production" && preloadedFeatures && lazyContext.strict) {
        heyListen.invariant(false, "You have rendered a `motion` component within a `LazyMotion` component. This will break tree shaking. Import and render a `m` component instead.");
      }
      for (var i = 0; i < numFeatures; i++) {
        var name_1 = featureNames[i];
        var _a = featureDefinitions[name_1], isEnabled = _a.isEnabled, Component = _a.Component;
        if (isEnabled(props) && Component) {
          features.push(React__namespace.createElement(Component, tslib.__assign({ key: name_1 }, props, { visualElement: visualElement2 })));
        }
      }
      return features;
    }
    var MotionConfigContext = React3.createContext({
      transformPagePoint: function(p) {
        return p;
      },
      isStatic: false,
      reducedMotion: "never"
    });
    var MotionContext = React3.createContext({});
    function useVisualElementContext() {
      return React3.useContext(MotionContext).visualElement;
    }
    var PresenceContext = React3.createContext(null);
    var isBrowser = typeof document !== "undefined";
    var useIsomorphicLayoutEffect = isBrowser ? React3.useLayoutEffect : React3.useEffect;
    var prefersReducedMotion = { current: null };
    var hasDetected = false;
    function initPrefersReducedMotion() {
      hasDetected = true;
      if (!isBrowser)
        return;
      if (window.matchMedia) {
        var motionMediaQuery_1 = window.matchMedia("(prefers-reduced-motion)");
        var setReducedMotionPreferences = function() {
          return prefersReducedMotion.current = motionMediaQuery_1.matches;
        };
        motionMediaQuery_1.addListener(setReducedMotionPreferences);
        setReducedMotionPreferences();
      } else {
        prefersReducedMotion.current = false;
      }
    }
    function useReducedMotion() {
      !hasDetected && initPrefersReducedMotion();
      var _a = tslib.__read(React3.useState(prefersReducedMotion.current), 1), shouldReduceMotion = _a[0];
      return shouldReduceMotion;
    }
    function useReducedMotionConfig() {
      var reducedMotionPreference = useReducedMotion();
      var reducedMotion = React3.useContext(MotionConfigContext).reducedMotion;
      if (reducedMotion === "never") {
        return false;
      } else if (reducedMotion === "always") {
        return true;
      } else {
        return reducedMotionPreference;
      }
    }
    function useVisualElement(Component, visualState, props, createVisualElement) {
      var lazyContext = React3.useContext(LazyContext);
      var parent = useVisualElementContext();
      var presenceContext = React3.useContext(PresenceContext);
      var shouldReduceMotion = useReducedMotionConfig();
      var visualElementRef = React3.useRef(void 0);
      if (!createVisualElement)
        createVisualElement = lazyContext.renderer;
      if (!visualElementRef.current && createVisualElement) {
        visualElementRef.current = createVisualElement(Component, {
          visualState,
          parent,
          props,
          presenceId: presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.id,
          blockInitialAnimation: (presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.initial) === false,
          shouldReduceMotion
        });
      }
      var visualElement2 = visualElementRef.current;
      useIsomorphicLayoutEffect(function() {
        visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.syncRender();
      });
      React3.useEffect(function() {
        var _a;
        (_a = visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.animationState) === null || _a === void 0 ? void 0 : _a.animateChanges();
      });
      useIsomorphicLayoutEffect(function() {
        return function() {
          return visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.notifyUnmount();
        };
      }, []);
      return visualElement2;
    }
    function isRefObject(ref) {
      return typeof ref === "object" && Object.prototype.hasOwnProperty.call(ref, "current");
    }
    function useMotionRef(visualState, visualElement2, externalRef) {
      return React3.useCallback(
        function(instance) {
          var _a;
          instance && ((_a = visualState.mount) === null || _a === void 0 ? void 0 : _a.call(visualState, instance));
          if (visualElement2) {
            instance ? visualElement2.mount(instance) : visualElement2.unmount();
          }
          if (externalRef) {
            if (typeof externalRef === "function") {
              externalRef(instance);
            } else if (isRefObject(externalRef)) {
              externalRef.current = instance;
            }
          }
        },
        /**
         * Only pass a new ref callback to React if we've received a visual element
         * factory. Otherwise we'll be mounting/remounting every time externalRef
         * or other dependencies change.
         */
        [visualElement2]
      );
    }
    function isVariantLabels(v) {
      return Array.isArray(v);
    }
    function isVariantLabel(v) {
      return typeof v === "string" || isVariantLabels(v);
    }
    function getCurrent(visualElement2) {
      var current = {};
      visualElement2.forEachValue(function(value, key) {
        return current[key] = value.get();
      });
      return current;
    }
    function getVelocity$1(visualElement2) {
      var velocity = {};
      visualElement2.forEachValue(function(value, key) {
        return velocity[key] = value.getVelocity();
      });
      return velocity;
    }
    function resolveVariantFromProps(props, definition, custom, currentValues, currentVelocity) {
      var _a;
      if (currentValues === void 0) {
        currentValues = {};
      }
      if (currentVelocity === void 0) {
        currentVelocity = {};
      }
      if (typeof definition === "function") {
        definition = definition(custom !== null && custom !== void 0 ? custom : props.custom, currentValues, currentVelocity);
      }
      if (typeof definition === "string") {
        definition = (_a = props.variants) === null || _a === void 0 ? void 0 : _a[definition];
      }
      if (typeof definition === "function") {
        definition = definition(custom !== null && custom !== void 0 ? custom : props.custom, currentValues, currentVelocity);
      }
      return definition;
    }
    function resolveVariant2(visualElement2, definition, custom) {
      var props = visualElement2.getProps();
      return resolveVariantFromProps(props, definition, custom !== null && custom !== void 0 ? custom : props.custom, getCurrent(visualElement2), getVelocity$1(visualElement2));
    }
    function checkIfControllingVariants(props) {
      var _a;
      return typeof ((_a = props.animate) === null || _a === void 0 ? void 0 : _a.start) === "function" || isVariantLabel(props.initial) || isVariantLabel(props.animate) || isVariantLabel(props.whileHover) || isVariantLabel(props.whileDrag) || isVariantLabel(props.whileTap) || isVariantLabel(props.whileFocus) || isVariantLabel(props.exit);
    }
    function checkIfVariantNode(props) {
      return Boolean(checkIfControllingVariants(props) || props.variants);
    }
    function getCurrentTreeVariants(props, context) {
      if (checkIfControllingVariants(props)) {
        var initial = props.initial, animate3 = props.animate;
        return {
          initial: initial === false || isVariantLabel(initial) ? initial : void 0,
          animate: isVariantLabel(animate3) ? animate3 : void 0
        };
      }
      return props.inherit !== false ? context : {};
    }
    function useCreateMotionContext(props) {
      var _a = getCurrentTreeVariants(props, React3.useContext(MotionContext)), initial = _a.initial, animate3 = _a.animate;
      return React3.useMemo(function() {
        return { initial, animate: animate3 };
      }, [variantLabelsAsDependency(initial), variantLabelsAsDependency(animate3)]);
    }
    function variantLabelsAsDependency(prop) {
      return Array.isArray(prop) ? prop.join(" ") : prop;
    }
    function useConstant(init) {
      var ref = React3.useRef(null);
      if (ref.current === null) {
        ref.current = init();
      }
      return ref.current;
    }
    var globalProjectionState = {
      /**
       * Global flag as to whether the tree has animated since the last time
       * we resized the window
       */
      hasAnimatedSinceResize: true,
      /**
       * We set this to true once, on the first update. Any nodes added to the tree beyond that
       * update will be given a `data-projection-id` attribute.
       */
      hasEverUpdated: false
    };
    var id$1 = 1;
    function useProjectionId() {
      return useConstant(function() {
        if (globalProjectionState.hasEverUpdated) {
          return id$1++;
        }
      });
    }
    var LayoutGroupContext = React3.createContext({});
    var SwitchLayoutGroupContext = React3.createContext({});
    function useProjection(projectionId, _a, visualElement2, ProjectionNodeConstructor) {
      var _b;
      var layoutId = _a.layoutId, layout = _a.layout, drag2 = _a.drag, dragConstraints = _a.dragConstraints, layoutScroll = _a.layoutScroll;
      var initialPromotionConfig = React3.useContext(SwitchLayoutGroupContext);
      if (!ProjectionNodeConstructor || !visualElement2 || (visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.projection)) {
        return;
      }
      visualElement2.projection = new ProjectionNodeConstructor(projectionId, visualElement2.getLatestValues(), (_b = visualElement2.parent) === null || _b === void 0 ? void 0 : _b.projection);
      visualElement2.projection.setOptions({
        layoutId,
        layout,
        alwaysMeasureLayout: Boolean(drag2) || dragConstraints && isRefObject(dragConstraints),
        visualElement: visualElement2,
        scheduleRender: function() {
          return visualElement2.scheduleRender();
        },
        /**
         * TODO: Update options in an effect. This could be tricky as it'll be too late
         * to update by the time layout animations run.
         * We also need to fix this safeToRemove by linking it up to the one returned by usePresence,
         * ensuring it gets called if there's no potential layout animations.
         *
         */
        animationType: typeof layout === "string" ? layout : "both",
        initialPromotionConfig,
        layoutScroll
      });
    }
    var VisualElementHandler = (
      /** @class */
      function(_super) {
        tslib.__extends(VisualElementHandler2, _super);
        function VisualElementHandler2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        VisualElementHandler2.prototype.getSnapshotBeforeUpdate = function() {
          this.updateProps();
          return null;
        };
        VisualElementHandler2.prototype.componentDidUpdate = function() {
        };
        VisualElementHandler2.prototype.updateProps = function() {
          var _a = this.props, visualElement2 = _a.visualElement, props = _a.props;
          if (visualElement2)
            visualElement2.setProps(props);
        };
        VisualElementHandler2.prototype.render = function() {
          return this.props.children;
        };
        return VisualElementHandler2;
      }(React__default["default"].Component)
    );
    function createMotionComponent(_a) {
      var preloadedFeatures = _a.preloadedFeatures, createVisualElement = _a.createVisualElement, projectionNodeConstructor = _a.projectionNodeConstructor, useRender = _a.useRender, useVisualState2 = _a.useVisualState, Component = _a.Component;
      preloadedFeatures && loadFeatures(preloadedFeatures);
      function MotionComponent(props, externalRef) {
        var layoutId = useLayoutId(props);
        props = tslib.__assign(tslib.__assign({}, props), { layoutId });
        var config = React3.useContext(MotionConfigContext);
        var features = null;
        var context = useCreateMotionContext(props);
        var projectionId = config.isStatic ? void 0 : useProjectionId();
        var visualState = useVisualState2(props, config.isStatic);
        if (!config.isStatic && isBrowser) {
          context.visualElement = useVisualElement(Component, visualState, tslib.__assign(tslib.__assign({}, config), props), createVisualElement);
          useProjection(projectionId, props, context.visualElement, projectionNodeConstructor || featureDefinitions.projectionNodeConstructor);
          features = useFeatures(props, context.visualElement, preloadedFeatures);
        }
        return React__namespace.createElement(
          VisualElementHandler,
          { visualElement: context.visualElement, props: tslib.__assign(tslib.__assign({}, config), props) },
          features,
          React__namespace.createElement(MotionContext.Provider, { value: context }, useRender(Component, props, projectionId, useMotionRef(visualState, context.visualElement, externalRef), visualState, config.isStatic, context.visualElement))
        );
      }
      return React3.forwardRef(MotionComponent);
    }
    function useLayoutId(_a) {
      var _b;
      var layoutId = _a.layoutId;
      var layoutGroupId = (_b = React3.useContext(LayoutGroupContext)) === null || _b === void 0 ? void 0 : _b.id;
      return layoutGroupId && layoutId !== void 0 ? layoutGroupId + "-" + layoutId : layoutId;
    }
    function createMotionProxy(createConfig) {
      function custom(Component, customMotionComponentConfig) {
        if (customMotionComponentConfig === void 0) {
          customMotionComponentConfig = {};
        }
        return createMotionComponent(createConfig(Component, customMotionComponentConfig));
      }
      if (typeof Proxy === "undefined") {
        return custom;
      }
      var componentCache = /* @__PURE__ */ new Map();
      return new Proxy(custom, {
        /**
         * Called when `motion` is referenced with a prop: `motion.div`, `motion.input` etc.
         * The prop name is passed through as `key` and we can use that to generate a `motion`
         * DOM component with that name.
         */
        get: function(_target, key) {
          if (!componentCache.has(key)) {
            componentCache.set(key, custom(key));
          }
          return componentCache.get(key);
        }
      });
    }
    var lowercaseSVGElements = [
      "animate",
      "circle",
      "defs",
      "desc",
      "ellipse",
      "g",
      "image",
      "line",
      "filter",
      "marker",
      "mask",
      "metadata",
      "path",
      "pattern",
      "polygon",
      "polyline",
      "rect",
      "stop",
      "svg",
      "switch",
      "symbol",
      "text",
      "tspan",
      "use",
      "view"
    ];
    function isSVGComponent(Component) {
      if (
        /**
         * If it's not a string, it's a custom React component. Currently we only support
         * HTML custom React components.
         */
        typeof Component !== "string" || /**
         * If it contains a dash, the element is a custom HTML webcomponent.
         */
        Component.includes("-")
      ) {
        return false;
      } else if (
        /**
         * If it's in our list of lowercase SVG tags, it's an SVG component
         */
        lowercaseSVGElements.indexOf(Component) > -1 || /**
         * If it contains a capital letter, it's an SVG component
         */
        /[A-Z]/.test(Component)
      ) {
        return true;
      }
      return false;
    }
    var scaleCorrectors = {};
    function addScaleCorrector(correctors) {
      Object.assign(scaleCorrectors, correctors);
    }
    var transformAxes = ["", "X", "Y", "Z"];
    var order2 = ["translate", "scale", "rotate", "skew"];
    var transformProps = ["transformPerspective", "x", "y", "z"];
    order2.forEach(function(operationKey) {
      return transformAxes.forEach(function(axesKey) {
        return transformProps.push(operationKey + axesKey);
      });
    });
    function sortTransformProps(a, b) {
      return transformProps.indexOf(a) - transformProps.indexOf(b);
    }
    var transformPropSet = new Set(transformProps);
    function isTransformProp(key) {
      return transformPropSet.has(key);
    }
    var transformOriginProps = /* @__PURE__ */ new Set(["originX", "originY", "originZ"]);
    function isTransformOriginProp(key) {
      return transformOriginProps.has(key);
    }
    function isForcedMotionValue(key, _a) {
      var layout = _a.layout, layoutId = _a.layoutId;
      return isTransformProp(key) || isTransformOriginProp(key) || (layout || layoutId !== void 0) && (!!scaleCorrectors[key] || key === "opacity");
    }
    var isMotionValue = function(value) {
      return Boolean(value !== null && typeof value === "object" && value.getVelocity);
    };
    var translateAlias = {
      x: "translateX",
      y: "translateY",
      z: "translateZ",
      transformPerspective: "perspective"
    };
    function buildTransform(_a, _b, transformIsDefault, transformTemplate) {
      var transform2 = _a.transform, transformKeys2 = _a.transformKeys;
      var _c = _b.enableHardwareAcceleration, enableHardwareAcceleration = _c === void 0 ? true : _c, _d = _b.allowTransformNone, allowTransformNone = _d === void 0 ? true : _d;
      var transformString = "";
      transformKeys2.sort(sortTransformProps);
      var transformHasZ = false;
      var numTransformKeys = transformKeys2.length;
      for (var i = 0; i < numTransformKeys; i++) {
        var key = transformKeys2[i];
        transformString += "".concat(translateAlias[key] || key, "(").concat(transform2[key], ") ");
        if (key === "z")
          transformHasZ = true;
      }
      if (!transformHasZ && enableHardwareAcceleration) {
        transformString += "translateZ(0)";
      } else {
        transformString = transformString.trim();
      }
      if (transformTemplate) {
        transformString = transformTemplate(transform2, transformIsDefault ? "" : transformString);
      } else if (allowTransformNone && transformIsDefault) {
        transformString = "none";
      }
      return transformString;
    }
    function buildTransformOrigin(_a) {
      var _b = _a.originX, originX = _b === void 0 ? "50%" : _b, _c = _a.originY, originY = _c === void 0 ? "50%" : _c, _d = _a.originZ, originZ = _d === void 0 ? 0 : _d;
      return "".concat(originX, " ").concat(originY, " ").concat(originZ);
    }
    function isCSSVariable$1(key) {
      return key.startsWith("--");
    }
    var getValueAsType = function(value, type) {
      return type && typeof value === "number" ? type.transform(value) : value;
    };
    var int = tslib.__assign(tslib.__assign({}, styleValueTypes.number), { transform: Math.round });
    var numberValueTypes = {
      // Border props
      borderWidth: styleValueTypes.px,
      borderTopWidth: styleValueTypes.px,
      borderRightWidth: styleValueTypes.px,
      borderBottomWidth: styleValueTypes.px,
      borderLeftWidth: styleValueTypes.px,
      borderRadius: styleValueTypes.px,
      radius: styleValueTypes.px,
      borderTopLeftRadius: styleValueTypes.px,
      borderTopRightRadius: styleValueTypes.px,
      borderBottomRightRadius: styleValueTypes.px,
      borderBottomLeftRadius: styleValueTypes.px,
      // Positioning props
      width: styleValueTypes.px,
      maxWidth: styleValueTypes.px,
      height: styleValueTypes.px,
      maxHeight: styleValueTypes.px,
      size: styleValueTypes.px,
      top: styleValueTypes.px,
      right: styleValueTypes.px,
      bottom: styleValueTypes.px,
      left: styleValueTypes.px,
      // Spacing props
      padding: styleValueTypes.px,
      paddingTop: styleValueTypes.px,
      paddingRight: styleValueTypes.px,
      paddingBottom: styleValueTypes.px,
      paddingLeft: styleValueTypes.px,
      margin: styleValueTypes.px,
      marginTop: styleValueTypes.px,
      marginRight: styleValueTypes.px,
      marginBottom: styleValueTypes.px,
      marginLeft: styleValueTypes.px,
      // Transform props
      rotate: styleValueTypes.degrees,
      rotateX: styleValueTypes.degrees,
      rotateY: styleValueTypes.degrees,
      rotateZ: styleValueTypes.degrees,
      scale: styleValueTypes.scale,
      scaleX: styleValueTypes.scale,
      scaleY: styleValueTypes.scale,
      scaleZ: styleValueTypes.scale,
      skew: styleValueTypes.degrees,
      skewX: styleValueTypes.degrees,
      skewY: styleValueTypes.degrees,
      distance: styleValueTypes.px,
      translateX: styleValueTypes.px,
      translateY: styleValueTypes.px,
      translateZ: styleValueTypes.px,
      x: styleValueTypes.px,
      y: styleValueTypes.px,
      z: styleValueTypes.px,
      perspective: styleValueTypes.px,
      transformPerspective: styleValueTypes.px,
      opacity: styleValueTypes.alpha,
      originX: styleValueTypes.progressPercentage,
      originY: styleValueTypes.progressPercentage,
      originZ: styleValueTypes.px,
      // Misc
      zIndex: int,
      // SVG
      fillOpacity: styleValueTypes.alpha,
      strokeOpacity: styleValueTypes.alpha,
      numOctaves: int
    };
    function buildHTMLStyles(state, latestValues, options, transformTemplate) {
      var _a;
      var style2 = state.style, vars = state.vars, transform2 = state.transform, transformKeys2 = state.transformKeys, transformOrigin = state.transformOrigin;
      transformKeys2.length = 0;
      var hasTransform2 = false;
      var hasTransformOrigin = false;
      var transformIsNone = true;
      for (var key in latestValues) {
        var value = latestValues[key];
        if (isCSSVariable$1(key)) {
          vars[key] = value;
          continue;
        }
        var valueType = numberValueTypes[key];
        var valueAsType = getValueAsType(value, valueType);
        if (isTransformProp(key)) {
          hasTransform2 = true;
          transform2[key] = valueAsType;
          transformKeys2.push(key);
          if (!transformIsNone)
            continue;
          if (value !== ((_a = valueType.default) !== null && _a !== void 0 ? _a : 0))
            transformIsNone = false;
        } else if (isTransformOriginProp(key)) {
          transformOrigin[key] = valueAsType;
          hasTransformOrigin = true;
        } else {
          style2[key] = valueAsType;
        }
      }
      if (hasTransform2) {
        style2.transform = buildTransform(state, options, transformIsNone, transformTemplate);
      } else if (transformTemplate) {
        style2.transform = transformTemplate({}, "");
      } else if (!latestValues.transform && style2.transform) {
        style2.transform = "none";
      }
      if (hasTransformOrigin) {
        style2.transformOrigin = buildTransformOrigin(transformOrigin);
      }
    }
    var createHtmlRenderState = function() {
      return {
        style: {},
        transform: {},
        transformKeys: [],
        transformOrigin: {},
        vars: {}
      };
    };
    function copyRawValuesOnly(target, source, props) {
      for (var key in source) {
        if (!isMotionValue(source[key]) && !isForcedMotionValue(key, props)) {
          target[key] = source[key];
        }
      }
    }
    function useInitialMotionValues(_a, visualState, isStatic) {
      var transformTemplate = _a.transformTemplate;
      return React3.useMemo(function() {
        var state = createHtmlRenderState();
        buildHTMLStyles(state, visualState, { enableHardwareAcceleration: !isStatic }, transformTemplate);
        var vars = state.vars, style2 = state.style;
        return tslib.__assign(tslib.__assign({}, vars), style2);
      }, [visualState]);
    }
    function useStyle(props, visualState, isStatic) {
      var styleProp = props.style || {};
      var style2 = {};
      copyRawValuesOnly(style2, styleProp, props);
      Object.assign(style2, useInitialMotionValues(props, visualState, isStatic));
      if (props.transformValues) {
        style2 = props.transformValues(style2);
      }
      return style2;
    }
    function useHTMLProps(props, visualState, isStatic) {
      var htmlProps = {};
      var style2 = useStyle(props, visualState, isStatic);
      if (Boolean(props.drag) && props.dragListener !== false) {
        htmlProps.draggable = false;
        style2.userSelect = style2.WebkitUserSelect = style2.WebkitTouchCallout = "none";
        style2.touchAction = props.drag === true ? "none" : "pan-".concat(props.drag === "x" ? "y" : "x");
      }
      htmlProps.style = style2;
      return htmlProps;
    }
    var validMotionProps = /* @__PURE__ */ new Set([
      "initial",
      "animate",
      "exit",
      "style",
      "variants",
      "transition",
      "transformTemplate",
      "transformValues",
      "custom",
      "inherit",
      "layout",
      "layoutId",
      "layoutDependency",
      "onLayoutAnimationStart",
      "onLayoutAnimationComplete",
      "onLayoutMeasure",
      "onBeforeLayoutMeasure",
      "onAnimationStart",
      "onAnimationComplete",
      "onUpdate",
      "onDragStart",
      "onDrag",
      "onDragEnd",
      "onMeasureDragConstraints",
      "onDirectionLock",
      "onDragTransitionEnd",
      "drag",
      "dragControls",
      "dragListener",
      "dragConstraints",
      "dragDirectionLock",
      "dragSnapToOrigin",
      "_dragX",
      "_dragY",
      "dragElastic",
      "dragMomentum",
      "dragPropagation",
      "dragTransition",
      "whileDrag",
      "onPan",
      "onPanStart",
      "onPanEnd",
      "onPanSessionStart",
      "onTap",
      "onTapStart",
      "onTapCancel",
      "onHoverStart",
      "onHoverEnd",
      "whileFocus",
      "whileTap",
      "whileHover",
      "whileInView",
      "onViewportEnter",
      "onViewportLeave",
      "viewport",
      "layoutScroll"
    ]);
    function isValidMotionProp(key) {
      return validMotionProps.has(key);
    }
    var shouldForward = function(key) {
      return !isValidMotionProp(key);
    };
    function loadExternalIsValidProp(isValidProp) {
      if (!isValidProp)
        return;
      shouldForward = function(key) {
        return key.startsWith("on") ? !isValidMotionProp(key) : isValidProp(key);
      };
    }
    try {
      loadExternalIsValidProp((init_is_prop_valid_browser_esm(), __toCommonJS(is_prop_valid_browser_esm_exports)).default);
    } catch (_a) {
    }
    function filterProps(props, isDom, forwardMotionProps) {
      var filteredProps = {};
      for (var key in props) {
        if (shouldForward(key) || forwardMotionProps === true && isValidMotionProp(key) || !isDom && !isValidMotionProp(key) || // If trying to use native HTML drag events, forward drag listeners
        props["draggable"] && key.startsWith("onDrag")) {
          filteredProps[key] = props[key];
        }
      }
      return filteredProps;
    }
    function calcOrigin$1(origin, offset3, size3) {
      return typeof origin === "string" ? origin : styleValueTypes.px.transform(offset3 + size3 * origin);
    }
    function calcSVGTransformOrigin(dimensions, originX, originY) {
      var pxOriginX = calcOrigin$1(originX, dimensions.x, dimensions.width);
      var pxOriginY = calcOrigin$1(originY, dimensions.y, dimensions.height);
      return "".concat(pxOriginX, " ").concat(pxOriginY);
    }
    var dashKeys = {
      offset: "stroke-dashoffset",
      array: "stroke-dasharray"
    };
    var camelKeys = {
      offset: "strokeDashoffset",
      array: "strokeDasharray"
    };
    function buildSVGPath(attrs, length2, spacing, offset3, useDashCase) {
      if (spacing === void 0) {
        spacing = 1;
      }
      if (offset3 === void 0) {
        offset3 = 0;
      }
      if (useDashCase === void 0) {
        useDashCase = true;
      }
      attrs.pathLength = 1;
      var keys2 = useDashCase ? dashKeys : camelKeys;
      attrs[keys2.offset] = styleValueTypes.px.transform(-offset3);
      var pathLength = styleValueTypes.px.transform(length2);
      var pathSpacing = styleValueTypes.px.transform(spacing);
      attrs[keys2.array] = "".concat(pathLength, " ").concat(pathSpacing);
    }
    function buildSVGAttrs(state, _a, options, transformTemplate) {
      var attrX = _a.attrX, attrY = _a.attrY, originX = _a.originX, originY = _a.originY, pathLength = _a.pathLength, _b = _a.pathSpacing, pathSpacing = _b === void 0 ? 1 : _b, _c = _a.pathOffset, pathOffset = _c === void 0 ? 0 : _c, latest = tslib.__rest(_a, ["attrX", "attrY", "originX", "originY", "pathLength", "pathSpacing", "pathOffset"]);
      buildHTMLStyles(state, latest, options, transformTemplate);
      state.attrs = state.style;
      state.style = {};
      var attrs = state.attrs, style2 = state.style, dimensions = state.dimensions;
      if (attrs.transform) {
        if (dimensions)
          style2.transform = attrs.transform;
        delete attrs.transform;
      }
      if (dimensions && (originX !== void 0 || originY !== void 0 || style2.transform)) {
        style2.transformOrigin = calcSVGTransformOrigin(dimensions, originX !== void 0 ? originX : 0.5, originY !== void 0 ? originY : 0.5);
      }
      if (attrX !== void 0)
        attrs.x = attrX;
      if (attrY !== void 0)
        attrs.y = attrY;
      if (pathLength !== void 0) {
        buildSVGPath(attrs, pathLength, pathSpacing, pathOffset, false);
      }
    }
    var createSvgRenderState = function() {
      return tslib.__assign(tslib.__assign({}, createHtmlRenderState()), { attrs: {} });
    };
    function useSVGProps(props, visualState) {
      var visualProps = React3.useMemo(function() {
        var state = createSvgRenderState();
        buildSVGAttrs(state, visualState, { enableHardwareAcceleration: false }, props.transformTemplate);
        return tslib.__assign(tslib.__assign({}, state.attrs), { style: tslib.__assign({}, state.style) });
      }, [visualState]);
      if (props.style) {
        var rawStyles = {};
        copyRawValuesOnly(rawStyles, props.style, props);
        visualProps.style = tslib.__assign(tslib.__assign({}, rawStyles), visualProps.style);
      }
      return visualProps;
    }
    function createUseRender(forwardMotionProps) {
      if (forwardMotionProps === void 0) {
        forwardMotionProps = false;
      }
      var useRender = function(Component, props, projectionId, ref, _a, isStatic) {
        var latestValues = _a.latestValues;
        var useVisualProps = isSVGComponent(Component) ? useSVGProps : useHTMLProps;
        var visualProps = useVisualProps(props, latestValues, isStatic);
        var filteredProps = filterProps(props, typeof Component === "string", forwardMotionProps);
        var elementProps = tslib.__assign(tslib.__assign(tslib.__assign({}, filteredProps), visualProps), { ref });
        if (projectionId) {
          elementProps["data-projection-id"] = projectionId;
        }
        return React3.createElement(Component, elementProps);
      };
      return useRender;
    }
    var CAMEL_CASE_PATTERN = /([a-z])([A-Z])/g;
    var REPLACE_TEMPLATE = "$1-$2";
    var camelToDash = function(str) {
      return str.replace(CAMEL_CASE_PATTERN, REPLACE_TEMPLATE).toLowerCase();
    };
    function renderHTML(element, _a, styleProp, projection) {
      var style2 = _a.style, vars = _a.vars;
      Object.assign(element.style, style2, projection && projection.getProjectionStyles(styleProp));
      for (var key in vars) {
        element.style.setProperty(key, vars[key]);
      }
    }
    var camelCaseAttributes = /* @__PURE__ */ new Set([
      "baseFrequency",
      "diffuseConstant",
      "kernelMatrix",
      "kernelUnitLength",
      "keySplines",
      "keyTimes",
      "limitingConeAngle",
      "markerHeight",
      "markerWidth",
      "numOctaves",
      "targetX",
      "targetY",
      "surfaceScale",
      "specularConstant",
      "specularExponent",
      "stdDeviation",
      "tableValues",
      "viewBox",
      "gradientTransform",
      "pathLength"
    ]);
    function renderSVG(element, renderState, _styleProp, projection) {
      renderHTML(element, renderState, void 0, projection);
      for (var key in renderState.attrs) {
        element.setAttribute(!camelCaseAttributes.has(key) ? camelToDash(key) : key, renderState.attrs[key]);
      }
    }
    function scrapeMotionValuesFromProps$1(props) {
      var style2 = props.style;
      var newValues = {};
      for (var key in style2) {
        if (isMotionValue(style2[key]) || isForcedMotionValue(key, props)) {
          newValues[key] = style2[key];
        }
      }
      return newValues;
    }
    function scrapeMotionValuesFromProps(props) {
      var newValues = scrapeMotionValuesFromProps$1(props);
      for (var key in props) {
        if (isMotionValue(props[key])) {
          var targetKey = key === "x" || key === "y" ? "attr" + key.toUpperCase() : key;
          newValues[targetKey] = props[key];
        }
      }
      return newValues;
    }
    function isAnimationControls(v) {
      return typeof v === "object" && typeof v.start === "function";
    }
    var isKeyframesTarget = function(v) {
      return Array.isArray(v);
    };
    var isCustomValue = function(v) {
      return Boolean(v && typeof v === "object" && v.mix && v.toValue);
    };
    var resolveFinalValueInKeyframes = function(v) {
      return isKeyframesTarget(v) ? v[v.length - 1] || 0 : v;
    };
    function resolveMotionValue(value) {
      var unwrappedValue = isMotionValue(value) ? value.get() : value;
      return isCustomValue(unwrappedValue) ? unwrappedValue.toValue() : unwrappedValue;
    }
    function makeState(_a, props, context, presenceContext) {
      var scrapeMotionValuesFromProps2 = _a.scrapeMotionValuesFromProps, createRenderState = _a.createRenderState, onMount = _a.onMount;
      var state = {
        latestValues: makeLatestValues(props, context, presenceContext, scrapeMotionValuesFromProps2),
        renderState: createRenderState()
      };
      if (onMount) {
        state.mount = function(instance) {
          return onMount(props, instance, state);
        };
      }
      return state;
    }
    var makeUseVisualState = function(config) {
      return function(props, isStatic) {
        var context = React3.useContext(MotionContext);
        var presenceContext = React3.useContext(PresenceContext);
        return isStatic ? makeState(config, props, context, presenceContext) : useConstant(function() {
          return makeState(config, props, context, presenceContext);
        });
      };
    };
    function makeLatestValues(props, context, presenceContext, scrapeMotionValues) {
      var values = {};
      var blockInitialAnimation = (presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.initial) === false;
      var motionValues = scrapeMotionValues(props);
      for (var key in motionValues) {
        values[key] = resolveMotionValue(motionValues[key]);
      }
      var initial = props.initial, animate3 = props.animate;
      var isControllingVariants = checkIfControllingVariants(props);
      var isVariantNode = checkIfVariantNode(props);
      if (context && isVariantNode && !isControllingVariants && props.inherit !== false) {
        initial !== null && initial !== void 0 ? initial : initial = context.initial;
        animate3 !== null && animate3 !== void 0 ? animate3 : animate3 = context.animate;
      }
      var initialAnimationIsBlocked = blockInitialAnimation || initial === false;
      var variantToSet = initialAnimationIsBlocked ? animate3 : initial;
      if (variantToSet && typeof variantToSet !== "boolean" && !isAnimationControls(variantToSet)) {
        var list = Array.isArray(variantToSet) ? variantToSet : [variantToSet];
        list.forEach(function(definition) {
          var resolved = resolveVariantFromProps(props, definition);
          if (!resolved)
            return;
          var transitionEnd = resolved.transitionEnd;
          resolved.transition;
          var target = tslib.__rest(resolved, ["transitionEnd", "transition"]);
          for (var key2 in target) {
            var valueTarget = target[key2];
            if (Array.isArray(valueTarget)) {
              var index4 = initialAnimationIsBlocked ? valueTarget.length - 1 : 0;
              valueTarget = valueTarget[index4];
            }
            if (valueTarget !== null) {
              values[key2] = valueTarget;
            }
          }
          for (var key2 in transitionEnd)
            values[key2] = transitionEnd[key2];
        });
      }
      return values;
    }
    var svgMotionConfig = {
      useVisualState: makeUseVisualState({
        scrapeMotionValuesFromProps,
        createRenderState: createSvgRenderState,
        onMount: function(props, instance, _a) {
          var renderState = _a.renderState, latestValues = _a.latestValues;
          try {
            renderState.dimensions = typeof instance.getBBox === "function" ? instance.getBBox() : instance.getBoundingClientRect();
          } catch (e) {
            renderState.dimensions = {
              x: 0,
              y: 0,
              width: 0,
              height: 0
            };
          }
          buildSVGAttrs(renderState, latestValues, { enableHardwareAcceleration: false }, props.transformTemplate);
          renderSVG(instance, renderState);
        }
      })
    };
    var htmlMotionConfig = {
      useVisualState: makeUseVisualState({
        scrapeMotionValuesFromProps: scrapeMotionValuesFromProps$1,
        createRenderState: createHtmlRenderState
      })
    };
    function createDomMotionConfig(Component, _a, preloadedFeatures, createVisualElement, projectionNodeConstructor) {
      var _b = _a.forwardMotionProps, forwardMotionProps = _b === void 0 ? false : _b;
      var baseConfig = isSVGComponent(Component) ? svgMotionConfig : htmlMotionConfig;
      return tslib.__assign(tslib.__assign({}, baseConfig), { preloadedFeatures, useRender: createUseRender(forwardMotionProps), createVisualElement, projectionNodeConstructor, Component });
    }
    exports.AnimationType = void 0;
    (function(AnimationType) {
      AnimationType["Animate"] = "animate";
      AnimationType["Hover"] = "whileHover";
      AnimationType["Tap"] = "whileTap";
      AnimationType["Drag"] = "whileDrag";
      AnimationType["Focus"] = "whileFocus";
      AnimationType["InView"] = "whileInView";
      AnimationType["Exit"] = "exit";
    })(exports.AnimationType || (exports.AnimationType = {}));
    function addDomEvent(target, eventName, handler, options) {
      if (options === void 0) {
        options = { passive: true };
      }
      target.addEventListener(eventName, handler, options);
      return function() {
        return target.removeEventListener(eventName, handler);
      };
    }
    function useDomEvent(ref, eventName, handler, options) {
      React3.useEffect(function() {
        var element = ref.current;
        if (handler && element) {
          return addDomEvent(element, eventName, handler, options);
        }
      }, [ref, eventName, handler, options]);
    }
    function useFocusGesture(_a) {
      var whileFocus = _a.whileFocus, visualElement2 = _a.visualElement;
      var onFocus = function() {
        var _a2;
        (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Focus, true);
      };
      var onBlur = function() {
        var _a2;
        (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Focus, false);
      };
      useDomEvent(visualElement2, "focus", whileFocus ? onFocus : void 0);
      useDomEvent(visualElement2, "blur", whileFocus ? onBlur : void 0);
    }
    function isMouseEvent(event) {
      if (typeof PointerEvent !== "undefined" && event instanceof PointerEvent) {
        return !!(event.pointerType === "mouse");
      }
      return event instanceof MouseEvent;
    }
    function isTouchEvent(event) {
      var hasTouches = !!event.touches;
      return hasTouches;
    }
    function filterPrimaryPointer(eventHandler) {
      return function(event) {
        var isMouseEvent2 = event instanceof MouseEvent;
        var isPrimaryPointer = !isMouseEvent2 || isMouseEvent2 && event.button === 0;
        if (isPrimaryPointer) {
          eventHandler(event);
        }
      };
    }
    var defaultPagePoint = { pageX: 0, pageY: 0 };
    function pointFromTouch(e, pointType) {
      if (pointType === void 0) {
        pointType = "page";
      }
      var primaryTouch = e.touches[0] || e.changedTouches[0];
      var point2 = primaryTouch || defaultPagePoint;
      return {
        x: point2[pointType + "X"],
        y: point2[pointType + "Y"]
      };
    }
    function pointFromMouse(point2, pointType) {
      if (pointType === void 0) {
        pointType = "page";
      }
      return {
        x: point2[pointType + "X"],
        y: point2[pointType + "Y"]
      };
    }
    function extractEventInfo(event, pointType) {
      if (pointType === void 0) {
        pointType = "page";
      }
      return {
        point: isTouchEvent(event) ? pointFromTouch(event, pointType) : pointFromMouse(event, pointType)
      };
    }
    var wrapHandler = function(handler, shouldFilterPrimaryPointer) {
      if (shouldFilterPrimaryPointer === void 0) {
        shouldFilterPrimaryPointer = false;
      }
      var listener = function(event) {
        return handler(event, extractEventInfo(event));
      };
      return shouldFilterPrimaryPointer ? filterPrimaryPointer(listener) : listener;
    };
    var supportsPointerEvents = function() {
      return isBrowser && window.onpointerdown === null;
    };
    var supportsTouchEvents = function() {
      return isBrowser && window.ontouchstart === null;
    };
    var supportsMouseEvents = function() {
      return isBrowser && window.onmousedown === null;
    };
    var mouseEventNames = {
      pointerdown: "mousedown",
      pointermove: "mousemove",
      pointerup: "mouseup",
      pointercancel: "mousecancel",
      pointerover: "mouseover",
      pointerout: "mouseout",
      pointerenter: "mouseenter",
      pointerleave: "mouseleave"
    };
    var touchEventNames = {
      pointerdown: "touchstart",
      pointermove: "touchmove",
      pointerup: "touchend",
      pointercancel: "touchcancel"
    };
    function getPointerEventName(name) {
      if (supportsPointerEvents()) {
        return name;
      } else if (supportsTouchEvents()) {
        return touchEventNames[name];
      } else if (supportsMouseEvents()) {
        return mouseEventNames[name];
      }
      return name;
    }
    function addPointerEvent(target, eventName, handler, options) {
      return addDomEvent(target, getPointerEventName(eventName), wrapHandler(handler, eventName === "pointerdown"), options);
    }
    function usePointerEvent(ref, eventName, handler, options) {
      return useDomEvent(ref, getPointerEventName(eventName), handler && wrapHandler(handler, eventName === "pointerdown"), options);
    }
    function createLock(name) {
      var lock = null;
      return function() {
        var openLock = function() {
          lock = null;
        };
        if (lock === null) {
          lock = name;
          return openLock;
        }
        return false;
      };
    }
    var globalHorizontalLock = createLock("dragHorizontal");
    var globalVerticalLock = createLock("dragVertical");
    function getGlobalLock(drag2) {
      var lock = false;
      if (drag2 === "y") {
        lock = globalVerticalLock();
      } else if (drag2 === "x") {
        lock = globalHorizontalLock();
      } else {
        var openHorizontal_1 = globalHorizontalLock();
        var openVertical_1 = globalVerticalLock();
        if (openHorizontal_1 && openVertical_1) {
          lock = function() {
            openHorizontal_1();
            openVertical_1();
          };
        } else {
          if (openHorizontal_1)
            openHorizontal_1();
          if (openVertical_1)
            openVertical_1();
        }
      }
      return lock;
    }
    function isDragActive() {
      var openGestureLock = getGlobalLock(true);
      if (!openGestureLock)
        return true;
      openGestureLock();
      return false;
    }
    function createHoverEvent(visualElement2, isActive, callback) {
      return function(event, info) {
        var _a;
        if (!isMouseEvent(event) || isDragActive())
          return;
        (_a = visualElement2.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Hover, isActive);
        callback === null || callback === void 0 ? void 0 : callback(event, info);
      };
    }
    function useHoverGesture(_a) {
      var onHoverStart = _a.onHoverStart, onHoverEnd = _a.onHoverEnd, whileHover = _a.whileHover, visualElement2 = _a.visualElement;
      usePointerEvent(visualElement2, "pointerenter", onHoverStart || whileHover ? createHoverEvent(visualElement2, true, onHoverStart) : void 0, { passive: !onHoverStart });
      usePointerEvent(visualElement2, "pointerleave", onHoverEnd || whileHover ? createHoverEvent(visualElement2, false, onHoverEnd) : void 0, { passive: !onHoverEnd });
    }
    var isNodeOrChild = function(parent, child) {
      if (!child) {
        return false;
      } else if (parent === child) {
        return true;
      } else {
        return isNodeOrChild(parent, child.parentElement);
      }
    };
    function useUnmountEffect(callback) {
      return React3.useEffect(function() {
        return function() {
          return callback();
        };
      }, []);
    }
    function useTapGesture(_a) {
      var onTap = _a.onTap, onTapStart = _a.onTapStart, onTapCancel = _a.onTapCancel, whileTap = _a.whileTap, visualElement2 = _a.visualElement;
      var hasPressListeners = onTap || onTapStart || onTapCancel || whileTap;
      var isPressing = React3.useRef(false);
      var cancelPointerEndListeners = React3.useRef(null);
      var eventOptions = {
        passive: !(onTapStart || onTap || onTapCancel || onPointerDown)
      };
      function removePointerEndListener() {
        var _a2;
        (_a2 = cancelPointerEndListeners.current) === null || _a2 === void 0 ? void 0 : _a2.call(cancelPointerEndListeners);
        cancelPointerEndListeners.current = null;
      }
      function checkPointerEnd() {
        var _a2;
        removePointerEndListener();
        isPressing.current = false;
        (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Tap, false);
        return !isDragActive();
      }
      function onPointerUp(event, info) {
        if (!checkPointerEnd())
          return;
        !isNodeOrChild(visualElement2.getInstance(), event.target) ? onTapCancel === null || onTapCancel === void 0 ? void 0 : onTapCancel(event, info) : onTap === null || onTap === void 0 ? void 0 : onTap(event, info);
      }
      function onPointerCancel(event, info) {
        if (!checkPointerEnd())
          return;
        onTapCancel === null || onTapCancel === void 0 ? void 0 : onTapCancel(event, info);
      }
      function onPointerDown(event, info) {
        var _a2;
        removePointerEndListener();
        if (isPressing.current)
          return;
        isPressing.current = true;
        cancelPointerEndListeners.current = popmotion.pipe(addPointerEvent(window, "pointerup", onPointerUp, eventOptions), addPointerEvent(window, "pointercancel", onPointerCancel, eventOptions));
        (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Tap, true);
        onTapStart === null || onTapStart === void 0 ? void 0 : onTapStart(event, info);
      }
      usePointerEvent(visualElement2, "pointerdown", hasPressListeners ? onPointerDown : void 0, eventOptions);
      useUnmountEffect(removePointerEndListener);
    }
    var warned = /* @__PURE__ */ new Set();
    function warnOnce(condition, message, element) {
      if (condition || warned.has(message))
        return;
      console.warn(message);
      if (element)
        console.warn(element);
      warned.add(message);
    }
    var observerCallbacks = /* @__PURE__ */ new WeakMap();
    var observers = /* @__PURE__ */ new WeakMap();
    var fireObserverCallback = function(entry) {
      var _a;
      (_a = observerCallbacks.get(entry.target)) === null || _a === void 0 ? void 0 : _a(entry);
    };
    var fireAllObserverCallbacks = function(entries) {
      entries.forEach(fireObserverCallback);
    };
    function initIntersectionObserver(_a) {
      var root = _a.root, options = tslib.__rest(_a, ["root"]);
      var lookupRoot = root || document;
      if (!observers.has(lookupRoot)) {
        observers.set(lookupRoot, {});
      }
      var rootObservers = observers.get(lookupRoot);
      var key = JSON.stringify(options);
      if (!rootObservers[key]) {
        rootObservers[key] = new IntersectionObserver(fireAllObserverCallbacks, tslib.__assign({ root }, options));
      }
      return rootObservers[key];
    }
    function observeIntersection(element, options, callback) {
      var rootInteresectionObserver = initIntersectionObserver(options);
      observerCallbacks.set(element, callback);
      rootInteresectionObserver.observe(element);
      return function() {
        observerCallbacks.delete(element);
        rootInteresectionObserver.unobserve(element);
      };
    }
    function useViewport(_a) {
      var visualElement2 = _a.visualElement, whileInView = _a.whileInView, onViewportEnter = _a.onViewportEnter, onViewportLeave = _a.onViewportLeave, _b = _a.viewport, viewport = _b === void 0 ? {} : _b;
      var state = React3.useRef({
        hasEnteredView: false,
        isInView: false
      });
      var shouldObserve = Boolean(whileInView || onViewportEnter || onViewportLeave);
      if (viewport.once && state.current.hasEnteredView)
        shouldObserve = false;
      var useObserver = typeof IntersectionObserver === "undefined" ? useMissingIntersectionObserver : useIntersectionObserver;
      useObserver(shouldObserve, state.current, visualElement2, viewport);
    }
    var thresholdNames = {
      some: 0,
      all: 1
    };
    function useIntersectionObserver(shouldObserve, state, visualElement2, _a) {
      var root = _a.root, rootMargin = _a.margin, _b = _a.amount, amount = _b === void 0 ? "some" : _b, once = _a.once;
      React3.useEffect(function() {
        if (!shouldObserve)
          return;
        var options = {
          root: root === null || root === void 0 ? void 0 : root.current,
          rootMargin,
          threshold: typeof amount === "number" ? amount : thresholdNames[amount]
        };
        var intersectionCallback = function(entry) {
          var _a2;
          var isIntersecting = entry.isIntersecting;
          if (state.isInView === isIntersecting)
            return;
          state.isInView = isIntersecting;
          if (once && !isIntersecting && state.hasEnteredView) {
            return;
          } else if (isIntersecting) {
            state.hasEnteredView = true;
          }
          (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.InView, isIntersecting);
          var props = visualElement2.getProps();
          var callback = isIntersecting ? props.onViewportEnter : props.onViewportLeave;
          callback === null || callback === void 0 ? void 0 : callback(entry);
        };
        return observeIntersection(visualElement2.getInstance(), options, intersectionCallback);
      }, [shouldObserve, root, rootMargin, amount]);
    }
    function useMissingIntersectionObserver(shouldObserve, state, visualElement2, _a) {
      var _b = _a.fallback, fallback = _b === void 0 ? true : _b;
      React3.useEffect(function() {
        if (!shouldObserve || !fallback)
          return;
        if (env !== "production") {
          warnOnce(false, "IntersectionObserver not available on this device. whileInView animations will trigger on mount.");
        }
        requestAnimationFrame(function() {
          var _a2;
          state.hasEnteredView = true;
          var onViewportEnter = visualElement2.getProps().onViewportEnter;
          onViewportEnter === null || onViewportEnter === void 0 ? void 0 : onViewportEnter(null);
          (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.InView, true);
        });
      }, [shouldObserve]);
    }
    var makeRenderlessComponent = function(hook) {
      return function(props) {
        hook(props);
        return null;
      };
    };
    var gestureAnimations = {
      inView: makeRenderlessComponent(useViewport),
      tap: makeRenderlessComponent(useTapGesture),
      focus: makeRenderlessComponent(useFocusGesture),
      hover: makeRenderlessComponent(useHoverGesture)
    };
    var counter = 0;
    var incrementId = function() {
      return counter++;
    };
    var useId2 = function() {
      return useConstant(incrementId);
    };
    function usePresence() {
      var context = React3.useContext(PresenceContext);
      if (context === null)
        return [true, null];
      var isPresent2 = context.isPresent, onExitComplete = context.onExitComplete, register = context.register;
      var id2 = useId2();
      React3.useEffect(function() {
        return register(id2);
      }, []);
      var safeToRemove = function() {
        return onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete(id2);
      };
      return !isPresent2 && onExitComplete ? [false, safeToRemove] : [true];
    }
    function useIsPresent() {
      return isPresent(React3.useContext(PresenceContext));
    }
    function isPresent(context) {
      return context === null ? true : context.isPresent;
    }
    function shallowCompare2(next, prev) {
      if (!Array.isArray(prev))
        return false;
      var prevLength = prev.length;
      if (prevLength !== next.length)
        return false;
      for (var i = 0; i < prevLength; i++) {
        if (prev[i] !== next[i])
          return false;
      }
      return true;
    }
    var secondsToMilliseconds = function(seconds) {
      return seconds * 1e3;
    };
    var easingLookup = {
      linear: popmotion.linear,
      easeIn: popmotion.easeIn,
      easeInOut: popmotion.easeInOut,
      easeOut: popmotion.easeOut,
      circIn: popmotion.circIn,
      circInOut: popmotion.circInOut,
      circOut: popmotion.circOut,
      backIn: popmotion.backIn,
      backInOut: popmotion.backInOut,
      backOut: popmotion.backOut,
      anticipate: popmotion.anticipate,
      bounceIn: popmotion.bounceIn,
      bounceInOut: popmotion.bounceInOut,
      bounceOut: popmotion.bounceOut
    };
    var easingDefinitionToFunction = function(definition) {
      if (Array.isArray(definition)) {
        heyListen.invariant(definition.length === 4, "Cubic bezier arrays must contain four numerical values.");
        var _a = tslib.__read(definition, 4), x1 = _a[0], y1 = _a[1], x2 = _a[2], y2 = _a[3];
        return popmotion.cubicBezier(x1, y1, x2, y2);
      } else if (typeof definition === "string") {
        heyListen.invariant(easingLookup[definition] !== void 0, "Invalid easing type '".concat(definition, "'"));
        return easingLookup[definition];
      }
      return definition;
    };
    var isEasingArray = function(ease) {
      return Array.isArray(ease) && typeof ease[0] !== "number";
    };
    var isAnimatable = function(key, value) {
      if (key === "zIndex")
        return false;
      if (typeof value === "number" || Array.isArray(value))
        return true;
      if (typeof value === "string" && // It's animatable if we have a string
      styleValueTypes.complex.test(value) && // And it contains numbers and/or colors
      !value.startsWith("url(")) {
        return true;
      }
      return false;
    };
    var underDampedSpring = function() {
      return {
        type: "spring",
        stiffness: 500,
        damping: 25,
        restSpeed: 10
      };
    };
    var criticallyDampedSpring = function(to) {
      return {
        type: "spring",
        stiffness: 550,
        damping: to === 0 ? 2 * Math.sqrt(550) : 30,
        restSpeed: 10
      };
    };
    var linearTween = function() {
      return {
        type: "keyframes",
        ease: "linear",
        duration: 0.3
      };
    };
    var keyframes = function(values) {
      return {
        type: "keyframes",
        duration: 0.8,
        values
      };
    };
    var defaultTransitions = {
      x: underDampedSpring,
      y: underDampedSpring,
      z: underDampedSpring,
      rotate: underDampedSpring,
      rotateX: underDampedSpring,
      rotateY: underDampedSpring,
      rotateZ: underDampedSpring,
      scaleX: criticallyDampedSpring,
      scaleY: criticallyDampedSpring,
      scale: criticallyDampedSpring,
      opacity: linearTween,
      backgroundColor: linearTween,
      color: linearTween,
      default: criticallyDampedSpring
    };
    var getDefaultTransition = function(valueKey, to) {
      var transitionFactory;
      if (isKeyframesTarget(to)) {
        transitionFactory = keyframes;
      } else {
        transitionFactory = defaultTransitions[valueKey] || defaultTransitions.default;
      }
      return tslib.__assign({ to }, transitionFactory(to));
    };
    var defaultValueTypes = tslib.__assign(tslib.__assign({}, numberValueTypes), {
      // Color props
      color: styleValueTypes.color,
      backgroundColor: styleValueTypes.color,
      outlineColor: styleValueTypes.color,
      fill: styleValueTypes.color,
      stroke: styleValueTypes.color,
      // Border props
      borderColor: styleValueTypes.color,
      borderTopColor: styleValueTypes.color,
      borderRightColor: styleValueTypes.color,
      borderBottomColor: styleValueTypes.color,
      borderLeftColor: styleValueTypes.color,
      filter: styleValueTypes.filter,
      WebkitFilter: styleValueTypes.filter
    });
    var getDefaultValueType = function(key) {
      return defaultValueTypes[key];
    };
    function getAnimatableNone(key, value) {
      var _a;
      var defaultValueType = getDefaultValueType(key);
      if (defaultValueType !== styleValueTypes.filter)
        defaultValueType = styleValueTypes.complex;
      return (_a = defaultValueType.getAnimatableNone) === null || _a === void 0 ? void 0 : _a.call(defaultValueType, value);
    }
    var instantAnimationState = {
      current: false
    };
    function isTransitionDefined(_a) {
      _a.when;
      _a.delay;
      _a.delayChildren;
      _a.staggerChildren;
      _a.staggerDirection;
      _a.repeat;
      _a.repeatType;
      _a.repeatDelay;
      _a.from;
      var transition = tslib.__rest(_a, ["when", "delay", "delayChildren", "staggerChildren", "staggerDirection", "repeat", "repeatType", "repeatDelay", "from"]);
      return !!Object.keys(transition).length;
    }
    var legacyRepeatWarning = false;
    function convertTransitionToAnimationOptions(_a) {
      var ease = _a.ease, times = _a.times, yoyo = _a.yoyo, flip3 = _a.flip, loop = _a.loop, transition = tslib.__rest(_a, ["ease", "times", "yoyo", "flip", "loop"]);
      var options = tslib.__assign({}, transition);
      if (times)
        options["offset"] = times;
      if (transition.duration)
        options["duration"] = secondsToMilliseconds(transition.duration);
      if (transition.repeatDelay)
        options.repeatDelay = secondsToMilliseconds(transition.repeatDelay);
      if (ease) {
        options["ease"] = isEasingArray(ease) ? ease.map(easingDefinitionToFunction) : easingDefinitionToFunction(ease);
      }
      if (transition.type === "tween")
        options.type = "keyframes";
      if (yoyo || loop || flip3) {
        heyListen.warning(!legacyRepeatWarning, "yoyo, loop and flip have been removed from the API. Replace with repeat and repeatType options.");
        legacyRepeatWarning = true;
        if (yoyo) {
          options.repeatType = "reverse";
        } else if (loop) {
          options.repeatType = "loop";
        } else if (flip3) {
          options.repeatType = "mirror";
        }
        options.repeat = loop || yoyo || flip3 || transition.repeat;
      }
      if (transition.type !== "spring")
        options.type = "keyframes";
      return options;
    }
    function getDelayFromTransition(transition, key) {
      var _a, _b;
      var valueTransition = getValueTransition(transition, key) || {};
      return (_b = (_a = valueTransition.delay) !== null && _a !== void 0 ? _a : transition.delay) !== null && _b !== void 0 ? _b : 0;
    }
    function hydrateKeyframes2(options) {
      if (Array.isArray(options.to) && options.to[0] === null) {
        options.to = tslib.__spreadArray([], tslib.__read(options.to), false);
        options.to[0] = options.from;
      }
      return options;
    }
    function getPopmotionAnimationOptions(transition, options, key) {
      var _a;
      if (Array.isArray(options.to)) {
        (_a = transition.duration) !== null && _a !== void 0 ? _a : transition.duration = 0.8;
      }
      hydrateKeyframes2(options);
      if (!isTransitionDefined(transition)) {
        transition = tslib.__assign(tslib.__assign({}, transition), getDefaultTransition(key, options.to));
      }
      return tslib.__assign(tslib.__assign({}, options), convertTransitionToAnimationOptions(transition));
    }
    function getAnimation(key, value, target, transition, onComplete) {
      var _a;
      var valueTransition = getValueTransition(transition, key);
      var origin = (_a = valueTransition.from) !== null && _a !== void 0 ? _a : value.get();
      var isTargetAnimatable = isAnimatable(key, target);
      if (origin === "none" && isTargetAnimatable && typeof target === "string") {
        origin = getAnimatableNone(key, target);
      } else if (isZero(origin) && typeof target === "string") {
        origin = getZeroUnit(target);
      } else if (!Array.isArray(target) && isZero(target) && typeof origin === "string") {
        target = getZeroUnit(origin);
      }
      var isOriginAnimatable = isAnimatable(key, origin);
      heyListen.warning(isOriginAnimatable === isTargetAnimatable, "You are trying to animate ".concat(key, ' from "').concat(origin, '" to "').concat(target, '". ').concat(origin, " is not an animatable value - to enable this animation set ").concat(origin, " to a value animatable to ").concat(target, " via the `style` property."));
      function start() {
        var options = {
          from: origin,
          to: target,
          velocity: value.getVelocity(),
          onComplete,
          onUpdate: function(v) {
            return value.set(v);
          }
        };
        return valueTransition.type === "inertia" || valueTransition.type === "decay" ? popmotion.inertia(tslib.__assign(tslib.__assign({}, options), valueTransition)) : popmotion.animate(tslib.__assign(tslib.__assign({}, getPopmotionAnimationOptions(valueTransition, options, key)), { onUpdate: function(v) {
          var _a2;
          options.onUpdate(v);
          (_a2 = valueTransition.onUpdate) === null || _a2 === void 0 ? void 0 : _a2.call(valueTransition, v);
        }, onComplete: function() {
          var _a2;
          options.onComplete();
          (_a2 = valueTransition.onComplete) === null || _a2 === void 0 ? void 0 : _a2.call(valueTransition);
        } }));
      }
      function set() {
        var _a2, _b;
        var finalTarget = resolveFinalValueInKeyframes(target);
        value.set(finalTarget);
        onComplete();
        (_a2 = valueTransition === null || valueTransition === void 0 ? void 0 : valueTransition.onUpdate) === null || _a2 === void 0 ? void 0 : _a2.call(valueTransition, finalTarget);
        (_b = valueTransition === null || valueTransition === void 0 ? void 0 : valueTransition.onComplete) === null || _b === void 0 ? void 0 : _b.call(valueTransition);
        return { stop: function() {
        } };
      }
      return !isOriginAnimatable || !isTargetAnimatable || valueTransition.type === false ? set : start;
    }
    function isZero(value) {
      return value === 0 || typeof value === "string" && parseFloat(value) === 0 && value.indexOf(" ") === -1;
    }
    function getZeroUnit(potentialUnitType) {
      return typeof potentialUnitType === "number" ? 0 : getAnimatableNone("", potentialUnitType);
    }
    function getValueTransition(transition, key) {
      return transition[key] || transition["default"] || transition;
    }
    function startAnimation(key, value, target, transition) {
      if (transition === void 0) {
        transition = {};
      }
      if (instantAnimationState.current) {
        transition = { type: false };
      }
      return value.start(function(onComplete) {
        var delayTimer;
        var controls2;
        var animation = getAnimation(key, value, target, transition, onComplete);
        var delay = getDelayFromTransition(transition, key);
        var start = function() {
          return controls2 = animation();
        };
        if (delay) {
          delayTimer = window.setTimeout(start, secondsToMilliseconds(delay));
        } else {
          start();
        }
        return function() {
          clearTimeout(delayTimer);
          controls2 === null || controls2 === void 0 ? void 0 : controls2.stop();
        };
      });
    }
    var isNumericalString = function(v) {
      return /^\-?\d*\.?\d+$/.test(v);
    };
    var isZeroValueString = function(v) {
      return /^0[^.\s]+$/.test(v);
    };
    function addUniqueItem2(arr, item) {
      arr.indexOf(item) === -1 && arr.push(item);
    }
    function removeItem2(arr, item) {
      var index4 = arr.indexOf(item);
      index4 > -1 && arr.splice(index4, 1);
    }
    function moveItem(_a, fromIndex, toIndex) {
      var _b = tslib.__read(_a), arr = _b.slice(0);
      var startIndex = fromIndex < 0 ? arr.length + fromIndex : fromIndex;
      if (startIndex >= 0 && startIndex < arr.length) {
        var endIndex = toIndex < 0 ? arr.length + toIndex : toIndex;
        var _c = tslib.__read(arr.splice(fromIndex, 1), 1), item = _c[0];
        arr.splice(endIndex, 0, item);
      }
      return arr;
    }
    var SubscriptionManager = (
      /** @class */
      function() {
        function SubscriptionManager2() {
          this.subscriptions = [];
        }
        SubscriptionManager2.prototype.add = function(handler) {
          var _this = this;
          addUniqueItem2(this.subscriptions, handler);
          return function() {
            return removeItem2(_this.subscriptions, handler);
          };
        };
        SubscriptionManager2.prototype.notify = function(a, b, c) {
          var numSubscriptions = this.subscriptions.length;
          if (!numSubscriptions)
            return;
          if (numSubscriptions === 1) {
            this.subscriptions[0](a, b, c);
          } else {
            for (var i = 0; i < numSubscriptions; i++) {
              var handler = this.subscriptions[i];
              handler && handler(a, b, c);
            }
          }
        };
        SubscriptionManager2.prototype.getSize = function() {
          return this.subscriptions.length;
        };
        SubscriptionManager2.prototype.clear = function() {
          this.subscriptions.length = 0;
        };
        return SubscriptionManager2;
      }()
    );
    var isFloat = function(value) {
      return !isNaN(parseFloat(value));
    };
    var MotionValue2 = (
      /** @class */
      function() {
        function MotionValue3(init) {
          var _this = this;
          this.version = "6.5.1";
          this.timeDelta = 0;
          this.lastUpdated = 0;
          this.updateSubscribers = new SubscriptionManager();
          this.velocityUpdateSubscribers = new SubscriptionManager();
          this.renderSubscribers = new SubscriptionManager();
          this.canTrackVelocity = false;
          this.updateAndNotify = function(v, render) {
            if (render === void 0) {
              render = true;
            }
            _this.prev = _this.current;
            _this.current = v;
            var _a = sync.getFrameData(), delta = _a.delta, timestamp = _a.timestamp;
            if (_this.lastUpdated !== timestamp) {
              _this.timeDelta = delta;
              _this.lastUpdated = timestamp;
              sync__default["default"].postRender(_this.scheduleVelocityCheck);
            }
            if (_this.prev !== _this.current) {
              _this.updateSubscribers.notify(_this.current);
            }
            if (_this.velocityUpdateSubscribers.getSize()) {
              _this.velocityUpdateSubscribers.notify(_this.getVelocity());
            }
            if (render) {
              _this.renderSubscribers.notify(_this.current);
            }
          };
          this.scheduleVelocityCheck = function() {
            return sync__default["default"].postRender(_this.velocityCheck);
          };
          this.velocityCheck = function(_a) {
            var timestamp = _a.timestamp;
            if (timestamp !== _this.lastUpdated) {
              _this.prev = _this.current;
              _this.velocityUpdateSubscribers.notify(_this.getVelocity());
            }
          };
          this.hasAnimated = false;
          this.prev = this.current = init;
          this.canTrackVelocity = isFloat(this.current);
        }
        MotionValue3.prototype.onChange = function(subscription) {
          return this.updateSubscribers.add(subscription);
        };
        MotionValue3.prototype.clearListeners = function() {
          this.updateSubscribers.clear();
        };
        MotionValue3.prototype.onRenderRequest = function(subscription) {
          subscription(this.get());
          return this.renderSubscribers.add(subscription);
        };
        MotionValue3.prototype.attach = function(passiveEffect) {
          this.passiveEffect = passiveEffect;
        };
        MotionValue3.prototype.set = function(v, render) {
          if (render === void 0) {
            render = true;
          }
          if (!render || !this.passiveEffect) {
            this.updateAndNotify(v, render);
          } else {
            this.passiveEffect(v, this.updateAndNotify);
          }
        };
        MotionValue3.prototype.get = function() {
          return this.current;
        };
        MotionValue3.prototype.getPrevious = function() {
          return this.prev;
        };
        MotionValue3.prototype.getVelocity = function() {
          return this.canTrackVelocity ? (
            // These casts could be avoided if parseFloat would be typed better
            popmotion.velocityPerSecond(parseFloat(this.current) - parseFloat(this.prev), this.timeDelta)
          ) : 0;
        };
        MotionValue3.prototype.start = function(animation) {
          var _this = this;
          this.stop();
          return new Promise(function(resolve) {
            _this.hasAnimated = true;
            _this.stopAnimation = animation(resolve);
          }).then(function() {
            return _this.clearAnimation();
          });
        };
        MotionValue3.prototype.stop = function() {
          if (this.stopAnimation)
            this.stopAnimation();
          this.clearAnimation();
        };
        MotionValue3.prototype.isAnimating = function() {
          return !!this.stopAnimation;
        };
        MotionValue3.prototype.clearAnimation = function() {
          this.stopAnimation = null;
        };
        MotionValue3.prototype.destroy = function() {
          this.updateSubscribers.clear();
          this.renderSubscribers.clear();
          this.stop();
        };
        return MotionValue3;
      }()
    );
    function motionValue(init) {
      return new MotionValue2(init);
    }
    var testValueType = function(v) {
      return function(type) {
        return type.test(v);
      };
    };
    var auto = {
      test: function(v) {
        return v === "auto";
      },
      parse: function(v) {
        return v;
      }
    };
    var dimensionValueTypes = [styleValueTypes.number, styleValueTypes.px, styleValueTypes.percent, styleValueTypes.degrees, styleValueTypes.vw, styleValueTypes.vh, auto];
    var findDimensionValueType = function(v) {
      return dimensionValueTypes.find(testValueType(v));
    };
    var valueTypes = tslib.__spreadArray(tslib.__spreadArray([], tslib.__read(dimensionValueTypes), false), [styleValueTypes.color, styleValueTypes.complex], false);
    var findValueType = function(v) {
      return valueTypes.find(testValueType(v));
    };
    function setMotionValue(visualElement2, key, value) {
      if (visualElement2.hasValue(key)) {
        visualElement2.getValue(key).set(value);
      } else {
        visualElement2.addValue(key, motionValue(value));
      }
    }
    function setTarget(visualElement2, definition) {
      var resolved = resolveVariant2(visualElement2, definition);
      var _a = resolved ? visualElement2.makeTargetAnimatable(resolved, false) : {}, _b = _a.transitionEnd, transitionEnd = _b === void 0 ? {} : _b;
      _a.transition;
      var target = tslib.__rest(_a, ["transitionEnd", "transition"]);
      target = tslib.__assign(tslib.__assign({}, target), transitionEnd);
      for (var key in target) {
        var value = resolveFinalValueInKeyframes(target[key]);
        setMotionValue(visualElement2, key, value);
      }
    }
    function setVariants(visualElement2, variantLabels) {
      var reversedLabels = tslib.__spreadArray([], tslib.__read(variantLabels), false).reverse();
      reversedLabels.forEach(function(key) {
        var _a;
        var variant = visualElement2.getVariant(key);
        variant && setTarget(visualElement2, variant);
        (_a = visualElement2.variantChildren) === null || _a === void 0 ? void 0 : _a.forEach(function(child) {
          setVariants(child, variantLabels);
        });
      });
    }
    function setValues(visualElement2, definition) {
      if (Array.isArray(definition)) {
        return setVariants(visualElement2, definition);
      } else if (typeof definition === "string") {
        return setVariants(visualElement2, [definition]);
      } else {
        setTarget(visualElement2, definition);
      }
    }
    function checkTargetForNewValues(visualElement2, target, origin) {
      var _a, _b, _c;
      var _d;
      var newValueKeys = Object.keys(target).filter(function(key2) {
        return !visualElement2.hasValue(key2);
      });
      var numNewValues = newValueKeys.length;
      if (!numNewValues)
        return;
      for (var i = 0; i < numNewValues; i++) {
        var key = newValueKeys[i];
        var targetValue = target[key];
        var value = null;
        if (Array.isArray(targetValue)) {
          value = targetValue[0];
        }
        if (value === null) {
          value = (_b = (_a = origin[key]) !== null && _a !== void 0 ? _a : visualElement2.readValue(key)) !== null && _b !== void 0 ? _b : target[key];
        }
        if (value === void 0 || value === null)
          continue;
        if (typeof value === "string" && (isNumericalString(value) || isZeroValueString(value))) {
          value = parseFloat(value);
        } else if (!findValueType(value) && styleValueTypes.complex.test(targetValue)) {
          value = getAnimatableNone(key, targetValue);
        }
        visualElement2.addValue(key, motionValue(value));
        (_c = (_d = origin)[key]) !== null && _c !== void 0 ? _c : _d[key] = value;
        visualElement2.setBaseTarget(key, value);
      }
    }
    function getOriginFromTransition(key, transition) {
      if (!transition)
        return;
      var valueTransition = transition[key] || transition["default"] || transition;
      return valueTransition.from;
    }
    function getOrigin(target, transition, visualElement2) {
      var _a, _b;
      var origin = {};
      for (var key in target) {
        origin[key] = (_a = getOriginFromTransition(key, transition)) !== null && _a !== void 0 ? _a : (_b = visualElement2.getValue(key)) === null || _b === void 0 ? void 0 : _b.get();
      }
      return origin;
    }
    function animateVisualElement(visualElement2, definition, options) {
      if (options === void 0) {
        options = {};
      }
      visualElement2.notifyAnimationStart(definition);
      var animation;
      if (Array.isArray(definition)) {
        var animations2 = definition.map(function(variant) {
          return animateVariant(visualElement2, variant, options);
        });
        animation = Promise.all(animations2);
      } else if (typeof definition === "string") {
        animation = animateVariant(visualElement2, definition, options);
      } else {
        var resolvedDefinition = typeof definition === "function" ? resolveVariant2(visualElement2, definition, options.custom) : definition;
        animation = animateTarget(visualElement2, resolvedDefinition, options);
      }
      return animation.then(function() {
        return visualElement2.notifyAnimationComplete(definition);
      });
    }
    function animateVariant(visualElement2, variant, options) {
      var _a;
      if (options === void 0) {
        options = {};
      }
      var resolved = resolveVariant2(visualElement2, variant, options.custom);
      var _b = (resolved || {}).transition, transition = _b === void 0 ? visualElement2.getDefaultTransition() || {} : _b;
      if (options.transitionOverride) {
        transition = options.transitionOverride;
      }
      var getAnimation2 = resolved ? function() {
        return animateTarget(visualElement2, resolved, options);
      } : function() {
        return Promise.resolve();
      };
      var getChildAnimations = ((_a = visualElement2.variantChildren) === null || _a === void 0 ? void 0 : _a.size) ? function(forwardDelay) {
        if (forwardDelay === void 0) {
          forwardDelay = 0;
        }
        var _a2 = transition.delayChildren, delayChildren = _a2 === void 0 ? 0 : _a2, staggerChildren = transition.staggerChildren, staggerDirection = transition.staggerDirection;
        return animateChildren(visualElement2, variant, delayChildren + forwardDelay, staggerChildren, staggerDirection, options);
      } : function() {
        return Promise.resolve();
      };
      var when = transition.when;
      if (when) {
        var _c = tslib.__read(when === "beforeChildren" ? [getAnimation2, getChildAnimations] : [getChildAnimations, getAnimation2], 2), first = _c[0], last = _c[1];
        return first().then(last);
      } else {
        return Promise.all([getAnimation2(), getChildAnimations(options.delay)]);
      }
    }
    function animateTarget(visualElement2, definition, _a) {
      var _b;
      var _c = _a === void 0 ? {} : _a, _d = _c.delay, delay = _d === void 0 ? 0 : _d, transitionOverride = _c.transitionOverride, type = _c.type;
      var _e = visualElement2.makeTargetAnimatable(definition), _f = _e.transition, transition = _f === void 0 ? visualElement2.getDefaultTransition() : _f, transitionEnd = _e.transitionEnd, target = tslib.__rest(_e, ["transition", "transitionEnd"]);
      if (transitionOverride)
        transition = transitionOverride;
      var animations2 = [];
      var animationTypeState = type && ((_b = visualElement2.animationState) === null || _b === void 0 ? void 0 : _b.getState()[type]);
      for (var key in target) {
        var value = visualElement2.getValue(key);
        var valueTarget = target[key];
        if (!value || valueTarget === void 0 || animationTypeState && shouldBlockAnimation(animationTypeState, key)) {
          continue;
        }
        var valueTransition = tslib.__assign({ delay }, transition);
        if (visualElement2.shouldReduceMotion && isTransformProp(key)) {
          valueTransition = tslib.__assign(tslib.__assign({}, valueTransition), { type: false, delay: 0 });
        }
        var animation = startAnimation(key, value, valueTarget, valueTransition);
        animations2.push(animation);
      }
      return Promise.all(animations2).then(function() {
        transitionEnd && setTarget(visualElement2, transitionEnd);
      });
    }
    function animateChildren(visualElement2, variant, delayChildren, staggerChildren, staggerDirection, options) {
      if (delayChildren === void 0) {
        delayChildren = 0;
      }
      if (staggerChildren === void 0) {
        staggerChildren = 0;
      }
      if (staggerDirection === void 0) {
        staggerDirection = 1;
      }
      var animations2 = [];
      var maxStaggerDuration = (visualElement2.variantChildren.size - 1) * staggerChildren;
      var generateStaggerDuration = staggerDirection === 1 ? function(i) {
        if (i === void 0) {
          i = 0;
        }
        return i * staggerChildren;
      } : function(i) {
        if (i === void 0) {
          i = 0;
        }
        return maxStaggerDuration - i * staggerChildren;
      };
      Array.from(visualElement2.variantChildren).sort(sortByTreeOrder).forEach(function(child, i) {
        animations2.push(animateVariant(child, variant, tslib.__assign(tslib.__assign({}, options), { delay: delayChildren + generateStaggerDuration(i) })).then(function() {
          return child.notifyAnimationComplete(variant);
        }));
      });
      return Promise.all(animations2);
    }
    function stopAnimation2(visualElement2) {
      visualElement2.forEachValue(function(value) {
        return value.stop();
      });
    }
    function sortByTreeOrder(a, b) {
      return a.sortNodePosition(b);
    }
    function shouldBlockAnimation(_a, key) {
      var protectedKeys = _a.protectedKeys, needsAnimating = _a.needsAnimating;
      var shouldBlock = protectedKeys.hasOwnProperty(key) && needsAnimating[key] !== true;
      needsAnimating[key] = false;
      return shouldBlock;
    }
    var variantPriorityOrder = [
      exports.AnimationType.Animate,
      exports.AnimationType.InView,
      exports.AnimationType.Focus,
      exports.AnimationType.Hover,
      exports.AnimationType.Tap,
      exports.AnimationType.Drag,
      exports.AnimationType.Exit
    ];
    var reversePriorityOrder = tslib.__spreadArray([], tslib.__read(variantPriorityOrder), false).reverse();
    var numAnimationTypes = variantPriorityOrder.length;
    function animateList(visualElement2) {
      return function(animations2) {
        return Promise.all(animations2.map(function(_a) {
          var animation = _a.animation, options = _a.options;
          return animateVisualElement(visualElement2, animation, options);
        }));
      };
    }
    function createAnimationState(visualElement2) {
      var animate3 = animateList(visualElement2);
      var state = createState();
      var allAnimatedKeys = {};
      var isInitialRender = true;
      var buildResolvedTypeValues = function(acc, definition) {
        var resolved = resolveVariant2(visualElement2, definition);
        if (resolved) {
          resolved.transition;
          var transitionEnd = resolved.transitionEnd, target = tslib.__rest(resolved, ["transition", "transitionEnd"]);
          acc = tslib.__assign(tslib.__assign(tslib.__assign({}, acc), target), transitionEnd);
        }
        return acc;
      };
      function isAnimated(key) {
        return allAnimatedKeys[key] !== void 0;
      }
      function setAnimateFunction(makeAnimator) {
        animate3 = makeAnimator(visualElement2);
      }
      function animateChanges(options, changedActiveType) {
        var _a;
        var props = visualElement2.getProps();
        var context = visualElement2.getVariantContext(true) || {};
        var animations2 = [];
        var removedKeys = /* @__PURE__ */ new Set();
        var encounteredKeys = {};
        var removedVariantIndex = Infinity;
        var _loop_1 = function(i2) {
          var type = reversePriorityOrder[i2];
          var typeState = state[type];
          var prop = (_a = props[type]) !== null && _a !== void 0 ? _a : context[type];
          var propIsVariant = isVariantLabel(prop);
          var activeDelta = type === changedActiveType ? typeState.isActive : null;
          if (activeDelta === false)
            removedVariantIndex = i2;
          var isInherited = prop === context[type] && prop !== props[type] && propIsVariant;
          if (isInherited && isInitialRender && visualElement2.manuallyAnimateOnMount) {
            isInherited = false;
          }
          typeState.protectedKeys = tslib.__assign({}, encounteredKeys);
          if (
            // If it isn't active and hasn't *just* been set as inactive
            !typeState.isActive && activeDelta === null || // If we didn't and don't have any defined prop for this animation type
            !prop && !typeState.prevProp || // Or if the prop doesn't define an animation
            isAnimationControls(prop) || typeof prop === "boolean"
          ) {
            return "continue";
          }
          var variantDidChange = checkVariantsDidChange(typeState.prevProp, prop);
          var shouldAnimateType = variantDidChange || // If we're making this variant active, we want to always make it active
          type === changedActiveType && typeState.isActive && !isInherited && propIsVariant || // If we removed a higher-priority variant (i is in reverse order)
          i2 > removedVariantIndex && propIsVariant;
          var definitionList = Array.isArray(prop) ? prop : [prop];
          var resolvedValues = definitionList.reduce(buildResolvedTypeValues, {});
          if (activeDelta === false)
            resolvedValues = {};
          var _b = typeState.prevResolvedValues, prevResolvedValues = _b === void 0 ? {} : _b;
          var allKeys = tslib.__assign(tslib.__assign({}, prevResolvedValues), resolvedValues);
          var markToAnimate = function(key2) {
            shouldAnimateType = true;
            removedKeys.delete(key2);
            typeState.needsAnimating[key2] = true;
          };
          for (var key in allKeys) {
            var next = resolvedValues[key];
            var prev = prevResolvedValues[key];
            if (encounteredKeys.hasOwnProperty(key))
              continue;
            if (next !== prev) {
              if (isKeyframesTarget(next) && isKeyframesTarget(prev)) {
                if (!shallowCompare2(next, prev) || variantDidChange) {
                  markToAnimate(key);
                } else {
                  typeState.protectedKeys[key] = true;
                }
              } else if (next !== void 0) {
                markToAnimate(key);
              } else {
                removedKeys.add(key);
              }
            } else if (next !== void 0 && removedKeys.has(key)) {
              markToAnimate(key);
            } else {
              typeState.protectedKeys[key] = true;
            }
          }
          typeState.prevProp = prop;
          typeState.prevResolvedValues = resolvedValues;
          if (typeState.isActive) {
            encounteredKeys = tslib.__assign(tslib.__assign({}, encounteredKeys), resolvedValues);
          }
          if (isInitialRender && visualElement2.blockInitialAnimation) {
            shouldAnimateType = false;
          }
          if (shouldAnimateType && !isInherited) {
            animations2.push.apply(animations2, tslib.__spreadArray([], tslib.__read(definitionList.map(function(animation) {
              return {
                animation,
                options: tslib.__assign({ type }, options)
              };
            })), false));
          }
        };
        for (var i = 0; i < numAnimationTypes; i++) {
          _loop_1(i);
        }
        allAnimatedKeys = tslib.__assign({}, encounteredKeys);
        if (removedKeys.size) {
          var fallbackAnimation_1 = {};
          removedKeys.forEach(function(key) {
            var fallbackTarget = visualElement2.getBaseTarget(key);
            if (fallbackTarget !== void 0) {
              fallbackAnimation_1[key] = fallbackTarget;
            }
          });
          animations2.push({ animation: fallbackAnimation_1 });
        }
        var shouldAnimate = Boolean(animations2.length);
        if (isInitialRender && props.initial === false && !visualElement2.manuallyAnimateOnMount) {
          shouldAnimate = false;
        }
        isInitialRender = false;
        return shouldAnimate ? animate3(animations2) : Promise.resolve();
      }
      function setActive(type, isActive, options) {
        var _a;
        if (state[type].isActive === isActive)
          return Promise.resolve();
        (_a = visualElement2.variantChildren) === null || _a === void 0 ? void 0 : _a.forEach(function(child) {
          var _a2;
          return (_a2 = child.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(type, isActive);
        });
        state[type].isActive = isActive;
        var animations2 = animateChanges(options, type);
        for (var key in state) {
          state[key].protectedKeys = {};
        }
        return animations2;
      }
      return {
        isAnimated,
        animateChanges,
        setActive,
        setAnimateFunction,
        getState: function() {
          return state;
        }
      };
    }
    function checkVariantsDidChange(prev, next) {
      if (typeof next === "string") {
        return next !== prev;
      } else if (isVariantLabels(next)) {
        return !shallowCompare2(next, prev);
      }
      return false;
    }
    function createTypeState(isActive) {
      if (isActive === void 0) {
        isActive = false;
      }
      return {
        isActive,
        protectedKeys: {},
        needsAnimating: {},
        prevResolvedValues: {}
      };
    }
    function createState() {
      var _a;
      return _a = {}, _a[exports.AnimationType.Animate] = createTypeState(true), _a[exports.AnimationType.InView] = createTypeState(), _a[exports.AnimationType.Hover] = createTypeState(), _a[exports.AnimationType.Tap] = createTypeState(), _a[exports.AnimationType.Drag] = createTypeState(), _a[exports.AnimationType.Focus] = createTypeState(), _a[exports.AnimationType.Exit] = createTypeState(), _a;
    }
    var animations = {
      animation: makeRenderlessComponent(function(_a) {
        var visualElement2 = _a.visualElement, animate3 = _a.animate;
        visualElement2.animationState || (visualElement2.animationState = createAnimationState(visualElement2));
        if (isAnimationControls(animate3)) {
          React3.useEffect(function() {
            return animate3.subscribe(visualElement2);
          }, [animate3]);
        }
      }),
      exit: makeRenderlessComponent(function(props) {
        var custom = props.custom, visualElement2 = props.visualElement;
        var _a = tslib.__read(usePresence(), 2), isPresent2 = _a[0], safeToRemove = _a[1];
        var presenceContext = React3.useContext(PresenceContext);
        React3.useEffect(function() {
          var _a2, _b;
          visualElement2.isPresent = isPresent2;
          var animation = (_a2 = visualElement2.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Exit, !isPresent2, { custom: (_b = presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.custom) !== null && _b !== void 0 ? _b : custom });
          !isPresent2 && (animation === null || animation === void 0 ? void 0 : animation.then(safeToRemove));
        }, [isPresent2]);
      })
    };
    var PanSession = (
      /** @class */
      function() {
        function PanSession2(event, handlers, _a) {
          var _this = this;
          var _b = _a === void 0 ? {} : _a, transformPagePoint = _b.transformPagePoint;
          this.startEvent = null;
          this.lastMoveEvent = null;
          this.lastMoveEventInfo = null;
          this.handlers = {};
          this.updatePoint = function() {
            if (!(_this.lastMoveEvent && _this.lastMoveEventInfo))
              return;
            var info2 = getPanInfo(_this.lastMoveEventInfo, _this.history);
            var isPanStarted = _this.startEvent !== null;
            var isDistancePastThreshold = popmotion.distance(info2.offset, { x: 0, y: 0 }) >= 3;
            if (!isPanStarted && !isDistancePastThreshold)
              return;
            var point3 = info2.point;
            var timestamp2 = sync.getFrameData().timestamp;
            _this.history.push(tslib.__assign(tslib.__assign({}, point3), { timestamp: timestamp2 }));
            var _a2 = _this.handlers, onStart = _a2.onStart, onMove = _a2.onMove;
            if (!isPanStarted) {
              onStart && onStart(_this.lastMoveEvent, info2);
              _this.startEvent = _this.lastMoveEvent;
            }
            onMove && onMove(_this.lastMoveEvent, info2);
          };
          this.handlePointerMove = function(event2, info2) {
            _this.lastMoveEvent = event2;
            _this.lastMoveEventInfo = transformPoint(info2, _this.transformPagePoint);
            if (isMouseEvent(event2) && event2.buttons === 0) {
              _this.handlePointerUp(event2, info2);
              return;
            }
            sync__default["default"].update(_this.updatePoint, true);
          };
          this.handlePointerUp = function(event2, info2) {
            _this.end();
            var _a2 = _this.handlers, onEnd = _a2.onEnd, onSessionEnd = _a2.onSessionEnd;
            var panInfo = getPanInfo(transformPoint(info2, _this.transformPagePoint), _this.history);
            if (_this.startEvent && onEnd) {
              onEnd(event2, panInfo);
            }
            onSessionEnd && onSessionEnd(event2, panInfo);
          };
          if (isTouchEvent(event) && event.touches.length > 1)
            return;
          this.handlers = handlers;
          this.transformPagePoint = transformPagePoint;
          var info = extractEventInfo(event);
          var initialInfo = transformPoint(info, this.transformPagePoint);
          var point2 = initialInfo.point;
          var timestamp = sync.getFrameData().timestamp;
          this.history = [tslib.__assign(tslib.__assign({}, point2), { timestamp })];
          var onSessionStart = handlers.onSessionStart;
          onSessionStart && onSessionStart(event, getPanInfo(initialInfo, this.history));
          this.removeListeners = popmotion.pipe(addPointerEvent(window, "pointermove", this.handlePointerMove), addPointerEvent(window, "pointerup", this.handlePointerUp), addPointerEvent(window, "pointercancel", this.handlePointerUp));
        }
        PanSession2.prototype.updateHandlers = function(handlers) {
          this.handlers = handlers;
        };
        PanSession2.prototype.end = function() {
          this.removeListeners && this.removeListeners();
          sync.cancelSync.update(this.updatePoint);
        };
        return PanSession2;
      }()
    );
    function transformPoint(info, transformPagePoint) {
      return transformPagePoint ? { point: transformPagePoint(info.point) } : info;
    }
    function subtractPoint(a, b) {
      return { x: a.x - b.x, y: a.y - b.y };
    }
    function getPanInfo(_a, history) {
      var point2 = _a.point;
      return {
        point: point2,
        delta: subtractPoint(point2, lastDevicePoint(history)),
        offset: subtractPoint(point2, startDevicePoint(history)),
        velocity: getVelocity(history, 0.1)
      };
    }
    function startDevicePoint(history) {
      return history[0];
    }
    function lastDevicePoint(history) {
      return history[history.length - 1];
    }
    function getVelocity(history, timeDelta) {
      if (history.length < 2) {
        return { x: 0, y: 0 };
      }
      var i = history.length - 1;
      var timestampedPoint = null;
      var lastPoint = lastDevicePoint(history);
      while (i >= 0) {
        timestampedPoint = history[i];
        if (lastPoint.timestamp - timestampedPoint.timestamp > secondsToMilliseconds(timeDelta)) {
          break;
        }
        i--;
      }
      if (!timestampedPoint) {
        return { x: 0, y: 0 };
      }
      var time2 = (lastPoint.timestamp - timestampedPoint.timestamp) / 1e3;
      if (time2 === 0) {
        return { x: 0, y: 0 };
      }
      var currentVelocity = {
        x: (lastPoint.x - timestampedPoint.x) / time2,
        y: (lastPoint.y - timestampedPoint.y) / time2
      };
      if (currentVelocity.x === Infinity) {
        currentVelocity.x = 0;
      }
      if (currentVelocity.y === Infinity) {
        currentVelocity.y = 0;
      }
      return currentVelocity;
    }
    function calcLength(axis) {
      return axis.max - axis.min;
    }
    function isNear(value, target, maxDistance) {
      if (target === void 0) {
        target = 0;
      }
      if (maxDistance === void 0) {
        maxDistance = 0.01;
      }
      return popmotion.distance(value, target) < maxDistance;
    }
    function calcAxisDelta(delta, source, target, origin) {
      if (origin === void 0) {
        origin = 0.5;
      }
      delta.origin = origin;
      delta.originPoint = popmotion.mix(source.min, source.max, delta.origin);
      delta.scale = calcLength(target) / calcLength(source);
      if (isNear(delta.scale, 1, 1e-4) || isNaN(delta.scale))
        delta.scale = 1;
      delta.translate = popmotion.mix(target.min, target.max, delta.origin) - delta.originPoint;
      if (isNear(delta.translate) || isNaN(delta.translate))
        delta.translate = 0;
    }
    function calcBoxDelta(delta, source, target, origin) {
      calcAxisDelta(delta.x, source.x, target.x, origin === null || origin === void 0 ? void 0 : origin.originX);
      calcAxisDelta(delta.y, source.y, target.y, origin === null || origin === void 0 ? void 0 : origin.originY);
    }
    function calcRelativeAxis(target, relative, parent) {
      target.min = parent.min + relative.min;
      target.max = target.min + calcLength(relative);
    }
    function calcRelativeBox(target, relative, parent) {
      calcRelativeAxis(target.x, relative.x, parent.x);
      calcRelativeAxis(target.y, relative.y, parent.y);
    }
    function calcRelativeAxisPosition(target, layout, parent) {
      target.min = layout.min - parent.min;
      target.max = target.min + calcLength(layout);
    }
    function calcRelativePosition(target, layout, parent) {
      calcRelativeAxisPosition(target.x, layout.x, parent.x);
      calcRelativeAxisPosition(target.y, layout.y, parent.y);
    }
    function applyConstraints(point2, _a, elastic) {
      var min2 = _a.min, max2 = _a.max;
      if (min2 !== void 0 && point2 < min2) {
        point2 = elastic ? popmotion.mix(min2, point2, elastic.min) : Math.max(point2, min2);
      } else if (max2 !== void 0 && point2 > max2) {
        point2 = elastic ? popmotion.mix(max2, point2, elastic.max) : Math.min(point2, max2);
      }
      return point2;
    }
    function calcRelativeAxisConstraints(axis, min2, max2) {
      return {
        min: min2 !== void 0 ? axis.min + min2 : void 0,
        max: max2 !== void 0 ? axis.max + max2 - (axis.max - axis.min) : void 0
      };
    }
    function calcRelativeConstraints(layoutBox, _a) {
      var top = _a.top, left = _a.left, bottom = _a.bottom, right = _a.right;
      return {
        x: calcRelativeAxisConstraints(layoutBox.x, left, right),
        y: calcRelativeAxisConstraints(layoutBox.y, top, bottom)
      };
    }
    function calcViewportAxisConstraints(layoutAxis, constraintsAxis) {
      var _a;
      var min2 = constraintsAxis.min - layoutAxis.min;
      var max2 = constraintsAxis.max - layoutAxis.max;
      if (constraintsAxis.max - constraintsAxis.min < layoutAxis.max - layoutAxis.min) {
        _a = tslib.__read([max2, min2], 2), min2 = _a[0], max2 = _a[1];
      }
      return { min: min2, max: max2 };
    }
    function calcViewportConstraints(layoutBox, constraintsBox) {
      return {
        x: calcViewportAxisConstraints(layoutBox.x, constraintsBox.x),
        y: calcViewportAxisConstraints(layoutBox.y, constraintsBox.y)
      };
    }
    function calcOrigin(source, target) {
      var origin = 0.5;
      var sourceLength = calcLength(source);
      var targetLength = calcLength(target);
      if (targetLength > sourceLength) {
        origin = popmotion.progress(target.min, target.max - sourceLength, source.min);
      } else if (sourceLength > targetLength) {
        origin = popmotion.progress(source.min, source.max - targetLength, target.min);
      }
      return popmotion.clamp(0, 1, origin);
    }
    function rebaseAxisConstraints(layout, constraints) {
      var relativeConstraints = {};
      if (constraints.min !== void 0) {
        relativeConstraints.min = constraints.min - layout.min;
      }
      if (constraints.max !== void 0) {
        relativeConstraints.max = constraints.max - layout.min;
      }
      return relativeConstraints;
    }
    var defaultElastic = 0.35;
    function resolveDragElastic(dragElastic) {
      if (dragElastic === void 0) {
        dragElastic = defaultElastic;
      }
      if (dragElastic === false) {
        dragElastic = 0;
      } else if (dragElastic === true) {
        dragElastic = defaultElastic;
      }
      return {
        x: resolveAxisElastic(dragElastic, "left", "right"),
        y: resolveAxisElastic(dragElastic, "top", "bottom")
      };
    }
    function resolveAxisElastic(dragElastic, minLabel, maxLabel) {
      return {
        min: resolvePointElastic(dragElastic, minLabel),
        max: resolvePointElastic(dragElastic, maxLabel)
      };
    }
    function resolvePointElastic(dragElastic, label) {
      var _a;
      return typeof dragElastic === "number" ? dragElastic : (_a = dragElastic[label]) !== null && _a !== void 0 ? _a : 0;
    }
    var createAxisDelta = function() {
      return {
        translate: 0,
        scale: 1,
        origin: 0,
        originPoint: 0
      };
    };
    var createDelta = function() {
      return {
        x: createAxisDelta(),
        y: createAxisDelta()
      };
    };
    var createAxis = function() {
      return { min: 0, max: 0 };
    };
    var createBox = function() {
      return {
        x: createAxis(),
        y: createAxis()
      };
    };
    function eachAxis(callback) {
      return [callback("x"), callback("y")];
    }
    function convertBoundingBoxToBox(_a) {
      var top = _a.top, left = _a.left, right = _a.right, bottom = _a.bottom;
      return {
        x: { min: left, max: right },
        y: { min: top, max: bottom }
      };
    }
    function convertBoxToBoundingBox(_a) {
      var x = _a.x, y = _a.y;
      return { top: y.min, right: x.max, bottom: y.max, left: x.min };
    }
    function transformBoxPoints(point2, transformPoint2) {
      if (!transformPoint2)
        return point2;
      var topLeft = transformPoint2({ x: point2.left, y: point2.top });
      var bottomRight = transformPoint2({ x: point2.right, y: point2.bottom });
      return {
        top: topLeft.y,
        left: topLeft.x,
        bottom: bottomRight.y,
        right: bottomRight.x
      };
    }
    function isIdentityScale(scale) {
      return scale === void 0 || scale === 1;
    }
    function hasScale(_a) {
      var scale = _a.scale, scaleX = _a.scaleX, scaleY = _a.scaleY;
      return !isIdentityScale(scale) || !isIdentityScale(scaleX) || !isIdentityScale(scaleY);
    }
    function hasTransform(values) {
      return hasScale(values) || hasTranslate(values.x) || hasTranslate(values.y) || values.z || values.rotate || values.rotateX || values.rotateY;
    }
    function hasTranslate(value) {
      return value && value !== "0%";
    }
    function scalePoint(point2, scale, originPoint) {
      var distanceFromOrigin = point2 - originPoint;
      var scaled = scale * distanceFromOrigin;
      return originPoint + scaled;
    }
    function applyPointDelta(point2, translate, scale, originPoint, boxScale) {
      if (boxScale !== void 0) {
        point2 = scalePoint(point2, boxScale, originPoint);
      }
      return scalePoint(point2, scale, originPoint) + translate;
    }
    function applyAxisDelta(axis, translate, scale, originPoint, boxScale) {
      if (translate === void 0) {
        translate = 0;
      }
      if (scale === void 0) {
        scale = 1;
      }
      axis.min = applyPointDelta(axis.min, translate, scale, originPoint, boxScale);
      axis.max = applyPointDelta(axis.max, translate, scale, originPoint, boxScale);
    }
    function applyBoxDelta(box, _a) {
      var x = _a.x, y = _a.y;
      applyAxisDelta(box.x, x.translate, x.scale, x.originPoint);
      applyAxisDelta(box.y, y.translate, y.scale, y.originPoint);
    }
    function applyTreeDeltas(box, treeScale, treePath, isSharedTransition) {
      var _a, _b;
      if (isSharedTransition === void 0) {
        isSharedTransition = false;
      }
      var treeLength = treePath.length;
      if (!treeLength)
        return;
      treeScale.x = treeScale.y = 1;
      var node;
      var delta;
      for (var i = 0; i < treeLength; i++) {
        node = treePath[i];
        delta = node.projectionDelta;
        if (((_b = (_a = node.instance) === null || _a === void 0 ? void 0 : _a.style) === null || _b === void 0 ? void 0 : _b.display) === "contents")
          continue;
        if (isSharedTransition && node.options.layoutScroll && node.scroll && node !== node.root) {
          transformBox(box, { x: -node.scroll.x, y: -node.scroll.y });
        }
        if (delta) {
          treeScale.x *= delta.x.scale;
          treeScale.y *= delta.y.scale;
          applyBoxDelta(box, delta);
        }
        if (isSharedTransition && hasTransform(node.latestValues)) {
          transformBox(box, node.latestValues);
        }
      }
    }
    function translateAxis(axis, distance) {
      axis.min = axis.min + distance;
      axis.max = axis.max + distance;
    }
    function transformAxis(axis, transforms2, _a) {
      var _b = tslib.__read(_a, 3), key = _b[0], scaleKey = _b[1], originKey = _b[2];
      var axisOrigin = transforms2[originKey] !== void 0 ? transforms2[originKey] : 0.5;
      var originPoint = popmotion.mix(axis.min, axis.max, axisOrigin);
      applyAxisDelta(axis, transforms2[key], transforms2[scaleKey], originPoint, transforms2.scale);
    }
    var xKeys$1 = ["x", "scaleX", "originX"];
    var yKeys$1 = ["y", "scaleY", "originY"];
    function transformBox(box, transform2) {
      transformAxis(box.x, transform2, xKeys$1);
      transformAxis(box.y, transform2, yKeys$1);
    }
    function measureViewportBox(instance, transformPoint2) {
      return convertBoundingBoxToBox(transformBoxPoints(instance.getBoundingClientRect(), transformPoint2));
    }
    function measurePageBox(element, rootProjectionNode2, transformPagePoint) {
      var viewportBox = measureViewportBox(element, transformPagePoint);
      var scroll2 = rootProjectionNode2.scroll;
      if (scroll2) {
        translateAxis(viewportBox.x, scroll2.x);
        translateAxis(viewportBox.y, scroll2.y);
      }
      return viewportBox;
    }
    var elementDragControls = /* @__PURE__ */ new WeakMap();
    var VisualElementDragControls = (
      /** @class */
      function() {
        function VisualElementDragControls2(visualElement2) {
          this.openGlobalLock = null;
          this.isDragging = false;
          this.currentDirection = null;
          this.originPoint = { x: 0, y: 0 };
          this.constraints = false;
          this.hasMutatedConstraints = false;
          this.elastic = createBox();
          this.visualElement = visualElement2;
        }
        VisualElementDragControls2.prototype.start = function(originEvent, _a) {
          var _this = this;
          var _b = _a === void 0 ? {} : _a, _c = _b.snapToCursor, snapToCursor = _c === void 0 ? false : _c;
          if (this.visualElement.isPresent === false)
            return;
          var onSessionStart = function(event) {
            _this.stopAnimation();
            if (snapToCursor) {
              _this.snapToCursor(extractEventInfo(event, "page").point);
            }
          };
          var onStart = function(event, info) {
            var _a2;
            var _b2 = _this.getProps(), drag2 = _b2.drag, dragPropagation = _b2.dragPropagation, onDragStart = _b2.onDragStart;
            if (drag2 && !dragPropagation) {
              if (_this.openGlobalLock)
                _this.openGlobalLock();
              _this.openGlobalLock = getGlobalLock(drag2);
              if (!_this.openGlobalLock)
                return;
            }
            _this.isDragging = true;
            _this.currentDirection = null;
            _this.resolveConstraints();
            if (_this.visualElement.projection) {
              _this.visualElement.projection.isAnimationBlocked = true;
              _this.visualElement.projection.target = void 0;
            }
            eachAxis(function(axis) {
              var _a3, _b3;
              var current = _this.getAxisMotionValue(axis).get() || 0;
              if (styleValueTypes.percent.test(current)) {
                var measuredAxis = (_b3 = (_a3 = _this.visualElement.projection) === null || _a3 === void 0 ? void 0 : _a3.layout) === null || _b3 === void 0 ? void 0 : _b3.actual[axis];
                if (measuredAxis) {
                  var length_1 = calcLength(measuredAxis);
                  current = length_1 * (parseFloat(current) / 100);
                }
              }
              _this.originPoint[axis] = current;
            });
            onDragStart === null || onDragStart === void 0 ? void 0 : onDragStart(event, info);
            (_a2 = _this.visualElement.animationState) === null || _a2 === void 0 ? void 0 : _a2.setActive(exports.AnimationType.Drag, true);
          };
          var onMove = function(event, info) {
            var _a2 = _this.getProps(), dragPropagation = _a2.dragPropagation, dragDirectionLock = _a2.dragDirectionLock, onDirectionLock = _a2.onDirectionLock, onDrag = _a2.onDrag;
            if (!dragPropagation && !_this.openGlobalLock)
              return;
            var offset3 = info.offset;
            if (dragDirectionLock && _this.currentDirection === null) {
              _this.currentDirection = getCurrentDirection(offset3);
              if (_this.currentDirection !== null) {
                onDirectionLock === null || onDirectionLock === void 0 ? void 0 : onDirectionLock(_this.currentDirection);
              }
              return;
            }
            _this.updateAxis("x", info.point, offset3);
            _this.updateAxis("y", info.point, offset3);
            _this.visualElement.syncRender();
            onDrag === null || onDrag === void 0 ? void 0 : onDrag(event, info);
          };
          var onSessionEnd = function(event, info) {
            return _this.stop(event, info);
          };
          this.panSession = new PanSession(originEvent, {
            onSessionStart,
            onStart,
            onMove,
            onSessionEnd
          }, { transformPagePoint: this.visualElement.getTransformPagePoint() });
        };
        VisualElementDragControls2.prototype.stop = function(event, info) {
          var isDragging = this.isDragging;
          this.cancel();
          if (!isDragging)
            return;
          var velocity = info.velocity;
          this.startAnimation(velocity);
          var onDragEnd = this.getProps().onDragEnd;
          onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd(event, info);
        };
        VisualElementDragControls2.prototype.cancel = function() {
          var _a, _b;
          this.isDragging = false;
          if (this.visualElement.projection) {
            this.visualElement.projection.isAnimationBlocked = false;
          }
          (_a = this.panSession) === null || _a === void 0 ? void 0 : _a.end();
          this.panSession = void 0;
          var dragPropagation = this.getProps().dragPropagation;
          if (!dragPropagation && this.openGlobalLock) {
            this.openGlobalLock();
            this.openGlobalLock = null;
          }
          (_b = this.visualElement.animationState) === null || _b === void 0 ? void 0 : _b.setActive(exports.AnimationType.Drag, false);
        };
        VisualElementDragControls2.prototype.updateAxis = function(axis, _point, offset3) {
          var drag2 = this.getProps().drag;
          if (!offset3 || !shouldDrag(axis, drag2, this.currentDirection))
            return;
          var axisValue = this.getAxisMotionValue(axis);
          var next = this.originPoint[axis] + offset3[axis];
          if (this.constraints && this.constraints[axis]) {
            next = applyConstraints(next, this.constraints[axis], this.elastic[axis]);
          }
          axisValue.set(next);
        };
        VisualElementDragControls2.prototype.resolveConstraints = function() {
          var _this = this;
          var _a = this.getProps(), dragConstraints = _a.dragConstraints, dragElastic = _a.dragElastic;
          var layout = (this.visualElement.projection || {}).layout;
          var prevConstraints = this.constraints;
          if (dragConstraints && isRefObject(dragConstraints)) {
            if (!this.constraints) {
              this.constraints = this.resolveRefConstraints();
            }
          } else {
            if (dragConstraints && layout) {
              this.constraints = calcRelativeConstraints(layout.actual, dragConstraints);
            } else {
              this.constraints = false;
            }
          }
          this.elastic = resolveDragElastic(dragElastic);
          if (prevConstraints !== this.constraints && layout && this.constraints && !this.hasMutatedConstraints) {
            eachAxis(function(axis) {
              if (_this.getAxisMotionValue(axis)) {
                _this.constraints[axis] = rebaseAxisConstraints(layout.actual[axis], _this.constraints[axis]);
              }
            });
          }
        };
        VisualElementDragControls2.prototype.resolveRefConstraints = function() {
          var _a = this.getProps(), constraints = _a.dragConstraints, onMeasureDragConstraints = _a.onMeasureDragConstraints;
          if (!constraints || !isRefObject(constraints))
            return false;
          var constraintsElement = constraints.current;
          heyListen.invariant(constraintsElement !== null, "If `dragConstraints` is set as a React ref, that ref must be passed to another component's `ref` prop.");
          var projection = this.visualElement.projection;
          if (!projection || !projection.layout)
            return false;
          var constraintsBox = measurePageBox(constraintsElement, projection.root, this.visualElement.getTransformPagePoint());
          var measuredConstraints = calcViewportConstraints(projection.layout.actual, constraintsBox);
          if (onMeasureDragConstraints) {
            var userConstraints = onMeasureDragConstraints(convertBoxToBoundingBox(measuredConstraints));
            this.hasMutatedConstraints = !!userConstraints;
            if (userConstraints) {
              measuredConstraints = convertBoundingBoxToBox(userConstraints);
            }
          }
          return measuredConstraints;
        };
        VisualElementDragControls2.prototype.startAnimation = function(velocity) {
          var _this = this;
          var _a = this.getProps(), drag2 = _a.drag, dragMomentum = _a.dragMomentum, dragElastic = _a.dragElastic, dragTransition = _a.dragTransition, dragSnapToOrigin = _a.dragSnapToOrigin, onDragTransitionEnd = _a.onDragTransitionEnd;
          var constraints = this.constraints || {};
          var momentumAnimations = eachAxis(function(axis) {
            var _a2;
            if (!shouldDrag(axis, drag2, _this.currentDirection)) {
              return;
            }
            var transition = (_a2 = constraints === null || constraints === void 0 ? void 0 : constraints[axis]) !== null && _a2 !== void 0 ? _a2 : {};
            if (dragSnapToOrigin)
              transition = { min: 0, max: 0 };
            var bounceStiffness = dragElastic ? 200 : 1e6;
            var bounceDamping = dragElastic ? 40 : 1e7;
            var inertia = tslib.__assign(tslib.__assign({ type: "inertia", velocity: dragMomentum ? velocity[axis] : 0, bounceStiffness, bounceDamping, timeConstant: 750, restDelta: 1, restSpeed: 10 }, dragTransition), transition);
            return _this.startAxisValueAnimation(axis, inertia);
          });
          return Promise.all(momentumAnimations).then(onDragTransitionEnd);
        };
        VisualElementDragControls2.prototype.startAxisValueAnimation = function(axis, transition) {
          var axisValue = this.getAxisMotionValue(axis);
          return startAnimation(axis, axisValue, 0, transition);
        };
        VisualElementDragControls2.prototype.stopAnimation = function() {
          var _this = this;
          eachAxis(function(axis) {
            return _this.getAxisMotionValue(axis).stop();
          });
        };
        VisualElementDragControls2.prototype.getAxisMotionValue = function(axis) {
          var _a, _b;
          var dragKey = "_drag" + axis.toUpperCase();
          var externalMotionValue = this.visualElement.getProps()[dragKey];
          return externalMotionValue ? externalMotionValue : this.visualElement.getValue(axis, (_b = (_a = this.visualElement.getProps().initial) === null || _a === void 0 ? void 0 : _a[axis]) !== null && _b !== void 0 ? _b : 0);
        };
        VisualElementDragControls2.prototype.snapToCursor = function(point2) {
          var _this = this;
          eachAxis(function(axis) {
            var drag2 = _this.getProps().drag;
            if (!shouldDrag(axis, drag2, _this.currentDirection))
              return;
            var projection = _this.visualElement.projection;
            var axisValue = _this.getAxisMotionValue(axis);
            if (projection && projection.layout) {
              var _a = projection.layout.actual[axis], min2 = _a.min, max2 = _a.max;
              axisValue.set(point2[axis] - popmotion.mix(min2, max2, 0.5));
            }
          });
        };
        VisualElementDragControls2.prototype.scalePositionWithinConstraints = function() {
          var _this = this;
          var _a;
          var _b = this.getProps(), drag2 = _b.drag, dragConstraints = _b.dragConstraints;
          var projection = this.visualElement.projection;
          if (!isRefObject(dragConstraints) || !projection || !this.constraints)
            return;
          this.stopAnimation();
          var boxProgress = { x: 0, y: 0 };
          eachAxis(function(axis) {
            var axisValue = _this.getAxisMotionValue(axis);
            if (axisValue) {
              var latest = axisValue.get();
              boxProgress[axis] = calcOrigin({ min: latest, max: latest }, _this.constraints[axis]);
            }
          });
          var transformTemplate = this.visualElement.getProps().transformTemplate;
          this.visualElement.getInstance().style.transform = transformTemplate ? transformTemplate({}, "") : "none";
          (_a = projection.root) === null || _a === void 0 ? void 0 : _a.updateScroll();
          projection.updateLayout();
          this.resolveConstraints();
          eachAxis(function(axis) {
            if (!shouldDrag(axis, drag2, null))
              return;
            var axisValue = _this.getAxisMotionValue(axis);
            var _a2 = _this.constraints[axis], min2 = _a2.min, max2 = _a2.max;
            axisValue.set(popmotion.mix(min2, max2, boxProgress[axis]));
          });
        };
        VisualElementDragControls2.prototype.addListeners = function() {
          var _this = this;
          var _a;
          elementDragControls.set(this.visualElement, this);
          var element = this.visualElement.getInstance();
          var stopPointerListener = addPointerEvent(element, "pointerdown", function(event) {
            var _a2 = _this.getProps(), drag2 = _a2.drag, _b = _a2.dragListener, dragListener = _b === void 0 ? true : _b;
            drag2 && dragListener && _this.start(event);
          });
          var measureDragConstraints = function() {
            var dragConstraints = _this.getProps().dragConstraints;
            if (isRefObject(dragConstraints)) {
              _this.constraints = _this.resolveRefConstraints();
            }
          };
          var projection = this.visualElement.projection;
          var stopMeasureLayoutListener = projection.addEventListener("measure", measureDragConstraints);
          if (projection && !projection.layout) {
            (_a = projection.root) === null || _a === void 0 ? void 0 : _a.updateScroll();
            projection.updateLayout();
          }
          measureDragConstraints();
          var stopResizeListener = addDomEvent(window, "resize", function() {
            return _this.scalePositionWithinConstraints();
          });
          projection.addEventListener("didUpdate", function(_a2) {
            var delta = _a2.delta, hasLayoutChanged = _a2.hasLayoutChanged;
            if (_this.isDragging && hasLayoutChanged) {
              eachAxis(function(axis) {
                var motionValue2 = _this.getAxisMotionValue(axis);
                if (!motionValue2)
                  return;
                _this.originPoint[axis] += delta[axis].translate;
                motionValue2.set(motionValue2.get() + delta[axis].translate);
              });
              _this.visualElement.syncRender();
            }
          });
          return function() {
            stopResizeListener();
            stopPointerListener();
            stopMeasureLayoutListener();
          };
        };
        VisualElementDragControls2.prototype.getProps = function() {
          var props = this.visualElement.getProps();
          var _a = props.drag, drag2 = _a === void 0 ? false : _a, _b = props.dragDirectionLock, dragDirectionLock = _b === void 0 ? false : _b, _c = props.dragPropagation, dragPropagation = _c === void 0 ? false : _c, _d = props.dragConstraints, dragConstraints = _d === void 0 ? false : _d, _e = props.dragElastic, dragElastic = _e === void 0 ? defaultElastic : _e, _f = props.dragMomentum, dragMomentum = _f === void 0 ? true : _f;
          return tslib.__assign(tslib.__assign({}, props), { drag: drag2, dragDirectionLock, dragPropagation, dragConstraints, dragElastic, dragMomentum });
        };
        return VisualElementDragControls2;
      }()
    );
    function shouldDrag(direction, drag2, currentDirection) {
      return (drag2 === true || drag2 === direction) && (currentDirection === null || currentDirection === direction);
    }
    function getCurrentDirection(offset3, lockThreshold) {
      if (lockThreshold === void 0) {
        lockThreshold = 10;
      }
      var direction = null;
      if (Math.abs(offset3.y) > lockThreshold) {
        direction = "y";
      } else if (Math.abs(offset3.x) > lockThreshold) {
        direction = "x";
      }
      return direction;
    }
    function useDrag(props) {
      var groupDragControls = props.dragControls, visualElement2 = props.visualElement;
      var dragControls = useConstant(function() {
        return new VisualElementDragControls(visualElement2);
      });
      React3.useEffect(function() {
        return groupDragControls && groupDragControls.subscribe(dragControls);
      }, [dragControls, groupDragControls]);
      React3.useEffect(function() {
        return dragControls.addListeners();
      }, [dragControls]);
    }
    function usePanGesture(_a) {
      var onPan = _a.onPan, onPanStart = _a.onPanStart, onPanEnd = _a.onPanEnd, onPanSessionStart = _a.onPanSessionStart, visualElement2 = _a.visualElement;
      var hasPanEvents = onPan || onPanStart || onPanEnd || onPanSessionStart;
      var panSession = React3.useRef(null);
      var transformPagePoint = React3.useContext(MotionConfigContext).transformPagePoint;
      var handlers = {
        onSessionStart: onPanSessionStart,
        onStart: onPanStart,
        onMove: onPan,
        onEnd: function(event, info) {
          panSession.current = null;
          onPanEnd && onPanEnd(event, info);
        }
      };
      React3.useEffect(function() {
        if (panSession.current !== null) {
          panSession.current.updateHandlers(handlers);
        }
      });
      function onPointerDown(event) {
        panSession.current = new PanSession(event, handlers, {
          transformPagePoint
        });
      }
      usePointerEvent(visualElement2, "pointerdown", hasPanEvents && onPointerDown);
      useUnmountEffect(function() {
        return panSession.current && panSession.current.end();
      });
    }
    var drag = {
      pan: makeRenderlessComponent(usePanGesture),
      drag: makeRenderlessComponent(useDrag)
    };
    var names = [
      "LayoutMeasure",
      "BeforeLayoutMeasure",
      "LayoutUpdate",
      "ViewportBoxUpdate",
      "Update",
      "Render",
      "AnimationComplete",
      "LayoutAnimationComplete",
      "AnimationStart",
      "LayoutAnimationStart",
      "SetAxisTarget",
      "Unmount"
    ];
    function createLifecycles() {
      var managers = names.map(function() {
        return new SubscriptionManager();
      });
      var propSubscriptions = {};
      var lifecycles = {
        clearAllListeners: function() {
          return managers.forEach(function(manager) {
            return manager.clear();
          });
        },
        updatePropListeners: function(props) {
          names.forEach(function(name) {
            var _a;
            var on = "on" + name;
            var propListener = props[on];
            (_a = propSubscriptions[name]) === null || _a === void 0 ? void 0 : _a.call(propSubscriptions);
            if (propListener) {
              propSubscriptions[name] = lifecycles[on](propListener);
            }
          });
        }
      };
      managers.forEach(function(manager, i) {
        lifecycles["on" + names[i]] = function(handler) {
          return manager.add(handler);
        };
        lifecycles["notify" + names[i]] = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          return manager.notify.apply(manager, tslib.__spreadArray([], tslib.__read(args), false));
        };
      });
      return lifecycles;
    }
    function updateMotionValuesFromProps(element, next, prev) {
      var _a;
      for (var key in next) {
        var nextValue = next[key];
        var prevValue = prev[key];
        if (isMotionValue(nextValue)) {
          element.addValue(key, nextValue);
          if (true) {
            warnOnce(nextValue.version === "6.5.1", "Attempting to mix Framer Motion versions ".concat(nextValue.version, " with 6.5.1 may not work as expected."));
          }
        } else if (isMotionValue(prevValue)) {
          element.addValue(key, motionValue(nextValue));
        } else if (prevValue !== nextValue) {
          if (element.hasValue(key)) {
            var existingValue = element.getValue(key);
            !existingValue.hasAnimated && existingValue.set(nextValue);
          } else {
            element.addValue(key, motionValue((_a = element.getStaticValue(key)) !== null && _a !== void 0 ? _a : nextValue));
          }
        }
      }
      for (var key in prev) {
        if (next[key] === void 0)
          element.removeValue(key);
      }
      return next;
    }
    var visualElement = function(_a) {
      var _b = _a.treeType, treeType = _b === void 0 ? "" : _b, build = _a.build, getBaseTarget = _a.getBaseTarget, makeTargetAnimatable = _a.makeTargetAnimatable, measureViewportBox2 = _a.measureViewportBox, renderInstance = _a.render, readValueFromInstance = _a.readValueFromInstance, removeValueFromRenderState = _a.removeValueFromRenderState, sortNodePosition = _a.sortNodePosition, scrapeMotionValuesFromProps2 = _a.scrapeMotionValuesFromProps;
      return function(_a2, options) {
        var parent = _a2.parent, props = _a2.props, presenceId = _a2.presenceId, blockInitialAnimation = _a2.blockInitialAnimation, visualState = _a2.visualState, shouldReduceMotion = _a2.shouldReduceMotion;
        if (options === void 0) {
          options = {};
        }
        var isMounted = false;
        var latestValues = visualState.latestValues, renderState = visualState.renderState;
        var instance;
        var lifecycles = createLifecycles();
        var values = /* @__PURE__ */ new Map();
        var valueSubscriptions = /* @__PURE__ */ new Map();
        var prevMotionValues = {};
        var baseTarget = tslib.__assign({}, latestValues);
        var removeFromVariantTree;
        function render() {
          if (!instance || !isMounted)
            return;
          triggerBuild();
          renderInstance(instance, renderState, props.style, element.projection);
        }
        function triggerBuild() {
          build(element, renderState, latestValues, options, props);
        }
        function update() {
          lifecycles.notifyUpdate(latestValues);
        }
        function bindToMotionValue(key2, value2) {
          var removeOnChange = value2.onChange(function(latestValue) {
            latestValues[key2] = latestValue;
            props.onUpdate && sync__default["default"].update(update, false, true);
          });
          var removeOnRenderRequest = value2.onRenderRequest(element.scheduleRender);
          valueSubscriptions.set(key2, function() {
            removeOnChange();
            removeOnRenderRequest();
          });
        }
        var initialMotionValues = scrapeMotionValuesFromProps2(props);
        for (var key in initialMotionValues) {
          var value = initialMotionValues[key];
          if (latestValues[key] !== void 0 && isMotionValue(value)) {
            value.set(latestValues[key], false);
          }
        }
        var isControllingVariants = checkIfControllingVariants(props);
        var isVariantNode = checkIfVariantNode(props);
        var element = tslib.__assign(tslib.__assign({
          treeType,
          /**
           * This is a mirror of the internal instance prop, which keeps
           * VisualElement type-compatible with React's RefObject.
           */
          current: null,
          /**
           * The depth of this visual element within the visual element tree.
           */
          depth: parent ? parent.depth + 1 : 0,
          parent,
          children: /* @__PURE__ */ new Set(),
          /**
           *
           */
          presenceId,
          shouldReduceMotion,
          /**
           * If this component is part of the variant tree, it should track
           * any children that are also part of the tree. This is essentially
           * a shadow tree to simplify logic around how to stagger over children.
           */
          variantChildren: isVariantNode ? /* @__PURE__ */ new Set() : void 0,
          /**
           * Whether this instance is visible. This can be changed imperatively
           * by the projection tree, is analogous to CSS's visibility in that
           * hidden elements should take up layout, and needs enacting by the configured
           * render function.
           */
          isVisible: void 0,
          /**
           * Normally, if a component is controlled by a parent's variants, it can
           * rely on that ancestor to trigger animations further down the tree.
           * However, if a component is created after its parent is mounted, the parent
           * won't trigger that mount animation so the child needs to.
           *
           * TODO: This might be better replaced with a method isParentMounted
           */
          manuallyAnimateOnMount: Boolean(parent === null || parent === void 0 ? void 0 : parent.isMounted()),
          /**
           * This can be set by AnimatePresence to force components that mount
           * at the same time as it to mount as if they have initial={false} set.
           */
          blockInitialAnimation,
          /**
           * Determine whether this component has mounted yet. This is mostly used
           * by variant children to determine whether they need to trigger their
           * own animations on mount.
           */
          isMounted: function() {
            return Boolean(instance);
          },
          mount: function(newInstance) {
            isMounted = true;
            instance = element.current = newInstance;
            if (element.projection) {
              element.projection.mount(newInstance);
            }
            if (isVariantNode && parent && !isControllingVariants) {
              removeFromVariantTree = parent === null || parent === void 0 ? void 0 : parent.addVariantChild(element);
            }
            values.forEach(function(value2, key2) {
              return bindToMotionValue(key2, value2);
            });
            parent === null || parent === void 0 ? void 0 : parent.children.add(element);
            element.setProps(props);
          },
          /**
           *
           */
          unmount: function() {
            var _a3;
            (_a3 = element.projection) === null || _a3 === void 0 ? void 0 : _a3.unmount();
            sync.cancelSync.update(update);
            sync.cancelSync.render(render);
            valueSubscriptions.forEach(function(remove) {
              return remove();
            });
            removeFromVariantTree === null || removeFromVariantTree === void 0 ? void 0 : removeFromVariantTree();
            parent === null || parent === void 0 ? void 0 : parent.children.delete(element);
            lifecycles.clearAllListeners();
            instance = void 0;
            isMounted = false;
          },
          /**
           * Add a child visual element to our set of children.
           */
          addVariantChild: function(child) {
            var _a3;
            var closestVariantNode = element.getClosestVariantNode();
            if (closestVariantNode) {
              (_a3 = closestVariantNode.variantChildren) === null || _a3 === void 0 ? void 0 : _a3.add(child);
              return function() {
                return closestVariantNode.variantChildren.delete(child);
              };
            }
          },
          sortNodePosition: function(other) {
            if (!sortNodePosition || treeType !== other.treeType)
              return 0;
            return sortNodePosition(element.getInstance(), other.getInstance());
          },
          /**
           * Returns the closest variant node in the tree starting from
           * this visual element.
           */
          getClosestVariantNode: function() {
            return isVariantNode ? element : parent === null || parent === void 0 ? void 0 : parent.getClosestVariantNode();
          },
          /**
           * Expose the latest layoutId prop.
           */
          getLayoutId: function() {
            return props.layoutId;
          },
          /**
           * Returns the current instance.
           */
          getInstance: function() {
            return instance;
          },
          /**
           * Get/set the latest static values.
           */
          getStaticValue: function(key2) {
            return latestValues[key2];
          },
          setStaticValue: function(key2, value2) {
            return latestValues[key2] = value2;
          },
          /**
           * Returns the latest motion value state. Currently only used to take
           * a snapshot of the visual element - perhaps this can return the whole
           * visual state
           */
          getLatestValues: function() {
            return latestValues;
          },
          /**
           * Set the visiblity of the visual element. If it's changed, schedule
           * a render to reflect these changes.
           */
          setVisibility: function(visibility) {
            if (element.isVisible === visibility)
              return;
            element.isVisible = visibility;
            element.scheduleRender();
          },
          /**
           * Make a target animatable by Popmotion. For instance, if we're
           * trying to animate width from 100px to 100vw we need to measure 100vw
           * in pixels to determine what we really need to animate to. This is also
           * pluggable to support Framer's custom value types like Color,
           * and CSS variables.
           */
          makeTargetAnimatable: function(target, canMutate) {
            if (canMutate === void 0) {
              canMutate = true;
            }
            return makeTargetAnimatable(element, target, props, canMutate);
          },
          /**
           * Measure the current viewport box with or without transforms.
           * Only measures axis-aligned boxes, rotate and skew must be manually
           * removed with a re-render to work.
           */
          measureViewportBox: function() {
            return measureViewportBox2(instance, props);
          },
          // Motion values ========================
          /**
           * Add a motion value and bind it to this visual element.
           */
          addValue: function(key2, value2) {
            if (element.hasValue(key2))
              element.removeValue(key2);
            values.set(key2, value2);
            latestValues[key2] = value2.get();
            bindToMotionValue(key2, value2);
          },
          /**
           * Remove a motion value and unbind any active subscriptions.
           */
          removeValue: function(key2) {
            var _a3;
            values.delete(key2);
            (_a3 = valueSubscriptions.get(key2)) === null || _a3 === void 0 ? void 0 : _a3();
            valueSubscriptions.delete(key2);
            delete latestValues[key2];
            removeValueFromRenderState(key2, renderState);
          },
          /**
           * Check whether we have a motion value for this key
           */
          hasValue: function(key2) {
            return values.has(key2);
          },
          /**
           * Get a motion value for this key. If called with a default
           * value, we'll create one if none exists.
           */
          getValue: function(key2, defaultValue) {
            var value2 = values.get(key2);
            if (value2 === void 0 && defaultValue !== void 0) {
              value2 = motionValue(defaultValue);
              element.addValue(key2, value2);
            }
            return value2;
          },
          /**
           * Iterate over our motion values.
           */
          forEachValue: function(callback) {
            return values.forEach(callback);
          },
          /**
           * If we're trying to animate to a previously unencountered value,
           * we need to check for it in our state and as a last resort read it
           * directly from the instance (which might have performance implications).
           */
          readValue: function(key2) {
            var _a3;
            return (_a3 = latestValues[key2]) !== null && _a3 !== void 0 ? _a3 : readValueFromInstance(instance, key2, options);
          },
          /**
           * Set the base target to later animate back to. This is currently
           * only hydrated on creation and when we first read a value.
           */
          setBaseTarget: function(key2, value2) {
            baseTarget[key2] = value2;
          },
          /**
           * Find the base target for a value thats been removed from all animation
           * props.
           */
          getBaseTarget: function(key2) {
            if (getBaseTarget) {
              var target = getBaseTarget(props, key2);
              if (target !== void 0 && !isMotionValue(target))
                return target;
            }
            return baseTarget[key2];
          }
        }, lifecycles), {
          /**
           * Build the renderer state based on the latest visual state.
           */
          build: function() {
            triggerBuild();
            return renderState;
          },
          /**
           * Schedule a render on the next animation frame.
           */
          scheduleRender: function() {
            sync__default["default"].render(render, false, true);
          },
          /**
           * Synchronously fire render. It's prefered that we batch renders but
           * in many circumstances, like layout measurement, we need to run this
           * synchronously. However in those instances other measures should be taken
           * to batch reads/writes.
           */
          syncRender: render,
          /**
           * Update the provided props. Ensure any newly-added motion values are
           * added to our map, old ones removed, and listeners updated.
           */
          setProps: function(newProps) {
            if (newProps.transformTemplate || props.transformTemplate) {
              element.scheduleRender();
            }
            props = newProps;
            lifecycles.updatePropListeners(newProps);
            prevMotionValues = updateMotionValuesFromProps(element, scrapeMotionValuesFromProps2(props), prevMotionValues);
          },
          getProps: function() {
            return props;
          },
          // Variants ==============================
          /**
           * Returns the variant definition with a given name.
           */
          getVariant: function(name) {
            var _a3;
            return (_a3 = props.variants) === null || _a3 === void 0 ? void 0 : _a3[name];
          },
          /**
           * Returns the defined default transition on this component.
           */
          getDefaultTransition: function() {
            return props.transition;
          },
          getTransformPagePoint: function() {
            return props.transformPagePoint;
          },
          /**
           * Used by child variant nodes to get the closest ancestor variant props.
           */
          getVariantContext: function(startAtParent) {
            if (startAtParent === void 0) {
              startAtParent = false;
            }
            if (startAtParent)
              return parent === null || parent === void 0 ? void 0 : parent.getVariantContext();
            if (!isControllingVariants) {
              var context_1 = (parent === null || parent === void 0 ? void 0 : parent.getVariantContext()) || {};
              if (props.initial !== void 0) {
                context_1.initial = props.initial;
              }
              return context_1;
            }
            var context = {};
            for (var i = 0; i < numVariantProps; i++) {
              var name_1 = variantProps[i];
              var prop = props[name_1];
              if (isVariantLabel(prop) || prop === false) {
                context[name_1] = prop;
              }
            }
            return context;
          }
        });
        return element;
      };
    };
    var variantProps = tslib.__spreadArray(["initial"], tslib.__read(variantPriorityOrder), false);
    var numVariantProps = variantProps.length;
    function isCSSVariable(value) {
      return typeof value === "string" && value.startsWith("var(--");
    }
    var cssVariableRegex = /var\((--[a-zA-Z0-9-_]+),? ?([a-zA-Z0-9 ()%#.,-]+)?\)/;
    function parseCSSVariable(current) {
      var match = cssVariableRegex.exec(current);
      if (!match)
        return [,];
      var _a = tslib.__read(match, 3), token = _a[1], fallback = _a[2];
      return [token, fallback];
    }
    var maxDepth = 4;
    function getVariableValue(current, element, depth) {
      if (depth === void 0) {
        depth = 1;
      }
      heyListen.invariant(depth <= maxDepth, 'Max CSS variable fallback depth detected in property "'.concat(current, '". This may indicate a circular fallback dependency.'));
      var _a = tslib.__read(parseCSSVariable(current), 2), token = _a[0], fallback = _a[1];
      if (!token)
        return;
      var resolved = window.getComputedStyle(element).getPropertyValue(token);
      if (resolved) {
        return resolved.trim();
      } else if (isCSSVariable(fallback)) {
        return getVariableValue(fallback, element, depth + 1);
      } else {
        return fallback;
      }
    }
    function resolveCSSVariables(visualElement2, _a, transitionEnd) {
      var _b;
      var target = tslib.__rest(_a, []);
      var element = visualElement2.getInstance();
      if (!(element instanceof Element))
        return { target, transitionEnd };
      if (transitionEnd) {
        transitionEnd = tslib.__assign({}, transitionEnd);
      }
      visualElement2.forEachValue(function(value) {
        var current2 = value.get();
        if (!isCSSVariable(current2))
          return;
        var resolved2 = getVariableValue(current2, element);
        if (resolved2)
          value.set(resolved2);
      });
      for (var key in target) {
        var current = target[key];
        if (!isCSSVariable(current))
          continue;
        var resolved = getVariableValue(current, element);
        if (!resolved)
          continue;
        target[key] = resolved;
        if (transitionEnd)
          (_b = transitionEnd[key]) !== null && _b !== void 0 ? _b : transitionEnd[key] = current;
      }
      return { target, transitionEnd };
    }
    var positionalKeys = /* @__PURE__ */ new Set([
      "width",
      "height",
      "top",
      "left",
      "right",
      "bottom",
      "x",
      "y"
    ]);
    var isPositionalKey = function(key) {
      return positionalKeys.has(key);
    };
    var hasPositionalKey = function(target) {
      return Object.keys(target).some(isPositionalKey);
    };
    var setAndResetVelocity = function(value, to) {
      value.set(to, false);
      value.set(to);
    };
    var isNumOrPxType = function(v) {
      return v === styleValueTypes.number || v === styleValueTypes.px;
    };
    var BoundingBoxDimension;
    (function(BoundingBoxDimension2) {
      BoundingBoxDimension2["width"] = "width";
      BoundingBoxDimension2["height"] = "height";
      BoundingBoxDimension2["left"] = "left";
      BoundingBoxDimension2["right"] = "right";
      BoundingBoxDimension2["top"] = "top";
      BoundingBoxDimension2["bottom"] = "bottom";
    })(BoundingBoxDimension || (BoundingBoxDimension = {}));
    var getPosFromMatrix = function(matrix, pos) {
      return parseFloat(matrix.split(", ")[pos]);
    };
    var getTranslateFromMatrix = function(pos2, pos3) {
      return function(_bbox, _a) {
        var transform2 = _a.transform;
        if (transform2 === "none" || !transform2)
          return 0;
        var matrix3d = transform2.match(/^matrix3d\((.+)\)$/);
        if (matrix3d) {
          return getPosFromMatrix(matrix3d[1], pos3);
        } else {
          var matrix = transform2.match(/^matrix\((.+)\)$/);
          if (matrix) {
            return getPosFromMatrix(matrix[1], pos2);
          } else {
            return 0;
          }
        }
      };
    };
    var transformKeys = /* @__PURE__ */ new Set(["x", "y", "z"]);
    var nonTranslationalTransformKeys = transformProps.filter(function(key) {
      return !transformKeys.has(key);
    });
    function removeNonTranslationalTransform(visualElement2) {
      var removedTransforms = [];
      nonTranslationalTransformKeys.forEach(function(key) {
        var value = visualElement2.getValue(key);
        if (value !== void 0) {
          removedTransforms.push([key, value.get()]);
          value.set(key.startsWith("scale") ? 1 : 0);
        }
      });
      if (removedTransforms.length)
        visualElement2.syncRender();
      return removedTransforms;
    }
    var positionalValues = {
      // Dimensions
      width: function(_a, _b) {
        var x = _a.x;
        var _c = _b.paddingLeft, paddingLeft = _c === void 0 ? "0" : _c, _d = _b.paddingRight, paddingRight = _d === void 0 ? "0" : _d;
        return x.max - x.min - parseFloat(paddingLeft) - parseFloat(paddingRight);
      },
      height: function(_a, _b) {
        var y = _a.y;
        var _c = _b.paddingTop, paddingTop = _c === void 0 ? "0" : _c, _d = _b.paddingBottom, paddingBottom = _d === void 0 ? "0" : _d;
        return y.max - y.min - parseFloat(paddingTop) - parseFloat(paddingBottom);
      },
      top: function(_bbox, _a) {
        var top = _a.top;
        return parseFloat(top);
      },
      left: function(_bbox, _a) {
        var left = _a.left;
        return parseFloat(left);
      },
      bottom: function(_a, _b) {
        var y = _a.y;
        var top = _b.top;
        return parseFloat(top) + (y.max - y.min);
      },
      right: function(_a, _b) {
        var x = _a.x;
        var left = _b.left;
        return parseFloat(left) + (x.max - x.min);
      },
      // Transform
      x: getTranslateFromMatrix(4, 13),
      y: getTranslateFromMatrix(5, 14)
    };
    var convertChangedValueTypes = function(target, visualElement2, changedKeys) {
      var originBbox = visualElement2.measureViewportBox();
      var element = visualElement2.getInstance();
      var elementComputedStyle = getComputedStyle(element);
      var display = elementComputedStyle.display;
      var origin = {};
      if (display === "none") {
        visualElement2.setStaticValue("display", target.display || "block");
      }
      changedKeys.forEach(function(key) {
        origin[key] = positionalValues[key](originBbox, elementComputedStyle);
      });
      visualElement2.syncRender();
      var targetBbox = visualElement2.measureViewportBox();
      changedKeys.forEach(function(key) {
        var value = visualElement2.getValue(key);
        setAndResetVelocity(value, origin[key]);
        target[key] = positionalValues[key](targetBbox, elementComputedStyle);
      });
      return target;
    };
    var checkAndConvertChangedValueTypes = function(visualElement2, target, origin, transitionEnd) {
      if (origin === void 0) {
        origin = {};
      }
      if (transitionEnd === void 0) {
        transitionEnd = {};
      }
      target = tslib.__assign({}, target);
      transitionEnd = tslib.__assign({}, transitionEnd);
      var targetPositionalKeys = Object.keys(target).filter(isPositionalKey);
      var removedTransformValues = [];
      var hasAttemptedToRemoveTransformValues = false;
      var changedValueTypeKeys = [];
      targetPositionalKeys.forEach(function(key) {
        var value = visualElement2.getValue(key);
        if (!visualElement2.hasValue(key))
          return;
        var from = origin[key];
        var fromType = findDimensionValueType(from);
        var to = target[key];
        var toType;
        if (isKeyframesTarget(to)) {
          var numKeyframes = to.length;
          var fromIndex = to[0] === null ? 1 : 0;
          from = to[fromIndex];
          fromType = findDimensionValueType(from);
          for (var i = fromIndex; i < numKeyframes; i++) {
            if (!toType) {
              toType = findDimensionValueType(to[i]);
              heyListen.invariant(toType === fromType || isNumOrPxType(fromType) && isNumOrPxType(toType), "Keyframes must be of the same dimension as the current value");
            } else {
              heyListen.invariant(findDimensionValueType(to[i]) === toType, "All keyframes must be of the same type");
            }
          }
        } else {
          toType = findDimensionValueType(to);
        }
        if (fromType !== toType) {
          if (isNumOrPxType(fromType) && isNumOrPxType(toType)) {
            var current = value.get();
            if (typeof current === "string") {
              value.set(parseFloat(current));
            }
            if (typeof to === "string") {
              target[key] = parseFloat(to);
            } else if (Array.isArray(to) && toType === styleValueTypes.px) {
              target[key] = to.map(parseFloat);
            }
          } else if ((fromType === null || fromType === void 0 ? void 0 : fromType.transform) && (toType === null || toType === void 0 ? void 0 : toType.transform) && (from === 0 || to === 0)) {
            if (from === 0) {
              value.set(toType.transform(from));
            } else {
              target[key] = fromType.transform(to);
            }
          } else {
            if (!hasAttemptedToRemoveTransformValues) {
              removedTransformValues = removeNonTranslationalTransform(visualElement2);
              hasAttemptedToRemoveTransformValues = true;
            }
            changedValueTypeKeys.push(key);
            transitionEnd[key] = transitionEnd[key] !== void 0 ? transitionEnd[key] : target[key];
            setAndResetVelocity(value, to);
          }
        }
      });
      if (changedValueTypeKeys.length) {
        var scrollY_1 = changedValueTypeKeys.indexOf("height") >= 0 ? window.pageYOffset : null;
        var convertedTarget = convertChangedValueTypes(target, visualElement2, changedValueTypeKeys);
        if (removedTransformValues.length) {
          removedTransformValues.forEach(function(_a) {
            var _b = tslib.__read(_a, 2), key = _b[0], value = _b[1];
            visualElement2.getValue(key).set(value);
          });
        }
        visualElement2.syncRender();
        if (scrollY_1 !== null)
          window.scrollTo({ top: scrollY_1 });
        return { target: convertedTarget, transitionEnd };
      } else {
        return { target, transitionEnd };
      }
    };
    function unitConversion(visualElement2, target, origin, transitionEnd) {
      return hasPositionalKey(target) ? checkAndConvertChangedValueTypes(visualElement2, target, origin, transitionEnd) : { target, transitionEnd };
    }
    var parseDomVariant = function(visualElement2, target, origin, transitionEnd) {
      var resolved = resolveCSSVariables(visualElement2, target, transitionEnd);
      target = resolved.target;
      transitionEnd = resolved.transitionEnd;
      return unitConversion(visualElement2, target, origin, transitionEnd);
    };
    function getComputedStyle$1(element) {
      return window.getComputedStyle(element);
    }
    var htmlConfig = {
      treeType: "dom",
      readValueFromInstance: function(domElement, key) {
        if (isTransformProp(key)) {
          var defaultType = getDefaultValueType(key);
          return defaultType ? defaultType.default || 0 : 0;
        } else {
          var computedStyle = getComputedStyle$1(domElement);
          return (isCSSVariable$1(key) ? computedStyle.getPropertyValue(key) : computedStyle[key]) || 0;
        }
      },
      sortNodePosition: function(a, b) {
        return a.compareDocumentPosition(b) & 2 ? 1 : -1;
      },
      getBaseTarget: function(props, key) {
        var _a;
        return (_a = props.style) === null || _a === void 0 ? void 0 : _a[key];
      },
      measureViewportBox: function(element, _a) {
        var transformPagePoint = _a.transformPagePoint;
        return measureViewportBox(element, transformPagePoint);
      },
      /**
       * Reset the transform on the current Element. This is called as part
       * of a batched process across the entire layout tree. To remove this write
       * cycle it'd be interesting to see if it's possible to "undo" all the current
       * layout transforms up the tree in the same way this.getBoundingBoxWithoutTransforms
       * works
       */
      resetTransform: function(element, domElement, props) {
        var transformTemplate = props.transformTemplate;
        domElement.style.transform = transformTemplate ? transformTemplate({}, "") : "none";
        element.scheduleRender();
      },
      restoreTransform: function(instance, mutableState) {
        instance.style.transform = mutableState.style.transform;
      },
      removeValueFromRenderState: function(key, _a) {
        var vars = _a.vars, style2 = _a.style;
        delete vars[key];
        delete style2[key];
      },
      /**
       * Ensure that HTML and Framer-specific value types like `px`->`%` and `Color`
       * can be animated by Motion.
       */
      makeTargetAnimatable: function(element, _a, _b, isMounted) {
        var transformValues = _b.transformValues;
        if (isMounted === void 0) {
          isMounted = true;
        }
        var transition = _a.transition, transitionEnd = _a.transitionEnd, target = tslib.__rest(_a, ["transition", "transitionEnd"]);
        var origin = getOrigin(target, transition || {}, element);
        if (transformValues) {
          if (transitionEnd)
            transitionEnd = transformValues(transitionEnd);
          if (target)
            target = transformValues(target);
          if (origin)
            origin = transformValues(origin);
        }
        if (isMounted) {
          checkTargetForNewValues(element, target, origin);
          var parsed = parseDomVariant(element, target, origin, transitionEnd);
          transitionEnd = parsed.transitionEnd;
          target = parsed.target;
        }
        return tslib.__assign({ transition, transitionEnd }, target);
      },
      scrapeMotionValuesFromProps: scrapeMotionValuesFromProps$1,
      build: function(element, renderState, latestValues, options, props) {
        if (element.isVisible !== void 0) {
          renderState.style.visibility = element.isVisible ? "visible" : "hidden";
        }
        buildHTMLStyles(renderState, latestValues, options, props.transformTemplate);
      },
      render: renderHTML
    };
    var htmlVisualElement = visualElement(htmlConfig);
    var svgVisualElement = visualElement(tslib.__assign(tslib.__assign({}, htmlConfig), { getBaseTarget: function(props, key) {
      return props[key];
    }, readValueFromInstance: function(domElement, key) {
      var _a;
      if (isTransformProp(key)) {
        return ((_a = getDefaultValueType(key)) === null || _a === void 0 ? void 0 : _a.default) || 0;
      }
      key = !camelCaseAttributes.has(key) ? camelToDash(key) : key;
      return domElement.getAttribute(key);
    }, scrapeMotionValuesFromProps, build: function(_element, renderState, latestValues, options, props) {
      buildSVGAttrs(renderState, latestValues, options, props.transformTemplate);
    }, render: renderSVG }));
    var createDomVisualElement = function(Component, options) {
      return isSVGComponent(Component) ? svgVisualElement(options, { enableHardwareAcceleration: false }) : htmlVisualElement(options, { enableHardwareAcceleration: true });
    };
    function pixelsToPercent(pixels, axis) {
      if (axis.max === axis.min)
        return 0;
      return pixels / (axis.max - axis.min) * 100;
    }
    var correctBorderRadius = {
      correct: function(latest, node) {
        if (!node.target)
          return latest;
        if (typeof latest === "string") {
          if (styleValueTypes.px.test(latest)) {
            latest = parseFloat(latest);
          } else {
            return latest;
          }
        }
        var x = pixelsToPercent(latest, node.target.x);
        var y = pixelsToPercent(latest, node.target.y);
        return "".concat(x, "% ").concat(y, "%");
      }
    };
    var varToken = "_$css";
    var correctBoxShadow = {
      correct: function(latest, _a) {
        var treeScale = _a.treeScale, projectionDelta = _a.projectionDelta;
        var original = latest;
        var containsCSSVariables = latest.includes("var(");
        var cssVariables = [];
        if (containsCSSVariables) {
          latest = latest.replace(cssVariableRegex, function(match) {
            cssVariables.push(match);
            return varToken;
          });
        }
        var shadow = styleValueTypes.complex.parse(latest);
        if (shadow.length > 5)
          return original;
        var template = styleValueTypes.complex.createTransformer(latest);
        var offset3 = typeof shadow[0] !== "number" ? 1 : 0;
        var xScale = projectionDelta.x.scale * treeScale.x;
        var yScale = projectionDelta.y.scale * treeScale.y;
        shadow[0 + offset3] /= xScale;
        shadow[1 + offset3] /= yScale;
        var averageScale = popmotion.mix(xScale, yScale, 0.5);
        if (typeof shadow[2 + offset3] === "number")
          shadow[2 + offset3] /= averageScale;
        if (typeof shadow[3 + offset3] === "number")
          shadow[3 + offset3] /= averageScale;
        var output = template(shadow);
        if (containsCSSVariables) {
          var i_1 = 0;
          output = output.replace(varToken, function() {
            var cssVariable = cssVariables[i_1];
            i_1++;
            return cssVariable;
          });
        }
        return output;
      }
    };
    var MeasureLayoutWithContext = (
      /** @class */
      function(_super) {
        tslib.__extends(MeasureLayoutWithContext2, _super);
        function MeasureLayoutWithContext2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        MeasureLayoutWithContext2.prototype.componentDidMount = function() {
          var _this = this;
          var _a = this.props, visualElement2 = _a.visualElement, layoutGroup = _a.layoutGroup, switchLayoutGroup = _a.switchLayoutGroup, layoutId = _a.layoutId;
          var projection = visualElement2.projection;
          addScaleCorrector(defaultScaleCorrectors);
          if (projection) {
            if (layoutGroup === null || layoutGroup === void 0 ? void 0 : layoutGroup.group)
              layoutGroup.group.add(projection);
            if ((switchLayoutGroup === null || switchLayoutGroup === void 0 ? void 0 : switchLayoutGroup.register) && layoutId) {
              switchLayoutGroup.register(projection);
            }
            projection.root.didUpdate();
            projection.addEventListener("animationComplete", function() {
              _this.safeToRemove();
            });
            projection.setOptions(tslib.__assign(tslib.__assign({}, projection.options), { onExitComplete: function() {
              return _this.safeToRemove();
            } }));
          }
          globalProjectionState.hasEverUpdated = true;
        };
        MeasureLayoutWithContext2.prototype.getSnapshotBeforeUpdate = function(prevProps) {
          var _this = this;
          var _a = this.props, layoutDependency = _a.layoutDependency, visualElement2 = _a.visualElement, drag2 = _a.drag, isPresent2 = _a.isPresent;
          var projection = visualElement2.projection;
          if (!projection)
            return null;
          projection.isPresent = isPresent2;
          if (drag2 || prevProps.layoutDependency !== layoutDependency || layoutDependency === void 0) {
            projection.willUpdate();
          } else {
            this.safeToRemove();
          }
          if (prevProps.isPresent !== isPresent2) {
            if (isPresent2) {
              projection.promote();
            } else if (!projection.relegate()) {
              sync__default["default"].postRender(function() {
                var _a2;
                if (!((_a2 = projection.getStack()) === null || _a2 === void 0 ? void 0 : _a2.members.length)) {
                  _this.safeToRemove();
                }
              });
            }
          }
          return null;
        };
        MeasureLayoutWithContext2.prototype.componentDidUpdate = function() {
          var projection = this.props.visualElement.projection;
          if (projection) {
            projection.root.didUpdate();
            if (!projection.currentAnimation && projection.isLead()) {
              this.safeToRemove();
            }
          }
        };
        MeasureLayoutWithContext2.prototype.componentWillUnmount = function() {
          var _a = this.props, visualElement2 = _a.visualElement, layoutGroup = _a.layoutGroup, promoteContext = _a.switchLayoutGroup;
          var projection = visualElement2.projection;
          if (projection) {
            projection.scheduleCheckAfterUnmount();
            if (layoutGroup === null || layoutGroup === void 0 ? void 0 : layoutGroup.group)
              layoutGroup.group.remove(projection);
            if (promoteContext === null || promoteContext === void 0 ? void 0 : promoteContext.deregister)
              promoteContext.deregister(projection);
          }
        };
        MeasureLayoutWithContext2.prototype.safeToRemove = function() {
          var safeToRemove = this.props.safeToRemove;
          safeToRemove === null || safeToRemove === void 0 ? void 0 : safeToRemove();
        };
        MeasureLayoutWithContext2.prototype.render = function() {
          return null;
        };
        return MeasureLayoutWithContext2;
      }(React__default["default"].Component)
    );
    function MeasureLayout(props) {
      var _a = tslib.__read(usePresence(), 2), isPresent2 = _a[0], safeToRemove = _a[1];
      var layoutGroup = React3.useContext(LayoutGroupContext);
      return React__default["default"].createElement(MeasureLayoutWithContext, tslib.__assign({}, props, { layoutGroup, switchLayoutGroup: React3.useContext(SwitchLayoutGroupContext), isPresent: isPresent2, safeToRemove }));
    }
    var defaultScaleCorrectors = {
      borderRadius: tslib.__assign(tslib.__assign({}, correctBorderRadius), { applyTo: [
        "borderTopLeftRadius",
        "borderTopRightRadius",
        "borderBottomLeftRadius",
        "borderBottomRightRadius"
      ] }),
      borderTopLeftRadius: correctBorderRadius,
      borderTopRightRadius: correctBorderRadius,
      borderBottomLeftRadius: correctBorderRadius,
      borderBottomRightRadius: correctBorderRadius,
      boxShadow: correctBoxShadow
    };
    var layoutFeatures = {
      measureLayout: MeasureLayout
    };
    function animate2(from, to, transition) {
      if (transition === void 0) {
        transition = {};
      }
      var value = isMotionValue(from) ? from : motionValue(from);
      startAnimation("", value, to, transition);
      return {
        stop: function() {
          return value.stop();
        },
        isAnimating: function() {
          return value.isAnimating();
        }
      };
    }
    var borders = ["TopLeft", "TopRight", "BottomLeft", "BottomRight"];
    var numBorders = borders.length;
    var asNumber = function(value) {
      return typeof value === "string" ? parseFloat(value) : value;
    };
    var isPx = function(value) {
      return typeof value === "number" || styleValueTypes.px.test(value);
    };
    function mixValues(target, follow, lead, progress2, shouldCrossfadeOpacity, isOnlyMember) {
      var _a, _b, _c, _d;
      if (shouldCrossfadeOpacity) {
        target.opacity = popmotion.mix(
          0,
          // (follow?.opacity as number) ?? 0,
          // TODO Reinstate this if only child
          (_a = lead.opacity) !== null && _a !== void 0 ? _a : 1,
          easeCrossfadeIn(progress2)
        );
        target.opacityExit = popmotion.mix((_b = follow.opacity) !== null && _b !== void 0 ? _b : 1, 0, easeCrossfadeOut(progress2));
      } else if (isOnlyMember) {
        target.opacity = popmotion.mix((_c = follow.opacity) !== null && _c !== void 0 ? _c : 1, (_d = lead.opacity) !== null && _d !== void 0 ? _d : 1, progress2);
      }
      for (var i = 0; i < numBorders; i++) {
        var borderLabel = "border".concat(borders[i], "Radius");
        var followRadius = getRadius(follow, borderLabel);
        var leadRadius = getRadius(lead, borderLabel);
        if (followRadius === void 0 && leadRadius === void 0)
          continue;
        followRadius || (followRadius = 0);
        leadRadius || (leadRadius = 0);
        var canMix = followRadius === 0 || leadRadius === 0 || isPx(followRadius) === isPx(leadRadius);
        if (canMix) {
          target[borderLabel] = Math.max(popmotion.mix(asNumber(followRadius), asNumber(leadRadius), progress2), 0);
          if (styleValueTypes.percent.test(leadRadius) || styleValueTypes.percent.test(followRadius)) {
            target[borderLabel] += "%";
          }
        } else {
          target[borderLabel] = leadRadius;
        }
      }
      if (follow.rotate || lead.rotate) {
        target.rotate = popmotion.mix(follow.rotate || 0, lead.rotate || 0, progress2);
      }
    }
    function getRadius(values, radiusName) {
      var _a;
      return (_a = values[radiusName]) !== null && _a !== void 0 ? _a : values.borderRadius;
    }
    var easeCrossfadeIn = compress(0, 0.5, popmotion.circOut);
    var easeCrossfadeOut = compress(0.5, 0.95, popmotion.linear);
    function compress(min2, max2, easing) {
      return function(p) {
        if (p < min2)
          return 0;
        if (p > max2)
          return 1;
        return easing(popmotion.progress(min2, max2, p));
      };
    }
    function copyAxisInto(axis, originAxis) {
      axis.min = originAxis.min;
      axis.max = originAxis.max;
    }
    function copyBoxInto(box, originBox) {
      copyAxisInto(box.x, originBox.x);
      copyAxisInto(box.y, originBox.y);
    }
    function removePointDelta(point2, translate, scale, originPoint, boxScale) {
      point2 -= translate;
      point2 = scalePoint(point2, 1 / scale, originPoint);
      if (boxScale !== void 0) {
        point2 = scalePoint(point2, 1 / boxScale, originPoint);
      }
      return point2;
    }
    function removeAxisDelta(axis, translate, scale, origin, boxScale, originAxis, sourceAxis) {
      if (translate === void 0) {
        translate = 0;
      }
      if (scale === void 0) {
        scale = 1;
      }
      if (origin === void 0) {
        origin = 0.5;
      }
      if (originAxis === void 0) {
        originAxis = axis;
      }
      if (sourceAxis === void 0) {
        sourceAxis = axis;
      }
      if (styleValueTypes.percent.test(translate)) {
        translate = parseFloat(translate);
        var relativeProgress = popmotion.mix(sourceAxis.min, sourceAxis.max, translate / 100);
        translate = relativeProgress - sourceAxis.min;
      }
      if (typeof translate !== "number")
        return;
      var originPoint = popmotion.mix(originAxis.min, originAxis.max, origin);
      if (axis === originAxis)
        originPoint -= translate;
      axis.min = removePointDelta(axis.min, translate, scale, originPoint, boxScale);
      axis.max = removePointDelta(axis.max, translate, scale, originPoint, boxScale);
    }
    function removeAxisTransforms(axis, transforms2, _a, origin, sourceAxis) {
      var _b = tslib.__read(_a, 3), key = _b[0], scaleKey = _b[1], originKey = _b[2];
      removeAxisDelta(axis, transforms2[key], transforms2[scaleKey], transforms2[originKey], transforms2.scale, origin, sourceAxis);
    }
    var xKeys = ["x", "scaleX", "originX"];
    var yKeys = ["y", "scaleY", "originY"];
    function removeBoxTransforms(box, transforms2, originBox, sourceBox) {
      removeAxisTransforms(box.x, transforms2, xKeys, originBox === null || originBox === void 0 ? void 0 : originBox.x, sourceBox === null || sourceBox === void 0 ? void 0 : sourceBox.x);
      removeAxisTransforms(box.y, transforms2, yKeys, originBox === null || originBox === void 0 ? void 0 : originBox.y, sourceBox === null || sourceBox === void 0 ? void 0 : sourceBox.y);
    }
    function isAxisDeltaZero(delta) {
      return delta.translate === 0 && delta.scale === 1;
    }
    function isDeltaZero(delta) {
      return isAxisDeltaZero(delta.x) && isAxisDeltaZero(delta.y);
    }
    function boxEquals(a, b) {
      return a.x.min === b.x.min && a.x.max === b.x.max && a.y.min === b.y.min && a.y.max === b.y.max;
    }
    var NodeStack = (
      /** @class */
      function() {
        function NodeStack2() {
          this.members = [];
        }
        NodeStack2.prototype.add = function(node) {
          addUniqueItem2(this.members, node);
          node.scheduleRender();
        };
        NodeStack2.prototype.remove = function(node) {
          removeItem2(this.members, node);
          if (node === this.prevLead) {
            this.prevLead = void 0;
          }
          if (node === this.lead) {
            var prevLead = this.members[this.members.length - 1];
            if (prevLead) {
              this.promote(prevLead);
            }
          }
        };
        NodeStack2.prototype.relegate = function(node) {
          var indexOfNode = this.members.findIndex(function(member2) {
            return node === member2;
          });
          if (indexOfNode === 0)
            return false;
          var prevLead;
          for (var i = indexOfNode; i >= 0; i--) {
            var member = this.members[i];
            if (member.isPresent !== false) {
              prevLead = member;
              break;
            }
          }
          if (prevLead) {
            this.promote(prevLead);
            return true;
          } else {
            return false;
          }
        };
        NodeStack2.prototype.promote = function(node, preserveFollowOpacity) {
          var _a;
          var prevLead = this.lead;
          if (node === prevLead)
            return;
          this.prevLead = prevLead;
          this.lead = node;
          node.show();
          if (prevLead) {
            prevLead.instance && prevLead.scheduleRender();
            node.scheduleRender();
            node.resumeFrom = prevLead;
            if (preserveFollowOpacity) {
              node.resumeFrom.preserveOpacity = true;
            }
            if (prevLead.snapshot) {
              node.snapshot = prevLead.snapshot;
              node.snapshot.latestValues = prevLead.animationValues || prevLead.latestValues;
              node.snapshot.isShared = true;
            }
            if ((_a = node.root) === null || _a === void 0 ? void 0 : _a.isUpdating) {
              node.isLayoutDirty = true;
            }
            var crossfade = node.options.crossfade;
            if (crossfade === false) {
              prevLead.hide();
            }
          }
        };
        NodeStack2.prototype.exitAnimationComplete = function() {
          this.members.forEach(function(node) {
            var _a, _b, _c, _d, _e;
            (_b = (_a = node.options).onExitComplete) === null || _b === void 0 ? void 0 : _b.call(_a);
            (_e = (_c = node.resumingFrom) === null || _c === void 0 ? void 0 : (_d = _c.options).onExitComplete) === null || _e === void 0 ? void 0 : _e.call(_d);
          });
        };
        NodeStack2.prototype.scheduleRender = function() {
          this.members.forEach(function(node) {
            node.instance && node.scheduleRender(false);
          });
        };
        NodeStack2.prototype.removeLeadSnapshot = function() {
          if (this.lead && this.lead.snapshot) {
            this.lead.snapshot = void 0;
          }
        };
        return NodeStack2;
      }()
    );
    var identityProjection = "translate3d(0px, 0px, 0) scale(1, 1) scale(1, 1)";
    function buildProjectionTransform(delta, treeScale, latestTransform) {
      var xTranslate = delta.x.translate / treeScale.x;
      var yTranslate = delta.y.translate / treeScale.y;
      var transform2 = "translate3d(".concat(xTranslate, "px, ").concat(yTranslate, "px, 0) ");
      transform2 += "scale(".concat(1 / treeScale.x, ", ").concat(1 / treeScale.y, ") ");
      if (latestTransform) {
        var rotate = latestTransform.rotate, rotateX = latestTransform.rotateX, rotateY = latestTransform.rotateY;
        if (rotate)
          transform2 += "rotate(".concat(rotate, "deg) ");
        if (rotateX)
          transform2 += "rotateX(".concat(rotateX, "deg) ");
        if (rotateY)
          transform2 += "rotateY(".concat(rotateY, "deg) ");
      }
      var elementScaleX = delta.x.scale * treeScale.x;
      var elementScaleY = delta.y.scale * treeScale.y;
      transform2 += "scale(".concat(elementScaleX, ", ").concat(elementScaleY, ")");
      return transform2 === identityProjection ? "none" : transform2;
    }
    var compareByDepth2 = function(a, b) {
      return a.depth - b.depth;
    };
    var FlatTree = (
      /** @class */
      function() {
        function FlatTree2() {
          this.children = [];
          this.isDirty = false;
        }
        FlatTree2.prototype.add = function(child) {
          addUniqueItem2(this.children, child);
          this.isDirty = true;
        };
        FlatTree2.prototype.remove = function(child) {
          removeItem2(this.children, child);
          this.isDirty = true;
        };
        FlatTree2.prototype.forEach = function(callback) {
          this.isDirty && this.children.sort(compareByDepth2);
          this.isDirty = false;
          this.children.forEach(callback);
        };
        return FlatTree2;
      }()
    );
    var animationTarget = 1e3;
    function createProjectionNode(_a) {
      var attachResizeListener = _a.attachResizeListener, defaultParent = _a.defaultParent, measureScroll = _a.measureScroll, checkIsScrollRoot = _a.checkIsScrollRoot, resetTransform = _a.resetTransform;
      return (
        /** @class */
        function() {
          function ProjectionNode(id2, latestValues, parent) {
            var _this = this;
            if (latestValues === void 0) {
              latestValues = {};
            }
            if (parent === void 0) {
              parent = defaultParent === null || defaultParent === void 0 ? void 0 : defaultParent();
            }
            this.children = /* @__PURE__ */ new Set();
            this.options = {};
            this.isTreeAnimating = false;
            this.isAnimationBlocked = false;
            this.isLayoutDirty = false;
            this.updateManuallyBlocked = false;
            this.updateBlockedByResize = false;
            this.isUpdating = false;
            this.isSVG = false;
            this.needsReset = false;
            this.shouldResetTransform = false;
            this.treeScale = { x: 1, y: 1 };
            this.eventHandlers = /* @__PURE__ */ new Map();
            this.potentialNodes = /* @__PURE__ */ new Map();
            this.checkUpdateFailed = function() {
              if (_this.isUpdating) {
                _this.isUpdating = false;
                _this.clearAllSnapshots();
              }
            };
            this.updateProjection = function() {
              _this.nodes.forEach(resolveTargetDelta);
              _this.nodes.forEach(calcProjection);
            };
            this.hasProjected = false;
            this.isVisible = true;
            this.animationProgress = 0;
            this.sharedNodes = /* @__PURE__ */ new Map();
            this.id = id2;
            this.latestValues = latestValues;
            this.root = parent ? parent.root || parent : this;
            this.path = parent ? tslib.__spreadArray(tslib.__spreadArray([], tslib.__read(parent.path), false), [parent], false) : [];
            this.parent = parent;
            this.depth = parent ? parent.depth + 1 : 0;
            id2 && this.root.registerPotentialNode(id2, this);
            for (var i = 0; i < this.path.length; i++) {
              this.path[i].shouldResetTransform = true;
            }
            if (this.root === this)
              this.nodes = new FlatTree();
          }
          ProjectionNode.prototype.addEventListener = function(name, handler) {
            if (!this.eventHandlers.has(name)) {
              this.eventHandlers.set(name, new SubscriptionManager());
            }
            return this.eventHandlers.get(name).add(handler);
          };
          ProjectionNode.prototype.notifyListeners = function(name) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
              args[_i - 1] = arguments[_i];
            }
            var subscriptionManager = this.eventHandlers.get(name);
            subscriptionManager === null || subscriptionManager === void 0 ? void 0 : subscriptionManager.notify.apply(subscriptionManager, tslib.__spreadArray([], tslib.__read(args), false));
          };
          ProjectionNode.prototype.hasListeners = function(name) {
            return this.eventHandlers.has(name);
          };
          ProjectionNode.prototype.registerPotentialNode = function(id2, node) {
            this.potentialNodes.set(id2, node);
          };
          ProjectionNode.prototype.mount = function(instance, isLayoutDirty) {
            var _this = this;
            var _a2;
            if (isLayoutDirty === void 0) {
              isLayoutDirty = false;
            }
            if (this.instance)
              return;
            this.isSVG = instance instanceof SVGElement && instance.tagName !== "svg";
            this.instance = instance;
            var _b = this.options, layoutId = _b.layoutId, layout = _b.layout, visualElement2 = _b.visualElement;
            if (visualElement2 && !visualElement2.getInstance()) {
              visualElement2.mount(instance);
            }
            this.root.nodes.add(this);
            (_a2 = this.parent) === null || _a2 === void 0 ? void 0 : _a2.children.add(this);
            this.id && this.root.potentialNodes.delete(this.id);
            if (isLayoutDirty && (layout || layoutId)) {
              this.isLayoutDirty = true;
            }
            if (attachResizeListener) {
              var unblockTimeout_1;
              var resizeUnblockUpdate_1 = function() {
                return _this.root.updateBlockedByResize = false;
              };
              attachResizeListener(instance, function() {
                _this.root.updateBlockedByResize = true;
                clearTimeout(unblockTimeout_1);
                unblockTimeout_1 = window.setTimeout(resizeUnblockUpdate_1, 250);
                if (globalProjectionState.hasAnimatedSinceResize) {
                  globalProjectionState.hasAnimatedSinceResize = false;
                  _this.nodes.forEach(finishAnimation);
                }
              });
            }
            if (layoutId) {
              this.root.registerSharedNode(layoutId, this);
            }
            if (this.options.animate !== false && visualElement2 && (layoutId || layout)) {
              this.addEventListener("didUpdate", function(_a3) {
                var _b2, _c, _d, _e, _f;
                var delta = _a3.delta, hasLayoutChanged = _a3.hasLayoutChanged, hasRelativeTargetChanged = _a3.hasRelativeTargetChanged, newLayout = _a3.layout;
                if (_this.isTreeAnimationBlocked()) {
                  _this.target = void 0;
                  _this.relativeTarget = void 0;
                  return;
                }
                var layoutTransition = (_c = (_b2 = _this.options.transition) !== null && _b2 !== void 0 ? _b2 : visualElement2.getDefaultTransition()) !== null && _c !== void 0 ? _c : defaultLayoutTransition;
                var _g = visualElement2.getProps(), onLayoutAnimationStart = _g.onLayoutAnimationStart, onLayoutAnimationComplete = _g.onLayoutAnimationComplete;
                var targetChanged = !_this.targetLayout || !boxEquals(_this.targetLayout, newLayout) || hasRelativeTargetChanged;
                var hasOnlyRelativeTargetChanged = !hasLayoutChanged && hasRelativeTargetChanged;
                if (((_d = _this.resumeFrom) === null || _d === void 0 ? void 0 : _d.instance) || hasOnlyRelativeTargetChanged || hasLayoutChanged && (targetChanged || !_this.currentAnimation)) {
                  if (_this.resumeFrom) {
                    _this.resumingFrom = _this.resumeFrom;
                    _this.resumingFrom.resumingFrom = void 0;
                  }
                  _this.setAnimationOrigin(delta, hasOnlyRelativeTargetChanged);
                  var animationOptions = tslib.__assign(tslib.__assign({}, getValueTransition(layoutTransition, "layout")), { onPlay: onLayoutAnimationStart, onComplete: onLayoutAnimationComplete });
                  if (visualElement2.shouldReduceMotion) {
                    animationOptions.delay = 0;
                    animationOptions.type = false;
                  }
                  _this.startAnimation(animationOptions);
                } else {
                  if (!hasLayoutChanged && _this.animationProgress === 0) {
                    _this.finishAnimation();
                  }
                  _this.isLead() && ((_f = (_e = _this.options).onExitComplete) === null || _f === void 0 ? void 0 : _f.call(_e));
                }
                _this.targetLayout = newLayout;
              });
            }
          };
          ProjectionNode.prototype.unmount = function() {
            var _a2, _b;
            this.options.layoutId && this.willUpdate();
            this.root.nodes.remove(this);
            (_a2 = this.getStack()) === null || _a2 === void 0 ? void 0 : _a2.remove(this);
            (_b = this.parent) === null || _b === void 0 ? void 0 : _b.children.delete(this);
            this.instance = void 0;
            sync.cancelSync.preRender(this.updateProjection);
          };
          ProjectionNode.prototype.blockUpdate = function() {
            this.updateManuallyBlocked = true;
          };
          ProjectionNode.prototype.unblockUpdate = function() {
            this.updateManuallyBlocked = false;
          };
          ProjectionNode.prototype.isUpdateBlocked = function() {
            return this.updateManuallyBlocked || this.updateBlockedByResize;
          };
          ProjectionNode.prototype.isTreeAnimationBlocked = function() {
            var _a2;
            return this.isAnimationBlocked || ((_a2 = this.parent) === null || _a2 === void 0 ? void 0 : _a2.isTreeAnimationBlocked()) || false;
          };
          ProjectionNode.prototype.startUpdate = function() {
            var _a2;
            if (this.isUpdateBlocked())
              return;
            this.isUpdating = true;
            (_a2 = this.nodes) === null || _a2 === void 0 ? void 0 : _a2.forEach(resetRotation);
          };
          ProjectionNode.prototype.willUpdate = function(shouldNotifyListeners) {
            var _a2, _b, _c;
            if (shouldNotifyListeners === void 0) {
              shouldNotifyListeners = true;
            }
            if (this.root.isUpdateBlocked()) {
              (_b = (_a2 = this.options).onExitComplete) === null || _b === void 0 ? void 0 : _b.call(_a2);
              return;
            }
            !this.root.isUpdating && this.root.startUpdate();
            if (this.isLayoutDirty)
              return;
            this.isLayoutDirty = true;
            for (var i = 0; i < this.path.length; i++) {
              var node = this.path[i];
              node.shouldResetTransform = true;
              node.updateScroll();
            }
            var _d = this.options, layoutId = _d.layoutId, layout = _d.layout;
            if (layoutId === void 0 && !layout)
              return;
            var transformTemplate = (_c = this.options.visualElement) === null || _c === void 0 ? void 0 : _c.getProps().transformTemplate;
            this.prevTransformTemplateValue = transformTemplate === null || transformTemplate === void 0 ? void 0 : transformTemplate(this.latestValues, "");
            this.updateSnapshot();
            shouldNotifyListeners && this.notifyListeners("willUpdate");
          };
          ProjectionNode.prototype.didUpdate = function() {
            var updateWasBlocked = this.isUpdateBlocked();
            if (updateWasBlocked) {
              this.unblockUpdate();
              this.clearAllSnapshots();
              this.nodes.forEach(clearMeasurements);
              return;
            }
            if (!this.isUpdating)
              return;
            this.isUpdating = false;
            if (this.potentialNodes.size) {
              this.potentialNodes.forEach(mountNodeEarly);
              this.potentialNodes.clear();
            }
            this.nodes.forEach(resetTransformStyle);
            this.nodes.forEach(updateLayout);
            this.nodes.forEach(notifyLayoutUpdate);
            this.clearAllSnapshots();
            sync.flushSync.update();
            sync.flushSync.preRender();
            sync.flushSync.render();
          };
          ProjectionNode.prototype.clearAllSnapshots = function() {
            this.nodes.forEach(clearSnapshot);
            this.sharedNodes.forEach(removeLeadSnapshots);
          };
          ProjectionNode.prototype.scheduleUpdateProjection = function() {
            sync__default["default"].preRender(this.updateProjection, false, true);
          };
          ProjectionNode.prototype.scheduleCheckAfterUnmount = function() {
            var _this = this;
            sync__default["default"].postRender(function() {
              if (_this.isLayoutDirty) {
                _this.root.didUpdate();
              } else {
                _this.root.checkUpdateFailed();
              }
            });
          };
          ProjectionNode.prototype.updateSnapshot = function() {
            if (this.snapshot || !this.instance)
              return;
            var measured = this.measure();
            var layout = this.removeTransform(this.removeElementScroll(measured));
            roundBox(layout);
            this.snapshot = {
              measured,
              layout,
              latestValues: {}
            };
          };
          ProjectionNode.prototype.updateLayout = function() {
            var _a2;
            if (!this.instance)
              return;
            this.updateScroll();
            if (!(this.options.alwaysMeasureLayout && this.isLead()) && !this.isLayoutDirty) {
              return;
            }
            if (this.resumeFrom && !this.resumeFrom.instance) {
              for (var i = 0; i < this.path.length; i++) {
                var node = this.path[i];
                node.updateScroll();
              }
            }
            var measured = this.measure();
            roundBox(measured);
            var prevLayout = this.layout;
            this.layout = {
              measured,
              actual: this.removeElementScroll(measured)
            };
            this.layoutCorrected = createBox();
            this.isLayoutDirty = false;
            this.projectionDelta = void 0;
            this.notifyListeners("measure", this.layout.actual);
            (_a2 = this.options.visualElement) === null || _a2 === void 0 ? void 0 : _a2.notifyLayoutMeasure(this.layout.actual, prevLayout === null || prevLayout === void 0 ? void 0 : prevLayout.actual);
          };
          ProjectionNode.prototype.updateScroll = function() {
            if (this.options.layoutScroll && this.instance) {
              this.isScrollRoot = checkIsScrollRoot(this.instance);
              this.scroll = measureScroll(this.instance);
            }
          };
          ProjectionNode.prototype.resetTransform = function() {
            var _a2;
            if (!resetTransform)
              return;
            var isResetRequested = this.isLayoutDirty || this.shouldResetTransform;
            var hasProjection = this.projectionDelta && !isDeltaZero(this.projectionDelta);
            var transformTemplate = (_a2 = this.options.visualElement) === null || _a2 === void 0 ? void 0 : _a2.getProps().transformTemplate;
            var transformTemplateValue = transformTemplate === null || transformTemplate === void 0 ? void 0 : transformTemplate(this.latestValues, "");
            var transformTemplateHasChanged = transformTemplateValue !== this.prevTransformTemplateValue;
            if (isResetRequested && (hasProjection || hasTransform(this.latestValues) || transformTemplateHasChanged)) {
              resetTransform(this.instance, transformTemplateValue);
              this.shouldResetTransform = false;
              this.scheduleRender();
            }
          };
          ProjectionNode.prototype.measure = function() {
            var visualElement2 = this.options.visualElement;
            if (!visualElement2)
              return createBox();
            var box = visualElement2.measureViewportBox();
            var scroll2 = this.root.scroll;
            if (scroll2) {
              translateAxis(box.x, scroll2.x);
              translateAxis(box.y, scroll2.y);
            }
            return box;
          };
          ProjectionNode.prototype.removeElementScroll = function(box) {
            var boxWithoutScroll = createBox();
            copyBoxInto(boxWithoutScroll, box);
            for (var i = 0; i < this.path.length; i++) {
              var node = this.path[i];
              var scroll_1 = node.scroll, options = node.options, isScrollRoot = node.isScrollRoot;
              if (node !== this.root && scroll_1 && options.layoutScroll) {
                if (isScrollRoot) {
                  copyBoxInto(boxWithoutScroll, box);
                  var rootScroll = this.root.scroll;
                  if (rootScroll) {
                    translateAxis(boxWithoutScroll.x, -rootScroll.x);
                    translateAxis(boxWithoutScroll.y, -rootScroll.y);
                  }
                }
                translateAxis(boxWithoutScroll.x, scroll_1.x);
                translateAxis(boxWithoutScroll.y, scroll_1.y);
              }
            }
            return boxWithoutScroll;
          };
          ProjectionNode.prototype.applyTransform = function(box, transformOnly) {
            if (transformOnly === void 0) {
              transformOnly = false;
            }
            var withTransforms = createBox();
            copyBoxInto(withTransforms, box);
            for (var i = 0; i < this.path.length; i++) {
              var node = this.path[i];
              if (!transformOnly && node.options.layoutScroll && node.scroll && node !== node.root) {
                transformBox(withTransforms, {
                  x: -node.scroll.x,
                  y: -node.scroll.y
                });
              }
              if (!hasTransform(node.latestValues))
                continue;
              transformBox(withTransforms, node.latestValues);
            }
            if (hasTransform(this.latestValues)) {
              transformBox(withTransforms, this.latestValues);
            }
            return withTransforms;
          };
          ProjectionNode.prototype.removeTransform = function(box) {
            var _a2;
            var boxWithoutTransform = createBox();
            copyBoxInto(boxWithoutTransform, box);
            for (var i = 0; i < this.path.length; i++) {
              var node = this.path[i];
              if (!node.instance)
                continue;
              if (!hasTransform(node.latestValues))
                continue;
              hasScale(node.latestValues) && node.updateSnapshot();
              var sourceBox = createBox();
              var nodeBox = node.measure();
              copyBoxInto(sourceBox, nodeBox);
              removeBoxTransforms(boxWithoutTransform, node.latestValues, (_a2 = node.snapshot) === null || _a2 === void 0 ? void 0 : _a2.layout, sourceBox);
            }
            if (hasTransform(this.latestValues)) {
              removeBoxTransforms(boxWithoutTransform, this.latestValues);
            }
            return boxWithoutTransform;
          };
          ProjectionNode.prototype.setTargetDelta = function(delta) {
            this.targetDelta = delta;
            this.root.scheduleUpdateProjection();
          };
          ProjectionNode.prototype.setOptions = function(options) {
            var _a2;
            this.options = tslib.__assign(tslib.__assign(tslib.__assign({}, this.options), options), { crossfade: (_a2 = options.crossfade) !== null && _a2 !== void 0 ? _a2 : true });
          };
          ProjectionNode.prototype.clearMeasurements = function() {
            this.scroll = void 0;
            this.layout = void 0;
            this.snapshot = void 0;
            this.prevTransformTemplateValue = void 0;
            this.targetDelta = void 0;
            this.target = void 0;
            this.isLayoutDirty = false;
          };
          ProjectionNode.prototype.resolveTargetDelta = function() {
            var _a2;
            var _b = this.options, layout = _b.layout, layoutId = _b.layoutId;
            if (!this.layout || !(layout || layoutId))
              return;
            if (!this.targetDelta && !this.relativeTarget) {
              this.relativeParent = this.getClosestProjectingParent();
              if (this.relativeParent && this.relativeParent.layout) {
                this.relativeTarget = createBox();
                this.relativeTargetOrigin = createBox();
                calcRelativePosition(this.relativeTargetOrigin, this.layout.actual, this.relativeParent.layout.actual);
                copyBoxInto(this.relativeTarget, this.relativeTargetOrigin);
              }
            }
            if (!this.relativeTarget && !this.targetDelta)
              return;
            if (!this.target) {
              this.target = createBox();
              this.targetWithTransforms = createBox();
            }
            if (this.relativeTarget && this.relativeTargetOrigin && ((_a2 = this.relativeParent) === null || _a2 === void 0 ? void 0 : _a2.target)) {
              calcRelativeBox(this.target, this.relativeTarget, this.relativeParent.target);
            } else if (this.targetDelta) {
              if (Boolean(this.resumingFrom)) {
                this.target = this.applyTransform(this.layout.actual);
              } else {
                copyBoxInto(this.target, this.layout.actual);
              }
              applyBoxDelta(this.target, this.targetDelta);
            } else {
              copyBoxInto(this.target, this.layout.actual);
            }
            if (this.attemptToResolveRelativeTarget) {
              this.attemptToResolveRelativeTarget = false;
              this.relativeParent = this.getClosestProjectingParent();
              if (this.relativeParent && Boolean(this.relativeParent.resumingFrom) === Boolean(this.resumingFrom) && !this.relativeParent.options.layoutScroll && this.relativeParent.target) {
                this.relativeTarget = createBox();
                this.relativeTargetOrigin = createBox();
                calcRelativePosition(this.relativeTargetOrigin, this.target, this.relativeParent.target);
                copyBoxInto(this.relativeTarget, this.relativeTargetOrigin);
              }
            }
          };
          ProjectionNode.prototype.getClosestProjectingParent = function() {
            if (!this.parent || hasTransform(this.parent.latestValues))
              return void 0;
            if ((this.parent.relativeTarget || this.parent.targetDelta) && this.parent.layout) {
              return this.parent;
            } else {
              return this.parent.getClosestProjectingParent();
            }
          };
          ProjectionNode.prototype.calcProjection = function() {
            var _a2;
            var _b = this.options, layout = _b.layout, layoutId = _b.layoutId;
            this.isTreeAnimating = Boolean(((_a2 = this.parent) === null || _a2 === void 0 ? void 0 : _a2.isTreeAnimating) || this.currentAnimation || this.pendingAnimation);
            if (!this.isTreeAnimating) {
              this.targetDelta = this.relativeTarget = void 0;
            }
            if (!this.layout || !(layout || layoutId))
              return;
            var lead = this.getLead();
            copyBoxInto(this.layoutCorrected, this.layout.actual);
            applyTreeDeltas(this.layoutCorrected, this.treeScale, this.path, Boolean(this.resumingFrom) || this !== lead);
            var target = lead.target;
            if (!target)
              return;
            if (!this.projectionDelta) {
              this.projectionDelta = createDelta();
              this.projectionDeltaWithTransform = createDelta();
            }
            var prevTreeScaleX = this.treeScale.x;
            var prevTreeScaleY = this.treeScale.y;
            var prevProjectionTransform = this.projectionTransform;
            calcBoxDelta(this.projectionDelta, this.layoutCorrected, target, this.latestValues);
            this.projectionTransform = buildProjectionTransform(this.projectionDelta, this.treeScale);
            if (this.projectionTransform !== prevProjectionTransform || this.treeScale.x !== prevTreeScaleX || this.treeScale.y !== prevTreeScaleY) {
              this.hasProjected = true;
              this.scheduleRender();
              this.notifyListeners("projectionUpdate", target);
            }
          };
          ProjectionNode.prototype.hide = function() {
            this.isVisible = false;
          };
          ProjectionNode.prototype.show = function() {
            this.isVisible = true;
          };
          ProjectionNode.prototype.scheduleRender = function(notifyAll2) {
            var _a2, _b, _c;
            if (notifyAll2 === void 0) {
              notifyAll2 = true;
            }
            (_b = (_a2 = this.options).scheduleRender) === null || _b === void 0 ? void 0 : _b.call(_a2);
            notifyAll2 && ((_c = this.getStack()) === null || _c === void 0 ? void 0 : _c.scheduleRender());
            if (this.resumingFrom && !this.resumingFrom.instance) {
              this.resumingFrom = void 0;
            }
          };
          ProjectionNode.prototype.setAnimationOrigin = function(delta, hasOnlyRelativeTargetChanged) {
            var _this = this;
            var _a2;
            if (hasOnlyRelativeTargetChanged === void 0) {
              hasOnlyRelativeTargetChanged = false;
            }
            var snapshot = this.snapshot;
            var snapshotLatestValues = (snapshot === null || snapshot === void 0 ? void 0 : snapshot.latestValues) || {};
            var mixedValues = tslib.__assign({}, this.latestValues);
            var targetDelta = createDelta();
            this.relativeTarget = this.relativeTargetOrigin = void 0;
            this.attemptToResolveRelativeTarget = !hasOnlyRelativeTargetChanged;
            var relativeLayout = createBox();
            var isSharedLayoutAnimation = snapshot === null || snapshot === void 0 ? void 0 : snapshot.isShared;
            var isOnlyMember = (((_a2 = this.getStack()) === null || _a2 === void 0 ? void 0 : _a2.members.length) || 0) <= 1;
            var shouldCrossfadeOpacity = Boolean(isSharedLayoutAnimation && !isOnlyMember && this.options.crossfade === true && !this.path.some(hasOpacityCrossfade));
            this.animationProgress = 0;
            this.mixTargetDelta = function(latest) {
              var _a3;
              var progress2 = latest / 1e3;
              mixAxisDelta(targetDelta.x, delta.x, progress2);
              mixAxisDelta(targetDelta.y, delta.y, progress2);
              _this.setTargetDelta(targetDelta);
              if (_this.relativeTarget && _this.relativeTargetOrigin && _this.layout && ((_a3 = _this.relativeParent) === null || _a3 === void 0 ? void 0 : _a3.layout)) {
                calcRelativePosition(relativeLayout, _this.layout.actual, _this.relativeParent.layout.actual);
                mixBox(_this.relativeTarget, _this.relativeTargetOrigin, relativeLayout, progress2);
              }
              if (isSharedLayoutAnimation) {
                _this.animationValues = mixedValues;
                mixValues(mixedValues, snapshotLatestValues, _this.latestValues, progress2, shouldCrossfadeOpacity, isOnlyMember);
              }
              _this.root.scheduleUpdateProjection();
              _this.scheduleRender();
              _this.animationProgress = progress2;
            };
            this.mixTargetDelta(0);
          };
          ProjectionNode.prototype.startAnimation = function(options) {
            var _this = this;
            var _a2, _b;
            this.notifyListeners("animationStart");
            (_a2 = this.currentAnimation) === null || _a2 === void 0 ? void 0 : _a2.stop();
            if (this.resumingFrom) {
              (_b = this.resumingFrom.currentAnimation) === null || _b === void 0 ? void 0 : _b.stop();
            }
            if (this.pendingAnimation) {
              sync.cancelSync.update(this.pendingAnimation);
              this.pendingAnimation = void 0;
            }
            this.pendingAnimation = sync__default["default"].update(function() {
              globalProjectionState.hasAnimatedSinceResize = true;
              _this.currentAnimation = animate2(0, animationTarget, tslib.__assign(tslib.__assign({}, options), { onUpdate: function(latest) {
                var _a3;
                _this.mixTargetDelta(latest);
                (_a3 = options.onUpdate) === null || _a3 === void 0 ? void 0 : _a3.call(options, latest);
              }, onComplete: function() {
                var _a3;
                (_a3 = options.onComplete) === null || _a3 === void 0 ? void 0 : _a3.call(options);
                _this.completeAnimation();
              } }));
              if (_this.resumingFrom) {
                _this.resumingFrom.currentAnimation = _this.currentAnimation;
              }
              _this.pendingAnimation = void 0;
            });
          };
          ProjectionNode.prototype.completeAnimation = function() {
            var _a2;
            if (this.resumingFrom) {
              this.resumingFrom.currentAnimation = void 0;
              this.resumingFrom.preserveOpacity = void 0;
            }
            (_a2 = this.getStack()) === null || _a2 === void 0 ? void 0 : _a2.exitAnimationComplete();
            this.resumingFrom = this.currentAnimation = this.animationValues = void 0;
            this.notifyListeners("animationComplete");
          };
          ProjectionNode.prototype.finishAnimation = function() {
            var _a2;
            if (this.currentAnimation) {
              (_a2 = this.mixTargetDelta) === null || _a2 === void 0 ? void 0 : _a2.call(this, animationTarget);
              this.currentAnimation.stop();
            }
            this.completeAnimation();
          };
          ProjectionNode.prototype.applyTransformsToTarget = function() {
            var _a2 = this.getLead(), targetWithTransforms = _a2.targetWithTransforms, target = _a2.target, layout = _a2.layout, latestValues = _a2.latestValues;
            if (!targetWithTransforms || !target || !layout)
              return;
            copyBoxInto(targetWithTransforms, target);
            transformBox(targetWithTransforms, latestValues);
            calcBoxDelta(this.projectionDeltaWithTransform, this.layoutCorrected, targetWithTransforms, latestValues);
          };
          ProjectionNode.prototype.registerSharedNode = function(layoutId, node) {
            var _a2, _b, _c;
            if (!this.sharedNodes.has(layoutId)) {
              this.sharedNodes.set(layoutId, new NodeStack());
            }
            var stack = this.sharedNodes.get(layoutId);
            stack.add(node);
            node.promote({
              transition: (_a2 = node.options.initialPromotionConfig) === null || _a2 === void 0 ? void 0 : _a2.transition,
              preserveFollowOpacity: (_c = (_b = node.options.initialPromotionConfig) === null || _b === void 0 ? void 0 : _b.shouldPreserveFollowOpacity) === null || _c === void 0 ? void 0 : _c.call(_b, node)
            });
          };
          ProjectionNode.prototype.isLead = function() {
            var stack = this.getStack();
            return stack ? stack.lead === this : true;
          };
          ProjectionNode.prototype.getLead = function() {
            var _a2;
            var layoutId = this.options.layoutId;
            return layoutId ? ((_a2 = this.getStack()) === null || _a2 === void 0 ? void 0 : _a2.lead) || this : this;
          };
          ProjectionNode.prototype.getPrevLead = function() {
            var _a2;
            var layoutId = this.options.layoutId;
            return layoutId ? (_a2 = this.getStack()) === null || _a2 === void 0 ? void 0 : _a2.prevLead : void 0;
          };
          ProjectionNode.prototype.getStack = function() {
            var layoutId = this.options.layoutId;
            if (layoutId)
              return this.root.sharedNodes.get(layoutId);
          };
          ProjectionNode.prototype.promote = function(_a2) {
            var _b = _a2 === void 0 ? {} : _a2, needsReset = _b.needsReset, transition = _b.transition, preserveFollowOpacity = _b.preserveFollowOpacity;
            var stack = this.getStack();
            if (stack)
              stack.promote(this, preserveFollowOpacity);
            if (needsReset) {
              this.projectionDelta = void 0;
              this.needsReset = true;
            }
            if (transition)
              this.setOptions({ transition });
          };
          ProjectionNode.prototype.relegate = function() {
            var stack = this.getStack();
            if (stack) {
              return stack.relegate(this);
            } else {
              return false;
            }
          };
          ProjectionNode.prototype.resetRotation = function() {
            var visualElement2 = this.options.visualElement;
            if (!visualElement2)
              return;
            var hasRotate = false;
            var resetValues = {};
            for (var i = 0; i < transformAxes.length; i++) {
              var axis = transformAxes[i];
              var key = "rotate" + axis;
              if (!visualElement2.getStaticValue(key)) {
                continue;
              }
              hasRotate = true;
              resetValues[key] = visualElement2.getStaticValue(key);
              visualElement2.setStaticValue(key, 0);
            }
            if (!hasRotate)
              return;
            visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.syncRender();
            for (var key in resetValues) {
              visualElement2.setStaticValue(key, resetValues[key]);
            }
            visualElement2.scheduleRender();
          };
          ProjectionNode.prototype.getProjectionStyles = function(styleProp) {
            var _a2, _b, _c, _d, _e, _f;
            if (styleProp === void 0) {
              styleProp = {};
            }
            var styles = {};
            if (!this.instance || this.isSVG)
              return styles;
            if (!this.isVisible) {
              return { visibility: "hidden" };
            } else {
              styles.visibility = "";
            }
            var transformTemplate = (_a2 = this.options.visualElement) === null || _a2 === void 0 ? void 0 : _a2.getProps().transformTemplate;
            if (this.needsReset) {
              this.needsReset = false;
              styles.opacity = "";
              styles.pointerEvents = resolveMotionValue(styleProp.pointerEvents) || "";
              styles.transform = transformTemplate ? transformTemplate(this.latestValues, "") : "none";
              return styles;
            }
            var lead = this.getLead();
            if (!this.projectionDelta || !this.layout || !lead.target) {
              var emptyStyles = {};
              if (this.options.layoutId) {
                emptyStyles.opacity = (_b = this.latestValues.opacity) !== null && _b !== void 0 ? _b : 1;
                emptyStyles.pointerEvents = resolveMotionValue(styleProp.pointerEvents) || "";
              }
              if (this.hasProjected && !hasTransform(this.latestValues)) {
                emptyStyles.transform = transformTemplate ? transformTemplate({}, "") : "none";
                this.hasProjected = false;
              }
              return emptyStyles;
            }
            var valuesToRender = lead.animationValues || lead.latestValues;
            this.applyTransformsToTarget();
            styles.transform = buildProjectionTransform(this.projectionDeltaWithTransform, this.treeScale, valuesToRender);
            if (transformTemplate) {
              styles.transform = transformTemplate(valuesToRender, styles.transform);
            }
            var _g = this.projectionDelta, x = _g.x, y = _g.y;
            styles.transformOrigin = "".concat(x.origin * 100, "% ").concat(y.origin * 100, "% 0");
            if (lead.animationValues) {
              styles.opacity = lead === this ? (_d = (_c = valuesToRender.opacity) !== null && _c !== void 0 ? _c : this.latestValues.opacity) !== null && _d !== void 0 ? _d : 1 : this.preserveOpacity ? this.latestValues.opacity : valuesToRender.opacityExit;
            } else {
              styles.opacity = lead === this ? (_e = valuesToRender.opacity) !== null && _e !== void 0 ? _e : "" : (_f = valuesToRender.opacityExit) !== null && _f !== void 0 ? _f : 0;
            }
            for (var key in scaleCorrectors) {
              if (valuesToRender[key] === void 0)
                continue;
              var _h = scaleCorrectors[key], correct = _h.correct, applyTo = _h.applyTo;
              var corrected = correct(valuesToRender[key], lead);
              if (applyTo) {
                var num = applyTo.length;
                for (var i = 0; i < num; i++) {
                  styles[applyTo[i]] = corrected;
                }
              } else {
                styles[key] = corrected;
              }
            }
            if (this.options.layoutId) {
              styles.pointerEvents = lead === this ? resolveMotionValue(styleProp.pointerEvents) || "" : "none";
            }
            return styles;
          };
          ProjectionNode.prototype.clearSnapshot = function() {
            this.resumeFrom = this.snapshot = void 0;
          };
          ProjectionNode.prototype.resetTree = function() {
            this.root.nodes.forEach(function(node) {
              var _a2;
              return (_a2 = node.currentAnimation) === null || _a2 === void 0 ? void 0 : _a2.stop();
            });
            this.root.nodes.forEach(clearMeasurements);
            this.root.sharedNodes.clear();
          };
          return ProjectionNode;
        }()
      );
    }
    function updateLayout(node) {
      node.updateLayout();
    }
    function notifyLayoutUpdate(node) {
      var _a, _b, _c, _d;
      var snapshot = (_b = (_a = node.resumeFrom) === null || _a === void 0 ? void 0 : _a.snapshot) !== null && _b !== void 0 ? _b : node.snapshot;
      if (node.isLead() && node.layout && snapshot && node.hasListeners("didUpdate")) {
        var _e = node.layout, layout_1 = _e.actual, measuredLayout = _e.measured;
        if (node.options.animationType === "size") {
          eachAxis(function(axis) {
            var axisSnapshot = snapshot.isShared ? snapshot.measured[axis] : snapshot.layout[axis];
            var length2 = calcLength(axisSnapshot);
            axisSnapshot.min = layout_1[axis].min;
            axisSnapshot.max = axisSnapshot.min + length2;
          });
        } else if (node.options.animationType === "position") {
          eachAxis(function(axis) {
            var axisSnapshot = snapshot.isShared ? snapshot.measured[axis] : snapshot.layout[axis];
            var length2 = calcLength(layout_1[axis]);
            axisSnapshot.max = axisSnapshot.min + length2;
          });
        }
        var layoutDelta = createDelta();
        calcBoxDelta(layoutDelta, layout_1, snapshot.layout);
        var visualDelta = createDelta();
        if (snapshot.isShared) {
          calcBoxDelta(visualDelta, node.applyTransform(measuredLayout, true), snapshot.measured);
        } else {
          calcBoxDelta(visualDelta, layout_1, snapshot.layout);
        }
        var hasLayoutChanged = !isDeltaZero(layoutDelta);
        var hasRelativeTargetChanged = false;
        if (!node.resumeFrom) {
          node.relativeParent = node.getClosestProjectingParent();
          if (node.relativeParent && !node.relativeParent.resumeFrom) {
            var _f = node.relativeParent, parentSnapshot = _f.snapshot, parentLayout = _f.layout;
            if (parentSnapshot && parentLayout) {
              var relativeSnapshot = createBox();
              calcRelativePosition(relativeSnapshot, snapshot.layout, parentSnapshot.layout);
              var relativeLayout = createBox();
              calcRelativePosition(relativeLayout, layout_1, parentLayout.actual);
              if (!boxEquals(relativeSnapshot, relativeLayout)) {
                hasRelativeTargetChanged = true;
              }
            }
          }
        }
        node.notifyListeners("didUpdate", {
          layout: layout_1,
          snapshot,
          delta: visualDelta,
          layoutDelta,
          hasLayoutChanged,
          hasRelativeTargetChanged
        });
      } else if (node.isLead()) {
        (_d = (_c = node.options).onExitComplete) === null || _d === void 0 ? void 0 : _d.call(_c);
      }
      node.options.transition = void 0;
    }
    function clearSnapshot(node) {
      node.clearSnapshot();
    }
    function clearMeasurements(node) {
      node.clearMeasurements();
    }
    function resetTransformStyle(node) {
      var visualElement2 = node.options.visualElement;
      if (visualElement2 === null || visualElement2 === void 0 ? void 0 : visualElement2.getProps().onBeforeLayoutMeasure) {
        visualElement2.notifyBeforeLayoutMeasure();
      }
      node.resetTransform();
    }
    function finishAnimation(node) {
      node.finishAnimation();
      node.targetDelta = node.relativeTarget = node.target = void 0;
    }
    function resolveTargetDelta(node) {
      node.resolveTargetDelta();
    }
    function calcProjection(node) {
      node.calcProjection();
    }
    function resetRotation(node) {
      node.resetRotation();
    }
    function removeLeadSnapshots(stack) {
      stack.removeLeadSnapshot();
    }
    function mixAxisDelta(output, delta, p) {
      output.translate = popmotion.mix(delta.translate, 0, p);
      output.scale = popmotion.mix(delta.scale, 1, p);
      output.origin = delta.origin;
      output.originPoint = delta.originPoint;
    }
    function mixAxis(output, from, to, p) {
      output.min = popmotion.mix(from.min, to.min, p);
      output.max = popmotion.mix(from.max, to.max, p);
    }
    function mixBox(output, from, to, p) {
      mixAxis(output.x, from.x, to.x, p);
      mixAxis(output.y, from.y, to.y, p);
    }
    function hasOpacityCrossfade(node) {
      return node.animationValues && node.animationValues.opacityExit !== void 0;
    }
    var defaultLayoutTransition = {
      duration: 0.45,
      ease: [0.4, 0, 0.1, 1]
    };
    function mountNodeEarly(node, id2) {
      var searchNode = node.root;
      for (var i = node.path.length - 1; i >= 0; i--) {
        if (Boolean(node.path[i].instance)) {
          searchNode = node.path[i];
          break;
        }
      }
      var searchElement = searchNode && searchNode !== node.root ? searchNode.instance : document;
      var element = searchElement.querySelector('[data-projection-id="'.concat(id2, '"]'));
      if (element)
        node.mount(element, true);
    }
    function roundAxis(axis) {
      axis.min = Math.round(axis.min);
      axis.max = Math.round(axis.max);
    }
    function roundBox(box) {
      roundAxis(box.x);
      roundAxis(box.y);
    }
    var DocumentProjectionNode = createProjectionNode({
      attachResizeListener: function(ref, notify2) {
        return addDomEvent(ref, "resize", notify2);
      },
      measureScroll: function() {
        return {
          x: document.documentElement.scrollLeft || document.body.scrollLeft,
          y: document.documentElement.scrollTop || document.body.scrollTop
        };
      },
      checkIsScrollRoot: function() {
        return true;
      }
    });
    var rootProjectionNode = {
      current: void 0
    };
    var HTMLProjectionNode = createProjectionNode({
      measureScroll: function(instance) {
        return {
          x: instance.scrollLeft,
          y: instance.scrollTop
        };
      },
      defaultParent: function() {
        if (!rootProjectionNode.current) {
          var documentNode = new DocumentProjectionNode(0, {});
          documentNode.mount(window);
          documentNode.setOptions({ layoutScroll: true });
          rootProjectionNode.current = documentNode;
        }
        return rootProjectionNode.current;
      },
      resetTransform: function(instance, value) {
        instance.style.transform = value !== null && value !== void 0 ? value : "none";
      },
      checkIsScrollRoot: function(instance) {
        return Boolean(window.getComputedStyle(instance).position === "fixed");
      }
    });
    var featureBundle = tslib.__assign(tslib.__assign(tslib.__assign(tslib.__assign({}, animations), gestureAnimations), drag), layoutFeatures);
    var motion = createMotionProxy(function(Component, config) {
      return createDomMotionConfig(Component, config, featureBundle, createDomVisualElement, HTMLProjectionNode);
    });
    function createDomMotionComponent(key) {
      return createMotionComponent(createDomMotionConfig(key, { forwardMotionProps: false }, featureBundle, createDomVisualElement, HTMLProjectionNode));
    }
    var m = createMotionProxy(createDomMotionConfig);
    function useIsMounted() {
      var isMounted = React3.useRef(false);
      useIsomorphicLayoutEffect(function() {
        isMounted.current = true;
        return function() {
          isMounted.current = false;
        };
      }, []);
      return isMounted;
    }
    function useForceUpdate() {
      var isMounted = useIsMounted();
      var _a = tslib.__read(React3.useState(0), 2), forcedRenderCount = _a[0], setForcedRenderCount = _a[1];
      var forceRender = React3.useCallback(function() {
        isMounted.current && setForcedRenderCount(forcedRenderCount + 1);
      }, [forcedRenderCount]);
      var deferredForceRender = React3.useCallback(function() {
        return sync__default["default"].postRender(forceRender);
      }, [forceRender]);
      return [deferredForceRender, forcedRenderCount];
    }
    var PresenceChild = function(_a) {
      var children = _a.children, initial = _a.initial, isPresent2 = _a.isPresent, onExitComplete = _a.onExitComplete, custom = _a.custom, presenceAffectsLayout = _a.presenceAffectsLayout;
      var presenceChildren = useConstant(newChildrenMap);
      var id2 = useId2();
      var context = React3.useMemo(
        function() {
          return {
            id: id2,
            initial,
            isPresent: isPresent2,
            custom,
            onExitComplete: function(childId) {
              var e_1, _a2;
              presenceChildren.set(childId, true);
              try {
                for (var _b = tslib.__values(presenceChildren.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                  var isComplete = _c.value;
                  if (!isComplete)
                    return;
                }
              } catch (e_1_1) {
                e_1 = { error: e_1_1 };
              } finally {
                try {
                  if (_c && !_c.done && (_a2 = _b.return))
                    _a2.call(_b);
                } finally {
                  if (e_1)
                    throw e_1.error;
                }
              }
              onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete();
            },
            register: function(childId) {
              presenceChildren.set(childId, false);
              return function() {
                return presenceChildren.delete(childId);
              };
            }
          };
        },
        /**
         * If the presence of a child affects the layout of the components around it,
         * we want to make a new context value to ensure they get re-rendered
         * so they can detect that layout change.
         */
        presenceAffectsLayout ? void 0 : [isPresent2]
      );
      React3.useMemo(function() {
        presenceChildren.forEach(function(_, key) {
          return presenceChildren.set(key, false);
        });
      }, [isPresent2]);
      React__namespace.useEffect(function() {
        !isPresent2 && !presenceChildren.size && (onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete());
      }, [isPresent2]);
      return React__namespace.createElement(PresenceContext.Provider, { value: context }, children);
    };
    function newChildrenMap() {
      return /* @__PURE__ */ new Map();
    }
    var getChildKey = function(child) {
      return child.key || "";
    };
    function updateChildLookup(children, allChildren) {
      children.forEach(function(child) {
        var key = getChildKey(child);
        allChildren.set(key, child);
      });
    }
    function onlyElements(children) {
      var filtered = [];
      React3.Children.forEach(children, function(child) {
        if (React3.isValidElement(child))
          filtered.push(child);
      });
      return filtered;
    }
    var AnimatePresence = function(_a) {
      var children = _a.children, custom = _a.custom, _b = _a.initial, initial = _b === void 0 ? true : _b, onExitComplete = _a.onExitComplete, exitBeforeEnter = _a.exitBeforeEnter, _c = _a.presenceAffectsLayout, presenceAffectsLayout = _c === void 0 ? true : _c;
      var _d = tslib.__read(useForceUpdate(), 1), forceRender = _d[0];
      var forceRenderLayoutGroup = React3.useContext(LayoutGroupContext).forceRender;
      if (forceRenderLayoutGroup)
        forceRender = forceRenderLayoutGroup;
      var isMounted = useIsMounted();
      var filteredChildren = onlyElements(children);
      var childrenToRender = filteredChildren;
      var exiting = /* @__PURE__ */ new Set();
      var presentChildren = React3.useRef(childrenToRender);
      var allChildren = React3.useRef(/* @__PURE__ */ new Map()).current;
      var isInitialRender = React3.useRef(true);
      useIsomorphicLayoutEffect(function() {
        isInitialRender.current = false;
        updateChildLookup(filteredChildren, allChildren);
        presentChildren.current = childrenToRender;
      });
      useUnmountEffect(function() {
        isInitialRender.current = true;
        allChildren.clear();
        exiting.clear();
      });
      if (isInitialRender.current) {
        return React__namespace.createElement(React__namespace.Fragment, null, childrenToRender.map(function(child) {
          return React__namespace.createElement(PresenceChild, { key: getChildKey(child), isPresent: true, initial: initial ? void 0 : false, presenceAffectsLayout }, child);
        }));
      }
      childrenToRender = tslib.__spreadArray([], tslib.__read(childrenToRender), false);
      var presentKeys = presentChildren.current.map(getChildKey);
      var targetKeys = filteredChildren.map(getChildKey);
      var numPresent = presentKeys.length;
      for (var i = 0; i < numPresent; i++) {
        var key = presentKeys[i];
        if (targetKeys.indexOf(key) === -1) {
          exiting.add(key);
        }
      }
      if (exitBeforeEnter && exiting.size) {
        childrenToRender = [];
      }
      exiting.forEach(function(key2) {
        if (targetKeys.indexOf(key2) !== -1)
          return;
        var child = allChildren.get(key2);
        if (!child)
          return;
        var insertionIndex = presentKeys.indexOf(key2);
        var onExit = function() {
          allChildren.delete(key2);
          exiting.delete(key2);
          var removeIndex = presentChildren.current.findIndex(function(presentChild) {
            return presentChild.key === key2;
          });
          presentChildren.current.splice(removeIndex, 1);
          if (!exiting.size) {
            presentChildren.current = filteredChildren;
            if (isMounted.current === false)
              return;
            forceRender();
            onExitComplete && onExitComplete();
          }
        };
        childrenToRender.splice(insertionIndex, 0, React__namespace.createElement(PresenceChild, { key: getChildKey(child), isPresent: false, onExitComplete: onExit, custom, presenceAffectsLayout }, child));
      });
      childrenToRender = childrenToRender.map(function(child) {
        var key2 = child.key;
        return exiting.has(key2) ? child : React__namespace.createElement(PresenceChild, { key: getChildKey(child), isPresent: true, presenceAffectsLayout }, child);
      });
      if (env !== "production" && exitBeforeEnter && childrenToRender.length > 1) {
        console.warn("You're attempting to animate multiple children within AnimatePresence, but its exitBeforeEnter prop is set to true. This will lead to odd visual behaviour.");
      }
      return React__namespace.createElement(React__namespace.Fragment, null, exiting.size ? childrenToRender : childrenToRender.map(function(child) {
        return React3.cloneElement(child);
      }));
    };
    var DeprecatedLayoutGroupContext = React3.createContext(null);
    var notify = function(node) {
      return !node.isLayoutDirty && node.willUpdate(false);
    };
    function nodeGroup() {
      var nodes = /* @__PURE__ */ new Set();
      var subscriptions = /* @__PURE__ */ new WeakMap();
      var dirtyAll = function() {
        return nodes.forEach(notify);
      };
      return {
        add: function(node) {
          nodes.add(node);
          subscriptions.set(node, node.addEventListener("willUpdate", dirtyAll));
        },
        remove: function(node) {
          var _a;
          nodes.delete(node);
          (_a = subscriptions.get(node)) === null || _a === void 0 ? void 0 : _a();
          subscriptions.delete(node);
          dirtyAll();
        },
        dirty: dirtyAll
      };
    }
    var shouldInheritGroup = function(inherit) {
      return inherit === true;
    };
    var shouldInheritId = function(inherit) {
      return shouldInheritGroup(inherit === true) || inherit === "id";
    };
    var LayoutGroup = function(_a) {
      var _b, _c;
      var children = _a.children, id2 = _a.id, inheritId = _a.inheritId, _d = _a.inherit, inherit = _d === void 0 ? true : _d;
      if (inheritId !== void 0)
        inherit = inheritId;
      var layoutGroupContext = React3.useContext(LayoutGroupContext);
      var deprecatedLayoutGroupContext = React3.useContext(DeprecatedLayoutGroupContext);
      var _e = tslib.__read(useForceUpdate(), 2), forceRender = _e[0], key = _e[1];
      var context = React3.useRef(null);
      var upstreamId = (_b = layoutGroupContext.id) !== null && _b !== void 0 ? _b : deprecatedLayoutGroupContext;
      if (context.current === null) {
        if (shouldInheritId(inherit) && upstreamId) {
          id2 = id2 ? upstreamId + "-" + id2 : upstreamId;
        }
        context.current = {
          id: id2,
          group: shouldInheritGroup(inherit) ? (_c = layoutGroupContext === null || layoutGroupContext === void 0 ? void 0 : layoutGroupContext.group) !== null && _c !== void 0 ? _c : nodeGroup() : nodeGroup()
        };
      }
      var memoizedContext = React3.useMemo(function() {
        return tslib.__assign(tslib.__assign({}, context.current), { forceRender });
      }, [key]);
      return React__namespace.createElement(LayoutGroupContext.Provider, { value: memoizedContext }, children);
    };
    var id = 0;
    var AnimateSharedLayout = function(_a) {
      var children = _a.children;
      React__namespace.useEffect(function() {
        heyListen.warning(false, "AnimateSharedLayout is deprecated: https://www.framer.com/docs/guide-upgrade/##shared-layout-animations");
      }, []);
      return React__namespace.createElement(LayoutGroup, { id: useConstant(function() {
        return "asl-".concat(id++);
      }) }, children);
    };
    function MotionConfig(_a) {
      var children = _a.children, isValidProp = _a.isValidProp, config = tslib.__rest(_a, ["children", "isValidProp"]);
      isValidProp && loadExternalIsValidProp(isValidProp);
      config = tslib.__assign(tslib.__assign({}, React3.useContext(MotionConfigContext)), config);
      config.isStatic = useConstant(function() {
        return config.isStatic;
      });
      var context = React3.useMemo(function() {
        return config;
      }, [JSON.stringify(config.transition), config.transformPagePoint, config.reducedMotion]);
      return React__namespace.createElement(MotionConfigContext.Provider, { value: context }, children);
    }
    function LazyMotion(_a) {
      var children = _a.children, features = _a.features, _b = _a.strict, strict = _b === void 0 ? false : _b;
      var _c = tslib.__read(React3.useState(!isLazyBundle(features)), 2), setIsLoaded = _c[1];
      var loadedRenderer = React3.useRef(void 0);
      if (!isLazyBundle(features)) {
        var renderer = features.renderer, loadedFeatures = tslib.__rest(features, ["renderer"]);
        loadedRenderer.current = renderer;
        loadFeatures(loadedFeatures);
      }
      React3.useEffect(function() {
        if (isLazyBundle(features)) {
          features().then(function(_a2) {
            var renderer2 = _a2.renderer, loadedFeatures2 = tslib.__rest(_a2, ["renderer"]);
            loadFeatures(loadedFeatures2);
            loadedRenderer.current = renderer2;
            setIsLoaded(true);
          });
        }
      }, []);
      return React__namespace.createElement(LazyContext.Provider, { value: { renderer: loadedRenderer.current, strict } }, children);
    }
    function isLazyBundle(features) {
      return typeof features === "function";
    }
    var ReorderContext = React3.createContext(null);
    function checkReorder(order3, value, offset3, velocity) {
      if (!velocity)
        return order3;
      var index4 = order3.findIndex(function(item2) {
        return item2.value === value;
      });
      if (index4 === -1)
        return order3;
      var nextOffset = velocity > 0 ? 1 : -1;
      var nextItem = order3[index4 + nextOffset];
      if (!nextItem)
        return order3;
      var item = order3[index4];
      var nextLayout = nextItem.layout;
      var nextItemCenter = popmotion.mix(nextLayout.min, nextLayout.max, 0.5);
      if (nextOffset === 1 && item.layout.max + offset3 > nextItemCenter || nextOffset === -1 && item.layout.min + offset3 < nextItemCenter) {
        return moveItem(order3, index4, index4 + nextOffset);
      }
      return order3;
    }
    function ReorderGroup(_a, externalRef) {
      var children = _a.children, _b = _a.as, as = _b === void 0 ? "ul" : _b, _c = _a.axis, axis = _c === void 0 ? "y" : _c, onReorder = _a.onReorder, values = _a.values, props = tslib.__rest(_a, ["children", "as", "axis", "onReorder", "values"]);
      var Component = useConstant(function() {
        return motion(as);
      });
      var order3 = [];
      var isReordering = React3.useRef(false);
      heyListen.invariant(Boolean(values), "Reorder.Group must be provided a values prop");
      var context = {
        axis,
        registerItem: function(value, layout) {
          if (layout && order3.findIndex(function(entry) {
            return value === entry.value;
          }) === -1) {
            order3.push({ value, layout: layout[axis] });
            order3.sort(compareMin);
          }
        },
        updateOrder: function(id2, offset3, velocity) {
          if (isReordering.current)
            return;
          var newOrder = checkReorder(order3, id2, offset3, velocity);
          if (order3 !== newOrder) {
            isReordering.current = true;
            onReorder(newOrder.map(getValue).filter(function(value) {
              return values.indexOf(value) !== -1;
            }));
          }
        }
      };
      React3.useEffect(function() {
        isReordering.current = false;
      });
      return React__namespace.createElement(
        Component,
        tslib.__assign({}, props, { ref: externalRef }),
        React__namespace.createElement(ReorderContext.Provider, { value: context }, children)
      );
    }
    var Group = React3.forwardRef(ReorderGroup);
    function getValue(item) {
      return item.value;
    }
    function compareMin(a, b) {
      return a.layout.min - b.layout.min;
    }
    function useMotionValue(initial) {
      var value = useConstant(function() {
        return motionValue(initial);
      });
      var isStatic = React3.useContext(MotionConfigContext).isStatic;
      if (isStatic) {
        var _a = tslib.__read(React3.useState(initial), 2), setLatest_1 = _a[1];
        React3.useEffect(function() {
          return value.onChange(setLatest_1);
        }, []);
      }
      return value;
    }
    var isCustomValueType = function(v) {
      return typeof v === "object" && v.mix;
    };
    var getMixer = function(v) {
      return isCustomValueType(v) ? v.mix : void 0;
    };
    function transform() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      var useImmediate = !Array.isArray(args[0]);
      var argOffset = useImmediate ? 0 : -1;
      var inputValue = args[0 + argOffset];
      var inputRange = args[1 + argOffset];
      var outputRange = args[2 + argOffset];
      var options = args[3 + argOffset];
      var interpolator = popmotion.interpolate(inputRange, outputRange, tslib.__assign({ mixer: getMixer(outputRange[0]) }, options));
      return useImmediate ? interpolator(inputValue) : interpolator;
    }
    function useOnChange(value, callback) {
      useIsomorphicLayoutEffect(function() {
        if (isMotionValue(value))
          return value.onChange(callback);
      }, [callback]);
    }
    function useMultiOnChange(values, handler) {
      useIsomorphicLayoutEffect(function() {
        var subscriptions = values.map(function(value) {
          return value.onChange(handler);
        });
        return function() {
          return subscriptions.forEach(function(unsubscribe) {
            return unsubscribe();
          });
        };
      });
    }
    function useCombineMotionValues(values, combineValues) {
      var value = useMotionValue(combineValues());
      var updateValue = function() {
        return value.set(combineValues());
      };
      updateValue();
      useMultiOnChange(values, function() {
        return sync__default["default"].update(updateValue, false, true);
      });
      return value;
    }
    function useTransform(input, inputRangeOrTransformer, outputRange, options) {
      var transformer = typeof inputRangeOrTransformer === "function" ? inputRangeOrTransformer : transform(inputRangeOrTransformer, outputRange, options);
      return Array.isArray(input) ? useListTransform(input, transformer) : useListTransform([input], function(_a) {
        var _b = tslib.__read(_a, 1), latest = _b[0];
        return transformer(latest);
      });
    }
    function useListTransform(values, transformer) {
      var latest = useConstant(function() {
        return [];
      });
      return useCombineMotionValues(values, function() {
        latest.length = 0;
        var numValues = values.length;
        for (var i = 0; i < numValues; i++) {
          latest[i] = values[i].get();
        }
        return transformer(latest);
      });
    }
    function useDefaultMotionValue(value, defaultValue) {
      if (defaultValue === void 0) {
        defaultValue = 0;
      }
      return isMotionValue(value) ? value : useMotionValue(defaultValue);
    }
    function ReorderItem(_a, externalRef) {
      var children = _a.children, style2 = _a.style, value = _a.value, _b = _a.as, as = _b === void 0 ? "li" : _b, onDrag = _a.onDrag, _c = _a.layout, layout = _c === void 0 ? true : _c, props = tslib.__rest(_a, ["children", "style", "value", "as", "onDrag", "layout"]);
      var Component = useConstant(function() {
        return motion(as);
      });
      var context = React3.useContext(ReorderContext);
      var point2 = {
        x: useDefaultMotionValue(style2 === null || style2 === void 0 ? void 0 : style2.x),
        y: useDefaultMotionValue(style2 === null || style2 === void 0 ? void 0 : style2.y)
      };
      var zIndex = useTransform([point2.x, point2.y], function(_a2) {
        var _b2 = tslib.__read(_a2, 2), latestX = _b2[0], latestY = _b2[1];
        return latestX || latestY ? 1 : "unset";
      });
      var measuredLayout = React3.useRef(null);
      heyListen.invariant(Boolean(context), "Reorder.Item must be a child of Reorder.Group");
      var _d = context, axis = _d.axis, registerItem = _d.registerItem, updateOrder = _d.updateOrder;
      React3.useEffect(function() {
        registerItem(value, measuredLayout.current);
      }, [context]);
      return React__namespace.createElement(Component, tslib.__assign({ drag: axis }, props, { dragSnapToOrigin: true, style: tslib.__assign(tslib.__assign({}, style2), { x: point2.x, y: point2.y, zIndex }), layout, onDrag: function(event, gesturePoint) {
        var velocity = gesturePoint.velocity;
        velocity[axis] && updateOrder(value, point2[axis].get(), velocity[axis]);
        onDrag === null || onDrag === void 0 ? void 0 : onDrag(event, gesturePoint);
      }, onLayoutMeasure: function(measured) {
        measuredLayout.current = measured;
      }, ref: externalRef }), children);
    }
    var Item = React3.forwardRef(ReorderItem);
    var Reorder = {
      Group,
      Item
    };
    var domAnimation = tslib.__assign(tslib.__assign({ renderer: createDomVisualElement }, animations), gestureAnimations);
    var domMax = tslib.__assign(tslib.__assign(tslib.__assign(tslib.__assign({}, domAnimation), drag), layoutFeatures), { projectionNodeConstructor: HTMLProjectionNode });
    function useMotionTemplate(fragments) {
      var values = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        values[_i - 1] = arguments[_i];
      }
      var numFragments = fragments.length;
      function buildValue() {
        var output = "";
        for (var i = 0; i < numFragments; i++) {
          output += fragments[i];
          var value = values[i];
          if (value)
            output += values[i].get();
        }
        return output;
      }
      return useCombineMotionValues(values, buildValue);
    }
    function useSpring(source, config) {
      if (config === void 0) {
        config = {};
      }
      var isStatic = React3.useContext(MotionConfigContext).isStatic;
      var activeSpringAnimation = React3.useRef(null);
      var value = useMotionValue(isMotionValue(source) ? source.get() : source);
      React3.useMemo(function() {
        return value.attach(function(v, set) {
          if (isStatic)
            return set(v);
          if (activeSpringAnimation.current) {
            activeSpringAnimation.current.stop();
          }
          activeSpringAnimation.current = popmotion.animate(tslib.__assign(tslib.__assign({ from: value.get(), to: v, velocity: value.getVelocity() }, config), { onUpdate: set }));
          return value.get();
        });
      }, [JSON.stringify(config)]);
      useOnChange(source, function(v) {
        return value.set(parseFloat(v));
      });
      return value;
    }
    function useVelocity(value) {
      var velocity = useMotionValue(value.getVelocity());
      React3.useEffect(function() {
        return value.velocityUpdateSubscribers.add(function(newVelocity) {
          velocity.set(newVelocity);
        });
      }, [value]);
      return velocity;
    }
    var createScrollMotionValues = function() {
      return {
        scrollX: motionValue(0),
        scrollY: motionValue(0),
        scrollXProgress: motionValue(0),
        scrollYProgress: motionValue(0)
      };
    };
    function useScroll(_a) {
      if (_a === void 0) {
        _a = {};
      }
      var container = _a.container, target = _a.target, options = tslib.__rest(_a, ["container", "target"]);
      var values = useConstant(createScrollMotionValues);
      useIsomorphicLayoutEffect(function() {
        return dom.scroll(function(_a2) {
          var x = _a2.x, y = _a2.y;
          values.scrollX.set(x.current);
          values.scrollXProgress.set(x.progress);
          values.scrollY.set(y.current);
          values.scrollYProgress.set(y.progress);
        }, tslib.__assign(tslib.__assign({}, options), { container: (container === null || container === void 0 ? void 0 : container.current) || void 0, target: (target === null || target === void 0 ? void 0 : target.current) || void 0 }));
      }, []);
      return values;
    }
    function useElementScroll(ref) {
      warnOnce(false, "useElementScroll is deprecated. Convert to useScroll({ container: ref }).");
      return useScroll({ container: ref });
    }
    function useViewportScroll() {
      warnOnce(false, "useViewportScroll is deprecated. Convert to useScroll().");
      return useScroll();
    }
    var getCurrentTime = typeof performance !== "undefined" ? function() {
      return performance.now();
    } : function() {
      return Date.now();
    };
    function useAnimationFrame(callback) {
      var initialTimestamp = useConstant(getCurrentTime);
      var isStatic = React3.useContext(MotionConfigContext).isStatic;
      React3.useEffect(function() {
        if (isStatic)
          return;
        var provideTimeSinceStart = function(_a) {
          var timestamp = _a.timestamp;
          callback(timestamp - initialTimestamp);
        };
        sync__default["default"].update(provideTimeSinceStart, true);
        return function() {
          return sync.cancelSync.update(provideTimeSinceStart);
        };
      }, [callback]);
    }
    function useTime() {
      var time2 = useMotionValue(0);
      useAnimationFrame(function(t) {
        return time2.set(t);
      });
      return time2;
    }
    function animationControls() {
      var hasMounted = false;
      var pendingAnimations = [];
      var subscribers = /* @__PURE__ */ new Set();
      var controls2 = {
        subscribe: function(visualElement2) {
          subscribers.add(visualElement2);
          return function() {
            return void subscribers.delete(visualElement2);
          };
        },
        start: function(definition, transitionOverride) {
          if (hasMounted) {
            var animations_1 = [];
            subscribers.forEach(function(visualElement2) {
              animations_1.push(animateVisualElement(visualElement2, definition, {
                transitionOverride
              }));
            });
            return Promise.all(animations_1);
          } else {
            return new Promise(function(resolve) {
              pendingAnimations.push({
                animation: [definition, transitionOverride],
                resolve
              });
            });
          }
        },
        set: function(definition) {
          heyListen.invariant(hasMounted, "controls.set() should only be called after a component has mounted. Consider calling within a useEffect hook.");
          return subscribers.forEach(function(visualElement2) {
            setValues(visualElement2, definition);
          });
        },
        stop: function() {
          subscribers.forEach(function(visualElement2) {
            stopAnimation2(visualElement2);
          });
        },
        mount: function() {
          hasMounted = true;
          pendingAnimations.forEach(function(_a) {
            var animation = _a.animation, resolve = _a.resolve;
            controls2.start.apply(controls2, tslib.__spreadArray([], tslib.__read(animation), false)).then(resolve);
          });
          return function() {
            hasMounted = false;
            controls2.stop();
          };
        }
      };
      return controls2;
    }
    function useAnimationControls() {
      var controls2 = useConstant(animationControls);
      React3.useEffect(controls2.mount, []);
      return controls2;
    }
    var useAnimation = useAnimationControls;
    function useCycle() {
      var items = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        items[_i] = arguments[_i];
      }
      var index4 = React3.useRef(0);
      var _a = tslib.__read(React3.useState(items[index4.current]), 2), item = _a[0], setItem = _a[1];
      var runCycle = React3.useCallback(function(next) {
        index4.current = typeof next !== "number" ? popmotion.wrap(0, items.length, index4.current + 1) : next;
        setItem(items[index4.current]);
      }, tslib.__spreadArray([items.length], tslib.__read(items), false));
      return [item, runCycle];
    }
    function useInView(ref, _a) {
      var _b = _a === void 0 ? {} : _a, root = _b.root, margin = _b.margin, amount = _b.amount, _c = _b.once, once = _c === void 0 ? false : _c;
      var _d = tslib.__read(React3.useState(false), 2), isInView = _d[0], setInView = _d[1];
      React3.useEffect(function() {
        var _a2;
        if (!ref.current || once && isInView)
          return;
        var onEnter = function() {
          setInView(true);
          return once ? void 0 : function() {
            return setInView(false);
          };
        };
        var options = {
          root: (_a2 = root === null || root === void 0 ? void 0 : root.current) !== null && _a2 !== void 0 ? _a2 : void 0,
          margin,
          amount: amount === "some" ? "any" : amount
        };
        return dom.inView(ref.current, onEnter, options);
      }, [root, ref, margin, once]);
      return isInView;
    }
    var DragControls = (
      /** @class */
      function() {
        function DragControls2() {
          this.componentControls = /* @__PURE__ */ new Set();
        }
        DragControls2.prototype.subscribe = function(controls2) {
          var _this = this;
          this.componentControls.add(controls2);
          return function() {
            return _this.componentControls.delete(controls2);
          };
        };
        DragControls2.prototype.start = function(event, options) {
          this.componentControls.forEach(function(controls2) {
            controls2.start(event.nativeEvent || event, options);
          });
        };
        return DragControls2;
      }()
    );
    var createDragControls = function() {
      return new DragControls();
    };
    function useDragControls() {
      return useConstant(createDragControls);
    }
    function useInstantLayoutTransition() {
      return startTransition;
    }
    function startTransition(cb) {
      if (!rootProjectionNode.current)
        return;
      rootProjectionNode.current.isUpdating = false;
      rootProjectionNode.current.blockUpdate();
      cb === null || cb === void 0 ? void 0 : cb();
    }
    function useInstantTransition() {
      var _a = tslib.__read(useForceUpdate(), 2), forceUpdate = _a[0], forcedRenderCount = _a[1];
      var startInstantLayoutTransition = useInstantLayoutTransition();
      React3.useEffect(function() {
        sync__default["default"].postRender(function() {
          return sync__default["default"].postRender(function() {
            return instantAnimationState.current = false;
          });
        });
      }, [forcedRenderCount]);
      return function(callback) {
        startInstantLayoutTransition(function() {
          instantAnimationState.current = true;
          forceUpdate();
          callback();
        });
      };
    }
    function useResetProjection() {
      var reset = React__namespace.useCallback(function() {
        var root = rootProjectionNode.current;
        if (!root)
          return;
        root.resetTree();
      }, []);
      return reset;
    }
    var createObject = function() {
      return {};
    };
    var stateVisualElement = visualElement({
      build: function() {
      },
      measureViewportBox: createBox,
      resetTransform: function() {
      },
      restoreTransform: function() {
      },
      removeValueFromRenderState: function() {
      },
      render: function() {
      },
      scrapeMotionValuesFromProps: createObject,
      readValueFromInstance: function(_state, key, options) {
        return options.initialState[key] || 0;
      },
      makeTargetAnimatable: function(element, _a) {
        var transition = _a.transition, transitionEnd = _a.transitionEnd, target = tslib.__rest(_a, ["transition", "transitionEnd"]);
        var origin = getOrigin(target, transition || {}, element);
        checkTargetForNewValues(element, target, origin);
        return tslib.__assign({ transition, transitionEnd }, target);
      }
    });
    var useVisualState = makeUseVisualState({
      scrapeMotionValuesFromProps: createObject,
      createRenderState: createObject
    });
    function useAnimatedState(initialState) {
      var _a = tslib.__read(React3.useState(initialState), 2), animationState = _a[0], setAnimationState = _a[1];
      var visualState = useVisualState({}, false);
      var element = useConstant(function() {
        return stateVisualElement({ props: {}, visualState }, { initialState });
      });
      React3.useEffect(function() {
        element.mount({});
        return element.unmount;
      }, [element]);
      React3.useEffect(function() {
        element.setProps({
          onUpdate: function(v) {
            setAnimationState(tslib.__assign({}, v));
          }
        });
      }, [setAnimationState, element]);
      var startAnimation2 = useConstant(function() {
        return function(animationDefinition) {
          return animateVisualElement(element, animationDefinition);
        };
      });
      return [animationState, startAnimation2];
    }
    var maxScale = 1e5;
    var invertScale = function(scale) {
      return scale > 1e-3 ? 1 / scale : maxScale;
    };
    var hasWarned = false;
    function useInvertedScale(scale) {
      var parentScaleX = useMotionValue(1);
      var parentScaleY = useMotionValue(1);
      var visualElement2 = useVisualElementContext();
      heyListen.invariant(!!(scale || visualElement2), "If no scale values are provided, useInvertedScale must be used within a child of another motion component.");
      heyListen.warning(hasWarned, "useInvertedScale is deprecated and will be removed in 3.0. Use the layout prop instead.");
      hasWarned = true;
      if (scale) {
        parentScaleX = scale.scaleX || parentScaleX;
        parentScaleY = scale.scaleY || parentScaleY;
      } else if (visualElement2) {
        parentScaleX = visualElement2.getValue("scaleX", 1);
        parentScaleY = visualElement2.getValue("scaleY", 1);
      }
      var scaleX = useTransform(parentScaleX, invertScale);
      var scaleY = useTransform(parentScaleY, invertScale);
      return { scaleX, scaleY };
    }
    exports.AnimatePresence = AnimatePresence;
    exports.AnimateSharedLayout = AnimateSharedLayout;
    exports.DeprecatedLayoutGroupContext = DeprecatedLayoutGroupContext;
    exports.DragControls = DragControls;
    exports.FlatTree = FlatTree;
    exports.LayoutGroup = LayoutGroup;
    exports.LayoutGroupContext = LayoutGroupContext;
    exports.LazyMotion = LazyMotion;
    exports.MotionConfig = MotionConfig;
    exports.MotionConfigContext = MotionConfigContext;
    exports.MotionContext = MotionContext;
    exports.MotionValue = MotionValue2;
    exports.PresenceContext = PresenceContext;
    exports.Reorder = Reorder;
    exports.SwitchLayoutGroupContext = SwitchLayoutGroupContext;
    exports.addPointerEvent = addPointerEvent;
    exports.addScaleCorrector = addScaleCorrector;
    exports.animate = animate2;
    exports.animateVisualElement = animateVisualElement;
    exports.animationControls = animationControls;
    exports.animations = animations;
    exports.calcLength = calcLength;
    exports.checkTargetForNewValues = checkTargetForNewValues;
    exports.createBox = createBox;
    exports.createDomMotionComponent = createDomMotionComponent;
    exports.createMotionComponent = createMotionComponent;
    exports.domAnimation = domAnimation;
    exports.domMax = domMax;
    exports.filterProps = filterProps;
    exports.isBrowser = isBrowser;
    exports.isDragActive = isDragActive;
    exports.isMotionValue = isMotionValue;
    exports.isValidMotionProp = isValidMotionProp;
    exports.m = m;
    exports.makeUseVisualState = makeUseVisualState;
    exports.motion = motion;
    exports.motionValue = motionValue;
    exports.resolveMotionValue = resolveMotionValue;
    exports.transform = transform;
    exports.useAnimation = useAnimation;
    exports.useAnimationControls = useAnimationControls;
    exports.useAnimationFrame = useAnimationFrame;
    exports.useCycle = useCycle;
    exports.useDeprecatedAnimatedState = useAnimatedState;
    exports.useDeprecatedInvertedScale = useInvertedScale;
    exports.useDomEvent = useDomEvent;
    exports.useDragControls = useDragControls;
    exports.useElementScroll = useElementScroll;
    exports.useForceUpdate = useForceUpdate;
    exports.useInView = useInView;
    exports.useInstantLayoutTransition = useInstantLayoutTransition;
    exports.useInstantTransition = useInstantTransition;
    exports.useIsPresent = useIsPresent;
    exports.useIsomorphicLayoutEffect = useIsomorphicLayoutEffect;
    exports.useMotionTemplate = useMotionTemplate;
    exports.useMotionValue = useMotionValue;
    exports.usePresence = usePresence;
    exports.useReducedMotion = useReducedMotion;
    exports.useReducedMotionConfig = useReducedMotionConfig;
    exports.useResetProjection = useResetProjection;
    exports.useScroll = useScroll;
    exports.useSpring = useSpring;
    exports.useTime = useTime;
    exports.useTransform = useTransform;
    exports.useUnmountEffect = useUnmountEffect;
    exports.useVelocity = useVelocity;
    exports.useViewportScroll = useViewportScroll;
    exports.useVisualElementContext = useVisualElementContext;
    exports.visualElement = visualElement;
    exports.wrapHandler = wrapHandler;
  }
});

// node_modules/@material-tailwind/react/components/Accordion/AccordionBody.js
var require_AccordionBody = __commonJS({
  "node_modules/@material-tailwind/react/components/Accordion/AccordionBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { AccordionBody: function() {
      return AccordionBody;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _framerMotion = require_cjs2();
    var _classnames = _interopRequireDefault(require_classnames());
    var _deepmerge = _interopRequireDefault(require_cjs());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _tailwindMerge = require_dist();
    var _accordionContext = require_AccordionContext();
    var _theme = require_theme2();
    var _accordion = require_accordion2();
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var AccordionBody = _react.default.forwardRef(function(_param, ref) {
      var className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["className", "children"]);
      var _useAccordion = (0, _accordionContext.useAccordion)(), open = _useAccordion.open, animate2 = _useAccordion.animate;
      var accordion = (0, _theme.useTheme)().accordion;
      var base = accordion.styles.base;
      className = className !== null && className !== void 0 ? className : "";
      var bodyClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.body)), className);
      var heightAnimation = { unmount: { height: "0px", transition: { duration: 0.2, times: [0.4, 0, 0.2, 1] } }, mount: { height: "auto", transition: { duration: 0.2, times: [0.4, 0, 0.2, 1] } } };
      var mainAnimation = { unmount: { transition: { duration: 0.3, ease: "linear" } }, mount: { transition: { duration: 0.3, ease: "linear" } } };
      var appliedAnimation = (0, _deepmerge.default)(heightAnimation, animate2);
      return _react.default.createElement(_framerMotion.LazyMotion, { features: _framerMotion.domAnimation }, _react.default.createElement(_framerMotion.m.div, { className: "overflow-hidden", initial: "unmount", exit: "unmount", animate: open ? "mount" : "unmount", variants: appliedAnimation }, _react.default.createElement(_framerMotion.m.div, _extends2({}, rest, { ref, className: bodyClasses, initial: "unmount", exit: "unmount", animate: open ? "mount" : "unmount", variants: mainAnimation }), children)));
    });
    AccordionBody.propTypes = { className: _accordion.propTypesClassName, children: _accordion.propTypesChildren };
    AccordionBody.displayName = "MaterialTailwind.AccordionBody";
    var _default = AccordionBody;
  }
});

// node_modules/@material-tailwind/react/components/Accordion/index.js
var require_Accordion = __commonJS({
  "node_modules/@material-tailwind/react/components/Accordion/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Accordion: function() {
      return Accordion;
    }, AccordionHeader: function() {
      return _accordionHeader.AccordionHeader;
    }, AccordionBody: function() {
      return _accordionBody.AccordionBody;
    }, useAccordion: function() {
      return _accordionContext.useAccordion;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _accordionContext = require_AccordionContext();
    var _accordion = require_accordion2();
    var _accordionHeader = require_AccordionHeader();
    var _accordionBody = require_AccordionBody();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Accordion = _react.default.forwardRef(function(_param, ref) {
      var open = _param.open, icon = _param.icon, animate2 = _param.animate, className = _param.className, disabled = _param.disabled, children = _param.children, rest = _objectWithoutProperties(_param, ["open", "icon", "animate", "className", "disabled", "children"]);
      var accordion = (0, _theme.useTheme)().accordion;
      var defaultProps = accordion.defaultProps, base = accordion.styles.base;
      icon = icon !== null && icon !== void 0 ? icon : defaultProps.icon;
      animate2 = animate2 !== null && animate2 !== void 0 ? animate2 : defaultProps.animate;
      disabled = disabled !== null && disabled !== void 0 ? disabled : defaultProps.disabled;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var accordionClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.container), _defineProperty({}, (0, _objectsToString.default)(base.disabled), disabled)), className);
      var contextValue = _react.default.useMemo(function() {
        return { open, icon, animate: animate2, disabled };
      }, [open, icon, animate2, disabled]);
      return _react.default.createElement(_accordionContext.AccordionContextProvider, { value: contextValue }, _react.default.createElement("div", _extends2({}, rest, { ref, className: accordionClasses }), children));
    });
    Accordion.propTypes = { open: _accordion.propTypesOpen, icon: _accordion.propTypesIcon, animate: _accordion.propTypesAnimate, disabled: _accordion.propTypesDisabled, className: _accordion.propTypesClassName, children: _accordion.propTypesChildren };
    Accordion.displayName = "MaterialTailwind.Accordion";
    var _default = Object.assign(Accordion, { Header: _accordionHeader.AccordionHeader, Body: _accordionBody.AccordionBody });
  }
});

// node_modules/@material-tailwind/react/utils/findMatch.js
var require_findMatch = __commonJS({
  "node_modules/@material-tailwind/react/utils/findMatch.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return _default;
    } });
    function findMatch(data2, find, defaultValue) {
      var founded = data2.findIndex(function(el) {
        return el === find;
      });
      return founded >= 0 ? find : defaultValue;
    }
    var _default = findMatch;
  }
});

// node_modules/material-ripple-effects/index.js
var require_material_ripple_effects = __commonJS({
  "node_modules/material-ripple-effects/index.js"(exports, module) {
    module.exports = class Ripple {
      constructor() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
      }
      findFurthestPoint(clickPointX, elementWidth, offsetX, clickPointY, elementHeight, offsetY) {
        this.x = clickPointX - offsetX > elementWidth / 2 ? 0 : elementWidth;
        this.y = clickPointY - offsetY > elementHeight / 2 ? 0 : elementHeight;
        this.z = Math.hypot(
          this.x - (clickPointX - offsetX),
          this.y - (clickPointY - offsetY)
        );
        return this.z;
      }
      appyStyles(element, color, rect, radius, event) {
        element.classList.add("ripple");
        element.style.backgroundColor = color === "dark" ? "rgba(0,0,0, 0.2)" : "rgba(255,255,255, 0.3)";
        element.style.borderRadius = "50%";
        element.style.pointerEvents = "none";
        element.style.position = "absolute";
        element.style.left = event.clientX - rect.left - radius + "px";
        element.style.top = event.clientY - rect.top - radius + "px";
        element.style.width = element.style.height = radius * 2 + "px";
      }
      applyAnimation(element) {
        element.animate(
          [
            {
              transform: "scale(0)",
              opacity: 1
            },
            {
              transform: "scale(1.5)",
              opacity: 0
            }
          ],
          {
            duration: 500,
            easing: "linear"
          }
        );
      }
      create(event, color) {
        const element = event.currentTarget;
        element.style.position = "relative";
        element.style.overflow = "hidden";
        const rect = element.getBoundingClientRect();
        const radius = this.findFurthestPoint(
          event.clientX,
          element.offsetWidth,
          rect.left,
          event.clientY,
          element.offsetHeight,
          rect.top
        );
        const circle = document.createElement("span");
        this.appyStyles(circle, color, rect, radius, event);
        this.applyAnimation(circle);
        element.appendChild(circle);
        setTimeout(() => circle.remove(), 500);
      }
    };
  }
});

// node_modules/@material-tailwind/react/components/IconButton/index.js
var require_IconButton = __commonJS({
  "node_modules/@material-tailwind/react/components/IconButton/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { IconButton: function() {
      return IconButton;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _materialRippleEffects = _interopRequireDefault(require_material_ripple_effects());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _button = require_button();
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var IconButton = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, size3 = _param.size, color = _param.color, ripple = _param.ripple, className = _param.className, children = _param.children, fullWidth = _param.fullWidth, rest = _objectWithoutProperties(_param, ["variant", "size", "color", "ripple", "className", "children", "fullWidth"]);
      var iconButton = (0, _theme.useTheme)().iconButton;
      var valid = iconButton.valid, defaultProps = iconButton.defaultProps, styles = iconButton.styles;
      var base = styles.base, variants = styles.variants, sizes = styles.sizes;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      size3 = size3 !== null && size3 !== void 0 ? size3 : defaultProps.size;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      ripple = ripple !== null && ripple !== void 0 ? ripple : defaultProps.ripple;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var rippleEffect = ripple !== void 0 && new _materialRippleEffects.default();
      var buttonBase = (0, _objectsToString.default)(base);
      var buttonVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "gray")]);
      var buttonSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(buttonBase, buttonSize, buttonVariant), className);
      return _react.default.createElement("button", _extends2({}, rest, { ref, className: classes, type: rest.type || "button", onMouseDown: function(e) {
        var onMouseDown = rest === null || rest === void 0 ? void 0 : rest.onMouseDown;
        if (ripple) {
          rippleEffect.create(e, (variant === "filled" || variant === "gradient") && color !== "white" ? "light" : "dark");
        }
        return typeof onMouseDown === "function" && onMouseDown(e);
      } }), _react.default.createElement("span", { className: "absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 transform" }, children));
    });
    IconButton.propTypes = { variant: _propTypes.default.oneOf(_button.propTypesVariant), size: _propTypes.default.oneOf(_button.propTypesSize), color: _propTypes.default.oneOf(_button.propTypesColor), ripple: _button.propTypesRipple, className: _button.propTypesClassName, children: _button.propTypesChildren };
    IconButton.displayName = "MaterialTailwind.IconButton";
    var _default = IconButton;
  }
});

// node_modules/@material-tailwind/react/components/Alert/index.js
var require_Alert = __commonJS({
  "node_modules/@material-tailwind/react/components/Alert/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Alert: function() {
      return Alert;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _framerMotion = require_cjs2();
    var _classnames = _interopRequireDefault(require_classnames());
    var _deepmerge = _interopRequireDefault(require_cjs());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _alert = require_alert();
    var _iconButton = _interopRequireDefault(require_IconButton());
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Alert = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, color = _param.color, icon = _param.icon, open = _param.open, action = _param.action, onClose = _param.onClose, animate2 = _param.animate, className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["variant", "color", "icon", "open", "action", "onClose", "animate", "className", "children"]);
      var alert = (0, _theme.useTheme)().alert;
      var defaultProps = alert.defaultProps, valid = alert.valid, styles = alert.styles;
      var base = styles.base, variants = styles.variants;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      animate2 = animate2 !== null && animate2 !== void 0 ? animate2 : defaultProps.animate;
      open = open !== null && open !== void 0 ? open : defaultProps.open;
      action = action !== null && action !== void 0 ? action : defaultProps.action;
      onClose = onClose !== null && onClose !== void 0 ? onClose : defaultProps.onClose;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var alertBase = (0, _objectsToString.default)(base.alert);
      var alertAction = (0, _objectsToString.default)(base.action);
      var alertVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "gray")]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(alertBase, alertVariant), className);
      var actionClasses = (0, _classnames.default)(alertAction);
      var mainAnimation = { unmount: { opacity: 0 }, mount: { opacity: 1 } };
      var appliedAnimation = (0, _deepmerge.default)(mainAnimation, animate2);
      var iconTemplate = _react.default.createElement("div", { className: "shrink-0" }, icon);
      var NewAnimatePresence = _framerMotion.AnimatePresence;
      return _react.default.createElement(_framerMotion.LazyMotion, { features: _framerMotion.domAnimation }, _react.default.createElement(NewAnimatePresence, null, open && _react.default.createElement(_framerMotion.m.div, _extends2({}, rest, { ref, role: "alert", className: "".concat(classes, " flex"), initial: "unmount", exit: "unmount", animate: open ? "mount" : "unmount", variants: appliedAnimation }), icon && iconTemplate, _react.default.createElement("div", { className: "".concat(icon ? "ml-3" : "", " mr-12") }, children), onClose && !action && _react.default.createElement(_iconButton.default, { onClick: onClose, size: "sm", variant: "text", color: variant === "outlined" || variant === "ghost" ? color : "white", className: actionClasses }, _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", stroke: "currentColor", className: "h-6 w-6", strokeWidth: 2 }, _react.default.createElement("path", { strokeLinecap: "round", strokeLinejoin: "round", d: "M6 18L18 6M6 6l12 12" }))), action || null)));
    });
    Alert.propTypes = { variant: _propTypes.default.oneOf(_alert.propTypesVariant), color: _propTypes.default.oneOf(_alert.propTypesColor), icon: _alert.propTypesIcon, open: _alert.propTypesOpen, action: _alert.propTypesAction, onClose: _alert.propTypesOnClose, animate: _alert.propTypesAnimate, className: _alert.propTypesClassName, children: _alert.propTypesChildren };
    Alert.displayName = "MaterialTailwind.Alert";
    var _default = Alert;
  }
});

// node_modules/@material-tailwind/react/components/Avatar/index.js
var require_Avatar = __commonJS({
  "node_modules/@material-tailwind/react/components/Avatar/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Avatar: function() {
      return Avatar;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _avatar = require_avatar();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Avatar = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, size3 = _param.size, className = _param.className, color = _param.color, withBorder = _param.withBorder, rest = _objectWithoutProperties(_param, ["variant", "size", "className", "color", "withBorder"]);
      var avatar = (0, _theme.useTheme)().avatar;
      var valid = avatar.valid, defaultProps = avatar.defaultProps, styles = avatar.styles;
      var base = styles.base, variants = styles.variants, sizes = styles.sizes, borderColor = styles.borderColor;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      size3 = size3 !== null && size3 !== void 0 ? size3 : defaultProps.size;
      withBorder = withBorder !== null && withBorder !== void 0 ? withBorder : defaultProps.withBorder;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var avatarVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "rounded")]);
      var avatarSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]);
      var avatarBorderColor = (0, _objectsToString.default)(borderColor[(0, _findMatch.default)(valid.colors, color, "gray")]);
      var _obj;
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.initial), avatarVariant, avatarSize, (_obj = {}, _defineProperty(_obj, (0, _objectsToString.default)(base.withBorder), withBorder), _defineProperty(_obj, avatarBorderColor, withBorder), _obj)), className);
      return _react.default.createElement("img", _extends2({}, rest, { ref, className: classes }));
    });
    Avatar.propTypes = { variant: _propTypes.default.oneOf(_avatar.propTypesVariant), size: _propTypes.default.oneOf(_avatar.propTypesSize), className: _avatar.propTypesClassName, withBorder: _avatar.propTypesWithBorder, color: _propTypes.default.oneOf(_avatar.propTypesColor) };
    Avatar.displayName = "MaterialTailwind.Avatar";
    var _default = Avatar;
  }
});

// node_modules/@material-tailwind/react/types/components/breadcrumbs.js
var require_breadcrumbs2 = __commonJS({
  "node_modules/@material-tailwind/react/types/components/breadcrumbs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { propTypesSeparator: function() {
      return propTypesSeparator;
    }, propTypesFullWidth: function() {
      return propTypesFullWidth;
    }, propTypesClassName: function() {
      return propTypesClassName;
    }, propTypesChildren: function() {
      return propTypesChildren;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var propTypesSeparator = _propTypes.default.node;
    var propTypesFullWidth = _propTypes.default.bool;
    var propTypesClassName = _propTypes.default.string;
    var propTypesChildren = _propTypes.default.node.isRequired;
  }
});

// node_modules/@material-tailwind/react/components/Breadcrumbs/index.js
var require_Breadcrumbs = __commonJS({
  "node_modules/@material-tailwind/react/components/Breadcrumbs/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Breadcrumbs: function() {
      return Breadcrumbs;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireWildcard(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _breadcrumbs = require_breadcrumbs2();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Breadcrumbs = (0, _react.forwardRef)(function(_param, ref) {
      var separator = _param.separator, fullWidth = _param.fullWidth, className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["separator", "fullWidth", "className", "children"]);
      var breadcrumbs = (0, _theme.useTheme)().breadcrumbs;
      var defaultProps = breadcrumbs.defaultProps, base = breadcrumbs.styles.base;
      separator = separator !== null && separator !== void 0 ? separator : defaultProps.separator;
      fullWidth = fullWidth !== null && fullWidth !== void 0 ? fullWidth : defaultProps.fullWidth;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var breadcrumbsRootClasses = (0, _classnames.default)((0, _objectsToString.default)(base.root.initial), _defineProperty({}, (0, _objectsToString.default)(base.root.fullWidth), fullWidth));
      var breadcrumbsListClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.list)), className);
      var breadcrumbsItemClasses = (0, _classnames.default)((0, _objectsToString.default)(base.item.initial));
      var breadcrumbsSeparatorClasses = (0, _classnames.default)((0, _objectsToString.default)(base.separator));
      return _react.default.createElement("nav", { "aria-label": "breadcrumb", className: breadcrumbsRootClasses }, _react.default.createElement("ol", _extends2({}, rest, { ref, className: breadcrumbsListClasses }), _react.Children.map(children, function(child, index4) {
        if ((0, _react.isValidElement)(child)) {
          var _child_props;
          return _react.default.createElement("li", { className: (0, _classnames.default)(breadcrumbsItemClasses, _defineProperty({}, (0, _objectsToString.default)(base.item.disabled), child === null || child === void 0 ? void 0 : (_child_props = child.props) === null || _child_props === void 0 ? void 0 : _child_props.disabled)) }, child, index4 !== _react.Children.count(children) - 1 && _react.default.createElement("span", { className: breadcrumbsSeparatorClasses }, separator));
        }
        return null;
      })));
    });
    Breadcrumbs.propTypes = { separator: _breadcrumbs.propTypesSeparator, fullWidth: _breadcrumbs.propTypesFullWidth, className: _breadcrumbs.propTypesClassName, children: _breadcrumbs.propTypesChildren };
    Breadcrumbs.displayName = "MaterialTailwind.Breadcrumbs";
    var _default = Breadcrumbs;
  }
});

// node_modules/@material-tailwind/react/components/Spinner/index.js
var require_Spinner = __commonJS({
  "node_modules/@material-tailwind/react/components/Spinner/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Spinner: function() {
      return Spinner;
    }, default: function() {
      return _default;
    } });
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _react = _interopRequireWildcard(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _spinner = require_spinner();
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Spinner = (0, _react.forwardRef)(function(_param, ref) {
      var color = _param.color, className = _param.className, rest = _objectWithoutProperties(_param, ["color", "className"]);
      var spinner = (0, _theme.useTheme)().spinner;
      var defaultProps = spinner.defaultProps, valid = spinner.valid, _spinner_styles = spinner.styles, base = _spinner_styles.base, colors = _spinner_styles.colors;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var spinnerColor = (0, _objectsToString.default)(colors[(0, _findMatch.default)(valid.colors, color, "gray")]);
      var spinnerClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base)), className);
      var _rest_width, _rest_height;
      return _react.default.createElement("svg", _extends2({}, rest, { ref, className: spinnerClasses, viewBox: "0 0 64 64", fill: "none", xmlns: "http://www.w3.org/2000/svg", width: (_rest_width = rest === null || rest === void 0 ? void 0 : rest.width) !== null && _rest_width !== void 0 ? _rest_width : 24, height: (_rest_height = rest === null || rest === void 0 ? void 0 : rest.height) !== null && _rest_height !== void 0 ? _rest_height : 24 }), _react.default.createElement("path", { d: "M32 3C35.8083 3 39.5794 3.75011 43.0978 5.20749C46.6163 6.66488 49.8132 8.80101 52.5061 11.4939C55.199 14.1868 57.3351 17.3837 58.7925 20.9022C60.2499 24.4206 61 28.1917 61 32C61 35.8083 60.2499 39.5794 58.7925 43.0978C57.3351 46.6163 55.199 49.8132 52.5061 52.5061C49.8132 55.199 46.6163 57.3351 43.0978 58.7925C39.5794 60.2499 35.8083 61 32 61C28.1917 61 24.4206 60.2499 20.9022 58.7925C17.3837 57.3351 14.1868 55.199 11.4939 52.5061C8.801 49.8132 6.66487 46.6163 5.20749 43.0978C3.7501 39.5794 3 35.8083 3 32C3 28.1917 3.75011 24.4206 5.2075 20.9022C6.66489 17.3837 8.80101 14.1868 11.4939 11.4939C14.1868 8.80099 17.3838 6.66487 20.9022 5.20749C24.4206 3.7501 28.1917 3 32 3L32 3Z", stroke: "currentColor", strokeWidth: "5", strokeLinecap: "round", strokeLinejoin: "round" }), _react.default.createElement("path", { d: "M32 3C36.5778 3 41.0906 4.08374 45.1692 6.16256C49.2477 8.24138 52.7762 11.2562 55.466 14.9605C58.1558 18.6647 59.9304 22.9531 60.6448 27.4748C61.3591 31.9965 60.9928 36.6232 59.5759 40.9762", stroke: "currentColor", strokeWidth: "5", strokeLinecap: "round", strokeLinejoin: "round", className: spinnerColor }));
    });
    Spinner.propTypes = { color: _propTypes.default.oneOf(_spinner.propTypesColor), className: _spinner.propTypesClassName };
    Spinner.displayName = "MaterialTailwind.Spinner";
    var _default = Spinner;
  }
});

// node_modules/@material-tailwind/react/components/Button/index.js
var require_Button = __commonJS({
  "node_modules/@material-tailwind/react/components/Button/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Button: function() {
      return Button;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _materialRippleEffects = _interopRequireDefault(require_material_ripple_effects());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _spinner = _interopRequireDefault(require_Spinner());
    var _button = require_button();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Button = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, size3 = _param.size, color = _param.color, fullWidth = _param.fullWidth, ripple = _param.ripple, className = _param.className, children = _param.children, loading = _param.loading, rest = _objectWithoutProperties(_param, ["variant", "size", "color", "fullWidth", "ripple", "className", "children", "loading"]);
      var button = (0, _theme.useTheme)().button;
      var valid = button.valid, defaultProps = button.defaultProps, styles = button.styles;
      var base = styles.base, variants = styles.variants, sizes = styles.sizes;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      size3 = size3 !== null && size3 !== void 0 ? size3 : defaultProps.size;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      fullWidth = fullWidth !== null && fullWidth !== void 0 ? fullWidth : defaultProps.fullWidth;
      ripple = ripple !== null && ripple !== void 0 ? ripple : defaultProps.ripple;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var rippleEffect = ripple !== void 0 && new _materialRippleEffects.default();
      var buttonBase = (0, _objectsToString.default)(base.initial);
      var buttonVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "gray")]);
      var buttonSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(buttonBase, buttonSize, buttonVariant, _defineProperty({}, (0, _objectsToString.default)(base.fullWidth), fullWidth), { "flex items-center gap-2": loading, "gap-3": size3 === "lg" }), className);
      var spinnerClass = (0, _tailwindMerge.twMerge)((0, _classnames.default)({ "w-4 h-4": true, "w-5 h-5": size3 === "lg" }));
      var _rest_disabled;
      return _react.default.createElement("button", _extends2({}, rest, { disabled: (_rest_disabled = rest.disabled) !== null && _rest_disabled !== void 0 ? _rest_disabled : loading, ref, className: classes, type: rest.type || "button", onMouseDown: function(e) {
        var onMouseDown = rest === null || rest === void 0 ? void 0 : rest.onMouseDown;
        if (ripple) {
          rippleEffect.create(e, (variant === "filled" || variant === "gradient") && color !== "white" ? "light" : "dark");
        }
        return typeof onMouseDown === "function" && onMouseDown(e);
      } }), loading && _react.default.createElement(_spinner.default, { className: spinnerClass }), children);
    });
    Button.propTypes = { variant: _propTypes.default.oneOf(_button.propTypesVariant), size: _propTypes.default.oneOf(_button.propTypesSize), color: _propTypes.default.oneOf(_button.propTypesColor), fullWidth: _button.propTypesFullWidth, ripple: _button.propTypesRipple, className: _button.propTypesClassName, children: _button.propTypesChildren, loading: _button.propTypesLoading };
    Button.displayName = "MaterialTailwind.Button";
    var _default = Button;
  }
});

// node_modules/@material-tailwind/react/components/Card/CardHeader.js
var require_CardHeader = __commonJS({
  "node_modules/@material-tailwind/react/components/Card/CardHeader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { CardHeader: function() {
      return CardHeader;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _card = require_card();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var CardHeader = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, color = _param.color, shadow = _param.shadow, floated = _param.floated, className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["variant", "color", "shadow", "floated", "className", "children"]);
      var cardHeader = (0, _theme.useTheme)().cardHeader;
      var defaultProps = cardHeader.defaultProps, styles = cardHeader.styles, valid = cardHeader.valid;
      var base = styles.base, variants = styles.variants;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      shadow = shadow !== null && shadow !== void 0 ? shadow : defaultProps.shadow;
      floated = floated !== null && floated !== void 0 ? floated : defaultProps.floated;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var cardHeaderRoot = (0, _objectsToString.default)(base.initial);
      var cardHeaderVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "white")]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(cardHeaderRoot, cardHeaderVariant, _defineProperty({}, (0, _objectsToString.default)(base.shadow), shadow), _defineProperty({}, (0, _objectsToString.default)(base.floated), floated)), className);
      return _react.default.createElement("div", _extends2({}, rest, { ref, className: classes }), children);
    });
    CardHeader.propTypes = { variant: _propTypes.default.oneOf(_card.propTypesVariant), color: _propTypes.default.oneOf(_card.propTypesColor), shadow: _card.propTypesShadow, floated: _card.propTypesFloated, className: _card.propTypesClassName, children: _card.propTypesChildren };
    CardHeader.displayName = "MaterialTailwind.CardHeader";
    var _default = CardHeader;
  }
});

// node_modules/@material-tailwind/react/components/Card/CardBody.js
var require_CardBody = __commonJS({
  "node_modules/@material-tailwind/react/components/Card/CardBody.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { CardBody: function() {
      return CardBody;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _card = require_card();
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var CardBody = _react.default.forwardRef(function(_param, ref) {
      var className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["className", "children"]);
      var cardBody = (0, _theme.useTheme)().cardBody;
      var defaultProps = cardBody.defaultProps, base = cardBody.styles.base;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var cardBodyClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base)), className);
      return _react.default.createElement("div", _extends2({}, rest, { ref, className: cardBodyClasses }), children);
    });
    CardBody.propTypes = { className: _card.propTypesClassName, children: _card.propTypesChildren };
    CardBody.displayName = "MaterialTailwind.CardBody";
    var _default = CardBody;
  }
});

// node_modules/@material-tailwind/react/components/Card/CardFooter.js
var require_CardFooter = __commonJS({
  "node_modules/@material-tailwind/react/components/Card/CardFooter.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { CardFooter: function() {
      return CardFooter;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _card = require_card();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var CardFooter = _react.default.forwardRef(function(_param, ref) {
      var divider = _param.divider, className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["divider", "className", "children"]);
      var cardFooter = (0, _theme.useTheme)().cardFooter;
      var defaultProps = cardFooter.defaultProps, base = cardFooter.styles.base;
      divider = divider !== null && divider !== void 0 ? divider : defaultProps.divider;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var cardFooterClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.initial), _defineProperty({}, (0, _objectsToString.default)(base.divider), divider)), className);
      return _react.default.createElement("div", _extends2({}, rest, { ref, className: cardFooterClasses }), children);
    });
    CardFooter.propTypes = { divider: _card.propTypesDivider, className: _card.propTypesClassName, children: _card.propTypesChildren };
    CardFooter.displayName = "MaterialTailwind.CardFooter";
    var _default = CardFooter;
  }
});

// node_modules/@material-tailwind/react/components/Card/index.js
var require_Card = __commonJS({
  "node_modules/@material-tailwind/react/components/Card/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Card: function() {
      return Card;
    }, CardHeader: function() {
      return _cardHeader.CardHeader;
    }, CardBody: function() {
      return _cardBody.CardBody;
    }, CardFooter: function() {
      return _cardFooter.CardFooter;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _cardHeader = require_CardHeader();
    var _cardBody = require_CardBody();
    var _cardFooter = require_CardFooter();
    var _card = require_card();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Card = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, color = _param.color, shadow = _param.shadow, className = _param.className, children = _param.children, rest = _objectWithoutProperties(_param, ["variant", "color", "shadow", "className", "children"]);
      var card = (0, _theme.useTheme)().card;
      var defaultProps = card.defaultProps, styles = card.styles, valid = card.valid;
      var base = styles.base, variants = styles.variants;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      shadow = shadow !== null && shadow !== void 0 ? shadow : defaultProps.shadow;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var cardRoot = (0, _objectsToString.default)(base.initial);
      var cardVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "white")]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(cardRoot, cardVariant, _defineProperty({}, (0, _objectsToString.default)(base.shadow), shadow)), className);
      return _react.default.createElement("div", _extends2({}, rest, { ref, className: classes }), children);
    });
    Card.propTypes = { variant: _propTypes.default.oneOf(_card.propTypesVariant), color: _propTypes.default.oneOf(_card.propTypesColor), shadow: _card.propTypesShadow, className: _card.propTypesClassName, children: _card.propTypesChildren };
    Card.displayName = "MaterialTailwind.Card";
    var _default = Object.assign(Card, { Header: _cardHeader.CardHeader, Body: _cardBody.CardBody, Footer: _cardFooter.CardFooter });
  }
});

// node_modules/@material-tailwind/react/components/Checkbox/index.js
var require_Checkbox = __commonJS({
  "node_modules/@material-tailwind/react/components/Checkbox/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Checkbox: function() {
      return Checkbox;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _materialRippleEffects = _interopRequireDefault(require_material_ripple_effects());
    var _classnames = _interopRequireDefault(require_classnames());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _checkbox = require_checkbox();
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Checkbox = _react.default.forwardRef(function(_param, ref) {
      var color = _param.color, label = _param.label, icon = _param.icon, ripple = _param.ripple, className = _param.className, disabled = _param.disabled, containerProps = _param.containerProps, labelProps = _param.labelProps, iconProps = _param.iconProps, inputRef = _param.inputRef, rest = _objectWithoutProperties(_param, ["color", "label", "icon", "ripple", "className", "disabled", "containerProps", "labelProps", "iconProps", "inputRef"]);
      var checkbox = (0, _theme.useTheme)().checkbox;
      var defaultProps = checkbox.defaultProps, valid = checkbox.valid, styles = checkbox.styles;
      var base = styles.base, colors = styles.colors;
      var checkboxId = _react.default.useId();
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      label = label !== null && label !== void 0 ? label : defaultProps.label;
      icon = icon !== null && icon !== void 0 ? icon : defaultProps.icon;
      ripple = ripple !== null && ripple !== void 0 ? ripple : defaultProps.ripple;
      disabled = disabled !== null && disabled !== void 0 ? disabled : defaultProps.disabled;
      containerProps = containerProps !== null && containerProps !== void 0 ? containerProps : defaultProps.containerProps;
      labelProps = labelProps !== null && labelProps !== void 0 ? labelProps : defaultProps.labelProps;
      iconProps = iconProps !== null && iconProps !== void 0 ? iconProps : defaultProps.iconProps;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var rippleEffect = ripple !== void 0 && new _materialRippleEffects.default();
      var rootClasses = (0, _classnames.default)((0, _objectsToString.default)(base.root), _defineProperty({}, (0, _objectsToString.default)(base.disabled), disabled));
      var containerClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.container)), containerProps === null || containerProps === void 0 ? void 0 : containerProps.className);
      var inputClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.input), (0, _objectsToString.default)(colors[(0, _findMatch.default)(valid.colors, color, "gray")])), className);
      var labelClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.label)), labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
      var iconContainerClasses = (0, _tailwindMerge.twMerge)((0, _classnames.default)((0, _objectsToString.default)(base.icon)), iconProps === null || iconProps === void 0 ? void 0 : iconProps.className);
      return _react.default.createElement("div", { ref, className: rootClasses }, _react.default.createElement("label", _extends2({}, containerProps, { className: containerClasses, htmlFor: rest.id || checkboxId, onMouseDown: function(e) {
        var onMouseDown = containerProps === null || containerProps === void 0 ? void 0 : containerProps.onMouseDown;
        if (ripple) {
          rippleEffect.create(e, "dark");
        }
        return typeof onMouseDown === "function" && onMouseDown(e);
      } }), _react.default.createElement("input", _extends2({}, rest, { ref: inputRef, type: "checkbox", disabled, className: inputClasses, id: rest.id || checkboxId })), _react.default.createElement("span", { className: iconContainerClasses }, icon || _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", className: "h-3.5 w-3.5", viewBox: "0 0 20 20", fill: "currentColor", stroke: "currentColor", strokeWidth: 1 }, _react.default.createElement("path", { fillRule: "evenodd", d: "M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z", clipRule: "evenodd" })))), label && _react.default.createElement("label", _extends2({}, labelProps, { className: labelClasses, htmlFor: rest.id || checkboxId }), label));
    });
    Checkbox.propTypes = { color: _propTypes.default.oneOf(_checkbox.propTypesColor), label: _checkbox.propTypesLabel, icon: _checkbox.propTypesIcon, ripple: _checkbox.propTypesRipple, className: _checkbox.propTypesClassName, disabled: _checkbox.propTypesDisabled, containerProps: _checkbox.propTypesObject, labelProps: _checkbox.propTypesObject };
    Checkbox.displayName = "MaterialTailwind.Checkbox";
    var _default = Checkbox;
  }
});

// node_modules/@material-tailwind/react/components/Chip/index.js
var require_Chip = __commonJS({
  "node_modules/@material-tailwind/react/components/Chip/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, { enumerable: true, get: all[name] });
    }
    _export(exports, { Chip: function() {
      return Chip;
    }, default: function() {
      return _default;
    } });
    var _react = _interopRequireDefault(require_react());
    var _propTypes = _interopRequireDefault(require_prop_types());
    var _framerMotion = require_cjs2();
    var _classnames = _interopRequireDefault(require_classnames());
    var _deepmerge = _interopRequireDefault(require_cjs());
    var _tailwindMerge = require_dist();
    var _findMatch = _interopRequireDefault(require_findMatch());
    var _objectsToString = _interopRequireDefault(require_objectsToString());
    var _theme = require_theme2();
    var _chip = require_chip();
    var _iconButton = _interopRequireDefault(require_IconButton());
    function _extends2() {
      _extends2 = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      return _extends2.apply(this, arguments);
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _objectWithoutProperties(source, excluded) {
      if (source == null)
        return {};
      var target = _objectWithoutPropertiesLoose(source, excluded);
      var key, i;
      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0)
            continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key))
            continue;
          target[key] = source[key];
        }
      }
      return target;
    }
    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null)
        return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;
      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0)
          continue;
        target[key] = source[key];
      }
      return target;
    }
    var Chip = _react.default.forwardRef(function(_param, ref) {
      var variant = _param.variant, size3 = _param.size, color = _param.color, icon = _param.icon, open = _param.open, onClose = _param.onClose, action = _param.action, animate2 = _param.animate, className = _param.className, value = _param.value, rest = _objectWithoutProperties(_param, ["variant", "size", "color", "icon", "open", "onClose", "action", "animate", "className", "value"]);
      var chip = (0, _theme.useTheme)().chip;
      var defaultProps = chip.defaultProps, valid = chip.valid, styles = chip.styles;
      var base = styles.base, variants = styles.variants, sizes = styles.sizes;
      variant = variant !== null && variant !== void 0 ? variant : defaultProps.variant;
      size3 = size3 !== null && size3 !== void 0 ? size3 : defaultProps.size;
      color = color !== null && color !== void 0 ? color : defaultProps.color;
      animate2 = animate2 !== null && animate2 !== void 0 ? animate2 : defaultProps.animate;
      open = open !== null && open !== void 0 ? open : defaultProps.open;
      action = action !== null && action !== void 0 ? action : defaultProps.action;
      onClose = onClose !== null && onClose !== void 0 ? onClose : defaultProps.onClose;
      className = (0, _tailwindMerge.twMerge)(defaultProps.className || "", className);
      var chipBase = (0, _objectsToString.default)(base.chip);
      var chipAction = (0, _objectsToString.default)(base.action);
      var chipIcon = (0, _objectsToString.default)(base.icon);
      var chipVariant = (0, _objectsToString.default)(variants[(0, _findMatch.default)(valid.variants, variant, "filled")][(0, _findMatch.default)(valid.colors, color, "gray")]);
      var chipSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]["chip"]);
      var actionSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]["action"]);
      var iconSize = (0, _objectsToString.default)(sizes[(0, _findMatch.default)(valid.sizes, size3, "md")]["icon"]);
      var classes = (0, _tailwindMerge.twMerge)((0, _classnames.default)(chipBase, chipVariant, chipSize), className);
      var actionClasses = (0, _classnames.default)(chipAction, actionSize);
      var iconClasses = (0, _classnames.default)(chipIcon, iconSize);
      var contentClasses = (0, _classnames.default)({ "ml-4": icon && size3 === "sm", "ml-[18px]": icon && size3 === "md", "ml-5": icon && size3 === "lg", "mr-5": onClose });
      var mainAnimation = { unmount: { opacity: 0 }, mount: { opacity: 1 } };
      var appliedAnimation = (0, _deepmerge.default)(mainAnimation, animate2);
      var iconTemplate = _react.default.createElement("div", { className: iconClasses }, icon);
      var NewAnimatePresence = _framerMotion.AnimatePresence;
      return _react.default.createElement(_framerMotion.LazyMotion, { features: _framerMotion.domAnimation }, _react.default.createElement(NewAnimatePresence, null, open && _react.default.createElement(_framerMotion.m.div, _extends2({}, rest, { ref, className: classes, initial: "unmount", exit: "unmount", animate: open ? "mount" : "unmount", variants: appliedAnimation }), icon && iconTemplate, _react.default.createElement("span", { className: contentClasses }, value), onClose && !action && _react.default.createElement(_iconButton.default, { onClick: onClose, size: "sm", variant: "text", color: variant === "outlined" || variant === "ghost" ? color : "white", className: actionClasses }, _react.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", stroke: "currentColor", className: (0, _classnames.default)({ "h-3.5 w-3.5": size3 === "sm", "h-4 w-4": size3 === "md", "h-5 w-5": size3 === "lg" }), strokeWidth: 2 }, _react.default.createElement("path", { strokeLinecap: "round", strokeLinejoin: "round", d: "M6 18L18 6M6 6l12 12" }))), action || null)));
    });
    Chip.propTypes = { variant: _propTypes.default.oneOf(_chip.propTypesVariant), size: _propTypes.default.oneOf(_chip.propTypesSize), color: _propTypes.default.oneOf(_chip.propTypesColor), icon: _chip.propTypesIcon, open: _chip.propTypesOpen, onClose: _chip.propTypesOnClose, action: _chip.propTypesAction, animate: _chip.propTypesAnimate, className: _chip.propTypesClassName, value: _chip.propTypesValue };
    Chip.displayName = "MaterialTailwind.Chip";
    var _default = Chip;
  }
});

// node_modules/aria-hidden/dist/es2015/index.js
var getDefaultParent, counterMap, uncontrolledNodes, markerMap, lockCount, unwrapHost, correctTargets, applyAttributeToOthers, hideOthers;
var init_es2015 = __esm({
  "node_modules/aria-hidden/dist/es2015/index.js"() {
    getDefaultParent = function(originalTarget) {
      if (typeof document === "undefined") {
        return null;
      }
      var sampleTarget = Array.isArray(originalTarget) ? originalTarget[0] : originalTarget;
      return sampleTarget.ownerDocument.body;
    };
    counterMap = /* @__PURE__ */ new WeakMap();
    uncontrolledNodes = /* @__PURE__ */ new WeakMap();
    markerMap = {};
    lockCount = 0;
    unwrapHost = function(node) {
      return node && (node.host || unwrapHost(node.parentNode));
    };
    correctTargets = function(parent, targets) {
      return targets.map(function(target) {
        if (parent.contains(target)) {
          return target;
        }
        var correctedTarget = unwrapHost(target);
        if (correctedTarget && parent.contains(correctedTarget)) {
          return correctedTarget;
        }
        console.error("aria-hidden", target, "in not contained inside", parent, ". Doing nothing");
        return null;
      }).filter(function(x) {
        return Boolean(x);
      });
    };
    applyAttributeToOthers = function(originalTarget, parentNode, markerName, controlAttribute) {
      var targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
      if (!markerMap[markerName]) {
        markerMap[markerName] = /* @__PURE__ */ new WeakMap();
      }
      var markerCounter = markerMap[markerName];
      var hiddenNodes = [];
      var elementsToKeep = /* @__PURE__ */ new Set();
      var elementsToStop = new Set(targets);
      var keep = function(el) {
        if (!el || elementsToKeep.has(el)) {
          return;
        }
        elementsToKeep.add(el);
        keep(el.parentNode);
      };
      targets.forEach(keep);
      var deep = function(parent) {
        if (!parent || elementsToStop.has(parent)) {
          return;
        }
        Array.prototype.forEach.call(parent.children, function(node) {
          if (elementsToKeep.has(node)) {
            deep(node);
          } else {
            try {
              var attr = node.getAttribute(controlAttribute);
              var alreadyHidden = attr !== null && attr !== "false";
              var counterValue = (counterMap.get(node) || 0) + 1;
              var markerValue = (markerCounter.get(node) || 0) + 1;
              counterMap.set(node, counterValue);
              markerCounter.set(node, markerValue);
              hiddenNodes.push(node);
              if (counterValue === 1 && alreadyHidden) {
                uncontrolledNodes.set(node, true);
              }
              if (markerValue === 1) {
                node.setAttribute(markerName, "true");
              }
              if (!alreadyHidden) {
                node.setAttribute(controlAttribute, "true");
              }
            } catch (e) {
              console.error("aria-hidden: cannot operate on ", node, e);
            }
          }
        });
      };
      deep(parentNode);
      elementsToKeep.clear();
      lockCount++;
      return function() {
        hiddenNodes.forEach(function(node) {
          var counterValue = counterMap.get(node) - 1;
          var markerValue = markerCounter.get(node) - 1;
          counterMap.set(node, counterValue);
          markerCounter.set(node, markerValue);
          if (!counterValue) {
            if (!uncontrolledNodes.has(node)) {
              node.removeAttribute(controlAttribute);
            }
            uncontrolledNodes.delete(node);
          }
          if (!markerValue) {
            node.removeAttribute(markerName);
          }
        });
        lockCount--;
        if (!lockCount) {
          counterMap = /* @__PURE__ */ new WeakMap();
          counterMap = /* @__PURE__ */ new WeakMap();
          uncontrolledNodes = /* @__PURE__ */ new WeakMap();
          markerMap = {};
        }
      };
    };
    hideOthers = function(originalTarget, parentNode, markerName) {
      if (markerName === void 0) {
        markerName = "data-aria-hidden";
      }
      var targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
      var activeParentNode = parentNode || getDefaultParent(originalTarget);
      if (!activeParentNode) {
        return function() {
          return null;
        };
      }
      targets.push.apply(targets, Array.from(activeParentNode.querySelectorAll("[aria-live]")));
      return applyAttributeToOthers(targets, activeParentNode, markerName, "aria-hidden");
    };
  }
});

// node_modules/tabbable/dist/index.esm.js
var candidateSelectors, candidateSelector, NoElement, matches, getRootNode, isInert, isContentEditable, getCandidates, getCandidatesIteratively, hasTabIndex, getTabIndex, getSortOrderTabIndex, sortOrderedTabbables, isInput, isHiddenInput, isDetailsWithSummary, getCheckedRadio, isTabbableRadio, isRadio, isNonTabbableRadio, isNodeAttached, isZeroArea, isHidden, isDisabledFromFieldset, isNodeMatchingSelectorFocusable, isNodeMatchingSelectorTabbable, isValidShadowRootTabbable, sortByOrder, tabbable, focusableCandidateSelector;
var init_index_esm = __esm({
  "node_modules/tabbable/dist/index.esm.js"() {
    candidateSelectors = ["input:not([inert])", "select:not([inert])", "textarea:not([inert])", "a[href]:not([inert])", "button:not([inert])", "[tabindex]:not(slot):not([inert])", "audio[controls]:not([inert])", "video[controls]:not([inert])", '[contenteditable]:not([contenteditable="false"]):not([inert])', "details>summary:first-of-type:not([inert])", "details:not([inert])"];
    candidateSelector = candidateSelectors.join(",");
    NoElement = typeof Element === "undefined";
    matches = NoElement ? function() {
    } : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
    getRootNode = !NoElement && Element.prototype.getRootNode ? function(element) {
      var _element$getRootNode;
      return element === null || element === void 0 ? void 0 : (_element$getRootNode = element.getRootNode) === null || _element$getRootNode === void 0 ? void 0 : _element$getRootNode.call(element);
    } : function(element) {
      return element === null || element === void 0 ? void 0 : element.ownerDocument;
    };
    isInert = function isInert2(node, lookUp) {
      var _node$getAttribute;
      if (lookUp === void 0) {
        lookUp = true;
      }
      var inertAtt = node === null || node === void 0 ? void 0 : (_node$getAttribute = node.getAttribute) === null || _node$getAttribute === void 0 ? void 0 : _node$getAttribute.call(node, "inert");
      var inert = inertAtt === "" || inertAtt === "true";
      var result = inert || lookUp && node && isInert2(node.parentNode);
      return result;
    };
    isContentEditable = function isContentEditable2(node) {
      var _node$getAttribute2;
      var attValue = node === null || node === void 0 ? void 0 : (_node$getAttribute2 = node.getAttribute) === null || _node$getAttribute2 === void 0 ? void 0 : _node$getAttribute2.call(node, "contenteditable");
      return attValue === "" || attValue === "true";
    };
    getCandidates = function getCandidates2(el, includeContainer, filter) {
      if (isInert(el)) {
        return [];
      }
      var candidates = Array.prototype.slice.apply(el.querySelectorAll(candidateSelector));
      if (includeContainer && matches.call(el, candidateSelector)) {
        candidates.unshift(el);
      }
      candidates = candidates.filter(filter);
      return candidates;
    };
    getCandidatesIteratively = function getCandidatesIteratively2(elements, includeContainer, options) {
      var candidates = [];
      var elementsToCheck = Array.from(elements);
      while (elementsToCheck.length) {
        var element = elementsToCheck.shift();
        if (isInert(element, false)) {
          continue;
        }
        if (element.tagName === "SLOT") {
          var assigned = element.assignedElements();
          var content = assigned.length ? assigned : element.children;
          var nestedCandidates = getCandidatesIteratively2(content, true, options);
          if (options.flatten) {
            candidates.push.apply(candidates, nestedCandidates);
          } else {
            candidates.push({
              scopeParent: element,
              candidates: nestedCandidates
            });
          }
        } else {
          var validCandidate = matches.call(element, candidateSelector);
          if (validCandidate && options.filter(element) && (includeContainer || !elements.includes(element))) {
            candidates.push(element);
          }
          var shadowRoot = element.shadowRoot || // check for an undisclosed shadow
          typeof options.getShadowRoot === "function" && options.getShadowRoot(element);
          var validShadowRoot = !isInert(shadowRoot, false) && (!options.shadowRootFilter || options.shadowRootFilter(element));
          if (shadowRoot && validShadowRoot) {
            var _nestedCandidates = getCandidatesIteratively2(shadowRoot === true ? element.children : shadowRoot.children, true, options);
            if (options.flatten) {
              candidates.push.apply(candidates, _nestedCandidates);
            } else {
              candidates.push({
                scopeParent: element,
                candidates: _nestedCandidates
              });
            }
          } else {
            elementsToCheck.unshift.apply(elementsToCheck, element.children);
          }
        }
      }
      return candidates;
    };
    hasTabIndex = function hasTabIndex2(node) {
      return !isNaN(parseInt(node.getAttribute("tabindex"), 10));
    };
    getTabIndex = function getTabIndex2(node) {
      if (!node) {
        throw new Error("No node provided");
      }
      if (node.tabIndex < 0) {
        if ((/^(AUDIO|VIDEO|DETAILS)$/.test(node.tagName) || isContentEditable(node)) && !hasTabIndex(node)) {
          return 0;
        }
      }
      return node.tabIndex;
    };
    getSortOrderTabIndex = function getSortOrderTabIndex2(node, isScope) {
      var tabIndex = getTabIndex(node);
      if (tabIndex < 0 && isScope && !hasTabIndex(node)) {
        return 0;
      }
      return tabIndex;
    };
    sortOrderedTabbables = function sortOrderedTabbables2(a, b) {
      return a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex;
    };
    isInput = function isInput2(node) {
      return node.tagName === "INPUT";
    };
    isHiddenInput = function isHiddenInput2(node) {
      return isInput(node) && node.type === "hidden";
    };
    isDetailsWithSummary = function isDetailsWithSummary2(node) {
      var r = node.tagName === "DETAILS" && Array.prototype.slice.apply(node.children).some(function(child) {
        return child.tagName === "SUMMARY";
      });
      return r;
    };
    getCheckedRadio = function getCheckedRadio2(nodes, form) {
      for (var i = 0; i < nodes.length; i++) {
        if (nodes[i].checked && nodes[i].form === form) {
          return nodes[i];
        }
      }
    };
    isTabbableRadio = function isTabbableRadio2(node) {
      if (!node.name) {
        return true;
      }
      var radioScope = node.form || getRootNode(node);
      var queryRadios = function queryRadios2(name) {
        return radioScope.querySelectorAll('input[type="radio"][name="' + name + '"]');
      };
      var radioSet;
      if (typeof window !== "undefined" && typeof window.CSS !== "undefined" && typeof window.CSS.escape === "function") {
        radioSet = queryRadios(window.CSS.escape(node.name));
      } else {
        try {
          radioSet = queryRadios(node.name);
        } catch (err) {
          console.error("Looks like you have a radio button with a name attribute containing invalid CSS selector characters and need the CSS.escape polyfill: %s", err.message);
          return false;
        }
      }
      var checked = getCheckedRadio(radioSet, node.form);
      return !checked || checked === node;
    };
    isRadio = function isRadio2(node) {
      return isInput(node) && node.type === "radio";
    };
    isNonTabbableRadio = function isNonTabbableRadio2(node) {
      return isRadio(node) && !isTabbableRadio(node);
    };
    isNodeAttached = function isNodeAttached2(node) {
      var _nodeRoot;
      var nodeRoot = node && getRootNode(node);
      var nodeRootHost = (_nodeRoot = nodeRoot) === null || _nodeRoot === void 0 ? void 0 : _nodeRoot.host;
      var attached = false;
      if (nodeRoot && nodeRoot !== node) {
        var _nodeRootHost, _nodeRootHost$ownerDo, _node$ownerDocument;
        attached = !!((_nodeRootHost = nodeRootHost) !== null && _nodeRootHost !== void 0 && (_nodeRootHost$ownerDo = _nodeRootHost.ownerDocument) !== null && _nodeRootHost$ownerDo !== void 0 && _nodeRootHost$ownerDo.contains(nodeRootHost) || node !== null && node !== void 0 && (_node$ownerDocument = node.ownerDocument) !== null && _node$ownerDocument !== void 0 && _node$ownerDocument.contains(node));
        while (!attached && nodeRootHost) {
          var _nodeRoot2, _nodeRootHost2, _nodeRootHost2$ownerD;
          nodeRoot = getRootNode(nodeRootHost);
          nodeRootHost = (_nodeRoot2 = nodeRoot) === null || _nodeRoot2 === void 0 ? void 0 : _nodeRoot2.host;
          attached = !!((_nodeRootHost2 = nodeRootHost) !== null && _nodeRootHost2 !== void 0 && (_nodeRootHost2$ownerD = _nodeRootHost2.ownerDocument) !== null && _nodeRootHost2$ownerD !== void 0 && _nodeRootHost2$ownerD.contains(nodeRootHost));
        }
      }
      return attached;
    };
    isZeroArea = function isZeroArea2(node) {
      var _node$getBoundingClie = node.getBoundingClientRect(), width = _node$getBoundingClie.width, height = _node$getBoundingClie.height;
      return width === 0 && height === 0;
    };
    isHidden = function isHidden2(node, _ref) {
      var displayCheck = _ref.displayCheck, getShadowRoot = _ref.getShadowRoot;
      if (getComputedStyle(node).visibility === "hidden") {
        return true;
      }
      var isDirectSummary = matches.call(node, "details>summary:first-of-type");
      var nodeUnderDetails = isDirectSummary ? node.parentElement : node;
      if (matches.call(nodeUnderDetails, "details:not([open]) *")) {
        return true;
      }
      if (!displayCheck || displayCheck === "full" || displayCheck === "legacy-full") {
        if (typeof getShadowRoot === "function") {
          var originalNode = node;
          while (node) {
            var parentElement = node.parentElement;
            var rootNode = getRootNode(node);
            if (parentElement && !parentElement.shadowRoot && getShadowRoot(parentElement) === true) {
              return isZeroArea(node);
            } else if (node.assignedSlot) {
              node = node.assignedSlot;
            } else if (!parentElement && rootNode !== node.ownerDocument) {
              node = rootNode.host;
            } else {
              node = parentElement;
            }
          }
          node = originalNode;
        }
        if (isNodeAttached(node)) {
          return !node.getClientRects().length;
        }
        if (displayCheck !== "legacy-full") {
          return true;
        }
      } else if (displayCheck === "non-zero-area") {
        return isZeroArea(node);
      }
      return false;
    };
    isDisabledFromFieldset = function isDisabledFromFieldset2(node) {
      if (/^(INPUT|BUTTON|SELECT|TEXTAREA)$/.test(node.tagName)) {
        var parentNode = node.parentElement;
        while (parentNode) {
          if (parentNode.tagName === "FIELDSET" && parentNode.disabled) {
            for (var i = 0; i < parentNode.children.length; i++) {
              var child = parentNode.children.item(i);
              if (child.tagName === "LEGEND") {
                return matches.call(parentNode, "fieldset[disabled] *") ? true : !child.contains(node);
              }
            }
            return true;
          }
          parentNode = parentNode.parentElement;
        }
      }
      return false;
    };
    isNodeMatchingSelectorFocusable = function isNodeMatchingSelectorFocusable2(options, node) {
      if (node.disabled || // we must do an inert look up to filter out any elements inside an inert ancestor
      //  because we're limited in the type of selectors we can use in JSDom (see related
      //  note related to `candidateSelectors`)
      isInert(node) || isHiddenInput(node) || isHidden(node, options) || // For a details element with a summary, the summary element gets the focus
      isDetailsWithSummary(node) || isDisabledFromFieldset(node)) {
        return false;
      }
      return true;
    };
    isNodeMatchingSelectorTabbable = function isNodeMatchingSelectorTabbable2(options, node) {
      if (isNonTabbableRadio(node) || getTabIndex(node) < 0 || !isNodeMatchingSelectorFocusable(options, node)) {
        return false;
      }
      return true;
    };
    isValidShadowRootTabbable = function isValidShadowRootTabbable2(shadowHostNode) {
      var tabIndex = parseInt(shadowHostNode.getAttribute("tabindex"), 10);
      if (isNaN(tabIndex) || tabIndex >= 0) {
        return true;
      }
      return false;
    };
    sortByOrder = function sortByOrder2(candidates) {
      var regularTabbables = [];
      var orderedTabbables = [];
      candidates.forEach(function(item, i) {
        var isScope = !!item.scopeParent;
        var element = isScope ? item.scopeParent : item;
        var candidateTabindex = getSortOrderTabIndex(element, isScope);
        var elements = isScope ? sortByOrder2(item.candidates) : element;
        if (candidateTabindex === 0) {
          isScope ? regularTabbables.push.apply(regularTabbables, elements) : regularTabbables.push(element);
        } else {
          orderedTabbables.push({
            documentOrder: i,
            tabIndex: candidateTabindex,
            item,
            isScope,
            content: elements
          });
        }
      });
      return orderedTabbables.sort(sortOrderedTabbables).reduce(function(acc, sortable) {
        sortable.isScope ? acc.push.apply(acc, sortable.content) : acc.push(sortable.content);
        return acc;
      }, []).concat(regularTabbables);
    };
    tabbable = function tabbable2(container, options) {
      options = options || {};
      var candidates;
      if (options.getShadowRoot) {
        candidates = getCandidatesIteratively([container], options.includeContainer, {
          filter: isNodeMatchingSelectorTabbable.bind(null, options),
          flatten: false,
          getShadowRoot: options.getShadowRoot,
          shadowRootFilter: isValidShadowRootTabbable
        });
      } else {
        candidates = getCandidates(container, options.includeContainer, isNodeMatchingSelectorTabbable.bind(null, options));
      }
      return sortByOrder(candidates);
    };
    focusableCandidateSelector = candidateSelectors.concat("iframe").join(",");
  }
});

// node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs
function clamp2(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === "function" ? value(param) : value;
}
function getSide(placement) {
  return placement.split("-")[0];
}
function getAlignment(placement) {
  return placement.split("-")[1];
}
function getOppositeAxis(axis) {
  return axis === "x" ? "y" : "x";
}
function getAxisLength(axis) {
  return axis === "y" ? "height" : "width";
}
function getSideAxis(placement) {
  return ["top", "bottom"].includes(getSide(placement)) ? "y" : "x";
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length2 = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === "x" ? alignment === (rtl ? "end" : "start") ? "right" : "left" : alignment === "start" ? "bottom" : "top";
  if (rects.reference[length2] > rects.floating[length2]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, (alignment) => oppositeAlignmentMap[alignment]);
}
function getSideList(side, isStart, rtl) {
  const lr = ["left", "right"];
  const rl = ["right", "left"];
  const tb = ["top", "bottom"];
  const bt = ["bottom", "top"];
  switch (side) {
    case "top":
    case "bottom":
      if (rtl)
        return isStart ? rl : lr;
      return isStart ? lr : rl;
    case "left":
    case "right":
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === "start", rtl);
  if (alignment) {
    list = list.map((side) => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, (side) => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== "number" ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y,
    left: x,
    right: x + width,
    bottom: y + height,
    x,
    y
  };
}
var sides, alignments, placements, min, max, round, floor, createCoords, oppositeSideMap, oppositeAlignmentMap;
var init_floating_ui_utils = __esm({
  "node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs"() {
    sides = ["top", "right", "bottom", "left"];
    alignments = ["start", "end"];
    placements = sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
    min = Math.min;
    max = Math.max;
    round = Math.round;
    floor = Math.floor;
    createCoords = (v) => ({
      x: v,
      y: v
    });
    oppositeSideMap = {
      left: "right",
      right: "left",
      bottom: "top",
      top: "bottom"
    };
    oppositeAlignmentMap = {
      start: "end",
      end: "start"
    };
  }
});

// node_modules/@floating-ui/core/dist/floating-ui.core.mjs
function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = getSideAxis(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const alignLength = getAxisLength(alignmentAxis);
  const side = getSide(placement);
  const isVertical = sideAxis === "y";
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case "top":
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case "bottom":
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case "right":
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case "left":
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case "start":
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case "end":
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform: platform2,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = "clippingAncestors",
    rootBoundary = "viewport",
    elementContext = "floating",
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getPaddingObject(padding);
  const altContext = elementContext === "floating" ? "reference" : "floating";
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform2.getClippingRect({
    element: ((_await$platform$isEle = await (platform2.isElement == null ? void 0 : platform2.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || await (platform2.getDocumentElement == null ? void 0 : platform2.getDocumentElement(elements.floating)),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === "floating" ? {
    x,
    y,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(elements.floating));
  const offsetScale = await (platform2.isElement == null ? void 0 : platform2.isElement(offsetParent)) ? await (platform2.getScale == null ? void 0 : platform2.getScale(offsetParent)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform2.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform2.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}
function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter((placement) => getAlignment(placement) === alignment), ...allowedPlacements.filter((placement) => getAlignment(placement) !== alignment)] : allowedPlacements.filter((placement) => getSide(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter((placement) => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some((side) => overflow[side] >= 0);
}
function getBoundingRect(rects) {
  const minX = min(...rects.map((rect) => rect.left));
  const minY = min(...rects.map((rect) => rect.top));
  const maxX = max(...rects.map((rect) => rect.right));
  const maxY = max(...rects.map((rect) => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map((rect) => rectToClientRect(getBoundingRect(rect)));
}
async function convertValueToCoords(state, options) {
  const {
    placement,
    platform: platform2,
    elements
  } = state;
  const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getSideAxis(placement) === "y";
  const mainAxisMulti = ["left", "top"].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === "number" ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === "number") {
    crossAxis = alignment === "end" ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}
var computePosition, arrow, autoPlacement, flip, hide, inline, offset, shift, limitShift, size;
var init_floating_ui_core = __esm({
  "node_modules/@floating-ui/core/dist/floating-ui.core.mjs"() {
    init_floating_ui_utils();
    init_floating_ui_utils();
    computePosition = async (reference, floating, config) => {
      const {
        placement = "bottom",
        strategy = "absolute",
        middleware = [],
        platform: platform2
      } = config;
      const validMiddleware = middleware.filter(Boolean);
      const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(floating));
      let rects = await platform2.getElementRects({
        reference,
        floating,
        strategy
      });
      let {
        x,
        y
      } = computeCoordsFromPlacement(rects, placement, rtl);
      let statefulPlacement = placement;
      let middlewareData = {};
      let resetCount = 0;
      for (let i = 0; i < validMiddleware.length; i++) {
        const {
          name,
          fn
        } = validMiddleware[i];
        const {
          x: nextX,
          y: nextY,
          data: data2,
          reset
        } = await fn({
          x,
          y,
          initialPlacement: placement,
          placement: statefulPlacement,
          strategy,
          middlewareData,
          rects,
          platform: platform2,
          elements: {
            reference,
            floating
          }
        });
        x = nextX != null ? nextX : x;
        y = nextY != null ? nextY : y;
        middlewareData = {
          ...middlewareData,
          [name]: {
            ...middlewareData[name],
            ...data2
          }
        };
        if (reset && resetCount <= 50) {
          resetCount++;
          if (typeof reset === "object") {
            if (reset.placement) {
              statefulPlacement = reset.placement;
            }
            if (reset.rects) {
              rects = reset.rects === true ? await platform2.getElementRects({
                reference,
                floating,
                strategy
              }) : reset.rects;
            }
            ({
              x,
              y
            } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
          }
          i = -1;
        }
      }
      return {
        x,
        y,
        placement: statefulPlacement,
        strategy,
        middlewareData
      };
    };
    arrow = (options) => ({
      name: "arrow",
      options,
      async fn(state) {
        const {
          x,
          y,
          placement,
          rects,
          platform: platform2,
          elements,
          middlewareData
        } = state;
        const {
          element,
          padding = 0
        } = evaluate(options, state) || {};
        if (element == null) {
          return {};
        }
        const paddingObject = getPaddingObject(padding);
        const coords = {
          x,
          y
        };
        const axis = getAlignmentAxis(placement);
        const length2 = getAxisLength(axis);
        const arrowDimensions = await platform2.getDimensions(element);
        const isYAxis = axis === "y";
        const minProp = isYAxis ? "top" : "left";
        const maxProp = isYAxis ? "bottom" : "right";
        const clientProp = isYAxis ? "clientHeight" : "clientWidth";
        const endDiff = rects.reference[length2] + rects.reference[axis] - coords[axis] - rects.floating[length2];
        const startDiff = coords[axis] - rects.reference[axis];
        const arrowOffsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(element));
        let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;
        if (!clientSize || !await (platform2.isElement == null ? void 0 : platform2.isElement(arrowOffsetParent))) {
          clientSize = elements.floating[clientProp] || rects.floating[length2];
        }
        const centerToReference = endDiff / 2 - startDiff / 2;
        const largestPossiblePadding = clientSize / 2 - arrowDimensions[length2] / 2 - 1;
        const minPadding = min(paddingObject[minProp], largestPossiblePadding);
        const maxPadding = min(paddingObject[maxProp], largestPossiblePadding);
        const min$1 = minPadding;
        const max2 = clientSize - arrowDimensions[length2] - maxPadding;
        const center = clientSize / 2 - arrowDimensions[length2] / 2 + centerToReference;
        const offset3 = clamp2(min$1, center, max2);
        const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center !== offset3 && rects.reference[length2] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length2] / 2 < 0;
        const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max2 : 0;
        return {
          [axis]: coords[axis] + alignmentOffset,
          data: {
            [axis]: offset3,
            centerOffset: center - offset3 - alignmentOffset,
            ...shouldAddOffset && {
              alignmentOffset
            }
          },
          reset: shouldAddOffset
        };
      }
    });
    autoPlacement = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "autoPlacement",
        options,
        async fn(state) {
          var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
          const {
            rects,
            middlewareData,
            placement,
            platform: platform2,
            elements
          } = state;
          const {
            crossAxis = false,
            alignment,
            allowedPlacements = placements,
            autoAlignment = true,
            ...detectOverflowOptions
          } = evaluate(options, state);
          const placements$1 = alignment !== void 0 || allowedPlacements === placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
          const overflow = await detectOverflow(state, detectOverflowOptions);
          const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
          const currentPlacement = placements$1[currentIndex];
          if (currentPlacement == null) {
            return {};
          }
          const alignmentSides = getAlignmentSides(currentPlacement, rects, await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating)));
          if (placement !== currentPlacement) {
            return {
              reset: {
                placement: placements$1[0]
              }
            };
          }
          const currentOverflows = [overflow[getSide(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
          const allOverflows = [...((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || [], {
            placement: currentPlacement,
            overflows: currentOverflows
          }];
          const nextPlacement = placements$1[currentIndex + 1];
          if (nextPlacement) {
            return {
              data: {
                index: currentIndex + 1,
                overflows: allOverflows
              },
              reset: {
                placement: nextPlacement
              }
            };
          }
          const placementsSortedByMostSpace = allOverflows.map((d) => {
            const alignment2 = getAlignment(d.placement);
            return [d.placement, alignment2 && crossAxis ? (
              // Check along the mainAxis and main crossAxis side.
              d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0)
            ) : (
              // Check only the mainAxis.
              d.overflows[0]
            ), d.overflows];
          }).sort((a, b) => a[1] - b[1]);
          const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter((d) => d[2].slice(
            0,
            // Aligned placements should not check their opposite crossAxis
            // side.
            getAlignment(d[0]) ? 2 : 3
          ).every((v) => v <= 0));
          const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
          if (resetPlacement !== placement) {
            return {
              data: {
                index: currentIndex + 1,
                overflows: allOverflows
              },
              reset: {
                placement: resetPlacement
              }
            };
          }
          return {};
        }
      };
    };
    flip = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "flip",
        options,
        async fn(state) {
          var _middlewareData$arrow, _middlewareData$flip;
          const {
            placement,
            middlewareData,
            rects,
            initialPlacement,
            platform: platform2,
            elements
          } = state;
          const {
            mainAxis: checkMainAxis = true,
            crossAxis: checkCrossAxis = true,
            fallbackPlacements: specifiedFallbackPlacements,
            fallbackStrategy = "bestFit",
            fallbackAxisSideDirection = "none",
            flipAlignment = true,
            ...detectOverflowOptions
          } = evaluate(options, state);
          if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
            return {};
          }
          const side = getSide(placement);
          const initialSideAxis = getSideAxis(initialPlacement);
          const isBasePlacement = getSide(initialPlacement) === initialPlacement;
          const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
          const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
          const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== "none";
          if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
            fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
          }
          const placements2 = [initialPlacement, ...fallbackPlacements];
          const overflow = await detectOverflow(state, detectOverflowOptions);
          const overflows = [];
          let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
          if (checkMainAxis) {
            overflows.push(overflow[side]);
          }
          if (checkCrossAxis) {
            const sides2 = getAlignmentSides(placement, rects, rtl);
            overflows.push(overflow[sides2[0]], overflow[sides2[1]]);
          }
          overflowsData = [...overflowsData, {
            placement,
            overflows
          }];
          if (!overflows.every((side2) => side2 <= 0)) {
            var _middlewareData$flip2, _overflowsData$filter;
            const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
            const nextPlacement = placements2[nextIndex];
            if (nextPlacement) {
              return {
                data: {
                  index: nextIndex,
                  overflows: overflowsData
                },
                reset: {
                  placement: nextPlacement
                }
              };
            }
            let resetPlacement = (_overflowsData$filter = overflowsData.filter((d) => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;
            if (!resetPlacement) {
              switch (fallbackStrategy) {
                case "bestFit": {
                  var _overflowsData$filter2;
                  const placement2 = (_overflowsData$filter2 = overflowsData.filter((d) => {
                    if (hasFallbackAxisSideDirection) {
                      const currentSideAxis = getSideAxis(d.placement);
                      return currentSideAxis === initialSideAxis || // Create a bias to the `y` side axis due to horizontal
                      // reading directions favoring greater width.
                      currentSideAxis === "y";
                    }
                    return true;
                  }).map((d) => [d.placement, d.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
                  if (placement2) {
                    resetPlacement = placement2;
                  }
                  break;
                }
                case "initialPlacement":
                  resetPlacement = initialPlacement;
                  break;
              }
            }
            if (placement !== resetPlacement) {
              return {
                reset: {
                  placement: resetPlacement
                }
              };
            }
          }
          return {};
        }
      };
    };
    hide = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "hide",
        options,
        async fn(state) {
          const {
            rects
          } = state;
          const {
            strategy = "referenceHidden",
            ...detectOverflowOptions
          } = evaluate(options, state);
          switch (strategy) {
            case "referenceHidden": {
              const overflow = await detectOverflow(state, {
                ...detectOverflowOptions,
                elementContext: "reference"
              });
              const offsets = getSideOffsets(overflow, rects.reference);
              return {
                data: {
                  referenceHiddenOffsets: offsets,
                  referenceHidden: isAnySideFullyClipped(offsets)
                }
              };
            }
            case "escaped": {
              const overflow = await detectOverflow(state, {
                ...detectOverflowOptions,
                altBoundary: true
              });
              const offsets = getSideOffsets(overflow, rects.floating);
              return {
                data: {
                  escapedOffsets: offsets,
                  escaped: isAnySideFullyClipped(offsets)
                }
              };
            }
            default: {
              return {};
            }
          }
        }
      };
    };
    inline = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "inline",
        options,
        async fn(state) {
          const {
            placement,
            elements,
            rects,
            platform: platform2,
            strategy
          } = state;
          const {
            padding = 2,
            x,
            y
          } = evaluate(options, state);
          const nativeClientRects = Array.from(await (platform2.getClientRects == null ? void 0 : platform2.getClientRects(elements.reference)) || []);
          const clientRects = getRectsByLine(nativeClientRects);
          const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
          const paddingObject = getPaddingObject(padding);
          function getBoundingClientRect2() {
            if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
              return clientRects.find((rect) => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
            }
            if (clientRects.length >= 2) {
              if (getSideAxis(placement) === "y") {
                const firstRect = clientRects[0];
                const lastRect = clientRects[clientRects.length - 1];
                const isTop = getSide(placement) === "top";
                const top2 = firstRect.top;
                const bottom2 = lastRect.bottom;
                const left2 = isTop ? firstRect.left : lastRect.left;
                const right2 = isTop ? firstRect.right : lastRect.right;
                const width2 = right2 - left2;
                const height2 = bottom2 - top2;
                return {
                  top: top2,
                  bottom: bottom2,
                  left: left2,
                  right: right2,
                  width: width2,
                  height: height2,
                  x: left2,
                  y: top2
                };
              }
              const isLeftSide = getSide(placement) === "left";
              const maxRight = max(...clientRects.map((rect) => rect.right));
              const minLeft = min(...clientRects.map((rect) => rect.left));
              const measureRects = clientRects.filter((rect) => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
              const top = measureRects[0].top;
              const bottom = measureRects[measureRects.length - 1].bottom;
              const left = minLeft;
              const right = maxRight;
              const width = right - left;
              const height = bottom - top;
              return {
                top,
                bottom,
                left,
                right,
                width,
                height,
                x: left,
                y: top
              };
            }
            return fallback;
          }
          const resetRects = await platform2.getElementRects({
            reference: {
              getBoundingClientRect: getBoundingClientRect2
            },
            floating: elements.floating,
            strategy
          });
          if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
            return {
              reset: {
                rects: resetRects
              }
            };
          }
          return {};
        }
      };
    };
    offset = function(options) {
      if (options === void 0) {
        options = 0;
      }
      return {
        name: "offset",
        options,
        async fn(state) {
          var _middlewareData$offse, _middlewareData$arrow;
          const {
            x,
            y,
            placement,
            middlewareData
          } = state;
          const diffCoords = await convertValueToCoords(state, options);
          if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
            return {};
          }
          return {
            x: x + diffCoords.x,
            y: y + diffCoords.y,
            data: {
              ...diffCoords,
              placement
            }
          };
        }
      };
    };
    shift = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "shift",
        options,
        async fn(state) {
          const {
            x,
            y,
            placement
          } = state;
          const {
            mainAxis: checkMainAxis = true,
            crossAxis: checkCrossAxis = false,
            limiter = {
              fn: (_ref) => {
                let {
                  x: x2,
                  y: y2
                } = _ref;
                return {
                  x: x2,
                  y: y2
                };
              }
            },
            ...detectOverflowOptions
          } = evaluate(options, state);
          const coords = {
            x,
            y
          };
          const overflow = await detectOverflow(state, detectOverflowOptions);
          const crossAxis = getSideAxis(getSide(placement));
          const mainAxis = getOppositeAxis(crossAxis);
          let mainAxisCoord = coords[mainAxis];
          let crossAxisCoord = coords[crossAxis];
          if (checkMainAxis) {
            const minSide = mainAxis === "y" ? "top" : "left";
            const maxSide = mainAxis === "y" ? "bottom" : "right";
            const min2 = mainAxisCoord + overflow[minSide];
            const max2 = mainAxisCoord - overflow[maxSide];
            mainAxisCoord = clamp2(min2, mainAxisCoord, max2);
          }
          if (checkCrossAxis) {
            const minSide = crossAxis === "y" ? "top" : "left";
            const maxSide = crossAxis === "y" ? "bottom" : "right";
            const min2 = crossAxisCoord + overflow[minSide];
            const max2 = crossAxisCoord - overflow[maxSide];
            crossAxisCoord = clamp2(min2, crossAxisCoord, max2);
          }
          const limitedCoords = limiter.fn({
            ...state,
            [mainAxis]: mainAxisCoord,
            [crossAxis]: crossAxisCoord
          });
          return {
            ...limitedCoords,
            data: {
              x: limitedCoords.x - x,
              y: limitedCoords.y - y
            }
          };
        }
      };
    };
    limitShift = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        options,
        fn(state) {
          const {
            x,
            y,
            placement,
            rects,
            middlewareData
          } = state;
          const {
            offset: offset3 = 0,
            mainAxis: checkMainAxis = true,
            crossAxis: checkCrossAxis = true
          } = evaluate(options, state);
          const coords = {
            x,
            y
          };
          const crossAxis = getSideAxis(placement);
          const mainAxis = getOppositeAxis(crossAxis);
          let mainAxisCoord = coords[mainAxis];
          let crossAxisCoord = coords[crossAxis];
          const rawOffset = evaluate(offset3, state);
          const computedOffset = typeof rawOffset === "number" ? {
            mainAxis: rawOffset,
            crossAxis: 0
          } : {
            mainAxis: 0,
            crossAxis: 0,
            ...rawOffset
          };
          if (checkMainAxis) {
            const len = mainAxis === "y" ? "height" : "width";
            const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
            const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
            if (mainAxisCoord < limitMin) {
              mainAxisCoord = limitMin;
            } else if (mainAxisCoord > limitMax) {
              mainAxisCoord = limitMax;
            }
          }
          if (checkCrossAxis) {
            var _middlewareData$offse, _middlewareData$offse2;
            const len = mainAxis === "y" ? "width" : "height";
            const isOriginSide = ["top", "left"].includes(getSide(placement));
            const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
            const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
            if (crossAxisCoord < limitMin) {
              crossAxisCoord = limitMin;
            } else if (crossAxisCoord > limitMax) {
              crossAxisCoord = limitMax;
            }
          }
          return {
            [mainAxis]: mainAxisCoord,
            [crossAxis]: crossAxisCoord
          };
        }
      };
    };
    size = function(options) {
      if (options === void 0) {
        options = {};
      }
      return {
        name: "size",
        options,
        async fn(state) {
          const {
            placement,
            rects,
            platform: platform2,
            elements
          } = state;
          const {
            apply = () => {
            },
            ...detectOverflowOptions
          } = evaluate(options, state);
          const overflow = await detectOverflow(state, detectOverflowOptions);
          const side = getSide(placement);
          const alignment = getAlignment(placement);
          const isYAxis = getSideAxis(placement) === "y";
          const {
            width,
            height
          } = rects.floating;
          let heightSide;
          let widthSide;
          if (side === "top" || side === "bottom") {
            heightSide = side;
            widthSide = alignment === (await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating)) ? "start" : "end") ? "left" : "right";
          } else {
            widthSide = side;
            heightSide = alignment === "end" ? "top" : "bottom";
          }
          const maximumClippingHeight = height - overflow.top - overflow.bottom;
          const maximumClippingWidth = width - overflow.left - overflow.right;
          const overflowAvailableHeight = min(height - overflow[heightSide], maximumClippingHeight);
          const overflowAvailableWidth = min(width - overflow[widthSide], maximumClippingWidth);
          const noShift = !state.middlewareData.shift;
          let availableHeight = overflowAvailableHeight;
          let availableWidth = overflowAvailableWidth;
          if (isYAxis) {
            availableWidth = alignment || noShift ? min(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
          } else {
            availableHeight = alignment || noShift ? min(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
          }
          if (noShift && !alignment) {
            const xMin = max(overflow.left, 0);
            const xMax = max(overflow.right, 0);
            const yMin = max(overflow.top, 0);
            const yMax = max(overflow.bottom, 0);
            if (isYAxis) {
              availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
            } else {
              availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
            }
          }
          await apply({
            ...state,
            availableWidth,
            availableHeight
          });
          const nextDimensions = await platform2.getDimensions(elements.floating);
          if (width !== nextDimensions.width || height !== nextDimensions.height) {
            return {
              reset: {
                rects: true
              }
            };
          }
          return {};
        }
      };
    };
  }
});

// node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || "").toLowerCase();
  }
  return "#document";
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (typeof ShadowRoot === "undefined") {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle2(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !["inline", "contents"].includes(display);
}
function isTableElement(element) {
  return ["table", "td", "th"].includes(getNodeName(element));
}
function isTopLayer(element) {
  return [":popover-open", ":modal"].some((selector) => {
    try {
      return element.matches(selector);
    } catch (e) {
      return false;
    }
  });
}
function isContainingBlock(element) {
  const webkit = isWebKit();
  const css = getComputedStyle2(element);
  return css.transform !== "none" || css.perspective !== "none" || (css.containerType ? css.containerType !== "normal" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== "none" : false) || !webkit && (css.filter ? css.filter !== "none" : false) || ["transform", "perspective", "filter"].some((value) => (css.willChange || "").includes(value)) || ["paint", "layout", "strict", "content"].some((value) => (css.contain || "").includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isTopLayer(currentNode)) {
      return null;
    }
    if (isContainingBlock(currentNode)) {
      return currentNode;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === "undefined" || !CSS.supports)
    return false;
  return CSS.supports("-webkit-backdrop-filter", "none");
}
function isLastTraversableNode(node) {
  return ["html", "body", "#document"].includes(getNodeName(node));
}
function getComputedStyle2(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === "html") {
    return node;
  }
  const result = (
    // Step into the shadow DOM of the parent of a slotted node.
    node.assignedSlot || // DOM Element detected.
    node.parentNode || // ShadowRoot detected.
    isShadowRoot(node) && node.host || // Fallback.
    getDocumentElement(node)
  );
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], win.frameElement && traverseIframes ? getOverflowAncestors(win.frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
var init_floating_ui_utils_dom = __esm({
  "node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs"() {
  }
});

// node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs
function getCssDimensions(element) {
  const css = getComputedStyle2(element);
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldF